% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/clusterwild.R
\name{cluster.wild}
\alias{cluster.wild}
\title{Wild Cluster Bootstrapped p-Values for Linear Family GLM}
\usage{
cluster.wild(mod, dat, cluster, boot.reps = 1000, report = TRUE,
  prog.bar = TRUE)
}
\arguments{
\item{mod}{A linear (identity link) model estimated using \code{glm}.}

\item{dat}{The data set used to estimate \code{mod}.}

\item{cluster}{A formula of the clustering variable.}

\item{boot.reps}{The number of bootstrap samples to draw.}

\item{report}{Should a table of results be printed to the console?}

\item{prog.bar}{Show a progress bar of the bootstrap (= TRUE) or not (= FALSE).}
}
\value{
A list with the elements
\item{p.values}{A matrix of the estimated p-values.}
}
\description{
This software estimates p-values using wild cluster bootstrapped t-statistics for linear family GLM models (Cameron, Gelbach, and Miller 2008). Residuals are repeatedly re-sampled by cluster to form a pseudo-dependent variable, a model is estimated for each re-sampled data set, and inference is based on the sampling distribution of the pivotal (t) statistic.
}
\note{
Code to estimate GLM clustered standard errors by Mahmood Ara: http://thetarzan.wordpress.com/2011/06/11/clustered-standard-errors-in-r/.
}
\examples{
\dontrun{
# predict prestige score of occupation
require(effects)
data(BEPS)
linear.model <- glm(Europe ~ age + gender + economic.cond.national, data=BEPS)
summary(linear.model)

# compute wild cluster bootstrapped p-values
clust.wd.p <- cluster.wild(linear.model, BEPS, ~ vote, report = T)
}
}
\author{
Justin Esarey
}
\references{
Cameron, A. Colin, Jonah B. Gelbach, and Douglas L. Miller. 2008. "Bootstrap-Based Improvements for Inference with Clustered Errors." \emph{The Review of Economics and Statistics} 90(3): 414-427.
}

