% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_transfer_bulk.R
\name{cloud_s3_read_bulk}
\alias{cloud_s3_read_bulk}
\title{Bulk Read Contents from S3}
\usage{
cloud_s3_read_bulk(content, fun = NULL, ..., quiet = FALSE, root = NULL)
}
\arguments{
\item{content}{(data.frame) Output of \code{cloud_s3_ls()}}

\item{fun}{A custom reading function. If \code{NULL} (default), the appropriate
reading function will be inferred based on the file's extension.}

\item{...}{Additional arguments to pass to the reading function \code{fun}.}

\item{quiet}{All caution messages may be turned off by setting this parameter
to \code{TRUE}.}

\item{root}{S3 path of the project root. This serves as the reference point
for all relative paths. When left as \code{NULL}, the root is automatically
derived from the \code{cloudfs.s3} field of the project's DESCRIPTION file.}
}
\value{
A named list where each element corresponds to the content of a file
from S3. The names of the list elements are derived from the file names.
}
\description{
This function facilitates the bulk reading of multiple files
from the project's designated S3 folder. By using \link{cloud_s3_ls}, you can
obtain a dataframe detailing the contents of the S3 folder. Applying
\code{cloud_s3_read_bulk} to this dataframe allows you to read all listed files
into a named list. The function will, by default, infer the appropriate
reading method based on each file's extension. However, if a specific
reading function is provided via the \code{fun} parameter, it will be applied
uniformly to all files, which may not be suitable for diverse file types.
}
\examples{
\dontshow{if (interactive() ) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# provided there's a folder called "data" in the root of the project's main
# S3 folder, and it contains csv files
data_lst <- 
  cloud_s3_ls("data") |>  
  filter(type == "csv")  |>  
  cloud_s3_read_bulk()
  
\dontshow{\}) # examplesIf}
}
