% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drive_show.R
\name{cloud_drive_ls}
\alias{cloud_drive_ls}
\title{List Contents of Project's Google Drive Folder}
\usage{
cloud_drive_ls(path = "", recursive = FALSE, full_names = FALSE, root = NULL)
}
\arguments{
\item{path}{(optional) Path inside the Google Drive root folder. Specifies
the subfolder whose contents should be listed. By default, when \code{path = ""}, lists root-level files and folders.}

\item{recursive}{(logical) If \code{TRUE}, lists contents recursively in all
nested subfolders. Default is \code{FALSE}.}

\item{full_names}{(logical) If \code{TRUE}, folder path is appended to object
names to give a relative file path.}

\item{root}{Google Drive ID or URL of the project root. This serves as the
reference point for all relative paths. When left as \code{NULL}, the root is
automatically derived from the \code{cloudfs.drive} field of the project's
DESCRIPTION file.}
}
\value{
A tibble containing the names, last modification timestamps, sizes in
bytes, and Google Drive IDs of files and folders inside the specified
Google Drive folder.
}
\description{
Returns a tibble with names, timestamps, and sizes of files and
folders inside the specified Google Drive folder.
}
\details{
Google Drive file structure is different from the usual file
structure like e.g. on Linux or Windows. A folder on Google Drive can have
two or more child folders with the same name. Google Drive marks files and
folders with so-called id values to distinguish between them. These values
are always unique. You can see them in browser URL for example. The concept
of "name" is in the first place for convenience of the end user.

In such a setup a relative file path may correspond to multiple files or
folders. This function however works under assumption that the relative
path you pass to it defines strictly one object. If there's any ambiguity
it throws an error.
}
\examples{
\dontshow{if (interactive() ) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# list only root-level files and folders
cloud_drive_ls() 

# list all files in all nested folders
cloud_drive_ls(recursive = TRUE)

# list contents of "plots/barplots" subfolder
cloud_drive_ls("plots/barplots")
\dontshow{\}) # examplesIf}
}
