/*
 * Decompiled with CFR 0.152.
 */
package ppe.gui;

import javax.swing.table.AbstractTableModel;
import ppe.ExceptionHandler;
import ppe.StateChangeListener;
import ppe.UtilPPE;
import ppe.ec2.InstanceStatus;
import ppe.ec2.InstanceTag;
import ppe.ec2.NetworkInfo;
import ppe.ec2.NiM;

public class InstanceTableModel
extends AbstractTableModel
implements StateChangeListener {
    public String networkID;
    public String networkName;

    public InstanceTableModel(NetworkInfo ni) {
        this.networkName = ni.getNetworkName();
        this.networkID = ni.getNetworkID();
    }

    @Override
    public int getRowCount() {
        NetworkInfo ni = this.getNetwork();
        if (ni == null) {
            return 0;
        }
        return ni.instances.size();
    }

    @Override
    public int getColumnCount() {
        return ItColumn.values().length;
    }

    @Override
    public String getColumnName(int column) {
        return ItColumn.values()[column].nm;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        NetworkInfo ni = this.getNetwork();
        if (ni == null) {
            return "null";
        }
        InstanceStatus s = ni.instances.get(rowIndex);
        if (s == null) {
            return "null";
        }
        ItColumn col = ItColumn.values()[columnIndex];
        switch (col) {
            case publicDns: {
                return s.getPublicDnsName();
            }
            case status: {
                try {
                    return ni.getStateDescription();
                }
                catch (Exception xxx) {
                    ExceptionHandler.text(xxx);
                    return "-";
                }
            }
            case nodeType: {
                return s.getTagValue(InstanceTag.nodeType);
            }
            case launchTime: {
                long tm = s.instance.getLaunchTime().getTime();
                if (tm < Long.MAX_VALUE) {
                    return UtilPPE.toDateTimeString(tm);
                }
                return "null";
            }
            case instanceType: {
                return s.instance.getInstanceType();
            }
            case ami: {
                return s.instance.getImageId();
            }
            case virualizationType: {
                return s.instance.getVirtualizationType();
            }
        }
        return "Undefined column: " + (col != null ? col.toString() : "null");
    }

    @Override
    public void stateChanged() {
        this.fireTableDataChanged();
    }

    private NetworkInfo getNetwork() {
        return NiM.getForID(this.networkID);
    }

    private static enum ItColumn {
        publicDns("Public DNS"),
        status("Status"),
        nodeType("Node type"),
        launchTime("Launch time"),
        instanceType("Instance type"),
        ami("ami"),
        virualizationType("Virtualization");

        String nm;

        private ItColumn(String nm) {
            this.nm = nm;
        }
    }
}

