% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autowin.R
\name{autowin}
\alias{autowin}
\title{Test for auto-correlation in climate.}
\usage{
autowin(reference, xvar, cdate, bdate, baseline, range, stat, func, type,
  refday, cmissing = FALSE, cinterval = "day", upper = NA, lower = NA,
  binary = FALSE, centre = list(NULL, "both"), cohort = NULL,
  spatial = NULL, cutoff.day = NULL, cutoff.month = NULL,
  furthest = NULL, closest = NULL, thresh = NULL)
}
\arguments{
\item{reference}{Reference climate data to be compared. Generated by functions
\code{\link{singlewin}} or \code{\link{slidingwin}}.}

\item{xvar}{The climate variable of interest. Please specify the parent 
environment and variable name (e.g. Climate$Temp).}

\item{cdate}{The climate date variable (dd/mm/yyyy). Please specify the parent
environment and variable name (e.g. Climate$Date).}

\item{bdate}{The biological date variable (dd/mm/yyyy). Please specify the 
parent environment and variable name (e.g. Biol$Date).}

\item{baseline}{The baseline model used to fit climate windows. These will be
correlated with the reference climate window.}

\item{range}{Two values signifying respectively the furthest and closest number 
of time intervals (set by cinterval) back from the cutoff date or biological record to include 
in the climate window search.}

\item{stat}{The aggregate statistic used to analyse the climate data. Can 
currently use basic R statistics (e.g. mean, min), as well as slope. 
Additional aggregate statistics can be created using the format function(x) 
(...). See parameter FUN in \code{\link{apply}} for more detail.}

\item{func}{The function used to fit the climate variable. Can be linear 
("lin"), quadratic ("quad"), cubic ("cub"), inverse ("inv") or log ("log").
Not required when a variable is provided for parameter 'centre'.}

\item{type}{"absolute" or "relative", whether you wish the climate window to be relative
(e.g. the number of days before each biological record is measured) or absolute
(e.g. number of days before a set point in time).}

\item{refday}{If type is "absolute", the day and month respectively of the 
year from which the absolute window analysis will start.}

\item{cmissing}{cmissing Determines what should be done if there are 
missing climate data. Three approaches are possible:
 - FALSE; the function will not run if missing climate data is encountered.
 An object 'missing' will be returned containing the dates of missing climate.
 - "method1"; missing climate data will be replaced with the mean climate
 of the preceding and following 2 days.
 - "method2"; missing climate data will be replaced with the mean climate
 of all records on the same date.}

\item{cinterval}{The resolution at which climate window analysis will be 
conducted. May be days ("day"), weeks ("week"), or months ("month"). Note the units 
of parameter 'range' will differ with the choice of cinterval.}

\item{upper}{Cut-off value used to determine growing degree days or positive 
climate thresholds (depending on parameter thresh). Note that when values
of lower and upper are both provided, autowin will instead calculate an 
optimal climate zone.}

\item{lower}{Cut-off value used to determine chill days or negative 
climate thresholds (determined by parameter thresh). Note that when values
of lower and upper are both provided, autowin will instead calculate an 
optimal climate zone.}

\item{binary}{TRUE or FALSE. Determines whether to use values of upper and
lower to calculate binary climate data (binary = TRUE), or to use for
growing degree days (binary = FALSE).}

\item{centre}{A list item containing:
1. The variable used for mean centring (e.g. Year, Site, Individual). 
Please specify the parent environment and variable name (e.g. Biol$Year).
2. Whether the model should include both within-group means and variance ("both"),
only within-group means ("mean"), or only within-group variance ("dev").}

\item{cohort}{A variable used to group biological records that occur in the same biological
season but cover multiple years (e.g. southern hemisphere breeding season). By default,
autowin will use year (extracted from parameter bdate) as the cohort variable. 
The cohort variable should be in the same dataset as the variable bdate.}

\item{spatial}{A list item containing:
1. A factor that defines which spatial group (i.e. population) each biological
record is taken from. The length of this factor should correspond to the length 
of the biological dataset.
2. A factor that defines which spatial group (i.e. population) climate data
corresponds to. The length of this factor should correspond to the length of
the climate dataset.}

\item{cutoff.day, cutoff.month}{Redundant parameters. Now replaced by refday.}

\item{furthest, closest}{Redundant parameters. Now replaced by range.}

\item{thresh}{Redundant parameter. Now replaced by binary.}
}
\value{
Will return a data frame showing the correlation between the climate 
 in each fitted window and the chosen reference window.
}
\description{
Tests the correlation between the climate in a specified climate window and 
other fitted climate windows.
}
\examples{
\dontrun{

# Test for auto-correlation using 'Mass' and 'MassClimate' data frames

data(Mass)
data(MassClimate)

# Fit a single climate window using the datasets Mass and MassClimate.

single <- singlewin(xvar = list(Temp = MassClimate$Temp), 
                    cdate = MassClimate$Date, bdate = Mass$Date,
                    baseline = lm(Mass ~ 1, data = Mass), 
                    range = c(72, 15), 
                    stat = "mean", func = "lin", type = "absolute", 
                    refday = c(20, 5), 
                    cmissing = FALSE, cinterval = "day")            

# Test the autocorrelation between the climate in this single window and other climate windows.

auto <- autowin(reference = single,
                xvar  = list(Temp = MassClimate$Temp), cdate = MassClimate$Date, bdate = Mass$Date,
                baseline = lm(Mass ~ 1, data = Mass), range = c(365, 0), 
                stat = "mean", func = "lin", 
                type = "absolute", refday = c(20, 5),
                cmissing = FALSE, cinterval = "day")
                
# View the output
head(auto)

# Plot the output
plotcor(auto, type = "A")                                   
}
       
}
\author{
Liam D. Bailey and Martijn van de Pol
}

