% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deviationThroughTime.R
\name{deviationThroughTime}
\alias{deviationThroughTime}
\title{Calculating Deviation Through Time}
\usage{
deviationThroughTime(variableDirectory, timeSlicePeriod)
}
\arguments{
\item{variableDirectory}{A directory containing at least two time slice rasters for a given climate variable.}

\item{timeSlicePeriod}{Either a single number, in years, representing the time period elapsed between temporally-even climate variable raster slices, or a vector corresponding to periods, in years, between temporally-uneven time slices.}
}
\value{
A raster showing the geographic distribution of climate deviation through time for a particular climate variable.
}
\description{
A function that reads time-slice rasters of data for a given climate (typically processed data from a climate model run, such as the results of an analysis using PaleoView (Fordham, *et al.* 2017, Ecography)) in a given directory and calculates average deviation per year across time slices.
}
\details{
Make sure that files in the `variableDirectory` are read into `R` in order.

If you are specifying temporally-uneven time slices with `timeSlicePeriod`, make sure that each number corresponds to the number of years elapsed *between* time slices, *in the same order as the files were read into `R`*. There should be one less number than the number of files.
}
\examples{
\donttest{
#Even time slices
precipDeviation <- deviationThroughTime("precipfiles/", 1000);

#Uneven time slices
precipDeviationUneven <- deviationThroughTime("unevenPrecipFiles",
                                              c(1000, 1000, 1000, 1000, 5000, 5000, 6000))
}

}
\references{
Owens, HL, and RP Guralnick. Submitted, Biodiversity Informatics.
}
\seealso{
\code{\link{precipDeviation}} and \code{\link{temperatureDeviation}} for examples of data produced using this function.
}
\keyword{manip}
