% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descriptive.R
\name{unforge}
\alias{unforge}
\title{Un-Forge}
\usage{
unforge(data, origin, variables, prefix = origin)
}
\arguments{
\item{data}{data.frame}

\item{origin}{Character vector with variable names in data containing the values to be assigned to the different new variables}

\item{variables}{Variable in data containing the variable names to be created}

\item{prefix}{Vector with prefixes for the new variable names}
}
\description{
Reshapes a data frame from long to wide format
}
\examples{
#Data frame in wide format
df1 <- data.frame(id = 1:4, age = c(20, 30, 30, 35), score1 = c(2,2,3,4),
                  score2 = c(2,1,3,1), score3 = c(1,1,0,1))
df1
#Data frame in long format
df2 <- forge(df1, affixes= c("1", "2", "3"))
df2
#Data frame in wide format again
df3 <- unforge(df2, "score", "time", prefix="score")

}
