% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures_clusterings.R
\name{mutual_info}
\alias{mutual_info}
\title{Mutual Information Between Clusterings}
\usage{
mutual_info(true, pred, base = exp(1))
}
\arguments{
\item{true}{ground truth clustering represented as a membership
vector. Each entry corresponds to an element and the value identifies
the assigned cluster. The specific values of the cluster identifiers
are arbitrary.}

\item{pred}{predicted clustering represented as a membership
vector.}

\item{base}{base of the logarithm. Defaults to \code{exp(1)}.}
}
\description{
Computes the mutual information between two
clusterings, such as a predicted and ground truth clustering.
}
\details{
Mutual information is an entropy-based measure of the similarity
between two clusterings.
}
\examples{
true <- c(1,1,1,2,2)  # ground truth clustering
pred <- c(1,1,2,2,2)  # predicted clustering
mutual_info(true, pred)

}
