% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organization_show.R
\name{organization_show}
\alias{organization_show}
\title{Show an organization}
\usage{
organization_show(
  id,
  include_datasets = FALSE,
  url = get_default_url(),
  key = get_default_key(),
  as = "list",
  ...
)
}
\arguments{
\item{id}{(character) Organization id or name.}

\item{include_datasets}{(logical). Whether to include a list of the
organization datasets}

\item{url}{Base url to use. Default: \url{http://data.techno-science.ca}. See
also \code{\link{ckanr_setup}} and \code{\link{get_default_url}}.}

\item{key}{A privileged CKAN API key, Default: your key set with \code{\link{ckanr_setup}}}

\item{as}{(character) One of list (default), table, or json. Parsing with table option
uses \code{jsonlite::fromJSON(..., simplifyDataFrame = TRUE)}, which attempts to parse
data to data.frame's when possible, so the result can vary from a vector, list or
data.frame. (required)}

\item{...}{Curl args passed on to \code{\link[crul]{verb-POST}} (optional)}
}
\description{
Show an organization
}
\details{
By default the help and success slots are dropped, and only the
result slot is returned. You can request raw json with \code{as = 'json'}
then parse yourself to get the help slot.
}
\examples{
\dontrun{
ckanr_setup(url = "https://demo.ckan.org/", key = getOption("ckan_demo_key"))

res <- organization_create("stuffthings2")
organization_show(res$id)
}
}
