#' Delete a related item.
#'
#' @export
#'
#' @param id (character) Resource identifier.
#' @param url Base url to use. Default: http://data.techno-science.ca See
#' also [ckanr_setup()] and [get_default_url()].
#' @param ... Curl args passed on to [crul::verb-POST] (optional)
#' @template key
#' @examples \dontrun{
#' # Setup
#' ckanr_setup(url = "https://demo.ckan.org/", key = getOption("ckan_demo_key"))
#'
#' # create a package and a related item
#' res <- package_create("hello-venus2") %>%
#'    related_create(title = "my resource",
#'                   type = "visualization")
#'
#' # show the related item
#' related_delete(res)
#' ## or with id itself:
#' ## related_delete(res$id)
#' }
related_delete <- function(id, url = get_default_url(),
  key = get_default_key(), ...) {

  id <- as.ckan_related(id, url = url)
  tmp <- ckan_POST(url, 'related_delete', body = list(id = id$id),
    key = key, opts = list(...))
  jsonlite::fromJSON(tmp)$success
}
