% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{credentials_post_authenticate}
\alias{credentials_post_authenticate}
\title{Authenticate against a remote host}
\usage{
credentials_post_authenticate(url, remote_host_type, username, password)
}
\arguments{
\item{url}{string required. The URL to your host.}

\item{remote_host_type}{string required. The type of remote host. One of: RemoteHostTypes::BSD, RemoteHostTypes::Ftp, RemoteHostTypes::Github, RemoteHostTypes::GoogleDoc, RemoteHostTypes::JDBC, RemoteHostTypes::Redshift, RemoteHostTypes::Salesforce, and RemoteHostTypes::Van}

\item{username}{string required. The username for the credential.}

\item{password}{string required. The password for the credential.}
}
\value{
A list containing the following elements:
\item{id}{integer, The ID of the credential.}
\item{name}{string, The name identifying the credential}
\item{type}{string, The credential's type.}
\item{username}{string, The username for the credential.}
\item{description}{string, A long description of the credential.}
\item{owner}{string, The name of the user who this credential belongs to.}
\item{remoteHostId}{integer, The ID of the remote host associated with this credential.}
\item{remoteHostName}{string, The name of the remote host associated with this credential.}
\item{createdAt}{string, The creation time for this credential.}
\item{updatedAt}{string, The last modification time for this credential.}
}
\description{
Authenticate against a remote host
}
