% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.r
\name{plot.DRtrace}
\alias{plot.DRtrace}
\alias{plot.doseResponse}
\title{PLotting Methods for DRtrace, doseResponse Objects}
\usage{
\method{plot}{DRtrace}(x, xlab = "Patient Order", ylab = "Dose", ...)

\method{plot}{doseResponse}(
  x,
  xlab = "Dose",
  ylab = "Response",
  pch = "X",
  varsize = TRUE,
  refsize = mean(x$weight),
  ...
)
}
\arguments{
\item{x}{the object, whether DRtrace or doseResponse}

\item{xlab, ylab}{x-axis and y-axis labels passed on to \code{\link{plot}}}

\item{...}{Other arguments passed on to \code{\link{plot}}.}

\item{pch}{the plotting character (doseResponse only), the default being 'X' marks}

\item{varsize}{(doseResponse only) logical, should symbol size vary by sample size? Default \code{TRUE}}

\item{refsize}{(doseResponse only) a reference size by which the plotting sizes will be divided. Larger values make the symbols smaller. Default is \code{mean(dr$weight)}.}
}
\description{
Plotting methods for \code{\link{doseResponse}} and \code{\link{DRtrace}} classes.
}
\details{
Generic methods for dose-response trajectory/trace (\code{\link{DRtrace}}), and dose-response summary  (\code{\link{doseResponse}}) class objects. 
The \code{\link{DRtrace}} plotting uses the typical convention of plotting dose-finding experimental trace, with dose levels (x) in the vertical axis and 1/0 responses (y) denoted via filled/empty circles, respectively. In other words, this generic plotting method is only relevant for binary 0/1 outcomes.
The \code{\link{doseResponse}} plotting has response rate on the y-axis and dose on the x-axis, and plots symbols whose area is proportional to the weights.
}
\examples{
## Summary of raw data from the notorious Neuenschwander et al. (Stat. Med., 2008) trial
neundatTrace=DRtrace(x=c(rep(1:4,each=4),7,7,rep(6,9)),y=c(rep(0,16),1,1,rep(c(0,0,1),2),0,0,0))
par(mar=c(3,3,3,1),mgp=c(2,.5,0),tcl=-0.25)
layout(t(1:2))
plot(neundatTrace,main="N. et al. (2008) Cohort Trace",ylab="Ordinal Dose Level",cex.main=1.5)

## Same data, in 'doseResponse' format with actual doses rather than dose levels
neundatDose=doseResponse(x=c(1,2.5,5,10,20,25),y=c(rep(0,4),2/9,1),wt=c(3,4,5,4,9,2))
plot(neundatDose,main="N. et al. (2008) Final Dose-Toxicity",ylim=c(0,1),
	xlab="Dose (mg/sq.m./wk)",ylab="Toxicity Response Curve (F)",cex.main=1.5)
## We can also convert the DRtrace object to doseResponse...
neundatLevel=doseResponse(neundatTrace)

### Now plotting the former, vs. IR/CIR estimates
neunCIR0=cirPAVA(neundatDose,full=TRUE)
lines(neunCIR0$shrinkage$x,neunCIR0$shrinkage$y,type='b',pch=19)
legend(1,1,pch=c(4,19),legend=c('Observations','CIR (IR is same)'),bty='n')
}
\seealso{
\code{\link{doseResponse}}, \code{\link{DRtrace}}
}
\author{
Assaf P. Oron \code{<aoron.at.idmod.org>}
}
