% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flatten_xifti.R
\name{flatten_xifti}
\alias{flatten_xifti}
\title{Flatten a \code{"xifti"}}
\usage{
flatten_xifti(xifti, medial_wall = NULL, subcort_order = "alphabetical")
}
\arguments{
\item{xifti}{A \code{"xifti"} object.}

\item{medial_wall}{Should vertices for the medial wall be included with the
cortical data? If \code{NULL} (default), do not include them. If any other
value, use that value to fill rows corresponding to the medial wall mask.}

\item{subcort_order}{"alphabetical" (default) to match the Connectome
Workbench command \code{-cifti-export-dense-mapping}, or "spatial" which is
already the ordering used in the \code{"xifti"}.}
}
\value{
The flattened \code{"xifti"}, a data matrix
}
\description{
Concatenates the data in a \code{"xifti"} object row-wise to form a single matrix.
}
\details{
If all brain structures are present, and if
\code{is.null(medial_wall)} and \code{subcort_order=="alphabetical"}
(the default arguments), then the result will be identical to the matrix
obtained with the Connectome Workbench command
\code{-cifti-export-dense-mapping}.
}
\keyword{internal}
