% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_quantile_glmer.R
\name{add_quantile.glmerMod}
\alias{add_quantile.glmerMod}
\title{Response Quantiles for Generalized Linear Mixed Model Predictions}
\usage{
\method{add_quantile}{glmerMod}(
  df,
  fit,
  p,
  name = NULL,
  yhatName = "pred",
  type = "boot",
  includeRanef = TRUE,
  nSims = 10000,
  ...
)
}
\arguments{
\item{df}{A data frame of new data.}

\item{fit}{An object of class \code{glmerMod}.}

\item{p}{A real number between 0 and 1. Sets the probability level
of the quantiles.}

\item{name}{\code{NULL} or a string. If \code{NULL}, quantile
automatically will be named by \code{add_quantile}}

\item{yhatName}{\code{NULL} or a string. Name of the predictions vector.}

\item{type}{A string. Must be \code{"boot"}, If \code{type =
"boot"}, then \code{add_ci} calls \code{lme4::simulate} to
calculate the confidence intervals. This method may be time
consuming, but is applicable with random slope and random
intercept models.}

\item{includeRanef}{A logical. Default is \code{TRUE}. Set whether
the predictions and intervals should be made conditional on the
random effects. If \code{FALSE}, random effects will not be
included.}

\item{nSims}{A positive integer.  Controls the number of bootstrap
replicates.}

\item{...}{Additional arguments.}
}
\value{
A dataframe, \code{df}, with predicted values and quantiles attached.
}
\description{
This function is one of the methods for \code{add_pi}, and is
called automatically when \code{add_pi} is used on a \code{fit} of
class \code{glmerMod}. This function is experimental.
}
\details{
If \code{IncludeRanef} is False, random slopes and intercepts are set to 0. Unlike in
  `lmer` fits, settings random effects to 0 does not mean they are marginalized out. Consider
  generalized estimating equations if this is desired.
}
\examples{
n <- 300
x <- runif(n)
f <- factor(sample(1:5, size = n, replace = TRUE))
y <- rpois(n, lambda = exp(1 - 0.05 * x * as.numeric(f) + 2 * as.numeric(f)))
df <- data.frame(x = x, f = f, y = y)
fit <- lme4::glmer(y ~ (1+x|f), data=df, family = "poisson")

add_quantile(df, fit, name = "quant0.6", p = 0.6, nSims = 500)

}
\seealso{
\code{\link{add_pi.glmerMod}} for prediction intervals
    of \code{glmerMod} objects, \code{\link{add_probs.glmerMod}} for
    conditional probabilities of \code{glmerMod} objects, and
    \code{\link{add_ci.glmerMod}} for confidence intervals of
    \code{glmerMod} objects.
}
