% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chromoMap.R
\name{chromoMap}
\alias{chromoMap}
\title{render interactive chromosome plots}
\usage{
chromoMap(chData, type = c("annotation", "heatmap-single", "heatmap-double"),
  align = "horizontal", bgCol = "white", bgBorder = "white",
  chCol = "#c70039", chBorder = "#c70039", annoColor = "orange",
  textCol = "black", HeatColRange = c("red", "white", "blue"),
  dim = c(640, 480), width = NULL, height = NULL)
}
\arguments{
\item{chData}{The chromosome data required for annotating chromosome and creating 
heatmaps. It is a data.frame with atleast three colums viz. name (specify the 
name for annotation), chrom (specify chromosome name), and start (specify
the start position of element). While for heatmaps additional columns 
data and/or secondData need to added.}

\item{type}{Specify the type of chromosome plot.Takes only one value from
"annotation" , "heatmap-single", or "heatmap-double". For more information 
about the type of plots see vignette.}

\item{align}{specify the alignment of plot. Takes the value "horizontal" or
"vertical".}

\item{bgCol}{specify the backround color.}

\item{bgBorder}{specify the border color.}

\item{chCol}{specify the body color of chromosomes}

\item{chBorder}{specify the border color of chromosomes}

\item{annoColor}{specify the color of annotation bars on the chromosomes.}

\item{textCol}{specify the text color.}

\item{HeatColRange}{specify the heat-colors for the heatmap. Takes a character
vecter with three color values each corresponding to minimum, medium, and
maximum data.}

\item{dim}{specify dimension of plot. Takes two values for width and height 
of the plot.}

\item{width}{use to define width of widget. Usually ignore and do not change}

\item{height}{height of widget. ignore}
}
\description{
render an interactive graphics of human chromosome. It creates
an HTML widget that calls the JavaScript library chromoMap.js that generates
the chromosome graphics

required for creating widgets
}
\examples{

library(chromoMap)
data("pancandata")
#dataset contains two data
#view data set
head(pancandata$data1)
head(pancandata$data2)

#plotting simple annotation
chromoMap(pancandata$data1)

#plotting heatmap-single
chromoMap(pancandata$data1,type="heatmap-single")

#plotting heatmap double
chromoMap(pancandata$data2,type="heatmap-double")

#change orientation of plot
chromoMap(pancandata$data1,align="vertical")

#change chromosome color
chromoMap(pancandata$data1,chCol="green",chBorder="green")

#change chromosome plot background and text color
chromoMap(pancandata$data2,type="heatmap-double",textCol="white",bgCol="black")





}
