% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hclust_gcms.R
\name{hclust_gcms}
\alias{hclust_gcms}
\title{Hierarchical Clustering of GCMs}
\usage{
hclust_gcms(
  s,
  var_names = c("bio_1", "bio_12"),
  study_area = NULL,
  scale = TRUE,
  k = 3,
  n = NULL
)
}
\arguments{
\item{s}{A list of stacks of General Circulation Models (GCMs).}

\item{var_names}{Character. A vector of names of the variables to include, or 'all' to include all variables.}

\item{study_area}{An Extent object, or any object from which an Extent object can be extracted.
Defines the study area for cropping and masking the rasters.}

\item{scale}{Logical. Should the data be centered and scaled? Default is \code{TRUE}.}

\item{k}{Integer. The number of clusters to identify.}

\item{n}{Integer. The number of values to use in the clustering. If \code{NULL} (default), all data is used.}
}
\value{
A dendrogram visualizing the clusters and the suggested GCMs.
}
\description{
This function performs hierarchical clustering on a random subset of raster values and produces a dendrogram visualization of the clusters.
}
\examples{
var_names <- c("bio_1", "bio_12")
s <- import_gcms(system.file("extdata", package = "chooseGCM"), var_names = var_names)
study_area <- terra::ext(c(-80, -30, -50, 10)) |> terra::vect(crs="epsg:4326")
hclust_gcms(s, var_names, study_area, k = 4, n = 500)

}
\seealso{
\code{\link{transform_gcms}} \code{\link{flatten_gcms}}
}
\author{
Luíz Fernando Esser (luizesser@gmail.com)
https://luizfesser.wordpress.com
}
