% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_chkpt_draws.R
\name{extract_chkpt_draws}
\alias{extract_chkpt_draws}
\title{Extract Draws from \code{CmdStanMCMC} Objects}
\usage{
extract_chkpt_draws(object, phase)
}
\arguments{
\item{object}{An object of class \code{CmdStanMCMC}.}

\item{phase}{Character string. Which phase during checkpointing?
The options included \code{warmup} and \code{sample}.
The latter extracts the draws with
\code{inc_warmup = FALSE}, which is the default in
\code{\link[cmdstanr]{draws}}}
}
\value{
A 3-D \code{draws_array} object
(iteration \emph{x} chain \emph{x} variable).
}
\description{
A convenience function for extracting the draws from a
\code{CmdStanMCMC} object.
}
\note{
This can be used to extract the draws in general by setting
\code{phase = "sample"} which then only includes the post-warmup
draws.
}
\examples{
\dontrun{
 library(cmdstanr)

# eight schools example
fit_schools_ncp_mcmc <- cmdstanr_example("schools_ncp")

drws <- extract_chkpt_draws(object = fit_schools_ncp_mcmc,
                            phase = "sample")

# compare to cmdstanr
all.equal(drws, fit_schools_ncp_mcmc$draws())
}
}
