% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/txt2csv.R
\name{txt2csv}
\alias{txt2csv}
\title{Write Many Separated Files into a CSV}
\usage{
txt2csv(..., csv, must_txt = TRUE, na_in_txt = NULL)
}
\arguments{
\item{...}{names of folders and files, obtained files may end with ".txt" or not , see below.
Encoding for each file is auto-detected.}

\item{csv}{a .csv file that will contain texts. It must end with ".csv".}

\item{must_txt}{should be \code{TRUE} or \code{FALSE}. Should all qualified texts 
end with ".txt"? If you want to read other types of file, such as .rtf, set 
it to \code{FALSE}. Default is \code{TRUE}.}

\item{na_in_txt}{character vector that specifies what content, when it occupies a single line, 
should be treated as \code{NA}. See Details. Length of it can be larger than 1.}
}
\description{
Given filenames, folder names, or the mixture of the two, the function will read texts 
in .txt or other separated files, and then write 
them into one .csv file. It helps those who prefer texts in a table format.
}
\details{
Whether a file is taken as \code{NA} is judged by \code{\link{scancn}}. " " (a space) 
is also taken as \code{NA}. However, you 
can further decide what else is deemed as \code{NA}, e. g., "404 ERROR", if your texts are from 
websites. If a file cannot be accessed, the result to be 
written in the corresponding cell of csv file will become \code{NA}, and there will be a 
message, but no error is raised.
In the .csv file, full filenames of txt occupy a column and fulltexts occupy another.
}
\examples{
\dontrun{
x1 <- file.path(find.package("base"), "CITATION")
x2 <- file.path(find.package("base"), "DESCRIPTION")
txt2csv(x1, x2, must_txt = FALSE, csv = 'x1x2csv.csv')
}
}
