% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RMSEP_RPD.R
\name{RPD}
\alias{RPD}
\title{Residual Prediction Deviation (RPD)}
\usage{
RPD(predicted, observed, na.rm = FALSE)
}
\arguments{
\item{predicted}{a numeric vector containing predicted values.}

\item{observed}{a numeric vector of the same length as ```predicted```
containing observed values.}

\item{na.rm}{Boolean parameter indicating whether NA values should be removed before the analysis}
}
\value{
numeric value of the RDP.
}
\description{
This function computes the Residual Prediction Deviation (RPD), which
is defined as the standard deviation of observed values divided by
the Root Mean Square Error or Prediction (RMSEP). The RDP takes both
the prediction error and the variation of observed values into 
account, providing a metric of model validity that is more objective
than the RMSEP and more easily comparable across model validation
studies. The greater the RPD, the better the model's predictive
capacity.
}
\details{
Interpretation of the RPD is somewhat arbitrary, with different
thresholds for a good model used in the literature. Many studies
call a model *excellent*, when the RPD is above 2 (but other
classification use thresholds as high as 8 for this).
}
\examples{

predicted<-c(1,2,3,4,5,6,7,8,9,10)
observed<-c(1.5,1.8,3.3,3.9,4.4,6,7.5,9,11,10)

RPD(predicted,observed)

}
\references{
Williams PC and Sobering DC (1993) Comparison of
commercial near infrared transmittance and reflectance instruments
for analysis of whole grains and seeds. J. Near Infrared Spectrosc.
1, 25-32 (I didn't have access to this paper, but have noticed that
it is often provided as the key reference for the RPD).
}
\author{
Eike Luedeling
}
\keyword{model}
\keyword{validation}
