% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recycle.R
\name{recycle}
\alias{recycle}
\title{Recycle objects to a common size}
\usage{
recycle(..., length = NULL)
}
\arguments{
\item{...}{Objects to recycle.}

\item{length}{Optional length to recycle objects to.}
}
\value{
A list of recycled R objects.
}
\description{
A convenience function to recycle R objects to either a common or specified
size.
}
\details{
Data frames are recycled by recycling their rows. \cr
\code{recycle()} is optimised to only recycle objects that need recycling. \cr
\code{NULL} objects are ignored and not recycled or returned.
}
\examples{
library(cheapr)

recycle(Sys.Date(), 1:10)

# Any vectors of zero-length are all recycled to zero-length
recycle(integer(), 1:10)

# Data frame rows are recycled
recycle(sset(iris, 1:3), length = 3 * 3)

# To recycle list items, use `do.call()`
my_list <- list(from = 1L, to = 10L, by = seq(0.1, 1, 0.1))
do.call(recycle, my_list)

}
