% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parametricMesh.R
\name{parametricMesh}
\alias{parametricMesh}
\title{Mesh of a parametric surface}
\usage{
parametricMesh(f, urange, vrange, periodic = c(FALSE, FALSE), nu, nv)
}
\arguments{
\item{f}{vectorized function of two variables returning a three-dimensional 
point}

\item{urange, vrange}{the ranges of the two variables}

\item{periodic}{two Boolean values, whether \code{f} is periodic in the 
first variable and in the second variable}

\item{nu, nv}{numbers of subdivisions}
}
\value{
A \strong{rgl} mesh (\code{mesh3d} object).
}
\description{
Mesh of a parametric surface.
}
\examples{
library(cgalMeshes)
library(rgl)
# Richmond surface
Richmond <- function(r, t){
  radius <- 0.5
  r <- r + 1/4
  exprho <- exp(r*(1 + 3*radius) - 2 - radius)
  u <- exprho * cospi(2*t)
  v <- exprho * sinpi(2*t)
  rbind(
    -v/(u*u+v*v) - u*u*v + v*v*v/3,
    3*u,
     u/(u*u+v*v) - u*v*v + u*u*u/3
  ) 
}
rmesh <- parametricMesh(
  Richmond, urange = c(0, 1), vrange = c(0, 1),
  periodic = c(FALSE, TRUE), nu = 100, nv = 100
)
rmesh <- addNormals(rmesh)
# plot
open3d(windowRect = 50 + c(0, 0, 512, 512))
view3d(50, 10, zoom = 0.8)
shade3d(rmesh, color = "gold")
}
