% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat.R
\name{boxplot.timeSpent}
\alias{boxplot.timeSpent}
\title{Boxplot of time spent in each state}
\usage{
\method{boxplot}{timeSpent}(x, col = NULL, ...)
}
\arguments{
\item{x}{output of \code{\link{compute_time_spent}} function}

\item{col}{a vector containing color for each state}

\item{...}{extra parameters for \code{geom_boxplot}}
}
\value{
a \code{ggplot} object that can be modified using \code{ggplot2} package.
}
\description{
Boxplot of time spent in each state
}
\examples{
# Simulate the Jukes-Cantor model of nucleotide replacement
K <- 4
PJK <- matrix(1 / 3, nrow = K, ncol = K) - diag(rep(1 / 3, K))
lambda_PJK <- c(1, 1, 1, 1)
d_JK <- generate_Markov(n = 10, K = K, P = PJK, lambda = lambda_PJK, Tmax = 10)

# cut at Tmax = 8
d_JK2 <- cut_data(d_JK, Tmax = 8)

# compute time spent by each id in each state
timeSpent <- compute_time_spent(d_JK2)

# plot the result
boxplot(timeSpent, col = c("#8DA0CB", "#E78AC3", "#A6D854", "#FFD92F"))

# modify the plot using ggplot2
library(ggplot2)
boxplot(timeSpent, notch = TRUE, outlier.colour = "black") +
  coord_flip() +
  labs(title = "Time spent in each state")
}
\author{
Quentin Grimonprez
}
