% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/cernn.r
\name{get_lambda_max}
\alias{get_lambda_max}
\title{Compute lambda_max parameter for covariance regularization.}
\usage{
get_lambda_max(d, alpha, n, eps = 0.01)
}
\arguments{
\item{d}{Vector of sample eigenvalues to shrink. These must be nonnegative.}

\item{alpha}{Parameter that controls mixture between the trace and inverse trace penalties.}

\item{n}{The number of observations.}

\item{eps}{tolerance}
}
\description{
\code{get_lambda_max} computes a maximum lambda value that will shrink eigenvalues nearly to the grand mean.
}
\examples{
n <- 10
p <- 5
set.seed(12345)
X <- matrix(rnorm(n*p),n,p)
d <- svd(X)$d**2
alpha <- get_alpha(X)
get_lambda_max(d,alpha,n)
}

