% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/single.R
\name{cxy_single}
\alias{cxy_single}
\title{Geocode Single Parsed Address}
\usage{
cxy_single(
  street,
  city = NULL,
  state = NULL,
  zip = NULL,
  return = "locations",
  benchmark = "Public_AR_Current",
  vintage = NULL
)
}
\arguments{
\item{street}{String containing street address}

\item{city}{Optional String containing city}

\item{state}{Optional String containing state}

\item{zip}{Optional String or Integer containing 5-digit Zip Code}

\item{return}{One of 'locations' or 'geographies' See Details.}

\item{benchmark}{Optional ID or Name of Census Benchmark. See Details.}

\item{vintage}{Optional ID or Name of Census Vintage. See Details.}
}
\value{
A data.frame containing matched address or NULL if not matches
}
\description{
Provides access to the structured single address geocoding API from the US Census Bureau.
}
\details{
To obtain current valid benchmarks, use the \code{cxy_benchmarks()} function.

If you want to append census geographies, you must specify a valid vintage for your benchmark.
    You may use the \code{cxy_vintages()} function to obtain valid Vintages. See \code{vignette('censusxy')}
    for a full walkthrough.
}
\examples{
cxy_single(street = "20 N Grand Blvd", city = "St Louis", state = "MO", zip = "63108",
    return = "locations")

}
