% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rate_plot.R
\name{get_rate_summary}
\alias{get_rate_summary}
\title{Rates summary}
\usage{
get_rate_summary(
  seahorse_rates,
  measure = "OCR",
  assay,
  error_metric = "ci",
  conf_int = 0.95
)
}
\arguments{
\item{seahorse_rates}{data.table Seahorse OCR and ECAR rates (imported using \code{read_data} function)}

\item{measure}{Whether to calculate summary for \code{"OCR"} or \code{"ECAR"}}

\item{assay}{What assay to calculate summary for (e.g. "MITO" or "GLYCO")}

\item{error_metric}{Whether to calculate error as standard deviations (\code{"sd"}) or confidence intervals (\code{"ci"})}

\item{conf_int}{The confidence interval percentage. Should be between 0 and 1}
}
\value{
a data.table with means, standard deviations/standard error with bounds around the mean(sd or confidence intervals)
}
\description{
Summarize OCR and ECAR as mean and bounded standard deviations or standard error with confidence intervals
}
\examples{
rep_list <- system.file("extdata", package = "ceas") |>
  list.files(pattern = "*.xlsx", full.names = TRUE)
seahorse_rates <- read_data(rep_list, sheet = 2)
rates <- get_rate_summary(
  seahorse_rates,
  measure = "OCR",
  assay = "MCIO",
  error_metric = "ci",
  conf_int = 0.95
)
head(rates, n = 10)
}
