% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orderQ.R
\name{orderQ}
\alias{orderQ}
\title{Reorder Q-matrix columns}
\usage{
orderQ(Q, target)
}
\arguments{
\item{Q}{A \emph{J} items x \emph{K} attributes Q-matrix (\code{matrix} or \code{data.frame}). This is the Q-matrix that will be reordered.}

\item{target}{A \emph{J} items x \emph{K} attributes Q-matrix (\code{matrix} or \code{data.frame}). This could be the "true", generating Q-matrix.}
}
\value{
\code{orderQ} returns an object of class \code{orderQ}.
\describe{
\item{\code{order.Q}}{The reordered Q-matrix (\code{matrix}).}
\item{\code{configs}}{Comparison information between the different column configurations of the Q-matrix and the target Q-matrix, including the average absolute difference and the average Tucker index of factor congruence (\code{matrix}). The function will not look for all possible specifications if a perfect match is found.}
\item{\code{specifications}}{Function call specifications (\code{list}).}
}
}
\description{
Reorders Q-matrix columns according to a target matrix (e.g., another Q-matrix).
Specifically, it provides a reordered Q-matrix which columns show the lowest possible average Tucker index congruent coefficient with the target columns.
Reordering a Q-matrix is alike relabeling the attributes and it does not change the model.
Useful for simulation studies (e.g., comparing a validated Q-matrix with the generating Q-matrix).
}
\examples{
library(GDINA)
dat <- sim30GDINA$simdat
Q <- sim30GDINA$simQ
sugQ1 <- estQ(r = dat, K = 5) # Estimate Q-matrix
sugQ1$est.Q <- orderQ(sugQ1$est.Q, Q)$order.Q # Reorder Q-matrix attributes
mean(sugQ1$est.Q == Q) # Check similarity with the generating Q-matrix
}
\author{
{Francisco J. Abad, Universidad Autónoma de Madrid \cr Pablo Nájera, Universidad Pontificia Comillas}
}
