% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RowsColumns.R
\name{unpivot_to_blocks}
\alias{unpivot_to_blocks}
\title{Move values from columns to rows (anti-pivot, or "shred").}
\usage{
unpivot_to_blocks(data, nameForNewKeyColumn, nameForNewValueColumn,
  columnsToTakeFrom, ..., nameForNewClassColumn = NULL)
}
\arguments{
\item{data}{data.frame to work with (must be local, for remote please try \code{moveValuesToRows*}).}

\item{nameForNewKeyColumn}{character name of column to write new keys in.}

\item{nameForNewValueColumn}{character name of column to write new values in.}

\item{columnsToTakeFrom}{character array names of columns to take values from.}

\item{...}{force later argumets to bind by name.}

\item{nameForNewClassColumn}{optional name to land original cell classes to.}
}
\value{
new data.frame with values moved to rows.
}
\description{
For a tutorial please try \code{vignette('RowsAndColumns', package='cdata')}.
}
\examples{

if (requireNamespace("RSQLite", quietly = TRUE)) {
  d <- data.frame(AUC= 0.6, R2= 0.2)
  unpivot_to_blocks(d,
                    nameForNewKeyColumn= 'meas',
                    nameForNewValueColumn= 'val',
                    columnsToTakeFrom= c('AUC', 'R2')) \%.>\%
     print(.)
}

}
\seealso{
\code{\link{pivot_to_rowrecs}}
}
