% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusters.R
\name{cluster_shell}
\alias{cluster_shell}
\title{cluster_shell}
\usage{
cluster_shell(N = 50, R0 = 30, d = 1, a = 1, b = 1, c = 1,
  orientation = c("radial", "flat", "random"), position = c("fibonacci",
  "hc", "random"), exclusion = 5 * N^(-1/4), seed = 123, ...)
}
\arguments{
\item{N}{number of particles}

\item{R0}{radius of core}

\item{d}{distance from core}

\item{a}{semi-axis along x}

\item{b}{semi-axis along y}

\item{c}{semi-axis along z}

\item{orientation}{type of angular orientation}

\item{position}{type of random coverage}

\item{exclusion}{minimum exclusion distance for 'hc' positions}

\item{seed}{random seed for reproducibility}

\item{...}{extra arguments (ignored)}
}
\value{
list of class cluster with fields: positions, sizes, angles
}
\description{
Sparse shell of nanoparticles around a spherical core
}
\details{
A cluster describing a discrete shell of nanoparticles in a spherical geometry
}
\author{
baptiste Auguie
}
\seealso{
Other user_level cluster: \code{\link{cluster_array}},
  \code{\link{cluster_ball}}, \code{\link{cluster_chain}},
  \code{\link{cluster_dimer}}, \code{\link{cluster_helix}},
  \code{\link{cluster_single}}
}

