% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate.rsdata.R
\name{generate.rsdata}
\alias{generate.rsdata}
\title{Simulate preference data to apply CCRS}
\usage{
generate.rsdata(n=n,m=m,q=q,K.true=K.true,H.true=NULL,clustered.rs=FALSE,
              cls.cont.vec=NULL,cls.rs.vec=NULL,savedata=FALSE)
}
\arguments{
\item{n}{An integer indicating the number of respondents.}

\item{m}{An integer indicating the number of items.}

\item{q}{An integer indicating the maximum rating.}

\item{K.true}{An integer indicating the true number of content-based clusters for n respondents.}

\item{H.true}{An integer indicating the true number of response-style-based clusters for n respondents. This is needed when \code{clustered.rs=TRUE}.}

\item{clustered.rs}{A logical value indicating whether response-style-based cluster structure exists in generated data. If \code{TRUE}, coefficients of I-spline are generated by response-style-based clusters. The default is \code{clustered.rs=FALSE}.}

\item{cls.cont.vec}{A vector of integers (from 1:K.true) of length n indicating the content-based cluster to which each respondent is allocated in artificial data. If it's \code{NULL}, it is generated automatically.}

\item{cls.rs.vec}{A vector of integers (from 1:H.true) of length n indicating the response-style-based clusters. If it's \code{NULL} and clustered.rs==T, it is generated randomly.}

\item{savedata}{A logical value indicating whether artificial data are saved as csv files. The default is \code{savedata=FALSE}.}
}
\value{
A list with the following elements:
\item{\code{X}}{An n by m matrix of categorical variables.}
\item{\code{X.star}}{An n by m matrix of true preference data \code{X^*}.}
\item{\code{X.nors}}{An n by m matrix of categorical variables transformed by reference boundaries.}
\item{\code{cls.cont.vec}}{A vector of integers (from 1:H.true) indicating content-based clusters used to generate artificial data.}
\item{\code{cls.rs.vec}}{A vector of integers (from 1:H.true) indicating response-style-based clusters used to generate artificial data.}
}
\description{
Simulates artificial preference data containing content-based (and response-style-based) clusters.
}
\examples{
#data setting
n <- 30 ; m <- 10 ; H.true <- 2 ; K.true <- 2 ; q <- 5
datagene <- generate.rsdata(n=n,m=m,K.true=K.true,H.true=H.true,q=q,clustered.rs = TRUE)
#obtain n x m data matrix
X <- datagene$X
}
\references{
Takagishi, M., Velden, M. van de & Yadohisa, H. (2019). Clustering preference data in the presence of response style bias, to appear in British Journal of Mathematical and Statistical Psychology.
}
\seealso{
\code{\link{create.ccrsdata}}
}
