% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power.R
\name{cbc_power}
\alias{cbc_power}
\title{Estimate power analysis for choice experiment designs}
\usage{
cbc_power(
  data,
  outcome = "choice",
  obsID = "obsID",
  pars = NULL,
  randPars = NULL,
  n_breaks = 10,
  n_q = NULL,
  panelID = NULL,
  alpha = 0.05,
  return_models = FALSE,
  n_cores = NULL,
  ...
)
}
\arguments{
\item{data}{A data frame containing choice data. Can be a \code{cbc_choices} object
or any data frame with the required columns.}

\item{outcome}{Name of the outcome variable column (1 for chosen, 0 for not).
Defaults to "choice".}

\item{obsID}{Name of the observation ID column. Defaults to "obsID".}

\item{pars}{Names of the parameters to estimate. If NULL (default), will
auto-detect from column names for \code{cbc_choices} objects.}

\item{randPars}{Named vector of random parameters and their distributions
('n' for normal, 'ln' for log-normal). Defaults to NULL.}

\item{n_breaks}{Number of sample size groups to test. Defaults to 10.}

\item{n_q}{Number of questions per respondent. Auto-detected for \code{cbc_choices}
objects if not specified.}

\item{panelID}{Name of the panel ID column for panel data. Auto-detected
as "respID" for multi-respondent \code{cbc_choices} objects.}

\item{alpha}{Significance level for power calculations. Defaults to 0.05.}

\item{return_models}{If TRUE, includes full model objects in returned list.
Defaults to FALSE.}

\item{n_cores}{Number of cores for parallel processing. Defaults to
\code{parallel::detectCores() - 1}.}

\item{...}{Additional arguments passed to \code{logitr::logitr()}.}
}
\value{
A \code{cbc_power} object containing:
\itemize{
\item \code{power_summary}: Data frame with sample sizes, coefficients, estimates,
standard errors, t-statistics, and power
\item \code{models}: List of estimated models (if \code{return_models = TRUE})
\item \code{sample_sizes}: Vector of sample sizes tested
\item \code{n_breaks}: Number of breaks used
\item \code{alpha}: Significance level used
}
}
\description{
This function estimates the same model multiple times using different sample
sizes to assess statistical power. It returns both the estimated models and
a summary of coefficient estimates, standard errors, and power statistics.
}
\examples{
library(cbcTools)

# Create profiles and design
profiles <- cbc_profiles(
  price = c(1, 2, 3),
  type = c("A", "B", "C"),
  quality = c("Low", "High")
)

design <- cbc_design(profiles, n_alts = 2, n_q = 6)

# Simulate choices
priors <- cbc_priors(profiles, price = -0.1, type = c(0.5, 0.2), quality = 0.3)
choices <- cbc_choices(design, priors)

# Run power analysis
power_results <- cbc_power(choices, n_breaks = 8)

# View results
print(power_results)
plot(power_results)
}
