% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CAT_ability_est.R
\name{CAT_ability_est}
\alias{CAT_ability_est}
\title{Ability level estimation for an individual using a CAT decision tree}
\usage{
CAT_ability_est(cat.dt, res)
}
\arguments{
\item{cat.dt}{A \code{cat.dt} object returned by \code{\link{CAT_DT}}.}

\item{res}{Vector containing the test taker's responses to every item}
}
\value{
A list containing the following elements:

\code{$estimation} Estimated ability level after each level of the tree.

\code{$linf} Lower limit of the final estimation at 95%

\code{$lsup} Upper limit of the final estimation at 95%

\code{$items} Administered item in each level.

\code{$graphics} Plot object of the evolution of the ability level
estimation. It shows the ability level estimation after the individual
has answered to every administered item.
}
\description{
Computes the test taker's estimated ability level based on the CAT decision
tree previously built and the test taker's responses to every item at every
tree level
}
\examples{
data("itemBank")
# Build the cat.dt
nodes = CAT_DT(bank = itemBank, model = "GRM", crit = "MEPV",
               C = 0.3, stop = c(3,0.5), limit = 200, inters = 0.98,
               p = 0.9, dens = dnorm, 0, 1)

# Estimate the ability level of a subject with responses res
estimation = CAT_ability_est(nodes, res = itemRes[1, ])

#plot the estimations
plot(estimation$graphics)

}
\author{
Javier Rodr?guez-Cuadrado
}
