% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MakeArtificalData.R
\name{make_true_and_sample_web}
\alias{make_true_and_sample_web}
\title{Make an artificial bipartite networks with some properties of ecological networks, then sample from it}
\usage{
make_true_and_sample_web(seed = NULL, specpar = 1, n_hosts = 10,
  n_wasps = 10, TargetTrueConn = 0.5, SampleObs = 1000,
  abun_mean = 5, abun_sdlog = 1, traitvsnested = 0.5,
  hosttrait_n = "two")
}
\arguments{
\item{seed}{Random number generator seed, if specified.}

\item{specpar}{Specialisation parameter, equal to 1/sd of the normal curve that defines the consumption range}

\item{n_hosts}{Number of focal level species (e.g. hosts, flowers)}

\item{n_wasps}{Number of non-focal level species (e.g. parasitic wasps, pollinators)}

\item{TargetTrueConn}{Proportion of possible interactions to keep}

\item{SampleObs}{Number of samples to draw}

\item{abun_mean}{Mean abundance level (log scale).}

\item{abun_sdlog}{Distributon of abundance level (SD log scale).}

\item{traitvsnested}{The relative balance between the nestedness generator and the trait-based generator}

\item{hosttrait_n}{Number of trait dimensions. Default 'two', uses two traits, with one dominant. 'single' and 'multi' retained from Frund et al.}
}
\value{
A network list containing 'obs' a matrix of observations, 'TrueWeb' a matrix of the 'true']
 drawn web, and number of other properties of these networks.
}
\description{
Core model adapted from: "Sampling bias is a challenge [...]: lessons from a quantitative nichemodel" by
Jochen Frund, Kevin S. McCann and Neal M. Williams
}
\details{
Abundances are assigned by generating abundances that match a log-normal distribution (but without
 introducing noise)
}
\examples{
make_true_and_sample_web()
}
