% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sim.R
\docType{methods}
\name{claimFitting}
\alias{claimFitting}
\alias{claimFitting,Simulation,data.frame-method}
\alias{claimFitting,ANY-method}
\title{Claim data fitting analysis at line/type/status level}
\usage{
claimFitting(object, claimData, ...)

\S4method{claimFitting}{Simulation,data.frame}(object, claimData,
  startDate = as.Date("2012-01-01"),
  evaluationDate = as.Date("2016-12-31"), lineList = object@lines,
  typeList = object@types, discreteDist = c("Poisson",
  "NegativeBinomial", "Geometric"), continuousDist = c("Normal",
  "Lognormal", "Pareto", "Weibull", "Gamma", "Uniform", "Exponential"),
  copulaList = c("normal"), fReportLag = TRUE, fSettlementLag = TRUE,
  fFrequency = TRUE, fSeverity = TRUE, fSSRCorrelation = TRUE,
  fFreqCorrelation = TRUE, copulaTest = TRUE, iTotalLoss = TRUE,
  fDeductible = TRUE, fLimit = TRUE, check = TRUE)
}
\arguments{
\item{object}{Simulation object}

\item{claimData}{claim data including existing claims for RBNER and claim reopenness analysis}

\item{...}{Additional parameters that may or may not be used.}

\item{startDate}{Date after which claims are analyzed;}

\item{evaluationDate}{Date of evaluation for existing claims and IBNR;}

\item{lineList}{List of business lines to be included in claim fitting;}

\item{typeList}{List of claim types to be included in claim fitting;}

\item{discreteDist}{List of discrete distributions to try fitting (report lag, settlemet lag, frequency);}

\item{continuousDist}{List of continuous distribution to try fitting (severity);}

\item{copulaList}{List of copula to try fitting;}

\item{fReportLag}{Boolean variable to indicate whether report lag needs to be fitted;}

\item{fSettlementLag}{Boolean variable to indicate whether settlement lag needs to be fitted;}

\item{fFrequency}{Boolean variable to indicate whether monthly frequency needs to be fitted;}

\item{fSeverity}{Boolean variable to indicate whether severity needs to be fitted;}

\item{fSSRCorrelation}{Boolean variable to indicate whether copula among severity, report lag and settlement lag needs to be fitted;}

\item{fFreqCorrelation}{Boolean variable to indicate whether copula among frequencies of business lines needs to be fitted.}

\item{copulaTest}{Whether to test copula. The testing could take a very long time;}

\item{iTotalLoss}{Boolean variable to indicate whether total loss before deductible and limit is available for severity fitting;}

\item{fDeductible}{Boolean variable to indicate whether deductible empirical distribution needs to be fitted;}

\item{fLimit}{Boolean variable to indicate whether limit empirical distribution needs to be fitted;}

\item{check}{Boolean variable to indicate whether graph of each tried distribution fitting needs to be generated and saved.}
}
\description{
Claim data fitting analysis at line/type/status level
}
\examples{
library(cascsim)
data(claimdata)
lines<-c("Auto")
types<-c("N")
#exposure index
index1 <- new("Index",monthlyIndex=c(rep(1,11),cumprod(c(1,rep(1.5^(1/12),11))),
cumprod(c(1.5,rep((1.3/1.5)^(1/12),11))),
cumprod(c(1.3,rep((1.35/1.3)^(1/12),11))),cumprod(c(1.35,rep((1.4/1.35)^(1/12),11))),rep(1.4,301)))
#severity index
index2 <- new("Index",monthlyIndex=c(cumprod(c(1,rep(1.03^(1/12),59))),rep(1.03^(5),300)))
objan <- new("ClaimType", line="Auto",claimType="N",exposureIndex=index1,severityIndex=index2)
objlist <- list(objan)
simobj <- new("Simulation",lines=lines,types=types,claimobjs=objlist,iFit=TRUE,
iCopula=FALSE, iReport=TRUE, workingFolder=tempdir())
simobj <- claimFitting(simobj,claimdata,fSSRCorrelation = FALSE, fSettlementLag = FALSE)
}
