% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CTriangle.R
\docType{class}
\name{Triangle-class}
\alias{Triangle-class}
\title{An S4 class to represent a triangle or rectangle object.}
\description{
An S4 class to represent a triangle or rectangle object.
}
\section{Slots}{

\describe{
\item{\code{triID}}{A character string to identify the triangle object.}

\item{\code{type}}{A character string that indicates the triangle type, such as reportedCount, closedCount, paidLoss, and incurredLoss.}

\item{\code{startDate}}{The start date for the accident year or Quarter.}

\item{\code{frequency}}{A character that indicates the frequency of the triangle, "yearly" or "quarterly".}

\item{\code{sim}}{A number that indicates the simulation number used to complete the rectangle. Zero means using the average value.}

\item{\code{percentile}}{A number that indicates the percentile used to complete the rectangle. It is only used when sim is NA.}

\item{\code{iRBNER}}{A Boolean that indicates whether open claims are simulated. If not, current information will be used for constructing rectangles. Otherwise, simulated data will be used.}

\item{\code{iROPEN}}{A Boolean that indicates whether claim reopen are simulated. If not, current information will be used for constructing rectangles. Otherwise, simulated data will be used.}

\item{\code{percentile}}{A number that indicates the percentile used to complete the rectangle. It is only used when sim is NA.}

\item{\code{upper}}{A matrix that contains the upper triangle based on claim data.}

\item{\code{upperkeep}}{A matrix that contains the upper triangle that are not simulated. It will be used to construct the rectangle for the non-simulated part.}

\item{\code{rectangle}}{A matrix that contains the entire rectangle based on simulation data.}
}}

