% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brktrials2.R
\name{brktrials2}
\alias{brktrials2}
\title{\code{brktrials2} produces \code{t-x} trajectories for lead and following vehicles at a bottleneck}
\usage{
brktrials2(tend, umn, usd, xstart, xfunnel, leff, lane, step, type)
}
\arguments{
\item{tend}{end time for a simulation run, a number}

\item{umn}{start speed (mph) for vehicle in lane 1, a number}

\item{usd}{speed volatility for \code{umn}, a number}

\item{xstart}{a vector of  \code{nveh} start locations, (feet), a vector}

\item{xfunnel}{upstream location where the lane drop starts (feet), a number}

\item{leff}{effective vehicle length(feet), a number}

\item{lane}{a vector of \code{nveh} numbers, a vector}

\item{step}{size in seconds, a number}

\item{type}{0 no plots, 1 prediction plot, 2 all plots, a number}
}
\value{
\code{brktrials2} returns  \code{t-x} trajectories of \code{nveh} vehicles at a bottleneck.
}
\description{
\code{brktrials2} produces \code{t-x} trajectories for lead and following vehicles at a bottleneck
}
\examples{
brktrials2(30, 41, 11, xstart, -500, 14, lane, 0.5, 1)
}
