% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rust_fn.R
\name{rust_fn}
\alias{rust_fn}
\title{Define an R Function Implemented in Rust}
\usage{
rust_fn(
  ...,
  dependencies = character(0),
  minimum_version = "1.31.0",
  verbose = FALSE,
  cached = TRUE,
  longjmp = TRUE,
  invisible = FALSE
)
}
\arguments{
\item{...}{Rust code is taken as a string from the last unnamed argument, and
variable names come for all other unnamed arguments.  See example.}

\item{dependencies}{A character vector of crate dependencies, e.g.,
\code{c('rand = "0.8.4"','rand_pcg = "0.3.1"')}.}

\item{minimum_version}{A character string representing the minimum version of
Rust that is needed. Or a path to the DESCRIPTION file, in which case the
value is found from the field: \code{SystemRequirements: Cargo (>= XXXX)}.}

\item{verbose}{If \code{TRUE}, Cargo prints compilation details.  If
\code{FALSE}, Cargo is run in quiet mode, except for the first time this
function is run.  If \code{"never"}, Cargo is always run in quiet mode.
In any case, errors in code are always shown.}

\item{cached}{Should Cargo use previously compiled artifacts?}

\item{longjmp}{Should the compiled function use the faster (but experimental)
longjmp functionality when Rust code panics?}

\item{invisible}{Should the compiled function return values invisibly?}
}
\description{
This function takes Rust code as a string from the last unnamed argument,
takes variable names for all other unnamed arguments, compiles the Rust
function, and wraps it as an R function.
}
