"print.train" <-
  function(x,
           digits = min(3, getOption("digits") - 3),
           printCall = TRUE,
           details = FALSE, ...)
{
  stringFunc <- function (x) 
    {
      if (!is.character(x)) x <- as.character(x)
      numElements <- length(x)
      out <- if (length(x) > 0) {
        switch(min(numElements, 3), x, paste(x, collapse = " and "), 
               {
                 x <- paste(x, c(rep(",", numElements - 2), " and", 
                                 ""), sep = "")
                 paste(x, collapse = " ")
               })
      } else ""
      out
    }   

  if(printCall)
    {
      cat("\nCall:\n")
      print(x$call)
    }
  cat("\n")
  
  if(!is.null(x$trainingData))
    {
      chDim <- dim(x$trainingData)
      chDim[2] <- chDim[2] - 1
      chDim <- format(chDim)
      cat(
          chDim[1], 
          " samples\n", 
          chDim[2],
          " predictors\n\n",
          sep = "")    
    }
  if(!is.null(x$preProc))
    {
      ## Make things look a little nicer:
      pp <- x$preProc$method
      pp <- gsub("scale", "scaled", pp)
      pp <- gsub("center", "centered", pp)
      pp <- gsub("pca", "principal component signal extraction", pp)
      pp <- gsub("ica", "independent component signal extraction", pp)
      pp <- gsub("spatialSign", "spatial sign transformation", pp)

      cat("Pre-processing:",
          paste(pp, collapse = ", "),
         "\n")
    } else cat("No pre-processing\n")


  
  if(!is.null(x$control$index))
    {
      resampleN <- unlist(lapply(x$control$index, length))
      numResamp <- length(resampleN)
      
      resampName <- switch(tolower(x$control$method),
                           boot = paste("Bootstrap (", numResamp, " reps)", sep = ""),
                           boot632 = paste("Bootstrap 632 Rule (", numResamp, " reps)", sep = ""),
                           cv = paste("Cross-Validation (", x$control$number, " fold)", sep = ""),
                           repeatedcv = paste("Cross-Validation (", x$control$number, " fold, repeated ",
                                              x$control$repeats, " times)", sep = ""),
                           lgocv = paste("Repeated Train/Test Splits (", numResamp, " reps, ",
                             round(x$control$p, 2), "%)", sep = ""))
      cat("Resampling:", resampName, "\n\n")      
      outLabel <- x$metric

      resampleN <- as.character(resampleN)
      if(numResamp > 5) resampleN <- c(resampleN[1:6], "...")
      cat("Summary of sample sizes:", paste(resampleN, collapse = ", "), "\n\n")

      
      if(is.null(x$control$index) & x$control$number != numResamp)
        {
          cat(
              "(", 
              x$control$number - numResamp,
              " resamples were not returned",
              "by the lsf process)\n\n")
        }
    }
  tuneAcc <- x$results 
  tuneAcc <- tuneAcc[, names(tuneAcc) != "parameter"]

  cat("Resampling results")
  if(dim(tuneAcc)[1] > 1) cat(" across tuning parameters:\n") else cat("\n")
  cat("\n")


  
  if(dim(tuneAcc)[1] > 1)
    {
      numParam <- nrow(caret:::modelLookup(x$method))

      finalTune <- x$bestTune
      names(finalTune) <- substring(names(finalTune), 2)

      optValues <- paste(names(finalTune), "=", format(finalTune, digits = digits))
      optString <- paste(
                         "The final ",
                         ifelse(numParam > 1, "values", "value"),
                         " used for the model ",
                         ifelse(numParam > 1, "were ", "was "),
                         stringFunc(optValues),
                         ".",
                         sep = "")

      
      finalTune$Selected <- "*"

      tuneAcc <- merge(tuneAcc, finalTune, all.x = TRUE)
      tuneAcc$Selected[is.na(tuneAcc$Selected)] <- ""

    } else optString <- ""
  
  sdCols <- grep("SD$", colnames(tuneAcc))
  sdCheck <- unlist(lapply(
                           tuneAcc[, sdCols, drop = FALSE],
                           function(u) all(is.na(u))))
  if(any(sdCheck))
    {
      rmCols <- names(sdCheck)[sdCheck]
      tuneAcc <- tuneAcc[, !(names(tuneAcc) %in% rmCols)]	
    }

  params <- modelLookup(x$method)$parameter
  if(!all(params == "parameter"))
    {
      numVals <- apply(tuneAcc[, params, drop = FALSE], 2, function(x) length(unique(x)))
      if(any(numVals < 2))
        {
          constString <- NULL
          for(i in seq(along = numVals))
            {
              if(numVals[i] == 1)
                constString <- c(constString,
                                 paste("Tuning parameter '",
                                       names(numVals)[i],
                                       "' was held constant at a value of ",
                                       ifelse(is.character(tuneAcc[1,names(numVals)[i]]) |
                                              is.factor(tuneAcc[1,names(numVals)[i]]),
                                              paste("'", tuneAcc[1,names(numVals)[i]], "'", sep = ""),
                                              tuneAcc[1,names(numVals)[i]]),
                                       sep = ""))
            }
          discard <- names(numVals)[which(numVals == 1)]
          tuneAcc <- tuneAcc[, !(names(tuneAcc) %in% discard), drop = FALSE]

        } else constString <- NULL
    } else constString <- NULL
  
  printList <- lapply(
                      tuneAcc, 
                      function(data, dig = digits)
                      {
                        if(is.numeric(data) & !is.factor(data)) out <- paste(signif(data, dig))
                        else out <- as.character(data)
                        out
                      }) 
  printMat <- as.matrix(as.data.frame(printList))      
  rownames(printMat) <- rep("", dim(printMat)[1])
  colnames(printMat) <- gsub("SD", " SD", colnames(printMat))
  
  print(printMat, quote = FALSE, print.gap = 2)
  cat("\n")

  if(!is.null(constString))
    {
      cat(paste(constString, collapse = "\n"))
      cat("\n")
    }

  
  if(dim(tuneAcc)[1] > 1)
    {
      cat(x$metric, "was used to select the optimal model using")
      if(is.function(x$control$selectionFunction))
        {
          cat(" a custom selection rule.\n")
        } else {

          cat(
              switch(
                     x$control$selectionFunction,
                     best = paste(
                       " the",
                       ifelse(x$maximize, "largest", "smallest"),
                       "value.\n"),
                     oneSE = " the one SE rule.\n",
                     tolerance = " a tolerance rule.\n"))
        }
    }
  
  cat(optString)
  
  if(details)
    {
      if(!(x$method %in% c("gbm", "treebag", "nb", "lvq", "knn")))
        {
          cat("\n----------------------------------------------------------\n")
          cat("\nThe final model:\n\n")
          switch(x$method,
                 lm =, nnet =, multinom =, pls =, earth =,
                 lmStepAIC =,
                 bagEarth =, bagFDA = print(summary(x$finalModel)),
                 rpart =, ctree =, ctree2=, cforest =,
                 glmboost =, gamboost =, blackboost =,
                 ada =, randomForest =, pcaNNet =,
                 svmradial =, svmpoly =,
                 svmRadial =, svmPoly =,
                 rvmRadial =, rvmPoly =,
                 lssvmRadial =, lssvmPoly =,
                 gaussprRadial =, gaussprPoly =,
                 enet =, lasso =, LMT =, JRip =,
                 lda =, rda =, pamr =, gpls =, J48 =,
                 ppr = print(x$finalModel),
                 fda = 
                 {
                   print(x$finalModel)
                   cat("\n Summary of Terms\n\n")
                   print(x$finalModel$fit)
                   
                 })
        }
    }
  
  
  invisible(as.data.frame(printList))
}


