% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_fishertest.R
\name{ard_fishertest}
\alias{ard_fishertest}
\title{ARD Fisher's Exact Test}
\usage{
ard_fishertest(data, by, variable, ...)
}
\arguments{
\item{data}{(\code{data.frame})\cr
a data frame.}

\item{by, variable}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
column names to compare}

\item{...}{additional arguments passed to \code{fisher.test(...)}}
}
\value{
ARD data frame
}
\description{
Analysis results data for Fisher's Exact Test.
Calculated with \code{fisher.test(x = data[[variable]], y = data[[by]], ...)}
}
\examples{
cards::ADSL[1:30, ] |>
  ard_fishertest(by = "ARM", variable = "AGEGR1")
}
