% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_chisqtest.R
\name{ard_chisqtest}
\alias{ard_chisqtest}
\title{ARD Chi-squared Test}
\usage{
ard_chisqtest(data, by, variable, ...)
}
\arguments{
\item{data}{(\code{data.frame})\cr
a data frame.}

\item{by, variable}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
column names to compare}

\item{...}{additional arguments passed to \code{fisher.test(...)}}
}
\value{
ARD data frame
}
\description{
Analysis results data for Pearson's Chi-squared Test.
Calculated with \code{chisq.test(x = data[[variable]], y = data[[by]], ...)}
}
\examples{
cards::ADSL |>
  ard_chisqtest(by = "ARM", variable = "AGEGR1")
}
