\name{compPower}
\alias{compPower}
\title{Comparison of Powers for Different Tests under Different Randomization methods}
\usage{
  compPower(powers, diffs, testname)
}
\description{
  Compares the power of tests under different randomization methods and treatment effects through matrices and plots.
}
\arguments{
  \item{powers}{a list. Each argument consists the power generated by \code{evalPower} in this package or by other sources. The length of each argument must match.}
  \item{diffs}{a vector. It contains values of differences in treatment effects. The length of this argument and the length of each argument of \code{powers} must match.}
  \item{testname}{a vector. Each element is the name of test and randomization method used. For example, when applying \code{rand.test} under \code{HuHuCAR} and \code{corr.test} under \code{HuHuCAR}, it can be \code{c('HH.rand','HH.corr')}. The length of this argument must match the length of \code{diffs}.}
}
\value{
  This function returns a list. The first element is a matrix consisting of powers of chosen tests under different values of treatment effects. The second element of the list is a plot of powers. \code{diffs} forms the vertical axis of the plot.
}

\examples{
##settings
set.seed(100)
n = 1000
cov_num = 5
level_num = c(2,2,2,2,2)
pr = rep(0.5,10)
beta = c(1,4,3,2,5)
di = seq(0,0.5,0.1)
sigma = 1
type = "linear"
p=0.85
Iternum = 10 #<<for demonstration,it is suggested to be around 1000
sl = 0.05
weight = rep(0.1,5)

#comparison of corrected t-test under StrBCD and PocSim
##data generation
library("ggplot2")
Strctp=evalPower(n,cov_num,level_num,pr,type,beta,di,
                sigma,Iternum,sl,StrBCD,corr.test,FALSE,p)
PSctp=evalPower(n,cov_num,level_num,pr,type,beta,di,sigma,
                Iternum,sl,PocSimMIN,corr.test,FALSE,weight,p)
powers = list(Strctp,PSctp)
testname = c("StrBCD.corr","PocSimMIN.corr")

#get plot and matrix for comparison
cp = compPower(powers,di,testname)
cp
}
