\name{PocSimMIN.sim}
\alias{PocSimMIN.sim}
\alias{PocSimMIN.sim.carandom}
\title{
Pocock and Simon's Method in Two-arms Case for Simulated Data
}
\description{
Allocates patients generated by simulating covariates-profile on assumption of independence between covariates and levels within each covariate, to one of two treatments using Pocock and Simon's method proposed by Pocock S J, Simon R (1975) <Doi:10.2307/2529712>.
}
\usage{
\method{PocSimMIN.sim}{carandom}(n = 1000, cov_num = 2, level_num = c(2, 2), 
              pr = rep(0.5, 4), weight = NULL, p = 0.85)
}
\arguments{
  \item{n}{number of patients. Default is \code{1000}.}
  \item{cov_num}{number of covariates. Default is \code{2}.}
  \item{level_num}{vector of level numbers for each covariates. Hence the length of level_num should equal to number of covariates. Default is \code{level_num = c(2, 2)}. }
  \item{pr}{vector of probabilities. Under assumption of independence between covariates, \code{pr} is a vector containing probabilities for each levels of each covariates. The length of \code{pr} should correspond to number of all levels; and sum of \code{pr} should equal \code{cov_num}. If \code{pr = rep(0.5, 4)} (default), it means \code{cov_num = 2}, and \code{level_num = c(2, 2)}.}
  \item{weight}{vector of weights for maginal imbalances. It is required that at least one element is larger than 0. If \code{weight = NULL} (default), it weights marginal imbalances with equal proportion \code{1/cov_num} for each margin.}
  \item{p}{probabilities of assigning one patient to treatment 1. p should be larger than 1/2 to obtain balance. The default is \code{0.85}.}
}
\details{
See \code{\link{PocSimMIN}}.
}
\value{
See \code{\link{PocSimMIN}}. 
}
\seealso{
  See \code{\link{PocSimMIN}} for allocating a given completely collected data; See \code{\link{PocSimMIN.ui}} for command-line user interface. 
}