% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symbol.R
\name{sympy_func}
\alias{sympy_func}
\title{Call a SymPy function directly on x}
\usage{
sympy_func(x, fun, ...)
}
\arguments{
\item{x}{Object to call \code{fun} on}

\item{fun}{Function to call}

\item{\dots}{Passed on to \code{fun}}
}
\description{
Call a SymPy function directly on x
}
\examples{
if (has_sympy()) {
  def_sym(x, a)
  p <- (x-a)^4
  p
  q <- p \%>\% sympy_func("expand")
  q
  q \%>\% sympy_func("factor")
  
  def_sym(x, y, z)
  expr <- x*y + x - 3 + 2*x^2 - z*x^2 + x^3
  expr
  expr \%>\% sympy_func("collect", x) 
}
 
}
\concept{caracas_symbol}
