\name{car-package}
\alias{car-package}
\alias{car}
\docType{package}
\title{
Companion to Applied Regression
}
\description{
This package accompanies J. Fox, An R and S-PLUS Companion
to Applied Regression, Sage, 2002. The package contains mostly
functions for applied regression, linear models, and
generalized linear models, with an emphasis on regression
diagnostics, particularly graphical diagnostic methods. There
are also some utility functions. With some exceptions, I have
tried not to duplicate capabilities in the basic distribution
of R, nor in widely used packages. Where relevant, the
functions in car are consistent with na.action = na.omit or
na.exclude.
}
\details{
\tabular{ll}{
Package: \tab car\cr
Version: \tab 1.2-4\cr
Date: \tab 2007/10/10\cr
Depends: \tab R (>= 2.1.1), stats, graphics\cr
Suggests: \tab MASS, nnet, leaps\cr
License: \tab GPL (>= 2)\cr
URL: \tab http://www.r-project.org, http://socserv.socsci.mcmaster.ca/jfox/\cr
}

Index:
\preformatted{
Adler                   Experimenter Expectations
Angell                  Moral Integration of American Cities
Anova                   Anova Tables for Various Statistical Models
Anscombe                U. S. State Public-School Expenditures
Ask                     Change Argument to a Function Interactively
Baumann                 Methods of Teaching Reading Comprehension
Bfox                    Canadian Women's Labour-Force Participation
Blackmoor               Exercise Histories of Eating-Disordered and
                        Control Subjects
Burt                    Fraudulent Data on IQs of Twins Raised Apart
Can.pop                 Canadian Population Data
Chile                   Voting Intentions in the 1988 Chilean
                        Plebiscite
Chirot                  The 1907 Romanian Peasant Rebellion
Contrasts               Functions to Construct Contrasts
Cowles                  Cowles and Davis's Data on Volunteering
Davis                   Self-Reports of Height and Weight
DavisThin               Davis's Data on Drive for Thinness
Duncan                  Duncan's Occupational Prestige Data
Ericksen                The 1980 U.S. Census Undercount
Florida                 Florida County Voting
Freedman                Crowding and Crime in U. S. Metropolitan Areas
Friendly                Format Effects on Recall
Ginzberg                Data on Depression
Greene                  Refugee Appeals
Guyer                   Anonymity and Cooperation
Hartnagel               Canadian Crime-Rates Time Series
Leinhardt               Data on Infant-Mortality
Mandel                  Contrived Collinear Data
Migration               Canadian Interprovincial Migration Data
Moore                   Status, Authoritarianism, and Conformity
Mroz                    U.S. Women's Labor-Force Participation
OBrienKaiser            O'Brien and Kaiser's Repeated-Measures Data
Ornstein                Interlocking Directorates Among Major Canadian
                        Firms
Prestige                Prestige of Canadian Occupations
Quartet                 Four Regression Datasets
Robey                   Fertility and Contraception
SLID                    Survey of Labour and Income Dynamics
Sahlins                 Agricultural Production in Mazulu Village
Soils                   Soil Compositions of Physical and Chemical Characteristics
States                  Education and Related Statistics for the U.S.
                        States
UN                      GDP and Infant Mortality
US.pop                  Population of the United States
Var                     Variance-Covariance Matrices (deprecated)
Vocab                   Vocabulary and Education
Womenlf                 Canadian Women's Labour-Force Participation
av.plots                Added-Variable Plots
box.cox                 Box-Cox Family of Transformations
box.cox.powers          Multivariate Unconditional Box-Cox
                        Transformations
box.cox.var             Constructed Variable for Box-Cox Transformation
box.tidwell             Box-Tidwell Transformations
ceres.plots             Ceres Plots
cookd                   Cook's Distances for Linear and Generalized
                        Linear Models
cr.plots                Component+Residual (Partial Residual) Plots
durbin.watson           Durbin-Watson Test for Autocorrelated Errors
ellipse                 Ellipses, Data Ellipses, and Confidence
                        Ellipses
hccm                    Heteroscedasticity-Corrected Covariance
                        Matrices
influencePlot           Regression Influence Plot
inv                     Internal car functions
levene.test             Levene's Test
leverage.plots          Regression Leverage Plots
linear.hypothesis       Test Linear Hypothesis
logit                   Logit Transformation
n.bins                  Number of Bins for Histogram
ncv.test                Score Test for Non-Constant Error Variance
outlier.test            Bonferroni Outlier Test
panel.car               Panel Function Coplots
power.axis              Axes for Transformed Variables
qq.plot                 Quantile-Comparison Plots
recode                  Recode a Variable
reg.line                Plot Regression Line
scatterplot             Scatterplots with Boxplots
scatterplot.matrix      Scatterplot Matrices
some                    Sample a Few Elements of an Object
spread.level.plot       Spread-Level Plots
subsets                 Plot Output from regsubsets Function in leaps
                        package
symbox                  Boxplots for transformations to symmetry
vif                     Variance Inflation Factors
which.names             Position of Row Names
}
}
\author{
John Fox <jfox@mcmaster.ca>. I am grateful to Douglas Bates,
David Firth, Michael Friendly, Gregor Gorjanc, Spencer Graves, 
Richard Heiberger, Georges Monette, Henric Nilsson, Brian Ripley, 
Sanford Weisberg, and Achim Zeleis for various suggestions and
contributions.

Maintainer: John Fox <jfox@mcmaster.ca>
}
\keyword{ package }
