% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linkage_blocks_network.R
\name{linkage_blocks_network}
\alias{linkage_blocks_network}
\title{Identify linkage blocks}
\usage{
linkage_blocks_network(
  data_obj,
  geno_obj,
  collapse_linked_markers = TRUE,
  threshold_power = 1,
  plot_blocks = TRUE
)
}
\arguments{
\item{data_obj}{a \code{\link{Cape}} object}

\item{geno_obj}{a genotype object}

\item{collapse_linked_markers}{A logical value. If TRUE markers are combined 
into linkage blocks based on correlation. If FALSE, each marker is treated as 
an independent observation.}

\item{threshold_power}{A soft threshold power. The marker
correlation matrix is raised to this power to increase or
decrease the number of linkage blocks detected. Increasing 
the power makes more linkage blocks, and decreasing the power
makes fewer linkage blocks. The default power is 1, which uses
the correlation matrix as is.}

\item{plot_blocks}{logical. If TRUE, the marker correlation 
matrices are plotted and the boundaries of the blocks are shown.}
}
\value{
The data object is returned with a new list called
linkage_blocks_collapsed if collapse_linked_markers is TRUE 
and linkage_blocks_full if collapse_linked_markers is FALSE
Each element of the list is one linkage block and contains
a vector naming the markers in that block. Blocks are named
with a chromosome number and an index.
}
\description{
This function identifies linkage blocks among markers
using pairwise correlation between genotypes. 
The algorithm clusters adjacent, correlated markers
using the fastgreedy community detection algorithm from 
R/igraph
}
\details{
Csardi G, Nepusz T: The igraph software package for 
complex network research, InterJournal, Complex Systems
1695. 2006. https://igraph.org

The correlation network can be optionally soft thresholded
to increase or decrease resolution.
}
\keyword{internal}
