context("canvasXpress selectedDataPoints")


vals = c(19.18,23.34,6.57,5.61,3.26,9.28,19.97,24.34,1.04,17.93,14.24,21.52,11.16,12.63,26.37,11.32,3.18,27.27,2.09,25.56,7.88,23.12,7.42,7.87,2.09,16.44,10.91,6.67,8.29,28.66,20.51,22.63,16.79,27.28,15.12,14.97,10.66,25.44,6.86,10.31,9.25,4.13,9.89,6.22,18.44,21.07,28.01,5.47,27.52,2.29,4.88,12.91,24.73,28.34,16.9,22.99,3.5,23.15,8.75,26.05,15.35,21.66,23.64,5.14,17.39,7.95,4.2,7.62,18.64,24.2,4,11.37,20.8,18.21,25.81,5.67,5.91,17.64,18.47,6.77,26.51,14.88,4.45,8.1,6.55,10.62,2.06,5.16,8.95,20.07,22.37,11.1,17.79,13.85,28.74,6.9,19.27,17.54,27.04,22.28,17.17,5.91,6.57,11.28,11.15,11.79,11.55,26.44,21.61,1.65,7.44,19.7,21.24,21.82,17.72,25.98,25.25,27.35,27.55,1.39,4.25,9.61,17.9,16.08,11.83,2.47,18.51,17.87,22.75,23.21,11.4,6.41,13.85,4.09,21.11,2.09,7.6,22.53,27.6,5.61,22.33,18.04,9.77,4.17,13.08,3.75,7.73,24.4,27.23,16.66,7.64,7.86,14.65,2.49,13.32,13.34,20.61,27.27,24.42,17.67,5.38,3.54,5.32,15.31,18.37,23.24,12.73,24.59,27.1,9.31,5.85,28.56,16.71,1.82,11.29,18.6,24.17,14.96,26.65,28.57,23.22,24.53,26.68,19.76,23.89,2.18,16.23,8.41,22.71,24.3,17.76,15.96,27.64,7.6,21.59,9.92,17.59,23.27,10.8,3.41,4.66,13.94,4.72,5.43,3.02,5.19,9.25,17.71,16.48,27.78,13.66,22.26,16.68,2.54,6.2,15.64,24.03,7.96,8.31,5.79,11.22,6.35,15.48,27.63,21.45,8.78,12.86,9.25,25.34,6.59,9.44,20.84,20.47,5.67,6.94,10.18,9.62,23.31,15.38,4.94,25.61,19.74,3.31,25.51,6.92,16.4,6.69,16.59,27.86,8.8,4.42,21.37,15.51,10.07,8.6,10.49,17.21,1.2,5.4,9.51,10.85,11.92,26.64,21.21,13.7,24.25,15.95,22.42,14.02,6.74,21.74,7.62,5.24,23.34,16.71,23.12,10.86,24.95,16.05,23.99,16.02,23.69,18.38,1.58,1.71,5.72,21.3,17.77,25.65,2.84,27.55,5.85,13.87,14.71,13.99,10.06,18.91,5.73,3.07,23.83,20.73,4.58,13.13,14.68,26.24,26.47,27.22,23.72,19.53,14.03,8.7,3.97,14.78,20.83,19.45,13.13,15.79,21.64,20.75,5.24,22.22,21.3,28.85,4.84,26.46,14.28,9.17,19.88,1.2,18.89,13.24,1.28,17.65,18.2,26.18,17.12,18.43,3.57,28.97,25.59,1.12,8.87,23.36,2.5,24.49,23.4,19.36,3.48,9.37,7.38,13.52,20.94,6.23,10.27,13.78,27.57,5.4,27.55,27.06,10.57,17.93,16.38,9.46,24.58,7.19,13.73,3.16,11.16,7.05,21.34,11.95,1.08,6.79,21.23,7.49,27.18,22.67,9.94,10.17,27.93,20.11,23.43,20.69,21.66,22.62,12.6,26.25,19.41,15.33,17.56,25.48,12.56,7.24,24.47,15.94,6.97,28.07,9.15,28.42,19.94)
vars = c("V1","V2","V3","V4","V5","V6","V7","V8","V9","V10","V11","V12","V13","V14","V15","V16","V17","V18","V19","V20")
smps = c("S1","S2","S3","S4","S5","S6","S7","S8","S9","S10","S11","S12","S13","S14","S15","S16","S17","S18","S19","S20")
data = as.data.frame(matrix(vals, nrow = 20, ncol = 20, byrow = TRUE, dimnames = list(vars, smps)))

test_that("Scatter2D selectedDataPoints", {

    result <-  canvasXpress(data                    = data,
                            selectedDataPoints      = list("V1"),
                            graphType               = "Scatter2D",
                            title                   = "Scatter2D - selectedDataPoints : V1")

    check_ui_test(result)
})

test_that("Scatter3D selectedDataPoints", {

    result <-  canvasXpress(data                    = data,
                            selectedDataPoints      = list("V3", "V4"),
                            graphType               = "Scatter3D",
                            title                   = "Scatter3D - selectedDataPoints : V3,V4")

    check_ui_test(result)
})

test_that("ScatterBubble2D selectedDataPoints", {

    result <-  canvasXpress(data                    = data,
                            selectedDataPoints      = list("V5", "V8", "V10"),
                            graphType               = "ScatterBubble2D",
                            title                   = "ScatterBubble2D - selectedDataPoints : V5,V8,V10")

    check_ui_test(result)
})
