/**
 * CanvasXpress 21.6 - JavaScript Canvas Library
 * 
 * Copyright (c) 2009-2018 Isaac Neuhaus
 * 
 * imnphd@gmail.com
 * 
 * 
 * Redistributions of this source code must retain this copyright notice and the following disclaimer.
 * 
 * CanvasXpress is licensed under the terms of the Open Source GPL version 3.0 license.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * Please see a copy of the GNU General Public License at http://www.gnu.org/licenses.
 * 
 * Commercial use may be granted to the extent that this source code does NOT become part of any other Open Source or Commercially licensed development library or toolkit without explicit permission.
 * Please contact me for additional information.
 * 
 * Thanks to Mingyi Liu for his contributions with the network graphs and Charles Tilford for his input to the Genome Browser.
 * 
 */
/**
 * 
 * canvas.text.js
 * @projectDescription An cross-browser implementation of the HTML5 <canvas> text methods 
 * @author Fabien M�nager 
 * @version $Revision: 1.4 $ 
 * @license MIT License <http://www.opensource.org/licenses/mit-license.php> 
 * 
 * Known issues: 
 * - The 'light' font weight is not supported, neither is the 'oblique' font style. 
 * - Optimize the different hacks (for Opera9) 
 * 
 ****
 *
 * HeyGraph by Tom Martin
 * 
 * Copyright (c) 2010 Tom Martin
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * 
 ****
 * 
 * sprintf() for JavaScript v.0.4
 *
 * Copyright (c) 2007 Alexandru Marasteanu <http://alexei.417.ro/>
 * Thanks to David Baird (unit test and patch).
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA 02111-1307 USA
 *
 ***
 * 
 * Date Format 1.2.3
 * (c) 2007-2009 Steven Levithan <stevenlevithan.com>
 * MIT license
 *
 * Includes enhancements by Scott Trenda <scott.trenda.net>
 * and Kris Kowal <cixar.com/~kris.kowal/>
 *
 * Accepts a date, a mask, or a date and a mask.
 * Returns a formatted version of the given date.
 * The date defaults to the current date/time.
 * The mask defaults to dateFormat.masks.default.
 *
 ****
 *
 * canvas_wrapper.js
 * Canvas doesn't support getCoords() which I really need....
 * So I made a wrapper, code mostly taken from excanvas.js by Google - http://code.google.com/p/explorercanvas/
 * alias some functions to make (compiled) code shorter
 *
 ****
 *
 * conrec.js
 * Copyright (c) 2010, Jason Davies.
 *
 * All rights reserved.  This code is based on Bradley White's Java version,
 * which is in turn based on Nicholas Yue's C++ version, which in turn is based
 * on Paul D. Bourke's original Fortran version.  See below for the respective
 * copyright notices.
 *
 * See http://paulbourke.net/papers/conrec for the original
 * paper by Paul D. Bourke.
 *
 * The vector conversion code is based on http://apptree.net/conrec.htm by
 * Graham Cox.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the <organization> nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 ****
 *
 * conrec.js
 * Copyright (c) 1996-1997 Nicholas Yue
 *
 * This software is copyrighted by Nicholas Yue. This code is based on Paul D.
 * Bourke's CONREC.F routine.
 *
 * The authors hereby grant permission to use, copy, and distribute this
 * software and its documentation for any purpose, provided that existing
 * copyright notices are retained in all copies and that this notice is
 * included verbatim in any distributions. Additionally, the authors grant
 * permission to modify this software and its documentation for any purpose,
 * provided that such modifications are not distributed without the explicit
 * consent of the authors and that existing copyright notices are retained in
 * all copies. Some of the algorithms implemented by this software are
 * patented, observe all applicable patent law.
 *
 * IN NO EVENT SHALL THE AUTHORS OR DISTRIBUTORS BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE, ITS DOCUMENTATION, OR ANY DERIVATIVES THEREOF,
 * EVEN IF THE AUTHORS HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE AUTHORS AND DISTRIBUTORS SPECIFICALLY DISCLAIM ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT.  THIS SOFTWARE IS
 * PROVIDED ON AN "AS IS" BASIS, AND THE AUTHORS AND DISTRIBUTORS HAVE NO
 * OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR
 * MODIFICATIONS.
 * 
 **** 
 *
 * jLouvain.js
 * Author: Corneliu S. (github.com/upphiminn)
 * This is a javascript implementation of the Louvain
 * community detection algorithm (http://arxiv.org/abs/0803.0476)
 * Based on https://bitbucket.org/taynaud/python-louvain/overview
 * 
 ****
 * 
 * science.js
 * Copyright (c) 2011, Jason Davies
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * The name Jason Davies may not be used to endorse or promote products
 * derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL JASON DAVIES BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 ****
 *
 * Apache-Style Software License for ColorBrewer software and ColorBrewer Color
 * Schemes
 * 
 * Copyright (c) 2002 Cynthia Brewer, Mark Harrower, and The Pennsylvania State
 * University.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions as source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 * 
 * 2. The end-user documentation included with the redistribution, if any, must
 * include the following acknowledgment: "This product includes color
 * specifications and designs developed by Cynthia Brewer
 * (http://colorbrewer.org/)." Alternately, this acknowledgment may appear in the
 * software itself, if and wherever such third-party acknowledgments normally
 * appear.
 * 
 * 4. The name "ColorBrewer" must not be used to endorse or promote products
 * derived from this software without prior written permission. For written
 * permission, please contact Cynthia Brewer at cbrewer@psu.edu.
 * 
 * 5. Products derived from this software may not be called "ColorBrewer", nor
 * may "ColorBrewer" appear in their name, without prior written permission of
 * Cynthia Brewer.
 *
 ****
 * 
 * FileSaver.js
 * Copyright © 2015 [Eli Grey][1].
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is furnished
 * to do so, subject to the following conditions:
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 **** 
 * 
 * canvas-toBlob.js
 * Copyright © 2011 Eli Grey and Devin Samarin.
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is furnished
 * to do so, subject to the following conditions:
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 ****
 *
 * Blob.js
 * Copyright © 2014 Eli Grey.
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is furnished
 * to do so, subject to the following conditions:
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 ****
 *
 * jstat.js
 * Copyright (c) 2013 jStat
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * 
 ****
 *
 * numeric.js
 * Numeric Javascript
 * Copyright (C) 2011 by Sébastien Loisel
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * 
 ****
 *
 * spark-md5.js
 * Copyright (c) 2015 André Cruz <amdfcruz@gmail.com>
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the 'Software'), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED 'AS IS', WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 ****
 *
 * Sankey.js
 * Copyright (c) 2012, Michael Bostock
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * * Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 *
 * * Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 *
 * * The name Michael Bostock may not be used to endorse or promote products
 *   derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL MICHAEL BOSTOCK BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****
 *
 * canvas2svg
 * The MIT License (MIT)
 *
 * Copyright (c) 2014 Gliffy Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 ****
 *
 * genie.js
 * The MIT License (MIT)
 * 
 * Copyright (c) 2014 Kamil Pekala (kamilkp@gmail.com)
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
function str_repeat(b,a){for(var c=[];a>0;c[--a]=b){}return(c.join(""))}function sprintf(){var g=0,e,h=arguments[g++],k=[],d,j,l,b;while(h){if(d=/^[^\x25]+/.exec(h)){k.push(d[0])}else{if(d=/^\x25{2}/.exec(h)){k.push("%")}else{if(d=/^\x25(?:(\d+)\$)?(\+)?(0|'[^$])?(-)?(\d+)?(?:\.(\d+))?([b-fosuxX])/.exec(h)){if(((e=arguments[d[1]||g++])==null)||(e==undefined)){throw ("Too few arguments.")}if(/[^s]/.test(d[7])&&(typeof(e)!="number")){throw ("Expecting number but found "+typeof(e))}switch(d[7]){case"b":e=e.toString(2);break;case"c":e=String.fromCharCode(e);break;case"d":e=parseInt(e);break;case"e":e=d[6]?e.toExponential(d[6]):e.toExponential();break;case"f":e=d[6]?parseFloat(e).toFixed(d[6]):parseFloat(e);break;case"o":e=e.toString(8);break;case"s":e=((e=String(e))&&d[6]?e.substring(0,d[6]):e);break;case"u":e=Math.abs(e);break;case"x":e=e.toString(16);break;case"X":e=e.toString(16).toUpperCase();break}e=(/[def]/.test(d[7])&&d[2]&&e>0?"+"+e:e);l=d[3]?d[3]=="0"?"0":d[3].charAt(1):" ";b=d[5]-String(e).length;j=d[5]?str_repeat(l,b):"";k.push(d[4]?e+j:j+e)}else{throw ("Huh ?!")}}}h=h.substring(d[0].length)}return k.join("")};var dateFormat=function(){var a=/d{1,4}|m{1,4}|yy(?:yy)?|([HhMsTt])\1?|[LloSZ]|"[^"]*"|'[^']*'/g,b=/\b(?:[PMCEA][SDP]T|(?:Pacific|Mountain|Central|Eastern|Atlantic) (?:Standard|Daylight|Prevailing) Time|(?:GMT|UTC)(?:[-+]\d{4})?)\b/g,d=/[^-+\dA-Z]/g,c=function(f,e){f=String(f);e=e||2;while(f.length<e){f="0"+f}return f};return function(i,v,q){var g=dateFormat;if(arguments.length==1&&Object.prototype.toString.call(i)=="[object String]"&&!/\d/.test(i)){v=i;i=undefined}i=i?new Date(i):new Date;if(isNaN(i)){throw SyntaxError("invalid date")}v=String(g.masks[v]||v||g.masks["default"]);if(v.slice(0,4)=="UTC:"){v=v.slice(4);q=true}var t=q?"getUTC":"get",l=i[t+"Date"](),e=i[t+"Day"](),j=i[t+"Month"](),p=i[t+"FullYear"](),r=i[t+"Hours"](),k=i[t+"Minutes"](),u=i[t+"Seconds"](),n=i[t+"Milliseconds"](),f=q?0:i.getTimezoneOffset(),h={d:l,dd:c(l),ddd:g.i18n.dayNames[e],dddd:g.i18n.dayNames[e+7],m:j+1,mm:c(j+1),mmm:g.i18n.monthNames[j],mmmm:g.i18n.monthNames[j+12],yy:String(p).slice(2),yyyy:p,h:r%12||12,hh:c(r%12||12),H:r,HH:c(r),M:k,MM:c(k),s:u,ss:c(u),l:c(n,3),L:c(n>99?Math.round(n/10):n),t:r<12?"a":"p",tt:r<12?"am":"pm",T:r<12?"A":"P",TT:r<12?"AM":"PM",Z:q?"UTC":(String(i).match(b)||[""]).pop().replace(d,""),o:(f>0?"-":"+")+c(Math.floor(Math.abs(f)/60)*100+Math.abs(f)%60,4),S:["th","st","nd","rd"][l%10>3?0:(l%100-l%10!=10)*l%10]};return v.replace(a,function(m){return m in h?h[m]:m.slice(1,m.length-1)})}}();dateFormat.masks={"default":"ddd mmm dd yyyy HH:MM:ss",shortDate:"m/d/yy",mediumDate:"mmm d, yyyy",longDate:"mmmm d, yyyy",fullDate:"dddd, mmmm d, yyyy",shortTime:"h:MM TT",mediumTime:"h:MM:ss TT",longTime:"h:MM:ss TT Z",isoDate:"yyyy-mm-dd",isoTime:"HH:MM:ss",isoDateTime:"yyyy-mm-dd'T'HH:MM:ss",isoUtcDateTime:"UTC:yyyy-mm-dd'T'HH:MM:ss'Z'"};dateFormat.i18n={dayNames:["Sun","Mon","Tue","Wed","Thu","Fri","Sat","Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],monthNames:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec","January","February","March","April","May","June","July","August","September","October","November","December"]};Date.prototype.format=function(a,b){return dateFormat(this,a,b)};var Conrec=(function(){var d=1e-20;var c=function(h,g){var f=h.x-g.x,i=h.y-g.y;return f*f+i*i<d};var e=function(h){var f=h.head;while(f){var g=f.next;f.next=f.prev;f.prev=g;f=g}var g=h.head;h.head=h.tail;h.tail=g};var b=function(f){this.level=f;this.s=null;this.count=0};b.prototype.remove_seq=function(f){if(f.prev){f.prev.next=f.next}else{this.s=f.next}if(f.next){f.next.prev=f.prev}--this.count};b.prototype.addSegment=function(k,j){var p=this.s;var m=null;var l=null;var o=false;var n=false;while(p){if(m==null){if(c(k,p.head.p)){m=p;o=true}else{if(c(k,p.tail.p)){m=p}}}if(l==null){if(c(j,p.head.p)){l=p;n=true}else{if(c(j,p.tail.p)){l=p}}}if(l!=null&&m!=null){break}else{p=p.next}}var i=((m!=null)?1:0)|((l!=null)?2:0);switch(i){case 0:var f={p:k,prev:null};var h={p:j,next:null};f.next=h;h.prev=f;m={head:f,tail:h,next:this.s,prev:null,closed:false};if(this.s){this.s.prev=m}this.s=m;++this.count;break;case 1:var g={p:j};if(o){g.next=m.head;g.prev=null;m.head.prev=g;m.head=g}else{g.next=null;g.prev=m.tail;m.tail.next=g;m.tail=g}break;case 2:var g={p:k};if(n){g.next=l.head;g.prev=null;l.head.prev=g;l.head=g}else{g.next=null;g.prev=l.tail;l.tail.next=g;l.tail=g}break;case 3:if(m===l){var g={p:m.tail.p,next:m.head,prev:null};m.head.prev=g;m.head=g;m.closed=true;break}switch((o?1:0)|(n?2:0)){case 0:e(m);case 1:l.tail.next=m.head;m.head.prev=l.tail;l.tail=m.tail;this.remove_seq(m);break;case 3:e(m);case 2:m.tail.next=l.head;l.head.prev=m.tail;m.tail=l.tail;this.remove_seq(l);break}}};var a=function(f){if(!f){var g=this;g.contours={};this.drawContour=function(j,i,o,n,m,l){var h=g.contours[l];if(!h){h=g.contours[l]=new b(m)}h.addSegment({x:j,y:i},{x:o,y:n})};this.contourList=function(){var m=[];var j=g.contours;for(var n in j){var p=j[n].s;var q=j[n].level;while(p){var o=p.head;var i=[];i.level=q;i.k=n;while(o&&o.p){i.push(o.p);o=o.next}m.push(i);p=p.next}}m.sort(function(k,h){return h.k-k.k});return m}}else{this.drawContour=f}this.h=new Array(5);this.sh=new Array(5);this.xh=new Array(5);this.yh=new Array(5)};a.prototype.contour=function(Q,L,P,r,u,B,A,t,v){var N=this.h,S=this.sh,D=this.xh,U=this.yh;var H=this.drawContour;this.contours={};var q=function(i,h){return(N[h]*D[i]-N[i]*D[h])/(N[h]-N[i])};var R=function(i,h){return(N[h]*U[i]-N[i]*U[h])/(N[h]-N[i])};var l;var g;var f;var s;var C;var E;var O=0;var M=0;var o=0;var n=0;var w=[0,1,1,0];var K=[0,0,1,1];var p=[[[0,0,8],[0,2,5],[7,6,9]],[[0,3,4],[1,3,1],[4,3,0]],[[9,6,7],[5,2,0],[8,0,0]]];for(var I=(u-1);I>=r;I--){for(var J=L;J<=P-1;J++){var V,T;V=Math.min(Q[J][I],Q[J][I+1]);T=Math.min(Q[J+1][I],Q[J+1][I+1]);C=Math.min(V,T);V=Math.max(Q[J][I],Q[J][I+1]);T=Math.max(Q[J+1][I],Q[J+1][I+1]);E=Math.max(V,T);if(E>=v[0]&&C<=v[t-1]){for(var G=0;G<t;G++){if(v[G]>=C&&v[G]<=E){for(var F=4;F>=0;F--){if(F>0){N[F]=Q[J+w[F-1]][I+K[F-1]]-v[G];D[F]=B[J+w[F-1]];U[F]=A[I+K[F-1]]}else{N[0]=0.25*(N[1]+N[2]+N[3]+N[4]);D[0]=0.5*(B[J]+B[J+1]);U[0]=0.5*(A[I]+A[I+1])}if(N[F]>0){S[F]=1}else{if(N[F]<0){S[F]=-1}else{S[F]=0}}}for(F=1;F<=4;F++){l=F;g=0;if(F!=4){f=F+1}else{f=1}s=p[S[l]+1][S[g]+1][S[f]+1];if(s!=0){switch(s){case 1:O=D[l];o=U[l];M=D[g];n=U[g];break;case 2:O=D[g];o=U[g];M=D[f];n=U[f];break;case 3:O=D[f];o=U[f];M=D[l];n=U[l];break;case 4:O=D[l];o=U[l];M=q(g,f);n=R(g,f);break;case 5:O=D[g];o=U[g];M=q(f,l);n=R(f,l);break;case 6:O=D[f];o=U[f];M=q(l,g);n=R(l,g);break;case 7:O=q(l,g);o=R(l,g);M=q(g,f);n=R(g,f);break;case 8:O=q(g,f);o=R(g,f);M=q(f,l);n=R(f,l);break;case 9:O=q(f,l);o=R(f,l);M=q(l,g);n=R(l,g);break;default:break}H(O,o,M,n,v[G],G)}}}}}}}};return a})();if(typeof exports!=="undefined"){exports.Conrec=Conrec};(function(){jLouvain=function(){var l=-1;var k=1e-7;var i;var y;var s={};var a;function d(C){var B={};C.forEach(function(E,D){B[E]=true});return Object.keys(B)}function x(D){var C=[];for(var B in D){if(D.hasOwnProperty(B)){C.push(D[B])}}return C}function v(E,C){var B=E._assoc_mat[C]?Object.keys(E._assoc_mat[C]):[];var D=0;B.forEach(function(F,G){var H=E._assoc_mat[C][F]||1;if(C==F){H*=2}D+=H});return D}function f(D,C){if(typeof D._assoc_mat[C]=="undefined"){return[]}var B=Object.keys(D._assoc_mat[C]);return B}function g(D,C,B){return D._assoc_mat[C]?D._assoc_mat[C][B]:undefined}function A(C){var B=0;C.edges.forEach(function(D){B+=D.weight});return B}function c(D,C){e(D,C);var B=D.edges.map(function(E){return E.id1+"_"+E.id2}).indexOf(C.id1+"_"+C.id2);if(B!=-1){D.edges[B].weight=C.weight}else{D.edges.push(C)}}function z(B){var C={};B.forEach(function(E,D){E.weight=E.weight||1;C[E.id1]=C[E.id1]||{};C[E.id1][E.id2]=E.weight;C[E.id2]=C[E.id2]||{};C[E.id2][E.id1]=E.weight});return C}function e(C,B){C._assoc_mat[B.id1]=C._assoc_mat[B.id1]||{};C._assoc_mat[B.id1][B.id2]=B.weight;C._assoc_mat[B.id2]=C._assoc_mat[B.id2]||{};C._assoc_mat[B.id2][B.id1]=B.weight}function t(D){if(D==null||typeof(D)!="object"){return D}var B=D.constructor();for(var C in D){B[C]=t(D[C])}return B}function p(D,B,C){B.nodes_to_com={};B.total_weight=0;B.internals={};B.degrees={};B.gdegrees={};B.loops={};B.total_weight=A(D);if(typeof C=="undefined"){D.nodes.forEach(function(G,E){B.nodes_to_com[G]=E;var F=v(D,G);if(F<0){throw"Bad graph type, use positive weights!"}B.degrees[E]=F;B.gdegrees[G]=F;B.loops[G]=g(D,G,G)||0;B.internals[E]=B.loops[G]})}else{D.nodes.forEach(function(I,G){var E=C[I];B.nodes_to_com[I]=E;var H=v(D,I);B.degrees[E]=(B.degrees[E]||0)+H;B.gdegrees[I]=H;var J=0;var F=f(D,I);F.forEach(function(K,L){var M=D._assoc_mat[I][K];if(M<=0){throw"Bad graph type, use positive weights"}if(C[K]==E){if(K==I){J+=M}else{J+=M/2}}});B.internals[E]=(B.internals[E]||0)+J})}}function o(C){var E=C.total_weight;var B=0;var D=d(x(C.nodes_to_com));D.forEach(function(F,G){var I=C.internals[F]||0;var H=C.degrees[F]||0;if(E>0){B=B+I/E-Math.pow((H/(2*E)),2)}});return B}function m(D,E,B){var C={};var F=f(E,D);F.forEach(function(G,H){if(G!=D){var I=E._assoc_mat[D][G]||1;var J=B.nodes_to_com[G];C[J]=(C[J]||0)+I}});return C}function u(D,C,E,B){B.nodes_to_com[D]=+C;B.degrees[C]=(B.degrees[C]||0)+(B.gdegrees[D]||0);B.internals[C]=(B.internals[C]||0)+E+(B.loops[D]||0)}function r(D,C,E,B){B.degrees[C]=((B.degrees[C]||0)-(B.gdegrees[D]||0));B.internals[C]=((B.internals[C]||0)-E-(B.loops[D]||0));B.nodes_to_com[D]=-1}function j(F){var D=0;var B=t(F);var C={};var E=Object.keys(F);E.forEach(function(H){var I=F[H];var G=typeof C[I]=="undefined"?-1:C[I];if(G==-1){C[I]=D;G=D;D=D+1}B[H]=G});return B}function b(F,B){var D=true,G=0,E=o(B),C=E;while(D&&G!=l){E=C;D=false;G+=1;F.nodes.forEach(function(J,I){var M=B.nodes_to_com[J];var O=(B.gdegrees[J]||0)/(B.total_weight*2);var L=m(J,F,B);r(J,M,(L[M]||0),B);var N=M;var H=0;var K=Object.keys(L);K.forEach(function(P,Q){var R=L[P]-(B.degrees[P]||0)*O;if(R>H){H=R;N=P}});u(J,N,L[N]||0,B);if(N!=M){D=true}});C=o(B);if(C-E<k){break}}}function h(C,G){var B={nodes:[],edges:[],_assoc_mat:{}};var D,F;var E=x(C);B.nodes=B.nodes.concat(d(E));G.edges.forEach(function(I,H){F=I.weight||1;var L=C[I.id1];var J=C[I.id2];D=(g(B,L,J)||0);var K=(D+F);c(B,{source:L,target:J,weight:K})});return B}function w(C,E){var B=t(C[0]);for(var D=1;D<E+1;D++){Object.keys(B).forEach(function(H,G){var I=H;var F=B[H];B[I]=C[D][F]})}return B}function n(J,D){if(J.edges.length==0){var C={};J.nodes.forEach(function(L,K){C[L]=L});return C}var F={};p(s,F,D);var H=o(F);var I=[];b(s,F);var B=o(F);var G=j(F.nodes_to_com);I.push(G);H=B;var E=h(G,s);p(E,F);while(true){b(E,F);B=o(F);if(B-H<k){break}G=j(F.nodes_to_com);I.push(G);H=B;E=h(G,E);p(E,F)}return I}var q=function(){var B={};var C=n(s,a);return w(C,C.length-1)};q.nodes=function(B){if(arguments.length>0){i=B}return q};q.edges=function(C){if(typeof i=="undefined"){throw"Please provide the graph nodes first!"}if(arguments.length>0){y=C;var B=z(C);s={nodes:i,edges:y,_assoc_mat:B}}return q};q.partition_init=function(B){if(arguments.length>0){a=B}return q};return q}})();/*! @source http://purl.eligrey.com/github/Blob.js/blob/master/Blob.js */
(function(a){a.URL=a.URL||a.webkitURL;if(a.Blob&&a.URL){try{new Blob;return}catch(d){}}var c=a.BlobBuilder||a.WebKitBlobBuilder||a.MozBlobBuilder||(function(p){var g=function(z){return Object.prototype.toString.call(z).match(/^\[object\s(.*)\]$/)[1]},y=function m(){this.data=[]},w=function i(B,z,A){this.data=B;this.size=B.length;this.type=z;this.encoding=A},q=y.prototype,v=w.prototype,s=p.FileReaderSync,e=function(z){this.code=this[this.name=z]},r=("NOT_FOUND_ERR SECURITY_ERR ABORT_ERR NOT_READABLE_ERR ENCODING_ERR NO_MODIFICATION_ALLOWED_ERR INVALID_STATE_ERR SYNTAX_ERR").split(" "),u=r.length,l=p.URL||p.webkitURL||p,t=l.createObjectURL,f=l.revokeObjectURL,k=l,o=p.btoa,j=p.atob,h=p.ArrayBuffer,n=p.Uint8Array,x=/^[\w-]+:\/*\[?[\w\.:-]+\]?(?::[0-9]+)?/;w.fake=v.fake=true;while(u--){e.prototype[r[u]]=u+1}if(!l.createObjectURL){k=p.URL=function(A){var z=document.createElementNS("http://www.w3.org/1999/xhtml","a"),B;z.href=A;if(!("origin" in z)){if(z.protocol.toLowerCase()==="data:"){z.origin=null}else{B=A.match(x);z.origin=B&&B[1]}}return z}}k.createObjectURL=function(A){var B=A.type,z;if(B===null){B="application/octet-stream"}if(A instanceof w){z="data:"+B;if(A.encoding==="base64"){return z+";base64,"+A.data}else{if(A.encoding==="URI"){return z+","+decodeURIComponent(A.data)}}if(o){return z+";base64,"+o(A.data)}else{return z+","+encodeURIComponent(A.data)}}else{if(t){return t.call(l,A)}}};k.revokeObjectURL=function(z){if(z.substring(0,5)!=="data:"&&f){f.call(l,z)}};q.append=function(D){var F=this.data;if(n&&(D instanceof h||D instanceof n)){var E="",A=new n(D),B=0,C=A.length;for(;B<C;B++){E+=String.fromCharCode(A[B])}F.push(E)}else{if(g(D)==="Blob"||g(D)==="File"){if(s){var z=new s;F.push(z.readAsBinaryString(D))}else{throw new e("NOT_READABLE_ERR")}}else{if(D instanceof w){if(D.encoding==="base64"&&j){F.push(j(D.data))}else{if(D.encoding==="URI"){F.push(decodeURIComponent(D.data))}else{if(D.encoding==="raw"){F.push(D.data)}}}}else{if(typeof D!=="string"){D+=""}F.push(unescape(encodeURIComponent(D)))}}}};q.getBlob=function(z){if(!arguments.length){z=null}return new w(this.data.join(""),z,"raw")};q.toString=function(){return"[object BlobBuilder]"};v.slice=function(C,z,B){var A=arguments.length;if(A<3){B=null}return new w(this.data.slice(C,A>1?z:this.data.length),B,this.encoding)};v.toString=function(){return"[object Blob]"};v.close=function(){this.size=0;delete this.data};return y}(a));a.Blob=function(j,h){var l=h?(h.type||""):"";var g=new c();if(j){for(var k=0,e=j.length;k<e;k++){if(Uint8Array&&j[k] instanceof Uint8Array){g.append(j[k].buffer)}else{g.append(j[k])}}}var f=g.getBlob(l);if(!f.slice&&f.webkitSlice){f.slice=f.webkitSlice}return f};var b=Object.getPrototypeOf||function(e){return e.__proto__};a.Blob.prototype=b(new a.Blob())}(typeof self!=="undefined"&&self||typeof window!=="undefined"&&window||this.content||this));
/*! @source http://purl.eligrey.com/github/canvas-toBlob.js/blob/master/canvas-toBlob.js */
(function(a){var b=a.Uint8Array,d=a.HTMLCanvasElement,c=d&&d.prototype,e=/\s*;\s*base64\s*(?:;|$)/i,f="toDataURL",h,g=function(p){var q=p.length,m=new b(q/4*3|0),o=0,s=0,t=[0,0],j=0,r=0,n,k,l;while(q--){k=p.charCodeAt(o++);n=h[k-43];if(n!==255&&n!==l){t[1]=t[0];t[0]=k;r=(r<<6)|n;j++;if(j===4){m[s++]=r>>>16;if(t[1]!==61){m[s++]=r>>>8}if(t[0]!==61){m[s++]=r}j=0}}}return m};if(b){h=new b([62,-1,-1,-1,63,52,53,54,55,56,57,58,59,60,61,-1,-1,-1,0,-1,-1,-1,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,-1,-1,-1,-1,-1,-1,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51])}if(d&&(!c.toBlob||!c.toBlobHD)){if(!c.toBlob){c.toBlob=function(p,n){if(!n){n="image/png"}if(this.mozGetAsFile){p(this.mozGetAsFile("canvas",n));return}if(this.msToBlob&&/^\s*image\/png\s*(?:$|;)/i.test(n)){p(this.msToBlob());return}var m=Array.prototype.slice.call(arguments,1),k=this[f].apply(this,m),j=k.indexOf(","),o=k.substring(j+1),i=e.test(k.substring(0,j)),l;if(Blob.fake){l=new Blob;if(i){l.encoding="base64"}else{l.encoding="URI"}l.data=o;l.size=o.length}else{if(b){if(i){l=new Blob([g(o)],{type:n})}else{l=new Blob([decodeURIComponent(o)],{type:n})}}}p(l)}}if(!c.toBlobHD&&c.toDataURLHD){c.toBlobHD=function(){f="toDataURLHD";var i=this.toBlob();f="toDataURL";return i}}else{c.toBlobHD=c.toBlob}}}(typeof self!=="undefined"&&self||typeof window!=="undefined"&&window||this.content||this));
/*! @source http://purl.eligrey.com/github/FileSaver.js/blob/master/FileSaver.js */
;var saveAs=saveAs||(function(g){if(typeof navigator!=="undefined"&&/MSIE [1-9]\./.test(navigator.userAgent)){return}var r=g.document,l=function(){return g.URL||g.webkitURL||g},n=r.createElementNS("http://www.w3.org/1999/xhtml","a"),e="download" in n,j=function(t){var s=r.createEvent("MouseEvents");s.initMouseEvent("click",true,false,g,0,0,0,0,0,false,false,false,false,0,null);t.dispatchEvent(s)},o=g.webkitRequestFileSystem,p=g.requestFileSystem||o||g.mozRequestFileSystem,m=function(s){(g.setImmediate||g.setTimeout)(function(){throw s},0)},b="application/octet-stream",k=0,h=500,i=function(t){var s=function(){if(typeof t==="string"){l().revokeObjectURL(t)}else{t.remove()}};if(g.chrome){s()}else{setTimeout(s,h)}},q=function(t,s,w){s=[].concat(s);var v=s.length;while(v--){var x=t["on"+s[v]];if(typeof x==="function"){try{x.call(t,w||t)}catch(u){m(u)}}}},f=function(s){if(/^\s*(?:text\/\S*|application\/xml|\S*\/\S*\+xml)\s*;.*charset\s*=\s*utf-8/i.test(s.type)){return new Blob(["\ufeff",s],{type:s.type})}return s},d=function(s,t){s=f(s);var u=this,A=s.type,D=false,w,v,z=function(){q(u,"writestart progress write writeend".split(" "))},C=function(){if(D||!w){w=l().createObjectURL(s)}if(v){v.location.href=w}else{var E=g.open(w,"_blank");if(E==undefined&&typeof safari!=="undefined"){g.location.href=w}}u.readyState=u.DONE;z();i(w)},y=function(E){return function(){if(u.readyState!==u.DONE){return E.apply(this,arguments)}}},x={create:true,exclusive:false},B;u.readyState=u.INIT;if(!t){t="download"}if(e){w=l().createObjectURL(s);n.href=w;n.download=t;j(n);u.readyState=u.DONE;z();i(w);return}if(g.chrome&&A&&A!==b){B=s.slice||s.webkitSlice;s=B.call(s,0,s.size,b);D=true}if(o&&t!=="download"){t+=".download"}if(A===b||o){v=g}if(!p){C();return}k+=s.size;p(g.TEMPORARY,k,y(function(E){E.root.getDirectory("saved",x,y(function(F){var G=function(){F.getFile(t,x,y(function(H){H.createWriter(y(function(I){I.onwriteend=function(J){v.location.href=H.toURL();u.readyState=u.DONE;q(u,"writeend",J);i(H)};I.onerror=function(){var J=I.error;if(J.code!==J.ABORT_ERR){C()}};"writestart progress write abort".split(" ").forEach(function(J){I["on"+J]=u["on"+J]});I.write(s);u.abort=function(){I.abort();u.readyState=u.DONE};u.readyState=u.WRITING}),C)}),C)};F.getFile(t,{create:false},y(function(H){H.remove();G()}),y(function(H){if(H.code===H.NOT_FOUND_ERR){G()}else{C()}}))}),C)}),C)},c=d.prototype,a=function(s,t){return new d(s,t)};if(typeof navigator!=="undefined"&&navigator.msSaveOrOpenBlob){return function(s,t){return navigator.msSaveOrOpenBlob(f(s),t)}}c.abort=function(){var s=this;s.readyState=s.DONE;q(s,"abort")};c.readyState=c.INIT=0;c.WRITING=1;c.DONE=2;c.error=c.onwritestart=c.onprogress=c.onwrite=c.onabort=c.onerror=c.onwriteend=null;return a}(typeof self!=="undefined"&&self||typeof window!=="undefined"&&window||this.content));if(typeof module!=="undefined"&&module.exports){module.exports.saveAs=saveAs}else{if((typeof define!=="undefined"&&define!==null)&&(define.amd!=null)){define([],function(){return saveAs})}};"use strict";var numeric=(typeof exports==="undefined")?(function numeric(){}):(exports);if(typeof global!=="undefined"){global.numeric=numeric}numeric.version="1.2.6";numeric._myIndexOf=(function _myIndexOf(a){var c=this.length,b;for(b=0;b<c;++b){if(this[b]===a){return b}}return -1});numeric.myIndexOf=(Array.prototype.indexOf)?Array.prototype.indexOf:numeric._myIndexOf;numeric.Function=Function;numeric.precision=4;numeric.largeArray=50;numeric._dim=function _dim(a){var b=[];while(typeof a==="object"){b.push(a.length);a=a[0]}return b};numeric.dim=function dim(a){var c,b;if(typeof a==="object"){c=a[0];if(typeof c==="object"){b=c[0];if(typeof b==="object"){return numeric._dim(a)}return[a.length,c.length]}return[a.length]}return[]};numeric.mapreduce=function mapreduce(a,b){return Function("x","accum","_s","_k",'if(typeof accum === "undefined") accum = '+b+';\nif(typeof x === "number") { var xi = x; '+a+'; return accum; }\nif(typeof _s === "undefined") _s = numeric.dim(x);\nif(typeof _k === "undefined") _k = 0;\nvar _n = _s[_k];\nvar i,xi;\nif(_k < _s.length-1) {\n    for(i=_n-1;i>=0;i--) {\n        accum = arguments.callee(x[i],accum,_s,_k+1);\n    }    return accum;\n}\nfor(i=_n-1;i>=1;i-=2) { \n    xi = x[i];\n    '+a+";\n    xi = x[i-1];\n    "+a+";\n}\nif(i === 0) {\n    xi = x[i];\n    "+a+"\n}\nreturn accum;")};numeric.mapreduce2=function mapreduce2(b,a){return Function("x","var n = x.length;\nvar i,xi;\n"+a+";\nfor(i=n-1;i!==-1;--i) { \n    xi = x[i];\n    "+b+";\n}\nreturn accum;")};numeric.same=function same(a,d){var b,c;if(!(a instanceof Array)||!(d instanceof Array)){return false}c=a.length;if(c!==d.length){return false}for(b=0;b<c;b++){if(a[b]===d[b]){continue}if(typeof a[b]==="object"){if(!same(a[b],d[b])){return false}}else{return false}}return true};numeric.rep=function rep(e,b,a){if(typeof a==="undefined"){a=0}var f=e[a],c=Array(f),d;if(a===e.length-1){for(d=f-2;d>=0;d-=2){c[d+1]=b;c[d]=b}if(d===-1){c[0]=b}return c}for(d=f-1;d>=0;d--){c[d]=numeric.rep(e,b,a+1)}return c};numeric.dotMMsmall=function dotMMsmall(v,u){var l,g,e,c,b,a,n,s,m,h,f,o,w,d;c=v.length;b=u.length;a=u[0].length;n=Array(c);for(l=c-1;l>=0;l--){s=Array(a);m=v[l];for(e=a-1;e>=0;e--){h=m[b-1]*u[b-1][e];for(g=b-2;g>=1;g-=2){f=g-1;h+=m[g]*u[g][e]+m[f]*u[f][e]}if(g===0){h+=m[0]*u[0][e]}s[e]=h}n[l]=s}return n};numeric._getCol=function _getCol(b,c,a){var e=b.length,d;for(d=e-1;d>0;--d){a[d]=b[d][c];--d;a[d]=b[d][c]}if(d===0){a[0]=b[0][c]}};numeric.dotMMbig=function dotMMbig(r,q){var s=numeric._getCol,a=q.length,u=Array(a);var d=r.length,c=q[0].length,b=new Array(d),l;var f=numeric.dotVV;var h,g,e,o;--a;--d;for(h=d;h!==-1;--h){b[h]=Array(c)}--c;for(h=c;h!==-1;--h){s(q,h,u);for(g=d;g!==-1;--g){o=0;l=r[g];b[g][h]=f(l,u)}}return b};numeric.dotMV=function dotMV(a,g){var e=a.length,d=g.length,c;var b=Array(e),f=numeric.dotVV;for(c=e-1;c>=0;c--){b[c]=f(a[c],g)}return b};numeric.dotVM=function dotVM(h,g){var w,v,u,n,m,l,D,B,A,e,s,f,c,z,d,b,a,o,C;n=h.length;m=g[0].length;D=Array(m);for(u=m-1;u>=0;u--){e=h[n-1]*g[n-1][u];for(v=n-2;v>=1;v-=2){s=v-1;e+=h[v]*g[v][u]+h[s]*g[s][u]}if(v===0){e+=h[0]*g[0][u]}D[u]=e}return D};numeric.dotVV=function dotVV(a,f){var c,e=a.length,d,b=a[e-1]*f[e-1];for(c=e-2;c>=1;c-=2){d=c-1;b+=a[c]*f[c]+a[d]*f[d]}if(c===0){b+=a[0]*f[0]}return b};numeric.dot=function dot(a,c){var b=numeric.dim;switch(b(a).length*1000+b(c).length){case 2002:if(c.length<10){return numeric.dotMMsmall(a,c)}else{return numeric.dotMMbig(a,c)}case 2001:return numeric.dotMV(a,c);case 1002:return numeric.dotVM(a,c);case 1001:return numeric.dotVV(a,c);case 1000:return numeric.mulVS(a,c);case 1:return numeric.mulSV(a,c);case 0:return a*c;default:throw new Error("numeric.dot only works on vectors and matrices")}};numeric.diag=function diag(g){var e,f,c,h=g.length,a=Array(h),b;for(e=h-1;e>=0;e--){b=Array(h);f=e+2;for(c=h-1;c>=f;c-=2){b[c]=0;b[c-1]=0}if(c>e){b[c]=0}b[e]=g[e];for(c=e-1;c>=1;c-=2){b[c]=0;b[c-1]=0}if(c===0){b[0]=0}a[e]=b}return a};numeric.getDiag=function(a){var d=Math.min(a.length,a[0].length),c,b=Array(d);for(c=d-1;c>=1;--c){b[c]=a[c][c];--c;b[c]=a[c][c]}if(c===0){b[0]=a[0][0]}return b};numeric.identity=function identity(a){return numeric.diag(numeric.rep([a],1))};numeric.pointwise2=function pointwise2(d,g,c){if(typeof c==="undefined"){c=""}var h=[];var e;var i=/\[i\]$/,a,f="";var b=false;for(e=0;e<d.length;e++){if(i.test(d[e])){a=d[e].substring(0,d[e].length-3);f=a}else{a=d[e]}if(a==="ret"){b=true}h.push(a)}h[d.length]=("var _n = "+f+".length;\nvar i"+(b?"":", ret = Array(_n)")+";\n"+c+"\nfor(i=_n-1;i!==-1;--i) {\n"+g+"\n}\nreturn ret;");return Function.apply(null,h)};numeric._biforeach=(function _biforeach(a,h,d,b,e){if(b===d.length-1){e(a,h);return}var c,g=d[b];for(c=g-1;c>=0;c--){_biforeach(typeof a==="object"?a[c]:a,typeof h==="object"?h[c]:h,d,b+1,e)}});numeric._biforeach2=(function _biforeach2(a,j,e,b,g){if(b===e.length-1){return g(a,j)}var d,h=e[b],c=Array(h);for(d=h-1;d>=0;--d){c[d]=_biforeach2(typeof a==="object"?a[d]:a,typeof j==="object"?j[d]:j,e,b+1,g)}return c});numeric._foreach=(function _foreach(a,d,b,e){if(b===d.length-1){e(a);return}var c,g=d[b];for(c=g-1;c>=0;c--){_foreach(a[c],d,b+1,e)}});numeric._foreach2=(function _foreach2(a,e,b,g){if(b===e.length-1){return g(a)}var d,h=e[b],c=Array(h);for(d=h-1;d>=0;d--){c[d]=_foreach2(a[d],e,b+1,g)}return c});numeric.ops2={add:"+",sub:"-",mul:"*",div:"/",mod:"%",and:"&&",or:"||",eq:"===",neq:"!==",lt:"<",gt:">",leq:"<=",geq:">=",band:"&",bor:"|",bxor:"^",lshift:"<<",rshift:">>",rrshift:">>>"};numeric.opseq={addeq:"+=",subeq:"-=",muleq:"*=",diveq:"/=",modeq:"%=",lshifteq:"<<=",rshifteq:">>=",rrshifteq:">>>=",bandeq:"&=",boreq:"|=",bxoreq:"^="};numeric.mathfuns=["abs","acos","asin","atan","ceil","cos","exp","floor","log","round","sin","sqrt","tan","isNaN","isFinite"];numeric.mathfuns2=["atan2","pow","max","min"];numeric.ops1={neg:"-",not:"!",bnot:"~",clone:""};numeric.mapreducers={any:["if(xi) return true;","var accum = false;"],all:["if(!xi) return false;","var accum = true;"],sum:["accum += xi;","var accum = 0;"],prod:["accum *= xi;","var accum = 1;"],norm2Squared:["accum += xi*xi;","var accum = 0;"],norminf:["accum = max(accum,abs(xi));","var accum = 0, max = Math.max, abs = Math.abs;"],norm1:["accum += abs(xi)","var accum = 0, abs = Math.abs;"],sup:["accum = max(accum,xi);","var accum = -Infinity, max = Math.max;"],inf:["accum = min(accum,xi);","var accum = Infinity, min = Math.min;"]};(function(){var b,e;for(b=0;b<numeric.mathfuns2.length;++b){e=numeric.mathfuns2[b];numeric.ops2[e]=e}for(b in numeric.ops2){if(numeric.ops2.hasOwnProperty(b)){e=numeric.ops2[b];var c,d,a="";if(numeric.myIndexOf.call(numeric.mathfuns2,b)!==-1){a="var "+e+" = Math."+e+";\n";c=function(g,f,h){return g+" = "+e+"("+f+","+h+")"};d=function(f,g){return f+" = "+e+"("+f+","+g+")"}}else{c=function(g,f,h){return g+" = "+f+" "+e+" "+h};if(numeric.opseq.hasOwnProperty(b+"eq")){d=function(f,g){return f+" "+e+"= "+g}}else{d=function(f,g){return f+" = "+f+" "+e+" "+g}}}numeric[b+"VV"]=numeric.pointwise2(["x[i]","y[i]"],c("ret[i]","x[i]","y[i]"),a);numeric[b+"SV"]=numeric.pointwise2(["x","y[i]"],c("ret[i]","x","y[i]"),a);numeric[b+"VS"]=numeric.pointwise2(["x[i]","y"],c("ret[i]","x[i]","y"),a);numeric[b]=Function("var n = arguments.length, i, x = arguments[0], y;\nvar VV = numeric."+b+"VV, VS = numeric."+b+"VS, SV = numeric."+b+'SV;\nvar dim = numeric.dim;\nfor(i=1;i!==n;++i) { \n  y = arguments[i];\n  if(typeof x === "object") {\n      if(typeof y === "object") x = numeric._biforeach2(x,y,dim(x),0,VV);\n      else x = numeric._biforeach2(x,y,dim(x),0,VS);\n  } else if(typeof y === "object") x = numeric._biforeach2(x,y,dim(y),0,SV);\n  else '+d("x","y")+"\n}\nreturn x;\n");numeric[e]=numeric[b];numeric[b+"eqV"]=numeric.pointwise2(["ret[i]","x[i]"],d("ret[i]","x[i]"),a);numeric[b+"eqS"]=numeric.pointwise2(["ret[i]","x"],d("ret[i]","x"),a);numeric[b+"eq"]=Function("var n = arguments.length, i, x = arguments[0], y;\nvar V = numeric."+b+"eqV, S = numeric."+b+'eqS\nvar s = numeric.dim(x);\nfor(i=1;i!==n;++i) { \n  y = arguments[i];\n  if(typeof y === "object") numeric._biforeach(x,y,s,0,V);\n  else numeric._biforeach(x,y,s,0,S);\n}\nreturn x;\n')}}for(b=0;b<numeric.mathfuns2.length;++b){e=numeric.mathfuns2[b];delete numeric.ops2[e]}for(b=0;b<numeric.mathfuns.length;++b){e=numeric.mathfuns[b];numeric.ops1[e]=e}for(b in numeric.ops1){if(numeric.ops1.hasOwnProperty(b)){a="";e=numeric.ops1[b];if(numeric.myIndexOf.call(numeric.mathfuns,b)!==-1){if(Math.hasOwnProperty(e)){a="var "+e+" = Math."+e+";\n"}}numeric[b+"eqV"]=numeric.pointwise2(["ret[i]"],"ret[i] = "+e+"(ret[i]);",a);numeric[b+"eq"]=Function("x",'if(typeof x !== "object") return '+e+"x\nvar i;\nvar V = numeric."+b+"eqV;\nvar s = numeric.dim(x);\nnumeric._foreach(x,s,0,V);\nreturn x;\n");numeric[b+"V"]=numeric.pointwise2(["x[i]"],"ret[i] = "+e+"(x[i]);",a);numeric[b]=Function("x",'if(typeof x !== "object") return '+e+"(x)\nvar i;\nvar V = numeric."+b+"V;\nvar s = numeric.dim(x);\nreturn numeric._foreach2(x,s,0,V);\n")}}for(b=0;b<numeric.mathfuns.length;++b){e=numeric.mathfuns[b];delete numeric.ops1[e]}for(b in numeric.mapreducers){if(numeric.mapreducers.hasOwnProperty(b)){e=numeric.mapreducers[b];numeric[b+"V"]=numeric.mapreduce2(e[0],e[1]);numeric[b]=Function("x","s","k",e[1]+'if(typeof x !== "object") {    xi = x;\n'+e[0]+';\n    return accum;\n}if(typeof s === "undefined") s = numeric.dim(x);\nif(typeof k === "undefined") k = 0;\nif(k === s.length-1) return numeric.'+b+"V(x);\nvar xi;\nvar n = x.length, i;\nfor(i=n-1;i!==-1;--i) {\n   xi = arguments.callee(x[i]);\n"+e[0]+";\n}\nreturn accum;\n")}}}());numeric.inv=function inv(o){var v=numeric.dim(o),w=Math.abs,d=v[0],c=v[1];var b=numeric.clone(o),q,l;var p=numeric.identity(d),a,u;var h,g,e,o;for(g=0;g<c;++g){var f=-1;var r=-1;for(h=g;h!==d;++h){e=w(b[h][g]);if(e>r){f=h;r=e}}l=b[f];b[f]=b[g];b[g]=l;u=p[f];p[f]=p[g];p[g]=u;o=l[g];for(e=g;e!==c;++e){l[e]/=o}for(e=c-1;e!==-1;--e){u[e]/=o}for(h=d-1;h!==-1;--h){if(h!==g){q=b[h];a=p[h];o=q[g];for(e=g+1;e!==c;++e){q[e]-=l[e]*o}for(e=c-1;e>0;--e){a[e]-=u[e]*o;--e;a[e]-=u[e]*o}if(e===0){a[0]-=u[0]*o}}}}return p};numeric.det=function det(p){var u=numeric.dim(p);if(u.length!==2||u[0]!==u[1]){throw new Error("numeric: det() only works on square matrices")}var b=u[0],l=1,f,e,d,a=numeric.clone(p),o,q,c,r,m,h,g;for(e=0;e<b-1;e++){d=e;for(f=e+1;f<b;f++){if(Math.abs(a[f][e])>Math.abs(a[d][e])){d=f}}if(d!==e){r=a[d];a[d]=a[e];a[e]=r;l*=-1}o=a[e];for(f=e+1;f<b;f++){q=a[f];c=q[e]/o[e];for(d=e+1;d<b-1;d+=2){m=d+1;q[d]-=o[d]*c;q[m]-=o[m]*c}if(d!==b){q[d]-=o[d]*c}}if(o[e]===0){return 0}l*=o[e]}return l*a[e][e]};numeric.transpose=function transpose(k){var g,e,c=k.length,a=k[0].length,h=Array(a),d,b,f;for(e=0;e<a;e++){h[e]=Array(c)}for(g=c-1;g>=1;g-=2){b=k[g];d=k[g-1];for(e=a-1;e>=1;--e){f=h[e];f[g]=b[e];f[g-1]=d[e];--e;f=h[e];f[g]=b[e];f[g-1]=d[e]}if(e===0){f=h[0];f[g]=b[0];f[g-1]=d[0]}}if(g===0){d=k[0];for(e=a-1;e>=1;--e){h[e][0]=d[e];--e;h[e][0]=d[e]}if(e===0){h[0][0]=d[0]}}return h};numeric.negtranspose=function negtranspose(k){var g,e,c=k.length,a=k[0].length,h=Array(a),d,b,f;for(e=0;e<a;e++){h[e]=Array(c)}for(g=c-1;g>=1;g-=2){b=k[g];d=k[g-1];for(e=a-1;e>=1;--e){f=h[e];f[g]=-b[e];f[g-1]=-d[e];--e;f=h[e];f[g]=-b[e];f[g-1]=-d[e]}if(e===0){f=h[0];f[g]=-b[0];f[g-1]=-d[0]}}if(g===0){d=k[0];for(e=a-1;e>=1;--e){h[e][0]=-d[e];--e;h[e][0]=-d[e]}if(e===0){h[0][0]=-d[0]}}return h};numeric.norm2=function norm2(a){return Math.sqrt(numeric.norm2Squared(a))};numeric.getBlock=function getBlock(a,e,d){var b=numeric.dim(a);function c(f,h){var l,g=e[h],m=d[h]-g,j=Array(m);if(h===b.length-1){for(l=m;l>=0;l--){j[l]=f[l+g]}return j}for(l=m;l>=0;l--){j[l]=c(f[l+g],h+1)}return j}return c(a,0)};numeric.setBlock=function setBlock(a,f,e,d){var b=numeric.dim(a);function c(g,o,j){var l,h=f[j],m=e[j]-h;if(j===b.length-1){for(l=m;l>=0;l--){g[l+h]=o[l]}}for(l=m;l>=0;l--){c(g[l+h],o[l],j+1)}}c(a,d,0);return a};numeric.getRange=function getRange(b,l,k){var e=l.length,d=k.length;var g,f;var a=Array(e),h,c;for(g=e-1;g!==-1;--g){a[g]=Array(d);h=a[g];c=b[l[g]];for(f=d-1;f!==-1;--f){h[f]=c[k[f]]}}return a};numeric.tensor=function tensor(h,g){if(typeof h==="number"||typeof g==="number"){return numeric.mul(h,g)}var o=numeric.dim(h),k=numeric.dim(g);if(o.length!==1||k.length!==1){throw new Error("numeric: tensor product is only defined for vectors")}var c=o[0],b=k[0],a=Array(c),l,e,d,f;for(e=c-1;e>=0;e--){l=Array(b);f=h[e];for(d=b-1;d>=3;--d){l[d]=f*g[d];--d;l[d]=f*g[d];--d;l[d]=f*g[d];--d;l[d]=f*g[d]}while(d>=0){l[d]=f*g[d];--d}a[e]=l}return a};numeric.T=function T(a,b){this.x=a;this.y=b};numeric.t=function t(a,b){return new numeric.T(a,b)};numeric.Tbinop=function Tbinop(c,e,d,g,a){var f=numeric.indexOf;if(typeof a!=="string"){var b;a="";for(b in numeric){if(numeric.hasOwnProperty(b)&&(c.indexOf(b)>=0||e.indexOf(b)>=0||d.indexOf(b)>=0||g.indexOf(b)>=0)&&b.length>1){a+="var "+b+" = numeric."+b+";\n"}}}return Function(["y"],"var x = this;\nif(!(y instanceof numeric.T)) { y = new numeric.T(y); }\n"+a+"\nif(x.y) {  if(y.y) {    return new numeric.T("+g+");\n  }\n  return new numeric.T("+d+");\n}\nif(y.y) {\n  return new numeric.T("+e+");\n}\nreturn new numeric.T("+c+");\n")};numeric.T.prototype.add=numeric.Tbinop("add(x.x,y.x)","add(x.x,y.x),y.y","add(x.x,y.x),x.y","add(x.x,y.x),add(x.y,y.y)");numeric.T.prototype.sub=numeric.Tbinop("sub(x.x,y.x)","sub(x.x,y.x),neg(y.y)","sub(x.x,y.x),x.y","sub(x.x,y.x),sub(x.y,y.y)");numeric.T.prototype.mul=numeric.Tbinop("mul(x.x,y.x)","mul(x.x,y.x),mul(x.x,y.y)","mul(x.x,y.x),mul(x.y,y.x)","sub(mul(x.x,y.x),mul(x.y,y.y)),add(mul(x.x,y.y),mul(x.y,y.x))");numeric.T.prototype.reciprocal=function reciprocal(){var a=numeric.mul,c=numeric.div;if(this.y){var b=numeric.add(a(this.x,this.x),a(this.y,this.y));return new numeric.T(c(this.x,b),c(numeric.neg(this.y),b))}return new T(c(1,this.x))};numeric.T.prototype.div=function div(b){if(!(b instanceof numeric.T)){b=new numeric.T(b)}if(b.y){return this.mul(b.reciprocal())}var a=numeric.div;if(this.y){return new numeric.T(a(this.x,b.x),a(this.y,b.x))}return new numeric.T(a(this.x,b.x))};numeric.T.prototype.dot=numeric.Tbinop("dot(x.x,y.x)","dot(x.x,y.x),dot(x.x,y.y)","dot(x.x,y.x),dot(x.y,y.x)","sub(dot(x.x,y.x),dot(x.y,y.y)),add(dot(x.x,y.y),dot(x.y,y.x))");numeric.T.prototype.transpose=function transpose(){var b=numeric.transpose,a=this.x,c=this.y;if(c){return new numeric.T(b(a),b(c))}return new numeric.T(b(a))};numeric.T.prototype.transjugate=function transjugate(){var b=numeric.transpose,a=this.x,c=this.y;if(c){return new numeric.T(b(a),numeric.negtranspose(c))}return new numeric.T(b(a))};numeric.Tunop=function Tunop(b,d,a){if(typeof a!=="string"){a=""}return Function("var x = this;\n"+a+"\nif(x.y) {  "+d+";\n}\n"+b+";\n")};numeric.T.prototype.exp=numeric.Tunop("return new numeric.T(ex)","return new numeric.T(mul(cos(x.y),ex),mul(sin(x.y),ex))","var ex = numeric.exp(x.x), cos = numeric.cos, sin = numeric.sin, mul = numeric.mul;");numeric.T.prototype.conj=numeric.Tunop("return new numeric.T(x.x);","return new numeric.T(x.x,numeric.neg(x.y));");numeric.T.prototype.neg=numeric.Tunop("return new numeric.T(neg(x.x));","return new numeric.T(neg(x.x),neg(x.y));","var neg = numeric.neg;");numeric.T.prototype.sin=numeric.Tunop("return new numeric.T(numeric.sin(x.x))","return x.exp().sub(x.neg().exp()).div(new numeric.T(0,2));");numeric.T.prototype.cos=numeric.Tunop("return new numeric.T(numeric.cos(x.x))","return x.exp().add(x.neg().exp()).div(2);");numeric.T.prototype.abs=numeric.Tunop("return new numeric.T(numeric.abs(x.x));","return new numeric.T(numeric.sqrt(numeric.add(mul(x.x,x.x),mul(x.y,x.y))));","var mul = numeric.mul;");numeric.T.prototype.log=numeric.Tunop("return new numeric.T(numeric.log(x.x));","var theta = new numeric.T(numeric.atan2(x.y,x.x)), r = x.abs();\nreturn new numeric.T(numeric.log(r.x),theta.x);");numeric.T.prototype.norm2=numeric.Tunop("return numeric.norm2(x.x);","var f = numeric.norm2Squared;\nreturn Math.sqrt(f(x.x)+f(x.y));");numeric.T.prototype.get=function get(d){var a=this.x,f=this.y,b=0,c,e=d.length;if(f){while(b<e){c=d[b];a=a[c];f=f[c];b++}return new numeric.T(a,f)}while(b<e){c=d[b];a=a[c];b++}return new numeric.T(a)};numeric.T.prototype.set=function set(c,j){var g=this.x,e=this.y,b=0,h,a=c.length,f=j.x,d=j.y;if(a===0){if(d){this.y=d}else{if(e){this.y=undefined}}this.x=g;return this}if(d){if(e){}else{e=numeric.rep(numeric.dim(g),0);this.y=e}while(b<a-1){h=c[b];g=g[h];e=e[h];b++}h=c[b];g[h]=f;e[h]=d;return this}if(e){while(b<a-1){h=c[b];g=g[h];e=e[h];b++}h=c[b];g[h]=f;if(f instanceof Array){e[h]=numeric.rep(numeric.dim(f),0)}else{e[h]=0}return this}while(b<a-1){h=c[b];g=g[h];b++}h=c[b];g[h]=f;return this};numeric.T.prototype.getRows=function getRows(e,c){var h=c-e+1,b;var f=Array(h),d,a=this.x,g=this.y;for(b=e;b<=c;b++){f[b-e]=a[b]}if(g){d=Array(h);for(b=e;b<=c;b++){d[b-e]=g[b]}return new numeric.T(f,d)}return new numeric.T(f)};numeric.T.prototype.setRows=function setRows(f,d,b){var c;var g=this.x,e=this.y,a=b.x,h=b.y;for(c=f;c<=d;c++){g[c]=a[c-f]}if(h){if(!e){e=numeric.rep(numeric.dim(g),0);this.y=e}for(c=f;c<=d;c++){e[c]=h[c-f]}}else{if(e){for(c=f;c<=d;c++){e[c]=numeric.rep([a[c-f].length],0)}}}return this};numeric.T.prototype.getRow=function getRow(b){var a=this.x,c=this.y;if(c){return new numeric.T(a[b],c[b])}return new numeric.T(a[b])};numeric.T.prototype.setRow=function setRow(c,b){var e=this.x,d=this.y,a=b.x,f=b.y;e[c]=a;if(f){if(!d){d=numeric.rep(numeric.dim(e),0);this.y=d}d[c]=f}else{if(d){d=numeric.rep([a.length],0)}}return this};numeric.T.prototype.getBlock=function getBlock(f,e){var c=this.x,d=this.y,a=numeric.getBlock;if(d){return new numeric.T(a(c,f,e),a(d,f,e))}return new numeric.T(a(c,f,e))};numeric.T.prototype.setBlock=function setBlock(i,h,d){if(!(d instanceof numeric.T)){d=new numeric.T(d)}var c=this.x,g=this.y,a=numeric.setBlock,f=d.x,e=d.y;if(e){if(!g){this.y=numeric.rep(numeric.dim(this),0);g=this.y}a(c,i,h,f);a(g,i,h,e);return this}a(c,i,h,f);if(g){a(g,i,h,numeric.rep(numeric.dim(f),0))}};numeric.T.rep=function rep(d,b){var c=numeric.T;if(!(b instanceof c)){b=new c(b)}var a=b.x,f=b.y,e=numeric.rep;if(f){return new c(e(d,a),e(d,f))}return new c(e(d,a))};numeric.T.diag=function diag(c){if(!(c instanceof numeric.T)){c=new numeric.T(c)}var a=c.x,e=c.y,b=numeric.diag;if(e){return new numeric.T(b(a),b(e))}return new numeric.T(b(a))};numeric.T.eig=function eig(){if(this.y){throw new Error("eig: not implemented for complex matrices.")}return numeric.eig(this.x)};numeric.T.identity=function identity(a){return new numeric.T(numeric.identity(a))};numeric.T.prototype.getDiag=function getDiag(){var c=numeric;var a=this.x,b=this.y;if(b){return new c.T(c.getDiag(a),c.getDiag(b))}return new c.T(c.getDiag(a))};numeric.house=function house(a){var b=numeric.clone(a);var c=a[0]>=0?1:-1;var d=c*numeric.norm2(a);b[0]+=d;var e=numeric.norm2(b);if(e===0){throw new Error("eig: internal error")}return numeric.div(b,e)};numeric.toUpperHessenberg=function toUpperHessenberg(o){var u=numeric.dim(o);if(u.length!==2||u[0]!==u[1]){throw new Error("numeric: toUpperHessenberg() only works on square matrices")}var f=u[0],l,h,g,p,r,d=numeric.clone(o),c,a,q,b,n=numeric.identity(f),e;for(h=0;h<f-2;h++){p=Array(f-h-1);for(l=h+1;l<f;l++){p[l-h-1]=d[l][h]}if(numeric.norm2(p)>0){r=numeric.house(p);c=numeric.getBlock(d,[h+1,h],[f-1,f-1]);a=numeric.tensor(r,numeric.dot(r,c));for(l=h+1;l<f;l++){q=d[l];b=a[l-h-1];for(g=h;g<f;g++){q[g]-=2*b[g-h]}}c=numeric.getBlock(d,[0,h+1],[f-1,f-1]);a=numeric.tensor(numeric.dot(c,r),r);for(l=0;l<f;l++){q=d[l];b=a[l];for(g=h+1;g<f;g++){q[g]-=2*b[g-h-1]}}c=Array(f-h-1);for(l=h+1;l<f;l++){c[l-h-1]=n[l]}a=numeric.tensor(r,numeric.dot(r,c));for(l=h+1;l<f;l++){e=n[l];b=a[l-h-1];for(g=0;g<f;g++){e[g]-=2*b[g]}}}}return{H:d,Q:n}};numeric.epsilon=2.220446049250313e-16;numeric.QRFrancis=function(z,h){if(typeof h==="undefined"){h=10000}z=numeric.clone(z);var D=numeric.clone(z);var E=numeric.dim(z),K=E[0],y,A,U,S,R,P,n,e,l,q=numeric.identity(K),u,r,I,G,F,O,M,L,N;if(K<3){return{Q:q,B:[[0,K-1]]}}var V=numeric.epsilon;for(N=0;N<h;N++){for(M=0;M<K-1;M++){if(Math.abs(z[M+1][M])<V*(Math.abs(z[M][M])+Math.abs(z[M+1][M+1]))){var p=numeric.QRFrancis(numeric.getBlock(z,[0,0],[M,M]),h);var o=numeric.QRFrancis(numeric.getBlock(z,[M+1,M+1],[K-1,K-1]),h);I=Array(M+1);for(O=0;O<=M;O++){I[O]=q[O]}G=numeric.dot(p.Q,I);for(O=0;O<=M;O++){q[O]=G[O]}I=Array(K-M-1);for(O=M+1;O<K;O++){I[O-M-1]=q[O]}G=numeric.dot(o.Q,I);for(O=M+1;O<K;O++){q[O]=G[O-M-1]}return{Q:q,B:p.B.concat(numeric.add(o.B,M+1))}}}U=z[K-2][K-2];S=z[K-2][K-1];R=z[K-1][K-2];P=z[K-1][K-1];e=U+P;n=(U*P-S*R);l=numeric.getBlock(z,[0,0],[2,2]);if(e*e>=4*n){var g,f;g=0.5*(e+Math.sqrt(e*e-4*n));f=0.5*(e-Math.sqrt(e*e-4*n));l=numeric.add(numeric.sub(numeric.dot(l,l),numeric.mul(l,g+f)),numeric.diag(numeric.rep([3],g*f)))}else{l=numeric.add(numeric.sub(numeric.dot(l,l),numeric.mul(l,e)),numeric.diag(numeric.rep([3],n)))}y=[l[0][0],l[1][0],l[2][0]];A=numeric.house(y);I=[z[0],z[1],z[2]];G=numeric.tensor(A,numeric.dot(A,I));for(O=0;O<3;O++){r=z[O];F=G[O];for(L=0;L<K;L++){r[L]-=2*F[L]}}I=numeric.getBlock(z,[0,0],[K-1,2]);G=numeric.tensor(numeric.dot(I,A),A);for(O=0;O<K;O++){r=z[O];F=G[O];for(L=0;L<3;L++){r[L]-=2*F[L]}}I=[q[0],q[1],q[2]];G=numeric.tensor(A,numeric.dot(A,I));for(O=0;O<3;O++){u=q[O];F=G[O];for(L=0;L<K;L++){u[L]-=2*F[L]}}var w;for(M=0;M<K-2;M++){for(L=M;L<=M+1;L++){if(Math.abs(z[L+1][L])<V*(Math.abs(z[L][L])+Math.abs(z[L+1][L+1]))){var p=numeric.QRFrancis(numeric.getBlock(z,[0,0],[L,L]),h);var o=numeric.QRFrancis(numeric.getBlock(z,[L+1,L+1],[K-1,K-1]),h);I=Array(L+1);for(O=0;O<=L;O++){I[O]=q[O]}G=numeric.dot(p.Q,I);for(O=0;O<=L;O++){q[O]=G[O]}I=Array(K-L-1);for(O=L+1;O<K;O++){I[O-L-1]=q[O]}G=numeric.dot(o.Q,I);for(O=L+1;O<K;O++){q[O]=G[O-L-1]}return{Q:q,B:p.B.concat(numeric.add(o.B,L+1))}}}w=Math.min(K-1,M+3);y=Array(w-M);for(O=M+1;O<=w;O++){y[O-M-1]=z[O][M]}A=numeric.house(y);I=numeric.getBlock(z,[M+1,M],[w,K-1]);G=numeric.tensor(A,numeric.dot(A,I));for(O=M+1;O<=w;O++){r=z[O];F=G[O-M-1];for(L=M;L<K;L++){r[L]-=2*F[L-M]}}I=numeric.getBlock(z,[0,M+1],[K-1,w]);G=numeric.tensor(numeric.dot(I,A),A);for(O=0;O<K;O++){r=z[O];F=G[O];for(L=M+1;L<=w;L++){r[L]-=2*F[L-M-1]}}I=Array(w-M);for(O=M+1;O<=w;O++){I[O-M-1]=q[O]}G=numeric.tensor(A,numeric.dot(A,I));for(O=M+1;O<=w;O++){u=q[O];F=G[O-M-1];for(L=0;L<K;L++){u[L]-=2*F[L]}}}}throw new Error("numeric: eigenvalue iteration does not converge -- increase maxiter?")};numeric.eig=function eig(L,l){var f=numeric.toUpperHessenberg(L);var o=numeric.QRFrancis(f.H,l);var r=numeric.T;var O=L.length,W,S,V=false,J=o.B,D=numeric.dot(o.Q,numeric.dot(f.H,numeric.transpose(o.Q)));var u=new r(numeric.dot(o.Q,f.Q)),G;var P=J.length,U;var aa,Z,Y,X,h,g,e,C,z,K,I,w,v;var ab=Math.sqrt;for(S=0;S<P;S++){W=J[S][0];if(W===J[S][1]){}else{U=W+1;aa=D[W][W];Z=D[W][U];Y=D[U][W];X=D[U][U];if(Z===0&&Y===0){continue}h=-aa-X;g=aa*X-Z*Y;e=h*h-4*g;if(e>=0){if(h<0){C=-0.5*(h-ab(e))}else{C=-0.5*(h+ab(e))}w=(aa-C)*(aa-C)+Z*Z;v=Y*Y+(X-C)*(X-C);if(w>v){w=ab(w);K=(aa-C)/w;I=Z/w}else{v=ab(v);K=Y/v;I=(X-C)/v}G=new r([[I,-K],[K,I]]);u.setRows(W,U,G.dot(u.getRows(W,U)))}else{C=-0.5*h;z=0.5*ab(-e);w=(aa-C)*(aa-C)+Z*Z;v=Y*Y+(X-C)*(X-C);if(w>v){w=ab(w+z*z);K=(aa-C)/w;I=Z/w;C=0;z/=w}else{v=ab(v+z*z);K=Y/v;I=(X-C)/v;C=z/v;z=0}G=new r([[I,-K],[K,I]],[[C,z],[z,-C]]);u.setRows(W,U,G.dot(u.getRows(W,U)))}}}var s=u.dot(L).dot(u.transjugate()),O=L.length,F=numeric.T.identity(O);for(U=0;U<O;U++){if(U>0){for(S=U-1;S>=0;S--){var M=s.get([S,S]),N=s.get([U,U]);if(numeric.neq(M.x,N.x)||numeric.neq(M.y,N.y)){C=s.getRow(S).getBlock([S],[U-1]);z=F.getRow(U).getBlock([S],[U-1]);F.set([U,S],(s.get([S,U]).neg().sub(C.dot(z))).div(M.sub(N)))}else{F.setRow(U,F.getRow(S));continue}}}}for(U=0;U<O;U++){C=F.getRow(U);F.setRow(U,C.div(C.norm2()))}F=F.transpose();F=u.transjugate().dot(F);return{lambda:s.getDiag(),E:F}};/*!!
 *  Canvas 2 Svg v1.0.19
 *  A low level canvas to SVG converter. Uses a mock canvas context to build an SVG document.
 *
 *  Licensed under the MIT license:
 *  http://www.opensource.org/licenses/mit-license.php
 *
 *  Author:
 *  Kerry Liu
 *
 *  Copyright (c) 2014 Gliffy Inc.
 */
;(function(){var j,k,i,e,a;function g(o,l){var n=Object.keys(l),m;for(m=0;m<n.length;m++){o=o.replace(new RegExp("\\{"+n[m]+"\\}","gi"),l[n[m]])}return o}function h(m){var o,n,l;if(!m){throw new Error("cannot create a random attribute name for an undefined object")}o="ABCDEFGHIJKLMNOPQRSTUVWXTZabcdefghiklmnopqrstuvwxyz";n="";do{n="";for(l=0;l<12;l++){n+=o[Math.floor(Math.random()*o.length)]}}while(m[n]);return n}function d(n,p){var o,m,r={},q,l;n=n.split(",");p=p||10;for(o=0;o<n.length;o+=2){m="&"+n[o+1]+";";q=parseInt(n[o],p);r[m]="&#"+q+";"}r["\\xa0"]="&#160;";return r}function f(m){var l={left:"start",right:"end",center:"middle",start:"start",end:"end"};return l[m]||l.start}function c(m){var l={alphabetic:"alphabetic",hanging:"hanging",top:"text-before-edge",bottom:"text-after-edge",middle:"central"};return l[m]||l.alphabetic}a=d("50,nbsp,51,iexcl,52,cent,53,pound,54,curren,55,yen,56,brvbar,57,sect,58,uml,59,copy,5a,ordf,5b,laquo,5c,not,5d,shy,5e,reg,5f,macr,5g,deg,5h,plusmn,5i,sup2,5j,sup3,5k,acute,5l,micro,5m,para,5n,middot,5o,cedil,5p,sup1,5q,ordm,5r,raquo,5s,frac14,5t,frac12,5u,frac34,5v,iquest,60,Agrave,61,Aacute,62,Acirc,63,Atilde,64,Auml,65,Aring,66,AElig,67,Ccedil,68,Egrave,69,Eacute,6a,Ecirc,6b,Euml,6c,Igrave,6d,Iacute,6e,Icirc,6f,Iuml,6g,ETH,6h,Ntilde,6i,Ograve,6j,Oacute,6k,Ocirc,6l,Otilde,6m,Ouml,6n,times,6o,Oslash,6p,Ugrave,6q,Uacute,6r,Ucirc,6s,Uuml,6t,Yacute,6u,THORN,6v,szlig,70,agrave,71,aacute,72,acirc,73,atilde,74,auml,75,aring,76,aelig,77,ccedil,78,egrave,79,eacute,7a,ecirc,7b,euml,7c,igrave,7d,iacute,7e,icirc,7f,iuml,7g,eth,7h,ntilde,7i,ograve,7j,oacute,7k,ocirc,7l,otilde,7m,ouml,7n,divide,7o,oslash,7p,ugrave,7q,uacute,7r,ucirc,7s,uuml,7t,yacute,7u,thorn,7v,yuml,ci,fnof,sh,Alpha,si,Beta,sj,Gamma,sk,Delta,sl,Epsilon,sm,Zeta,sn,Eta,so,Theta,sp,Iota,sq,Kappa,sr,Lambda,ss,Mu,st,Nu,su,Xi,sv,Omicron,t0,Pi,t1,Rho,t3,Sigma,t4,Tau,t5,Upsilon,t6,Phi,t7,Chi,t8,Psi,t9,Omega,th,alpha,ti,beta,tj,gamma,tk,delta,tl,epsilon,tm,zeta,tn,eta,to,theta,tp,iota,tq,kappa,tr,lambda,ts,mu,tt,nu,tu,xi,tv,omicron,u0,pi,u1,rho,u2,sigmaf,u3,sigma,u4,tau,u5,upsilon,u6,phi,u7,chi,u8,psi,u9,omega,uh,thetasym,ui,upsih,um,piv,812,bull,816,hellip,81i,prime,81j,Prime,81u,oline,824,frasl,88o,weierp,88h,image,88s,real,892,trade,89l,alefsym,8cg,larr,8ch,uarr,8ci,rarr,8cj,darr,8ck,harr,8dl,crarr,8eg,lArr,8eh,uArr,8ei,rArr,8ej,dArr,8ek,hArr,8g0,forall,8g2,part,8g3,exist,8g5,empty,8g7,nabla,8g8,isin,8g9,notin,8gb,ni,8gf,prod,8gh,sum,8gi,minus,8gn,lowast,8gq,radic,8gt,prop,8gu,infin,8h0,ang,8h7,and,8h8,or,8h9,cap,8ha,cup,8hb,int,8hk,there4,8hs,sim,8i5,cong,8i8,asymp,8j0,ne,8j1,equiv,8j4,le,8j5,ge,8k2,sub,8k3,sup,8k4,nsub,8k6,sube,8k7,supe,8kl,oplus,8kn,otimes,8l5,perp,8m5,sdot,8o8,lceil,8o9,rceil,8oa,lfloor,8ob,rfloor,8p9,lang,8pa,rang,9ea,loz,9j0,spades,9j3,clubs,9j5,hearts,9j6,diams,ai,OElig,aj,oelig,b0,Scaron,b1,scaron,bo,Yuml,m6,circ,ms,tilde,802,ensp,803,emsp,809,thinsp,80c,zwnj,80d,zwj,80e,lrm,80f,rlm,80j,ndash,80k,mdash,80o,lsquo,80p,rsquo,80q,sbquo,80s,ldquo,80t,rdquo,80u,bdquo,810,dagger,811,Dagger,81g,permil,81p,lsaquo,81q,rsaquo,85c,euro",32);j={strokeStyle:{svgAttr:"stroke",canvas:"#000000",svg:"none",apply:"stroke"},fillStyle:{svgAttr:"fill",canvas:"#000000",svg:null,apply:"fill"},lineCap:{svgAttr:"stroke-linecap",canvas:"butt",svg:"butt",apply:"stroke"},lineJoin:{svgAttr:"stroke-linejoin",canvas:"miter",svg:"miter",apply:"stroke"},miterLimit:{svgAttr:"stroke-miterlimit",canvas:10,svg:4,apply:"stroke"},lineWidth:{svgAttr:"stroke-width",canvas:1,svg:1,apply:"stroke"},globalAlpha:{svgAttr:"opacity",canvas:1,svg:1,apply:"fill stroke"},font:{canvas:"10px sans-serif"},shadowColor:{canvas:"#000000"},shadowOffsetX:{canvas:0},shadowOffsetY:{canvas:0},shadowBlur:{canvas:0},textAlign:{canvas:"start"},textBaseline:{canvas:"alphabetic"},lineDash:{svgAttr:"stroke-dasharray",canvas:[],svg:null,apply:"stroke"}};i=function(m,l){this.__root=m;this.__ctx=l};i.prototype.addColorStop=function(p,l){var m=this.__ctx.__createElement("stop"),n,o;m.setAttribute("offset",p);if(l.indexOf("rgba")!==-1){n=/rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi;o=n.exec(l);m.setAttribute("stop-color",g("rgb({r},{g},{b})",{r:o[1],g:o[2],b:o[3]}));m.setAttribute("stop-opacity",o[4])}else{m.setAttribute("stop-color",l)}this.__root.appendChild(m)};e=function(m,l){this.__root=m;this.__ctx=l};k=function(n){var l={width:500,height:500,enableMirroring:false},m;if(arguments.length>1){m=l;m.width=arguments[0];m.height=arguments[1]}else{if(!n){m=l}else{m=n}}if(!(this instanceof k)){return new k(m)}this.width=m.width||l.width;this.height=m.height||l.height;this.enableMirroring=m.enableMirroring!==undefined?m.enableMirroring:l.enableMirroring;this.canvas=this;this.__document=m.document||document;if(m.ctx){this.__ctx=m.ctx}else{this.__canvas=this.__document.createElement("canvas");this.__ctx=this.__canvas.getContext("2d")}this.__setDefaultStyles();this.__stack=[this.__getStyleState()];this.__groupStack=[];this.__root=this.__document.createElementNS("http://www.w3.org/2000/svg","svg");this.__root.setAttribute("version",1.1);this.__root.setAttribute("xmlns","http://www.w3.org/2000/svg");this.__root.setAttributeNS("http://www.w3.org/2000/xmlns/","xmlns:xlink","http://www.w3.org/1999/xlink");this.__root.setAttribute("width",this.width);this.__root.setAttribute("height",this.height);this.__ids={};this.__defs=this.__document.createElementNS("http://www.w3.org/2000/svg","defs");this.__root.appendChild(this.__defs);this.__currentElement=this.__document.createElementNS("http://www.w3.org/2000/svg","g");this.__root.appendChild(this.__currentElement)};k.prototype.__createElement=function(l,p,r){if(typeof p==="undefined"){p={}}var o=this.__document.createElementNS("http://www.w3.org/2000/svg",l),q=Object.keys(p),n,m;if(r){o.setAttribute("fill","none");o.setAttribute("stroke","none")}for(n=0;n<q.length;n++){m=q[n];o.setAttribute(m,p[m])}return o};k.prototype.__setDefaultStyles=function(){var n=Object.keys(j),m,l;for(m=0;m<n.length;m++){l=n[m];this[l]=j[l].canvas}};k.prototype.__applyStyleState=function(l){var o=Object.keys(l),n,m;for(n=0;n<o.length;n++){m=o[n];this[m]=l[m]}};k.prototype.__getStyleState=function(){var n,l={},o=Object.keys(j),m;for(n=0;n<o.length;n++){m=o[n];l[m]=this[m]}return l};k.prototype.__applyStyleToCurrentElement=function(u){var q=this.__currentElement;var n=this.__currentElementsToStyle;if(n){q.setAttribute(u,"");q=n.element;n.children.forEach(function(y){y.setAttribute(u,"")})}var x=Object.keys(j),o,l,w,m,v,p;for(o=0;o<x.length;o++){l=j[x[o]];w=this[x[o]];if(l.apply){if(w instanceof e){if(w.__ctx){while(w.__ctx.__defs.childNodes.length){m=w.__ctx.__defs.childNodes[0].getAttribute("id");this.__ids[m]=m;this.__defs.appendChild(w.__ctx.__defs.childNodes[0])}}q.setAttribute(l.apply,g("url(#{id})",{id:w.__root.getAttribute("id")}))}else{if(w instanceof i){q.setAttribute(l.apply,g("url(#{id})",{id:w.__root.getAttribute("id")}))}else{if(l.apply.indexOf(u)!==-1&&l.svg!==w){if((l.svgAttr==="stroke"||l.svgAttr==="fill")&&w.indexOf("rgba")!==-1){v=/rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi;p=v.exec(w);q.setAttribute(l.svgAttr,g("rgb({r},{g},{b})",{r:p[1],g:p[2],b:p[3]}));var r=p[4];var t=this.globalAlpha;if(t!=null){r*=t}q.setAttribute(l.svgAttr+"-opacity",r)}else{var s=l.svgAttr;if(x[o]==="globalAlpha"){s=u+"-"+l.svgAttr;if(q.getAttribute(s)){continue}}q.setAttribute(s,w)}}}}}}};k.prototype.__closestGroupOrSvg=function(l){l=l||this.__currentElement;if(l.nodeName==="g"||l.nodeName==="svg"){return l}else{return this.__closestGroupOrSvg(l.parentNode)}};k.prototype.getSerializedSvg=function(s){var q=new XMLSerializer().serializeToString(this.__root),n,m,l,p,o,r;r=/xmlns="http:\/\/www\.w3\.org\/2000\/svg".+xmlns="http:\/\/www\.w3\.org\/2000\/svg/gi;if(r.test(q)){q=q.replace('xmlns="http://www.w3.org/2000/svg','xmlns:xlink="http://www.w3.org/1999/xlink')}if(s){n=Object.keys(a);for(m=0;m<n.length;m++){l=n[m];p=a[l];o=new RegExp(l,"gi");if(o.test(q)){q=q.replace(o,p)}}}return q};k.prototype.getSvg=function(){return this.__root};k.prototype.save=function(){var m=this.__createElement("g");var l=this.__closestGroupOrSvg();this.__groupStack.push(l);l.appendChild(m);this.__currentElement=m;this.__stack.push(this.__getStyleState())};k.prototype.restore=function(){this.__currentElement=this.__groupStack.pop();this.__currentElementsToStyle=null;if(!this.__currentElement){this.__currentElement=this.__root.childNodes[1]}var l=this.__stack.pop();this.__applyStyleState(l)};k.prototype.__addTransform=function(m){var n=this.__closestGroupOrSvg();if(n.childNodes.length>0){if(this.__currentElement.nodeName==="path"){if(!this.__currentElementsToStyle){this.__currentElementsToStyle={element:n,children:[]}}this.__currentElementsToStyle.children.push(this.__currentElement);this.__applyCurrentDefaultPath()}var o=this.__createElement("g");n.appendChild(o);this.__currentElement=o}var l=this.__currentElement.getAttribute("transform");if(l){l+=" "}else{l=""}l+=m;this.__currentElement.setAttribute("transform",l)};k.prototype.scale=function(l,m){if(m===undefined){m=l}this.__addTransform(g("scale({x},{y})",{x:l,y:m}))};k.prototype.rotate=function(m){var l=(m*180/Math.PI);this.__addTransform(g("rotate({angle},{cx},{cy})",{angle:l,cx:0,cy:0}))};k.prototype.translate=function(l,m){this.__addTransform(g("translate({x},{y})",{x:l,y:m}))};k.prototype.transform=function(m,l,q,p,o,n){this.__addTransform(g("matrix({a},{b},{c},{d},{e},{f})",{a:m,b:l,c:q,d:p,e:o,f:n}))};k.prototype.beginPath=function(){var m,l;this.__currentDefaultPath="";this.__currentPosition={};m=this.__createElement("path",{},true);l=this.__closestGroupOrSvg();l.appendChild(m);this.__currentElement=m};k.prototype.__applyCurrentDefaultPath=function(){var l=this.__currentElement;if(l.nodeName==="path"){l.setAttribute("d",this.__currentDefaultPath)}else{console.error("Attempted to apply path command to node",l.nodeName)}};k.prototype.__addPathCommand=function(l){this.__currentDefaultPath+=" ";this.__currentDefaultPath+=l};k.prototype.moveTo=function(l,m){if(this.__currentElement.nodeName!=="path"){this.beginPath()}this.__currentPosition={x:l,y:m};this.__addPathCommand(g("M {x} {y}",{x:l,y:m}))};k.prototype.closePath=function(){if(this.__currentDefaultPath){this.__addPathCommand("Z")}};k.prototype.lineTo=function(l,m){this.__currentPosition={x:l,y:m};if(this.__currentDefaultPath.indexOf("M")>-1){this.__addPathCommand(g("L {x} {y}",{x:l,y:m}))}else{this.__addPathCommand(g("M {x} {y}",{x:l,y:m}))}};k.prototype.bezierCurveTo=function(n,m,p,o,l,q){this.__currentPosition={x:l,y:q};this.__addPathCommand(g("C {cp1x} {cp1y} {cp2x} {cp2y} {x} {y}",{cp1x:n,cp1y:m,cp2x:p,cp2y:o,x:l,y:q}))};k.prototype.quadraticCurveTo=function(n,m,l,o){this.__currentPosition={x:l,y:o};this.__addPathCommand(g("Q {cpx} {cpy} {x} {y}",{cpx:n,cpy:m,x:l,y:o}))};var b=function(m){var l=Math.sqrt(m[0]*m[0]+m[1]*m[1]);return[m[0]/l,m[1]/l]};k.prototype.arcTo=function(F,o,E,n,q){var G=this.__currentPosition&&this.__currentPosition.x;var p=this.__currentPosition&&this.__currentPosition.y;if(typeof G=="undefined"||typeof p=="undefined"){return}if(q<0){throw new Error("IndexSizeError: The radius provided ("+q+") is negative.")}if(((G===F)&&(p===o))||((F===E)&&(o===n))||(q===0)){this.lineTo(F,o);return}var u=b([G-F,p-o]);var t=b([E-F,n-o]);if(u[0]*t[1]===u[1]*t[0]){this.lineTo(F,o);return}var m=(u[0]*t[0]+u[1]*t[1]);var v=Math.acos(Math.abs(m));var B=b([u[0]+t[0],u[1]+t[1]]);var r=q/Math.sin(v/2);var A=F+r*B[0];var z=o+r*B[1];var l=[-u[1],u[0]];var w=[t[1],-t[0]];var s=function(I){var H=I[0];var J=I[1];if(J>=0){return Math.acos(H)}else{return -Math.acos(H)}};var D=s(l);var C=s(w);this.lineTo(A+l[0]*q,z+l[1]*q);this.arc(A,z,q,D,C)};k.prototype.stroke=function(){if(this.__currentElement.nodeName==="path"){this.__currentElement.setAttribute("paint-order","fill stroke markers")}this.__applyCurrentDefaultPath();this.__applyStyleToCurrentElement("stroke")};k.prototype.fill=function(){if(this.__currentElement.nodeName==="path"){this.__currentElement.setAttribute("paint-order","stroke fill markers")}this.__applyCurrentDefaultPath();this.__applyStyleToCurrentElement("fill")};k.prototype.rect=function(m,o,n,l){if(this.__currentElement.nodeName!=="path"){this.beginPath()}this.moveTo(m,o);this.lineTo(m+n,o);this.lineTo(m+n,o+l);this.lineTo(m,o+l);this.lineTo(m,o);this.closePath()};k.prototype.fillRect=function(m,q,o,l){var p,n;p=this.__createElement("rect",{x:m,y:q,width:o,height:l},true);n=this.__closestGroupOrSvg();n.appendChild(p);this.__currentElement=p;this.__applyStyleToCurrentElement("fill")};k.prototype.strokeRect=function(m,q,o,l){var p,n;p=this.__createElement("rect",{x:m,y:q,width:o,height:l},true);n=this.__closestGroupOrSvg();n.appendChild(p);this.__currentElement=p;this.__applyStyleToCurrentElement("stroke")};k.prototype.__clearCanvas=function(){var o=this.__closestGroupOrSvg(),l=o.getAttribute("transform");var n=this.__root.childNodes[1];var p=n.childNodes;for(var m=p.length-1;m>=0;m--){if(p[m]){n.removeChild(p[m])}}this.__currentElement=n;this.__groupStack=[];if(l){this.__addTransform(l)}};k.prototype.clearRect=function(m,q,o,l){if(m===0&&q===0&&o===this.width&&l===this.height){this.__clearCanvas();return}var p,n=this.__closestGroupOrSvg();p=this.__createElement("rect",{x:m,y:q,width:o,height:l,fill:"#FFFFFF"},true);n.appendChild(p)};k.prototype.createLinearGradient=function(m,o,l,n){var p=this.__createElement("linearGradient",{id:h(this.__ids),x1:m+"px",x2:l+"px",y1:o+"px",y2:n+"px",gradientUnits:"userSpaceOnUse"},false);this.__defs.appendChild(p);return new i(p,this)};k.prototype.createRadialGradient=function(o,q,n,m,p,l){var r=this.__createElement("radialGradient",{id:h(this.__ids),cx:m+"px",cy:p+"px",r:l+"px",fx:o+"px",fy:q+"px",gradientUnits:"userSpaceOnUse"},false);this.__defs.appendChild(r);return new i(r,this)};k.prototype.__parseFont=function(){var m=/^\s*(?=(?:(?:[-a-z]+\s*){0,2}(italic|oblique))?)(?=(?:(?:[-a-z]+\s*){0,2}(small-caps))?)(?=(?:(?:[-a-z]+\s*){0,2}(bold(?:er)?|lighter|[1-9]00))?)(?:(?:normal|\1|\2|\3)\s*){0,3}((?:xx?-)?(?:small|large)|medium|smaller|larger|[.\d]+(?:\%|in|[cem]m|ex|p[ctx]))(?:\s*\/\s*(normal|[.\d]+(?:\%|in|[cem]m|ex|p[ctx])))?\s*([-,\'\"\sa-z0-9]+?)\s*$/i;var l=m.exec(this.font);var n={style:l[1]||"normal",size:l[4]||"10px",family:l[6]||"sans-serif",weight:l[3]||"normal",decoration:l[2]||"normal",href:null};if(this.__fontUnderline==="underline"){n.decoration="underline"}if(this.__fontHref){n.href=this.__fontHref}return n};k.prototype.__wrapTextLink=function(m,n){if(m.href){var l=this.__createElement("a");l.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",m.href);l.appendChild(n);return l}return n};k.prototype.__applyText=function(q,l,r,p){var n=this.__parseFont(),o=this.__closestGroupOrSvg(),m=this.__createElement("text",{"font-family":n.family,"font-size":n.size,"font-style":n.style,"font-weight":n.weight,"text-decoration":n.decoration,x:l,y:r,"text-anchor":f(this.textAlign),"dominant-baseline":c(this.textBaseline)},true);m.appendChild(this.__document.createTextNode(q));this.__currentElement=m;this.__applyStyleToCurrentElement(p);o.appendChild(this.__wrapTextLink(n,m))};k.prototype.fillText=function(m,l,n){this.__applyText(m,l,n,"fill")};k.prototype.strokeText=function(m,l,n){this.__applyText(m,l,n,"stroke")};k.prototype.measureText=function(l){this.__ctx.font=this.font;return this.__ctx.measureText(l)};k.prototype.arc=function(t,s,q,r,m,v){if(r===m){return}r=r%(2*Math.PI);m=m%(2*Math.PI);if(r===m){m=((m+(2*Math.PI))-0.001*(v?-1:1))%(2*Math.PI)}var z=t+q*Math.cos(m),w=s+q*Math.sin(m),p=t+q*Math.cos(r),o=s+q*Math.sin(r),n=v?0:1,l=0,u=m-r;if(u<0){u+=2*Math.PI}if(v){l=u>Math.PI?0:1}else{l=u>Math.PI?1:0}this.lineTo(p,o);this.__addPathCommand(g("A {rx} {ry} {xAxisRotation} {largeArcFlag} {sweepFlag} {endX} {endY}",{rx:q,ry:q,xAxisRotation:0,largeArcFlag:l,sweepFlag:n,endX:z,endY:w}));this.__currentPosition={x:z,y:w}};k.prototype.clip=function(){var m=this.__closestGroupOrSvg(),l=this.__createElement("clipPath"),o=h(this.__ids),n=this.__createElement("g");this.__applyCurrentDefaultPath();m.removeChild(this.__currentElement);l.setAttribute("id",o);l.appendChild(this.__currentElement);this.__defs.appendChild(l);m.setAttribute("clip-path",g("url(#{id})",{id:o}));m.appendChild(n);this.__currentElement=n};k.prototype.drawImage=function(){var n=Array.prototype.slice.call(arguments),z=n[0],u,t,v,F,x=0,w=0,C,G,s,y,l,q,o,D,p,m,B;if(n.length===3){u=n[1];t=n[2];C=z.width;G=z.height;v=C;F=G}else{if(n.length===5){u=n[1];t=n[2];v=n[3];F=n[4];C=z.width;G=z.height}else{if(n.length===9){x=n[1];w=n[2];C=n[3];G=n[4];u=n[5];t=n[6];v=n[7];F=n[8]}else{throw new Error("Inavlid number of arguments passed to drawImage: "+arguments.length)}}}s=this.__closestGroupOrSvg();o=this.__currentElement;var r="translate("+u+", "+t+")";if(z instanceof k){y=z.getSvg().cloneNode(true);if(y.childNodes&&y.childNodes.length>1){l=y.childNodes[0];while(l.childNodes.length){B=l.childNodes[0].getAttribute("id");this.__ids[B]=B;this.__defs.appendChild(l.childNodes[0])}q=y.childNodes[1];if(q){var E=q.getAttribute("transform");var A;if(E){A=E+" "+r}else{A=r}q.setAttribute("transform",A);s.appendChild(q)}}}else{if(z.nodeName==="CANVAS"||z.nodeName==="IMG"){D=this.__createElement("image");D.setAttribute("width",v);D.setAttribute("height",F);D.setAttribute("preserveAspectRatio","none");if(x||w||C!==z.width||G!==z.height){p=this.__document.createElement("canvas");p.width=v;p.height=F;m=p.getContext("2d");m.drawImage(z,x,w,C,G,0,0,v,F);z=p}D.setAttribute("transform",r);D.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",z.nodeName==="CANVAS"?z.toDataURL():z.getAttribute("src"));s.appendChild(D)}}};k.prototype.createPattern=function(o,m){var n=this.__document.createElementNS("http://www.w3.org/2000/svg","pattern"),p=h(this.__ids),l;n.setAttribute("id",p);n.setAttribute("width",o.width);n.setAttribute("height",o.height);if(o.nodeName==="CANVAS"||o.nodeName==="IMG"){l=this.__document.createElementNS("http://www.w3.org/2000/svg","image");l.setAttribute("width",o.width);l.setAttribute("height",o.height);l.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",o.nodeName==="CANVAS"?o.toDataURL():o.getAttribute("src"));n.appendChild(l);this.__defs.appendChild(n)}else{if(o instanceof k){n.appendChild(o.__root.childNodes[1]);this.__defs.appendChild(n)}}return new e(n,this)};k.prototype.setLineDash=function(l){if(l&&l.length>0){this.lineDash=l.join(",")}else{this.lineDash=null}};k.prototype.drawFocusRing=function(){};k.prototype.createImageData=function(){};k.prototype.getImageData=function(){};k.prototype.putImageData=function(){};k.prototype.globalCompositeOperation=function(){};k.prototype.setTransform=function(){};if(typeof window==="object"){window.C2S=k}if(typeof module==="object"&&typeof module.exports==="object"){module.exports=k}}());(function(e,c){var h=e.document,i=function(j){if(!j){return null}var k=j.getBoundingClientRect();return{w:k.width,h:k.height,t:k.top,l:k.left,b:k.bottom,r:k.right,obj:j}},a=function(m,l,q,j){var o="webkit moz ms o ".split(" ");for(var n=0,k=o.length;n<k;n++){if(!o[n]){l=l.toLowerCase()}m.addEventListener(o[n]+l,q,j)}},g=function(j){var k=this;return function(){j.apply(k,Array.prototype.slice.call(arguments))}};function b(j,m,k,l){this.animationDirection=null;this.possibleDirections=m;this.step_quantum=typeof k==="number"?Math.abs(Math.ceil(k)):3;this.expandedContainer=j;this.fixedContainer=h.body.appendChild(h.createElement("div"));this.fixedContainer.style.zIndex=1000001;this.fixedContainer.className="genie";this.callback=l}var d=20;b.prototype={constructor:b,collapseTransitionEvent:function(l){switch(l.propertyName){case"left":case"top":var k=l.target.parentNode,q=i(k),t=i(this.target),n=k.childNodes,m=this.step_quantum+1,y=m-(n.length-1)*(1-m)-1,u=m+t.h-(n.length-1)*(1-m)-1,o=m-(n.length-1)*(1-m)-1,j=m+t.w-(n.length-1)*(1-m)-1,r,w=n.length,p,v,s,x;this.target.style.backgroundPosition="0px 0px";switch(this.animationDirection){case"top":for(r=w-1;r>=0;r--){p=n[r].style.backgroundPosition.split(" ")[1];v=parseFloat(p.slice(0,p.length-2),10);n[r].style.backgroundPosition="0px "+(v-u)+"px"}break;case"bottom":for(r=0;r<w;r++){p=n[r].style.backgroundPosition.split(" ")[1];v=parseFloat(p.slice(0,p.length-2),10);n[r].style.backgroundPosition="0px "+(v+y)+"px"}break;case"left":for(r=w-1;r>=0;r--){s=n[r].style.backgroundPosition.split(" ")[0];x=parseFloat(s.slice(0,s.length-2),10);n[r].style.backgroundPosition=(x-j)+"px 0px"}break;case"right":for(r=0;r<w;r++){s=n[r].style.backgroundPosition.split(" ")[0];x=parseFloat(s.slice(0,s.length-2),10);n[r].style.backgroundPosition=(x+o)+"px 0px"}break}k.className+=" change-pace";break;case"background-position":case"background-position-x":case"background-position-y":h.body.removeChild(this.fixedContainer);if(typeof this.callback==="function"){this.callback.call(this.expandedContainer)}break}},expandTransitionEvent:function(m){var n=m.target.parentNode;switch(m.propertyName){case"background-position":case"background-position-x":case"background-position-y":var l=n.childNodes,k,j=l.length;n.className+=" change-pace";for(k=0;k<j;k++){switch(this.animationDirection){case"top":case"bottom":l[k].style.width="100%";l[k].style.left="0px";break;case"left":case"right":l[k].style.height="100%";l[k].style.top="0px";break}}break;case"width":case"height":this.expandedContainer.style.backgroundPosition="0px 0px";h.body.removeChild(n);if(typeof this.callback==="function"){this.callback.call(this.expandedContainer)}break}},collapse:function(A){this.target=A;var o=this.step_quantum,r=this.expandedContainer,k=this.fixedContainer,w=i(r),j=i(A),m=Math.ceil((j.t-w.t)/o),q=Math.ceil((w.b-j.b)/o),t=Math.ceil((j.l-w.l)/o),x=Math.ceil((w.r-j.r)/o),v=-1,s="",z,p,l,u=0,n=this;if(typeof this.possibleDirections==="undefined"||typeof this.possibleDirections.indexOf!=="function"){this.possibleDirections=["top","bottom","right","left"]}if(this.possibleDirections.indexOf("bottom")>=0&&m>v){v=m;this.animationDirection="bottom"}if(this.possibleDirections.indexOf("top")>=0&&q>v){v=q;this.animationDirection="top"}if(this.possibleDirections.indexOf("left")>=0&&x>v){v=x;this.animationDirection="left"}if(this.possibleDirections.indexOf("right")>=0&&t>v){v=t;this.animationDirection="right"}switch(this.animationDirection){case"top":var y=Math.ceil((w.t-j.b)/o);k.style.width=w.w+"px";k.style.height=w.h+"px";k.style.top=w.t+"px";k.style.left=w.l+"px";k.style.position="absolute";k.style.backgroundPosition=r.style.backgroundPosition;k.style.backgroundImage=r.style.backgroundImage;k.style.display=r.style.display;k.style.backgroundPosition="0px 9999px";for(u=-y;u<q-y;u++){p=u*o;z="0px "+(-(u+1)*o)+"px";s+='<div class="genie-step" style="left: 0px; top: '+p+"px; width: "+w.w+"px; height: "+(o+1)+"px; background-position: "+z+"; background-size: 100% "+w.h+'px;"></div>'}k.innerHTML=s;setTimeout(function(){r.style.backgroundPosition="0px 9999px";var F=k.childNodes,D=Math.floor((j.l-w.l)/2),H=Math.floor((j.w-w.w)/2),C=H-j.w+1,I=(Math.PI*2)/(q*2),B=4.7,G=0,E=F.length;for(;G<E;G++){F[E-G-1].style.left=Math.ceil((Math.sin(B)*D)+D)+"px";F[E-G-1].style.width=Math.ceil((Math.sin(B)*H)-C)+"px";B+=I}a(F[0],"TransitionEnd",g.call(n,n.collapseTransitionEvent),true);k.className+=" genie-collapse"},d);break;case"bottom":k.style.width=w.w+"px";k.style.height=w.h+"px";k.style.top=w.t+"px";k.style.left=w.l+"px";k.style.position="absolute";k.style.backgroundPosition=r.style.backgroundPosition;k.style.backgroundImage=r.style.backgroundImage;k.style.display=r.style.display;k.style.backgroundPosition="0px -9999px";for(;u<m;u++){p=u*o;z="0px "+(-(u+1)*o)+"px";s+='<div class="genie-step" style="left: 0px; top: '+p+"px; width: "+w.w+"px; height: "+(o+1)+"px; background-position: "+z+"; background-size: 100% "+w.h+'px;"></div>'}k.innerHTML=s;setTimeout(function(){r.style.backgroundPosition="0px -9999px";var F=k.childNodes,D=Math.floor((j.l-w.l)/2),H=Math.floor((j.w-w.w)/2),C=H-j.w+1,I=(Math.PI*2)/(m*2),B=4.7,G=0,E=F.length;for(;G<E;G++){F[G].style.left=Math.ceil((Math.sin(B)*D)+D)+"px";F[G].style.width=Math.ceil((Math.sin(B)*H)-C)+"px";B+=I}a(F[E-1],"TransitionEnd",g.call(n,n.collapseTransitionEvent),true);k.className+=" genie-collapse"},d);break;case"right":k.style.width=w.w+"px";k.style.height=w.h+"px";k.style.top=w.t+"px";k.style.left=w.l+"px";k.style.position="absolute";k.style.backgroundPosition=r.style.backgroundPosition;k.style.backgroundImage=r.style.backgroundImage;k.style.display=r.style.display;k.style.backgroundPosition="-9999px 0px";for(;u<t;u++){l=u*o;z=(-(u+1)*o)+"px 0px";s+='<div class="genie-step" style="left: '+l+"px; top: 0px; width: "+(o+1)+"px; height: "+w.h+"px; background-position: "+z+"; background-size: "+w.w+'px 100%;"></div>'}k.innerHTML=s;setTimeout(function(){r.style.backgroundPosition="-9999px 0px";var D=k.childNodes,G=Math.floor((j.t-w.t)/2),F=Math.floor((j.h-w.h)/2),H=F-j.h+1,I=(Math.PI*2)/(t*2),B=4.7,E=0,C=D.length;for(;E<C;E++){D[E].style.top=Math.ceil((Math.sin(B)*G)+G)+"px";D[E].style.height=Math.ceil((Math.sin(B)*F)-H)+"px";B+=I}a(D[C-1],"TransitionEnd",g.call(n,n.collapseTransitionEvent),true);k.className+=" genie-collapse"},d);break;case"left":var y=Math.ceil((w.l-j.r)/o);k.style.width=w.w+"px";k.style.height=w.h+"px";k.style.top=w.t+"px";k.style.left=w.l+"px";k.style.position="absolute";k.style.backgroundPosition=r.style.backgroundPosition;k.style.backgroundImage=r.style.backgroundImage;k.style.display=r.style.display;k.style.backgroundPosition="9999px 0px";for(u=-y;u<x-y;u++){l=u*o;z=(-(u+1)*o)+"px 0px";s+='<div class="genie-step" style="left: '+l+"px; top: 0px; width: "+(o+1)+"px; height: "+w.h+"px; background-position: "+z+"; background-size: "+w.w+'px 100%;"></div>'}k.innerHTML=s;setTimeout(function(){var D=k.childNodes,G=Math.floor((j.t-w.t)/2),F=Math.floor((j.h-w.h)/2),H=F-j.h+1,I=(Math.PI*2)/(x*2),B=4.7,E=0,C=D.length;for(;E<C;E++){D[C-1-E].style.top=Math.ceil((Math.sin(B)*G)+G)+"px";D[C-1-E].style.height=Math.ceil((Math.sin(B)*F)-H)+"px";B+=I}a(D[0],"TransitionEnd",g.call(n,n.collapseTransitionEvent),true);r.style.backgroundPosition="9999px 0px";k.className+=" genie-collapse"},d);break}},setupTarget:function(j,n){var m=this.expandedContainer,l=new Image(),k=j.style.backgroundImage;l.src=/"/.test(k)?k.slice(5,k.length-2):k.slice(4,k.length-1);l.onload=function(){m.style.backgroundPosition="0px -9999px";m.style.backgroundImage=k;m.className="genie";if(typeof n==="function"){n()}}},expand:function(u){var r=this.step_quantum,J=this.expandedContainer,m=this.fixedContainer,C=i(u),l=i(J),o=Math.ceil((C.t-l.t)/r),t=Math.ceil((l.b-C.b)/r),x=Math.ceil((C.l-l.l)/r),G=Math.ceil((l.r-C.r)/r),B=-1,p=4.7,w="",A=0;if(typeof this.possibleDirections==="undefined"||typeof this.possibleDirections.indexOf!=="function"){this.possibleDirections=["top","bottom","right","left"]}if(this.possibleDirections.indexOf("bottom")>=0&&o>B){B=o;this.animationDirection="bottom"}if(this.possibleDirections.indexOf("top")>=0&&t>B){B=t;this.animationDirection="top"}if(this.possibleDirections.indexOf("left")>=0&&G>B){B=G;this.animationDirection="left"}if(this.possibleDirections.indexOf("right")>=0&&x>B){B=x;this.animationDirection="right"}switch(this.animationDirection){case"bottom":var v=C.t-l.t,K=Math.floor((C.l-l.l)/2),s=Math.floor((C.w-l.w)/2),F=s-C.w+1,q=(Math.PI*2)/(o*2);m.style.width=l.w+"px";m.style.height=l.h+"px";m.style.top=l.t+"px";m.style.left=l.l+"px";m.style.position="absolute";m.style.backgroundPosition=J.style.backgroundPosition;m.style.backgroundImage=J.style.backgroundImage;m.style.display=J.style.display;m.className="genie";for(;A<o;A++){w+='<div class="genie-step" style="top: '+(A*r)+"px; height: "+(r+1)+"px; background-position: 0px "+(v-(A*r))+"px; left: "+Math.ceil((Math.sin(p)*K)+K)+"px; width: "+Math.ceil((Math.sin(p)*s)-F)+"px; background-size: 100% "+l.h+'px;"></div>';p+=q}m.innerHTML=w;a(m.childNodes[0],"TransitionEnd",g.call(this,this.expandTransitionEvent));setTimeout(function(){var L=m.childNodes,O,M,N=0,k=L.length;for(;N<k;N++){O=L[N].style.backgroundPosition.split(" ")[1];M=parseFloat(O.slice(0,O.length-2),10);L[N].style.backgroundPosition="0px "+(M-v)+"px"}u.style.backgroundPosition="0px -"+Math.floor((v/l.h)*100)+"px";m.className+=" genie-expand"},d);break;case"top":var j=l.b-C.b,I=Math.ceil((l.t-C.b)/r),K=Math.floor((C.l-l.l)/2),s=Math.floor((C.w-l.w)/2),F=s-C.w+1,q=(Math.PI*2)/(t*2),y=t-I-1;m.style.width=l.w+"px";m.style.height=l.h+"px";m.style.top=l.t+"px";m.style.left=l.l+"px";m.style.position="absolute";m.style.backgroundPosition=J.style.backgroundPosition;m.style.backgroundImage=J.style.backgroundImage;m.style.display=J.style.display;m.className="genie";for(A=-I;A<t-I;A++,y--){w+='<div class="genie-step" style="top: '+(y*r)+"px; height: "+(r+1)+"px; background-position: 0px "+((-y*r)-j)+"px; left: "+Math.ceil((Math.sin(p)*K)+K)+"px; width: "+Math.ceil((Math.sin(p)*s)-F)+"px; background-size: 100% "+l.h+'px;"></div>';p+=q}m.innerHTML=w;a(m.childNodes[0],"TransitionEnd",g.call(this,this.expandTransitionEvent));setTimeout(function(){var L=m.childNodes,O,M,N=0,k=L.length;for(;N<k;N++){O=L[N].style.backgroundPosition.split(" ")[1];M=parseFloat(O.slice(0,O.length-2),10);L[N].style.backgroundPosition="0px "+(M+j)+"px"}u.style.backgroundPosition="0px "+Math.floor((j/l.h)*100)+"px";m.className+=" genie-expand"},d);break;case"right":var D=C.l-l.l,H=Math.floor((C.t-l.t)/2),n=Math.floor((C.h-l.h)/2),E=n-C.h+1,q=(Math.PI*2)/(x*2);m.style.width=l.w+"px";m.style.height=l.h+"px";m.style.top=l.t+"px";m.style.left=l.l+"px";m.style.position="absolute";m.style.backgroundPosition=J.style.backgroundPosition;m.style.backgroundImage=J.style.backgroundImage;m.style.display=J.style.display;m.className="genie";for(;A<x;A++){w+='<div class="genie-step" style="left: '+(A*r)+"px; width: "+(r+1)+"px; background-position: "+(D-(A*r))+"px 0px; top: "+Math.ceil((Math.sin(p)*H)+H)+"px; height: "+Math.ceil((Math.sin(p)*n)-E)+"px; background-size: "+l.w+'px 100%;"></div>';p+=q}m.innerHTML=w;a(m.childNodes[0],"TransitionEnd",g.call(this,this.expandTransitionEvent));setTimeout(function(){var M=m.childNodes,L,O,N=0,k=M.length;for(;N<k;N++){L=M[N].style.backgroundPosition.split(" ")[0];O=parseFloat(L.slice(0,L.length-2),10);M[N].style.backgroundPosition=(O-D)+"px 0px"}u.style.backgroundPosition="-"+Math.floor((D/l.h)*100)+"px 0px";m.className+=" genie-expand"},d);break;case"left":var z=l.r-C.r,I=Math.ceil((l.l-C.r)/r),H=Math.floor((C.t-l.t)/2),n=Math.floor((C.h-l.h)/2),E=n-C.h+1,q=(Math.PI*2)/(G*2),y=G-I-1;m.style.width=l.w+"px";m.style.height=l.h+"px";m.style.top=l.t+"px";m.style.left=l.l+"px";m.style.position="absolute";m.style.backgroundPosition=J.style.backgroundPosition;m.style.backgroundImage=J.style.backgroundImage;m.style.display=J.style.display;m.className="genie";for(A=-I;A<G-I;A++,y--){w+='<div class="genie-step" style="left: '+(y*r)+"px; width: "+(r+1)+"px; background-position: "+((-y*r)-z)+"px 0px; top: "+Math.ceil((Math.sin(p)*H)+H)+"px; height: "+Math.ceil((Math.sin(p)*n)-E)+"px; background-size: "+l.w+'px 100%;"></div>';p+=q}m.innerHTML=w;a(m.childNodes[0],"TransitionEnd",g.call(this,this.expandTransitionEvent));setTimeout(function(){var M=m.childNodes,L,O,N=0,k=M.length;for(;N<k;N++){L=M[N].style.backgroundPosition.split(" ")[0];O=parseFloat(L.slice(0,L.length-2),10);M[N].style.backgroundPosition=(O+z)+"px 0px"}u.style.backgroundPosition=Math.floor((z/l.h)*100)+"px 0px";m.className+=" genie-expand"},d);break}}};var f={expand:function(l,n,q,k,p){var o=false,m=g.call(n,function(){if(o){return}o=true;if(typeof p==="function"){p.call(this)}}),j=new b(n,q,k,m);j.setupTarget(l,function(){j.expand(l);setTimeout(m,2000)})},collapse:function(l,n,q,k,p){var o=false,m=g.call(l,function(){if(o){return}o=true;if(typeof p==="function"){p.call(this)}}),j=new b(l,q,k,m);j.collapse(n);setTimeout(m,2000)}};e.genie=f})(window);if(typeof(CanvasXpress)=="undefined"){CanvasXpress={}}var CanvasXpress=function(e,c,b,i,a,f,d,h,g){this.setInit=function(){this.target=e;this.events=i;this.info=a;this.userId=2;this.href=location.href;this.protocol=this.href.split(":")[0];this.url={};this.meta={ids:{},time:{start:new Date().getTime(),elapsed:null,end:null,draw:[],render:[]},data:false,canvas:{},config:{user:b,orig:{},vals:{},remote:false},vals:{},render:{objects:[],groups:{},types:{},order:[],map:{},origin:[],transition:false},events:{},state:{save:0,clip:false,translate:[0,0],rotate:[0],scale:[1,1]},stack:[],def:{}}};this.validateParameters=function(){this.validateData();this.validateConfig();this.validateEvents();this.validateInfo();this.validateAfterRender()};this.validateData=function(){this.dataURL=false;if(typeof(c)=="string"){var l=document.getElementById(c);if(l&&l.tagName.toLowerCase()=="table"&&l.className=="CanvasXpress"&&l.id){var m=c;c=this.parseHTMLTable(l,true);b=c.config;c=c.data;l.parentNode.removeChild(l);var j=document.getElementById("temp-table-id-"+m);if(j){j.id=m}else{alert("Dude! What did you do?")}}else{if(!this.isValidURL(c)){alert("Not a valid url\n")}else{this.dataURL=c;c=false}}}else{try{this.stringifyJSON(c)}catch(k){alert("Data object malformed:\n"+k)}}};this.validateConfig=function(){if(b){try{this.stringifyJSON(b)}catch(j){alert("Config object malformed:\n"+j)}}};this.validateEvents=function(){};this.validateInfo=function(){if(!a){a=""}};this.validateAfterRender=function(){if(f){try{this.stringifyJSON(f)}catch(j){alert("AfterRender object malformed:\n"+j)}}};this.isOneTimeFunctionInConfig=function(j){if(!j){j=this}if(j.transposeData){return true}if(j.asSampleFactors&&j.asSampleFactors.length){return true}if(j.asVariableFactors&&j.asVariableFactors.length){return true}if(j.stringSampleFactors&&j.stringSampleFactors.length){return true}if(j.stringVariableFactors&&j.stringVariableFactors.length){return true}if(j.asHistogram){return true}return false};this.afterRender=function(s){if(!s){s=[]}var u=this.meta.time.start;if(this.graphType!="Map"){if(this.asHistogram){if(this.asHistogram===true){s.unshift(["createHistogram",[],{},u])}else{s.unshift(["createHistogram",[this.asHistogram],{},u])}this.asHistogram=false}if(this.stringVariableFactors.length){for(var m=0;m<this.stringVariableFactors.length;m++){s.unshift(["switchNumericToString",[this.stringVariableFactors[m]],{},u])}this.stringVariableFactors=[];this.layoutRestore=false}if(this.stringSampleFactors.length){for(var m=0;m<this.stringSampleFactors.length;m++){s.unshift(["switchNumericToString",[this.stringSampleFactors[m],true],{},u])}this.stringSampleFactors=[];this.layoutRestore=false}if(this.asVariableFactors.length){for(var m=0;m<this.asVariableFactors.length;m++){s.unshift(["switchVarToAnnotation",[this.asVariableFactors[m]],{},u])}this.asVariableFactors=[];this.layoutRestore=false}if(this.asSampleFactors.length){for(var m=0;m<this.asSampleFactors.length;m++){s.unshift(["switchSmpToAnnotation",[this.asSampleFactors[m]],{},u])}this.asSampleFactors=[];this.layoutRestore=false}if(this.transposeData){s.unshift(["transpose",[false,true],{},u]);this.transposeData=false}if(this.selectedDataPoints.length){var r=false;for(var m=0;m<this.selectedDataPoints.length;m++){var l=this.getVariableIndices(this.selectedDataPoints[m]);if(l>=0){this.setSelectObject(false,[l,this.xAxisIndices[0],this.yAxisIndices[0],false]);r=true}}this.selectedDataPoints=[];if(r){s.unshift(["broadcastDraw",[],{},u])}}var n=s.length-1;for(var m=0;m<s.length;m++){var k=s[m];var p=k.shift();var j=k.length>0?k.shift():[];var q=k.length>0?k.shift():{};if(this.showFunctionNamesAfterRender){this.flashInfoSpan(20,20,p)}this.skipRender=!this.showTransition&&m<n?true:false;for(var o in q){this[o]=q[o]}this[p].apply(this,j)}this.triggerDataLoaded("afterRender")}else{this.deferedAfterRender=s}};this.setURL=function(){if(window.location.search!=""){var l=location.search.substring(1).split("&");for(var k=0;k<l.length;k++){var j=l[k].split("=");if(!j[0]||!j[0].match(/^cX/)){continue}this.url[j[0]]=j[1]||true}}};this.createThumbnail=function(){if(this.url.hasOwnProperty("cXprint")||this.printThumbnail){this.printThumbnail=false;var k=this.url.cXprint!==true&&this.url.cXprint!=="true"?this.url.cXprint:this.saveFilename?this.saveFilename:this.target+".png";var j=this;setTimeout(function(){j.print(false,k);setTimeout(function(){window.close()},1000)},1)}};this.setFunctionNames=function(k){var l=function(m){return m&&{}.toString.call(m)==="[object Function]"};for(var j in this){if(this[j]&&!this[j].fname&&l(this[j])){this[j].fname=j;this[j].pname=k||"CanvasXpress"}}};this.setFonts=function(){(function(){if(navigator.onLine&&!CanvasXpress.instances[0].offline){var k=document.createElement("link");k.type="text/css";k.rel="stylesheet";k.href="https://fonts.googleapis.com/css?family=Indie+Flower|Ubuntu|Architects+Daughter|Roboto:400,700,700italic";var j=document.getElementsByTagName("head")[0];j.appendChild(k);var l=new Image();l.onerror=function(){var o=document.createElement("canvas");var n=o.getContext("2d",{willReadFrequently:true});var m="10px Ubuntu";n.font=m;n.fillText("css loaded",100,100);m="10px Indie Flower";n.font=m;n.fillText("css loaded",100,100);m="10px Architects Daughter";n.font=m;n.fillText("css loaded",100,100);m="10px Roboto";n.font=m;n.fillText("css loaded",100,100)};l.src="https://fonts.googleapis.com/css?family=Indie+Flower|Ubuntu|Architects+Daughter|Roboto:400,700,700italic"}}())};if(!e){e=this.createNewTarget()}else{if(typeof(e)=="object"){c=e.data||false;b=e.config||false;i=e.events||false;a=e.info||false;f=e.afterRender||false;d=e.hidden||false;h=e.callback||false;g=e.uploadFile||false;e=e.renderTo||this.createNewTarget()}}this.triggerDataLoaded=function(l){var k=this;var j=function(){if(h){h();h=undefined}console.log("data ready - "+l);k.createThumbnail()};if(CanvasXpress.cacheImagesReady){if(l=="afterRender"){if(!this.isAnimation&&!this.isTransitionOn&&!this.dataURL&&!g&&!this.isUpdateRemoteData&&!d){j()}}else{if(this.graphType=="Network"){if(!this.isAnimation&&!this.isUpdateRemoteData){j()}}else{if(!this.isTransitionOn){j()}}}}};this.initialize=function(){CanvasXpress.instances.push(this);this.setInit();this.setURL();this.initDOM();this.initInterface();this.validateParameters();this.initConfig(b);this.setFonts();this.initViewport(d);this.initPrimitives();this.initUtils();this.initMathUtils();this.initLegendUtils();this.initFilterUtils();this.initClusterUtils();this.initSortUtils();this.initExample();this.initVocabulary();this.initDataUtils();this.initRandom();this.initData(c);this.initValidity();this.initLayout();this.initEvents();this.initTooltip();this.initToolbar();this.initMenus();this.initLinks();this.initConfigurator();this.initDataFilter();this.initDataTable();this.initCodeInfo();this.initBin();this.initDataExplorer();this.initAnimation();this.initRemote();this.initStack(c,b,i,a);this.initTransitions();this.initGraph(this.isOneTimeFunctionInConfig());this.afterRender(f);this.getDataFromURL(e,b,i,a);CanvasXpress.stack[this.target].state.push(this.getConfigState());CanvasXpress.current=this.target;this.meta.time.end=new Date().getTime();this.meta.time.elapsed=this.meta.time.end-this.meta.time.start;this.hideMask()};this.setFunctionNames("init");this.initialize()};CanvasXpress.instances=[];CanvasXpress.config=[];CanvasXpress.transitions={};CanvasXpress.cacheImages={};CanvasXpress.cacheImagesReady=false;CanvasXpress.cachePatterns={};CanvasXpress.cacheText={};CanvasXpress.vocabulary={};CanvasXpress.stack={};CanvasXpress.current=false;CanvasXpress.resizing=false;CanvasXpress.loading=false;CanvasXpress.geo=false;CanvasXpress.system={};CanvasXpress.factory={version:21.6,buildDate:"11-13-2018",client:"",siteSrc:false,valid:null};CanvasXpress.onReady=function(){var f=[];var a=false;var d=false;var c=function(){if(!a){console.log("cx ready");a=true;for(var g=0;g<f.length;g++){f[g].fn.call(window,f[g].ctx)}f=[]}};var b=function(){if(document.readyState==="complete"){c()}};var e=function(){c()};window.onReady=function(h,g){if(a){setTimeout(function(){h(g)},1);return}else{f.push({fn:h,ctx:g})}if(document.readyState==="complete"){setTimeout(c,1)}else{if(!d){if(document.addEventListener){document.addEventListener("DOMContentLoaded",c,false);window.addEventListener("load",e,false)}else{document.attachEvent("onreadystatechange",b);window.attachEvent("onload",e)}d=true}}}}();CanvasXpress.loadScripts=function(){var i=0;CanvasXpress.loading=true;return function(files,callback,scope){var head=document.getElementsByTagName("head")[0];var loadScript=function(s,c){var t=s.type;if(t.match(/javascript/i)){s.onreadystatechange=function(){if(s.readyState==="loaded"||s.readyState==="complete"){s.onreadystatechange=null;c()}};s.onload=function(){c()};head.appendChild(s)}else{head.appendChild(s);c()}};var count=function(){if(i===files.length){i=0;if(callback){CanvasXpress.loading=false;if(typeof(callback)=="function"){callback.call(scope)}else{if(typeof(callback)=="string"){eval("var fn = "+callback);fn()}}}}else{CanvasXpress.loadScripts(files,callback,scope)}};i++;loadScript(files[i-1],count)}}();CanvasXpress.transferDatasetAttributes=function(e,a,f){var d=JSON.parse(JSON.stringify(e.dataset));for(var c in d){if(d.hasOwnProperty(c)){if(f){a[c.replace(/^data-/,"")]=d[c]}else{var b="data-"+c.replace(/([a-zA-Z])(?=[A-Z])/g,"$1-").toLowerCase();a.setAttribute(b,d[c])}}}};CanvasXpress.initCanvas=function(){var d=document.getElementsByTagName("canvas");for(var b=0;b<d.length;b++){var f=d[b];if(f.className=="CanvasXpress"&&f.id){var e=false;var a={};if(f.hasAttribute("data-src")&&!obj){e=f.getAttribute("data-src");CanvasXpress.transferDatasetAttributes(f,a,true);if(Object.keys(a).length){new CanvasXpress(f.id,e,a)}else{new CanvasXpress(f.id,e)}}}}};CanvasXpress.initImage=function(){var a=document.getElementsByTagName("img");for(var c=0;c<a.length;c++){var g=a[c];if(g.className=="CanvasXpress"&&g.id){var f=CanvasXpress.getObject(g.id);var d=g.parentNode;if(!f){var e=g.src;var h=g.id;var b=document.createElement("canvas");b.width=g.clientWidth;b.height=g.clientHeight;CanvasXpress.transferDatasetAttributes(g,b);d.removeChild(g);b.id=h;d.appendChild(b);new CanvasXpress(h,e)}}}};CanvasXpress.initTable=function(){var c=document.getElementsByTagName("table");for(var b=0;b<c.length;b++){var e=c[b];if(e.className=="CanvasXpress"&&e.id){var g=CanvasXpress.getObject(e.id);var d=e.parentNode;if(!g){var f=e.id;var a=document.createElement("canvas");a.id="temp-table-id-"+e.id;a.width=e.hasAttribute("data-width")?e.getAttribute("data-width"):500;a.height=e.hasAttribute("data-height")?e.getAttribute("data-height"):500;CanvasXpress.transferDatasetAttributes(e,a);d.appendChild(a);new CanvasXpress({data:f,renderTo:f})}}}};CanvasXpress.getObject=function(c,b){for(var a=0;a<CanvasXpress.instances.length;a++){if(CanvasXpress.instances[a].target==c){return CanvasXpress.instances[a]}}if(b){return CanvasXpress.injectObject(c)}};CanvasXpress.$=function(b,a){return CanvasXpress.getObject(b,a)};CanvasXpress.destroy=function(a){if(CanvasXpress.instances.length>0){CanvasXpress.instances[0].destroy(a)}};CanvasXpress.injectObject=function(d){var a=document.getElementById(d);if(!a){var b=document.createElement("canvas");b.id=d;b.width=100;b.height=100;document.body.appendChild(b);a=new CanvasXpress({renderTo:d,hidden:true})}return a};CanvasXpress.setExampleContainer=function(a){if(!a){a="Show-All"}var j=CanvasXpress.getObject("CanvasXpress-Silent",true);var d=j.getWindowSize();var e=j.getWindowScroll();var c=Math.max(0,((d[0]-500)/2)+e[0]);var h=Math.max(0,((d[1]-500)/2)+e[1]);var g=j.$cX("div",{id:a+"-cX-API-Example",className:"CanvasXpressConfiguratorExample draggable"},{width:"513px",maxHeight:"505px",cursor:"move",display:"block",padding:"10px",position:"absolute",overflow:"hidden",paddingBottom:"25px",paddingRight:"5px",left:c+"px",top:h+"px"});var b=j.$cX("span",{id:a+"-cX-API-ExampleSpan",className:"CanvasXpressConfiguratorExample",innerHTML:""});var f=j.$cX("img",{id:a+"-cX-API-ExampleClose",className:"CanvasXpressConfigurator",property:a,src:CanvasXpress.images.cancel,alt:"Close",title:"Close"},{marginTop:"-5px"});var i=j.$cX("div",{id:a+"-cX-API-ExampleContent",className:"CanvasXpressConfiguratorExampleContent"},{width:"513px",maxHeight:"505px",overflow:"auto",padding:"1px"});g.appendChild(b);g.appendChild(f);g.appendChild(j.$cX("br"));g.appendChild(i);document.body.appendChild(g);f.onclick=function(){var k=j.$(this.property+"-cX-API-Example");if(k){j.destroyInDOM(k.getElementsByTagName("canvas"));k.parentNode.removeChild(k)}};return j};CanvasXpress.showExample=function(c,b){if(b){var a=CanvasXpress.setExampleContainer(b);a.stopEvent(c);a.cancelEvent(c);a.clickExamplePropertyDescription(c,b,true);return false}};CanvasXpress.showAllExamples=function(B,C){var o=CanvasXpress.setExampleContainer(C);o.stopEvent(B);o.cancelEvent(B);o.resetPropertyExample();var w=function(){var v={};var p=C?[C]:o.getKeys(CanvasXpress.doc.M).sort();for(var t=0;t<p.length;t++){var c=p[t];for(var e=0;e<CanvasXpress.doc.M[c]["P"].length;e++){var F=CanvasXpress.doc.M[c]["P"][e];var E=CanvasXpress.doc.P[F];if(E.H){v[F]=o.getExamplesDocObject(F)}}}return v};var l=function(j,c){var p=["sankey","tree","bubble"];for(var e=0;e<p.length;e++){delete (j[p[e]]);delete (c[p[e]])}return j?j:c};var d=function(){if(o.graphType!=n){n=o.graphType;D=o.getDataSet()}return D};var A=o.$(C+"-cX-API-Example");var f=o.$(C+"-cX-API-ExampleSpan");var r=o.$(C+"-cX-API-ExampleContent");var n=o.graphType;var D=o.getDataSet();if(A&&f&&r){A.style.display="block";f.innerHTML=C;var b=w();for(var s in b){var g=b[s];for(var y=0;y<g.length;y++){var u=g[y][0];var z=g[y][2];o.graphType=z.graphType;var q=l(o.cloneObject(g[y][1]),d());var k=g[y][3];var h=o.$cX("canvas",{id:u,width:500,height:500});r.appendChild(h);if(!z.title){if(z[s]!=null){if(o.isArray(z[s])){z.title=s+" : "+z[s].join(",")}else{if(o.isObject(z[s])){z.title=s+" : Object"}else{z.title=s+" : "+z[s]}}}else{z.title=s+" : null"}}var m=new CanvasXpress(u,q,z);if(k){for(var x=0;x<k.length;x++){if(k[x].match(/:/)){var a=k[x].split(":");m[a.shift()].apply(m,a)}else{m[k[x]]()}}}}}}return false};CanvasXpress.letters=["A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z"];CanvasXpress.countries={AFG:["Afghanistan","Asia","South Asia"],ALA:["Aland Islands","Europe","North Europe"],ALB:["Albania","Europe","South Europe"],DZA:["Algeria","Africa","North Africa"],ASM:["American Samoa","Oceania","Polynesia"],AND:["Andorra","Europe","South Europe"],AGO:["Angola","Africa","Middle Africa"],AIA:["Anguilla","America","Caribbean"],ATA:["Antarctica","",""],ATG:["Antigua and Barbuda","America","Caribbean"],ARG:["Argentina","America","South America"],ARM:["Armenia","Asia","West Asia"],ABW:["Aruba","America","Caribbean"],AUS:["Australia","Oceania","Australia and New Zealand"],AUT:["Austria","Europe","West Europe"],AZE:["Azerbaijan","Asia","West Asia"],BHS:["Bahamas","America","Caribbean"],BHR:["Bahrain","Asia","West Asia"],BGD:["Bangladesh","Asia","South Asia"],BRB:["Barbados","America","Caribbean"],BLR:["Belarus","Europe","East Europe"],BEL:["Belgium","Europe","West Europe"],BLZ:["Belize","America","Central America"],BEN:["Benin","Africa","West Africa"],BMU:["Bermuda","America","North America"],BTN:["Bhutan","Asia","South Asia"],BOL:["Bolivia","America","South America"],BES:["Bonaire","America","Caribbean"],BIH:["Bosnia and Herzegovina","Europe","South Europe"],BWA:["Botswana","Africa","South Africa"],BVT:["Bouvet Island","",""],BRA:["Brazil","America","South America"],IOT:["British Indian Ocean Territory","",""],BRN:["Brunei Darussalam","Asia","South-East Asia"],BGR:["Bulgaria","Europe","East Europe"],BFA:["Burkina Faso","Africa","West Africa"],BDI:["Burundi","Africa","East Africa"],KHM:["Cambodia","Asia","South-East Asia"],CMR:["Cameroon","Africa","Middle Africa"],CAN:["Canada","America","North America"],CPV:["Cabo Verde","Africa","West Africa"],CYM:["Cayman Islands","America","Caribbean"],CAF:["Central African Republic","Africa","Middle Africa"],TCD:["Chad","Africa","Middle Africa"],CHL:["Chile","America","South America"],CHN:["China","Asia","East Asia"],CXR:["Christmas Island","",""],CCK:["Cocos (Keeling) Islands","",""],COL:["Colombia","America","South America"],COM:["Comoros","Africa","East Africa"],COG:["Congo","Africa","Middle Africa"],COD:["Congo (Democratic Republic of the)","Africa","Middle Africa"],COK:["Cook Islands","Oceania","Polynesia"],CRI:["Costa Rica","America","Central America"],CIV:["Cote d'Ivoire","Africa","West Africa"],HRV:["Croatia","Europe","South Europe"],CUB:["Cuba","America","Caribbean"],CUW:["Curaçao","America","Caribbean"],CYP:["Cyprus","Asia","West Asia"],CZE:["Czech Republic","Europe","East Europe"],DNK:["Denmark","Europe","North Europe"],DJI:["Djibouti","Africa","East Africa"],DMA:["Dominica","America","Caribbean"],DOM:["Dominican Republic","America","Caribbean"],ECU:["Ecuador","America","South America"],EGY:["Egypt","Africa","North Africa"],SLV:["El Salvador","America","Central America"],GNQ:["Equatorial Guinea","Africa","Middle Africa"],ERI:["Eritrea","Africa","East Africa"],EST:["Estonia","Europe","North Europe"],ETH:["Ethiopia","Africa","East Africa"],FLK:["Falkland Islands","America","South America"],FRO:["Faroe Islands","Europe","North Europe"],FJI:["Fiji","Oceania","Melanesia"],FIN:["Finland","Europe","North Europe"],FRA:["France","Europe","West Europe"],GUF:["French Guiana","America","South America"],PYF:["French Polynesia","Oceania","Polynesia"],ATF:["French Southern Territories","",""],GAB:["Gabon","Africa","Middle Africa"],GMB:["Gambia","Africa","West Africa"],GEO:["Georgia","Asia","West Asia"],DEU:["Germany","Europe","West Europe"],GHA:["Ghana","Africa","West Africa"],GIB:["Gibraltar","Europe","South Europe"],GRC:["Greece","Europe","South Europe"],GRL:["Greenland","America","North America"],GRD:["Grenada","America","Caribbean"],GLP:["Guadeloupe","America","Caribbean"],GUM:["Guam","Oceania","Micronesia"],GTM:["Guatemala","America","Central America"],GGY:["Guernsey","Europe","North Europe"],GIN:["Guinea","Africa","West Africa"],GNB:["Guinea-Bissau","Africa","West Africa"],GUY:["Guyana","America","South America"],HTI:["Haiti","America","Caribbean"],HMD:["Heard Island and McDonald Islands","",""],VAT:["Holy See","Europe","South Europe"],HND:["Honduras","America","Central America"],HKG:["Hong Kong","Asia","East Asia"],HUN:["Hungary","Europe","East Europe"],ISL:["Iceland","Europe","North Europe"],IND:["India","Asia","South Asia"],IDN:["Indonesia","Asia","South-East Asia"],IRN:["Iran","Asia","South Asia"],IRQ:["Iraq","Asia","West Asia"],IRL:["Ireland","Europe","North Europe"],IMN:["Isle of Man","Europe","North Europe"],ISR:["Israel","Asia","West Asia"],ITA:["Italy","Europe","South Europe"],JAM:["Jamaica","America","Caribbean"],JPN:["Japan","Asia","East Asia"],JEY:["Jersey","Europe","North Europe"],JOR:["Jordan","Asia","West Asia"],KAZ:["Kazakhstan","Asia","Central Asia"],KEN:["Kenya","Africa","East Africa"],KIR:["Kiribati","Oceania","Micronesia"],PRK:["Korea (Democratic People's Republic of)","Asia","East Asia"],KOR:["Korea (Republic of)","Asia","East Asia"],KWT:["Kuwait","Asia","West Asia"],KGZ:["Kyrgyzstan","Asia","Central Asia"],LAO:["Lao People's Democratic Republic","Asia","South-East Asia"],LVA:["Latvia","Europe","North Europe"],LBN:["Lebanon","Asia","West Asia"],LSO:["Lesotho","Africa","South Africa"],LBR:["Liberia","Africa","West Africa"],LBY:["Libya","Africa","North Africa"],LIE:["Liechtenstein","Europe","West Europe"],LTU:["Lithuania","Europe","North Europe"],LUX:["Luxembourg","Europe","West Europe"],MAC:["Macao","Asia","East Asia"],MKD:["Macedonia","Europe","South Europe"],MDG:["Madagascar","Africa","East Africa"],MWI:["Malawi","Africa","East Africa"],MYS:["Malaysia","Asia","South-East Asia"],MDV:["Maldives","Asia","South Asia"],MLI:["Mali","Africa","West Africa"],MLT:["Malta","Europe","South Europe"],MHL:["Marshall Islands","Oceania","Micronesia"],MTQ:["Martinique","America","Caribbean"],MRT:["Mauritania","Africa","West Africa"],MUS:["Mauritius","Africa","East Africa"],MYT:["Mayotte","Africa","East Africa"],MEX:["Mexico","America","Central America"],FSM:["Micronesia","Oceania","Micronesia"],MDA:["Moldova","Europe","East Europe"],MCO:["Monaco","Europe","West Europe"],MNG:["Mongolia","Asia","East Asia"],MNE:["Montenegro","Europe","South Europe"],MSR:["Montserrat","America","Caribbean"],MAR:["Morocco","Africa","North Africa"],MOZ:["Mozambique","Africa","East Africa"],MMR:["Myanmar","Asia","South-East Asia"],NAM:["Namibia","Africa","South Africa"],NRU:["Nauru","Oceania","Micronesia"],NPL:["Nepal","Asia","South Asia"],NLD:["Netherlands","Europe","West Europe"],NCL:["New Caledonia","Oceania","Melanesia"],NZL:["New Zealand","Oceania","Australia and New Zealand"],NIC:["Nicaragua","America","Central America"],NER:["Niger","Africa","West Africa"],NGA:["Nigeria","Africa","West Africa"],NIU:["Niue","Oceania","Polynesia"],NFK:["Norfolk Island","Oceania","Australia and New Zealand"],MNP:["West Mariana Islands","Oceania","Micronesia"],NOR:["Norway","Europe","North Europe"],OMN:["Oman","Asia","West Asia"],PAK:["Pakistan","Asia","South Asia"],PLW:["Palau","Oceania","Micronesia"],PSE:["Palestine","Asia","West Asia"],PAN:["Panama","America","Central America"],PNG:["Papua New Guinea","Oceania","Melanesia"],PRY:["Paraguay","America","South America"],PER:["Peru","America","South America"],PHL:["Philippines","Asia","South-East Asia"],PCN:["Pitcairn","Oceania","Polynesia"],POL:["Poland","Europe","East Europe"],PRT:["Portugal","Europe","South Europe"],PRI:["Puerto Rico","America","Caribbean"],QAT:["Qatar","Asia","West Asia"],REU:["Réunion","Africa","East Africa"],ROU:["Romania","Europe","East Europe"],RUS:["Russian Federation","Europe","East Europe"],RWA:["Rwanda","Africa","East Africa"],BLM:["Saint Barthelemy","America","Caribbean"],SHN:["Saint Helena","Africa","West Africa"],KNA:["Saint Kitts and Nevis","America","Caribbean"],LCA:["Saint Lucia","America","Caribbean"],MAF:["Saint Martin","America","Caribbean"],SPM:["Saint Pierre and Miquelon","America","North America"],VCT:["Saint Vincent and the Grenadines","America","Caribbean"],WSM:["Samoa","Oceania","Polynesia"],SMR:["San Marino","Europe","South Europe"],STP:["Sao Tome and Principe","Africa","Middle Africa"],SAU:["Saudi Arabia","Asia","West Asia"],SEN:["Senegal","Africa","West Africa"],SRB:["Serbia","Europe","South Europe"],SYC:["Seychelles","Africa","East Africa"],SLE:["Sierra Leone","Africa","West Africa"],SGP:["Singapore","Asia","South-East Asia"],SXM:["Sint Maarten","America","Caribbean"],SVK:["Slovakia","Europe","East Europe"],SVN:["Slovenia","Europe","South Europe"],SLB:["Solomon Islands","Oceania","Melanesia"],SOM:["Somalia","Africa","East Africa"],ZAF:["South Africa","Africa","South Africa"],SGS:["South Georgia and the South Sandwich Islands","",""],SSD:["South Sudan","Africa","East Africa"],ESP:["Spain","Europe","South Europe"],LKA:["Sri Lanka","Asia","South Asia"],SDN:["Sudan","Africa","North Africa"],SUR:["Suriname","America","South America"],SJM:["Svalbard and Jan Mayen","Europe","North Europe"],SWZ:["Swaziland","Africa","South Africa"],SWE:["Sweden","Europe","North Europe"],CHE:["Switzerland","Europe","West Europe"],SYR:["Syrian Arab Republic","Asia","West Asia"],TWN:["Taiwan","Asia","East Asia"],TJK:["Tajikistan","Asia","Central Asia"],TZA:["Tanzania","Africa","East Africa"],THA:["Thailand","Asia","South-East Asia"],TLS:["Timor-Leste","Asia","South-East Asia"],TGO:["Togo","Africa","West Africa"],TKL:["Tokelau","Oceania","Polynesia"],TON:["Tonga","Oceania","Polynesia"],TTO:["Trinidad and Tobago","America","Caribbean"],TUN:["Tunisia","Africa","North Africa"],TUR:["Turkey","Asia","West Asia"],TKM:["Turkmenistan","Asia","Central Asia"],TCA:["Turks and Caicos Islands","America","Caribbean"],TUV:["Tuvalu","Oceania","Polynesia"],UGA:["Uganda","Africa","East Africa"],UKR:["Ukraine","Europe","East Europe"],ARE:["United Arab Emirates","Asia","West Asia"],GBR:["United Kingdom of Great Britain and Northern Ireland","Europe","North Europe"],USA:["United States of America","America","North America"],UMI:["United States Minor Outlying Islands","",""],URY:["Uruguay","America","South America"],UZB:["Uzbekistan","Asia","Central Asia"],VUT:["Vanuatu","Oceania","Melanesia"],VEN:["Venezuela","America","South America"],VNM:["Vietnam","Asia","South-East Asia"],VGB:["Virgin Islands (British)","America","Caribbean"],VIR:["Virgin Islands (U.S.)","America","Caribbean"],WLF:["Wallis and Futuna","Oceania","Polynesia"],ESH:["Western Sahara","Africa","North Africa"],YEM:["Yemen","Asia","West Asia"],ZMB:["Zambia","Africa","East Africa"],ZWE:["Zimbabwe","Africa","East Africa"]};CanvasXpress.chromosomes={hg19:{columns:["start","end","name","stain"],order:[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,"X","Y"],data:{1:[[0,2300000,"p36.33","gneg"],[2300000,5300000,"p36.32","gpos25"],[5300000,7100000,"p36.31","gneg"],[7100000,9200000,"p36.23","gpos25"],[9200000,12600000,"p36.22","gneg"],[12600000,16100000,"p36.21","gpos50"],[16100000,20300000,"p36.13","gneg"],[20300000,23800000,"p36.12","gpos25"],[23800000,27800000,"p36.11","gneg"],[27800000,30000000,"p35.3","gpos25"],[30000000,32200000,"p35.2","gneg"],[32200000,34400000,"p35.1","gpos25"],[34400000,39600000,"p34.3","gneg"],[39600000,43900000,"p34.2","gpos25"],[43900000,46500000,"p34.1","gneg"],[46500000,51300000,"p33","gpos75"],[51300000,56200000,"p32.3","gneg"],[56200000,58700000,"p32.2","gpos50"],[58700000,60900000,"p32.1","gneg"],[60900000,68700000,"p31.3","gpos50"],[68700000,69500000,"p31.2","gneg"],[69500000,84700000,"p31.1","gpos100"],[84700000,88100000,"p22.3","gneg"],[88100000,92000000,"p22.2","gpos75"],[92000000,94500000,"p22.1","gneg"],[94500000,99400000,"p21.3","gpos75"],[99400000,102000000,"p21.2","gneg"],[102000000,107000000,"p21.1","gpos100"],[107000000,111600000,"p13.3","gneg"],[111600000,115900000,"p13.2","gpos50"],[115900000,117600000,"p13.1","gneg"],[117600000,120700000,"p12","gpos50"],[120700000,121100000,"p11.2","gneg"],[121100000,124300000,"p11.1","acen"],[124300000,128000000,"q11","acen"],[128000000,142400000,"q12","gvar"],[142400000,148000000,"q21.1","gneg"],[148000000,149600000,"q21.2","gpos50"],[149600000,153300000,"q21.3","gneg"],[153300000,154800000,"q22","gpos50"],[154800000,157300000,"q23.1","gneg"],[157300000,158800000,"q23.2","gpos50"],[158800000,163800000,"q23.3","gneg"],[163800000,165500000,"q24.1","gpos50"],[165500000,169100000,"q24.2","gneg"],[169100000,171200000,"q24.3","gpos75"],[171200000,174300000,"q25.1","gneg"],[174300000,178600000,"q25.2","gpos50"],[178600000,184000000,"q25.3","gneg"],[184000000,189000000,"q31.1","gpos100"],[189000000,192100000,"q31.2","gneg"],[192100000,197500000,"q31.3","gpos100"],[197500000,205300000,"q32.1","gneg"],[205300000,209500000,"q32.2","gpos25"],[209500000,212100000,"q32.3","gneg"],[212100000,222100000,"q41","gpos100"],[222100000,222700000,"q42.11","gneg"],[222700000,225100000,"q42.12","gpos25"],[225100000,228800000,"q42.13","gneg"],[228800000,232700000,"q42.2","gpos50"],[232700000,234600000,"q42.3","gneg"],[234600000,241700000,"q43","gpos75"],[241700000,247249719,"q44","gneg"]],2:[[0,4300000,"p25.3","gneg"],[4300000,7000000,"p25.2","gpos50"],[7000000,12800000,"p25.1","gneg"],[12800000,17000000,"p24.3","gpos75"],[17000000,19100000,"p24.2","gneg"],[19100000,23900000,"p24.1","gpos75"],[23900000,27700000,"p23.3","gneg"],[27700000,29800000,"p23.2","gpos25"],[29800000,31900000,"p23.1","gneg"],[31900000,36400000,"p22.3","gpos75"],[36400000,38400000,"p22.2","gneg"],[38400000,41600000,"p22.1","gpos50"],[41600000,47600000,"p21","gneg"],[47600000,52700000,"p16.3","gpos100"],[52700000,54800000,"p16.2","gneg"],[54800000,61100000,"p16.1","gpos100"],[61100000,64000000,"p15","gneg"],[64000000,70500000,"p14","gpos50"],[70500000,72600000,"p13.3","gneg"],[72600000,73900000,"p13.2","gpos50"],[73900000,75400000,"p13.1","gneg"],[75400000,83700000,"p12","gpos100"],[83700000,91000000,"p11.2","gneg"],[91000000,93300000,"p11.1","acen"],[93300000,95700000,"q11.1","acen"],[95700000,102100000,"q11.2","gneg"],[102100000,105300000,"q12.1","gpos50"],[105300000,106700000,"q12.2","gneg"],[106700000,108600000,"q12.3","gpos25"],[108600000,113800000,"q13","gneg"],[113800000,118600000,"q14.1","gpos50"],[118600000,122100000,"q14.2","gneg"],[122100000,129600000,"q14.3","gpos50"],[129600000,132200000,"q21.1","gneg"],[132200000,134800000,"q21.2","gpos25"],[134800000,136600000,"q21.3","gneg"],[136600000,142400000,"q22.1","gpos100"],[142400000,144700000,"q22.2","gneg"],[144700000,148400000,"q22.3","gpos100"],[148400000,149600000,"q23.1","gneg"],[149600000,150300000,"q23.2","gpos25"],[150300000,154600000,"q23.3","gneg"],[154600000,159600000,"q24.1","gpos75"],[159600000,163500000,"q24.2","gneg"],[163500000,169500000,"q24.3","gpos75"],[169500000,177700000,"q31.1","gneg"],[177700000,180400000,"q31.2","gpos50"],[180400000,182700000,"q31.3","gneg"],[182700000,189100000,"q32.1","gpos75"],[189100000,191600000,"q32.2","gneg"],[191600000,197100000,"q32.3","gpos75"],[197100000,203500000,"q33.1","gneg"],[203500000,205600000,"q33.2","gpos50"],[205600000,209100000,"q33.3","gneg"],[209100000,215100000,"q34","gpos100"],[215100000,221300000,"q35","gneg"],[221300000,224900000,"q36.1","gpos75"],[224900000,225800000,"q36.2","gneg"],[225800000,230700000,"q36.3","gpos100"],[230700000,235300000,"q37.1","gneg"],[235300000,237000000,"q37.2","gpos50"],[237000000,242951149,"q37.3","gneg"]],3:[[0,3500000,"p26.3","gpos50"],[3500000,5500000,"p26.2","gneg"],[5500000,8700000,"p26.1","gpos50"],[8700000,11500000,"p25.3","gneg"],[11500000,12400000,"p25.2","gpos25"],[12400000,14700000,"p25.1","gneg"],[14700000,23800000,"p24.3","gpos100"],[23800000,26400000,"p24.2","gneg"],[26400000,30800000,"p24.1","gpos75"],[30800000,32100000,"p23","gneg"],[32100000,36500000,"p22.3","gpos50"],[36500000,39300000,"p22.2","gneg"],[39300000,43600000,"p22.1","gpos75"],[43600000,44400000,"p21.33","gneg"],[44400000,44700000,"p21.32","gpos50"],[44700000,51400000,"p21.31","gneg"],[51400000,51700000,"p21.2","gpos25"],[51700000,54400000,"p21.1","gneg"],[54400000,58500000,"p14.3","gpos50"],[58500000,63700000,"p14.2","gneg"],[63700000,71800000,"p14.1","gpos50"],[71800000,74200000,"p13","gneg"],[74200000,81800000,"p12.3","gpos75"],[81800000,83700000,"p12.2","gneg"],[83700000,87200000,"p12.1","gpos75"],[87200000,89400000,"p11.2","gneg"],[89400000,91700000,"p11.1","acen"],[91700000,93200000,"q11.1","acen"],[93200000,99800000,"q11.2","gvar"],[99800000,101500000,"q12.1","gneg"],[101500000,102500000,"q12.2","gpos25"],[102500000,104400000,"q12.3","gneg"],[104400000,107800000,"q13.11","gpos75"],[107800000,109500000,"q13.12","gneg"],[109500000,112800000,"q13.13","gpos50"],[112800000,115000000,"q13.2","gneg"],[115000000,118800000,"q13.31","gpos75"],[118800000,120500000,"q13.32","gneg"],[120500000,123400000,"q13.33","gpos75"],[123400000,125400000,"q21.1","gneg"],[125400000,127700000,"q21.2","gpos25"],[127700000,131500000,"q21.3","gneg"],[131500000,135700000,"q22.1","gpos25"],[135700000,137400000,"q22.2","gneg"],[137400000,140400000,"q22.3","gpos25"],[140400000,144400000,"q23","gneg"],[144400000,150400000,"q24","gpos100"],[150400000,153500000,"q25.1","gneg"],[153500000,156300000,"q25.2","gpos50"],[156300000,158100000,"q25.31","gneg"],[158100000,159900000,"q25.32","gpos50"],[159900000,161200000,"q25.33","gneg"],[161200000,169200000,"q26.1","gpos100"],[169200000,172500000,"q26.2","gneg"],[172500000,177300000,"q26.31","gpos75"],[177300000,180600000,"q26.32","gneg"],[180600000,184200000,"q26.33","gpos75"],[184200000,186000000,"q27.1","gneg"],[186000000,187500000,"q27.2","gpos25"],[187500000,189400000,"q27.3","gneg"],[189400000,193800000,"q28","gpos75"],[193800000,199501827,"q29","gneg"]],4:[[0,3100000,"p16.3","gneg"],[3100000,5200000,"p16.2","gpos25"],[5200000,10900000,"p16.1","gneg"],[10900000,15300000,"p15.33","gpos50"],[15300000,18500000,"p15.32","gneg"],[18500000,23100000,"p15.31","gpos75"],[23100000,27900000,"p15.2","gneg"],[27900000,35500000,"p15.1","gpos100"],[35500000,40900000,"p14","gneg"],[40900000,45600000,"p13","gpos50"],[45600000,48700000,"p12","gneg"],[48700000,50700000,"p11","acen"],[50700000,52400000,"q11","acen"],[52400000,59200000,"q12","gneg"],[59200000,66300000,"q13.1","gpos100"],[66300000,70400000,"q13.2","gneg"],[70400000,76500000,"q13.3","gpos75"],[76500000,79200000,"q21.1","gneg"],[79200000,82600000,"q21.21","gpos50"],[82600000,84300000,"q21.22","gneg"],[84300000,87100000,"q21.23","gpos25"],[87100000,88200000,"q21.3","gneg"],[88200000,94000000,"q22.1","gpos75"],[94000000,95400000,"q22.2","gneg"],[95400000,99100000,"q22.3","gpos75"],[99100000,102500000,"q23","gneg"],[102500000,107900000,"q24","gpos50"],[107900000,114100000,"q25","gneg"],[114100000,120600000,"q26","gpos75"],[120600000,124000000,"q27","gneg"],[124000000,129100000,"q28.1","gpos50"],[129100000,131300000,"q28.2","gneg"],[131300000,139500000,"q28.3","gpos100"],[139500000,141700000,"q31.1","gneg"],[141700000,145000000,"q31.21","gpos25"],[145000000,147700000,"q31.22","gneg"],[147700000,151000000,"q31.23","gpos25"],[151000000,155100000,"q31.3","gneg"],[155100000,161500000,"q32.1","gpos100"],[161500000,164500000,"q32.2","gneg"],[164500000,170400000,"q32.3","gpos100"],[170400000,172200000,"q33","gneg"],[172200000,176600000,"q34.1","gpos75"],[176600000,177800000,"q34.2","gneg"],[177800000,182600000,"q34.3","gpos100"],[182600000,187300000,"q35.1","gneg"],[187300000,191273063,"q35.2","gpos25"]],5:[[0,4400000,"p15.33","gneg"],[4400000,6000000,"p15.32","gpos25"],[6000000,8200000,"p15.31","gneg"],[8200000,15100000,"p15.2","gpos50"],[15100000,18500000,"p15.1","gneg"],[18500000,23300000,"p14.3","gpos100"],[23300000,24700000,"p14.2","gneg"],[24700000,29300000,"p14.1","gpos100"],[29300000,34400000,"p13.3","gneg"],[34400000,38500000,"p13.2","gpos25"],[38500000,42400000,"p13.1","gneg"],[42400000,45800000,"p12","gpos50"],[45800000,47700000,"p11","acen"],[47700000,50500000,"q11.1","acen"],[50500000,58900000,"q11.2","gneg"],[58900000,63000000,"q12.1","gpos75"],[63000000,63700000,"q12.2","gneg"],[63700000,66500000,"q12.3","gpos75"],[66500000,68400000,"q13.1","gneg"],[68400000,73300000,"q13.2","gpos50"],[73300000,76400000,"q13.3","gneg"],[76400000,81300000,"q14.1","gpos50"],[81300000,82800000,"q14.2","gneg"],[82800000,91900000,"q14.3","gpos100"],[91900000,97300000,"q15","gneg"],[97300000,102800000,"q21.1","gpos100"],[102800000,104500000,"q21.2","gneg"],[104500000,109600000,"q21.3","gpos100"],[109600000,111500000,"q22.1","gneg"],[111500000,113100000,"q22.2","gpos50"],[113100000,115200000,"q22.3","gneg"],[115200000,121500000,"q23.1","gpos100"],[121500000,127300000,"q23.2","gneg"],[127300000,130400000,"q23.3","gpos100"],[130400000,135400000,"q31.1","gneg"],[135400000,139000000,"q31.2","gpos25"],[139000000,143100000,"q31.3","gneg"],[143100000,147200000,"q32","gpos75"],[147200000,152100000,"q33.1","gneg"],[152100000,155600000,"q33.2","gpos50"],[155600000,159900000,"q33.3","gneg"],[159900000,167400000,"q34","gpos100"],[167400000,172200000,"q35.1","gneg"],[172200000,176500000,"q35.2","gpos25"],[176500000,180857866,"q35.3","gneg"]],6:[[0,2300000,"p25.3","gneg"],[2300000,4100000,"p25.2","gpos25"],[4100000,7000000,"p25.1","gneg"],[7000000,10600000,"p24.3","gpos50"],[10600000,11200000,"p24.2","gneg"],[11200000,13500000,"p24.1","gpos25"],[13500000,15500000,"p23","gneg"],[15500000,23500000,"p22.3","gpos75"],[23500000,26100000,"p22.2","gneg"],[26100000,29900000,"p22.1","gpos50"],[29900000,31900000,"p21.33","gneg"],[31900000,33600000,"p21.32","gpos25"],[33600000,36800000,"p21.31","gneg"],[36800000,40600000,"p21.2","gpos25"],[40600000,45200000,"p21.1","gneg"],[45200000,51100000,"p12.3","gpos100"],[51100000,52600000,"p12.2","gneg"],[52600000,57200000,"p12.1","gpos100"],[57200000,58400000,"p11.2","gneg"],[58400000,60500000,"p11.1","acen"],[60500000,63400000,"q11.1","acen"],[63400000,63500000,"q11.2","gneg"],[63500000,70000000,"q12","gpos100"],[70000000,75900000,"q13","gneg"],[75900000,83900000,"q14.1","gpos50"],[83900000,84700000,"q14.2","gneg"],[84700000,87500000,"q14.3","gpos50"],[87500000,92100000,"q15","gneg"],[92100000,98700000,"q16.1","gpos100"],[98700000,99900000,"q16.2","gneg"],[99900000,104800000,"q16.3","gpos100"],[104800000,113900000,"q21","gneg"],[113900000,117100000,"q22.1","gpos75"],[117100000,118600000,"q22.2","gneg"],[118600000,126200000,"q22.31","gpos100"],[126200000,127300000,"q22.32","gneg"],[127300000,130400000,"q22.33","gpos75"],[130400000,131300000,"q23.1","gneg"],[131300000,135200000,"q23.2","gpos50"],[135200000,139100000,"q23.3","gneg"],[139100000,142900000,"q24.1","gpos75"],[142900000,145700000,"q24.2","gneg"],[145700000,149100000,"q24.3","gpos75"],[149100000,152600000,"q25.1","gneg"],[152600000,155600000,"q25.2","gpos50"],[155600000,160900000,"q25.3","gneg"],[160900000,164400000,"q26","gpos50"],[164400000,170899992,"q27","gneg"]],7:[[0,2100000,"p22.3","gneg"],[2100000,4500000,"p22.2","gpos25"],[4500000,7200000,"p22.1","gneg"],[7200000,13300000,"p21.3","gpos100"],[13300000,15200000,"p21.2","gneg"],[15200000,19500000,"p21.1","gpos100"],[19500000,24900000,"p15.3","gneg"],[24900000,28000000,"p15.2","gpos50"],[28000000,31800000,"p15.1","gneg"],[31800000,35600000,"p14.3","gpos75"],[35600000,37500000,"p14.2","gneg"],[37500000,43300000,"p14.1","gpos75"],[43300000,46600000,"p13","gneg"],[46600000,49800000,"p12.3","gpos75"],[49800000,50900000,"p12.2","gneg"],[50900000,53900000,"p12.1","gpos75"],[53900000,57400000,"p11.2","gneg"],[57400000,59100000,"p11.1","acen"],[59100000,61100000,"q11.1","acen"],[61100000,66100000,"q11.21","gneg"],[66100000,71800000,"q11.22","gpos50"],[71800000,77400000,"q11.23","gneg"],[77400000,86200000,"q21.11","gpos100"],[86200000,88000000,"q21.12","gneg"],[88000000,90900000,"q21.13","gpos75"],[90900000,92600000,"q21.2","gneg"],[92600000,97900000,"q21.3","gpos75"],[97900000,104400000,"q22.1","gneg"],[104400000,105900000,"q22.2","gpos50"],[105900000,107200000,"q22.3","gneg"],[107200000,114400000,"q31.1","gpos75"],[114400000,117200000,"q31.2","gneg"],[117200000,120900000,"q31.31","gpos75"],[120900000,123600000,"q31.32","gneg"],[123600000,126900000,"q31.33","gpos75"],[126900000,129000000,"q32.1","gneg"],[129000000,130100000,"q32.2","gpos25"],[130100000,132400000,"q32.3","gneg"],[132400000,137300000,"q33","gpos50"],[137300000,142800000,"q34","gneg"],[142800000,147500000,"q35","gpos75"],[147500000,152200000,"q36.1","gneg"],[152200000,154700000,"q36.2","gpos25"],[154700000,158821424,"q36.3","gneg"]],8:[[0,2200000,"p23.3","gneg"],[2200000,6200000,"p23.2","gpos75"],[6200000,12700000,"p23.1","gneg"],[12700000,19100000,"p22","gpos100"],[19100000,23400000,"p21.3","gneg"],[23400000,27400000,"p21.2","gpos50"],[27400000,29700000,"p21.1","gneg"],[29700000,38500000,"p12","gpos75"],[38500000,39500000,"p11.23","gneg"],[39500000,39900000,"p11.22","gpos25"],[39900000,43200000,"p11.21","gneg"],[43200000,45200000,"p11.1","acen"],[45200000,48100000,"q11.1","acen"],[48100000,50400000,"q11.21","gneg"],[50400000,52800000,"q11.22","gpos75"],[52800000,55600000,"q11.23","gneg"],[55600000,61700000,"q12.1","gpos50"],[61700000,62400000,"q12.2","gneg"],[62400000,66100000,"q12.3","gpos50"],[66100000,68100000,"q13.1","gneg"],[68100000,70600000,"q13.2","gpos50"],[70600000,74000000,"q13.3","gneg"],[74000000,78500000,"q21.11","gpos100"],[78500000,80300000,"q21.12","gneg"],[80300000,84900000,"q21.13","gpos75"],[84900000,87200000,"q21.2","gneg"],[87200000,93500000,"q21.3","gpos100"],[93500000,99100000,"q22.1","gneg"],[99100000,101600000,"q22.2","gpos25"],[101600000,106100000,"q22.3","gneg"],[106100000,110600000,"q23.1","gpos75"],[110600000,112200000,"q23.2","gneg"],[112200000,117700000,"q23.3","gpos100"],[117700000,119200000,"q24.11","gneg"],[119200000,122500000,"q24.12","gpos50"],[122500000,127300000,"q24.13","gneg"],[127300000,131500000,"q24.21","gpos50"],[131500000,136500000,"q24.22","gneg"],[136500000,140000000,"q24.23","gpos75"],[140000000,146274826,"q24.3","gneg"]],9:[[0,2200000,"p24.3","gneg"],[2200000,4600000,"p24.2","gpos25"],[4600000,9000000,"p24.1","gneg"],[9000000,14100000,"p23","gpos75"],[14100000,16600000,"p22.3","gneg"],[16600000,18500000,"p22.2","gpos25"],[18500000,19900000,"p22.1","gneg"],[19900000,25500000,"p21.3","gpos100"],[25500000,28100000,"p21.2","gneg"],[28100000,32800000,"p21.1","gpos100"],[32800000,36300000,"p13.3","gneg"],[36300000,38000000,"p13.2","gpos25"],[38000000,40200000,"p13.1","gneg"],[40200000,42400000,"p12","gpos50"],[42400000,46700000,"p11.2","gneg"],[46700000,51800000,"p11.1","acen"],[51800000,60300000,"q11","acen"],[60300000,70000000,"q12","gvar"],[70000000,70500000,"q13","gneg"],[70500000,72700000,"q21.11","gpos25"],[72700000,73100000,"q21.12","gneg"],[73100000,79300000,"q21.13","gpos50"],[79300000,80300000,"q21.2","gneg"],[80300000,83400000,"q21.31","gpos50"],[83400000,86100000,"q21.32","gneg"],[86100000,89600000,"q21.33","gpos50"],[89600000,91000000,"q22.1","gneg"],[91000000,93000000,"q22.2","gpos25"],[93000000,95600000,"q22.31","gneg"],[95600000,98200000,"q22.32","gpos25"],[98200000,101600000,"q22.33","gneg"],[101600000,107200000,"q31.1","gpos100"],[107200000,110300000,"q31.2","gneg"],[110300000,113900000,"q31.3","gpos25"],[113900000,116700000,"q32","gneg"],[116700000,122000000,"q33.1","gpos75"],[122000000,125800000,"q33.2","gneg"],[125800000,129300000,"q33.3","gpos25"],[129300000,132500000,"q34.11","gneg"],[132500000,132800000,"q34.12","gpos25"],[132800000,134900000,"q34.13","gneg"],[134900000,136600000,"q34.2","gpos25"],[136600000,140273252,"q34.3","gneg"]],10:[[0,3000000,"p15.3","gneg"],[3000000,3800000,"p15.2","gpos25"],[3800000,6700000,"p15.1","gneg"],[6700000,12300000,"p14","gpos75"],[12300000,17300000,"p13","gneg"],[17300000,19900000,"p12.33","gpos75"],[19900000,20500000,"p12.32","gneg"],[20500000,22800000,"p12.31","gpos75"],[22800000,24100000,"p12.2","gneg"],[24100000,28300000,"p12.1","gpos50"],[28300000,31400000,"p11.23","gneg"],[31400000,34500000,"p11.22","gpos25"],[34500000,38800000,"p11.21","gneg"],[38800000,40300000,"p11.1","acen"],[40300000,42100000,"q11.1","acen"],[42100000,46100000,"q11.21","gneg"],[46100000,50100000,"q11.22","gpos25"],[50100000,53300000,"q11.23","gneg"],[53300000,61200000,"q21.1","gpos100"],[61200000,64800000,"q21.2","gneg"],[64800000,71300000,"q21.3","gpos100"],[71300000,74600000,"q22.1","gneg"],[74600000,77400000,"q22.2","gpos50"],[77400000,82000000,"q22.3","gneg"],[82000000,87900000,"q23.1","gpos100"],[87900000,89600000,"q23.2","gneg"],[89600000,92900000,"q23.31","gpos75"],[92900000,94200000,"q23.32","gneg"],[94200000,98000000,"q23.33","gpos50"],[98000000,99400000,"q24.1","gneg"],[99400000,102000000,"q24.2","gpos50"],[102000000,103000000,"q24.31","gneg"],[103000000,104900000,"q24.32","gpos25"],[104900000,105700000,"q24.33","gneg"],[105700000,111800000,"q25.1","gpos100"],[111800000,114900000,"q25.2","gneg"],[114900000,119100000,"q25.3","gpos75"],[119100000,121700000,"q26.11","gneg"],[121700000,123100000,"q26.12","gpos50"],[123100000,127400000,"q26.13","gneg"],[127400000,130500000,"q26.2","gpos50"],[130500000,135374737,"q26.3","gneg"]],11:[[0,2800000,"p15.5","gneg"],[2800000,10700000,"p15.4","gpos50"],[10700000,12600000,"p15.3","gneg"],[12600000,16100000,"p15.2","gpos50"],[16100000,21600000,"p15.1","gneg"],[21600000,26000000,"p14.3","gpos100"],[26000000,27200000,"p14.2","gneg"],[27200000,31000000,"p14.1","gpos75"],[31000000,36400000,"p13","gneg"],[36400000,43400000,"p12","gpos100"],[43400000,48800000,"p11.2","gneg"],[48800000,51400000,"p11.12","gpos75"],[51400000,52900000,"p11.11","acen"],[52900000,56400000,"q11","acen"],[56400000,59700000,"q12.1","gpos75"],[59700000,61400000,"q12.2","gneg"],[61400000,63100000,"q12.3","gpos25"],[63100000,67100000,"q13.1","gneg"],[67100000,69200000,"q13.2","gpos25"],[69200000,70700000,"q13.3","gneg"],[70700000,74900000,"q13.4","gpos50"],[74900000,76700000,"q13.5","gneg"],[76700000,85300000,"q14.1","gpos100"],[85300000,87900000,"q14.2","gneg"],[87900000,92300000,"q14.3","gpos100"],[92300000,96700000,"q21","gneg"],[96700000,101600000,"q22.1","gpos100"],[101600000,102400000,"q22.2","gneg"],[102400000,110000000,"q22.3","gpos100"],[110000000,112800000,"q23.1","gneg"],[112800000,115400000,"q23.2","gpos50"],[115400000,120700000,"q23.3","gneg"],[120700000,123500000,"q24.1","gpos50"],[123500000,127400000,"q24.2","gneg"],[127400000,130300000,"q24.3","gpos50"],[130300000,134452384,"q25","gneg"]],12:[[0,3100000,"p13.33","gneg"],[3100000,5300000,"p13.32","gpos25"],[5300000,10000000,"p13.31","gneg"],[10000000,12600000,"p13.2","gpos75"],[12600000,14800000,"p13.1","gneg"],[14800000,19900000,"p12.3","gpos100"],[19900000,21200000,"p12.2","gneg"],[21200000,26300000,"p12.1","gpos100"],[26300000,27700000,"p11.23","gneg"],[27700000,30600000,"p11.22","gpos50"],[30600000,33200000,"p11.21","gneg"],[33200000,35400000,"p11.1","acen"],[35400000,36500000,"q11","acen"],[36500000,44600000,"q12","gpos100"],[44600000,47400000,"q13.11","gneg"],[47400000,48400000,"q13.12","gpos25"],[48400000,53100000,"q13.13","gneg"],[53100000,55200000,"q13.2","gpos25"],[55200000,56300000,"q13.3","gneg"],[56300000,61400000,"q14.1","gpos75"],[61400000,63400000,"q14.2","gneg"],[63400000,66000000,"q14.3","gpos50"],[66000000,69800000,"q15","gneg"],[69800000,74100000,"q21.1","gpos75"],[74100000,78700000,"q21.2","gneg"],[78700000,85100000,"q21.31","gpos100"],[85100000,87500000,"q21.32","gneg"],[87500000,91200000,"q21.33","gpos100"],[91200000,94800000,"q22","gneg"],[94800000,100000000,"q23.1","gpos75"],[100000000,102400000,"q23.2","gneg"],[102400000,107500000,"q23.3","gpos50"],[107500000,110200000,"q24.11","gneg"],[110200000,110800000,"q24.12","gpos25"],[110800000,112800000,"q24.13","gneg"],[112800000,115300000,"q24.21","gpos50"],[115300000,116700000,"q24.22","gneg"],[116700000,119100000,"q24.23","gpos50"],[119100000,124500000,"q24.31","gneg"],[124500000,128700000,"q24.32","gpos50"],[128700000,132349534,"q24.33","gneg"]],13:[[0,3800000,"p13","gvar"],[3800000,8300000,"p12","stalk"],[8300000,13500000,"p11.2","gvar"],[13500000,16000000,"p11.1","acen"],[16000000,18400000,"q11","acen"],[18400000,22200000,"q12.11","gneg"],[22200000,24400000,"q12.12","gpos25"],[24400000,26700000,"q12.13","gneg"],[26700000,27800000,"q12.2","gpos25"],[27800000,31100000,"q12.3","gneg"],[31100000,32900000,"q13.1","gpos50"],[32900000,34700000,"q13.2","gneg"],[34700000,39500000,"q13.3","gpos75"],[39500000,44300000,"q14.11","gneg"],[44300000,45900000,"q14.12","gpos25"],[45900000,46200000,"q14.13","gneg"],[46200000,48900000,"q14.2","gpos50"],[48900000,52200000,"q14.3","gneg"],[52200000,57600000,"q21.1","gpos100"],[57600000,60500000,"q21.2","gneg"],[60500000,64100000,"q21.31","gpos75"],[64100000,67200000,"q21.32","gneg"],[67200000,72100000,"q21.33","gpos100"],[72100000,74200000,"q22.1","gneg"],[74200000,76000000,"q22.2","gpos50"],[76000000,77800000,"q22.3","gneg"],[77800000,86500000,"q31.1","gpos100"],[86500000,88800000,"q31.2","gneg"],[88800000,93800000,"q31.3","gpos100"],[93800000,97000000,"q32.1","gneg"],[97000000,98100000,"q32.2","gpos25"],[98100000,100500000,"q32.3","gneg"],[100500000,103700000,"q33.1","gpos100"],[103700000,105800000,"q33.2","gneg"],[105800000,109100000,"q33.3","gpos100"],[109100000,114142980,"q34","gneg"]],14:[[0,3100000,"p13","gvar"],[3100000,6700000,"p12","stalk"],[6700000,13600000,"p11.2","gvar"],[13600000,15600000,"p11.1","acen"],[15600000,19100000,"q11.1","acen"],[19100000,23600000,"q11.2","gneg"],[23600000,31800000,"q12","gpos100"],[31800000,34100000,"q13.1","gneg"],[34100000,35600000,"q13.2","gpos50"],[35600000,36900000,"q13.3","gneg"],[36900000,41000000,"q21.1","gpos100"],[41000000,43200000,"q21.2","gneg"],[43200000,48300000,"q21.3","gpos100"],[48300000,52300000,"q22.1","gneg"],[52300000,54400000,"q22.2","gpos25"],[54400000,55800000,"q22.3","gneg"],[55800000,61200000,"q23.1","gpos75"],[61200000,64000000,"q23.2","gneg"],[64000000,67000000,"q23.3","gpos50"],[67000000,69300000,"q24.1","gneg"],[69300000,72900000,"q24.2","gpos50"],[72900000,78400000,"q24.3","gneg"],[78400000,82600000,"q31.1","gpos100"],[82600000,84000000,"q31.2","gneg"],[84000000,88900000,"q31.3","gpos100"],[88900000,90500000,"q32.11","gneg"],[90500000,92800000,"q32.12","gpos25"],[92800000,95400000,"q32.13","gneg"],[95400000,100400000,"q32.2","gpos50"],[100400000,102200000,"q32.31","gneg"],[102200000,103000000,"q32.32","gpos50"],[103000000,106368585,"q32.33","gneg"]],15:[[0,3500000,"p13","gvar"],[3500000,7900000,"p12","stalk"],[7900000,14100000,"p11.2","gvar"],[14100000,17000000,"p11.1","acen"],[17000000,18400000,"q11.1","acen"],[18400000,23300000,"q11.2","gneg"],[23300000,25700000,"q12","gpos50"],[25700000,28000000,"q13.1","gneg"],[28000000,29000000,"q13.2","gpos50"],[29000000,31400000,"q13.3","gneg"],[31400000,37900000,"q14","gpos75"],[37900000,40700000,"q15.1","gneg"],[40700000,41400000,"q15.2","gpos25"],[41400000,42700000,"q15.3","gneg"],[42700000,47600000,"q21.1","gpos75"],[47600000,51100000,"q21.2","gneg"],[51100000,55800000,"q21.3","gpos75"],[55800000,57100000,"q22.1","gneg"],[57100000,61500000,"q22.2","gpos25"],[61500000,64900000,"q22.31","gneg"],[64900000,65000000,"q22.32","gpos25"],[65000000,65300000,"q22.33","gneg"],[65300000,70400000,"q23","gpos25"],[70400000,73100000,"q24.1","gneg"],[73100000,74400000,"q24.2","gpos25"],[74400000,76100000,"q24.3","gneg"],[76100000,79500000,"q25.1","gpos50"],[79500000,83000000,"q25.2","gneg"],[83000000,86900000,"q25.3","gpos50"],[86900000,92100000,"q26.1","gneg"],[92100000,96300000,"q26.2","gpos50"],[96300000,100338915,"q26.3","gneg"]],16:[[0,6300000,"p13.3","gneg"],[6300000,10300000,"p13.2","gpos50"],[10300000,12500000,"p13.13","gneg"],[12500000,14700000,"p13.12","gpos50"],[14700000,16700000,"p13.11","gneg"],[16700000,20500000,"p12.3","gpos50"],[20500000,21700000,"p12.2","gneg"],[21700000,27600000,"p12.1","gpos50"],[27600000,34400000,"p11.2","gneg"],[34400000,38200000,"p11.1","acen"],[38200000,40700000,"q11.1","acen"],[40700000,45500000,"q11.2","gvar"],[45500000,51200000,"q12.1","gneg"],[51200000,54500000,"q12.2","gpos50"],[54500000,56700000,"q13","gneg"],[56700000,65200000,"q21","gpos100"],[65200000,69400000,"q22.1","gneg"],[69400000,69800000,"q22.2","gpos50"],[69800000,73300000,"q22.3","gneg"],[73300000,78200000,"q23.1","gpos75"],[78200000,80500000,"q23.2","gneg"],[80500000,82700000,"q23.3","gpos50"],[82700000,85600000,"q24.1","gneg"],[85600000,87200000,"q24.2","gpos25"],[87200000,88827254,"q24.3","gneg"]],17:[[0,3600000,"p13.3","gneg"],[3600000,6800000,"p13.2","gpos50"],[6800000,11200000,"p13.1","gneg"],[11200000,15900000,"p12","gpos75"],[15900000,22100000,"p11.2","gneg"],[22100000,22200000,"p11.1","acen"],[22200000,23200000,"q11.1","acen"],[23200000,28800000,"q11.2","gneg"],[28800000,35400000,"q12","gpos50"],[35400000,35600000,"q21.1","gneg"],[35600000,37800000,"q21.2","gpos25"],[37800000,41900000,"q21.31","gneg"],[41900000,44800000,"q21.32","gpos25"],[44800000,47600000,"q21.33","gneg"],[47600000,54900000,"q22","gpos75"],[54900000,55600000,"q23.1","gneg"],[55600000,58400000,"q23.2","gpos75"],[58400000,59900000,"q23.3","gneg"],[59900000,61600000,"q24.1","gpos50"],[61600000,64600000,"q24.2","gneg"],[64600000,68400000,"q24.3","gpos75"],[68400000,72200000,"q25.1","gneg"],[72200000,72900000,"q25.2","gpos25"],[72900000,78774742,"q25.3","gneg"]],18:[[0,2900000,"p11.32","gneg"],[2900000,7200000,"p11.31","gpos50"],[7200000,8500000,"p11.23","gneg"],[8500000,10900000,"p11.22","gpos25"],[10900000,15400000,"p11.21","gneg"],[15400000,16100000,"p11.1","acen"],[16100000,17300000,"q11.1","acen"],[17300000,23300000,"q11.2","gneg"],[23300000,31000000,"q12.1","gpos100"],[31000000,35500000,"q12.2","gneg"],[35500000,41800000,"q12.3","gpos75"],[41800000,46400000,"q21.1","gneg"],[46400000,52000000,"q21.2","gpos75"],[52000000,54400000,"q21.31","gneg"],[54400000,57100000,"q21.32","gpos50"],[57100000,59800000,"q21.33","gneg"],[59800000,64900000,"q22.1","gpos100"],[64900000,66900000,"q22.2","gneg"],[66900000,71300000,"q22.3","gpos25"],[71300000,76117153,"q23","gneg"]],19:[[0,6900000,"p13.3","gneg"],[6900000,12600000,"p13.2","gpos25"],[12600000,13800000,"p13.13","gneg"],[13800000,16100000,"p13.12","gpos25"],[16100000,19800000,"p13.11","gneg"],[19800000,26700000,"p12","gvar"],[26700000,28500000,"p11","acen"],[28500000,30200000,"q11","acen"],[30200000,37100000,"q12","gvar"],[37100000,40300000,"q13.11","gneg"],[40300000,43000000,"q13.12","gpos25"],[43000000,43400000,"q13.13","gneg"],[43400000,47800000,"q13.2","gpos25"],[47800000,50000000,"q13.31","gneg"],[50000000,53800000,"q13.32","gpos25"],[53800000,57600000,"q13.33","gneg"],[57600000,59100000,"q13.41","gpos25"],[59100000,61400000,"q13.42","gneg"],[61400000,63811651,"q13.43","gpos25"]],20:[[0,5000000,"p13","gneg"],[5000000,9000000,"p12.3","gpos75"],[9000000,11900000,"p12.2","gneg"],[11900000,17800000,"p12.1","gpos75"],[17800000,21200000,"p11.23","gneg"],[21200000,22300000,"p11.22","gpos25"],[22300000,25700000,"p11.21","gneg"],[25700000,27100000,"p11.1","acen"],[27100000,28400000,"q11.1","acen"],[28400000,31500000,"q11.21","gneg"],[31500000,33900000,"q11.22","gpos25"],[33900000,37100000,"q11.23","gneg"],[37100000,41100000,"q12","gpos75"],[41100000,41600000,"q13.11","gneg"],[41600000,45800000,"q13.12","gpos25"],[45800000,49200000,"q13.13","gneg"],[49200000,54400000,"q13.2","gpos75"],[54400000,55900000,"q13.31","gneg"],[55900000,57900000,"q13.32","gpos50"],[57900000,62435964,"q13.33","gneg"]],21:[[0,2900000,"p13","gvar"],[2900000,6300000,"p12","stalk"],[6300000,10000000,"p11.2","gvar"],[10000000,12300000,"p11.1","acen"],[12300000,13200000,"q11.1","acen"],[13200000,15300000,"q11.2","gneg"],[15300000,22900000,"q21.1","gpos100"],[22900000,25800000,"q21.2","gneg"],[25800000,30500000,"q21.3","gpos75"],[30500000,34700000,"q22.11","gneg"],[34700000,36700000,"q22.12","gpos50"],[36700000,38600000,"q22.13","gneg"],[38600000,41400000,"q22.2","gpos50"],[41400000,46944323,"q22.3","gneg"]],22:[[0,3000000,"p13","gvar"],[3000000,6600000,"p12","stalk"],[6600000,9600000,"p11.2","gvar"],[9600000,11800000,"p11.1","acen"],[11800000,16300000,"q11.1","acen"],[16300000,20500000,"q11.21","gneg"],[20500000,21800000,"q11.22","gpos25"],[21800000,24300000,"q11.23","gneg"],[24300000,27900000,"q12.1","gpos50"],[27900000,30500000,"q12.2","gneg"],[30500000,35900000,"q12.3","gpos50"],[35900000,39300000,"q13.1","gneg"],[39300000,42600000,"q13.2","gpos50"],[42600000,47000000,"q13.31","gneg"],[47000000,48200000,"q13.32","gpos50"],[48200000,49691432,"q13.33","gneg"]],X:[[0,4300000,"p22.33","gneg"],[4300000,6000000,"p22.32","gpos50"],[6000000,9500000,"p22.31","gneg"],[9500000,17100000,"p22.2","gpos50"],[17100000,19200000,"p22.13","gneg"],[19200000,21800000,"p22.12","gpos50"],[21800000,24900000,"p22.11","gneg"],[24900000,29400000,"p21.3","gpos100"],[29400000,31500000,"p21.2","gneg"],[31500000,37500000,"p21.1","gpos100"],[37500000,42300000,"p11.4","gneg"],[42300000,47300000,"p11.3","gpos75"],[47300000,49700000,"p11.23","gneg"],[49700000,54700000,"p11.22","gpos25"],[54700000,56600000,"p11.21","gneg"],[56600000,59500000,"p11.1","acen"],[59500000,65000000,"q11.1","acen"],[65000000,65100000,"q11.2","gneg"],[65100000,67700000,"q12","gpos50"],[67700000,72200000,"q13.1","gneg"],[72200000,73800000,"q13.2","gpos50"],[73800000,76000000,"q13.3","gneg"],[76000000,84500000,"q21.1","gpos100"],[84500000,86200000,"q21.2","gneg"],[86200000,91900000,"q21.31","gpos100"],[91900000,93500000,"q21.32","gneg"],[93500000,98200000,"q21.33","gpos75"],[98200000,102500000,"q22.1","gneg"],[102500000,103600000,"q22.2","gpos50"],[103600000,110500000,"q22.3","gneg"],[110500000,116800000,"q23","gpos75"],[116800000,120700000,"q24","gneg"],[120700000,129800000,"q25","gpos100"],[129800000,130300000,"q26.1","gneg"],[130300000,133500000,"q26.2","gpos25"],[133500000,137800000,"q26.3","gneg"],[137800000,140100000,"q27.1","gpos75"],[140100000,141900000,"q27.2","gneg"],[141900000,146900000,"q27.3","gpos100"],[146900000,154913754,"q28","gneg"]],Y:[[0,1700000,"p11.32","gneg"],[1700000,3300000,"p11.31","gpos50"],[3300000,11200000,"p11.2","gneg"],[11200000,11300000,"p11.1","acen"],[11300000,12500000,"q11.1","acen"],[12500000,14300000,"q11.21","gneg"],[14300000,19000000,"q11.221","gpos50"],[19000000,21300000,"q11.222","gneg"],[21300000,25400000,"q11.223","gpos50"],[25400000,27200000,"q11.23","gneg"],[27200000,57772954,"q12","gvar"]]}}};CanvasXpress.graphTypes={Area:["Area"],AreaLine:["AreaLine"],Bar:["Bar"],BarLine:["BarLine"],Boxplot:["Boxplot"],Candlestick:["Candlestick"],Circular:["Circular"],Correlation:["Correlation"],DotLine:["DotLine"],Dotplot:["Dotplot"],Genome:["Genome"],Heatmap:["Heatmap"],Line:["Line"],Map:["Map"],Network:["Network"],ParallelCoordinates:["ParallelCoordinates"],Pie:["Pie"],Sankey:["Sankey"],Scatter2D:["Scatter2D"],ScatterBubble2D:["ScatterBubble2D"],Scatter3D:["Scatter3D"],Stacked:["Stacked"],StackedLine:["StackedLine"],StackedPercent:["StackedPercent"],StackedPercentLine:["StackedPercentLine"],TagCloud:["TagCloud"],Tree:["Tree"],Treemap:["Treemap"],Venn:["Venn"],Video:["Video"],DotGraphs:["Boxplot","DotLine","Dotplot"],LineGraphs:["AreaLine","BarLine","DotLine","Line","ParallelCoordinates","StackedLine","StackedPercentLine"],ScatterGraphs:["Scatter2D","ScatterBubble2D","Scatter3D"],StackedGraphs:["Stacked","StackedLine","StackedPercent","StackedPercentLine"],OneDPlots:["Area","AreaLine","Bar","BarLine","Boxplot","Candlestick","DotLine","Dotplot","Heatmap","Line","ParallelCoordinates","Sankey","Stacked","StackedLine","StackedPercent","StackedPercentLine","TagCloud","Tree","Treemap"],OneDGraphs:["Area","AreaLine","Bar","BarLine","Boxplot","Candlestick","DotLine","Dotplot","Heatmap","Line","ParallelCoordinates","Stacked","StackedLine","StackedPercent","StackedPercentLine"],OneTwoThreeeDGraphs:["Area","AreaLine","Bar","BarLine","Boxplot","Candlestick","Circular","DotLine","Dotplot","Heatmap","Line","ParallelCoordinates","Pie","Scatter2D","ScatterBubble2D","Scatter3D","Stacked","StackedLine","StackedPercent","StackedPercentLine"],AllGraphs:["Area","AreaLine","Bar","BarLine","Boxplot","Candlestick","Circular","Correlation","DotLine","Dotplot","Genome","Heatmap","Line","Map","Network","ParallelCoordinates","Pie","Sankey","Scatter2D","ScatterBubble2D","Scatter3D","Stacked","StackedLine","StackedPercent","StackedPercentLine","TagCloud","Tree","Treemap","Venn","Video"],AGraphs:["Area","AreaLine","Bar","BarLine","Boxplot","Candlestick","Circular","Correlation","DotLine","Dotplot","Heatmap","Line","Map","ParallelCoordinates","Sankey","Scatter2D","ScatterBubble2D","Scatter3D","Stacked","StackedLine","StackedPercent","StackedPercentLine","TagCloud","Tree","Treemap"],NoneDGraphs:["Genome","Map","Network","Sankey","TagCloud","Tree","Treemap","Venn","Video"]};CanvasXpress.colorNames={aliceblue:"F0F8FF",antiquewhite1:"FFEFDB",antiquewhite2:"EEDFCC",antiquewhite3:"CDC0B0",antiquewhite4:"8B8378",antiquewhite:"FAEBD7",aqua:"00FFFF",aquamarine1:"7FFFD4",aquamarine2:"76EEC6",aquamarine4:"458B74",aquamarine:"7FFFD4",azure1:"F0FFFF",azure2:"E0EEEE",azure3:"C1CDCD",azure4:"838B8B",azure:"F0FFFF",beige:"F5F5DC",bisque1:"FFE4C4",bisque2:"EED5B7",bisque3:"CDB79E",bisque4:"8B7D6B",bisque:"FFE4C4",black:"000000",blanchedalmond:"FFEBCD",blue:"0000FF",blue1:"0000FF",blue2:"0000EE",blue3:"1874CD",blue4:"00008B",blueviolet:"8A2BE2",brown1:"FF4040",brown2:"EE3B3B",brown3:"CD3333",brown4:"8B2323",brown:"A52A2A",burlywood1:"FFD39B",burlywood2:"EEC591",burlywood3:"CDAA7D",burlywood4:"8B7355",burlywood:"DEB887",cadetblue1:"98F5FF",cadetblue2:"8EE5EE",cadetblue3:"7AC5CD",cadetblue4:"53868B",cadetblue:"5F9EA0",chartreuse1:"7FFF00",chartreuse2:"76EE00",chartreuse3:"66CD00",chartreuse4:"458B00",chartreuse:"7FFF00",chocolate1:"FF7F24",chocolate2:"EE7621",chocolate3:"CD661D",chocolate:"D2691E",coral1:"FF7256",coral2:"EE6A50",coral3:"CD5B45",coral4:"8B3E2F",coral:"FF7F50",cornflowerblue:"6495ED",cornsilk1:"FFF8DC",cornsilk2:"EEE8CD",cornsilk3:"CDC8B1",cornsilk4:"8B8878",cornsilk:"FFF8DC",crimson:"DC143C",cyan:"00FFFF",cyan1:"00FFFF",cyan2:"00EEEE",cyan3:"00CDCD",cyan4:"008B8B",darkblue:"00008B",darkcyan:"008B8B",darkgoldenrod1:"FFB90F",darkgoldenrod2:"EEAD0E",darkgoldenrod3:"CD950C",darkgoldenrod4:"8B6508",darkgoldenrod4:"8B6508",darkgoldenrod:"B8860B",darkgray:"A9A9A9",darkgreen:"006400",darkgrey:"A9A9A9",darkkhaki:"BDB76B",darkmagenta:"8B008B",darkolivegreen1:"CAFF70",darkolivegreen2:"BCEE68",darkolivegreen3:"A2CD5A",darkolivegreen4:"6E8B3D",darkolivegreen:"556B2F",darkorange1:"FF7F00",darkorange2:"EE7600",darkorange3:"CD6600",darkorange4:"8B4500",darkorange:"FF8C00",darkorchid1:"BF3EFF",darkorchid2:"B23AEE",darkorchid3:"9A32CD",darkorchid4:"68228B",darkorchid:"9932CC",darkred:"8B0000",darksalmon:"E9967A",darkseagreen1:"C1FFC1",darkseagreen2:"B4EEB4",darkseagreen3:"9BCD9B",darkseagreen4:"698B69",darkseagreen:"8FBC8F",darkslateblue:"483D8B",darkslategray1:"97FFFF",darkslategray2:"8DEEEE",darkslategray:"2F4F4F",darkslategray3:"79CDCD",darkslategray4:"528B8B",darkslategrey:"2F4F4F",darkturquoise:"00CED1",darkviolet:"9400D3",deeppink1:"FF1493",deeppink2:"EE1289",deeppink3:"CD1076",deeppink4:"8B0A50",deeppink:"FF1493",deepskyblue:"00BFFF",deepskyblue1:"00BFFF",deepskyblue2:"00B2EE",deepskyblue3:"009ACD",deepskyblue4:"00688B",dimgray:"696969",dimgrey:"696969",dodgerblue1:"1E90FF",dodgerblue:"1E90FF",dodgerblue2:"1C86EE",dodgerblue3:"1874CD",dodgerblue4:"104E8B",firebrick1:"FF3030",firebrick2:"EE2C2C",firebrick3:"CD2626",firebrick4:"8B1A1A",firebrick:"B22222",floralwhite:"FFFAF0",forestgreen:"228B22",fuchsia:"FF00FF",gainsboro:"DCDCDC",ghostwhite:"F8F8FF",gold1:"FFD700",gold2:"EEC900",gold3:"CDAD00",gold4:"8B7500",goldenrod1:"FFC125",goldenrod2:"EEB422",goldenrod3:"CD9B1D",goldenrod4:"8B6914",goldenrod:"DAA520",goldenrod:"DAA520",gold:"FFD700",gray10:"1A1A1A",gray1:"030303",gray11:"1C1C1C",gray12:"1F1F1F",gray13:"212121",gray14:"242424",gray15:"262626",gray16:"292929",gray17:"2B2B2B",gray18:"2E2E2E",gray19:"303030",gray20:"333333",gray2:"050505",gray21:"363636",gray22:"383838",gray23:"3B3B3B",gray24:"3D3D3D",gray25:"404040",gray26:"424242",gray27:"454545",gray28:"474747",gray29:"4A4A4A",gray30:"4D4D4D",gray3:"080808",gray31:"4F4F4F",gray32:"525252",gray33:"545454",gray34:"575757",gray35:"595959",gray36:"5C5C5C",gray37:"5E5E5E",gray38:"616161",gray39:"636363",gray40:"666666",gray4:"0A0A0A",gray41:"696969",gray42:"6B6B6B",gray43:"6E6E6E",gray44:"707070",gray45:"737373",gray46:"757575",gray47:"787878",gray48:"7A7A7A",gray49:"7D7D7D",gray50:"7F7F7F",gray5:"0D0D0D",gray51:"828282",gray52:"858585",gray53:"878787",gray54:"8A8A8A",gray55:"8C8C8C",gray56:"8F8F8F",gray57:"919191",gray58:"949494",gray59:"969696",gray60:"999999",gray6:"0F0F0F",gray61:"9C9C9C",gray62:"9E9E9E",gray63:"A1A1A1",gray64:"A3A3A3",gray65:"A6A6A6",gray66:"A8A8A8",gray67:"ABABAB",gray68:"ADADAD",gray69:"B0B0B0",gray70:"B3B3B3",gray7:"121212",gray71:"B5B5B5",gray72:"B8B8B8",gray73:"BABABA",gray74:"BDBDBD",gray75:"BFBFBF",gray76:"C2C2C2",gray77:"C4C4C4",gray78:"C7C7C7",gray79:"C9C9C9",gray:"808080",gray80:"CCCCCC",gray8:"141414",gray81:"CFCFCF",gray82:"D1D1D1",gray83:"D4D4D4",gray84:"D6D6D6",gray85:"D9D9D9",gray86:"DBDBDB",gray87:"DEDEDE",gray88:"E0E0E0",gray89:"E3E3E3",gray90:"E5E5E5",gray9:"171717",gray91:"E8E8E8",gray92:"EBEBEB",gray93:"EDEDED",gray94:"F0F0F0",gray95:"F2F2F2",gray97:"F7F7F7",gray98:"FAFAFA",gray99:"FCFCFC",gray:"BEBEBE",green:"008000",green1:"00FF00",green2:"00EE00",green3:"00CD00",green4:"008B00",greenyellow:"ADFF2F",grey:"808080",honeydew1:"F0FFF0",honeydew2:"E0EEE0",honeydew3:"C1CDC1",honeydew4:"838B83",honeydew:"F0FFF0",hotpink1:"FF6EB4",hotpink2:"EE6AA7",hotpink3:"CD6090",hotpink4:"8B3A62",hotpink:"FF69B4",indianred1:"FF6A6A",indianred2:"EE6363",indianred3:"CD5555",indianred4:"8B3A3A",indianred:"CD5C5C",indigo:"4B0082",ivory1:"FFFFF0",ivory2:"EEEEE0",ivory3:"CDCDC1",ivory4:"8B8B83",ivory:"FFFFF0",khaki1:"FFF68F",khaki2:"EEE685",khaki3:"CDC673",khaki4:"8B864E",khaki:"F0E68C",lavenderblush1:"FFF0F5",lavenderblush2:"EEE0E5",lavenderblush3:"CDC1C5",lavenderblush4:"8B8386",lavenderblush:"FFF0F5",lavender:"E6E6FA",lawngreen:"7CFC00",lemonchiffon1:"FFFACD",lemonchiffon2:"EEE9BF",lemonchiffon3:"CDC9A5",lemonchiffon4:"8B8970",lemonchiffon:"FFFACD",lightblue1:"BFEFFF",lightblue2:"B2DFEE",lightblue3:"9AC0CD",lightblue4:"68838B",lightblue:"ADD8E6",lightcoral:"F08080",lightcyan1:"E0FFFF",lightcyan2:"D1EEEE",lightcyan3:"B4CDCD",lightcyan4:"7A8B8B",lightcyan:"E0FFFF",light:"EEDD82",lightgoldenrod1:"FFEC8B",lightgoldenrod2:"EEDC82",lightgoldenrod3:"CDBE70",lightgoldenrod4:"8B814C",lightgoldenrodyellow:"FAFAD2",lightgray:"D3D3D3",lightgreen:"90EE90",lightgrey:"D3D3D3",lightpink1:"FFAEB9",lightpink2:"EEA2AD",lightpink3:"CD8C95",lightpink4:"8B5F65",lightpink:"FFB6C1",lightsalmon1:"FFA07A",lightsalmon2:"EE9572",lightsalmon3:"CD8162",lightsalmon4:"8B5742",lightsalmon:"FFA07A",lightseagreen:"20B2AA",lightskyblue1:"B0E2FF",lightskyblue2:"A4D3EE",lightskyblue3:"8DB6CD",lightskyblue4:"607B8B",lightskyblue:"87CEFA",lightslateblue:"8470FF",lightslategray:"778899",lightslategrey:"778899",lightsteelblue1:"CAE1FF",lightsteelblue2:"BCD2EE",lightsteelblue3:"A2B5CD",lightsteelblue4:"6E7B8B",lightsteelblue:"B0C4DE",lightyellow1:"FFFFE0",lightyellow2:"EEEED1",lightyellow3:"CDCDB4",lightyellow4:"8B8B7A",lightyellow:"FFFFE0",lime:"00FF00",limegreen:"32CD32",linen:"FAF0E6",magenta2:"EE00EE",magenta3:"CD00CD",magenta4:"8B008B",magenta:"FF00FF",maroon1:"FF34B3",maroon2:"EE30A7",maroon3:"CD2990",maroon4:"8B1C62",maroon:"800000",maroon:"B03060",medium:"66CDAA",mediumaquamarine:"66CDAA",mediumblue:"0000CD",mediumorchid1:"E066FF",mediumorchid2:"D15FEE",mediumorchid3:"B452CD",mediumorchid4:"7A378B",mediumorchid:"BA55D3",mediumpurple1:"AB82FF",mediumpurple2:"9F79EE",mediumpurple3:"8968CD",mediumpurple4:"5D478B",mediumpurple:"9370DB",mediumseagreen:"3CB371",mediumslateblue:"7B68EE",mediumspringgreen:"00FA9A",mediumturquoise:"48D1CC",mediumvioletred:"C71585",midnightblue:"191970",mintcream:"F5FFFA",mistyrose1:"FFE4E1",mistyrose2:"EED5D2",mistyrose3:"CDB7B5",mistyrose4:"8B7D7B",mistyrose:"FFE4E1",moccasin:"FFE4B5",navajowhite1:"FFDEAD",navajowhite2:"EECFA1",navajowhite3:"CDB38B",navajowhite4:"8B795E",navajowhite:"FFDEAD",navy:"000080",navyblue:"000080",oldlace:"FDF5E6",olive:"808000",olivedrab1:"C0FF3E",olivedrab2:"B3EE3A",olivedrab4:"698B22",olivedrab:"6B8E23",orange1:"FFA500",orange2:"EE9A00",orange3:"CD8500",orange4:"8B5A00",orange:"FFA500",orangered1:"FF4500",orangered2:"EE4000",orangered3:"CD3700",orangered4:"8B2500",orangered:"FF4500",orchid1:"FF83FA",orchid2:"EE7AE9",orchid3:"CD69C9",orchid4:"8B4789",orchid:"DA70D6",pale:"DB7093",palegoldenrod:"EEE8AA",palegreen1:"9AFF9A",palegreen2:"90EE90",palegreen3:"7CCD7C",palegreen4:"548B54",palegreen:"98FB98",paleturquoise1:"BBFFFF",paleturquoise2:"AEEEEE",paleturquoise3:"96CDCD",paleturquoise4:"668B8B",paleturquoise:"AFEEEE",palevioletred1:"FF82AB",palevioletred2:"EE799F",palevioletred3:"CD6889",palevioletred4:"8B475D",palevioletred:"DB7093",papayawhip:"FFEFD5",peachpuff1:"FFDAB9",peachpuff2:"EECBAD",peachpuff3:"CDAF95",peachpuff4:"8B7765",peachpuff:"FFDAB9",peru:"CD853F",pink1:"FFB5C5",pink2:"EEA9B8",pink3:"CD919E",pink4:"8B636C",pink:"FFC0CB",plum1:"FFBBFF",plum2:"EEAEEE",plum3:"CD96CD",plum4:"8B668B",plum:"DDA0DD",powderblue:"B0E0E6",purple1:"9B30FF",purple2:"912CEE",purple3:"7D26CD",purple4:"551A8B",purple:"800080",purple:"A020F0",rebeccapurple:"663399",red1:"FF0000",red2:"EE0000",red3:"CD0000",red4:"8B0000",red:"FF0000",rosybrown1:"FFC1C1",rosybrown2:"EEB4B4",rosybrown3:"CD9B9B",rosybrown4:"8B6969",rosybrown:"BC8F8F",royalblue1:"4876FF",royalblue2:"436EEE",royalblue3:"3A5FCD",royalblue:"4169E1",royalblue4:"27408B",saddlebrown:"8B4513",salmon1:"FF8C69",salmon2:"EE8262",salmon3:"CD7054",salmon4:"8B4C39",salmon:"FA8072",sandybrown:"F4A460",seagreen1:"54FF9F",seagreen2:"4EEE94",seagreen:"2E8B57",seagreen3:"43CD80",seagreen4:"2E8B57",seashell1:"FFF5EE",seashell2:"EEE5DE",seashell3:"CDC5BF",seashell4:"8B8682",seashell:"FFF5EE",sienna1:"FF8247",sienna2:"EE7942",sienna3:"CD6839",sienna4:"8B4726",sienna:"A0522D",silver:"C0C0C0",skyblue1:"87CEFF",skyblue2:"7EC0EE",skyblue3:"6CA6CD",skyblue4:"4A708B",skyblue:"87CEEB",slateblue1:"836FFF",slateblue2:"7A67EE",slateblue3:"6959CD",slateblue4:"473C8B",slateblue:"6A5ACD",slategray1:"C6E2FF",slategray2:"B9D3EE",slategray3:"9FB6CD",slategray4:"6C7B8B",slategray:"708090",slategrey:"708090",snow1:"FFFAFA",snow2:"EEE9E9",snow3:"CDC9C9",snow4:"8B8989",snow:"FFFAFA",springgreen:"00FF7F",springgreen1:"00FF7F",springgreen2:"00EE76",springgreen3:"00CD66",springgreen4:"008B45",steelblue1:"63B8FF",steelblue2:"5CACEE",steelblue3:"4F94CD",steelblue4:"36648B",steelblue:"4682B4",tan1:"FFA54F",tan2:"EE9A49",tan3:"CD853F",tan4:"8B5A2B",tan:"D2B48C",teal:"008080",thistle1:"FFE1FF",thistle2:"EED2EE",thistle3:"CDB5CD",thistle4:"8B7B8B",thistle:"D8BFD8",tomato1:"FF6347",tomato2:"EE5C42",tomato3:"CD4F39",tomato4:"8B3626",tomato:"FF6347",turquoise1:"00F5FF",turquoise2:"00E5EE",turquoise3:"00C5CD",turquoise4:"00868B",turquoise:"40E0D0",violet:"EE82EE",violetred1:"FF3E96",violetred2:"EE3A8C",violetred3:"CD3278",violetred4:"8B2252",violetred:"D02090",wheat1:"FFE7BA",wheat2:"EED8AE",wheat3:"CDBA96",wheat4:"8B7E66",wheat:"F5DEB3",white:"FFFFFF",whitesmoke:"F5F5F5",yellow1:"FFFF00",yellow2:"EEEE00",yellow3:"CDCD00",yellow4:"8B8B00",yellow:"FFFF00",yellowgreen:"9ACD32"};CanvasXpress.colorSchemes={YlGn:{3:["#f7fcb9","#addd8e","#31a354"],4:["#ffffcc","#c2e699","#78c679","#238443"],5:["#ffffcc","#c2e699","#78c679","#31a354","#006837"],6:["#ffffcc","#d9f0a3","#addd8e","#78c679","#31a354","#006837"],7:["#ffffcc","#d9f0a3","#addd8e","#78c679","#41ab5d","#238443","#005a32"],8:["#ffffe5","#f7fcb9","#d9f0a3","#addd8e","#78c679","#41ab5d","#238443","#005a32"],9:["#ffffe5","#f7fcb9","#d9f0a3","#addd8e","#78c679","#41ab5d","#238443","#006837","#004529"]},YlGnBu:{3:["#edf8b1","#7fcdbb","#2c7fb8"],4:["#ffffcc","#a1dab4","#41b6c4","#225ea8"],5:["#ffffcc","#a1dab4","#41b6c4","#2c7fb8","#253494"],6:["#ffffcc","#c7e9b4","#7fcdbb","#41b6c4","#2c7fb8","#253494"],7:["#ffffcc","#c7e9b4","#7fcdbb","#41b6c4","#1d91c0","#225ea8","#0c2c84"],8:["#ffffd9","#edf8b1","#c7e9b4","#7fcdbb","#41b6c4","#1d91c0","#225ea8","#0c2c84"],9:["#ffffd9","#edf8b1","#c7e9b4","#7fcdbb","#41b6c4","#1d91c0","#225ea8","#253494","#081d58"]},GnBu:{3:["#e0f3db","#a8ddb5","#43a2ca"],4:["#f0f9e8","#bae4bc","#7bccc4","#2b8cbe"],5:["#f0f9e8","#bae4bc","#7bccc4","#43a2ca","#0868ac"],6:["#f0f9e8","#ccebc5","#a8ddb5","#7bccc4","#43a2ca","#0868ac"],7:["#f0f9e8","#ccebc5","#a8ddb5","#7bccc4","#4eb3d3","#2b8cbe","#08589e"],8:["#f7fcf0","#e0f3db","#ccebc5","#a8ddb5","#7bccc4","#4eb3d3","#2b8cbe","#08589e"],9:["#f7fcf0","#e0f3db","#ccebc5","#a8ddb5","#7bccc4","#4eb3d3","#2b8cbe","#0868ac","#084081"]},BuGn:{3:["#e5f5f9","#99d8c9","#2ca25f"],4:["#edf8fb","#b2e2e2","#66c2a4","#238b45"],5:["#edf8fb","#b2e2e2","#66c2a4","#2ca25f","#006d2c"],6:["#edf8fb","#ccece6","#99d8c9","#66c2a4","#2ca25f","#006d2c"],7:["#edf8fb","#ccece6","#99d8c9","#66c2a4","#41ae76","#238b45","#005824"],8:["#f7fcfd","#e5f5f9","#ccece6","#99d8c9","#66c2a4","#41ae76","#238b45","#005824"],9:["#f7fcfd","#e5f5f9","#ccece6","#99d8c9","#66c2a4","#41ae76","#238b45","#006d2c","#00441b"]},PuBuGn:{3:["#ece2f0","#a6bddb","#1c9099"],4:["#f6eff7","#bdc9e1","#67a9cf","#02818a"],5:["#f6eff7","#bdc9e1","#67a9cf","#1c9099","#016c59"],6:["#f6eff7","#d0d1e6","#a6bddb","#67a9cf","#1c9099","#016c59"],7:["#f6eff7","#d0d1e6","#a6bddb","#67a9cf","#3690c0","#02818a","#016450"],8:["#fff7fb","#ece2f0","#d0d1e6","#a6bddb","#67a9cf","#3690c0","#02818a","#016450"],9:["#fff7fb","#ece2f0","#d0d1e6","#a6bddb","#67a9cf","#3690c0","#02818a","#016c59","#014636"]},PuBu:{3:["#ece7f2","#a6bddb","#2b8cbe"],4:["#f1eef6","#bdc9e1","#74a9cf","#0570b0"],5:["#f1eef6","#bdc9e1","#74a9cf","#2b8cbe","#045a8d"],6:["#f1eef6","#d0d1e6","#a6bddb","#74a9cf","#2b8cbe","#045a8d"],7:["#f1eef6","#d0d1e6","#a6bddb","#74a9cf","#3690c0","#0570b0","#034e7b"],8:["#fff7fb","#ece7f2","#d0d1e6","#a6bddb","#74a9cf","#3690c0","#0570b0","#034e7b"],9:["#fff7fb","#ece7f2","#d0d1e6","#a6bddb","#74a9cf","#3690c0","#0570b0","#045a8d","#023858"]},BuPu:{3:["#e0ecf4","#9ebcda","#8856a7"],4:["#edf8fb","#b3cde3","#8c96c6","#88419d"],5:["#edf8fb","#b3cde3","#8c96c6","#8856a7","#810f7c"],6:["#edf8fb","#bfd3e6","#9ebcda","#8c96c6","#8856a7","#810f7c"],7:["#edf8fb","#bfd3e6","#9ebcda","#8c96c6","#8c6bb1","#88419d","#6e016b"],8:["#f7fcfd","#e0ecf4","#bfd3e6","#9ebcda","#8c96c6","#8c6bb1","#88419d","#6e016b"],9:["#f7fcfd","#e0ecf4","#bfd3e6","#9ebcda","#8c96c6","#8c6bb1","#88419d","#810f7c","#4d004b"]},RdPu:{3:["#fde0dd","#fa9fb5","#c51b8a"],4:["#feebe2","#fbb4b9","#f768a1","#ae017e"],5:["#feebe2","#fbb4b9","#f768a1","#c51b8a","#7a0177"],6:["#feebe2","#fcc5c0","#fa9fb5","#f768a1","#c51b8a","#7a0177"],7:["#feebe2","#fcc5c0","#fa9fb5","#f768a1","#dd3497","#ae017e","#7a0177"],8:["#fff7f3","#fde0dd","#fcc5c0","#fa9fb5","#f768a1","#dd3497","#ae017e","#7a0177"],9:["#fff7f3","#fde0dd","#fcc5c0","#fa9fb5","#f768a1","#dd3497","#ae017e","#7a0177","#49006a"]},PuRd:{3:["#e7e1ef","#c994c7","#dd1c77"],4:["#f1eef6","#d7b5d8","#df65b0","#ce1256"],5:["#f1eef6","#d7b5d8","#df65b0","#dd1c77","#980043"],6:["#f1eef6","#d4b9da","#c994c7","#df65b0","#dd1c77","#980043"],7:["#f1eef6","#d4b9da","#c994c7","#df65b0","#e7298a","#ce1256","#91003f"],8:["#f7f4f9","#e7e1ef","#d4b9da","#c994c7","#df65b0","#e7298a","#ce1256","#91003f"],9:["#f7f4f9","#e7e1ef","#d4b9da","#c994c7","#df65b0","#e7298a","#ce1256","#980043","#67001f"]},OrRd:{3:["#fee8c8","#fdbb84","#e34a33"],4:["#fef0d9","#fdcc8a","#fc8d59","#d7301f"],5:["#fef0d9","#fdcc8a","#fc8d59","#e34a33","#b30000"],6:["#fef0d9","#fdd49e","#fdbb84","#fc8d59","#e34a33","#b30000"],7:["#fef0d9","#fdd49e","#fdbb84","#fc8d59","#ef6548","#d7301f","#990000"],8:["#fff7ec","#fee8c8","#fdd49e","#fdbb84","#fc8d59","#ef6548","#d7301f","#990000"],9:["#fff7ec","#fee8c8","#fdd49e","#fdbb84","#fc8d59","#ef6548","#d7301f","#b30000","#7f0000"]},YlOrRd:{3:["#ffeda0","#feb24c","#f03b20"],4:["#ffffb2","#fecc5c","#fd8d3c","#e31a1c"],5:["#ffffb2","#fecc5c","#fd8d3c","#f03b20","#bd0026"],6:["#ffffb2","#fed976","#feb24c","#fd8d3c","#f03b20","#bd0026"],7:["#ffffb2","#fed976","#feb24c","#fd8d3c","#fc4e2a","#e31a1c","#b10026"],8:["#ffffcc","#ffeda0","#fed976","#feb24c","#fd8d3c","#fc4e2a","#e31a1c","#b10026"],9:["#ffffcc","#ffeda0","#fed976","#feb24c","#fd8d3c","#fc4e2a","#e31a1c","#bd0026","#800026"]},YlOrBr:{3:["#fff7bc","#fec44f","#d95f0e"],4:["#ffffd4","#fed98e","#fe9929","#cc4c02"],5:["#ffffd4","#fed98e","#fe9929","#d95f0e","#993404"],6:["#ffffd4","#fee391","#fec44f","#fe9929","#d95f0e","#993404"],7:["#ffffd4","#fee391","#fec44f","#fe9929","#ec7014","#cc4c02","#8c2d04"],8:["#ffffe5","#fff7bc","#fee391","#fec44f","#fe9929","#ec7014","#cc4c02","#8c2d04"],9:["#ffffe5","#fff7bc","#fee391","#fec44f","#fe9929","#ec7014","#cc4c02","#993404","#662506"]},Purples:{3:["#efedf5","#bcbddc","#756bb1"],4:["#f2f0f7","#cbc9e2","#9e9ac8","#6a51a3"],5:["#f2f0f7","#cbc9e2","#9e9ac8","#756bb1","#54278f"],6:["#f2f0f7","#dadaeb","#bcbddc","#9e9ac8","#756bb1","#54278f"],7:["#f2f0f7","#dadaeb","#bcbddc","#9e9ac8","#807dba","#6a51a3","#4a1486"],8:["#fcfbfd","#efedf5","#dadaeb","#bcbddc","#9e9ac8","#807dba","#6a51a3","#4a1486"],9:["#fcfbfd","#efedf5","#dadaeb","#bcbddc","#9e9ac8","#807dba","#6a51a3","#54278f","#3f007d"]},Blues:{3:["#deebf7","#9ecae1","#3182bd"],4:["#eff3ff","#bdd7e7","#6baed6","#2171b5"],5:["#eff3ff","#bdd7e7","#6baed6","#3182bd","#08519c"],6:["#eff3ff","#c6dbef","#9ecae1","#6baed6","#3182bd","#08519c"],7:["#eff3ff","#c6dbef","#9ecae1","#6baed6","#4292c6","#2171b5","#084594"],8:["#f7fbff","#deebf7","#c6dbef","#9ecae1","#6baed6","#4292c6","#2171b5","#084594"],9:["#f7fbff","#deebf7","#c6dbef","#9ecae1","#6baed6","#4292c6","#2171b5","#08519c","#08306b"]},Greens:{3:["#e5f5e0","#a1d99b","#31a354"],4:["#edf8e9","#bae4b3","#74c476","#238b45"],5:["#edf8e9","#bae4b3","#74c476","#31a354","#006d2c"],6:["#edf8e9","#c7e9c0","#a1d99b","#74c476","#31a354","#006d2c"],7:["#edf8e9","#c7e9c0","#a1d99b","#74c476","#41ab5d","#238b45","#005a32"],8:["#f7fcf5","#e5f5e0","#c7e9c0","#a1d99b","#74c476","#41ab5d","#238b45","#005a32"],9:["#f7fcf5","#e5f5e0","#c7e9c0","#a1d99b","#74c476","#41ab5d","#238b45","#006d2c","#00441b"]},Oranges:{3:["#fee6ce","#fdae6b","#e6550d"],4:["#feedde","#fdbe85","#fd8d3c","#d94701"],5:["#feedde","#fdbe85","#fd8d3c","#e6550d","#a63603"],6:["#feedde","#fdd0a2","#fdae6b","#fd8d3c","#e6550d","#a63603"],7:["#feedde","#fdd0a2","#fdae6b","#fd8d3c","#f16913","#d94801","#8c2d04"],8:["#fff5eb","#fee6ce","#fdd0a2","#fdae6b","#fd8d3c","#f16913","#d94801","#8c2d04"],9:["#fff5eb","#fee6ce","#fdd0a2","#fdae6b","#fd8d3c","#f16913","#d94801","#a63603","#7f2704"]},Reds:{3:["#fee0d2","#fc9272","#de2d26"],4:["#fee5d9","#fcae91","#fb6a4a","#cb181d"],5:["#fee5d9","#fcae91","#fb6a4a","#de2d26","#a50f15"],6:["#fee5d9","#fcbba1","#fc9272","#fb6a4a","#de2d26","#a50f15"],7:["#fee5d9","#fcbba1","#fc9272","#fb6a4a","#ef3b2c","#cb181d","#99000d"],8:["#fff5f0","#fee0d2","#fcbba1","#fc9272","#fb6a4a","#ef3b2c","#cb181d","#99000d"],9:["#fff5f0","#fee0d2","#fcbba1","#fc9272","#fb6a4a","#ef3b2c","#cb181d","#a50f15","#67000d"]},Greys:{3:["#f0f0f0","#bdbdbd","#636363"],4:["#f7f7f7","#cccccc","#969696","#525252"],5:["#f7f7f7","#cccccc","#969696","#636363","#252525"],6:["#f7f7f7","#d9d9d9","#bdbdbd","#969696","#636363","#252525"],7:["#f7f7f7","#d9d9d9","#bdbdbd","#969696","#737373","#525252","#252525"],8:["#ffffff","#f0f0f0","#d9d9d9","#bdbdbd","#969696","#737373","#525252","#252525"],9:["#ffffff","#f0f0f0","#d9d9d9","#bdbdbd","#969696","#737373","#525252","#252525","#000000"]},PuOr:{3:["#f1a340","#f7f7f7","#998ec3"],4:["#e66101","#fdb863","#b2abd2","#5e3c99"],5:["#e66101","#fdb863","#f7f7f7","#b2abd2","#5e3c99"],6:["#b35806","#f1a340","#fee0b6","#d8daeb","#998ec3","#542788"],7:["#b35806","#f1a340","#fee0b6","#f7f7f7","#d8daeb","#998ec3","#542788"],8:["#b35806","#e08214","#fdb863","#fee0b6","#d8daeb","#b2abd2","#8073ac","#542788"],9:["#b35806","#e08214","#fdb863","#fee0b6","#f7f7f7","#d8daeb","#b2abd2","#8073ac","#542788"],10:["#7f3b08","#b35806","#e08214","#fdb863","#fee0b6","#d8daeb","#b2abd2","#8073ac","#542788","#2d004b"],11:["#7f3b08","#b35806","#e08214","#fdb863","#fee0b6","#f7f7f7","#d8daeb","#b2abd2","#8073ac","#542788","#2d004b"]},BrBG:{3:["#d8b365","#f5f5f5","#5ab4ac"],4:["#a6611a","#dfc27d","#80cdc1","#018571"],5:["#a6611a","#dfc27d","#f5f5f5","#80cdc1","#018571"],6:["#8c510a","#d8b365","#f6e8c3","#c7eae5","#5ab4ac","#01665e"],7:["#8c510a","#d8b365","#f6e8c3","#f5f5f5","#c7eae5","#5ab4ac","#01665e"],8:["#8c510a","#bf812d","#dfc27d","#f6e8c3","#c7eae5","#80cdc1","#35978f","#01665e"],9:["#8c510a","#bf812d","#dfc27d","#f6e8c3","#f5f5f5","#c7eae5","#80cdc1","#35978f","#01665e"],10:["#543005","#8c510a","#bf812d","#dfc27d","#f6e8c3","#c7eae5","#80cdc1","#35978f","#01665e","#003c30"],11:["#543005","#8c510a","#bf812d","#dfc27d","#f6e8c3","#f5f5f5","#c7eae5","#80cdc1","#35978f","#01665e","#003c30"]},PRGn:{3:["#af8dc3","#f7f7f7","#7fbf7b"],4:["#7b3294","#c2a5cf","#a6dba0","#008837"],5:["#7b3294","#c2a5cf","#f7f7f7","#a6dba0","#008837"],6:["#762a83","#af8dc3","#e7d4e8","#d9f0d3","#7fbf7b","#1b7837"],7:["#762a83","#af8dc3","#e7d4e8","#f7f7f7","#d9f0d3","#7fbf7b","#1b7837"],8:["#762a83","#9970ab","#c2a5cf","#e7d4e8","#d9f0d3","#a6dba0","#5aae61","#1b7837"],9:["#762a83","#9970ab","#c2a5cf","#e7d4e8","#f7f7f7","#d9f0d3","#a6dba0","#5aae61","#1b7837"],10:["#40004b","#762a83","#9970ab","#c2a5cf","#e7d4e8","#d9f0d3","#a6dba0","#5aae61","#1b7837","#00441b"],11:["#40004b","#762a83","#9970ab","#c2a5cf","#e7d4e8","#f7f7f7","#d9f0d3","#a6dba0","#5aae61","#1b7837","#00441b"]},PiYG:{3:["#e9a3c9","#f7f7f7","#a1d76a"],4:["#d01c8b","#f1b6da","#b8e186","#4dac26"],5:["#d01c8b","#f1b6da","#f7f7f7","#b8e186","#4dac26"],6:["#c51b7d","#e9a3c9","#fde0ef","#e6f5d0","#a1d76a","#4d9221"],7:["#c51b7d","#e9a3c9","#fde0ef","#f7f7f7","#e6f5d0","#a1d76a","#4d9221"],8:["#c51b7d","#de77ae","#f1b6da","#fde0ef","#e6f5d0","#b8e186","#7fbc41","#4d9221"],9:["#c51b7d","#de77ae","#f1b6da","#fde0ef","#f7f7f7","#e6f5d0","#b8e186","#7fbc41","#4d9221"],10:["#8e0152","#c51b7d","#de77ae","#f1b6da","#fde0ef","#e6f5d0","#b8e186","#7fbc41","#4d9221","#276419"],11:["#8e0152","#c51b7d","#de77ae","#f1b6da","#fde0ef","#f7f7f7","#e6f5d0","#b8e186","#7fbc41","#4d9221","#276419"]},RdBu:{3:["#ef8a62","#f7f7f7","#67a9cf"],4:["#ca0020","#f4a582","#92c5de","#0571b0"],5:["#ca0020","#f4a582","#f7f7f7","#92c5de","#0571b0"],6:["#b2182b","#ef8a62","#fddbc7","#d1e5f0","#67a9cf","#2166ac"],7:["#b2182b","#ef8a62","#fddbc7","#f7f7f7","#d1e5f0","#67a9cf","#2166ac"],8:["#b2182b","#d6604d","#f4a582","#fddbc7","#d1e5f0","#92c5de","#4393c3","#2166ac"],9:["#b2182b","#d6604d","#f4a582","#fddbc7","#f7f7f7","#d1e5f0","#92c5de","#4393c3","#2166ac"],10:["#67001f","#b2182b","#d6604d","#f4a582","#fddbc7","#d1e5f0","#92c5de","#4393c3","#2166ac","#053061"],11:["#67001f","#b2182b","#d6604d","#f4a582","#fddbc7","#f7f7f7","#d1e5f0","#92c5de","#4393c3","#2166ac","#053061"]},RdGy:{3:["#ef8a62","#ffffff","#999999"],4:["#ca0020","#f4a582","#bababa","#404040"],5:["#ca0020","#f4a582","#ffffff","#bababa","#404040"],6:["#b2182b","#ef8a62","#fddbc7","#e0e0e0","#999999","#4d4d4d"],7:["#b2182b","#ef8a62","#fddbc7","#ffffff","#e0e0e0","#999999","#4d4d4d"],8:["#b2182b","#d6604d","#f4a582","#fddbc7","#e0e0e0","#bababa","#878787","#4d4d4d"],9:["#b2182b","#d6604d","#f4a582","#fddbc7","#ffffff","#e0e0e0","#bababa","#878787","#4d4d4d"],10:["#67001f","#b2182b","#d6604d","#f4a582","#fddbc7","#e0e0e0","#bababa","#878787","#4d4d4d","#1a1a1a"],11:["#67001f","#b2182b","#d6604d","#f4a582","#fddbc7","#ffffff","#e0e0e0","#bababa","#878787","#4d4d4d","#1a1a1a"]},RdYlBu:{3:["#fc8d59","#ffffbf","#91bfdb"],4:["#d7191c","#fdae61","#abd9e9","#2c7bb6"],5:["#d7191c","#fdae61","#ffffbf","#abd9e9","#2c7bb6"],6:["#d73027","#fc8d59","#fee090","#e0f3f8","#91bfdb","#4575b4"],7:["#d73027","#fc8d59","#fee090","#ffffbf","#e0f3f8","#91bfdb","#4575b4"],8:["#d73027","#f46d43","#fdae61","#fee090","#e0f3f8","#abd9e9","#74add1","#4575b4"],9:["#d73027","#f46d43","#fdae61","#fee090","#ffffbf","#e0f3f8","#abd9e9","#74add1","#4575b4"],10:["#a50026","#d73027","#f46d43","#fdae61","#fee090","#e0f3f8","#abd9e9","#74add1","#4575b4","#313695"],11:["#a50026","#d73027","#f46d43","#fdae61","#fee090","#ffffbf","#e0f3f8","#abd9e9","#74add1","#4575b4","#313695"]},Spectral:{3:["#fc8d59","#ffffbf","#99d594"],4:["#d7191c","#fdae61","#abdda4","#2b83ba"],5:["#d7191c","#fdae61","#ffffbf","#abdda4","#2b83ba"],6:["#d53e4f","#fc8d59","#fee08b","#e6f598","#99d594","#3288bd"],7:["#d53e4f","#fc8d59","#fee08b","#ffffbf","#e6f598","#99d594","#3288bd"],8:["#d53e4f","#f46d43","#fdae61","#fee08b","#e6f598","#abdda4","#66c2a5","#3288bd"],9:["#d53e4f","#f46d43","#fdae61","#fee08b","#ffffbf","#e6f598","#abdda4","#66c2a5","#3288bd"],10:["#9e0142","#d53e4f","#f46d43","#fdae61","#fee08b","#e6f598","#abdda4","#66c2a5","#3288bd","#5e4fa2"],11:["#9e0142","#d53e4f","#f46d43","#fdae61","#fee08b","#ffffbf","#e6f598","#abdda4","#66c2a5","#3288bd","#5e4fa2"]},RdYlGn:{3:["#fc8d59","#ffffbf","#91cf60"],4:["#d7191c","#fdae61","#a6d96a","#1a9641"],5:["#d7191c","#fdae61","#ffffbf","#a6d96a","#1a9641"],6:["#d73027","#fc8d59","#fee08b","#d9ef8b","#91cf60","#1a9850"],7:["#d73027","#fc8d59","#fee08b","#ffffbf","#d9ef8b","#91cf60","#1a9850"],8:["#d73027","#f46d43","#fdae61","#fee08b","#d9ef8b","#a6d96a","#66bd63","#1a9850"],9:["#d73027","#f46d43","#fdae61","#fee08b","#ffffbf","#d9ef8b","#a6d96a","#66bd63","#1a9850"],10:["#a50026","#d73027","#f46d43","#fdae61","#fee08b","#d9ef8b","#a6d96a","#66bd63","#1a9850","#006837"],11:["#a50026","#d73027","#f46d43","#fdae61","#fee08b","#ffffbf","#d9ef8b","#a6d96a","#66bd63","#1a9850","#006837"]},Accent:{3:["#7fc97f","#beaed4","#fdc086"],4:["#7fc97f","#beaed4","#fdc086","#ffff99"],5:["#7fc97f","#beaed4","#fdc086","#ffff99","#386cb0"],6:["#7fc97f","#beaed4","#fdc086","#ffff99","#386cb0","#f0027f"],7:["#7fc97f","#beaed4","#fdc086","#ffff99","#386cb0","#f0027f","#bf5b17"],8:["#7fc97f","#beaed4","#fdc086","#ffff99","#386cb0","#f0027f","#bf5b17","#666666"]},Dark2:{3:["#1b9e77","#d95f02","#7570b3"],4:["#1b9e77","#d95f02","#7570b3","#e7298a"],5:["#1b9e77","#d95f02","#7570b3","#e7298a","#66a61e"],6:["#1b9e77","#d95f02","#7570b3","#e7298a","#66a61e","#e6ab02"],7:["#1b9e77","#d95f02","#7570b3","#e7298a","#66a61e","#e6ab02","#a6761d"],8:["#1b9e77","#d95f02","#7570b3","#e7298a","#66a61e","#e6ab02","#a6761d","#666666"]},Paired:{3:["#a6cee3","#1f78b4","#b2df8a"],4:["#a6cee3","#1f78b4","#b2df8a","#33a02c"],5:["#a6cee3","#1f78b4","#b2df8a","#33a02c","#fb9a99"],6:["#a6cee3","#1f78b4","#b2df8a","#33a02c","#fb9a99","#e31a1c"],7:["#a6cee3","#1f78b4","#b2df8a","#33a02c","#fb9a99","#e31a1c","#fdbf6f"],8:["#a6cee3","#1f78b4","#b2df8a","#33a02c","#fb9a99","#e31a1c","#fdbf6f","#ff7f00"],9:["#a6cee3","#1f78b4","#b2df8a","#33a02c","#fb9a99","#e31a1c","#fdbf6f","#ff7f00","#cab2d6"],10:["#a6cee3","#1f78b4","#b2df8a","#33a02c","#fb9a99","#e31a1c","#fdbf6f","#ff7f00","#cab2d6","#6a3d9a"],11:["#a6cee3","#1f78b4","#b2df8a","#33a02c","#fb9a99","#e31a1c","#fdbf6f","#ff7f00","#cab2d6","#6a3d9a","#ffff99"],12:["#a6cee3","#1f78b4","#b2df8a","#33a02c","#fb9a99","#e31a1c","#fdbf6f","#ff7f00","#cab2d6","#6a3d9a","#ffff99","#b15928"]},Pastel1:{3:["#fbb4ae","#b3cde3","#ccebc5"],4:["#fbb4ae","#b3cde3","#ccebc5","#decbe4"],5:["#fbb4ae","#b3cde3","#ccebc5","#decbe4","#fed9a6"],6:["#fbb4ae","#b3cde3","#ccebc5","#decbe4","#fed9a6","#ffffcc"],7:["#fbb4ae","#b3cde3","#ccebc5","#decbe4","#fed9a6","#ffffcc","#e5d8bd"],8:["#fbb4ae","#b3cde3","#ccebc5","#decbe4","#fed9a6","#ffffcc","#e5d8bd","#fddaec"],9:["#fbb4ae","#b3cde3","#ccebc5","#decbe4","#fed9a6","#ffffcc","#e5d8bd","#fddaec","#f2f2f2"]},Pastel2:{3:["#b3e2cd","#fdcdac","#cbd5e8"],4:["#b3e2cd","#fdcdac","#cbd5e8","#f4cae4"],5:["#b3e2cd","#fdcdac","#cbd5e8","#f4cae4","#e6f5c9"],6:["#b3e2cd","#fdcdac","#cbd5e8","#f4cae4","#e6f5c9","#fff2ae"],7:["#b3e2cd","#fdcdac","#cbd5e8","#f4cae4","#e6f5c9","#fff2ae","#f1e2cc"],8:["#b3e2cd","#fdcdac","#cbd5e8","#f4cae4","#e6f5c9","#fff2ae","#f1e2cc","#cccccc"]},Set1:{3:["#e41a1c","#377eb8","#4daf4a"],4:["#e41a1c","#377eb8","#4daf4a","#984ea3"],5:["#e41a1c","#377eb8","#4daf4a","#984ea3","#ff7f00"],6:["#e41a1c","#377eb8","#4daf4a","#984ea3","#ff7f00","#ffff33"],7:["#e41a1c","#377eb8","#4daf4a","#984ea3","#ff7f00","#ffff33","#a65628"],8:["#e41a1c","#377eb8","#4daf4a","#984ea3","#ff7f00","#ffff33","#a65628","#f781bf"],9:["#e41a1c","#377eb8","#4daf4a","#984ea3","#ff7f00","#ffff33","#a65628","#f781bf","#999999"]},Set2:{3:["#66c2a5","#fc8d62","#8da0cb"],4:["#66c2a5","#fc8d62","#8da0cb","#e78ac3"],5:["#66c2a5","#fc8d62","#8da0cb","#e78ac3","#a6d854"],6:["#66c2a5","#fc8d62","#8da0cb","#e78ac3","#a6d854","#ffd92f"],7:["#66c2a5","#fc8d62","#8da0cb","#e78ac3","#a6d854","#ffd92f","#e5c494"],8:["#66c2a5","#fc8d62","#8da0cb","#e78ac3","#a6d854","#ffd92f","#e5c494","#b3b3b3"]},Set3:{3:["#8dd3c7","#ffffb3","#bebada"],4:["#8dd3c7","#ffffb3","#bebada","#fb8072"],5:["#8dd3c7","#ffffb3","#bebada","#fb8072","#80b1d3"],6:["#8dd3c7","#ffffb3","#bebada","#fb8072","#80b1d3","#fdb462"],7:["#8dd3c7","#ffffb3","#bebada","#fb8072","#80b1d3","#fdb462","#b3de69"],8:["#8dd3c7","#ffffb3","#bebada","#fb8072","#80b1d3","#fdb462","#b3de69","#fccde5"],9:["#8dd3c7","#ffffb3","#bebada","#fb8072","#80b1d3","#fdb462","#b3de69","#fccde5","#d9d9d9"],10:["#8dd3c7","#ffffb3","#bebada","#fb8072","#80b1d3","#fdb462","#b3de69","#fccde5","#d9d9d9","#bc80bd"],11:["#8dd3c7","#ffffb3","#bebada","#fb8072","#80b1d3","#fdb462","#b3de69","#fccde5","#d9d9d9","#bc80bd","#ccebc5"],12:["#8dd3c7","#ffffb3","#bebada","#fb8072","#80b1d3","#fdb462","#b3de69","#fccde5","#d9d9d9","#bc80bd","#ccebc5","#ffed6f"]},Default:{20:["#fe296c","#487eb6","#a7ce31","#f8cc03","#ff8c02","#699696","#b77844","#83acd0","#c2e076","#fadc5a","#ff549f","#ffaf54","#9ab8b7","#d2a683","#3d699b","#87ac22","#cda908","#d02158","#d07300","#567676"],36:["#ff0000","#0000ff","#00ff00","#ffff00","#00ffff","#ff00ff","#993300","#000080","#808000","#ff6600","#008080","#660066","#ff99cc","#666699","#333300","#ffcc99","#ccffff","#9999ff","#ff8080","#3366ff","#339966","#ffcc00","#00ccff","#d02090","#993366","#0066cc","#99cc00","#ff9900","#33cccc","#cc99ff","#800000","#333399","#008000","#ffffcc","#99ccff","#800080"]},Basic:{24:["#0000ff","#ff004d","#ffbf00","#74ff00","#a400ff","#ff7400","#ffff00","#00ffff","#ff0000","#ffd300","#3d00ff","#00ff00","#ff00ff","#ff9200","#d3ff00","#0090ff","#6d00ff","#ff4900","#ffe800","#00ff92","#ff0090","#ffaa00","#aaff00","#004dff"]},Light:{24:["#6565ff","#ff6593","#ffd865","#abff65","#c865ff","#ffab65","#ffff65","#65ffff","#ff6565","#ffe565","#8965ff","#65ff65","#ff65ff","#ffbd65","#e5ff65","#65bcff","#a765ff","#ff9165","#fff165","#65ffbd","#ff65bc","#ffcc65","#ccff65","#6593ff"]},Favorite:{1:["#ff0000"],2:["#ff0000","#00ffff"],3:["#ff0000","#00ff00","#0000ff"],4:["#ff0000","#80ff00","#00ffff","#8000ff"],5:["#ff0000","#bfff00","#00ff80","#0040ff","#ff00ff"],6:["#ff0000","#ffff00","#00ff00","#00ffff","#0000ff","#ff00ff"],8:["#ff0000","#ffbf00","#80ff00","#00ff40","#00ffff","#0040ff","#8000ff","#ff00bf"],10:["#ff0000","#ff8000","#ffff00","#80ff00","#00ff00","#00ff80","#00ffff","#0080ff","#0000ff","#8000ff"],12:["#ff0000","#ff8000","#ffff00","#80ff00","#00ff00","#00ff80","#00ffff","#0080ff","#0000ff","#8000ff","#ff00ff","#ff0080"],24:["#ff0000","#ff4000","#ff8000","#ffbf00","#ffff00","#bfff00","#80ff00","#40ff00","#00ff00","#00ff40","#00ff80","#00ffbf","#00ffff","#00bfff","#0080ff","#0040ff","#0000ff","#4000ff","#8000ff","#bf00ff","#ff00ff","#ff00bf","#ff0080","#ff0040"]},Pastel:{24:["#b5b5ff","#ffb5cb","#ffedb5","#d7ffb5","#e5b5ff","#ffd7b5","#ffffb5","#b5ffff","#ffb5b5","#fff2b5","#c7b5ff","#b5ffb5","#ffb5ff","#ffdfb5","#f2ffb5","#b5dfff","#d5b5ff","#ffcab5","#fff8b5","#b5ffdf","#ffb5df","#ffe6b5","#e6ffb5","#b5cbff"]},Balanced:{20:["#fe296c","#487eb6","#a7ce31","#f8cc03","#ff8c02","#699696","#b77844","#83acd0","#c2e076","#fadc5a","#ff549f","#ffaf54","#9ab8b7","#d2a683","#3d699b","#87ac22","#cda908","#d02158","#d07300","#567676"]},Rpalette:{8:["#000000","#ff0000","#00cd00","#0000ff","#00ffff","#ff00ff","#ffff00","#bebebe"]},RlatticeBackground:{7:["#ffe5cc","#ccffcc","#ccffff","#cce6ff","#ffccff","#ffcccc","#ffffcc"]},RlatticeShingle:{7:["#ff7f00","#00ff00","#00ffff","#0080ff","#ff00ff","#ff0000","#ffff00"]},RlatticeLine:{7:["#0080ff","#ff00ff","#006400","#ff0000","#ffa500","#00ff00","#a52a2a"]},RlatticePolygon:{7:["#ccffff","#ffccff","#ccffcc","#ffe5cc","#cce6ff","#ffffcc","#ffcccc"]},Bootstrap:{1:["#337ab7"],2:["#337ab7","#d9534f"],3:["#337ab7","#5cb85c","#d9534f"],4:["#337ab7","#5cb85c","#f0ad4e","#d9534f"],5:["#337ab7","#5cb85c","#5bc0de","#f0ad4e","#d9534f"],6:["#337ab7","#5cb85c","#9370db","#5bc0de","#f0ad4e","#d9534f"],7:["#337ab7","#5cb85c","#d9534f","#f0ad4e","#5bc0de","#84fe83","#ff9976"],8:["#337ab7","#5cb85c","#d9534f","#f0ad4e","#5bc0de","#84fe83","#ff9976","#c86727"]},ColorSpectrum:{1:[]},White:{1:["#ffffff"]},Black:{1:["#000000"]},Economist:{12:["#6794A7","#014D64","#76C0C1","#01A2D9","#7AD2F6","#00887D","#ADADAD","#7BD3F6","#7C260B","#EE8F71","#76C0C1","#A18376"]},EconomistBG:{5:["#D5E4EB","#C3D6DF","#ED111A","#EBEBEB","#C9C9C9"]},Excel:{7:["#FF00FF","#FFFF00","#00FFFF","#800080","#800000","#008080","#0000FF"]},Excel2:{7:["#993366","#FFFFCC","#CCFFFF","#660066","#FF8080","#0066CC","#CCCCFF"]},Excel3:{10:["#365E96","#983334","#77973D","#5D437C","#36869F","#D1702F","#8197C5","#C47F80","#ACC484","#9887B0"]},GGPlot:{1:["#F8766D"],2:["#F8766D","#00BFC4"],3:["#F8766D","#00BA38","#619CFF"],4:["#F8766D","#7CAE00","#00BFC4","#C77CFF"],5:["#F8766D","#A3A500","#00BF7D","#00B0F6","#E76BF3"],6:["#F8766D","#B79F00","#00BA38","#00BFC4","#619CFF","#F564E3"],7:["#F8766D","#C49A00","#53B400","#00C094","#00B6EB","#A58AFF","#FB61D7"],8:["#F8766D","#CD9600","#7CAE00","#00BE67","#00BFC4","#00A9FF","#C77CFF","#FF61CC"],9:["#F8766D","#D39200","#93AA00","#00BA38","#00C19F","#00B9E3","#619CFF","#DB72FB","#FF61C3"],10:["#F8766D","#D89000","#A3A500","#39B600","#00BF7D","#00BFC4","#00B0F6","#9590FF","#E76BF3","#FF62BC"],11:["#F8766D","#DB8E00","#AEA200","#64B200","#00BD5C","#00C1A7","#00BADE","#00A6FF","#B385FF","#EF67EB","#FF63B6"],12:["#F8766D","#DE8C00","#B79F00","#7CAE00","#00BA38","#00C08B","#00BFC4","#00B4F0","#619CFF","#C77CFF","#F564E3","#FF64B0"],13:["#F8766D","#E18A00","#BE9C00","#8CAB00","#24B700","#00BE70","#00C1AB","#00BBDA","#00ACFC","#8B93FF","#D575FE","#F962DD","#FF65AC"],14:["#F8766D","#E38900","#C49A00","#99A800","#53B400","#00BC56","#00C094","#00BFC4","#00B6EB","#06A4FF","#A58AFF","#DF70F8","#FB61D7","#FF66A8"],15:["#F8766D","#E58700","#C99800","#A3A500","#6BB100","#00BA38","#00BF7D","#00C0AF","#00BCD8","#00B0F6","#619CFF","#B983FF","#E76BF3","#FD61D1","#FF67A4"],16:["#F8766D","#E68613","#CD9600","#ABA300","#7CAE00","#0CB702","#00BE67","#00C19A","#00BFC4","#00B8E7","#00A9FF","#8494FF","#C77CFF","#ED68ED","#FF61CC","#FF68A1"],17:["#F8766D","#E7851E","#D09400","#B2A100","#89AC00","#45B500","#00BC51","#00C087","#00C0B2","#00BCD6","#00B3F2","#29A3FF","#9C8DFF","#D277FF","#F166E8","#FF61C7","#FF689E"],18:["#F8766D","#E88526","#D39200","#B79F00","#93AA00","#5EB300","#00BA38","#00BF74","#00C19F","#00BFC4","#00B9E3","#00ADFA","#619CFF","#AE87FF","#DB72FB","#F564E3","#FF61C3","#FF699C"]},Solarized:{1:["#B58900"],2:["#B58900","#859900"],3:["#B58900","#C671C4","#859900"],4:["#B58900","#DC322F","#268BD2","#859900"],5:["#B58900","#DC322F","#6C71C4","#268BD2","#859900"],6:["#B58900","#CB4B16","#D33682","#6C71C4","#2AA198","#859900"],7:["#B58900","#CB4B16","#DC322F","#6C71C4","#268BD2","#2AA198","#859900"],8:["#B58900","#CB4B16","#DC322F","#D33682","#6C71C4","#268BD2","#2AA198",,"#859900"]},SolarizedBase:{7:["#002B36","#073642","#586E75","#839496","#93A1A1","#EEE8D5","#FDF6E3"],8:["#002B36","#073642","#586E75","#657B83","#839496","#93A1A1","#EEE8D5","#FDF6E3"]},PaulTol:{1:["#4477AA"],2:["#4477AA","#CC6677"],3:["#4477AA","#DDCC77","#CC6677"],4:["#4477AA","#117733","#DDCC77","#CC6677"],5:["#4477AA","#88CCEE","#117733","#DDCC77","#CC6677"],6:["#4477AA","#88CCEE","#117733","#DDCC77","#CC6677","#AA4499"],7:["#332288","#88CCEE","#44AA99","#117733","#DDCC77","#CC6677","#AA4499"],8:["#332288","#88CCEE","#44AA99","#117733","#999933","#DDCC77","#CC6677","#AA4499"],9:["#332288","#88CCEE","#44AA99","#117733","#999933","#DDCC77","#CC6677","#882255","#AA4499"],10:["#332288","#88CCEE","#44AA99","#117733","#999933","#DDCC77","#661100","#CC6677","#882255","#AA4499"],11:["#332288","#6699CC","#88CCEE","#44AA99","#117733","#999933","#DDCC77","#661100","#CC6677","#882255","#AA4499"],12:["#332288","#6699CC","#88CCEE","#44AA99","#117733","#999933","#DDCC77","#661100","#CC6677","#AA4466","#882255","#AA4499"]},ColorBlind:{8:["#000000","#E69F00","#56B4E9","#009E73","#F0E442","#0072B2","#D55E00","#CC79A7"]},Tableau:{20:["#1F77B4","#AEC7E8","#FF7F0E","#FFBB78","#2CA02C","#98DF8A","#D62728","#FF9896","#9467BD","#C5B0D5","#8C564B","#C49C94","#E377C2","#F7B6D2","#7F7F7F","#C7C7C7","#BCBD22","#DBDB8D","#17BECF","#9EDAE5"],10:["#1F77B4","#FF7F0E","#2CA02C","#D62728","#9467BD","#8C564B","#E377C2","#7F7F7F","#BCBD22","#17BECF"]},TableauMedium:{10:["#729ECE","#FF9E4A","#67BF5C","#ED665D","#AD8BC9","#A8786E","#ED97CA","#A2A2A2","#CDCC5D","#6DCCDA"]},TableauLight:{10:["#AEC7E8","#FFBB78","#98DF8A","#FF9896","#C5B0D5","#C49C94","#F7B6D2","#C7C7C7","#DBDB8D","#9EDAE5"]},TableauGrey:{5:["#60636A","#A5ACAF","#414451","#8F8782","#CFCFCF"]},TableauColorBlind:{10:["#006BA4","#FF800E","#ABABAB","#595959","#5F9ED1","#C85200","#898989","#A2C8EC","#FFBC79","#CFCFCF"]},TableauTrafficLight:{9:["#B10318","#DBA13A","#309343","#D82526","#FFC156","#69B764","#F26C64","#FFDD71","#9FCD99"]},TableauPurpleGrey:{12:["#7B66D2","#A699E8","#DC5FBD","#FFC0DA","#5F5A41","#B4B19B","#995688","#D898BA","#AB6AD5","#D098EE","#8B7C6E","#DBD4C5"]},TableauBlueRed:{12:["#2C69B0","#B5C8E2","#F02720","#FFB6B0","#AC613C","#E9C39B","#6BA3D6","#B5DFFD","#AC8763","#DDC9B4","#BD0A36","#F4737A"]},TableauGreenOrange:{12:["#32A251","#ACD98D","#FF7F0F","#FFB977","#3CB7CC","#98D9E4","#B85A0D","#FFD94A","#39737C","#86B4A9","#82853B","#CCC94D"]},TableauCyclic:{20:["#1F83B4","#1696AC","#18A188","#29A03C","#54A338","#82A93F","#ADB828","#D8BD35","#FFBD4C","#FFB022","#FF9C0E","#FF810E","#E75727","#D23E4E","#C94D8C","#C04AA7","#B446B3","#9658B1","#8061B4","#6F63BB"]},TableauPairSequential:{32:["#BCCFB4","#9C0824","#BCCFB4","#09622A","#B4D4DA","#26456E","#F0C294","#7B3014","#C3C3C3","#1E1E1E","#E5E5E5","#FFB2B6","#E5E5E5","#B7E6A7","#E5E5E5","#C4D8F3","#E5E5E5","#FFCC9E","#F5CAC7","#BD1100","#DBE8B4","#3C8200","#F3E0C2","#BB5137","#FEFFD9","#41B7C4","#F7E4C6","#BB5137","#EFEDF5","#807DBA","#F0F0F0","#737373"]},TableauTripleDiverging:{48:["#9C0824","#CACACA","#26456E","#9C0824","#CACACA","#09622A","#9C0824","#FFFFFF","#09622A","#9C0824","#CACACA","#1E1E1E","#9C0824","#FFFFFF","#1E1E1E","#09622A","#CACACA","#26456E","#7B3014","#CACACA","#26456E","#7B3014","#FFFFFF","#26456E","#FFB2B6","#E5E5E5","#B7E6A7","#FFB2B6","#FFFFFF","#B7E6A7","#FFB2B6","#FFFFFF","#C6C6C6","#FFCC9E","#E5E5E5","#C4D8F3","#FFCC9E","#FFFFFF","#C4D8F3","#E0AD30","#E4E4E2","#7492AA","#EDA389","#CDE1D3","#5C8B70","#529985","#DBCF47","#C26B51"]},WallStreetJournal:{4:["#EFEFEF","#E9F3EA","#D4DEE7","#F8F2E4"]},WallStreetJournal2:{4:["#D3BA68","#D5695D","#5D8CA8","#65A479"]},WallStreetJournalRedGreen:{2:["#088158","#BA2F2A"]},WallStreetJournalBlackGreen:{4:["#000000","#595959","#59A77F","#008856"]},WallStreetJournalDemRep:{3:["#006A8E","#B1283A","#A8A6A7"]},WallStreetJournal3:{6:["#C72E29","#016392","#BE9C2E","#098154","#FB832D","#000000"]},Stata:{15:["#1A476F","#90353B","#55752F","#E37E00","#6E8E84","#C10534","#938DD2","#CAC27E","#A0522D","#7B92A8","#2D6D66","#9C8847","#BFA19C","#FFD200","#D9E6EB"]},Stata2:{15:["#FFFF00","#00FF00","#0080FF","#FF00FF","#FF7F00","#FF0000","#ADD8E6","#FFE474","#00FF80","#C0DCC0","#FF4500","#0000FF","#FF0080","#6E8E84","#A0522D"]},Stata3:{15:["#006000","#ff4500","#1a476f","#90353b","#6e8e84","#a0522d","#ff7f00","#ff00ff","#00ffff","#ff0000","#00ff00","#9c8847","#800080","#c0dcc0","#add8e6"]},StataMono:{15:["#606060","#A0A0A0","#808080","#404040","#000000","#E0E0E0","#202020","#707070","#909090","#B0B0B0","#D0D0D0","#F0F0F0","#303030","#C0C0C0","#505050"]},BlackAndWhite:{3:["#f0f0f0","#bdbdbd","#636363"],4:["#f7f7f7","#cccccc","#969696","#525252"],5:["#f7f7f7","#cccccc","#969696","#636363","#252525"],6:["#f7f7f7","#d9d9d9","#bdbdbd","#969696","#636363","#252525"],7:["#f7f7f7","#d9d9d9","#bdbdbd","#969696","#737373","#525252","#252525"],8:["#ffffff","#f0f0f0","#d9d9d9","#bdbdbd","#969696","#737373","#525252","#252525"],9:["#ffffff","#f0f0f0","#d9d9d9","#bdbdbd","#969696","#737373","#525252","#252525","#000000"]},CanvasXpress:{1:["#f2000d"],2:["#f2000d","#000df2"],3:["#f2000d","#000df2","#0df200"],4:["#f2000d","#000df2","#0df200","#f2f20d"],5:["#f2000d","#000df2","#0df200","#f2f20d","#f20df2"],6:["#f2000d","#000df2","#0df200","#f2f20d","#f20df2","#0df2f2"],7:["#f2000d","#000df2","#0df200","#f2f20d","#f20df2","#0df2f2","#f2f2f2"],8:["#f2000d","#000df2","#0df200","#f2f20d","#f20df2","#0df2f2","#f2f2f2","#fe8bd3"],9:["#f2000d","#000df2","#0df200","#f2f20d","#f20df2","#0df2f2","#f2f2f2","#fe8bd3","#8bd3fe"],10:["#f2000d","#000df2","#0df200","#f2f20d","#f20df2","#0df2f2","#f2f2f2","#fe8bd3","#8bd3fe","#d3fe8b"],11:["#f2000d","#000df2","#0df200","#f2f20d","#f20df2","#0df2f2","#f2f2f2","#fe8bd3","#8bd3fe","#d3fe8b","#5d0016"],12:["#f2000d","#000df2","#0df200","#f2f20d","#f20df2","#0df2f2","#f2f2f2","#fe8bd3","#8bd3fe","#d3fe8b","#5d0016","#00165d"],13:["#f2000d","#000df2","#0df200","#f2f20d","#f20df2","#0df2f2","#f2f2f2","#fe8bd3","#8bd3fe","#d3fe8b","#5d0016","#00165d","#165d00"],14:["#f2000d","#000df2","#0df200","#f2f20d","#f20df2","#0df2f2","#f2f2f2","#fe8bd3","#8bd3fe","#d3fe8b","#5d0016","#00165d","#165d00","#080808"],15:["#f2000d","#000df2","#0df200","#f2f20d","#f20df2","#0df2f2","#f2f2f2","#fe8bd3","#8bd3fe","#d3fe8b","#5d0016","#00165d","#165d00","#080808","#fed38b"],16:["#f2000d","#000df2","#0df200","#f2f20d","#f20df2","#0df2f2","#f2f2f2","#fe8bd3","#8bd3fe","#d3fe8b","#5d0016","#00165d","#165d00","#080808","#fed38b","#d38bfe"],17:["#f2000d","#000df2","#0df200","#f2f20d","#f20df2","#0df2f2","#f2f2f2","#fe8bd3","#8bd3fe","#d3fe8b","#5d0016","#00165d","#165d00","#080808","#fed38b","#d38bfe","#8bfed3"],18:["#f2000d","#000df2","#0df200","#f2f20d","#f20df2","#0df2f2","#f2f2f2","#fe8bd3","#8bd3fe","#d3fe8b","#5d0016","#00165d","#165d00","#080808","#fed38b","#d38bfe","#8bfed3","#404040"]},CanvasXpressT:{1:["rgba(242,0,13,0.5)"],2:["rgba(242,0,13,0.5)","rgba(0,13,242,0.5)"],3:["rgba(242,0,13,0.5)","rgba(0,13,242,0.5)","rgba(13,242,0,0.5)"],4:["rgba(242,0,13,0.5)","rgba(0,13,242,0.5)","rgba(13,242,0,0.5)","rgba(242,242,13,0.5)"],5:["rgba(242,0,13,0.5)","rgba(0,13,242,0.5)","rgba(13,242,0,0.5)","rgba(242,242,13,0.5)","rgba(242,13,242,0.5)"],6:["rgba(242,0,13,0.5)","rgba(0,13,242,0.5)","rgba(13,242,0,0.5)","rgba(242,242,13,0.5)","rgba(242,13,242,0.5)","rgba(13,242,242,0.5)"],7:["rgba(242,0,13,0.5)","rgba(0,13,242,0.5)","rgba(13,242,0,0.5)","rgba(242,242,13,0.5)","rgba(242,13,242,0.5)","rgba(13,242,242,0.5)","rgba(242,242,242,0.5)"],8:["rgba(242,0,13,0.5)","rgba(0,13,242,0.5)","rgba(13,242,0,0.5)","rgba(242,242,13,0.5)","rgba(242,13,242,0.5)","rgba(13,242,242,0.5)","rgba(242,242,242,0.5)","rgba(254,139,211,0.5)"],9:["rgba(242,0,13,0.5)","rgba(0,13,242,0.5)","rgba(13,242,0,0.5)","rgba(242,242,13,0.5)","rgba(242,13,242,0.5)","rgba(13,242,242,0.5)","rgba(242,242,242,0.5)","rgba(254,139,211,0.5)","rgba(139,211,254,0.5)"],10:["rgba(242,0,13,0.5)","rgba(0,13,242,0.5)","rgba(13,242,0,0.5)","rgba(242,242,13,0.5)","rgba(242,13,242,0.5)","rgba(13,242,242,0.5)","rgba(242,242,242,0.5)","rgba(254,139,211,0.5)","rgba(139,211,254,0.5)","rgba(211,254,139,0.5)"],11:["rgba(242,0,13,0.5)","rgba(0,13,242,0.5)","rgba(13,242,0,0.5)","rgba(242,242,13,0.5)","rgba(242,13,242,0.5)","rgba(13,242,242,0.5)","rgba(242,242,242,0.5)","rgba(254,139,211,0.5)","rgba(139,211,254,0.5)","rgba(211,254,139,0.5)","rgba(93,0,22,0.5)"],12:["rgba(242,0,13,0.5)","rgba(0,13,242,0.5)","rgba(13,242,0,0.5)","rgba(242,242,13,0.5)","rgba(242,13,242,0.5)","rgba(13,242,242,0.5)","rgba(242,242,242,0.5)","rgba(254,139,211,0.5)","rgba(139,211,254,0.5)","rgba(211,254,139,0.5)","rgba(93,0,22,0.5)","rgba(0,22,93,0.5)"],13:["rgba(242,0,13,0.5)","rgba(0,13,242,0.5)","rgba(13,242,0,0.5)","rgba(242,242,13,0.5)","rgba(242,13,242,0.5)","rgba(13,242,242,0.5)","rgba(242,242,242,0.5)","rgba(254,139,211,0.5)","rgba(139,211,254,0.5)","rgba(211,254,139,0.5)","rgba(93,0,22,0.5)","rgba(0,22,93,0.5)","rgba(22,93,0,0.5)"],14:["rgba(242,0,13,0.5)","rgba(0,13,242,0.5)","rgba(13,242,0,0.5)","rgba(242,242,13,0.5)","rgba(242,13,242,0.5)","rgba(13,242,242,0.5)","rgba(242,242,242,0.5)","rgba(254,139,211,0.5)","rgba(139,211,254,0.5)","rgba(211,254,139,0.5)","rgba(93,0,22,0.5)","rgba(0,22,93,0.5)","rgba(22,93,0,0.5)","rgba(8,8,8,0.5)"],15:["rgba(242,0,13,0.5)","rgba(0,13,242,0.5)","rgba(13,242,0,0.5)","rgba(242,242,13,0.5)","rgba(242,13,242,0.5)","rgba(13,242,242,0.5)","rgba(242,242,242,0.5)","rgba(254,139,211,0.5)","rgba(139,211,254,0.5)","rgba(211,254,139,0.5)","rgba(93,0,22,0.5)","rgba(0,22,93,0.5)","rgba(22,93,0,0.5)","rgba(8,8,8,0.5)","rgba(254,211,139,0.5)"],16:["rgba(242,0,13,0.5)","rgba(0,13,242,0.5)","rgba(13,242,0,0.5)","rgba(242,242,13,0.5)","rgba(242,13,242,0.5)","rgba(13,242,242,0.5)","rgba(242,242,242,0.5)","rgba(254,139,211,0.5)","rgba(139,211,254,0.5)","rgba(211,254,139,0.5)","rgba(93,0,22,0.5)","rgba(0,22,93,0.5)","rgba(22,93,0,0.5)","rgba(8,8,8,0.5)","rgba(254,211,139,0.5)","rgba(211,139,254,0.5)"],17:["rgba(242,0,13,0.5)","rgba(0,13,242,0.5)","rgba(13,242,0,0.5)","rgba(242,242,13,0.5)","rgba(242,13,242,0.5)","rgba(13,242,242,0.5)","rgba(242,242,242,0.5)","rgba(254,139,211,0.5)","rgba(139,211,254,0.5)","rgba(211,254,139,0.5)","rgba(93,0,22,0.5)","rgba(0,22,93,0.5)","rgba(22,93,0,0.5)","rgba(8,8,8,0.5)","rgba(254,211,139,0.5)","rgba(211,139,254,0.5)","rgba(139,254,211,0.5)"],18:["rgba(242,0,13,0.5)","rgba(0,13,242,0.5)","rgba(13,242,0,0.5)","rgba(242,242,13,0.5)","rgba(242,13,242,0.5)","rgba(13,242,242,0.5)","rgba(242,242,242,0.5)","rgba(254,139,211,0.5)","rgba(139,211,254,0.5)","rgba(211,254,139,0.5)","rgba(93,0,22,0.5)","rgba(0,22,93,0.5)","rgba(22,93,0,0.5)","rgba(8,8,8,0.5)","rgba(254,211,139,0.5)","rgba(211,139,254,0.5)","rgba(139,254,211,0.5)","rgba(64,64,64,0.5)"]},Matlab:{7:["rgb(0,114,189)","rgb(217,83,25)","rgb(237,177,32)","rgb(126,47,142)","rgb(119,172,48)","rgb(77,190,238)","rgb(162,20,47)"]},Parula:{10:["rgb(53,42,135)","rgb(15,92,221)","rgb(18,125,216)","rgb(7,156,207)","rgb(21,177,180)","rgb(89,189,140)","rgb(165,190,107)","rgb(225,185,82)","rgb(252,206,46)","rgb(249,251,14)"]},Viridis:{3:["#440154","#21908C","#FDE725"],4:["#440154","#31688E","#35B779","#FDE725"],5:["#440154","#3B528B","#21908C","#5DC863","#FDE725"],6:["#440154","#414487","#2A788E","#22A884","#7AD151","#FDE725"],7:["#440154","#443A83","#31688E","#21908C","#35B779","#8FD744","#FDE725"],8:["#440154","#46337E","#365C8D","#277F8E","#1FA187","#4AC16D","#9FDA3A","#FDE725"],9:["#440154","#472D7B","#3B528B","#2C728E","#21908C","#27AD81","#5DC863","#AADC32","#FDE725"],10:["#440154","#482878","#3E4A89","#31688E","#26828E","#1F9E89","#35B779","#6DCD59","#B4DE2C","#FDE725"],11:["#440154","#482576","#414487","#35608D","#2A788E","#21908C","#22A884","#43BF71","#7AD151","#BBDF27","#FDE725"],12:["#440154","#482173","#433E85","#38598C","#2D708E","#25858E","#1E9B8A","#2BB07F","#51C56A","#85D54A","#C2DF23","#FDE725"]},Magma:{3:["#000004","#B63679","#FCFDBF"],4:["#000004","#721F81","#F1605D","#FCFDBF"],5:["#000004","#51127C","#B63679","#FB8861","#FCFDBF"],6:["#000004","#3B0F70","#8C2981","#DE4968","#FE9F6D","#FCFDBF"],7:["#000004","#2D1160","#721F81","#B63679","#F1605D","#FEAF77","#FCFDBF"],8:["#000004","#231151","#5F187F","#982D80","#D3436E","#F8765C","#FEBA80","#FCFDBF"],9:["#000004","#1D1147","#51127C","#822681","#B63679","#E65164","#FB8861","#FEC287","#FCFDBF"],10:["#000004","#180F3E","#451077","#721F81","#9F2F7F","#CD4071","#F1605D","#FD9567","#FEC98D","#FCFDBF"],11:["#000004","#150E37","#3B0F70","#641A80","#8C2981","#B63679","#DE4968","#F76F5C","#FE9F6D","#FECE91","#FCFDBF"],12:["#000004","#120D32","#331068","#5A167E","#7D2482","#A3307E","#C83E73","#E95562","#F97C5D","#FEA873","#FED395","#FCFDBF"]},Plasma:{3:["#0D0887","#CC4678","#F0F921"],4:["#0D0887","#9C179E","#ED7953","#F0F921"],5:["#0D0887","#7E03A8","#CC4678","#F89441","#F0F921"],6:["#0D0887","#6A00A8","#B12A90","#E16462","#FCA636","#F0F921"],7:["#0D0887","#5D01A6","#9C179E","#CC4678","#ED7953","#FDB32F","#F0F921"],8:["#0D0887","#5402A3","#8B0AA5","#B93289","#DB5C68","#F48849","#FEBC2A","#F0F921"],9:["#0D0887","#4C02A1","#7E03A8","#A92395","#CC4678","#E56B5D","#F89441","#FDC328","#F0F921"],10:["#0D0887","#47039F","#7301A8","#9C179E","#BD3786","#D8576B","#ED7953","#FA9E3B","#FDC926","#F0F921"],11:["#0D0887","#42049E","#6A00A8","#900DA4","#B12A90","#CC4678","#E16462","#F1844B","#FCA636","#FCCE25","#F0F921"],12:["#0D0887","#3E049C","#6300A7","#8707A6","#A62098","#C03A83","#D5546E","#E76F5A","#F58C46","#FDAD32","#FCD225","#F0F921"]},Inferno:{3:["#000004","#BB3754","#FCFFA4"],4:["#000004","#781C6D","#ED6925","#FCFFA4"],5:["#000004","#56106E","#BB3754","#F98C0A","#FCFFA4"],6:["#000004","#420A68","#932667","#DD513A","#FCA50A","#FCFFA4"],7:["#000004","#330A5F","#781C6D","#BB3754","#ED6925","#FCB519","#FCFFA4"],8:["#000004","#280B54","#65156E","#9F2A63","#D44842","#F57D15","#FAC127","#FCFFA4"],9:["#000004","#210C4A","#56106E","#89226A","#BB3754","#E35932","#F98C0A","#F9C932","#FCFFA4"],10:["#000004","#1B0C42","#4B0C6B","#781C6D","#A52C60","#CF4446","#ED6925","#FB9A06","#F7D03C","#FCFFA4"],11:["#000004","#170C3A","#420A68","#6B186E","#932667","#BB3754","#DD513A","#F3771A","#FCA50A","#F6D645","#FCFFA4"],12:["#000004","#140B35","#3A0963","#60136E","#85216B","#A92E5E","#CB4149","#E65D2F","#F78311","#FCAD12","#F5DB4B","#FCFFA4"]},Cividis:{3:["#00204D","#7C7B78","#FFEA46"],4:["#00204D","#575C6D","#A69D75","#FFEA46"],5:["#00204D","#414D6B","#7C7B78","#BCAF6F","#FFEA46"],6:["#00204D","#31446B","#666970","#958F78","#CBBA69","#FFEA46"],7:["#00204D","#233E6C","#575C6D","#7C7B78","#A69D75","#D3C164","#FFEA46"],8:["#00204D","#16396D","#4B546C","#6C6E72","#8E8A79","#B3A772","#DBC761","#FFEA46"],9:["#00204D","#05366E","#414D6B","#61646F","#7C7B78","#9B9477","#BCAF6F","#E0CB5E","#FFEA46"],10:["#00204D","#00336F","#39486B","#575C6D","#707173","#8A8779","#A69D75","#C4B56C","#E4CF5B","#FFEA46"],11:["#00204D","#00326F","#31446B","#4E576C","#666970","#7C7B78","#958F78","#B0A473","#CBBA69","#E7D159","#FFEA46"],12:["#00204D","#00306F","#2A406C","#48526B","#5E626E","#727374","#878479","#9E9677","#B6A971","#D0BE67","#EAD357","#FFEA46"]},Rainbow:{3:["#FF0000","#00FF00","#0000FF"],4:["#FF0000","#80FF00","#00FFFF","#8000FF"],5:["#FF0000","#CCFF00","#00FF66","#0066FF","#CC00FF"],6:["#FF0000","#FFFF00","#00FF00","#00FFFF","#0000FF","#FF00FF"],7:["#FF0000","#FFDB00","#49FF00","#00FF92","#0092FF","#4900FF","#FF00DB"],8:["#FF0000","#FFBF00","#80FF00","#00FF40","#00FFFF","#0040FF","#8000FF","#FF00BF"],9:["#FF0000","#FFAA00","#AAFF00","#00FF00","#00FFAA","#00AAFF","#0000FF","#AA00FF","#FF00AA"],10:["#FF0000","#FF9900","#CCFF00","#33FF00","#00FF66","#00FFFF","#0066FF","#3300FF","#CC00FF","#FF0099"],11:["#FF0000","#FF8B00","#E8FF00","#5DFF00","#00FF2E","#00FFB9","#00B9FF","#002EFF","#5D00FF","#E800FF","#FF008B"],12:["#FF0000","#FF8000","#FFFF00","#80FF00","#00FF00","#00FF80","#00FFFF","#0080FF","#0000FF","#8000FF","#FF00FF","#FF0080"]},Heat:{3:["#FF0000","#FF8000","#FFFF00"],4:["#FF0000","#FF8000","#FFFF00","#FFFF80"],5:["#FF0000","#FF5500","#FFAA00","#FFFF00","#FFFF80"],6:["#FF0000","#FF4000","#FF8000","#FFBF00","#FFFF00","#FFFF80"],7:["#FF0000","#FF3300","#FF6600","#FF9900","#FFCC00","#FFFF00","#FFFF80"],8:["#FF0000","#FF3300","#FF6600","#FF9900","#FFCC00","#FFFF00","#FFFF40","#FFFFBF"],9:["#FF0000","#FF2A00","#FF5500","#FF8000","#FFAA00","#FFD500","#FFFF00","#FFFF40","#FFFFBF"],10:["#FF0000","#FF2400","#FF4900","#FF6D00","#FF9200","#FFB600","#FFDB00","#FFFF00","#FFFF40","#FFFFBF"],11:["#FF0000","#FF2000","#FF4000","#FF6000","#FF8000","#FF9F00","#FFBF00","#FFDF00","#FFFF00","#FFFF40","#FFFFBF"],12:["#FF0000","#FF2000","#FF4000","#FF6000","#FF8000","#FF9F00","#FFBF00","#FFDF00","#FFFF00","#FFFF2A","#FFFF80","#FFFFD5"]}};CanvasXpress.ambiguityCodes={"-":["-"],A:["A"],C:["C"],G:["G"],T:["T"],M:["A","C"],R:["A","G"],W:["A","T"],S:["C","G"],Y:["C","T"],K:["G","T"],V:["A","C","G"],H:["A","C","T"],D:["A","G","T"],B:["C","G","T"],N:["A","C","G","T"],X:["A","C","G","T"]};CanvasXpress.codon={TTT:["F","Phe","Phenylalanine"],TCT:["S","Ser","Serine"],TAT:["Y","Tyr","Tyrosine"],TGT:["C","Cys","Cysteine"],TTC:["F","Phe","Phenylalanine"],TCC:["S","Ser","Serine"],TAC:["Y","Tyr","Tyrosine"],TGC:["C","Cys","Cysteine"],TTA:["L","Leu","Leucine"],TCA:["S","Ser","Serine"],TAA:["*","Stop","Ochre"],TGA:["*","Stop","Opal"],TTG:["L","Leu","Leucine"],TCG:["S","Ser","Serine"],TAG:["*","Stop","Amber"],TGG:["W","Trp","Tryptophan"],CTT:["L","Leu","Leucine"],CCT:["P","Pro","Proline"],CAT:["H","His","Histidine"],CGT:["R","Arg","Arginine"],CTC:["L","Leu","Leucine"],CCC:["P","Pro","Proline"],CAC:["H","His","Histidine"],CGC:["R","Arg","Arginine"],CTA:["L","Leu","Leucine"],CCA:["P","Pro","Proline"],CAA:["Q","Gln","Glutamine"],CGA:["R","Arg","Arginine"],CTG:["L","Leu","Leucine"],CCG:["P","Pro","Proline"],CAG:["Q","Gln","Glutamine"],CGG:["R","Arg","Arginine"],ATT:["I","Ile","Isoleucine"],ACT:["T","Thr","Threonine"],AAT:["N","Asn","Asparagine"],AGT:["S","Ser","Serine"],ATC:["I","Ile","Isoleucine"],ACC:["T","Thr","Threonine"],AAC:["N","Asn","Asparagine"],AGC:["S","Ser","Serine"],ATA:["I","Ile","Isoleucine"],ACA:["T","Thr","Threonine"],AAA:["K","Lys","Lysine"],AGA:["R","Arg","Arginine"],ATG:["M","Met","Methionine"],ACG:["T","Thr","Threonine"],AAG:["K","Lys","Lysine"],AGG:["R","Arg","Arginine"],GTT:["V","Val","Valine"],GCT:["A","Ala","Alanine"],GAT:["D","Asp","Aspartic acid"],GGT:["G","Gly","Glycine"],GTC:["V","Val","Valine"],GCC:["A","Ala","Alanine"],GAC:["D","Asp","Aspartic acid"],GGC:["G","Gly","Glycine"],GTA:["V","Val","Valine"],GCA:["A","Ala","Alanine"],GAA:["E","Glu","Glutamic acid"],GGA:["G","Gly","Glycine"],GTG:["V","Val","Valine"],GCG:["A","Ala","Alanine"],GAG:["E","Glu","Glutamic acid"],GGG:["G","Gly","Glycine"]};CanvasXpress.reverseComplement={A:"T",C:"G",G:"C",T:"A",U:"A",Y:"R",R:"Y",W:"W",S:"S",K:"M",M:"K",B:"V",V:"B",D:"H",H:"D",X:"X",N:"N",a:"t",c:"g",g:"c",t:"a",u:"a",y:"r",r:"y",w:"w",s:"s",k:"m",m:"k",b:"v",v:"b",d:"h",h:"d",x:"x",n:"n"," ":" ","-":"-","/":"/","[":"[","]":"]"};CanvasXpress.themes={economist:{backgroundType:"solid",backgroundWindow:"#D5E4EB",background:"#D5E4EB",colorScheme:"Economist",legendColor:"#000000",legendBox:false,legendBoxColor:"#000000",legendBackgroundColor:"#D5E4EB",legendColumns:4,legendInside:true,legendPosition:"top",legendScaleFontFactor:1,axisTickScaleFontFactor:1,axisTitleScaleFontFactor:1,axisTickColor:"#000000",axisTitleColor:"#000000",axisTickThickness:2,axisMinMaxTickThickness:1,xAxisMinorTicks:false,xAxisMajorTicks:false,xAxisTickColor:"#000000",xAxisLeftMajorTick:false,xAxisRightMajorTick:false,xAxisTickStyle:"line",xAxisLeftRightTickColor:"#000000",yAxisMajorTicks:true,yAxisMinorTicks:false,yAxisShow:false,yAxis2Show:true,yAxisTickStyle:"line",yAxisTickColor:"#FFFFFF",yAxisTopMajorTick:false,yAxisBottomMajorTick:true,yAxisTopBottomTickColor:"#000000",titleAlign:"left",titleColor:"#000000",subtitleAlign:"left",subtitleColor:"#000000",conditional:{OneDPlots:{xAxisMajorTicks:true}}},excel:{backgroundType:"window",backgroundWindow:"#C0C0C0",background:"#FFFFFF",colorScheme:"Excel",legendColor:"#000000",legendBox:true,legendBoxColor:"#000000",legendBackgroundColor:"#FFFFFF",legendColumns:1,legendInside:false,legendPosition:"right",legendScaleFontFactor:1,axisTickScaleFontFactor:1,axisTitleScaleFontFactor:1,axisTickColor:"#000000",axisTitleColor:"#000000",axisTickThickness:1,axisMinMaxTickThickness:1,xAxisMinorTicks:false,xAxisMajorTicks:false,xAxisTickColor:"#000000",xAxisLeftMajorTick:true,xAxisRightMajorTick:true,xAxisTickStyle:"line",xAxisLeftRightTickColor:"#000000",yAxisMajorTicks:true,yAxisMinorTicks:false,yAxisShow:true,yAxis2Show:false,yAxisTickStyle:"line",yAxisTickColor:"#000000",yAxisTopMajorTick:true,yAxisBottomMajorTick:true,yAxisTopBottomTickColor:"#000000",titleAlign:"left",titleColor:"#000000",subtitleAlign:"left",subtitleColor:"#000000",conditional:{OneDPlots:{xAxisMajorTicks:true}}},tableau:{backgroundType:"window",backgroundWindow:"#FFFFFF",background:"#E5E5E5",colorScheme:"TableauMedium",legendColor:"#000000",legendBox:true,legendBoxColor:"#E5E5E5",legendBackgroundColor:"#FFFFFF",legendColumns:1,legendInside:false,legendPosition:"right",legendScaleFontFactor:1,axisTickScaleFontFactor:1,axisTitleScaleFontFactor:1,axisTickColor:"#000000",axisTitleColor:"#000000",axisTickThickness:1,axisMinMaxTickThickness:1,xAxisMinorTicks:false,xAxisMajorTicks:true,xAxisTickStyle:"line",xAxisTickColor:"#E5E5E5",xAxisLeftMajorTick:true,xAxisRightMajorTick:true,xAxisLeftRightTickColor:"#E5E5E5",yAxisMajorTicks:true,yAxisMinorTicks:false,yAxisShow:true,yAxis2Show:false,yAxisTickStyle:"line",yAxisTickColor:"#E5E5E5",yAxisTopMajorTick:true,yAxisBottomMajorTick:true,yAxisTopBottomTickColor:"#E5E5E5",titleAlign:"left",titleColor:"#000000",subtitleAlign:"left",subtitleColor:"#000000"},stata:{backgroundType:"window",backgroundWindow:"#FFFFFF",background:"#EAF2F3",colorScheme:"Stata",legendColor:"#000000",legendBox:true,legendBoxColor:"#000000",legendBackgroundColor:"#FFFFFF",legendColumns:4,legendInside:false,legendPosition:"bottom",legendScaleFontFactor:1,axisTickScaleFontFactor:1,axisTitleScaleFontFactor:1,axisTickColor:"#000000",axisTitleColor:"#000000",axisTickThickness:1,axisMinMaxTickThickness:2,xAxisMinorTicks:false,xAxisMajorTicks:false,xAxisTickStyle:"line",xAxisTickColor:"#000000",xAxisLeftMajorTick:true,xAxisRightMajorTick:false,xAxisLeftRightTickColor:"#000000",yAxisMajorTicks:true,yAxisMinorTicks:false,yAxisShow:true,yAxis2Show:false,yAxisTickStyle:"line",yAxisTickColor:"#EAF2F3",yAxisTopMajorTick:false,yAxisBottomMajorTick:true,yAxisTopBottomTickColor:"#000000",titleAlign:"center",titleColor:"#000000",subtitleAlign:"center",subtitleColor:"#000000",conditional:{OneDPlots:{xAxisMajorTicks:true}}},igray:{backgroundType:"window",backgroundWindow:"#FFFFFF",background:"#E5E5E5",colorScheme:"GGPlot",legendColor:"#000000",legendBox:false,legendBoxColor:"#000000",legendBackgroundColor:"#FFFFFF",legendColumns:1,legendInside:false,legendPosition:"right",legendScaleFontFactor:1,axisTickScaleFontFactor:1,axisTitleScaleFontFactor:1,axisTickColor:"#000000",axisTitleColor:"#000000",axisTickThickness:1,axisMinMaxTickThickness:1,xAxisMinorTicks:false,xAxisMajorTicks:true,xAxisTickStyle:"line",xAxisTickColor:"#E5E5E5",xAxisLeftMajorTick:false,xAxisRightMajorTick:false,xAxisLeftRightTickColor:"#000000",yAxisMajorTicks:true,yAxisMinorTicks:false,yAxisShow:true,yAxis2Show:false,yAxisTickStyle:"line",yAxisTickColor:"#E5E5E5",yAxisTopMajorTick:false,yAxisBottomMajorTick:false,yAxisTopBottomTickColor:"#000000",titleAlign:"center",titleColor:"#000000",subtitleAlign:"center",subtitleColor:"#000000"},solarized:{backgroundType:"solid",backgroundWindow:"#FDF6E3",background:"#FDF6E3",colorScheme:"Solarized",legendColor:"#93A1A1",legendBox:true,legendBoxColor:"#93A1A1",legendBackgroundColor:"#FFFFFF",legendColumns:1,legendInside:false,legendPosition:"right",legendScaleFontFactor:1,axisTickScaleFontFactor:1,axisTitleScaleFontFactor:1,axisTickColor:"#93A1A1",axisTitleColor:"#93A1A1",axisTickThickness:1,axisMinMaxTickThickness:2,xAxisMinorTicks:false,xAxisMajorTicks:true,xAxisTickStyle:"line",xAxisTickColor:"#93A1A1",xAxisLeftMajorTick:true,xAxisRightMajorTick:false,xAxisLeftRightTickColor:"#93A1A1",yAxisMajorTicks:true,yAxisMinorTicks:false,yAxisShow:true,yAxis2Show:false,yAxisTickStyle:"line",yAxisTickColor:"#93A1A1",yAxisTopMajorTick:false,yAxisBottomMajorTick:true,yAxisTopBottomTickColor:"#93A1A1",titleAlign:"left",titleColor:"#93A1A1",subtitleAlign:"left",subtitleColor:"#93A1A1"},paulTol:{backgroundType:"solid",backgroundWindow:"#FFFFFF",background:"#FFFFFF",colorScheme:"PaulTol",legendColor:"#000000",legendBox:false,legendBoxColor:"#000000",legendBackgroundColor:"#FFFFFF",legendColumns:1,legendInside:false,legendPosition:"right",legendScaleFontFactor:1,axisTickScaleFontFactor:1,axisTitleScaleFontFactor:1,axisTickColor:"#000000",axisTitleColor:"#000000",axisTickThickness:1,axisMinMaxTickThickness:1,xAxisMinorTicks:false,xAxisMajorTicks:true,xAxisTickStyle:"line",xAxisTickColor:"#E5E5E5",xAxisLeftMajorTick:false,xAxisRightMajorTick:false,xAxisLeftRightTickColor:"#E5E5E5",yAxisMajorTicks:true,yAxisMinorTicks:false,yAxisShow:true,yAxis2Show:false,yAxisTickStyle:"line",yAxisTickColor:"#E5E5E5",yAxisTopMajorTick:false,yAxisBottomMajorTick:false,yAxisTopBottomTickColor:"#E5E5E5",titleAlign:"left",titleColor:"#000000",subtitleAlign:"left",subtitleColor:"#000000"},ggplot:{backgroundType:"window",backgroundWindow:"#E5E5E5",background:"#FFFFFF",colorScheme:"GGPlot",legendColor:"#000000",legendBox:true,legendBoxColor:"#FFFFFF",legendBackgroundColor:"#E5E5E5",legendColumns:1,legendInside:false,legendPosition:"right",legendScaleFontFactor:1,axisTickScaleFontFactor:1,axisTitleScaleFontFactor:1,axisTickColor:"#000000",axisTitleColor:"#000000",axisTickThickness:1,axisMinMaxTickThickness:1,xAxisMinorTicks:false,xAxisMajorTicks:true,xAxisTickStyle:"line",xAxisTickColor:"#FFFFFF",xAxisLeftMajorTick:true,xAxisRightMajorTick:false,xAxisLeftRightTickColor:"#FFFFFF",yAxisMajorTicks:true,yAxisMinorTicks:false,yAxisShow:true,yAxis2Show:false,yAxisTickStyle:"line",yAxisTickColor:"#FFFFFF",yAxisTopMajorTick:false,yAxisBottomMajorTick:true,yAxisTopBottomTickColor:"#FFFFFF",titleAlign:"center",titleColor:"#000000",subtitleAlign:"center",subtitleColor:"#000000"},wallStreetJournal:{backgroundType:"solid",backgroundWindow:"#F8F2E4",background:"#F8F2E4",colorScheme:"WallStreetJournal3",legendColor:"#000000",legendBox:false,legendBoxColor:"#000000",legendBackgroundColor:"#F8F2E4",legendColumns:4,legendInside:true,legendPosition:"top",legendScaleFontFactor:1,axisTickScaleFontFactor:1,axisTitleScaleFontFactor:1,axisTickColor:"#000000",axisTitleColor:"#000000",axisTickThickness:2,axisMinMaxTickThickness:1,xAxisMinorTicks:false,xAxisMajorTicks:false,xAxisTickStyle:"dotted",xAxisTickColor:"#000000",xAxisLeftMajorTick:false,xAxisRightMajorTick:false,xAxisLeftRightTickColor:"#000000",yAxisMajorTicks:true,yAxisMinorTicks:false,yAxisShow:true,yAxis2Show:false,yAxisTickStyle:"dotted",yAxisTickColor:"#000000",yAxisTopMajorTick:false,yAxisBottomMajorTick:true,yAxisTopBottomTickColor:"#000000",titleAlign:"left",titleColor:"#000000",subtitleAlign:"left",subtitleColor:"#000000",conditional:{OneDPlots:{xAxisMajorTicks:true}}},cx:{backgroundType:"window",backgroundWindow:"#E8E8E8",background:"#FFFFFF",colorScheme:"CanvasXpressT",legendColor:"#000000",legendBox:true,legendBoxColor:"#FFFFFF",legendBackgroundColor:"#E8E8E8",legendColumns:1,legendInside:false,legendPosition:"right",legendScaleFontFactor:1,axisTickScaleFontFactor:1,axisTitleScaleFontFactor:1,axisTickColor:"#000000",axisTitleColor:"#000000",axisTickThickness:1,axisMinMaxTickThickness:1,xAxisMinorTicks:false,xAxisMajorTicks:true,xAxisTickStyle:"line",xAxisTickColor:"#FFFFFF",xAxisLeftMajorTick:true,xAxisRightMajorTick:true,xAxisLeftRightTickColor:"#337AB7",yAxisMajorTicks:true,yAxisMinorTicks:false,yAxisShow:true,yAxis2Show:false,yAxisTickStyle:"line",yAxisTickColor:"#FFFFFF",yAxisTopMajorTick:true,yAxisBottomMajorTick:true,yAxisTopBottomTickColor:"#337AB7",titleAlign:"center",titleColor:"#000000",subtitleAlign:"center",subtitleColor:"#000000"},none:{backgroundType:"solid",backgroundWindow:"rgb(244,244,244)",background:"rgb(255,255,255)",colorScheme:"User",colors:CanvasXpress.colorSchemes.Default[20],legendColor:"rgb(0,0,0)",legendBox:true,legendBoxColor:"rgb(204,204,204)",legendBackgroundColor:"rgb(255,255,255)",legendColumns:1,legendInside:false,legendPosition:"right",legendScaleFontFactor:1,axisTickScaleFontFactor:1,axisTitleScaleFontFactor:1,axisTickColor:"rgb(0,0,0)",axisTitleColor:"rgb(0,0,0)",axisTickThickness:1,axisMinMaxTickThickness:1,xAxisMinorTicks:true,xAxisMajorTicks:true,xAxisTickStyle:"line",xAxisTickColor:"rgb(204,204,204)",xAxisLeftMajorTick:true,xAxisRightMajorTick:true,xAxisLeftRightTickColor:"rgb(204,204,204)",yAxisMajorTicks:true,yAxisMinorTicks:true,yAxisShow:true,yAxis2Show:false,yAxisTickStyle:"line",yAxisTickColor:"rgb(204,204,204)",yAxisTopMajorTick:false,yAxisBottomMajorTick:true,yAxisTopBottomTickColor:"rgb(204,204,204)",titleAlign:"center",titleColor:"rgb(0,0,0)",subtitleAlign:"center",subtitleColor:"rgb(0,0,0)"}};CanvasXpress.R={lty:[[0,0],[],[8,6],[1,3],[1,3,5,3],[14,6],[4,3,8,3]],ltyNames:["blank","solid","dashed","dotted","dotdash","longdash","twodash"]};CanvasXpress.prototype.initDOM=function(){this.$=function(id){return document.getElementById(id)};this.$cX=function(t,p,s){var e=document.createElement(t);if(p){for(var i in p){e[i]=p[i]}}if(s){for(var i in s){e.style[i]=s[i]}}return e};this.setPixelImage=function(){this.beaconImage=this.$cX("img",{id:this.target+"-cX-Beacon-Image",src:navigator.onLine&&this.protocol!="file"&&!this.offline?"https://canvasxpress.org/cgi-bin/services.pl?beacon="+CanvasXpress.factory.client:CanvasXpress.images.canvasXpress})};this.createNewTarget=function(){var c=this.$cX("canvas",{id:this.newId("canvasXpress")});document.body.appendChild(c);return c.id};this.newId=function(t){var n=0;var i=this.target+t+n;while(this.meta.ids[i]){n++;i=this.target+t+n}this.meta.ids[i]=true;return i};this.insertTarget=function(t,p,w,h,a){if(t&&p){var c=this.$(t);if(c){return}else{c=this.$cX("canvas",{id:t,width:w,height:h});this.castCanvasAttributes(c)}if(a){p.parentNode.insertBefore(c,p.nextSibling)}else{p.parentNode.insertBefore(c,p)}}};this.castCanvasAttributes=function(c,e){var prs=["data-responsive","data-aspectRatio","data-resizable","data-maxWidth","data-maxHeight"];if(!e){e=this.meta.canvas.ctx.canvas}for(var i=0;i<prs.length;i++){if(e.hasAttribute(prs[i])){c.setAttribute(prs[i],e.getAttribute(prs[i]))}}};this.removeTarget=function(t){var n=this.$(t);if(n){n.parentNode.removeChild(n)}};this.getWindowSize=function(){var w=window.innerWidth||document.documentElement.clientWidth||document.body.clientWidth;var h=window.innerHeight||document.documentElement.clientHeight||document.body.clientHeight;return[w,h]};this.getWindowScroll=function(){var d=document.documentElement;var l=(window.pageXOffset||d.scrollLeft)-(d.clientLeft||0);var t=(window.pageYOffset||d.scrollTop)-(d.clientTop||0);return[l,t]};this.hasClass=function(e,n){return new RegExp("(\\s|^)"+n+"(\\s|$)").test(e.className)};this.addClass=function(e,n){if(!this.hasClass(e,n)){e.className+=(e.className?" ":"")+n}};this.removeClass=function(e,n){if(this.hasClass(e,n)){e.className=e.className.replace(new RegExp("(\\s|^)"+n+"(\\s|$)")," ").replace(/^\s+|\s+$/g,"")}};this.getComputedCSS=function(e){var s="";var o=getComputedStyle(e);for(var i=0;i<o.length;i++){s+=o[i]+":"+o.getPropertyValue(o[i])+";"}return s};this.cancelEvent=function(e){if(!e){e=window.event}if(!e){return}if(CanvasXpress.system.browser.match(/safari/i)){return false}else{if(e.preventDefault){e.preventDefault()}else{e.returnValue=false}}};this.stopEvent=function(e){if(!e){e=window.event}if(!e){return}if(e.stopPropagation){e.stopPropagation()}else{e.cancelBubble=true}};this.normalizeEvtName=function(e){return CanvasXpress.system.isIE?"on"+e:e};this.copyEvent=function(e){var ce={};for(var i in e){ce[i]=e[i]}return ce};this.addEvtListener=function(o,e,c,f){if(o&&e&&c){var m=this.meta.events;if(o.id){if(!m[o.id]){m[o.id]={}}m[o.id][e]=[c,f]}else{if(!m[o]){m[o]={}}m[o][e]=[c,f]}if(CanvasXpress.system.isIE){o.attachEvent(this.normalizeEvtName(e),c)}else{if(e=="touchstart"){o.addEventListener(e,c,f)}else{if(e=="mousewheel"){o.addEventListener(e,c,f);o.addEventListener("DOMMouseScroll",c,f)}else{o.addEventListener(e,c,f)}}}}};this.removeEvtListener=function(o,e,c,f){if(o&&e&&c){var m=this.meta.events;var k=m[o.id||o];if(k&&k.hasOwnProperty(e)){delete (k[e]);if(CanvasXpress.system.isIE){o.detachEvent(this.normalizeEvtName(e),c)}else{o.removeEventListener(e,c,f);if(e=="mousewheel"){o.removeEventListener("DOMMouseScroll",c,f)}}var v=this.getKeys(m[o.id||o]);if(v&&v.length<1){delete (m[o.id||o])}}}};this.addRemoveEvtListener=function(t,o,e,c,f){if(t&&o&&e&&c){this[t](o,e,c,f)}};this.purgeEventListeners=function(){var m=this.meta.events;for(var i in m){var o=this.$(i)||i;for(var e in m[i]){this.removeEvtListener(o,e,m[i][0],m[i][1])}}};this.preventSelection=function(){if(document.selection){document.selection.empty()}else{if(window.getSelection){window.getSelection().removeAllRanges()}}};this.getTargetEvent=function(e){var obj=e.target||e.srcElement;if(typeof(obj)!="object"){obj=this.$(obj)}return obj};this.setTimeout=function(callback,time){if(this.isR){setTimeout(callback,time)}else{var that=this;var wait=function(t){return new Promise(function(resolve,reject){if(t){setTimeout(resolve,t)}else{setTimeout(resolve,1000)}})};wait(time).then(function(){callback.apply(that)})}};this.setInterval=function(c,d){return setInterval(c,d)};if(typeof JSON.decycle!=="function"){JSON.decycle=function decycle(object,replacer){var objects=new WeakMap();return(function derez(value,path){var old_path;var nu;if(replacer!==undefined){value=replacer(value)}if(typeof value==="object"&&value!==null&&!(value instanceof Boolean)&&!(value instanceof Date)&&!(value instanceof Number)&&!(value instanceof RegExp)&&!(value instanceof String)){old_path=objects.get(value);if(old_path!==undefined){return{$ref:old_path}}objects.set(value,path);if(Array.isArray(value)){nu=[];value.forEach(function(element,i){nu[i]=derez(element,path+"["+i+"]")})}else{nu={};Object.keys(value).forEach(function(name){nu[name]=derez(value[name],path+"["+JSON.stringify(name)+"]")})}return nu}return value}(object,"$"))}}if(typeof JSON.retrocycle!=="function"){JSON.retrocycle=function retrocycle($){var px=/^\$(?:\[(?:\d+|"(?:[^\\"\u0000-\u001f]|\\([\\"\/bfnrt]|u[0-9a-zA-Z]{4}))*")\])*$/;(function rez(value){if(value&&typeof value==="object"){if(Array.isArray(value)){value.forEach(function(element,i){if(typeof element==="object"&&element!==null){var path=element.$ref;if(typeof path==="string"&&px.test(path)){value[i]=eval(path)}else{rez(element)}}})}else{Object.keys(value).forEach(function(name){var item=value[name];if(typeof item==="object"&&item!==null){var path=item.$ref;if(typeof path==="string"&&px.test(path)){value[name]=eval(path)}else{rez(item)}}})}}}($));return $}}if(!Array.from){Array.from=(function(){var toStr=Object.prototype.toString;var isCallable=function(fn){return typeof fn==="function"||toStr.call(fn)==="[object Function]"};var toInteger=function(value){var number=Number(value);if(isNaN(number)){return 0}if(number===0||!isFinite(number)){return number}return(number>0?1:-1)*Math.floor(Math.abs(number))};var maxSafeInteger=Math.pow(2,53)-1;var toLength=function(value){var len=toInteger(value);return Math.min(Math.max(len,0),maxSafeInteger)};return function from(arrayLike){var C=this;var items=Object(arrayLike);if(arrayLike==null){throw new TypeError("Array.from requires an array-like object - not null or undefined")}var mapFn=arguments.length>1?arguments[1]:void undefined;var T;if(typeof mapFn!=="undefined"){if(!isCallable(mapFn)){throw new TypeError("Array.from: when provided, the second argument must be a function")}if(arguments.length>2){T=arguments[2]}}var len=toLength(items.length);var A=isCallable(C)?Object(new C(len)):new Array(len);var k=0;var kValue;while(k<len){kValue=items[k];if(mapFn){A[k]=typeof T==="undefined"?mapFn(kValue,k):mapFn.call(T,kValue,k)}else{A[k]=kValue}k+=1}A.length=len;return A}}())}if(!Array.prototype.fill){Object.defineProperty(Array.prototype,"fill",{value:function(value){if(this==null){throw new TypeError("this is null or not defined")}var O=Object(this);var len=O.length>>>0;var start=arguments[1];var relativeStart=start>>0;var k=relativeStart<0?Math.max(len+relativeStart,0):Math.min(relativeStart,len);var end=arguments[2];var relativeEnd=end===undefined?len:end>>0;var finl=relativeEnd<0?Math.max(len+relativeEnd,0):Math.min(relativeEnd,len);while(k<finl){O[k]=value;k++}return O}})}if(typeof Object.assign!="function"){Object.defineProperty(Object,"assign",{value:function assign(target,varArgs){if(target==null){throw new TypeError("Cannot convert undefined or null to object")}var to=Object(target);for(var index=1;index<arguments.length;index++){var nextSource=arguments[index];if(nextSource!=null){for(var nextKey in nextSource){if(Object.prototype.hasOwnProperty.call(nextSource,nextKey)){to[nextKey]=nextSource[nextKey]}}}}return to},writable:true,configurable:true})}if(!Array.prototype.map){Array.prototype.map=function(callback){var T,A,k;if(this==null){throw new TypeError("this is null or not defined")}var O=Object(this);var len=O.length>>>0;if(typeof callback!=="function"){throw new TypeError(callback+" is not a function")}if(arguments.length>1){T=arguments[1]}A=new Array(len);k=0;while(k<len){var kValue,mappedValue;if(k in O){kValue=O[k];mappedValue=callback.call(T,kValue,k,O);A[k]=mappedValue}k++}return A}}if(!Array.prototype.findIndex){Object.defineProperty(Array.prototype,"findIndex",{value:function(predicate){if(this==null){throw new TypeError('"this" is null or not defined')}var o=Object(this);var len=o.length>>>0;if(typeof predicate!=="function"){throw new TypeError("predicate must be a function")}var thisArg=arguments[1];var k=0;while(k<len){var kValue=o[k];if(predicate.call(thisArg,kValue,k,o)){return k}k++}return -1}})}this.domToPng=function(origElem,callback){var supportsCSSText=window.getComputedStyle(document.body).cssText!=="";var clonePseudoElement=function(elem,origElem,pseudo){var formatPseudoElementStyle=function(className,pseudo,style){var formatCssText=function(style){var content=style.getPropertyValue("content");return style.cssText+" content: "+content+";"};var formatCssProperties=function(style){var asArray=function(arrayLike){var array=[];for(var i=0;i<arrayLike.length;i++){array.push(arrayLike[i])}return array};var formatProperty=function(name){return name+": "+style.getPropertyValue(name)+(style.getPropertyPriority(name)?" !important":"")};return asArray(style).map(formatProperty).join("; ")+";"};var selector="."+className+":"+pseudo;var cssText=style.cssText?formatCssText(style):formatCssProperties(style);return document.createTextNode(selector+"{"+cssText+"}")};var style=window.getComputedStyle(origElem,pseudo);var content=style.getPropertyValue("content");if(content===""||content==="none"){return}var className=elem.className+"-clone";elem.className=elem.className+" "+className;var styleElement=document.createElement("style");styleElement.appendChild(formatPseudoElementStyle(className,pseudo,style));elem.appendChild(styleElement)};var copyCSS=function(elem,origElem){var computedStyle=window.getComputedStyle(origElem);if(supportsCSSText){elem.style.cssText=computedStyle.cssText}else{for(var prop in computedStyle){if(isNaN(parseInt(prop,10))&&typeof computedStyle[prop]!=="function"&&!(/^(cssText|length|parentRule)$/).test(prop)){elem.style[prop]=computedStyle[prop]}}}[":before",":after"].forEach(function(pseudo){clonePseudoElement(elem,origElem,pseudo)})};var inlineStyles=function(elem,origElem){var children=elem.querySelectorAll("*");var origChildren=origElem.querySelectorAll("*");copyCSS(elem,origElem);Array.prototype.forEach.call(children,function(child,i){copyCSS(child,origChildren[i]);if(child instanceof HTMLImageElement){if(child.style.width=="0px"){child.style.width="24px"}if(child.style.height=="0px"){child.style.height="24px"}}});elem.style.margin=elem.style.marginLeft=elem.style.marginTop=elem.style.marginBottom=elem.style.marginRight=""};var cloneNode=function(node){var makeCopy=function(node){return node.cloneNode(false)};var cloneChildren=function(original,clone){var children=original.childNodes;if(children.length===0){return clone}else{return cloneChildrenInOrder(clone,children)}};var cloneChildrenInOrder=function(parent,children){var n=children.length;for(var i=0;i<n;i++){parent.appendChild(cloneNode(children[i]))}};var clone=makeCopy(node);cloneChildren(node,clone);return clone};var width=origElem.clientWidth;var height=origElem.clientHeight;var elem=cloneNode(origElem);inlineStyles(elem,origElem);elem.style.opacity=1;elem.style.left=0;elem.style.top=0;elem.setAttribute("xmlns","http://www.w3.org/1999/xhtml");var serialized=new XMLSerializer().serializeToString(elem);var svg='<svg xmlns="http://www.w3.org/2000/svg" width="'+width+'" height="'+height+'"><foreignObject width="100%" height="100%" x="0" y="0">'+serialized+"</foreignObject></svg>";var dataUri="data:image/svg+xml;charset=utf-8,"+svg;var img=new Image();img.onload=function(){var canvas=document.createElement("canvas");canvas.width=width;canvas.height=height;canvas.getContext("2d").drawImage(img,0,0);if(callback){callback.call(img,canvas.toDataURL())}};img.onerror=function(evt){console.log("Ooops! Something went wrong!");callback.call(this,img.src)};img.src=dataUri};this.isInIframe=function(){try{return window.self!==window.top}catch(e){return true}};this.initializeBrowser=function(){var getBrowserVersion=function(){var ua=navigator.userAgent;var tem;var m=ua.match(/(opera|chrome|safari|firefox|msie|trident(?=\/))\/?\s*(\d+)/i)||[];if(/trident/i.test(m[1])){tem=/\brv[ :]+(\d+)/g.exec(ua)||[];return"IE "+(tem[1]||"")}if(m[1]==="Chrome"){tem=ua.match(/\b(OPR|Edge)\/(\d+)/);if(tem!=null){return tem.slice(1).join(" ").replace("OPR","Opera")}}m=m[2]?[m[1],m[2]]:[navigator.appName,navigator.appVersion,"-?"];if((tem=ua.match(/version\/(\d+)/i))!=null){m.splice(1,1,tem[1])}return m.join(" ")};var str=getBrowserVersion().split(" ");CanvasXpress.system={browser:str[0],browserVersion:str[1],isjQuery:typeof $==="function",isReveal:typeof Reveal!="undefined",isZoom:typeof zoom!="undefined",isIE:this.browser=="IE"?true:false,isInIframe:str[0].match(/safari/i)?true:this.isInIframe(),isTouchScreen:"ontouchstart" in window||"onmsgesturechange" in window||navigator.maxTouchPoints}};this.setFunctionNames("initDOM");this.initializeBrowser()};CanvasXpress.prototype.initInterface=function(){this.parseJSON=function(s,r){if(this.isR){return JSON.parse(s,r||null)}else{if(r){return JSON.parse(s,r)}else{return JSON.parse(s,function(k,v){if(typeof v==="string"&&v.startsWith("/Function(")&&v.endsWith(")/")){v=v.substring(10,v.length-2);return eval("("+v+")")}else{return v}})}}};this.stringifyJSON=function(js,r,s){if(this.isR){return JSON.stringify(js,r||null,s||null)}else{if(r){return JSON.stringify(js,r,s||null)}else{return JSON.stringify(js,function(k,v){if(typeof v==="function"){return"/Function("+v.toString()+")/"}else{if(k=="state"||k=="stateIndex"){return undefined}else{return v}}},s||null)}}};this.isValidURL=function(str){var pattern=new RegExp("^(https?:\\/\\/)?((([a-z\\d]([a-z\\d-]*[a-z\\d])*)\\.?)+[a-z]{2,}|((\\d{1,3}\\.){3}\\d{1,3}))(\\:\\d+)?(\\/[-a-z\\d%_.~+]*)*(\\?[;,\\s\\(\\)\\[\\]&a-z\\d%_.~+=-]*)?(\\#[-a-z\\d_]*)?$","i");return pattern.test(str)};this.loadParamsFile=function(t){return function(e){t.removeMenus();t.resetConfigurator(e);var file=e.target.files[0];var type=file.type;var part=file.name.split(".");var reader=new FileReader();var ext=part.pop();if(ext=="json"){reader.onload=function(){try{var data=t.parseJSON(reader.result);t.setConfigDefaults();t.layoutValid=false;for(var p in data.config){t[p]=data.config[p]}if(data.afterRender){for(var i=0;i<data.afterRender.length;i++){var ar=data.afterRender[i];var fn=ar[0];var pr=ar[1]||[];t[fn].apply(t,pr)}}else{t.draw()}}catch(e){alert("Oooops! Not a valid CanvasXpress json parameter file")}};reader.readAsText(file)}else{alert("Oooops! Not a valid CanvasXpress json parameter file")}}}(this);this.parseDataFromPNG=function(p){var istEXt=function(dv,idx){var c="";for(var i=0;i<4;i++){c+=String.fromCharCode(dv.getUint8(idx+i))}return c=="tEXt"};var isCanvasXpress=function(dv,idx,len){var c="";for(var i=0;i<len;i++){c+=String.fromCharCode(dv.getUint8(idx+i))}return c.match(/CanvasXpress/)};var debug=function(dv,idx,len){var c="";for(var i=0;i<len;i++){console.log(idx+i+" = "+dv.getUint8(idx+i)+":"+String.fromCharCode(dv.getUint8(idx+i)))}return c};var dv=new DataView(p);var ihdr=dv.getUint32(8);var soft=dv.getUint32(8+4+4+ihdr+4);if(istEXt(dv,8+4+4+ihdr+4+4)&&isCanvasXpress(dv,8+4+4+ihdr+4+4+4,soft)){var rprs=dv.getUint32(8+4+4+ihdr+4+4+4+soft+4);var indx=8+4+4+ihdr+4+4+4+soft+4+4+4;var res="";for(var i=0;i<rprs;i++){res+=String.fromCharCode(dv.getUint8(indx+i))}res=res.replace("ReproducibleResearch\0","");return this.parseJSON(res)}else{alert("Oooops! Not a valid CanvasXpress Image")}};this.loadFile=function(t){return function(e,jr,callback,f){t.removeMenus();t.resetConfigurator(e);t.showMask();var file=f?f:e.target?e.target.files[0]:e.files[0];var type=file.type;var part=file.name.split(".");var reader=new FileReader();if(type=="image/png"){var istEXt=function(dv,idx){var c="";for(var i=0;i<4;i++){c+=String.fromCharCode(dv.getUint8(idx+i))}return c=="tEXt"};var isCanvasXpress=function(dv,idx,len){var c="";for(var i=0;i<len;i++){c+=String.fromCharCode(dv.getUint8(idx+i))}return c.match(/CanvasXpress/)};reader.onload=function(){var dv=new DataView(this.result);var ihdr=dv.getUint32(8);var soft=dv.getUint32(8+4+4+ihdr+4);if(istEXt(dv,8+4+4+ihdr+4+4)&&isCanvasXpress(dv,8+4+4+ihdr+4+4+4,soft)){var rprs=dv.getUint32(8+4+4+ihdr+4+4+4+soft+4);var indx=8+4+4+ihdr+4+4+4+soft+4+4+4;var res="";for(var i=0;i<rprs;i++){res+=String.fromCharCode(dv.getUint8(indx+i))}res=res.replace("ReproducibleResearch\0","");var data=t.parseJSON(res);if(jr){return data}data.uploadFile=true;t.remoteServiceType="file";t.updateRemoteData(data,callback);t.hideMask()}else{t.hideMask();alert("Oooops! Not a valid CanvasXpress Image")}};reader.readAsArrayBuffer(file)}else{var ext=part.pop();if(ext=="json"){reader.onload=function(){try{var data=t.parseJSON(reader.result);if(data.data){data.uploadFile=true;t.remoteServiceType="file";t.updateRemoteData(data,callback);t.hideMask()}else{if(data.config){t.setConfigDefaults();t.layoutValid=false;for(var p in data.config){t[p]=data.config[p]}if(data.afterRender){for(var i=0;i<data.afterRender.length;i++){var ar=data.afterRender[i];var fn=ar[0];var pr=ar[1]||[];t[fn].apply(t,pr)}}else{t.draw()}}else{var foo=data.error.error}}}catch(e){t.hideMask();alert("Oooops! Not a valid CanvasXpress json file")}}}else{if(ext=="svg"){reader.onload=function(){try{var data=t.SVGtoCX(reader.result);data.uploadFile=true;t.remoteServiceType="file";t.updateRemoteData(data,callback);t.hideMask()}catch(e){t.hideMask();alert("Oooops! Not a valid CanvasXpress json file")}}}else{if(ext=="txt"||ext=="csv"||ext=="tsv"||ext=="tab"){reader.onload=function(){try{var str=reader.result;var tc=0;var tt=0;if(str.match(/,/g)){tc=str.match(/,/g).length}if(str.match(/\t/g)){tt=str.match(/\t/g).length}var dl=ext=="csv"&&tc>tt?",":"\t";var data;if(t.graphType=="Network"){data=t.delimitedToArray(str,dl,false,true);if(data&&!t.isArray(data)){var fail="";if(data.fail>0){fail=data.fail+" records couldn't be mapped to network data"}alert(data.rows+" "+data.type+" records added to network data\n"+fail);if(data.type=="node"){t.appendNodeData(data.data)}else{t.appendEdgeData(data.data)}t.hideMask();return}else{data=t.arrayToCanvasXpress(data)}}else{data=t.delimitedToArray(str,dl,true)}data.renderTo=part[0];data.uploadFile=true;t.remoteServiceType="file";t.updateRemoteData(data,callback);t.hideMask()}catch(e){t.hideMask();alert("Oooops! Not a valid CanvasXpress delimited file")}}}else{if(ext=="gml"){reader.onload=function(){try{var data=t.parseGML(reader.result);data.renderTo=part[0];data.uploadFile=true;t.remoteServiceType="file";t.updateRemoteData(data,callback);t.hideMask()}catch(e){t.hideMask();alert("Oooops! Not a valid gml file for CanvasXpress")}}}else{if(ext.match(/ml$/)){reader.onload=function(){try{var xml=t.parseXML(reader.result);t.remoteServiceType="file";var ts1=xml.childNodes[0];var ts2=xml.childNodes[2];if(ts1.tagName&&ts1.tagName.toLowerCase()=="map"){t.metabaseToCX(xml,part[0])}else{if(ts1.tagName&&ts1.tagName.toLowerCase()=="graph"){t.cytoscapeToCX(xml,part[0])}else{if(ts1.tagName&&ts1.tagName.toLowerCase()=="pathway"){t.wikipathwayToCX(xml,part[0])}else{if(ts2&&ts2.tagName&&ts2.tagName.toLowerCase()=="pathway"){t.keggToCX(xml,part[0])}}}}}catch(e){t.hideMask();alert("Oooops! Not a valid "+ext+" file for CanvasXpress")}}}}}}}reader.readAsText(file)}}}(this);this.save=function(t){return function(e,f,p){t.removeMenus();t.resetConfigurator(e);var flnm=f?f+".json":t.saveFilename?t.saveFilename+".json":"cX-"+t.target+".json";flnm=flnm.replace(/.json.json$/,".json");CanvasXpress.stack[t.target].client=CanvasXpress.factory.client;CanvasXpress.stack[t.target].clientIP=CanvasXpress.geo;var obj;if(p){obj=t.prettyJSON({config:CanvasXpress.stack[t.target].config,afterRender:CanvasXpress.stack[t.target].afterRender||[]})}else{obj=t.prettyJSON(CanvasXpress.stack[t.target])}var blob=new Blob([obj],{type:"text/plain;charset="+document.characterSet});saveAs(blob,flnm)}}(this);this.saveSVG=function(t){return function(e,f){t.removeMenus();t.resetConfigurator(e);CanvasXpress.stack[t.target].client=CanvasXpress.factory.client;CanvasXpress.stack[t.target].clientIP=CanvasXpress.geo;t.isSVG=true;var tr=t.showTransition;t.showTransition=false;t.meta.canvas.ctx5=new C2S({width:t.width,height:t.height,desc:t.isReproducibleResearch?t.stringifyJSON(CanvasXpress.stack[t.target]):""});t.renderGraph(true);var svg=t.meta.canvas.ctx5.getSerializedSvg();if(t.isReproducibleResearch){t.flashInfoSpan(100,100,"<h2>Please be aware <br>the actual data is stored<br>inside the downloaded image</h2>",5000)}var flnm=f?f+".svg":t.saveFilename?t.saveFilename+".svg":"cX-"+t.target+".svg";flnm=flnm.replace(/.svg.svg$/,".svg");var blob=new Blob([svg],{type:"image/svg+xml;charset="+document.characterSet});saveAs(blob,flnm);t.showTransition=tr;delete (t.meta.canvas.ctx5);t.isSVG=false}}(this);this.parseXML=function(xml){var dom=null;if(window.DOMParser){try{dom=(new DOMParser()).parseFromString(xml,"text/xml")}catch(e){dom=null}}else{if(window.ActiveXObject){try{dom=new ActiveXObject("Microsoft.XMLDOM");dom.async=false;if(!dom.loadXML(xml)){window.alert(dom.parseError.reason+dom.parseError.srcText)}}catch(e){dom=null}}else{alert("cannot parse xml string!")}}return dom};this.parseHTMLTable=function(table,cx){var ar=[];for(var i=0;i<table.rows.length;i++){var ln=[];for(var j=0;j<table.rows.item(i).cells.length;j++){ln.push(table.rows.item(i).cells.item(j).innerHTML)}ar.push(ln)}if(cx){cx=this.arrayToCanvasXpress(ar);CanvasXpress.transferDatasetAttributes(table,cx.config,true);return cx}else{return ar}};this.SVGtoCX=function(xml){var dom=this.parseXML(xml);var svg=dom.childNodes[0];if(svg.tagName.match(/svg/i)){var desc=svg.getAttribute("desc");if(desc){return this.parseJSON(desc)}}};this.print=function(t){return function(e,f){var ow=t.width;var oh=t.height;var pm=t.printMagnification;var as=t.autoScaleFont;var st=t.showTransition;var ss=t.skipStack;var pr=["outlineWidth","lineThickness","axisTickThickness","axisMinMaxTickThickness","guidesWidth","boxplotMedianWidth","boxplotConnectWidth","treeLinkWidth","connectByWidth","histogramBarWidth","heatmapCellBoxWidth","heatmapCellBoxHighlightWidth","edgeThickness","maxTextSize"];if(!CanvasXpress.stack.hasOwnProperty(t.target)){t=CanvasXpress.getObject(CanvasXpress.current.replace("-events",""))}var adjustDPI=function(reset){if(reset&&pm!=1){for(var i=0;i<pr.length;i++){t[pr[i]]/=pm}t.autoScaleFont=as;t.showTransition=st;t.setDimensions(ow,oh,true);t.skipStack=ss}else{if(pm!=1){t.skipStack=true;t.showTransition=false;for(var i=0;i<pr.length;i++){t[pr[i]]*=pm}t.autoScaleFont=true;t.setDimensions(ow*pm,oh*pm,true)}}};var makeCRCTable=function(){var c;var crcTable=[];for(var n=0;n<256;n++){c=n;for(var k=0;k<8;k++){c=((c&1)?(3988292384^(c>>>1)):(c>>>1))}crcTable[n]=c}return crcTable};var crc32=function(str){var crcTable=window.crcTable||(window.crcTable=makeCRCTable());var crc=0^(-1);for(var i=0;i<str.length;i++){crc=(crc>>>8)^crcTable[(crc^str.charCodeAt(i))&255]}return(crc^(-1))>>>0};var appendBuffer=function(buffer1,buffer2){var tmp=new Uint8Array(buffer1.byteLength+buffer2.byteLength);tmp.set(new Uint8Array(buffer1),0);tmp.set(new Uint8Array(buffer2),buffer1.byteLength);return tmp.buffer};var getArrayBuffer=function(string){var ztxt="tEXt";var len=string.length;var crc=crc32(ztxt+string);var mab=new ArrayBuffer(12+len);var ndv=new DataView(mab);ndv.setUint32(0,len);for(var i=0;i<ztxt.length;i++){ndv.setUint8(4+i,ztxt.charCodeAt(i))}for(var i=0;i<string.length;i++){ndv.setUint8(8+i,string.charCodeAt(i))}ndv.setUint32(4+4+len,crc);return mab};var cleanStack=function(){if(t.isReproducibleResearch){if(t.printMagnification!=1){delete (CanvasXpress.stack[t.target].config.showTransition)}return t.stringifyJSON(CanvasXpress.stack[t.target])}else{var stk=t.parseJSON(t.stringifyJSON(CanvasXpress.stack[t.target]));stk.afterRender=[stk.afterRender[0]];return t.stringifyJSON(stk)}};var collectArrayBuffers=function(hab,sab,rab,dab){var nab=appendBuffer(hab,sab);nab=appendBuffer(nab,rab);nab=appendBuffer(nab,dab);return nab};var toDataUrl=function(blb){var fr=new FileReader();var tx="";if(t.isReproducibleResearch){tx+="<h2>Please be aware that the actual data is stored inside the image! Right click to save!</h2>"}else{tx+="<h2>Right click to save image</h2>"}fr.onload=function(evt){tx+="<img width="+t.width+" height="+t.height+" src= '"+evt.target.result+"'/>";t.showTooltipDiv(e,tx,t.getTargetEvent(e),{maxWidth:t.width+"px",whiteSpace:"normal"},40,40)};fr.readAsDataURL(blb)};adjustDPI();t.removeMenus();t.resetConfigurator(e);CanvasXpress.stack[t.target].client=CanvasXpress.factory.client;CanvasXpress.stack[t.target].clientIP=CanvasXpress.geo;var cnv=t.isMap?t.getLeafletCanvas():t.meta.canvas.ctx.canvas;cnv.toBlob(function(blob){var fr=new FileReader();var fn=f?f+".png":t.saveFilename?t.saveFilename+".png":"cX-"+t.target+".png";fn=fn.replace(/.png.png$/,".png");fr.onloadend=function(){var dv=new DataView(this.result);var ihdr=dv.getUint32(8);var idat=8+4+4+ihdr+4;var hab=this.result.slice(0,idat);var dab=this.result.slice(idat);var sab=getArrayBuffer("Software\0CanvasXpress Version: "+CanvasXpress.factory.version);var rab=getArrayBuffer("ReproducibleResearch\0"+cleanStack());var nab=collectArrayBuffers(hab,sab,rab,dab);var blb=new Blob([nab],{type:"image/png"});if(t.printType=="download"){if(t.isReproducibleResearch){t.flashInfoSpan(100,100,"<h2>Please be aware <br>the actual data is stored<br>inside the downloaded image</h2>",5000)}saveAs(blb,fn)}else{toDataUrl(blb)}adjustDPI(true)};fr.readAsArrayBuffer(blob)},"image/png");if(t.maximized){t.clickGraphMaxMin(e)}}}(this);this.exportToSVG=function(t){return function(){var ctx=t.meta.canvas.ctx;t.meta.canvas.ctx=new C2S({width:t.width,height:t.height});t.draw();var svg=t.prettyXML(t.meta.canvas.ctx.getSerializedSvg());var win=window.open("",t.target+"-SVG");win.document.write(svg);t.meta.canvas.ctx=ctx;t.draw();return false}}(this);this.exportToExcel=function(d){return this.exportToTabDelimited(d);var table=this.exportToHTML(d,true);var uri="data:application/vnd.ms-excel;base64,";var template='<html xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:x="urn:schemas-microsoft-com:office:excel" xmlns="https://www.w3.org/TR/REC-html40"><head><!--[if gte mso 9]><xml><x:ExcelWorkbook><x:ExcelWorksheets><x:ExcelWorksheet><x:Name>{worksheet}</x:Name><x:WorksheetOptions><x:DisplayGridlines/></x:WorksheetOptions></x:ExcelWorksheet></x:ExcelWorksheets></x:ExcelWorkbook></xml><![endif]--></head><body><table>{table}</table></body></html>';var base64=function(s){return window.btoa(unescape(encodeURIComponent(s)))};var format=function(s,c){return s.replace(/{(\w+)}/g,function(m,p){return c[p]})};var ctx={worksheet:"Worksheet",table:table};var link=this.$(this.target+"-cX-linkExcel");if(!link){link=this.$cX("a",{id:this.target+"-cX-linkExcel"},{display:"none"});document.body.appendChild(link)}link.href=uri+base64(format(template,ctx));link.download=this.target+".xls";link.click()};this.exportToHTML=function(d,t){var str="<table>";for(var i=0;i<d.length;i++){str+="<tr><td>";str+=d[i].join("</td><td>");str+="</td></tr>"}str+="</table>";return t?str:window.open().document.write(str)};this.exportToTabDelimited=function(d){var str="";for(var i=0;i<d.length;i++){str+=d[i].join("\t")+"\n"}var link=this.$(this.target+"-cX-linkTab");if(!link){link=this.$cX("a",{id:this.target+"-cX-linkTab"},{display:"none"});document.body.appendChild(link)}link.download=this.target+".tsv";link.href="data:text/tab-separated-values;charset=UTF-8,"+encodeURIComponent(str);link.click()};this.arrayToHTML=function(d){var str="";str+='<div class="CanvasXpressDataTableContainer" style="overflow:scroll;max-height:400px;max-width:600px;position:inherit;padding-left:18px;">';str+='<table class="CanvasXpressDataTable" style="position:inherit;">';str+="<tbody>";str+="<tr>";for(var i=0;i<d[0][0].length;i++){str+='<th class="CanvasXpressTableCellHead" style="height:18px">';str+='<div class="CanvasXpressTableCell" style="height:18px">';str+=d[0][0][i];str+="</div>";str+="</th>"}str+="</tr>";for(var i=1;i<d[0].length;i++){str+="<tr>";for(var j=0;j<d[0][i].length;j++){if(j==0){str+='<th class="CanvasXpressTableCellHead" style="height:18px">';str+='<div class="CanvasXpressTableCell" style="height:18px">';str+=d[0][i][j];str+="</div>";str+="</th>"}else{str+='<td class="CanvasXpressTableCell" style="height:18px">';str+='<div class="CanvasXpressTableCell" style="height:18px">';str+=d[0][i][j];str+="</div>";str+="</td>"}}str+="</tr>"}str+="</tbody>";str+="</table>";str+="</div>";return str};this.prettyColoredR=function(o,r,c){var replacer=function(match,pIndent,pKey,pVal,pEnd){var r=pIndent||"";if(pKey){pKey=pKey.replace(/[": ]/g,"");pKey=!isNaN(pKey)?'"'+pKey+'"':pKey;r=r+pKey+" = "}if(pVal){r=r+pVal.replace("false","FALSE").replace("true","TRUE")}return r+(pEnd||"").replace(/[\[\{ ]/g,"list(").replace(/[\]\} ]/g,")")};var replacerColor=function(match,pIndent,pKey,pVal,pEnd){var key="<span class=json-key>";var val="<span class=json-value>";var str="<span class=json-string>";var r=pIndent||"";if(pKey){pKey=pKey.replace(/[": ]/g,"");pKey=!isNaN(pKey)?'"'+pKey+'"':pKey;r=r+key+pKey+"</span> = "}if(pVal){r=r+(pVal[0]=='"'?str:val)+pVal.replace("false","FALSE").replace("true","TRUE")+"</span>"}return r+(pEnd||"").replace(/[\[\{ ]/g,"list(").replace(/[\]\} ]/g,")")};var RLine=/^( *)("[\w]+": )?("[^"]*"|[\w.+-]*)?([,[{])?$/mg;if(c){return this.stringifyJSON(o,r?r:null,2).replace(/]/g,")").replace(/}/g,")").replace(/&/g,"&amp;").replace(/\\"/g,"&quot;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(RLine,replacerColor).replace(/^list\(\n/,"").replace(/\)$/,"")}else{return this.stringifyJSON(o,r?r:null,2).replace(/]/g,")").replace(/}/g,")").replace(RLine,replacer).replace(/^list\(\n/,"").replace(/\)$/,"")}};this.dataToR=function(){var arr=[];var prp=[];var vls,vrs,sps,dat,nod,edg;var scr="";var ini="<span class=json-value>canvasXpress</span>(\n";if(this.meta.config.remote){scr+='data = "'+this.meta.config.remote.data+'"\n';ini+="  <span class=json-key>data</span> = data,\n"}else{if(this.graphType=="Map"){scr+="";ini+="  <span class=json-key>data</span> = <span class=json-value>FALSE</span>,\n"}else{if(this.data.y){for(var i=0;i<this.data.y.vars.length;i++){arr=arr.concat(this.data.y.data[i])}vls="vals = c("+arr.join(",")+")\n";vrs='vars = c("'+this.data.y.vars.join('","')+'")\n';sps='smps = c("'+this.data.y.smps.join('","')+'")\n';dat="data = as.data.frame(matrix(vals, nrow = "+this.data.y.vars.length+", ncol = "+this.data.y.smps.length+", byrow = TRUE, dimnames = list(vars, smps)))\n";scr+=vls+vrs+sps+dat;ini+="  <span class=json-key>data</span> = data,\n"}if(this.data.x){arr=[];prp=[];for(var i in this.data.x){arr=arr.concat(this.data.x[i]);prp.push(i)}vls='valx = c("'+arr.join('","')+'")\n';vrs='varx = c("'+prp.join('","')+'")\n';dat="datx = as.data.frame(matrix(valx, nrow = "+prp.length+", ncol = "+this.data.y.smps.length+", byrow = TRUE, dimnames = list(varx, smps)))\n";scr+=vls+vrs+dat;ini+="  <span class=json-key>smpAnnot</span> = datx,\n"}if(this.data.z){arr=[];prp=[];for(var i in this.data.z){arr=arr.concat(this.data.z[i]);prp.push(i)}vls='valz = c("'+arr.join('","')+'")\n';sps='smpz = c("'+prp.join('","')+'")\n';dat="datz = as.data.frame(matrix(valz, nrow = "+this.data.y.vars.length+", ncol = "+prp.length+", byrow = TRUE, dimnames = list(vars, smpz)))\n";scr+=vls+sps+dat;ini+="  <span class=json-key>varAnnot</span> = datz,\n"}if(this.data.nodes){scr+="nodes = list(\n"+this.prettyColoredR(this.data.nodes,false,true)+")\n";ini+="  <span class=json-key>nodeData</span> = nodes,\n"}if(this.data.edges){scr+="edges = list(\n"+this.prettyColoredR(this.data.edges,false,true)+")\n";ini+="  <span class=json-key>edgeData</span> = edges,\n"}if(this.data.venn){scr+="venn = data.frame(\n"+this.prettyColoredR(this.data.venn.data,false,true)+")\n";ini+="  <span class=json-key>vennData</span> = venn,\n";if(this.data.venn.legend){scr+="legn = data.frame(\n"+this.prettyColoredR(this.data.venn.legend,false,true)+")\n";ini+="  <span class=json-key>vennLegend</span> = legn,\n"}}}}ini+=this.prettyColoredR(this.meta.config.remote?this.meta.config.remote.config:this.meta.config.user,false,true)+")";return"library(<span class=json-value>canvasXpress</span>)\n"+scr+ini};this.prettyJSON=function(o,r,c){return c?this.prettyColoredJSON(o,r):this.stringifyJSON(o,r,2)};this.prettyColoredJSON=function(o,r){var replacer=function(match,pIndent,pKey,pVal,pEnd){var key="<span class=json-key>";var val="<span class=json-value>";var str="<span class=json-string>";var r=pIndent||"";if(pKey){r=r+key+pKey.replace(/[": ]/g,"")+"</span>: "}if(pVal){r=r+(pVal[0]=='"'?str:val)+pVal+"</span>"}return r+(pEnd||"")};var jsonLine=/^( *)("[\w]+": )?("[^"]*"|[\w.+-]*)?([,[{])?$/mg;return this.stringifyJSON(o,r?r:null,2).replace(/&/g,"&amp;").replace(/\\"/g,"&quot;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(jsonLine,replacer)};this.prettyXML=function(str){var reg=/(>)\s*(<)(\/*)/g;var wsexp=/ *(.*) +\n/g;var contexp=/(<.+>)(.+\n)/g;var xml=str.replace(reg,"$1\n$2$3").replace(wsexp,"$1\n").replace(contexp,"$1\n$2");var pad=0;var formatted="";var lines=xml.split("\n");var indent=0;var lastType="other";var transitions={"single->single":0,"single->closing":-1,"single->opening":0,"single->other":0,"closing->single":0,"closing->closing":-1,"closing->opening":0,"closing->other":0,"opening->single":1,"opening->closing":0,"opening->opening":1,"opening->other":1,"other->single":0,"other->closing":-1,"other->opening":0,"other->other":0};for(var i=0;i<lines.length;i++){var ln=lines[i];var single=Boolean(ln.match(/<.+\/>/));var closing=Boolean(ln.match(/<\/.+>/));var opening=Boolean(ln.match(/<[^!].*>/));var type=single?"single":closing?"closing":opening?"opening":"other";var fromTo=lastType+"->"+type;lastType=type;var padding="";indent+=transitions[fromTo];for(var j=0;j<indent;j++){padding+="  "}formatted+=padding+ln+"\n"}return formatted};this.delimitedToArrayOrig=function(str,delim,cx){delim=delim||",";var pat=new RegExp(("(\\"+delim+'|\\r?\\n|\\r|^)(?:"([^"]*(?:""[^"]*)*)"|([^"\\'+delim+"\\r\\n]*))"),"gi");var arr=[[]];var arrM=null;while(arrM=pat.exec(str)){var strM=arrM[1];if(strM.length&&strM!==delim){arr.push([])}var strV;if(arrM[2]){strV=arrM[2].replace(new RegExp('""',"g"),'"')}else{strV=arrM[3]}arr[arr.length-1].push(this.isNumber(strV)?Number(strV):strV!=this.missingDataValue?strV:null)}return cx?this.arrayToCanvasXpress(arr):arr};this.delimitedToArray=function(str,delim,cx,net){var nl=/\r\n|\r|\n/g;var ar=str.split(nl);var setDelim=function(){var tc=0;var tt=0;if(str.match(/,/g)){tc=str.match(/,/g).length}if(str.match(/\t/g)){tt=str.match(/\t/g).length}delim=tc>tt?",":"\t"};if(!delim){setDelim()}for(var i=0;i<ar.length;i++){if(ar[i].match(/^#/)){ar.splice(i,1);i--;continue}var f=ar[i].split(delim);for(var x=f.length-1;x>=0;x--){if(f[x].replace(/"\s+$/,'"').charAt(f[x].length-1)=='"'){var tl=f[x].replace(/^\s+"/,'"');if(tl.length>1&&tl.charAt(0)=='"'){f[x]=f[x].replace(/^\s*"|"\s*$/g,"").replace(/""/g,'"')}else{if(x){f.splice(x-1,2,[f[x-1],f[x]].join(delim))}else{f=f.shift().split(delim).concat(f)}}}else{f[x].replace(/""/g,'"')}}for(var j=0;j<f.length;j++){if(this.isNumber(f[j])){f[j]=Number(f[j])}else{if(f[j]==this.missingDataValue){f[j]=null}else{if(f[j].match(/^\[.+\]$/)||f[j].match(/^\{.+\}$/)){f[j]=this.parseJSON(f[j])}}}}if(f.length==1&&f[0]==""){ar.splice(i,1);i--;continue}ar[i]=f}return cx?this.arrayToCanvasXpress(ar):net?this.isNetworkFile(ar):ar};this.isNetworkFile=function(arr){var obj={};var cols=arr[0];var nodes=0;var edges=0;var fail=0;var type=false;for(var i=1;i<arr.length;i++){var n=arr[i][0];var m=arr[i][1];if(this.data.nodeIndices.hasOwnProperty(n)&&this.data.nodeIndices.hasOwnProperty(m)){edges++}else{if(this.data.nodeIndices.hasOwnProperty(n)){nodes++}else{fail++}}}if(edges>nodes){nodes=0;edges=0;fail=0;type="edge";for(var i=1;i<arr.length;i++){var n=arr[i][0];var m=arr[i][1];if(this.data.nodeIndices.hasOwnProperty(n)&&this.data.nodeIndices.hasOwnProperty(m)){edges++;obj[n+":"+m]={};for(var j=2;j<cols.length;j++){obj[n+":"+m][cols[j]]=arr[i][j]}}else{fail++}}}else{if(nodes>fail){nodes=0;edges=0;fail=0;type="node";for(var i=1;i<arr.length;i++){var n=arr[i][0];if(this.data.nodeIndices.hasOwnProperty(n)){nodes++;obj[n]={};for(var j=1;j<cols.length;j++){obj[n][cols[j]]=arr[i][j]}}else{fail++}}}else{return arr}}if((type=="edge"&&(edges>5||edges>=arr.length-1))||(type=="node"&&(nodes>5||nodes>=arr.length-1))){return{data:obj,rows:Math.max(nodes,edges),fail:fail,type:type}}else{return arr}};this.XMLToJSON=function(xml,json,p,parent){var j={};var prefix=new RegExp(/(?!xmlns)^.*:/);var trim=new RegExp(/^\s+|\s+$/g);if(!json){json={}}if(p&&!json[p]){json[p]=[]}if(xml.attributes&&xml.attributes.length>0){for(var i=0;i<xml.attributes.length;i++){var a=xml.attributes.item(i);var n=a.name.replace(prefix,"").toLowerCase();if(p){j[n]=a.value.replace(trim,"")}else{json[n]=a.value.replace(trim,"")}}if(p){json[p].push(j)}}else{if(p=="alt"){json[p].push(xml.textContent)}}if(xml.hasChildNodes()&&!parent){for(var i=0;i<xml.childNodes.length;i++){var n=xml.childNodes.item(i);var p;if(n.nodeType==4){}else{if(n.nodeType==3){}else{if(n.nodeType==1){p=n.nodeName.replace(prefix,"").toLowerCase();this.XMLToJSON(n,json,p)}}}}}return json};this.cytoscapeToCX=function(xml,target){var sp={ELLIPSE:"oval",arc:"circle",bitmap:"circle",line:"minus",text:"circle",ver_ellipsis:"oval",hor_ellipsis:"oval"};var nodes=[];var edges=[];var title="";var pw=xml.childNodes[0];if(pw.tagName.toLowerCase()=="graph"){var ob=this.XMLToJSON(pw,false,false,true);for(var i=0;i<pw.childNodes.length;i++){var el=pw.childNodes[i];if(el.nodeName){var nn=el.nodeName.toLowerCase();var js=this.XMLToJSON(el);switch(nn){case"node":if(js.graphics&&js.id){var gr=js.graphics[0];var node={id:js.id,x:Number(gr.x),y:Number(gr.y),z:Number(gr.z),width:Number(gr.w),height:Number(gr.h),shape:(sp[gr.type]||gr.type),color:gr.fill,outline:gr.outline,outlineWidth:Number(gr.width)};if(js.label){node.name=js.label}if(js.att){for(var j=0;j<js.att.length;j++){var at=js.att[j];if(at.name&&!at.name.match(/NODE_/)&&at.name!="selected"&&at.name!="isInPath"){switch(at.type){case"String":if(at.name=="COMMON"&&at.value){node.label=at.value}else{if(at.value){node[at.name]=at.value}}break;case"Double":case"Integer":if(at.value!=null){node[at.name]=Number(at.value)}break;case"Boolean":if(at.value!=null){node[at.name]=at.value==0?false:true}break}}}}nodes.push(node)}break;case"edge":if(js.source&&js.target){var edge={id1:js.source,id2:js.target};if(js.id){edge.intId=js.id}if(js.label){edge.label=js.label}if(js.directed){edge.directed=js.directed}if(js.graphics){edge.color=js.graphics[0].fill;edge.width=js.graphics[0].width}if(js.att){for(var j=0;j<js.att.length;j++){var at=js.att[j];if(at.name&&!at.name.match(/EDGE_/)&&at.name!="selected"&&at.name!="isInPath"){switch(at.type){case"String":if(at.value){edge[at.name]=at.value}break;case"Double":case"Integer":if(at.value!=null){edge[at.name]=Number(at.value)}break;case"Boolean":if(at.value!=null){edge[at.name]=at.value==0?false:true}break}}}}edges.push(edge)}break;case"att":if(js.name&&js.value&&js.name=="Dataset Name"){title=js.value}break}}}}else{alert("Ooops! Not a cytoscape xgmml file!")}var res="Number of Nodes: "+nodes.length+"\nNumber of Edges: "+edges.length+"\n";res=res.replace(/\n/g,"<br>");var data={data:{nodes:nodes,edges:edges},config:{adjustBezier:false,graphType:"Network",calculateLayout:false,showAnimation:false,networkNodesOnTop:true,showNodeNameThreshold:20000,networkFreeze:true,preScaleNetwork:false,nodeFontSize:10,title:title,moveParentsWithChildren:true,ignoreEventlessOrder:true},renderTo:target,uploadFile:true,afterRender:[["flashInfoSpan",[100,100,res,5000]]]};var clbk=false;var rurl=this.dataURL;var cnfg=this.cloneObject(this.meta.config.user);if(this.graphType=="Network"){for(var p in this.meta.config.user){data.config[p]=this.meta.config.user[p]}clbk=function(t){t.meta.config.remote={data:rurl,config:cnfg}}}this.updateRemoteData(data,clbk);this.hideMask()};this.keggToCX=function(xml,target){var that=this;var pw=xml.childNodes[2];var nodes=[];var edges=[];var title,image,link,width,height;var addAnchors=function(){nodes.push({id:"__zero__",type:"anchor",shape:"circle",color:"rgba(0,0,0,0)",outline:"rgb(0,0,0)",width:1,height:1,x:0,y:0,hideLabel:true},{id:"__max__",type:"anchor",shape:"circle",color:"rgba(0,0,0,0)",outline:"rgb(0,0,0)",width:1,height:1,x:width,y:height,hideLabel:true})};if(pw.tagName.toLowerCase()=="pathway"){var ob=this.XMLToJSON(pw,false,false,true);title=ob.title;image=ob.image;link=ob.link;var img=new Image();img.onload=function(){width=this.width;height=this.height;var res="Number of Nodes: "+nodes.length+"\n";res+="Number of Edges: "+edges.length+"\n";addAnchors();that.remoteServiceType="file";var data={data:{nodes:nodes,edges:edges},config:{adjustBezier:false,graphType:"Network",calculateLayout:false,showAnimation:false,networkNodesOnTop:false,showNodeNameThreshold:20000,networkFreeze:true,preScaleNetwork:false,title:title,backgroundType:"image",backgroundImage:image},renderTo:target,uploadFile:true,afterRender:[["flashInfoSpan",[100,100,res,5000]],["appendNetworkDataFromURL",[]]]};var clbk=false;var rurl=that.dataURL;var cnfg=that.cloneObject(that.meta.config.user);if(that.graphType=="Network"){for(var p in that.meta.config.user){data.config[p]=that.meta.config.user[p]}clbk=function(t){t.meta.config.remote={data:rurl,config:cnfg}}}that.updateRemoteData(data,clbk);that.hideMask()};if((CanvasXpress.system.isR&&!CanvasXpress.system.isInIframe)||!CanvasXpress.system.isR){img.crossOrigin="anonymous"}img.src=ob.image;for(var i=0;i<pw.childNodes.length;i++){var el=pw.childNodes[i];if(el.nodeName){var nn=el.nodeName.toLowerCase();switch(nn){case"entry":var ob=this.XMLToJSON(el);if(ob.graphics[0].type=="roundrectangle"){ob.graphics[0].type="roundrect";ob.graphics[0].fgcolor="rgba(0,0,0,0)"}if(ob.graphics&&ob.graphics.length==1&&ob.graphics[0].type!="line"){var ext=ob.type=="group"?5:0;var node={id:ob.id,type:ob.type,link:ob.link,name:ob.graphics[0].name,shape:ob.graphics[0].type,color:"rgba(0,0,0,0)",outline:that.validateColor(ob.graphics[0].fgcolor)||"rgb(0,0,0)",width:parseInt(ob.graphics[0].width)+ext,height:parseInt(ob.graphics[0].height)+ext,x:parseInt(ob.graphics[0].x),y:parseInt(ob.graphics[0].y),hideLabel:true,fixed:true};if(ob.type=="group"){nodes.unshift(node)}else{nodes.push(node)}}else{if(ob.graphics&&ob.graphics.length==1&&ob.graphics[0].type=="line"){var coords=ob.graphics[0].coords.split(",");if(coords.length==4){var x=[];var y=[];var w,h,r;while(coords.length>1){x.push(parseInt(coords.shift()));y.push(parseInt(coords.shift()))}var mx=parseInt(this.mean(x));var my=parseInt(this.mean(y));if(x[0]==x[1]){mx+=1;w=2;h=y[1]-y[0];r=0}else{if(y[0]==y[1]){my+=1;w=x[1]-x[0];h=2;r=0}else{h=this.lineLength(x[0],y[0],x[1],y[1]);w=2;r=this.getAngle(x[0],y[0],x[1],y[1])}}var node={id:ob.id,type:ob.type,link:ob.link,name:ob.graphics[0].name,shape:"rect",color:"rgba(0,0,0,0)",outline:"rgba(0,0,0,0)",x:mx,y:my,width:w,height:h,rotate:r,hideLabel:true,fixed:true};nodes.push(node)}}}break;case"relation":case"reaction":var ob=this.XMLToJSON(el);ob.id1=this.cloneObject(ob.entry1);ob.id2=this.cloneObject(ob.entry2);delete (ob.entry1);delete (ob.entry2);ob.color="rgba(0,0,0,0)";edges.push(ob);break}}}}else{alert("Ooops! Not a kgml file!")}};this.wikipathwayToCX=function(xml,target){var pw=xml.childNodes[0];var nodes={};var edges=[];var state={};var groups={};var anchors={};var order={};var cntp=1;var cntn=0;var sord=[];var groupRef={};var groupGref={};var groupId={};var wrn="\nWarnings:\n";var htt=false;var title,subtitle;var arrowTypes={Line:false,Arrow:"arrow",TBar:"square","mim-necessary-stimulation":false,"mim-binding":false,"mim-conversion":"arrow","mim-stimulation":"arrow","mim-catalysis":"round","mim-modification":false,"mim-inhibition":"square","mim-covalent-bond":false,"mim-transcription-translation":false};var createNodeFromGroup=function(grp,id){var mnx=Number.MAX_VALUE;var mny=Number.MAX_VALUE;var mxx=-Number.MAX_VALUE;var mxy=-Number.MAX_VALUE;var ids=[];var ord=[];var shw=false;for(var i=0;i<grp.length;i++){mnx=Math.min(mnx,grp[i][1]-(grp[i][3]/2));mny=Math.min(mny,grp[i][2]-(grp[i][4]/2));mxx=Math.max(mxx,grp[i][1]+(grp[i][3]/2));mxy=Math.max(mxy,grp[i][2]+(grp[i][4]/2));ids.push(grp[i][0]);nodes[grp[i][0]].parentNode=id;ord.push(nodes[grp[i][0]].zorder);if(nodes[grp[i][0]].nodeName!="label"){shw=true}ord.sort(function(a,b){return a-b})}var w=mxx-mnx;var h=mxy-mny;var ob={id:id,x:(mnx+mxx)/2,y:(mny+mxy)/2,width:w+(grp.length>1&&w>10?5:0),height:h+(grp.length>1&&h>10?5:0),group:ids,hideLabel:true,hideTooltip:htt,type:"Group",color:(shw?"rgba(245,245,245,0.5)":"rgba(0,0,0,0)"),outline:(shw?"rgb(0,0,0)":"rgba(0,0,0,0)"),shape:"rectangle",zorder:ord[0]};order[id]=cntn--;nodes[id]=ob;sord.push(id)};var createNodeFromPoint=function(p,id){var ob={id:id,x:Math.round(p.x*10)/10,y:Math.round(p.y*10)/10,width:p.width?Math.round(p.width):1,height:p.height?Math.round(p.height):1,hideLabel:p.show?false:true,hideTooltip:!htt?false:p.show?false:true,eventless:p.show?false:true,type:p.type||"Anchor",color:p.color||"rgba(0,0,0,0)",outline:p.outline||"rgba(0,0,0,0)",shape:p.shape||"circle",label:p.label||"",labelSize:p.labelSize||0.5,zorder:p.zorder||0};order[id]=cntp++;nodes[id]=ob;sord.push(id)};var getDirection=function(s){switch(s){case"r":case"l":return"rl";case"b":case"t":case"c":return"tb"}};var getSide=function(p){if(parseInt(p.relx)==1){return"r"}else{if(parseInt(p.relx)==-1){return"l"}else{if(parseInt(p.rely)==1){return"b"}else{if(parseInt(p.rely)==-1){return"t"}else{if(Math.abs(p.relx)>Math.abs(p.rely)){if(parseFloat(p.relx)>0){return"r"}else{return"l"}}else{if(parseFloat(p.rely)>0){return"b"}else{if(parseFloat(p.rely)<0){return"t"}else{return"c"}}}}}}}};var getNumberOfLines=function(s,t){var findExtra=function(sd,p1,p2){switch(sd){case"r":if(parseFloat(p1.x)>=parseFloat(p2.x)){return 2}break;case"l":if(parseFloat(p1.x)<=parseFloat(p2.x)){return 2}break;case"t":case"c":if(parseFloat(p1.y)<=parseFloat(p2.y)){return 2}break;case"b":if(parseFloat(p1.y)>=parseFloat(p2.y)){return 2}break}return 0};var ss=getSide(s);var ts=getSide(t);var ls=2;if(getDirection(ss)==getDirection(ts)){ls++}if(ss!=ts){ls+=findExtra(ss,s,t);ls+=findExtra(ts,t,s)}return ls};var getPoint=function(s,a,f){if(f){switch(s){case"r":return[a[0]+20,a[1]];case"l":return[a[0]-20,a[1]];case"t":case"c":return[a[0],a[1]-20];case"b":return[a[0],a[1]+20]}}else{switch(s){case"r":case"l":return[a[0][0],a[1][1]];case"t":case"b":case"c":return[a[1][0],a[0][1]]}}};var getCoords=function(d,a){var r=[a[0]];var l=a[0];for(var i=1;i<a.length;i++){var c=a[i];switch(d){case"rl":r.push([c[0],l[1]]);break;case"tb":r.push([l[0],c[1]]);break}l=r[i];d=d=="rl"?"tb":"rl"}r.push(a[a.length-1]);return r};var to2DArray=function(edg){var ps=edg.point;var a=[];for(var i=0;i<ps.length;i++){a.push([Math.round(ps[i].x*10)/10,Math.round(ps[i].y*10)/10])}return a};var getElbowPoints=function(edg){var ps=edg.point;var n1=ps.length-1;var ls=getNumberOfLines(ps[0],ps[n1]);var s=getSide(ps[0]);var t=getSide(ps[n1]);var d=getDirection(s);var a=to2DArray(edg);if(ls==ps.length){a=getCoords(d,a)}else{if(ps.length==2){a.splice(1,0,getPoint(s,a[0],true));if(ls>3){if(ls>3){a.splice(2,0,getPoint(t,a[2],true))}if(ls>4){if(ls>4){a.splice(3,0,[(a[1][0]+a[2][0])/2,(a[1][1]+a[2][1])/2])}if(ls>5){a=to2DArray(edg);a=getCoords(d,a)}}else{a.splice(2,0,getPoint(s,[a[1],a[2]]))}}else{if((a[0][0]==a[1][0]&&a[1][0]==a[2][0])||(a[0][1]==a[1][1]&&a[1][1]==a[2][1])){a.splice(1,1)}else{a.splice(2,0,getPoint(s,[a[1],a[2]]))}}}else{if(ps.length>ls){a=getCoords(d,a)}else{for(var i=0;i<n1;i++){var j=i*2;if(d=="tb"){d="rl";a.splice(j+1,0,[a[j][0],a[j+1][1]])}else{d="tb";a.splice(j+1,0,[a[j+1][0],a[j][1]])}}}}}var b=[[a[0][0],a[0][1]]];for(var i=1;i<a.length;i++){if(a[i][0]==a[i-1][0]&&a[i][1]==a[i-1][1]){continue}b.push([a[i][0],a[i][1]])}return b};var getBezierPoints=function(edg,sn,tn){var ps=edg.point;var n1=ps.length-1;var s=getSide(ps[0]);var t=getSide(ps[n1]);var ds=getDirection(s);var dt=getDirection(t);var ar=to2DArray(edg);var segs=[];var p0,p1,mx,my;if(n1==1){p0=ar[0];p1=ar[1];if(sn&&tn){if(ds==dt){mx=(p0[0]+p1[0])/2;my=(p0[1]+p1[1])/2;if(ds=="tb"){if(t=="t"){if(my>tn.y-tn.height){my-=tn.height}}else{if(t=="b"){if(my<tn.y+tn.height){my+=tn.height}}}segs.push([p0[0],p0[1],p0[0],my,mx,my]);segs.push([mx,my,p1[0],my,p1[0],p1[1]])}else{if(t=="l"){if(mx>tn.x-tn.width){mx-=tn.width*0.5}}else{if(t=="r"){if(mx<tn.x+tn.width){mx+=tn.width*0.5}}}segs.push([p0[0],p0[1],mx,p0[1],mx,my]);segs.push([mx,my,mx,p1[1],p1[0],p1[1]])}}else{if(s=="t"||s=="b"){mx=t=="l"?-tn.width*0.5:t=="r"?tn.width*0.5:-tn.width*0.5;my=(p1[1]-p0[1])/3;if((t=="l"&&p0[0]>tn.x-tn.width)||(t=="r"&&p0[0]<tn.x+tn.width)){segs.push([p0[0],p0[1],p0[0],p0[1]+my,p1[0],p0[1]+my]);segs.push([p1[0],p0[1]+my,p1[0]+mx,p0[1]+my,p1[0]+mx,p0[1]+my+my]);segs.push([p1[0]+mx,p0[1]+my+my,p1[0]+mx,p1[1],p1[0],p1[1]])}else{segs.push([p0[0],p0[1],p0[0],p1[1],p1[0],p1[1]])}}else{mx=(p1[0]-p0[0])/3;my=t=="t"?-tn.height:t=="b"?tn.height:-tn.height;if((t=="t"&&p0[1]>tn.y-tn.height)||(t=="b"&&p0[1]<tn.y+tn.height)){segs.push([p0[0],p0[1],p0[0]+mx,p0[1],p0[0]+mx,p1[1]]);segs.push([p0[0]+mx,p1[1],p0[0]+mx,p1[1]+my,p0[0]+mx+mx,p1[1]+my]);segs.push([p0[0]+mx+mx,p1[1]+my,p1[0],p1[1]+my,p1[0],p1[1]])}else{segs.push([p0[0],p0[1],p1[0],p0[1],p1[0],p1[1]])}}}}}else{p0=ar[0];if(s=="t"||s=="b"){for(var i=1;i<n1;i++){p1=ar[i];if(i%2){segs.push([p0[0],p0[1],p0[0],p1[1],p1[0],p1[1]])}else{segs.push([p0[0],p0[1],p1[0],p0[1],p1[0],p1[1]])}p0=p1}p1=ar[n1];if(n1%2){segs.push([p0[0],p0[1],p0[0],p1[1],p1[0],p1[1]])}else{segs.push([p0[0],p0[1],p1[0],p0[1],p1[0],p1[1]])}}else{for(var i=1;i<n1;i++){p1=ar[i];if(i%2){segs.push([p0[0],p0[1],p1[0],p0[1],p1[0],p1[1]])}else{segs.push([p0[0],p0[1],p0[0],p1[1],p1[0],p1[1]])}p0=p1}p1=ar[n1];if(n1%2){segs.push([p0[0],p0[1],p1[0],p0[1],p1[0],p1[1]])}else{segs.push([p0[0],p0[1],p0[0],p1[1],p1[0],p1[1]])}}}return segs};var getStatePosition=function(n,s){var x=parseFloat(s.relx);var y=parseFloat(s.rely);var w=n.width/2;var h=n.height/2;return[n.x+(x*w),n.y+(y*h)]};var XMLToJSON=function(xml,json,p,parent){var j={};var prefix=new RegExp(/(?!xmlns)^.*:/);var trim=new RegExp(/^\s+|\s+$/g);if(!json){json={}}if(p&&(p=="point"||p=="anchor")&&!json[p]){json[p]=[]}if(xml.attributes&&xml.attributes.length>0){for(var i=0;i<xml.attributes.length;i++){var a=xml.attributes.item(i);var n=a.name.replace(prefix,"").toLowerCase();if(p&&(p=="point"||p=="anchor")){j[n]=a.value.replace(trim,"")}else{json[n]=a.value.replace(trim,"")}}if(p&&(p=="point"||p=="anchor")){json[p].push(j)}}if(xml.hasChildNodes()&&!parent){for(var i=0;i<xml.childNodes.length;i++){var n=xml.childNodes.item(i);var p;if(n.nodeType==4){}else{if(n.nodeType==3){}else{if(n.nodeType==1){p=n.nodeName.replace(prefix,"").toLowerCase();XMLToJSON(n,json,p)}}}}}return json};if(pw.tagName.toLowerCase()=="pathway"){var ob=XMLToJSON(pw,false,false,true);title=ob.name;subtitle=ob.organism;for(var i=0;i<pw.childNodes.length;i++){var el=pw.childNodes[i];if(el.nodeName){var nn=el.nodeName.toLowerCase();switch(nn){case"comment":break;case"graphics":break;case"state":var ob=XMLToJSON(el);ob.nodeName=nn;state[ob.graphid]=ob;break;case"datanode":case"label":case"shape":var ob=XMLToJSON(el);ob.nodeName=nn;if(ob.centerx){ob.x=Math.round(ob.centerx*10)/10;delete (ob.centerx)}if(ob.centery){ob.y=Math.round(ob.centery*10)/10;delete (ob.centery)}if(ob.width){ob.width=parseInt(ob.width)}if(ob.height){ob.height=parseInt(ob.height)}if(ob.textlabel){ob.label=ob.textlabel;delete (ob.textlabel)}if(ob.database&&ob.id){ob.database+=" : "+ob.id}if(ob.graphid){ob.id=ob.graphid}if(ob.fontsize){ob.labelSize=parseInt(((ob.fontsize-1)/20)*10)/10}if(ob.rotation){ob.rotate=(parseFloat(ob.rotation)*180/Math.PI)+180}if(ob.shapetype){if(ob.shapetype=="RoundedRectangle"){ob.shapetype=ob.value&&ob.value=="Double"?"roundrectd":"roundrect"}if(ob.shapetype=="Arc"){ob.shapetype="arc3"}if(ob.shapetype=="Mitochondria"){ob.shapetype="image";ob.imagePath="https://canvasxpress.org/images/mit.png"}if(this.isValidShape(ob.shapetype.toLowerCase())){ob.shape=ob.shapetype.toLowerCase()}else{wrn+=ob.id+" has an unkown shape: "+ob.shapetype+"\n";ob.shape=ob.shapetype}if(ob.shape=="oval"&&ob.value&&ob.value=="Double"){ob.shape="ovald"}delete (ob.shapetype)}if(!ob.shape){ob.shape="rectangle"}if(nn=="shape"){ob.labelColor=ob.color?this.validateColor(ob.color):"rgb(0,0,0)"}else{if(ob.color){ob.labelColor=this.validateColor(ob.color)}else{ob.labelColor="rgb(0,0,0)"}}if(ob.fillcolor){ob.color=this.validateColor(ob.fillcolor);delete (ob.fillcolor)}else{ob.color="rgba(0,0,0,0)"}if(ob.color=="rgb(0,0,0)"){ob.color="rgba(0,0,0,0)"}if(ob.color=="rgb(255,255,255)"){ob.color="rgba(255,255,255,0)"}if(nn=="label"){if(!ob.label||ob.label==""){ob.hideLabel=true;ob.hideTooltip=htt;ob.eventless=true}ob.outline="rgba(0,0,0,0)";ob.color="rgba(0,0,0,0)"}else{ob.outline=ob.labelColor}if(nn=="shape"&&(!ob.label||ob.label=="")){ob.hideLabel=true;ob.hideTooltip=htt;ob.outline=ob.labelColor}if(ob.groupref){if(!groupRef.hasOwnProperty(ob.groupref)){groupRef[ob.groupref]=[]}groupRef[ob.groupref].push([ob.id,ob.x,ob.y,ob.width,ob.height]);ob.parentNode=ob.groupref}order[ob.id]=cntp++;nodes[ob.id]=ob;sord.push(ob.id);break;case"interaction":var ob=XMLToJSON(el);ob.nodeName=nn;if(ob.anchor){for(var j=0;j<ob.anchor.length;j++){anchors[ob.anchor[j].graphid]=true}delete (ob.anchor)}var n1=ob.point.length-1;if(ob.point[0].graphref&&ob.point[n1].graphref){ob.id1=ob.point[0].graphref;ob.id2=ob.point[n1].graphref}var type="solid";if(ob.linestyle&&ob.linestyle=="Broken"){type="dashed"}if(ob.connectortype&&ob.connectortype=="Curved"){type+="Bezier"}ob.type=type;if(ob.point[0].arrowhead){if(arrowTypes[ob.point[0].arrowhead]){ob.startArrow=arrowTypes[ob.point[0].arrowhead]}}if(ob.point[n1].arrowhead){if(arrowTypes[ob.point[n1].arrowhead]){ob.endArrow=arrowTypes[ob.point[n1].arrowhead]}}if(ob.linethickness){ob.thickness=parseInt(ob.linethickness*10)/10;delete (ob.linethickness)}if(ob.point[0].relx&&ob.point[0].rely){ob.startX=parseFloat(ob.point[0].relx);ob.startY=parseFloat(ob.point[0].rely)}if(ob.point[n1].relx&&ob.point[n1].rely){ob.endX=parseFloat(ob.point[n1].relx);ob.endY=parseFloat(ob.point[n1].rely)}delete (ob.id);edges.push(ob);break;case"group":var ob=XMLToJSON(el);ob.nodeName=nn;if(ob.groupref&&ob.groupid){if(!groups.hasOwnProperty(ob.groupref)){groups[ob.groupref]=[]}groups[ob.groupref].push(ob.groupid);groupGref[ob.graphid]=ob.groupref}else{groupId[ob.graphid]=ob.groupid}break;case"infobox":break;case"legend":break;case"biopax":break}}}}else{alert("Ooops! Not a gpml file!")}for(var s in state){var g=state[s].graphref;if(nodes[g]){var c=getStatePosition(nodes[g],state[s]);var p={id:g,x:c[0],y:c[1],width:state[s].width,height:state[s].height,label:state[s].textlabel==""?" ":state[s].textlabel,type:"State",color:state[s].textlabel==""?"rgb(255,255,255)":this.validateColor(state[s].fillcolor),outline:"rgb(0,0,0)",shape:"oval",show:true,labelSize:0.5};createNodeFromPoint(p,s)}}for(var g in groupRef){createNodeFromGroup(groupRef[g],g)}for(var g in groups){if(groupRef.hasOwnProperty(g)){for(var i=0;i<groups[g].length;i++){var ob=nodes[groups[g][i]];groupRef[g].push([ob.id,ob.x,ob.y,ob.width,ob.height])}createNodeFromGroup(groupRef[g],g)}}var edgs=[];var fail=[];for(var i=0;i<edges.length;i++){var ob=edges[i];var n1=ob.point.length-1;if(!ob.point[0].graphref&&!ob.point[n1].graphref){ob.exact=true}for(var j=0;j<ob.point.length;j++){var pt=ob.point[j];if(pt.graphref){if(!nodes.hasOwnProperty(pt.graphref)){if(j==0){if(groupId[pt.graphref]){ob.id1=groupId[pt.graphref]}else{createNodeFromPoint(pt,pt.graphref);ob.hideTooltip=htt;ob.exactStart=anchors[pt.graphref]?true:false;ob.id1=pt.graphref}}else{if(j==ob.point.length-1){if(groupId[pt.graphref]){ob.id2=groupId[pt.graphref]}else{createNodeFromPoint(pt,pt.graphref);ob.hideTooltip=htt;ob.exactEnd=anchors[pt.graphref]?true:false;ob.id2=pt.graphref}}}}}else{if(j==0||j==ob.point.length-1){var id=j==0?ob.graphid+".1":ob.graphid+".2";var ni=j==0?ob.point.length-1:0;createNodeFromPoint(pt,id);if(j==0){ob.id1=id;ob.exactStart=true}else{ob.id2=id;ob.exactEnd=true}ob.hideTooltip=htt;if(ob.point[ni].graphref){if(!nodes.hasOwnProperty(ob.point[ni].graphref)&&groupId[ob.point[ni].graphref]){if(j==0){ob.id2=groupId[ob.point[ni].graphref]}else{ob.id1=groupId[ob.point[ni].graphref]}}else{if(j==0){ob.id2=ob.point[ni].graphref}else{ob.id1=ob.point[ni].graphref}}}}}}if(ob.connectortype){if(ob.connectortype=="Elbow"){ob.elbows=getElbowPoints(ob)}else{if(ob.connectortype=="Curved"){ob.elbows=getBezierPoints(ob,nodes[ob.id1],nodes[ob.id2])}else{if(ob.connectortype=="Segmented"){ob.elbows=to2DArray(ob)}}}}if(nodes[ob.id1]&&nodes[ob.id2]){edgs.push(ob)}else{fail.push(ob)}}sord.sort(function(a,b){if(nodes[a].zorder&&nodes[b].zorder){if(parseInt(nodes[a].zorder)-parseInt(nodes[b].zorder)==0){return order[a]-order[b]}else{return parseInt(nodes[a].zorder)-parseInt(nodes[b].zorder)}}else{return order[a]-order[b]}});var nods=[];for(var i=0;i<sord.length;i++){nods.push(nodes[sord[i]])}var res="Number of Nodes: "+nods.length+"\n";res+="Number of Edges: "+edgs.length+"\n";if(fail.length>0){res+="Number of Failed Edges: "+fail.length+"\n";for(var i=0;i<fail.length;i++){res+="\t"+(i+1)+". "+fail[i].graphid+"\n"}}if(wrn!="\nWarnings:\n"){res+=wrn}res=res.replace(/\n/g,"<br>");var data={data:{nodes:nods,edges:edgs},config:{adjustBezier:false,graphType:"Network",calculateLayout:false,showAnimation:false,networkNodesOnTop:false,showNodeNameThreshold:20000,networkFreeze:true,preScaleNetwork:false,title:title},renderTo:target,uploadFile:true,afterRender:[["flashInfoSpan",[100,100,res,5000]]]};var clbk=false;var rurl=this.dataURL;var cnfg=this.cloneObject(this.meta.config.user);if(this.graphType=="Network"){for(var p in this.meta.config.user){data.config[p]=this.meta.config.user[p]}clbk=function(t){t.meta.config.remote={data:rurl,config:cnfg}}}this.updateRemoteData(data,clbk);this.hideMask()};this.metabaseToCX=function(xml,target){var that=this;var sp={ELLIPSE:"oval",arc:"circle",bitmap:"circle",line:"minus",text:"circle",ver_ellipsis:"oval",hor_ellipsis:"oval"};var loc={3:"microsome",13:"epr",21:"lysosome",43:"nucleus",67:"golgi",1287:"mitochondria",1312:"peroxisome"};var getMembrane=function(node){var getNode=function(){return{shape:"rectangle",color:"rgba(0,0,0,0)",outline:"rgba(0,0,0,0)",outlineWidth:0,hideLabel:true,eventless:true,type:node.type,zorder:node.zorder+1,width:32,height:32}};var getNodeTL=function(){var nd=getNode();nd.id=node.id+"-membraneTL";nd.pattern="membraneTL";nd.x=node.x-(node.width*0.5);nd.y=node.y-(node.height*0.5);nd.width=64;nd.height=64;return nd};var getNodeTR=function(){var nd=getNode();nd.id=node.id+"-membraneTR";nd.pattern="membraneTR";nd.x=node.x+(node.width*0.5)-32;nd.y=node.y-(node.height*0.5);nd.width=64;nd.height=64;return nd};var getNodeBL=function(){var nd=getNode();nd.id=node.id+"-membraneBL";nd.pattern="membraneBL";nd.x=node.x-(node.width*0.5);nd.y=node.y+(node.height*0.5)-32;nd.width=64;nd.height=64;return nd};var getNodeBR=function(){var nd=getNode();nd.id=node.id+"-membraneBR";nd.pattern="membraneBR";nd.x=node.x+(node.width*0.5)-32;nd.y=node.y+(node.height*0.5)-32;nd.width=64;nd.height=64;return nd};var getNodeTop=function(s){var nd=getNode();nd.id=node.id+"-membraneT";nd.pattern="membraneTop";nd.x=node.x+(s==0?0:s==1?-16:s==2?16:0);nd.y=node.y-(node.height*0.5);nd.width=node.width-(s==0?0:s==1?32:s==2?32:64);return nd};var getNodeBottom=function(s){var nd=getNodeTop(s);nd.id=node.id+"-membraneB";nd.pattern="membraneBottom";nd.y=node.y+(node.height*0.5)-16;return nd};var getNodeRight=function(s){var nd=getNode();nd.id=node.id+"-membraneR";nd.pattern="membraneRight";nd.x=node.x+(node.width*0.5)-16;nd.y=node.y+(s==0?0:s==1?-16:s==2?16:0);nd.height=node.height-(s==0?0:s==1?32:s==2?32:64);return nd};var getNodeLeft=function(s){var nd=getNodeRight(s);nd.id=node.id+"-membraneL";nd.pattern="membraneLeft";nd.x=node.x-(node.width*0.5);return nd};switch(node.type){case 1:node.shape="rectangle";return[getNodeTop(0)];case 2:node.shape="rectangle";return[getNodeRight(0)];case 3:node.shape="roundrecttr";return[getNodeTop(1),getNodeRight(2),getNodeTR()];case 4:node.shape="rectangle";return[getNodeBottom(0)];case 5:node.shape="rectangle";return[getNodeTop(0),getNodeBottom(0)];case 6:node.shape="roundrectbr";return[getNodeBottom(1),getNodeRight(1),getNodeBR()];case 7:node.shape="roundrectr";return[getNodeTop(1),getNodeBottom(1),getNodeRight(3),getNodeBR(),getNodeTR()];case 8:node.shape="rectangle";return[getNodeLeft(0)];case 9:node.shape="roundrecttl";return[getNodeTop(2),getNodeLeft(2),getNodeTL()];case 10:node.shape="rectangle";return[getNodeRight(0),getNodeLeft(0)];case 11:node.shape="roundrectt";return[getNodeTop(3),getNodeRight(2),getNodeLeft(2),getNodeTR(),getNodeTL()];case 12:node.shape="roundrectbl";return[getNodeBottom(2),getNodeLeft(1),getNodeBL()];case 13:node.shape="roundrectl";return[getNodeTop(2),getNodeBottom(2),getNodeLeft(3),getNodeTL(),getNodeBL()];case 14:node.shape="roundrectb";return[getNodeBottom(3),getNodeRight(1),getNodeLeft(1),getNodeBR(),getNodeBL()];case 15:if(node.width<64||node.height<64){node.shape="rectangle";delete node.gradient;delete node.color1;delete node.color2;delete node.color3;return[getNodeTop(0)]}node.shape="roundrect2";return[getNodeTop(3),getNodeBottom(3),getNodeRight(3),getNodeLeft(3),getNodeTR(),getNodeTL(),getNodeBR(),getNodeBL()]}return[]};var getLengthToNodeBoundary=function(x0,y0,x1,y1,node){var wi=node.width;var he=node.height;var cl=that.clip("line",[x0,y0,x1,y1],[x0-(node.width/2),y0-(node.height/2),node.width+(x0-(node.width/2)),node.height+(y0-(node.height/2))]);return that.lineLength(cl[0],cl[1],cl[2],cl[3])+2};var nodes=[];var edges=[];var pw=xml.childNodes[0];if(pw.tagName.toLowerCase()=="map"){var seen={};var sord=[];var n=0;var ob=this.XMLToJSON(pw,false,false,true);nodes.push({id:"__background__",type:"background",shape:"rectangle",color:"rgb(220,231,232)",outline:"rgb(29,154,195)",outlineWidth:3,width:Number(ob.width),height:Number(ob.height),x:Number(ob.width)*0.5,y:Number(ob.height)*0.5,hideLabel:true,eventless:true,zorder:1});sord.push(n++);for(var i=0;i<pw.childNodes.length;i++){var el=pw.childNodes[i];if(el.nodeName){var nn=el.nodeName.toLowerCase();switch(nn){case"localizations":for(var j=0;j<el.childNodes.length;j++){var nd=el.childNodes[j];if(nd.nodeName&&nd.nodeName.toLowerCase()=="loc"){var js=this.XMLToJSON(nd);var shp=loc.hasOwnProperty(js.id)?"image":js.id=="16"?"roundrect2":"roundrect";var node={id:"loc"+(j+1),shape:shp,hideLabel:true,eventless:true,x:Number(js.x)+(Number(js.width)*0.5),y:Number(js.y)+(Number(js.height)*0.5),width:Number(js.width),height:Number(js.height),type:Number(js.type),zorder:js.appearance&&js.appearance[0].zorder?Number(js.appearance[0].zorder.replace("Integer: ","")):2};if(shp!="image"){node.color="rgba(0,0,0,0)";node.outline=js.id=="16"?"rgba(0,0,0,0)":"rgb(83,158,188)";node.outlineWidth=js.id!="16"?3:0;if(js.id!="16"){node.width-=6;node.height-=6}}if(js.appearance&&js.appearance[0].rotateangle){node.rotate=Number(js.appearance&&js.appearance[0].rotateangle.split(": ")[1]);if(!node.rotate){delete node.rotate}else{node.widthTMP=node.width;node.width=node.height;node.height=node.widthTMP;delete node.widthTMP}}if(js.id=="16"){node.gradient="linear";node.color1="rgb(122,194,226)";node.color2="rgb(223,237,248)";node.color3="rgb(223,237,248)"}if(shp=="image"){if(js.id=="1287"){node.imagePath=js.type=="1"?CanvasXpress.images.mitochondria2:CanvasXpress.images.mitochondria}else{node.imagePath=CanvasXpress.images[loc[js.id]]}}for(var p in js){if(p.toLowerCase()=="appearance"){for(var a in js[p][0]){vk=js[p][0][a].split(": ");switch(vk[0]){case"String":node[a]=vk[1];break;case"Integer":case"Double":node[a]=Number(vk[1]);break;case"Boolean":node[a]=vk[1]=="true"?true:false;break}}}}nodes.push(node);sord.push(n++);if(Number(js.id)==16){var mem=getMembrane(node);if(mem.length){for(var k=0;k<mem.length;k++){nodes.push(mem[k]);sord.push(n++)}}}}}break;case"nodes":for(var j=0;j<el.childNodes.length;j++){var nd=el.childNodes[j];if(nd.nodeName&&nd.nodeName.toLowerCase()=="node"){var js=this.XMLToJSON(nd);var node={};for(var p in js){if(p.toLowerCase()=="alt"){if(js[p][0].match(/\w/)){node.tooltip=js[p][0]}}if(p.toLowerCase()=="appearance"){for(var a in js[p][0]){vk=js[p][0][a].split(":");switch(vk[0]){case"String":node[a]=vk[1].replace(/\s/g,"");break;case"Integer":case"Double":node[a]=Number(vk[1].replace(/\s/g,""));break;case"Boolean":node[a]=vk[1].replace(/\s/g,"")=="true"?true:false;break;case"Rectangle":node[a]=vk[1].replace(/\s/g,"").split(",").map(Number);break;case"Color":node[a]=vk[1].replace(/\s/g,"").split(",").map(Number);node[a][3]=Math.round(node[a][3]/255*10)/10;node[a]="rgba("+node[a].join(",")+")";break;case"Font":node[a]=vk[1].replace(/\s/g,"").split(",");break}}}node[p]=js[p]=="true"?true:js[p]=="false"?false:!isNaN(js[p])?Number(js[p]):js[p]}node.extId=js.id;node.id=js.nodeid.toString();node.x=Number(js.x)+(Number(js.width)*0.5);node.y=Number(js.y)+(Number(js.height)*0.5);node.width=Number(js.width);node.height=Number(js.height);if(node.iconarea){node.width=node.iconarea[2];node.height=node.iconarea[3];node.x=node.iconarea[0]+(node.width*0.5);node.y=node.iconarea[1]+(node.height*0.5);delete node.iconarea}if(js.icontype&&(js.type==0||js.type==16)){if(isNaN(js.icontype)){js.icontype=1000}if(Number(js.icontype)<10){js.icontype="0"+js.icontype}if(CanvasXpress.images.hasOwnProperty(js.icontype)){node.zoomX=50/node.width;node.zoomY=50/node.height;node.shape="image";node.imagePath=CanvasXpress.images[js.icontype]}else{node.shape="roundrect"}}else{if(js.icontype){switch(js.type){case"-10":node.width-=5;node.height-=5;node.x+=2.5;node.y+=2.5;node.shape=node.arcwidth>40?"roundrecto":"roundrect";break;case"21":case"61":case"63":case"91":case"-11":case"-12":node.width-=4;node.height-=4;node.x+=2;node.y+=2;node.shape="roundrect";break;default:break}}else{node.shape="roundrect"}}if(node.name==""){node.hideLabel=true}if(node.textarea){var lines=1;if(node.font){lines=Math.floor(node.textarea[3]/(Number(node.font[2])+(Number(node.font[2])>12?1:0)));node.labelSize=node.font[2]==14?1.1:1;if(node.font[0].match(/Bold Italic/i)){node.labelStyle="Bold Italic"}else{if(node.font[0].match(/Bold/i)){node.labelStyle="Bold"}else{if(node.font[0].match(/Italic/i)){node.labelStyle="Italic"}}}}if(lines>1&&!node.name.toString().match(/\n/)){var fnt=this.nodeFontStyle+" "+Math.floor(10*node.labelSize)+"px "+this.fontName;var tst=Math.floor(node.textarea[2]/5.5);var wrp=this.wrapText(node.name,tst);var lns=wrp.split(/\n/);var max=this.measureTextMultiple(wrp,fnt);if(lns.length>lines){while(lns.length>lines&&tst<node.name.toString().length){wrp=this.wrapText(node.name,tst++);lns=wrp.split(/\n/);max=this.measureTextMultiple(wrp,fnt)}}if(max>node.textarea[2]){wrp=wrp.replace("(","\n(");lns=wrp.split(/\n/);max=this.measureTextMultiple(wrp,fnt);while((max>node.textarea[2]||lns.length*fnt>node.textarea[3]||lns.length<lines)&&tst>3){wrp=this.wrapText(node.name,tst--);lns=wrp.split(/\n/);max=this.measureTextMultiple(wrp,fnt)}}node.name=wrp}else{if(lines==0){node.hideLabel=true}}node.labelX=node.textarea[0]+(node.textarea[2]*0.5);node.labelY=node.textarea[1]+(node.textarea[3]*0.5)}if(node.textalignment!=null){if(node.textalignment==0){node.labelAlign="left";node.labelX-=(node.textarea[2]*0.45)}else{if(node.textalignment==1){node.labelAlign="center"}else{if(node.textalignment==2){node.labelAlign="right";node.labelX+=(node.textarea[2]*0.45)}}}}delete node.textarea;if(node.fontcolor){node.labelColor=node.fontcolor;delete node.fontcolor}if(node.backgroundcolor){node.color=node.backgroundcolor;delete node.backgroundcolor}if(node.bordercolor){node.outline=node.bordercolor;delete node.bordercolor}if(node.rotateangle){node.rotate=node.shape=="image"?-node.rotateangle:270-node.rotateangle;if(node.shape!="image"){node.labelRotate=-node.rotateangle}delete node.rotateangle}if(node.borderwidth){node.outlineWidth=Number(node.borderwidth)-1;delete node.borderwidth}seen[node.id]=n;delete node.appearance;delete node.icontype;nodes.push(node);sord.push(n++);if(node.complex){nodes.push({id:node.id+"-complex",x:node.x,y:node.y,width:14,height:14,shape:"star",color:"rgb(255,255,255)",hideLabel:true,zorder:node.zorder+1,parentNode:node.id});seen[node.id+"-complex"]=n;sord.push(n++);delete node.complex}if(node.pathstart){var rot=0;var ptx=0;var pty=0;switch(node.sideofpathstarteditor){case 0:rot=90;pty=-(40+node.pathstartarrowmargin);break;case 1:rot=180;ptx=(40+node.pathstartarrowmargin);break;case 2:rot=270;pty=(40+node.pathstartarrowmargin);break;case 3:rot=0;ptx=-(40+node.pathstartarrowmargin);break}nodes.push({id:node.id+"-pathstart",x:node.x+ptx,y:node.y+pty,width:40,height:40,shape:"image",imagePath:CanvasXpress.images["99"],hideLabel:true,rotate:rot,zorder:node.zorder+1,parentNode:node.id});seen[node.id+"-pathstart"]=n;sord.push(n++);delete node.sideofpathstarteditor;delete node.pathstartarrowmargin;delete node.pathstart}if(node.organismspecificobject){nodes.push({id:node.id+"-organism",x:node.x,y:node.y,width:60,height:60,shape:"circle",color:"rgba(0,0,0,0.1)",outline:"rgb(255,255,0)",outlineWidth:3,hideLabel:true,zorder:node.zorder-1,parentNode:node.id});seen[node.id+"-organism"]=n;sord.push(n++);delete node.organismspecificobject}}}break;case"edges":for(var j=0;j<el.childNodes.length;j++){var ed=el.childNodes[j];if(ed.nodeName&&ed.nodeName.toLowerCase()=="edge"){var js=this.XMLToJSON(ed);var edge={};for(var p in js){if(p.toLowerCase()=="alt"){continue}if(p.toLowerCase()=="appearance"){for(var a in js[p][0]){if(a=="linkhighlighting"){vk=js[p][0][a].split(":");if(vk[1]=="Color"&&vk[2]){vk[2]=vk[2].split(",");vk[2].pop();edge.highlight="rgb("+vk[2].join(",")+")"}}else{vk=js[p][0][a].split(": ");switch(vk[0]){case"String":edge[a]=vk[1];break;case"Integer":case"Double":edge[a]=Number(vk[1]);break;case"Boolean":edge[a]=vk[1]=="true"?true:false;break;case"Rectangle":edge[a]=vk[1].replace(/\s/g,"").split(",").map(Number);break;case"PointArray":var cp=[];vk[1]=vk[1].replace(/\s/g,"").split(";");for(var k=0;k<vk[1].length-1;k++){cp.push(vk[1][k].split(",").map(Number))}edge[a]=cp;break}}}}edge[p]=js[p]=="true"?true:js[p]=="false"?false:!isNaN(js[p])?Number(js[p]):js[p]}edge.id1=js.src;edge.id2=js.dst;if(edge.type){edge.EdgeType=edge.type;delete edge.type}if(edge.directed){edge.endArrow="arrow";delete edge.directed}edge.color="grey";edge.type=edge.enhances?"dashed":"solid";if(edge.visualization=="Round"){edge.type="quadratic";edge.angle=edge.angle}else{if(edge.visualization=="Bezier"){edge.type="bezier";edge.angle=edge.angle}}if(edge.hasOwnProperty("effect")){if(edge.effect>=0){switch(edge.effect){case 0:edge.color="rgb(152,156,158)";break;case 1:edge.color="rgb(0,128,0)";break;case 2:edge.color="rgb(170,0,0)";break}}if(edge.mech!=null){var dec={};if(edge.showhexagon){var col=edge.hexagoncustomcolor||edge.color;var idx=edge.hexagonindex||0;var pos=edge.hexagoncoordinate||0.5;var cll=edge.effect==0?"black":"rgb(242,216,0)";var getDec=function(lbl){return{label:lbl,labelColor:cll,shape:"hexagon",color:col,index:idx,pos:pos}};switch(edge.mech){case -1:dec=getDec("");break;case 0:dec=getDec("?");break;case 2:dec=getDec("CM");break;case 3:dec=getDec("+P");break;case 4:dec=getDec("-P");break;case 5:dec=getDec("B");break;case 6:dec=getDec("Cn");break;case 7:dec=getDec("T");break;case 8:dec=getDec("C");break;case 9:dec=getDec("TR");break;case 10:dec=getDec("GR");dec.labelColor="white";dec.color="rgb(0,0,170)";break;case 11:dec=getDec("CR");break;case 12:dec=getDec("IE");break;case 14:dec=getDec("CS");dec.labelColor="white";dec.color="rgb(0,0,170)";break;case 15:dec=getDec("Z");break;case 16:dec=getDec("Tn");break;case 20:dec=getDec("cRT");break;case 21:dec=getDec("PE");break;case 22:dec=getDec("TE");break;case 24:dec=getDec("M");break;case 31:dec=getDec("SR");break;case 44:dec=getDec("RG");break;default:dec=getDec("");break}if(dec.label!=""){edge.decoration=[dec]}}delete edge.effect;delete edge.mech;delete edge.hexagonindex;delete edge.hexagoncoordinate;delete edge.showhexagon;delete edge.hexagoncustomcolor}}if(edge.broken){if(!edge.decoration){edge.decoration=[]}edge.decoration.push({label:"X",labelColor:"purple",fontSize:20,shape:"square",color:"rgba(0,0,0,0)",index:(edge.brokenindex||0),pos:(edge.brokencoordinate||0.5)});delete edge.broken;delete edge.brokenindex;delete edge.brokencoordinate}if(edge.weakens){if(!edge.decoration){edge.decoration=[]}edge.decoration.push({label:"-x-",labelColor:"purple",fontSize:12,shape:"square",color:"rgba(0,0,0,0)",index:(edge.weakensindex||0),pos:(edge.weakenscoordinate||0.5)});delete edge.weakens;delete edge.weakensindex;delete edge.weakenscoordinate}if(edge.disease){edge.color="purple";edge.thickness=2;delete edge.disease}if(edge.enhances){edge.color="purple";edge.thickness=2;delete edge.enhances}delete edge.appearance;delete edge.src;delete edge.dst;if(seen.hasOwnProperty(edge.id1)&&seen.hasOwnProperty(edge.id2)){var src=nodes[seen[edge.id1]];var dst=nodes[seen[edge.id2]];var sx=src.x;var sy=src.y;var sw=src.width*0.5;var sh=src.height*0.5;var ex=0;var ey=0;var dx=dst.x;var dy=dst.y;var dw=dst.width*0.5;var dh=dst.height*0.5;var ss,sd,sq,ds,dd,dq,xy,cx,cy,rd,frs,lst,n1;if(edge.visualization&&edge.visualization=="Right angle polyline"){ss=edge.linksourcepointindex?Math.floor((edge.linksourcepointindex-1)/src.linkpointcount):-1;sd=edge.linksourcepointindex?(edge.linksourcepointindex-(src.linkpointcount*ss))/(src.linkpointcount+1):0;if(edge.firstleg&&edge.firstleg=="Vertical"){frs=edge.controlpoints?edge.controlpoints[0][1]:false;sy=frs&&frs[1]>0?sy+sh:src.y>dst.y?sy-sh:frs&&frs<0?sy-sh:sy+sh;if(ss==0||ss==2){sx=(sx-sw)+(src.width*sd)}else{if(ss==1){sx=sx+sw}else{if(ss==3){sx=sx-sw}}}sq="tb"}else{frs=edge.controlpoints?edge.controlpoints[0][0]:false;sx=frs&&frs>0?sx+sw:src.x>dst.x?sx-sw:frs&&frs<0?sx-sw:sx+sw;if(ss==1||ss==3){sy=(sy-sh)+(src.height*sd)}else{if(ss==0){sy=sy-sh}else{if(ss==2){sy=sy+sh}}}sq="lr"}ds=edge.linktargetpointindex?Math.floor((edge.linktargetpointindex-1)/dst.linkpointcount):-1;dd=edge.linktargetpointindex?(edge.linktargetpointindex-(dst.linkpointcount*ds))/(dst.linkpointcount+1):0;if(!edge.controlpoints){if(edge.firstleg&&edge.firstleg=="Vertical"){dx=src.x>dst.x?dx+dw:dx-dw;if(ds==1||ds==3){dy=(dy-dh)+(dst.height*dd)}}else{dy=src.y>dst.y?dy+dh:dy-dh;if(ds==0||ds==2){dx=(dx-dw)+(dst.width*dd)}}}else{dq=edge.controlpoints.length%2?sq:sq=="tb"?"lr":"tb";n1=edge.controlpoints.length-1;lst=edge.controlpoints[n1];if(edge.linktargetpointindex){if(ds==1||ds==3){if(src.x+lst[0]>dst.x){dx+=dw}else{dx-=dw}dy=(dy-dh)+(dst.height*dd)}else{if(ds==0||ds==2){dx=(dx-dw)+(dst.width*dd);if(src.y+lst[1]>dst.y){dy+=dh}else{dy-=dh}}}}else{if(edge.controlpoints.length%2){if(sq==dq&&sq=="lr"){if(src.x+lst[0]>dst.x){dx+=dw}else{dx-=dw}}}else{dx=src.x+lst[0]>dst.x?dx+dw:dx-dw}if(edge.controlpoints.length%2){if(sq!=dq||sq!="lr"){dy=src.y+lst[1]>dst.y?dy+dh:dy-dh}}else{if(src.y+lst[1]>dst.y){dy=dy+dh}}}}if(edge.controlpoints){edge.elbows=[[sx,sy]];cx=sx;cy=sy;if(edge.firstleg&&edge.firstleg=="Vertical"){for(var k=0;k<edge.controlpoints.length;k++){if(k%2){cx=sx+edge.controlpoints[k][0]}else{cy=sy+edge.controlpoints[k][1]}edge.elbows.push([cx,cy])}if(edge.controlpoints.length%2){edge.elbows.push([dx,cy])}else{edge.elbows.push([cx,dy])}}else{for(var k=0;k<edge.controlpoints.length;k++){if(k%2){cy=sy+edge.controlpoints[k][1]}else{cx=sx+edge.controlpoints[k][0]}edge.elbows.push([cx,cy])}if(edge.controlpoints.length%2){edge.elbows.push([cx,dy])}else{edge.elbows.push([dx,cy])}}edge.elbows.push([dx,dy])}else{if(edge.firstleg&&edge.firstleg=="Vertical"){edge.elbows=[[sx,sy],[sx,dy],[dx,dy]]}else{edge.elbows=[[sx,sy],[dx,sy],[dx,dy]]}}}else{if(edge.controlpoints&&edge.linksourcepointindex!=null&&edge.linktargetpointindex!=null&&edge.id1!=edge.id2){if(edge.linksourcepointindex||edge.controlpoints){frs=edge.controlpoints?edge.controlpoints[0]:[0,0];if(edge.linksourcepointindex==0){ds=getLengthToNodeBoundary(sx,sy,sx+frs[0],sy+frs[1],src);xy=this.getCoordinateAtDistance(sx,sy,sx+frs[0],sy+frs[1],ds);rd=this.getRadians(sx,sy,sx+frs[0],sy+frs[1]);sx=xy[0];sy=xy[1];ex=(-ds*-Math.cos(rd));ey=ds*Math.sin(rd)}else{ss=Math.floor((edge.linksourcepointindex-1)/src.linkpointcount);sd=(edge.linksourcepointindex-(src.linkpointcount*ss))/(src.linkpointcount+1);switch(ss){case 0:ex=(src.width*sd);ey=0;sx=ex+sx-sw;sy=sy-sh;break;case 1:ex=0;ey=(src.height*sd);sx=sx+sw;sy=ey+sy-sh;break;case 2:ex=(src.width*sd);ey=0;sx=ex+sx-sw;sy=sy+sh;break;case 3:ex=0;ey=(src.height*sd);sx=sx-sw;sy=ey+sy-sh;break}}}if(edge.linktargetpointindex||edge.controlpoints){lst=edge.controlpoints?this.cloneObject(edge.controlpoints[edge.controlpoints.length-1]):[0,0];if(edge.linktargetpointindex==0){if(edge.controlpoints){lst[0]=dx-(sx+lst[0]);lst[1]=dy-(sy+lst[1])}ds=getLengthToNodeBoundary(dx,dy,dx+lst[0],dy+lst[1],dst);xy=this.getCoordinateAtDistance(dx,dy,dx+lst[0],dy+lst[1],-ds);rd=this.getRadians(dx,dy,dx+lst[0],dy+lst[1]);dx=xy[0];dy=xy[1]}else{ds=Math.floor((edge.linktargetpointindex-1)/dst.linkpointcount);dd=(edge.linktargetpointindex-(dst.linkpointcount*ds))/(dst.linkpointcount+1);switch(ds){case 0:dx=(dst.width*dd)+dx-dw;dy=dy-dh;break;case 1:dx=dx+dw;dy=(dst.height*dd)+dy-dh;break;case 2:dx=(dst.width*dd)+dx-dw;dy=dy+dh;break;case 3:dx=dx-dw;dy=(dst.height*dd)+dy-dh;break}}}edge.elbows=[];for(var k=0;k<edge.controlpoints.length;k++){edge.elbows.push([sx+edge.controlpoints[k][0]+5,sy+edge.controlpoints[k][1]])}edge.elbows.unshift([sx,sy]);edge.elbows.push([dx,dy])}else{if(edge.id1==edge.id2){ss=edge.linksourcepointindex?Math.floor((edge.linksourcepointindex-1)/src.linkpointcount):-1;ds=edge.linktargetpointindex?Math.floor((edge.linktargetpointindex-1)/dst.linkpointcount):-1;if(ss==ds){edge.self={dir:edge.angle>0,pos:(ss==0?"top":ss==1?"right":ss=2?"bottom":"left"),size:20,end:"arrow"}}else{if(ss>ds||(ss==0&&ds==3)){edge.self={dir:edge.angle>0,pos:(ss==0?"topLeft":ss=1?"topRight":ss==2?"bottomRight":"bottomLeft"),size:20,end:"arrow"}}else{if(ds>ss||(ds==0&&ss==3)){edge.self={dir:edge.angle>0,pos:(ss==0?"topRight":ss==1?"bottomRight":ss==2?"bottomLeft":"topLeft"),size:20,end:"arrow"}}}}}else{if(edge.linksourcepointindex){ss=edge.linksourcepointindex?Math.floor((edge.linksourcepointindex-1)/src.linkpointcount):-1;sd=edge.linksourcepointindex?(edge.linksourcepointindex-(src.linkpointcount*ss))/(src.linkpointcount+1):0;if(ss==0||ss==2){sx=(sx-sw)+(src.width*sd)}else{sy=(sy-sh)+(src.height*sd)}}if(edge.linktargetpointindex){ds=edge.linktargetpointindex?Math.floor((edge.linktargetpointindex-1)/dst.linkpointcount):-1;dd=edge.linktargetpointindex?(edge.linktargetpointindex-(dst.linkpointcount*ds))/(dst.linkpointcount+1):0;if(ds==0||ds==2){dx=(dx-dw)+(dst.width*dd)}else{dy=(dy-dh)+(dst.height*dd)}}if(edge.linksourcepointindex||edge.linktargetpointindex){if(edge.linksourcepointindex){switch(ss){case 0:sy-=sh;break;case 1:sx+=sw;break;case 2:sy+=sh;break;case 3:sx-=sw;break}if(!edge.linktargetpointindex){ds=getLengthToNodeBoundary(dx,dy,sx,sy,dst);xy=this.getCoordinateAtDistance(dx,dy,sx,sy,ds);dx=xy[0];dy=xy[1]}else{switch(ds){case 0:dy-=dh;break;case 1:dx+=dw;break;case 2:dy+=dh;break;case 3:dx-=dw;break}}}else{switch(ds){case 0:dy-=dh;break;case 1:dx+=dw;break;case 2:dy+=dh;break;case 3:dx-=dw;break}ds=getLengthToNodeBoundary(sx,sy,dx,dy,src);xy=this.getCoordinateAtDistance(sx,sy,dx,dy,ds);sx=xy[0];sy=xy[1]}edge.elbows=[[sx,sy],[dx,dy]]}}}}delete edge.linksourcepointindex;delete edge.linktargetpointindex;delete edge.controlpoints;delete edge.visualization;delete firstleg;edges.push(edge)}}}break}}}sord.sort(function(a,b){if(nodes[a].zorder-nodes[b].zorder==0){return a-b}else{return nodes[a].zorder-nodes[b].zorder}});var tmp=[];for(var i=0;i<sord.length;i++){tmp.push(nodes[sord[i]])}nodes=tmp}else{alert("Ooops! Not a Metabase xgmml file!")}var res="Number of Nodes: "+nodes.length+"\nNumber of Edges: "+edges.length+"\n";res=res.replace(/\n/g,"<br>");var data={data:{nodes:nodes,edges:edges},config:{adjustBezier:false,graphType:"Network",calculateLayout:false,showAnimation:false,networkNodesOnTop:false,showNodeNameThreshold:20000,networkFreeze:true,preScaleNetwork:false,nodeFontSize:10,moveParentsWithChildren:true,ignoreEventlessOrder:true},renderTo:target,uploadFile:true,afterRender:[["flashInfoSpan",[100,100,res,5000]]]};var clbk=false;var rurl=this.dataURL;var cnfg=this.cloneObject(this.meta.config.user);if(this.graphType=="Network"){for(var p in this.meta.config.user){data.config[p]=this.meta.config.user[p]}clbk=function(t){t.meta.config.remote={data:rurl,config:cnfg}}}this.updateRemoteData(data,clbk);this.hideMask()};this.parseGML=function(gml){var forIn=function(object,callback){Object.keys(object).forEach(function(key){callback(key,object[key])})};var json=("{\n"+gml+"\n}").replace(/^(\s*)(\w+)\s*\[/gm,'$1"$2": {').replace(/^(\s*)\]/gm,"$1},").replace(/^(\s*)(\w+)\s+(.+)$/gm,'$1"$2": $3,').replace(/,(\s*)\}/g,"$1}");var graph={};var nodes=[];var edges=[];var i=0;json=json.replace(/^(\s*)"node"/gm,function(all,indent){return(indent+'"node['+(i++)+']"')});i=0;json=json.replace(/^(\s*)"edge"/gm,function(all,indent){return(indent+'"edge['+(i++)+']"')});try{json=this.parseJSON(json)}catch(err){throw new SyntaxError("bad format")}if(!this.isObject(json.graph)){throw new SyntaxError("no graph tag")}forIn(json.graph,function(key,value){var matches=key.match(/^(\w+)\[(\d+)\]$/);var name;var i;if(matches){name=matches[1];i=parseInt(matches[2],10);if(name==="node"){nodes[i]=value}else{if(name==="edge"){edges[i]=value;edges[i].id1=edges[i].source;edges[i].id2=edges[i].target;delete (edges[i].source);delete (edges[i].target)}else{graph[key]=value}}}else{graph[key]=value}});graph.nodes=nodes;graph.edges=edges;return{data:graph,config:{graphType:"Network"}}};this.arrayToCanvasXpress=function(arr){var unique=function(a){return a.filter(function(x,i){return a.indexOf(x)===i})};var data={y:{vars:[],smps:[],data:[]}};var g="Scatter2D";var cols=arr[0].filter(Number);if(cols.length==0){cols=arr.shift()}else{cols=[];for(var i=0;i<arr[0].length;i++){cols.push("C"+(i+1))}}var rows=[];for(var i=0;i<arr.length;i++){rows.push(arr[i][0].toString())}var urow=unique(rows);if(urow.length==rows.length){for(var i=0;i<arr.length;i++){arr[i].shift(arr[i][0])}}else{rows=[];for(var i=0;i<arr.length;i++){rows.push("R"+(i+1))}}if(cols.length>arr[0].length){cols.shift();if(!cols.length==arr[0].length){return false}}if(arr[0].length!=arr[arr.length-1].length){arr.pop();rows.pop();if(arr[0].length!=arr[arr.length-1].length){return false}}var types=[];for(var i=0;i<cols.length;i++){types[i]=false;for(var j=0;j<rows.length;j++){if(isNaN(arr[j][i])){types[i]=true;break}}if(!types[i]){for(var j=0;j<rows.length;j++){arr[j][i]=Number(arr[j][i])}}else{data.z={}}}for(var i=0;i<rows.length;i++){data.y.data[i]=[];data.y.vars.push(rows[i])}for(var i=0;i<cols.length;i++){if(types[i]){data.z[cols[i]]=[];for(var j=0;j<rows.length;j++){data.z[cols[i]].push(arr[j][i])}}else{data.y.smps.push(cols[i]);for(var j=0;j<rows.length;j++){data.y.data[j].push(arr[j][i])}}}if(data.y.smps.length==0){var n=data.y.data.length;data.y.data=[[]];for(var i=0;i<n;i++){data.y.data[0].push(1)}data.y.smps=data.y.vars;data.y.vars=["counts"];data.x=data.z;delete (data.z);g="Bar"}else{if(data.y.smps.length==1){var trp=function(mat){return mat[0].map(function(_,c){return mat.map(function(r){return r[c]})})};data.y.data=trp(data.y.data);data.y.vars=data.y.smps;data.y.smps=rows;data.x=data.z;delete (data.z);g="Bar"}}return{data:data,config:{graphType:g}}};this.getRDatasets=function(){var setRDataSets=function(t){return function(r){t.Rdatasets=t.parseJSON(r)}}(this);var url=this.RdatasetsURL+"datasets.json";this.ajaxRequest(url,false,setRDataSets)};this.getRLibraryDataSets=function(s){this.getDataSetListFromURL(this.RdatasetsURL+"json/"+s+"/datasets.json")};this.appendNetworkDataFromURL=function(){var url=this.appendNetworkData.length>0?this.appendNetworkData.shift():false;var appendData=function(t){return function(r){if(url.match(/\.txt$/)||url.match(/\.csv$/)||url.match(/\.tsv$/)||url.match(/\.tab$/)){var tc=0;var tt=0;if(r.match(/,/g)){tc=r.match(/,/g).length}if(r.match(/\t/g)){tt=r.match(/\t/g).length}var dl=url.match(/\.csv$/)&&tc>tt?",":"\t";var data=t.delimitedToArray(r,dl,false,true);if(data&&!t.isArray(data)){var fail="";if(data.fail>0){fail=data.fail+" records couldn't be mapped to network data"}t.flashInfoSpan(100,150,data.rows+" "+data.type+" records added to network data\n"+fail,5000);var cn=t.meta.config.user;var at=["colorNodeBy","shapeNodeBy","sizeNodeBy","patternNodeBy","colorEdgeBy","SizeEdgeBy","decorations"];for(var i=0;i<at.length;i++){var a=at[i];if(cn.hasOwnProperty(a)){t[a]=cn[a]}}if(data.type=="node"){t.appendNodeData(data.data)}else{t.appendEdgeData(data.data)}if(t.appendNetworkData.length>0){t.appendNetworkDataFromURL()}else{t.draw();t.hideMask()}}}else{t.hideMask();alert("Oooops! Not a CanvasXpress Network delimited file")}}}(this);if(url){if(this.isValidURL(url.toString())){this.ajaxRequest(url,false,appendData)}else{if(url.type=="node"){this.appendNodeData(url.data)}else{this.appendEdgeData(url.data)}if(this.appendNetworkData.length>0){this.appendNetworkDataFromURL()}else{this.draw();this.hideMask()}}}};this.getDataFromURL=function(target,config,events,info,callback){if(this.dataURL){var that=this;var isJSON=function(s){try{that.parseJSON(s)}catch(e){return false}return true};var format=this.dataURL.match(/\.png$/)?"arraybuffer":false;var setData=function(t){return function(r){var data;t.remoteService=t.dataURL;t.remoteServiceType="file";if(isJSON(r)){data=t.parseJSON(r);if(Array.isArray(data)){return t.setDataSetsFromURL(r)}}else{if(t.dataURL.match(/\.png$/)){data=t.parseDataFromPNG(r)}else{if(t.dataURL.match(/\.svg$/)){data=t.SVGtoCX(r)}else{if(t.dataURL.match(/\.txt$/)||t.dataURL.match(/\.csv$/)||t.dataURL.match(/\.tsv$/)||t.dataURL.match(/\.tab$/)){data=t.delimitedToArray(r,false,true)}else{if(t.dataURL.match(/\ml$/)){var xml=t.parseXML(r);var ts1=xml.childNodes[0];var ts2=xml.childNodes[2];var trg=target?target:t.newId("cX-data-url-");if(ts1.tagName&&ts1.tagName.toLowerCase()=="map"){return t.metabaseToCX(xml,trg)}else{if(ts1.tagName&&ts1.tagName.toLowerCase()=="graph"){return t.cytoscapeToCX(xml,trg)}else{if(ts1.tagName&&ts1.tagName.toLowerCase()=="pathway"){return t.wikipathwayToCX(xml,trg)}else{if(ts2&&ts2.tagName&&ts2.tagName.toLowerCase()=="pathway"){return t.keggToCX(xml,trg)}}}}}}}}}data.records=0;data.renderTo=target?target:data.renderTo?data.renderTo:t.newId("cX-data-url-");data.config=config?config:data.config?data.config:{graphType:"Scatter2D"};if(data.config.graphType=="Network"){data.config.appendNetworkData=t.appendNetworkData}data.events=events?events:data.events?data.events:false;data.info=info?info:data.info?data.info:false;if(!data.afterRender){data.afterRender=[]}if(data.config.graphType=="Network"){data.afterRender.push(["appendNetworkDataFromURL",[]])}var rurl=t.dataURL;var cnfg=t.cloneObject(t.meta.config.user);t.updateRemoteData(data,function(that){that.meta.config.remote={data:rurl,config:cnfg};if(callback){callback()}})}}(this);this.ajaxRequest(this.dataURL,false,setData,format)}};this.getDataSetListFromURL=function(u){this.remoteService=u;this.ajaxRequest(u,false,this.setDataSetsFromURL)};this.setDataSetsFromURL=function(t){return function(r){var setDataSetsFromURLRemote=function(t){return function(r){var obj=n.parseJSON(r);n.updateRemoteData({data:obj,ids:n.remoteIds,records:n.remoteIds.length})}}(n);var getParentId=function(){var par=t.$("container-"+t.target).parentNode;while(par.id.match("canvasXpressRemoteWindow")){par=par.parentNode}if(!par.id){par.id=t.newId("-cX-data-sets-url-container-")}return par.id};var obj=t.parseJSON(r);var url=obj[0][1];var ids=[];for(var i=0;i<obj.length;i++){ids.push(obj[i][0])}var pid=getParentId();var par=t.$("container-"+t.target).parentNode;var cid=t.newId("cX-data-sets-");var cnv=t.$cX("canvas",{id:cid,width:t.originalWidth,height:t.originalHeight});t.castCanvasAttributes(cnv);par.appendChild(cnv);var n=new CanvasXpress(cid,false,{remoteService:t.remoteService});t.remoteIds=ids;t.destroy(t.target);n.remoteData=obj;n.remoteParentId=pid;n.remoteIds=ids;n.remoteServiceType="file";n.ajaxRequest(url,false,setDataSetsFromURLRemote)}}(this);this.dumpToConsole=function(o){console.log(this.target);console.log(this.prettyJSON(o))};this.initVocabulary=function(){if(!CanvasXpress.vocabulary){CanvasXpress.vocabulary={}}if(!CanvasXpress.vocabulary.n){CanvasXpress.vocabulary.n=0;CanvasXpress.vocabulary.byId=[];CanvasXpress.vocabulary.byStr={}}};this.getLeafletCanvas=function(){if(this.isMap){var c=this.meta.leaflet.ctx;var w=this.width;var h=this.height;var cw=c.canvas.width;var ch=c.canvas.height;var dw=parseInt((cw-w)/2);var dh=parseInt((ch-h)/2);var img=c.getImageData(dw,dh,w,h);var cnv=document.createElement("canvas");cnv.width=w;cnv.height=h;var ctx=cnv.getContext("2d");ctx.putImageData(img,0,0);return cnv}};this.initStack=function(data,config,events,info){if(!CanvasXpress.stack){CanvasXpress.stack={}}if(navigator.onLine&&!CanvasXpress.geo){this.setClientGeo()}var cnv=this.$(this.target);if(cnv){if(this.graphType=="Map"&&config.leafletInit){config.leafletInitString=config.leafletInit.toString()}CanvasXpress.stack[this.target]={version:CanvasXpress.factory.version,renderTo:this.target,data:data?this.parseJSON(this.stringifyJSON(data)):false,config:config?this.parseJSON(this.stringifyJSON(config)):false,events:events?this.parseJSON(this.stringifyJSON(events)):false,info:info?this.parseJSON(this.stringifyJSON(info)):false,afterRender:[["setDimensions",[cnv.originalWidth,cnv.originalHeight,true]]],state:[],stateIndex:0}}};this.getStack=function(){return CanvasXpress.stack[this.target].afterRender};this.diffConfigState=function(idx1,idx2){var s={};var d={idx1:{},idx2:{}};var c1=CanvasXpress.stack[this.target].state[idx1];var c2=CanvasXpress.stack[this.target].state[idx2];for(var c in c1){if(c2.hasOwnProperty(c)){if(!this.isSameObject(c1[c],c2[c])){d.idx1[c]=c1[c]}else{s[c]=true}}else{d.idx1[c]=c1[c]}}for(var c in c2){if(!s.hasOwnProperty(c)){if(c1.hasOwnProperty(c)){if(!this.isSameObject(c1[c],c2[c])){d.idx2[c]=c2[c]}}else{d.idx2[c]=c2[c]}}}return d};this.getConfigState=function(){var skip={meta:true,animationOn:true,arrows:true,beaconImage:true,bubble:true,changingColorItemOn:true,changingColorOn:true,changingSliderItemOn:true,currentCanvasContext:true,draggingOn:true,doubleClick:true,edgeConfigurableProperties:true,events:true,featureConfigurableProperties:true,functionCaller:true,functionCallerDraw:true,functions:true,images:true,info:true,infoStartTime:true,isHighlightCanvas:true,isTransitionCanvas:true,isTransitionOn:true,keyOn:true,lastCanvasEvent:true,lastMousemove:true,lines:true,moveSankey:true,movingOn:true,nodeConfigurableProperties:true,nodes:true,panningOn:true,patterns:true,resetOn:true,resizeCanvasCursorShow:true,shapes:true,sizes:true,skipClick:true,skipTransition:true,times:true,touchEvent:true,touches:true,trackConfigurableProperties:true,transitionIter:true,userId:true,validGraphTypes:true,vennCompartments:true,xMouseDown:true,yMouseDown:true};if(this.graphType!="Network"){skip.data=true}var config={};for(var c in this){if(!this.isFunction(this[c])&&!skip.hasOwnProperty(c)){config[c]=this.isObject(this[c])?this.cloneObject(this[c],true):this[c]}}return config};this.setConfigState=function(idx){if(!idx){idx=0}var config=CanvasXpress.stack[this.target].state[idx];for(var c in config){this[c]=config[c]}var tmp={calculateLayout:this.calculateLayout};this.calculateLayout=false;this.skipStack=true;this.draw();this.skipStack=false;for(var c in tmp){this[c]=tmp[c]}};this.stack=function(){if(!this.skipStack){var d=arguments.callee.caller.caller;var f=d.fname;var s=this.getConfigState();var t=new Date().getTime();if(d&&f){var a=this.cleanEventInArguments(Array.from(d.arguments));var n=CanvasXpress.stack[this.target].afterRender.length;switch(f){case"setDimensions":if(a&&a[0]==this.width&&a[1]==this.height){return}if(a&&a[4]){f="clickGraphMaxMin";a=[false,this.maximized]}CanvasXpress.stack[this.target].afterRender.push([f,a,{},t]);break;case"sortSamples":case"sortSamplesByCategory":case"sortSamplesByVariable":case"sortVariables":case"sortVariablesByCategory":case"sortVariablesBySample":CanvasXpress.stack[this.target].afterRender.push([f,a,{sortDir:this.sortDir},t]);break;case"desegregate":CanvasXpress.stack[this.target].afterRender.push([f,a,{segregateSamplesBy:this.segregateSamplesBy,segregateVariablesBy:this.segregateVariablesBy},t]);break;case"broadcastDraw":case"segregateSamplesVariables":d=d.caller;f=d.fname;a=this.cleanEventInArguments(Array.from(d.arguments));CanvasXpress.stack[this.target].afterRender.push([f,a,{},t]);break;case"updateDataFilter":CanvasXpress.stack[this.target].afterRender.push([f,[true],{toDoFilter:this.toDoFilter},t]);break;case"endCanvasResizer":CanvasXpress.stack[this.target].afterRender.push(["setDimensions",Array.from(arguments.callee.caller.arguments),{},t]);break;case"drawIndicesAfterWheelEvent":var u=CanvasXpress.stack[this.target].afterRender;var q=CanvasXpress.stack[this.target].state;if(n>1&&u[n-1][0]=="drawIndicesAfterWheelEvent"){var l=t-u[n-1][3];if(l<1000){u.pop();q.pop()}}CanvasXpress.stack[this.target].afterRender.push([f,a,{varIndicesStart:this.varIndicesStart,smpIndicesStart:this.smpIndicesStart},t]);break;case"drawRangesAfterWheelEvent":var u=CanvasXpress.stack[this.target].afterRender;var q=CanvasXpress.stack[this.target].state;if(n>1&&u[n-1][0]=="drawRangesAfterWheelEvent"){var l=t-u[n-1][3];if(l<1000){u.pop();q.pop()}}CanvasXpress.stack[this.target].afterRender.push([f,a,{},t]);break;case"drawIndicesAfterPannEvent":var u=CanvasXpress.stack[this.target].afterRender;var q=CanvasXpress.stack[this.target].state;if(n>1&&u[n-1][0]=="drawIndicesAfterPannEvent"){var l=t-u[n-1][3];if(l<1000){u.pop();q.pop()}}CanvasXpress.stack[this.target].afterRender.push([f,a,{varIndicesStart:this.varIndicesStart,smpIndicesStart:this.smpIndicesStart},t]);break;case"updateDragScatter":var u=CanvasXpress.stack[this.target].afterRender;var q=CanvasXpress.stack[this.target].state;if(n>1&&u[n-1][0]=="updateDragScatter"&&!a[0].shiftKey){var l=t-u[n-1][3];if(l<1000){u.pop();q.pop()}}CanvasXpress.stack[this.target].afterRender.push([f,a,{moveLegend:this.moveLegend,moveLegendX:this.moveLegendX,moveLegendY:this.moveLegendY,moveLegendCurX:this.moveLegendCurX,moveLegendCurY:this.moveLegendCurY},t]);break;case"updateDragGenome":var u=CanvasXpress.stack[this.target].afterRender;var q=CanvasXpress.stack[this.target].state;if(n>1&&u[n-1][0]=="updateDragGenome"&&!a[0].shiftKey){var l=t-u[n-1][3];if(l<1000){u.pop();q.pop()}}CanvasXpress.stack[this.target].afterRender.push([f,a,{moveGenome:this.moveGenome,setMinX:this.setMinX,setMaxX:this.setMaxX,xMouseDown:this.xMouseDown},t]);break;case"updateDragNetwork":var u=CanvasXpress.stack[this.target].afterRender;var q=CanvasXpress.stack[this.target].state;if(n>1&&u[n-1][0]=="updateDragNetwork"&&!a[0].shiftKey){var l=t-u[n-1][3];if(l<1000){u.pop();q.pop()}}CanvasXpress.stack[this.target].afterRender.push([f,a,{moveLegend:this.moveLegend,moveLegendX:this.moveLegendX,moveLegendY:this.moveLegendY,moveEdge:this.moveEdge,moveEdgeIndex:this.moveEdgeIndex,moveEdgeElbow:this.moveEdgeElbow,moveNode:this.moveNode,moveNodeIndex:this.moveNodeIndex,moveNodeLab:this.moveNodeLab,moveNodeDec:this.moveNodeDec,moveNodeW:this.moveNodeW,moveNodeH:this.moveNodeH,moveNodeX:this.moveNodeX,moveNodeY:this.moveNodeY,xMouseDown:this.xMouseDown,yMouseDown:this.yMouseDown},t]);break;case"handleDragEventOneDimension":CanvasXpress.stack[this.target].afterRender.push([f,a,{moveDendrogram:this.moveDendrogram,moveVarOverlay:this.moveVarOverlay,moveVar:this.moveVar,moveSmpOverlay:this.moveSmpOverlay,moveSmp:this.moveSmp},t]);break;case"updateDragCircular":var u=CanvasXpress.stack[this.target].afterRender;var q=CanvasXpress.stack[this.target].state;if(n>1&&u[n-1][0]=="updateDragCircular"&&!a[0].shiftKey){var l=t-u[n-1][3];if(l<1000){u.pop();q.pop()}}CanvasXpress.stack[this.target].afterRender.push([f,a,{circularRotate:this.circularRotate,moveCircular:this.moveCircular,panningX:this.panningX,panningY:this.panningY,xMouseDown:this.xMouseDown,yMouseDown:this.yMouseDown},t]);break;case"resortSankey":var u=CanvasXpress.stack[this.target].afterRender;var q=CanvasXpress.stack[this.target].state;if(n>1&&u[n-1][0]=="resortSankey"){var l=t-u[n-1][3];if(l<1000){u.pop();q.pop()}}CanvasXpress.stack[this.target].afterRender.push([f,a,{moveSankey:this.moveSankey,moveSankeyY:this.moveSankeyY,moveSankeyMin:this.moveSankeyMin,moveSankeyOrder:this.moveSankeyOrder},t]);break;default:CanvasXpress.stack[this.target].afterRender.push([f,a,{},t]);break}if(CanvasXpress.stack[this.target].stateIndex<CanvasXpress.stack[this.target].state.length-1){CanvasXpress.stack[this.target].state.splice(CanvasXpress.stack[this.target].stateIndex,CanvasXpress.stack[this.target].state.length-1)}this.meta.stack.push([f,this.meta.time.start,this.meta.time.elapsed]);CanvasXpress.stack[this.target].state.push(s);CanvasXpress.stack[this.target].stateIndex=CanvasXpress.stack[this.target].state.length-1}}};this.reproduce=function(t){return function(e,p){if(!e){e=window.event}t.skipStack=true;t.reproducing=true;t.resetMenus();t.resetLinks();t.addMotionDiv(e);if((e&&e.shiftKey)||p){t.clickMotion(e)}}}(this);this.setFunctionNames("initInterface")};CanvasXpress.prototype.initConfig=function(a){this.setConfigDefaults=function(){var b=CanvasXpress.config;this.graphType="Bar";b.push("graphType");this.graphOrientation="horizontal";b.push("graphOrientation");this.transparency=null;b.push("transparency");this.transparencyHidden=0.1;b.push("transparencyHidden");this.canvasBox=false;b.push("canvasBox");this.canvasBoxColor="rgb(204,204,204)";b.push("canvasBoxColor");this.plotBox=false;b.push("plotBox");this.plotBoxColor="rgb(204,204,204)";b.push("plotBoxColor");this.invertGraph=false;b.push("invertGraph");this.loadImagesTimeOut=100;b.push("loadImagesTimeOut");this.isR=false;b.push("isR");this.isReproducibleResearch=true;b.push("isReproducibleResearch");this.reproduceTime=50;b.push("reproduceTime");this.printType="download";b.push("printType");this.printMagnification=1;b.push("printMagnification");this.printThumbnail=false;b.push("printThumbnail");this.higlightGreyOut=false;b.push("higlightGreyOut");this.higlightGreyOutTransparency=0.67;b.push("higlightGreyOutTransparency");this.theme="none";b.push("theme");this.useVocabulary=false;b.push("useVocabulary");this.fullTextMeasureCheck=500;b.push("fullTextMeasureCheck");this.showFunctionNamesAfterRender=false;b.push("showFunctionNamesAfterRender");this.saveFilename=false;b.push("saveFilename");this.skipRender=false;b.push("skipRender");this.functions=[];this.gradient=false;b.push("gradient");this.gradientType="radial";b.push("gradientType");this.gradientOrientation="vertical";b.push("gradientOrientation");this.gradientRatio=1.3;b.push("gradientRatio");this.adjustAspectRatio=true;b.push("adjustAspectRatio");this.percentAspectRatioPlotArea=0.5;b.push("percentAspectRatioPlotArea");this.variableSpaceFactor=2;b.push("variableSpaceFactor");this.sampleSpaceFactor=1;b.push("sampleSpaceFactor");this.widthFactor=1;b.push("widthFactor");this.dataPointSize=28;b.push("dataPointSize");this.adjustAspectRatioMax=3;this.adjustAspectRatioYTries=0;this.adjustAspectRatioXTries=0;this.foreground="rgb(0,0,0)";b.push("foreground");this.background="rgb(255,255,255)";b.push("background");this.backgroundWindow="rgb(244,244,244)";b.push("backgroundWindow");this.backgroundType="solid";b.push("backgroundType");this.backgroundImage=false;b.push("backgroundImage");this.backgroundVideo=false;b.push("backgroundVideo");this.backgroundGradient1Color="rgb(0,0,200)";b.push("backgroundGradient1Color");this.backgroundGradient2Color="rgb(0,0,36)";b.push("backgroundGradient2Color");this.margin=5;b.push("margin");this.marginLeft=5;b.push("marginLeft");this.marginTop=5;b.push("marginTop");this.marginBottom=5;b.push("marginBottom");this.marginRight=5;b.push("marginRight");this.showShadow=false;b.push("showShadow");this.showTextShadow=false;b.push("showTextShadow");this.shadowOffsetX=1;b.push("shadowOffsetX");this.shadowOffsetY=1;b.push("shadowOffsetY");this.shadowBlur=2;b.push("shadowBlur");this.shadowColor="rgba(0,0,0,0.5)";b.push("shadowColor");this.topoJSON=false;b.push("topoJSON");this.leafletLayer=true;b.push("leafletLayer");this.leafletJS=["https://canvasxpress.org/js/topojson.v2.js","https://canvasxpress.org/js/leaflet.js"];b.push("leafletJS");this.leafletCSS=["https://canvasxpress.org/css/leaflet.css"];b.push("leafletCSS");this.leafletInit=false;b.push("leafletInit");this.leafletInitString=false;b.push("leafletInitString");this.leafletId=false;b.push("leafletId");this.leafletConfig=false;b.push("leafletConfig");this.isMap=false;this.videoControls=true;b.push("videoControls");this.videoAutoplay=true;b.push("videoAutoplay");this.videoLoop=false;b.push("videoLoop");this.videoPreload="none";b.push("videoPreload");this.videoData="{}";b.push("videoData");this.videoPoster="";b.push("videoPoster");this.videoClassName="video-js vjs-default-skin";b.push("videoClassName");this.videoPlaybackRate=1;b.push("videoPlaybackRate");this.videoCurrentTime=false;b.push("videoCurrentTime");this.videoGrid=false;b.push("videoGrid");this.videoGridStep=10;b.push("videoGridStep");this.videoColor="rgb(255,0,0)";b.push("videoColor");this.fontName="Arial";b.push("fontName");this.fontStyle="";b.push("fontStyle");this.fontSize=12;b.push("fontSize");this.fontScaleFontFactor=1;b.push("fontScaleFontFactor");this.align="center";b.push("align");this.baseline="middle";b.push("baseline");this.maxTextSize=40;b.push("maxTextSize");this.minTextSize=4;b.push("minTextSize");this.autoScaleFont=true;b.push("autoScaleFont");this.scaleTextConstantMult=30;this.scaleTextConstantAdd=2;this.title=false;b.push("title");this.titleAlign="center";b.push("titleAlign");this.titleFontSize=16;b.push("titleFontSize");this.titleColor="rgb(0,0,0)";b.push("titleColor");this.titleScaleFontFactor=1;b.push("titleScaleFontFactor");this.titleFontStyle="";b.push("titleFontStyle");this.subtitle=false;b.push("subtitle");this.subtitleAlign="center";b.push("subtitleAlign");this.subtitleFontSize=14;b.push("subtitleFontSize");this.subtitleColor="rgb(0,0,0)";b.push("subtitleColor");this.subtitleScaleFontFactor=1;b.push("subtitleScaleFontFactor");this.subtitleFontStyle="";b.push("subtitleFontStyle");this.citation=false;b.push("citation");this.citationColor="rgb(0,0,0)";b.push("citationColor");this.citationFontStyle="";b.push("citationFontStyle");this.citationFontSize=7;b.push("citationFontSize");this.citationScaleFontFactor=1;b.push("citationScaleFontFactor");this.dashLength=8;b.push("dashLength");this.dotLength=1;b.push("dotLength");this.arrowPointSize=9;b.push("arrowPointSize");this.arrowQuadraticFactor=2.3;b.push("arrowQuadraticFactor");this.capType="butt";b.push("capType");this.joinType="mitter";b.push("joinType");this.lineWidthEvent=2;this.outlineWidth=1;b.push("outlineWidth");this.lineThickness=1;b.push("lineThickness");this.adjustBezier=false;b.push("adjustBezier");this.lines=["line","solid","straight","bezier","curved","curvedCC","dashedLine","dashedBezier","dashedCurved","dashedCurvedCC","dottedLine","dottedBezier","dottedCurved","dottedCurvedCC","blank","dashed","dotted","dotdash","longdash","twodash"];this.arrows=["arrow","square","round"];this.colorScheme="User";b.push("colorScheme");this.colors=["#fe296c","#487eb6","#a7ce31","#f8cc03","#ff8c02","#699696","#b77844","#83acd0","#c2e076","#fadc5a","#ff549f","#ffaf54","#9ab8b7","#d2a683","#3d699b","#87ac22","#cda908","#d02158","#d07300","#567676"];b.push("colors");this.colorHSV=[0,0,1];this.colorRGB=[1,1,1];this.colorSpectrum=["#4575b4","#91bfdb","#e0f3f8","#ffffbf","#fee090","#fc8d59","#d73027"];b.push("colorSpectrum");this.colorSpectrumBreaks=[];b.push("colorSpectrumBreaks");this.colorSpectrumZeroValue=null;b.push("colorSpectrumZeroValue");this.colorSpectrumNumber=100;b.push("colorSpectrumNumber");this.colorSpectrumTarget=10;b.push("colorSpectrumTarget");this.oddColor=this.background;b.push("oddColor");this.evenColor="rgb(245,245,245)";b.push("evenColor");this.blindnessType=false;b.push("blindnessType");this.shapes=["sphere","square","triangle","star","rhombus","octagon","oval","plus","minus","pacman","pacman2","mdavid","rect2","pentagon","rect3","arc","rectangle","image"];b.push("shapes");this.sizes=[16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46];b.push("sizes");this.images=[];b.push("images");this.patterns=["solid","hatchForward","hatchReverse","stripeHorizontal","stripeVertical","polkaDot","crossHatch","crossStripe","squares","circles","plus","minus","bars","squiglesVertical","squiglesHorizontal","brickForward","brickReverse","art","pcx","hatchForward3","hatchReverse3"];b.push("patterns");this.maxSmpStringLen=30;b.push("maxSmpStringLen");this.smpLabelDescription=false;b.push("smpLabelDescription");this.smpTitle=false;b.push("smpTitle");this.smpTitleFontStyle="";b.push("smpTitleFontStyle");this.smpTitleFontSize=12;b.push("smpTitleFontSize");this.smpTitleFontColor=this.foreground;b.push("smpTitleFontColor");this.smpTitleScaleFontFactor=1;b.push("smpTitleScaleFontFactor");this.smpLabelFontStyle="";b.push("smpLabelFontStyle");this.smpLabelFontSize=12;b.push("smpLabelFontSize");this.smpLabelFontColor=this.foreground;b.push("smpLabelFontColor");this.smpLabelScaleFontFactor=1;b.push("smpLabelScaleFontFactor");this.smpLabelRotate=0;b.push("smpLabelRotate");this.smpLabelInterval=1;b.push("smpLabelInterval");this.showSampleNames=true;b.push("showSampleNames");this.highlightSmp=[];b.push("highlightSmp");this.smpHighlightColor="rgb(255,0,0)";b.push("smpHighlightColor");this.maxVarStringLen=30;b.push("maxVarStringLen");this.varLabelDescription=false;b.push("varLabelDescription");this.varTitle=false;b.push("varTitle");this.varTitleFontStyle="";b.push("varTitleFontStyle");this.varTitleFontSize=12;b.push("varTitleFontSize");this.varTitleFontColor=this.foreground;b.push("varTitleFontColor");this.varTitleScaleFontFactor=1;b.push("varTitleScaleFontFactor");this.varLabelFontStyle="";b.push("varLabelFontStyle");this.varLabelFontSize=12;b.push("varLabelFontSize");this.varLabelFontColor=this.foreground;b.push("varLabelFontColor");this.varLabelScaleFontFactor=1;b.push("varLabelScaleFontFactor");this.varLabelRotate=0;b.push("varLabelRotate");this.varLabelInterval=1;b.push("varLabelInterval");this.showVariableNames=true;b.push("showVariableNames");this.highlightVar=[];b.push("highlightVar");this.varHighlightColor="rgb(255,0,0)";b.push("varHighlightColor");this.binConfigurations={};b.push("binConfigurations");this.maxOverlayStringLen=30;b.push("maxOverlayStringLen");this.overlaysThickness=18;b.push("overlaysThickness");this.smpOverlays=[];b.push("smpOverlays");this.smpOverlayProperties={};b.push("smpOverlayProperties");this.smpOverlaysLegendColumns=1;b.push("smpOverlaysLegendColumns");this.showSmpOverlaysLegend=false;b.push("showSmpOverlaysLegend");this.varOverlays=[];b.push("varOverlays");this.varOverlayProperties={};b.push("varOverlayProperties");this.varOverlaysLegendColumns=1;b.push("varOverlaysLegendColumns");this.showVarOverlaysLegend=false;b.push("showVarOverlaysLegend");this.overlaysLegendPosition="topRight";b.push("overlaysLegendPosition");this.showOverlays=true;b.push("showOverlays");this.showLevelOverlays=true;b.push("showLevelOverlays");this.overlayFontStyle="";b.push("overlayFontStyle");this.overlayFontSize=12;b.push("overlayFontSize");this.overlayFontColor=this.foreground;b.push("overlayFontColor");this.overlayScaleFontFactor=1;b.push("overlayScaleFontFactor");this.showLegend=true;b.push("showLegend");this.showLegendTitle=true;b.push("showLegendTitle");this.legendColumns=1;b.push("legendColumns");this.legendPosition="right";b.push("legendPosition");this.legendInside=false;b.push("legendInside");this.legendColor=this.foreground;b.push("legendColor");this.legendBox=true;b.push("legendBox");this.legendBoxColor="rgb(204,204,204)";b.push("legendBoxColor");this.legendBackgroundColor=this.background;b.push("legendBackgroundColor");this.legendFontStyle="";b.push("legendFontStyle");this.legendFontSize=12;b.push("legendFontSize");this.legendScaleFontFactor=1;b.push("legendScaleFontFactor");this.legendOrder=false;b.push("legendOrder");this.legend=[];b.push("legend");this.showDecorations=true;b.push("showDecorations");this.showDecorationsLegend=true;b.push("showDecorationsLegend");this.decorationsPosition="bottom";b.push("decorationsPosition");this.decorationsColor=this.foreground;b.push("decorationsColor");this.decorationsBox=true;b.push("decorationsBox");this.decorationsBoxColor="rgb(204,204,204)";b.push("decorationsBoxColor");this.decorationsBackgroundColor=this.background;b.push("decorationsBackgroundColor");this.decorationFontStyle="";b.push("decorationFontStyle");this.decorationFontSize=12;b.push("decorationFontSize");this.decorationScaleFontFactor=1;b.push("decorationScaleFontFactor");this.decorationsWidth=20;b.push("decorationsWidth");this.decorationsHeight=40;b.push("decorationsHeight");this.decorationsType="bar";b.push("decorationsType");this.decorations=false;b.push("decorations");this.decorationsColors=[];b.push("decorationsColors");this.decorationsProperties={};b.push("decorationsProperties");this.isGroupedData=false;this.isBoxPlotCalc=false;this.isMarketDataFormated=false;this.isMarketSwitched=false;this.groupingFactors=[];b.push("groupingFactors");this.segregateSamplesBy=[];b.push("segregateSamplesBy");this.segregateVariablesBy=[];b.push("segregateVariablesBy");this.summaryType=false;b.push("summaryType");this.isTransformedData=false;this.transformBase=10;this.transformedData=false;b.push("transformedData");this.transformType=false;b.push("transformType");this.transformAxis="samples";b.push("transformAxis");this.ratioReference=0;b.push("ratioReference");this.ratioSampleReference=false;b.push("ratioSampleReference");this.ratioGroupReference=false;b.push("ratioGroupReference");this.ratioLevelReference="";b.push("ratioLevelReference");this.transposeData=false;b.push("transposeData");this.asSampleFactors=[];b.push("asSampleFactors");this.asVariableFactors=[];b.push("asVariableFactors");this.stringSampleFactors=[];b.push("stringSampleFactors");this.stringVariableFactors=[];b.push("stringVariableFactors");this.asHistogram=false;b.push("asHistogram");this.appendNetworkData=[];b.push("appendNetworkData");this.timeFormat="isoDate";b.push("timeFormat");this.isGraphTime=false;b.push("isGraphTime");this.timeValues=[];this.timeValueIndices=[];this.timeTicksFirst=false;b.push("timeTicksFirst");this.sortDir="ascending";b.push("sortDir");this.sortCaseSensitive=false;b.push("sortCaseSensitive");this.sort=[];b.push("sort");this.smpSort=-1;this.varSort=-1;this.tmpAsciiArray=[];this.missingDataColor="rgb(204,204,204)";b.push("missingDataColor");this.missingDataValue="NA";b.push("missingDataValue");this.showErrorBars=true;b.push("showErrorBars");this.errorBarsType="confidenceInterval95";b.push("errorBarsType");this.errorBarsColor="rgb(0,0,0)";b.push("errorBarsColor");this.errorBarsThickness=3;b.push("errorBarsThickness");this.errorBarsWidth=2;b.push("errorBarsWidth");this.standardDeviationType="unbiased";b.push("standardDeviationType");this.showRegressionFullRange=false;b.push("showRegressionFullRange");this.regressionType="linear";b.push("regressionType");this.regressionOrder=2;b.push("regressionOrder");this.showConfidenceIntervals=true;b.push("showConfidenceIntervals");this.confidenceLevel=0.95;b.push("confidenceLevel");this.confidenceIntervalColor="rgb(50,50,50)";b.push("confidenceIntervalColor");this.fitLineColor="rgb(255,215,0)";b.push("fitLineColor");this.fitLineStyle="solid";b.push("fitLineStyle");this.randomSeed=8;b.push("randomSeed");this.pseudoRandom=true;b.push("pseudoRandom");this.randomData=false;this.randomDataDistribution="biased";b.push("randomDataDistribution");this.randomDataTime=false;b.push("randomDataTime");this.randomDataMin=1;b.push("randomDataMin");this.randomDataMax=100;b.push("randomDataMax");this.randomDataMean=0;b.push("randomDataMean");this.randomDataSigma=1;b.push("randomDataSigma");this.randomDataVariables=3;b.push("randomDataVariables");this.randomDataSamples=36;b.push("randomDataSamples");this.randomDataVariableAnnotations=2;b.push("randomDataVariableAnnotations");this.randomDataSampleAnnotations=2;b.push("randomDataSampleAnnotations");this.randomMissingDataPercentage=0;b.push("randomMissingDataPercentage");this.randomNetworkReduce=true;b.push("randomNetworkReduce");this.randomNetworkNodes=40;b.push("randomNetworkNodes");this.randomNetworkNodeEdgesMax=5;b.push("randomNetworkNodeEdgesMax");this.randomNetworkAll=true;b.push("randomNetworkAll");this.randomNetworkLayout="forceLayout";b.push("randomNetworkLayout");this.zoom=1;b.push("zoom");this.zoomGlobal=1;this.zoomStep=0.2;b.push("zoomStep");this.zoomScale=true;b.push("zoomScale");this.zoomVariablesDisable=false;b.push("zoomVariablesDisable");this.zoomSamplesDisable=false;b.push("zoomSamplesDisable");this.zoomDisable=false;b.push("zoomDisable");this.panningX=0;b.push("panningX");this.panningY=0;b.push("panningY");this.panningGlobalX=0;this.panningGlobalY=0;this.panningStep=0.2;b.push("panningStep");this.resizerBackgroundColor=CanvasXpress.system.isIE?"rgb(204,204,204)":"rgba(204,204,204,0.7)";b.push("resizerBackgroundColor");this.xAxisAbsMax=null;this.xAxisAbsMin=null;this.xAxisMaxStrLength=false;this.setMaxX=null;b.push("setMaxX");this.setMinX=null;b.push("setMinX");this.xAxisCurrent=0;b.push("xAxisCurrent");this.xAxisTitle=false;b.push("xAxisTitle");this.xAxis=[];b.push("xAxis");this.xAxisTickStyle="solid";b.push("xAxisTickStyle");this.xAxisTickFormat=false;b.push("xAxisTickFormat");this.xAxisTickColor="rgb(204,204,204)";b.push("xAxisTickColor");this.xAxisExact=false;b.push("xAxisExact");this.xAxisValues=[];this.xAxisValuesRaw=[];this.xAxisMinorValues=[];this.xAxisTransform=false;b.push("xAxisTransform");this.xAxisCeilValue=null;b.push("xAxisCeilValue");this.xAxisFloorValue=null;b.push("xAxisFloorValue");this.xAxisTransformTicks=true;b.push("xAxisTransformTicks");this.xAxisShow=true;b.push("xAxisShow");this.xAxisS2Show=false;b.push("xAxisS2Show");this.xAxisTicks=5;b.push("xAxisTicks");this.xAxisMinorTicks=true;b.push("xAxisMinorTicks");this.xAxisMajorTicks=true;b.push("xAxisMajorTicks");this.xAxisLeftMajorTick=true;b.push("xAxisLeftMajorTick");this.xAxisRightMajorTick=true;b.push("xAxisRightMajorTick");this.xAxisLeftRightTickColor="rgb(204,204,204)";b.push("xAxisLeftRightTickColor");this.xAxisHistogramShow=false;b.push("xAxisHistogramShow");this.xAxisHistogramHeight=80;b.push("xAxisHistogramHeight");this.xAxis2AbsMax=null;this.xAxis2AbsMin=null;this.xAxis2MaxStrLength=false;this.setMaxX2=null;b.push("setMaxX2");this.setMinX2=null;b.push("setMinX2");this.xAxis2Title=false;b.push("xAxis2Title");this.xAxis2=[];b.push("xAxis2");this.xAxis2TickFormat=false;b.push("xAxis2TickFormat");this.xAxis2Values=[];this.xAxis2ValuesRaw=[];this.xAxis2MinorValues=[];this.xAxis2Show=true;b.push("xAxis2Show");this.xAxis2Ticks=null;this.yAxisAbsMax=null;this.yAxisAbsMin=null;this.yAxisMaxStrLength=false;this.setMaxY=null;b.push("setMaxY");this.setMinY=null;b.push("setMinY");this.yAxisCurrent=0;b.push("yAxisCurrent");this.yAxisTitle=false;b.push("yAxisTitle");this.yAxis2Title=false;b.push("yAxis2Title");this.yAxis=[];b.push("yAxis");this.yAxisTickStyle="solid";b.push("yAxisTickStyle");this.yAxisTickFormat=false;b.push("yAxisTickFormat");this.yAxisTickColor="rgb(204,204,204)";b.push("yAxisTickColor");this.yAxisExact=false;b.push("yAxisExact");this.yAxisValues=[];this.yAxisValuesRaw=[];this.yAxisMinorValues=[];this.yAxisTransform=false;b.push("yAxisTransform");this.yAxisCeilValue=null;b.push("yAxisCeilValue");this.yAxisFloorValue=null;b.push("yAxisFloorValue");this.yAxisTransformTicks=true;b.push("yAxisTransformTicks");this.yAxisShow=true;b.push("yAxisShow");this.yAxis2Show=false;b.push("yAxis2Show");this.yAxisTicks=5;b.push("yAxisTicks");this.yAxisMinorTicks=true;b.push("yAxisMinorTicks");this.yAxisMajorTicks=true;b.push("yAxisMajorTicks");this.yAxisTopMajorTick=true;b.push("yAxisTopMajorTick");this.yAxisBottomMajorTick=true;b.push("yAxisBottomMajorTick");this.yAxisTopBottomTickColor="rgb(204,204,204)";b.push("yAxisTopBottomTickColor");this.yAxisHistogramShow=false;b.push("yAxisHistogramShow");this.yAxisHistogramHeight=80;b.push("yAxisHistogramHeight");this.zAxisAbsMax=null;this.zAxisAbsMin=null;this.zAxisMaxStrLength=false;this.setMaxZ=null;b.push("setMaxZ");this.setMinZ=null;b.push("setMinZ");this.zAxisCurrent=0;b.push("zAxisCurrent");this.zAxisTitle=false;b.push("zAxisTitle");this.zAxis=[];b.push("zAxis");this.zAxisTickStyle="solid";b.push("zAxisTickStyle");this.zAxisTickFormat=false;b.push("zAxisTickFormat");this.zAxisTickColor="rgb(204,204,204)";b.push("zAxisTickColor");this.zAxisExact=false;b.push("zAxisExact");this.zAxisValues=[];this.zAxisValuesRaw=[];this.zAxisMinorValues=[];this.zAxisTransform=false;b.push("zAxisTransform");this.zAxisCeilValue=null;b.push("zAxisCeilValue");this.zAxisFloorValue=null;b.push("zAxisFloorValue");this.zAxisTransformTicks=true;b.push("zAxisTransformTicks");this.zAxisShow=true;b.push("zAxisShow");this.zAxisTicks=10;this.rAxisAbsMax=null;this.rAxisAbsMin=null;this.rAxisMaxStrLength=false;this.rAxisTickFormat=false;b.push("rAxisTickFormat");this.rAxisTickColor=this.foreground;b.push("rAxisTickColor");this.rAxisValues=[];b.push("rAxisValues");this.rAxisValuesRaw=[];this.rAxisMinorValues=[];b.push("rAxisMinorValues");this.rAxisPercentShow=true;b.push("rAxisPercentShow");this.rAxisShow=true;b.push("rAxisShow");this.rAxisLabelOrientation="perpendicular";b.push("rAxisLabelOrientation");this.rAxisTicks=5;b.push("rAxisTicks");this.rAxisMinorTicks=true;b.push("rAxisMinorTicks");this.rAxisMajorTicks=true;b.push("rAxisMajorTicks");this.axisTickColor=this.foreground;b.push("axisTickColor");this.axisTickThickness=1;b.push("axisTickThickness");this.axisMinMaxTickThickness=1;b.push("axisMinMaxTickThickness");this.axisTickFontStyle="";b.push("axisTickFontStyle");this.axisTickFontSize=12;b.push("axisTickFontSize");this.axisTickScaleFontFactor=1;b.push("axisTickScaleFontFactor");this.axisTitleColor=this.foreground;b.push("axisTitleColor");this.axisTitleFontStyle="";b.push("axisTitleFontStyle");this.axisTitleFontSize=12;b.push("axisTitleFontSize");this.axisTitleScaleFontFactor=1;b.push("axisTitleScaleFontFactor");this.axisExtension=0.1;b.push("axisExtension");this.axisAlgorithm="wilkinson";b.push("axisAlgorithm");this.axisWilkinsonLoose=false;b.push("axisWilkinsonLoose");this.setMax=null;this.setMin=null;this.guides=false;b.push("guides");this.guidesWidth=0.3;b.push("guidesWidth");this.guidesColor="rgb(204,204,204)";b.push("guidesColor");this.blockContrast=false;b.push("blockContrast");this.plotByVariable=false;b.push("plotByVariable");this.is3DPlot=false;b.push("is3DPlot");this.showDataValues=false;b.push("showDataValues");this.binned=false;b.push("binned");this.binAlignment="center";b.push("binAlignment");this.jitter=true;b.push("jitter");this.jitterColumns=7;b.push("jitterColumns");this.objectBorderColor="rgb(0,0,0)";b.push("objectBorderColor");this.lineDecoration="symbol";b.push("lineDecoration");this.lineErrorType="bar";b.push("lineErrorType");this.coordinateLineColor=false;b.push("coordinateLineColor");this.lineType="rect";b.push("lineType");this.tension=0.3;b.push("tension");this.tensionSegments=16;b.push("tensionSegments");this.parallelCoordinates=[];this.boxplotOutliersRatio=8;b.push("boxplotOutliersRatio");this.boxplotWishkersType="double";b.push("boxplotWishkersType");this.boxplotNotched=false;b.push("boxplotNotched");this.boxplotCoef=1.5;b.push("boxplotCoef");this.boxplotHingeFunction="summary";b.push("boxplotHingeFunction");this.showBoxplotOriginalData=false;b.push("showBoxplotOriginalData");this.showViolinBoxplot=false;b.push("showViolinBoxplot");this.violinTrim=true;b.push("violinTrim");this.violinScale="area";b.push("violinScale");this.showBoxplotIfViolin=true;b.push("showBoxplotIfViolin");this.boxplotWidthRatioIfViolin=0.33;b.push("boxplotWidthRatioIfViolin");this.boxplotDataPointTransparency=0.5;b.push("boxplotDataPointTransparency");this.boxplotMedianColor="rgb(0,0,0)";b.push("boxplotMedianColor");this.boxplotMedianWidth=1;b.push("boxplotMedianWidth");this.boxplotMean=false;b.push("boxplotMean");this.boxplotMeanColor="rgb(255,215,0)";b.push("boxplotMeanColor");this.boxplotMeanColorBorder="rgb(255,0,0)";b.push("boxplotMeanColorBorder");this.boxplotConnect=false;b.push("boxplotConnect");this.boxplotConnectWidth=2;b.push("boxplotConnectWidth");this.areaType="normal";b.push("areaType");this.dotplotType="normal";b.push("dotplotType");this.barType="normal";b.push("barType");this.barLollipopFactor=3;b.push("barLollipopFactor");this.sankeyNodeWidth=20;b.push("sankeyNodeWidth");this.sankeyIterations=32;this.sankeySource=false;b.push("sankeySource");this.sankeyTarget=false;b.push("sankeyTarget");this.sankeyColor="rgba(150,150,150,0.5)";b.push("sankeyColor");this.sankeyCoordinateColor=false;b.push("sankeyCoordinateColor");this.hierarchy=[];b.push("hierarchy");this.hierarchyVar=false;b.push("hierarchyVar");this.hierarchyVarIndex=0;this.treeNodeSize=20;b.push("treeNodeSize");this.treeLinkColor="rgb(150,150,150)";b.push("treeLinkColor");this.treeLinkWidth=1;b.push("treeLinkWidth");this.treeCircular=false;b.push("treeCircular");this.treeInverted=false;b.push("treeInverted");this.treeVarIndex=0;b.push("treeVarIndex");this.treeNodeId=0;this.colorBy=false;b.push("colorBy");this.colorByShowLegend=true;b.push("colorByShowLegend");this.colorKey=false;b.push("colorKey");this.shapeBy=false;b.push("shapeBy");this.shapeByShowLegend=true;b.push("shapeByShowLegend");this.shapeKey=false;b.push("shapeKey");this.shapeByData=false;b.push("shapeByData");this.shapeByShape=false;b.push("shapeByShape");this.sizeBy=false;b.push("sizeBy");this.sizeByContinuous=false;b.push("sizeByContinuous");this.sizeByShowLegend=true;b.push("sizeByShowLegend");this.sizeKey=false;b.push("sizeKey");this.sizeByData=false;b.push("sizeByData");this.outlineBy=false;b.push("outlineBy");this.outlineByShowLegend=true;b.push("outlineByShowLegend");this.outlineByData=false;b.push("outlineByData");this.patternBy=false;b.push("patternBy");this.patternByShowLegend=true;b.push("patternByShowLegend");this.patternKey=false;b.push("patternKey");this.patternByData=false;b.push("patternByData");this.connectBy=false;b.push("connectBy");this.connectByColor="rgb(204,204,204)";b.push("connectByColor");this.connectByWidth=2;b.push("coonnectByWidth");this.connectByData={};this.treemapBy=[];b.push("treemapBy");this.motionBy=false;b.push("motionBy");this.ellipseBy=false;b.push("ellipseBy");this.motionWidth=250;b.push("motionWidth");this.motionCurrentColor="rgba(0,0,0,0.3)";b.push("motionCurrentColor");this.motionCurrentFontStyle="";b.push("motionCurrentFontStyle");this.motionCurrentFontSize=60;b.push("motionCurrentFontSize");this.motionCurrentScaleFontFactor=1;b.push("motionCurrentScaleFontFactor");this.scatterType=false;b.push("scatterType");this.scatterAxesEqual=false;b.push("scatterAxesEqual");this.scatterOutlineThreshold=50000;b.push("scatterOutlineThreshold");this.functionIntervals=25;b.push("functionIntervals");this.selectDataMode="area";b.push("selectDataMode");this.selectDataModeDescription=false;b.push("selectDataModeDescription");this.selectedDataPoints=[];b.push("selectedDataPoints");this.selectDataPoint={};this.hideDataPoint={};this.isSelectDataPoints=0;this.contourType="overlay";b.push("contourType");this.contourXBinSize=false;b.push("contourXBinSize");this.contourYBinSize=false;b.push("contourYBinSize");this.contourZBinSize=false;b.push("contourZBinSize");this.isHistogram=false;b.push("isHistogram");this.histogramBarWidth=false;this.histogramBins=false;b.push("histogramBins");this.histogramStagger=false;b.push("histogramStagger");this.showHistogramDensity=false;b.push("showHistogramDensity");this.showFilledHistogramDensity=false;b.push("showFilledHistogramDensity");this.histogramDensityFillTransparency=0.5;b.push("histogramDensityFillTransparency");this.showHistogramMedian=false;b.push("showHistogramMedian");this.histogramMedianLineStyle="dashed";b.push("histogramMedianLineStyle");this.hideHistogram=false;b.push("hideHistogram");this.histogramSizeEstimator="sturges";b.push("histogramSizeEstimator");this.isCreateHistogram=false;this.showScatterDensity=false;b.push("showScatterDensity");this.densityPixels=1000;b.push("densityPixels");this.densityKernel="gaussian";b.push("densityKernel");this.bandwidthRule="nrd0";b.push("bandwidthRule");this.bandwidthCut=3;b.push("bandwidthCut");this.loessDegree=2;b.push("loessDegree");this.loessSteps=30;b.push("loessSteps");this.loessSurfaceSteps=30;b.push("loessSurfaceSteps");this.loessBandwidth=0.8;b.push("loessBandwidth");this.loessSpan=0.8;b.push("loessSpan");this.loessIterations=1;this.loessAccuracy=1e-12;this.showLoessFit=false;b.push("showLoessFit");this.maxDOENumber=8;b.push("maxDOENumber");this.includeDOE=[];b.push("includeDOE");this.showDOEData=true;b.push("showDOEData");this.scatterPlotMatrix=false;b.push("scatterPlotMatrix");this.scatterPlotMatrixType="completeBoth";b.push("scatterPlotMatrixType");this.xRotate=45;b.push("xRotate");this.yRotate=0;b.push("yRotate");this.zRotate=0;b.push("zRotate");this.x3DRatio=1;b.push("x3DRatio");this.y3DRatio=1;b.push("y3DRatio");this.z3DRatio=1;b.push("z3DRatio");this.show3DGrid=true;b.push("show3DGrid");this.rotationSensitivity=450;b.push("rotationSensitivity");this.rotationStep=2;b.push("rotationStep");this.perspectiveFactor=2.2;b.push("perspectiveFactor");this.varIndicesStart=-1;this.smpIndicesStart=-1;this.isMultidimensionalData=false;this.heatmapAutoAdjust=false;b.push("heatmapAutoAdjust");this.heatmapCellBox=true;b.push("heatmapCellBox");this.heatmapCellBoxColor="rgb(220,220,220)";b.push("heatmapCellBoxColor");this.heatmapCellBoxWidth=0.5;b.push("heatmapCellBoxWidth");this.heatmapCellBoxColorHighlight="rgb(255,215,0)";b.push("heatmapCellBoxColorHighlight");this.heatmapCellBoxHighlightWidth=1;b.push("heatmapCellBoxHighlightWidth");this.heatmapSmpSeparateBy=false;b.push("heatmapSmpSeparateBy");this.heatmapVarSeparateBy=false;b.push("heatmapVarSeparateBy");this.heatmapSeparatorThickness=2.5;b.push("heatmapSeparatorThickness");this.varTitleLabelPosition="bottom";b.push("varTitleLabelPosition");this.showHeatmapIndicator=true;b.push("showHeatmapIndicator");this.heatmapIndicatorHeight=20;b.push("heatmapIndicatorHeight");this.heatmapIndicatorWidth=160;b.push("heatmapIndicatorWidth");this.adjustAspectRatioHeatmapIndicator=true;b.push("adjustAspectRatioHeatmapIndicator");this.heatmapIndicatorPosition="top";b.push("heatmapIndicatorPosition");this.heatmapIndicatorHistogram=false;b.push("heatmapIndicatorHistogram");this.heatmapIndicatorHistogramColor="rgb(0,255,255)";b.push("heatmapIndicatorHistogramColor");this.isOncoprint=false;b.push("isOncoprint");this.oncoprintCode=false;b.push("oncoprintCode");this.oncoprintAmplification=3;b.push("oncoprintAmplification");this.oncoprintDeletion=1;b.push("oncoprintDeletion");this.treemapBorderWidth=3;b.push("treemapBorderWidth");this.treemapBorderColor="rgb(204,204,204)";b.push("treemapBorderColor");this.correlationAxis="samples";b.push("correlationAxis");this.correlationAnchorLegend=false;b.push("correlationAnchorLegend");this.correlationAnchorLegendAlignWidth=40;b.push("correlationAnchorLegendAlignWidth");this.correlationLabelInterval=1;b.push("correlationLabelInterval");this.showVarDendrogram=true;b.push("showVarDendrogram");this.varDendrogramNewick=false;b.push("varDendrogramNewick");this.varDendrogramPosition="top";b.push("varDendrogramPosition");this.colorVarDendrogramBy=false;b.push("colorVarDendrogramBy");this.showSmpDendrogram=true;b.push("showSmpDendrogram");this.smpDendrogramNewick=false;b.push("smpDendrogramNewick");this.smpDendrogramPosition="left";b.push("smpDendrogramPosition");this.colorSmpDendrogramBy=false;b.push("colorSmpDendrogramBy");this.dendrogramHeight=50;b.push("dendrogramHeight");this.dendrogramColor="rgb(0,0,0)";b.push("dendrogramColor");this.distance="euclidian";b.push("distance");this.linkage="complete";b.push("linkage");this.clusterAxis="samples";this.kmeansVarClusters=3;b.push("kmeansVarClusters");this.kmeansSmpClusters=3;b.push("kmeansSmpClusters");this.maxIterations=100;b.push("maxIterations");this.imputeMethod="mean";b.push("imputeMethod");this.samplesClustered=false;b.push("samplesClustered");this.variablesClustered=false;b.push("variablesClustered");this.samplesKmeaned=false;b.push("samplesKmeaned");this.variablesKmeaned=false;b.push("variablesKmeaned");this.vennLegendColors=false;b.push("vennLegendColors");this.vennGroups=4;b.push("vennGroups");this.vennCompartments=["A","B","AB","C","AC","BC","ABC","D","AD","BD","CD","ABD","ACD","BCD","ABCD"];b.push("vennCompartments");this.vennColors=[];b.push("vennColors");this.pieType="separated";b.push("pieType");this.pieSegmentPrecision=0;b.push("pieSegmentPrecision");this.pieSegmentSeparation=1;b.push("pieSegmentSeparation");this.pieSegmentLabels="inside";b.push("pieSegmentLabels");this.pieLabelType="percentage";b.push("pieLabelType");this.maxPieSectors=20;b.push("maxPieSectors");this.showPieGrid=true;b.push("showPieGrid");this.showPieValues=true;b.push("showPieValues");this.showPieSampleLabel=true;b.push("showPieSampleLabel");this.startPieSectors=0;b.push("startPieSectors");this.pieInnerRadius=0;b.push("pieInnerRadius");this.pieColors=[];b.push("pieColors");this.circularType="normal";b.push("circularType");this.chordThickness=28;b.push("chordThickness");this.chordColor="source";b.push("chordColor");this.bubbleColor="rgba(150,150,150,0.33)";b.push("bubbleColor");this.circularCenterProportion=0.3;b.push("circularCenterProportion");this.arcSegmentsSeparation=8;b.push("arcSegmentsSeparation");this.circularRotate=0;b.push("circularRotate");this.circularArc=360;b.push("circularArc");this.ringSeparation=5;b.push("ringSeparation");this.ringGraphType=[];b.push("ringGraphType");this.ringGraphWeight=[];b.push("ringGraphWeight");this.arcSegmentsRadius=[];b.push("arcSegmentsRadius");this.ringsOrder=[];b.push("ringsOrder");this.rAxis=false;b.push("rAxis");this.rAxisZero=false;b.push("rAxisZero");this.showRingLegend=true;b.push("showRingLegend");this.showCircularConnections=true;b.push("showCircularConnections");this.connections=[];b.push("connections");this.circularLetterSeparationFactor=1.5;b.push("circularLetterSeparationFactor");this.circularConnectionsTransparency=0.5;b.push("circularConnectionsTransparency");this.smpLabelOrientation="perpendicular";b.push("smpLabelOrientation");this.circularLabelsAlign="outside";b.push("circularLabelsAlign");this.circularScalesAlign="inside";b.push("circularScalesAlign");this.circularAnchorsAlign="inside";b.push("circularAnchorsAlign");this.circularAnchors2Align="outside";b.push("circularAnchors2Align");this.circularDataPosition="distributed";b.push("circularDataPosition");this.circularAnchorLength=15;b.push("circularAnchorLength");this.circularAnchorColor="rgb(0,0,255)";b.push("circularAnchorColor");this.showIdeogram=false;b.push("showIdeogram");this.ideogram="hg19";b.push("ideogram");this.ideogramChromosome="chr";b.push("ideogramChromosome");this.ideogramChromosomePosition="pos";b.push("ideogramChromosomePosition");this.tagCloudTextWeightFactor=1;b.push("tagCloudTextWeightFactor");this.tagCloudTextGridSize=8;b.push("tagCloudTextGridSize");this.tagCloudTextEllipticity=0.65;b.push("tagCloudTextEllipticity");this.tagCloudTextRotateRatio=0.1;b.push("tagCloudTextRotateRatio");this.tagCloudGridPoints=[];this.showVolume=true;b.push("showVolume");this.stockIndicators=["Sma5","Sma10","Sma25"];b.push("stockIndicators");this.sma5Color="rgb(255,0,0)";b.push("sma5Color");this.sma10Color="rgb(0,255,0)";b.push("sma10Color");this.sma20Color="rgb(0,0,255)";b.push("sma20Color");this.sma25Color="rgb(255,0,255)";b.push("sma25Color");this.sma50Color="rgb(0,0,0)";b.push("sma50Color");this.calculateLayout=true;b.push("calculateLayout");this.networkFreeze=false;b.push("networkFreeze");this.networkFreezeOnLoad=false;b.push("networkFreezeOnLoad");this.preScaleNetwork=false;b.push("preScaleNetwork");this.ignoreEventlessOrder=false;b.push("ignoreEventlessOrder");this.subNetworks=false;this.networkLayoutType="forceDirected";b.push("networkLayoutType");this.networkRoot=false;b.push("networkRoot");this.showNetworkRadialLayout=false;b.push("showNetworkRadialLayout");this.networkDepth=0;this.networkDivisions=0;this.is3DNetwork=false;b.push("is3DNetwork");this.network2DRotate=0;this.networkNodesOnTop=true;b.push("networkNodesOnTop");this.moveParentsWithChildren=false;b.push("moveParentsWithChildren");this.highlightNode=[];b.push("highlightNode");this.nodeHighlightColor="rgb(255,0,0)";b.push("nodeHighlightColor");this.selectNode={};this.isSelectNodes=0;this.showNodeNameThreshold=50;b.push("showNodeNameThreshold");this.nodeSize=30;this.edgeThickness=1;b.push("edgeThickness");this.labelNodePosition="auto";b.push("labelNodePosition");this.nodeFontStyle="";b.push("nodeFontStyle");this.nodeFontSize=20;b.push("nodeFontSize");this.nodeFontColor=this.foreground;b.push("nodeFontColor");this.nodeScaleFontFactor=1;b.push("nodeScaleFontFactor");this.layoutTime=1500;this.networkForceConstant=null;this.initialTemperature=0;this.temperature=0;this.networkNodeMinDistance=4;b.push("networkNodeMinDistance");this.attractiveForceFunction="FruchtermanReingold";b.push("attractiveForceFunction");this.repulsiveForceFunction="square";b.push("repulsiveForceFunction");this.colorNodeBy=false;b.push("colorNodeBy");this.shapeNodeBy=false;b.push("shapeNodeBy");this.sizeNodeBy=false;b.push("sizeNodeBy");this.patternNodeBy=false;b.push("patternNodeBy");this.colorEdgeBy=false;b.push("colorEdgeBy");this.sizeEdgeBy=false;b.push("sizeEdgeBy");this.showNetworkCommunities=false;b.push("showNetworkCommunities");this.calculateNetworkCommunities=true;b.push("calculateNetworkCommunities");this.coordinateNetworkConvexHullCommunityColor=false;b.push("coordinateNetworkConvexHullCommunityColor");this.hullScale=1.25;b.push("hullScale");this.networkCommunities=null;this.networkConvexHulls=[];this.genomeTicks=50;b.push("genomeTicks");this.trackNameFontStyle="";b.push("trackNameFontStyle");this.trackNameFontSize=10;b.push("trackNameFontSize");this.trackNameFontColor=this.foreground;b.push("trackNameFontColor");this.trackFillColor=this.background;b.push("trackFillColor");this.trackDirColor=this.foreground;b.push("trackDirColor");this.subtracksMaxDefault=8;b.push("subtracksMaxDefault");this.showFeatureNameThereshold=20;b.push("showFeatureNameThereshold");this.featureNameFontStyle="";b.push("featureNameFontStyle");this.featureNameFontSize=10;b.push("featureNameFontSize");this.featureNameFontColor=this.foreground;b.push("featureNameFontColor");this.featureFillColor=this.background;b.push("featureFillColor");this.featureDirColor=this.foreground;b.push("featureDirColor");this.maxFeatureStringLen=30;b.push("maxFeatureStringLen");this.featureWidthDefault=3;b.push("featureWidthDefault");this.featureHeightDefault=14;b.push("featureHeightDefault");this.featureTraceHeight=40;b.push("featureTraceHeight");this.featureTraceTrim=1;b.push("featureTraceTrim");this.featureTracesShow=true;b.push("featureTracesShow");this.featureQualityHeight=12;b.push("featureQualityHeight");this.featureQualityValues=false;b.push("featureQualityValues");this.featureQualityShow=true;b.push("featureQualityShow");this.featureSignalToNoiseHeight=12;b.push("featureSignalToNoiseHeight");this.featureSignalToNoiseValues=false;b.push("featureSignalToNoiseValues");this.featureSignalToNoiseShow=true;b.push("featureSignalToNoiseShow");this.featureCoordinateHeight=12;b.push("featureCoordinateHeight");this.featureCoordinateShow=true;b.push("featureCoordinateShow");this.featureTranslateHeight=12;b.push("featureTranslateHeight");this.featureTranslateShow=true;b.push("featureTranslateShow");this.featureTypeDefault="line";b.push("featureTypeDefault");this.featureStaggered=false;b.push("featureStaggered");this.sequenceFontStyle="";b.push("sequenceFontStyle");this.sequenceFontSize=10;b.push("sequenceFontSize");this.sequenceFill=false;b.push("sequenceFill");this.sequenceGAPColor="rgb(255,0,255)";b.push("sequenceGAPColor");this.sequenceAColor="rgb(0,103,0)";b.push("sequenceAColor");this.sequenceBColor="rgb(0,0,0)";b.push("sequenceBColor");this.sequenceCColor="rgb(0,0,255)";b.push("sequenceCColor");this.sequenceDColor="rgb(0,0,0)";b.push("sequenceDColor");this.sequenceEColor="rgb(0,0,0)";b.push("sequenceEColor");this.sequenceFColor="rgb(0,0,255)";b.push("sequenceFColor");this.sequenceGColor="rgb(0,0,0)";b.push("sequenceGColor");this.sequenceHColor="rgb(255,0,0)";b.push("sequenceHColor");this.sequenceIColor="rgb(0,103,0)";b.push("sequenceIColor");this.sequenceKColor="rgb(255,0,0)";b.push("sequenceKColor");this.sequenceLColor="rgb(0,103,0)";b.push("sequenceLColor");this.sequenceMColor="rgb(0,103,0)";b.push("sequenceMColor");this.sequenceNColor="rgb(0,0,0)";b.push("sequenceNColor");this.sequencePColor="rgb(255,165,0)";b.push("sequencePColor");this.sequenceQColor="rgb(0,0,0)";b.push("sequenceQColor");this.sequenceRColor="rgb(255,0,0)";b.push("sequenceRColor");this.sequenceSColor="rgb(255,165,0)";b.push("sequenceSColor");this.sequenceTColor="rgb(255,0,0)";b.push("sequenceTColor");this.sequenceUColor="rgb(255,0,0)";b.push("sequenceUColor");this.sequenceVColor="rgb(0,103,0)";b.push("sequenceVColor");this.sequenceWColor="rgb(0,0,255)";b.push("sequenceWColor");this.sequenceXColor="rgb(0,0,0)";b.push("sequenceXColor");this.sequenceYColor="rgb(0,0,255)";b.push("sequenceYColor");this.sequenceZColor="rgb(0,0,0)";b.push("sequenceZColor");this.sequenceStartColor="rgb(0,204,0)";b.push("sequenceStartColor");this.sequenceEndColor="rgb(255,0,0)";b.push("sequenceEndColor");this.wireColor="rgba(204,204,204,0.1)";b.push("wireColor");this.periodTicksLabels=5;b.push("periodTicksLabels");this.genomeResolution="low";this.trackConfigurableProperties=["name","hideName","hideFeatureNames","type","height","fill","outline","hide","connect","subtracksMax","highlight"];b.push("trackConfigurableProperties");this.featureConfigurableProperties=["id","name","label","hideName","fill","outline","dir","showDir","connect","offset","data","subtype","quality","signalToNoise","coordinate","sequence","trace","gaps","translate","hide","counter"];b.push("featureConfigurableProperties");this.errors=[];this.debug=false;b.push("debug");this.warnings=true;b.push("warnings");this.offline=false;b.push("offline");this.showVersion=true;b.push("showVersion");this.showCode=false;b.push("showCode");this.codeType="params";b.push("codeType");this.disableMenu=false;b.push("disableMenu");this.disableToolbar=false;b.push("disableToolbar");this.disableDataTable=false;b.push("disableDataTable");this.disableDataFilters=false;b.push("disableDataFilters");this.disableConfigurator=false;b.push("disableConfigurator");this.resizable=true;b.push("resizable");this.resizableX=true;b.push("resizableX");this.resizableY=true;b.push("resizableY");this.movable=true;b.push("movable");this.maxSubMenus=20;b.push("maxSubMenus");this.showPrimaryMenus=true;b.push("showPrimaryMenus");this.maxItemMenuCheckbox=10;b.push("maxItemMenuCheckbox");this.configuratorWidth=250;b.push("configuratorWidth");this.configuratorExamplesSize=400;b.push("configuratorExamplesSize");this.alignConfiguratorExamples=false;b.push("alignConfiguratorExamples");this.showConfiguratorExamplesOnSelect=false;b.push("showConfiguratorExamplesOnSelect");this.resizeWidthOnLayout=true;b.push("resizeWidthOnLayout");this.resizeHeightOnLayout=true;b.push("resizeHeightOnLayout");this.disableEvents=false;b.push("disableEvents");this.eventKeys=true;b.push("eventKeys");this.eventArrowKeys=true;b.push("eventArrowKeys");this.eventPlusMinusKeys=false;b.push("eventPlusMinusKeys");this.helpKeyEvents=false;b.push("helpKeyEvents");this.skipClick=false;this.infoTimeOut=3000;b.push("infoTimeOut");this.infoStartTime=new Date().getTime();this.infoTimeIn=50;b.push("infoTimeIn");this.broadcast=true;b.push("broadcast");this.broadcastType="var";b.push("broadcastType");this.showAnimation=false;b.push("showAnimation");this.showTransition=false;b.push("showTransition");this.transitionTime=1000;b.push("transitionTime");this.transitionStep=10;b.push("transitionStep");this.transitionStaggering=10;b.push("transitionStaggering");this.transitionFunction="easeInOutQuad";b.push("transitionFunction");this.weight=1;this.scaleX=1;this.scaleY=1;this.translateX=0;this.translateY=0;this.offsetX=0;this.offsetY=0;this.layoutWidth=0;this.layoutHeight=0;this.layout="1X1";this.layoutTopology=false;b.push("layoutTopology");this.layoutComb=false;this.layoutAdjust=false;b.push("layoutAdjust");this.layoutCollapse=false;b.push("layoutCollapse");this.layoutRemoveEmpty=true;b.push("layoutRemoveEmpty");this.layoutCanvasCompartments=false;b.push("layoutCanvasCompartments");this.layoutBoxLabelColors=[];b.push("layoutBoxLabelColors");this.layoutBoxShow=true;b.push("layoutBoxShow");this.layoutCurrent=0;this.layoutAxis=3;this.imageDir="";b.push("imageDir");this.loadingImage="loading1";b.push("loadingImage");this.remoteService=false;b.push("remoteService");this.remoteServiceType="webService";b.push("remoteServiceType");this.remoteParams={};b.push("remoteParams");this.remoteDirection="next";b.push("remoteDirection");this.remoteAutoPlay=false;b.push("remoteAutoPlay");this.remoteAutoPlayDelay=3000;b.push("remoteAutoPlayDelay");this.remoteParamOverride=true;b.push("remoteParamOverride");this.remoteUpdate=false;b.push("remoteUpdate");this.remoteUpdateDelay=10000;b.push("remoteUpdateDelay");this.remoteTransitionEffect="slide";b.push("remoteTransitionEffect");this.remoteParentId="";this.remoteDataIndex=0;this.remoteIds=[];this.remoteData=[];this.remoteUpdating=false;this.RdatasetsURL="https://raw.githubusercontent.com/neuhausi/Rdatasets/master/";this.loadRDatasets=false;b.push("loadRDatasets");this.maxDataExplorerEntries=10000;b.push("maxDataExplorerEntries");this.skipConfigurableProperties=true;b.push("skipConfigurableProperties");this.nodesProperties=[];b.push("nodesProperties");this.edgesProperties=[];b.push("edgesProperties");this.featuresProperties=[];b.push("featuresProperties");this.dataFilterWidth=180;b.push("dataFilterWidth");this.filterType="and";b.push("filterType");this.filterSkipNullKeys=false;b.push("filterSkipNullKeys");this.filterSkipNullValues=false;b.push("filterSkipNullValues");this.filterVarBy=[];b.push("filterVarBy");this.filterVarByOp=[];b.push("filterVarByOp");this.filterVarByValue=[];b.push("filterVarByValue");this.filterVarByCase=[];b.push("filterVarByCase");this.filteredVarIndices=[];b.push("filteredVarIndices");this.filterSmpBy=[];b.push("filterSmpBy");this.filterSmpByOp=[];b.push("filterSmpByOp");this.filterSmpByValue=[];b.push("filterSmpByValue");this.filterSmpByCase=[];b.push("filterSmpByCase");this.filteredSmpIndices=[];b.push("filteredSmpIndices");this.filterNodeBy=[];b.push("filterNodeBy");this.filterNodeByOp=[];b.push("filterNodeByOp");this.filterNodeByValue=[];b.push("filterNodeByValue");this.filterNodeByCase=[];b.push("filterNodeByCase");this.filterEdgeBy=[];b.push("filterEdgeBy");this.filterEdgeByOp=[];b.push("filterEdgeByOp");this.filterEdgeByValue=[];b.push("filterEdgeByValue");this.filterEdgeByCase=[];b.push("filterEdgeByCase");this.filterFeatureBy=[];b.push("filterFeatureBy");this.filterFeatureByOp=[];b.push("filterFeatureByOp");this.filterFeatureByValue=[];b.push("filterFeatureByValue");this.filterFeatureByCase=[];b.push("filterFeatureByCase");this.showDataTable=false;b.push("showDataTable");this.dataTableTransposed=true;b.push("dataTableTransposed");this.maxRows=10;b.push("maxRows");this.maxCols=6;b.push("maxCols");this.colWidth=100;b.push("colWidth");this.rowHeight=18;b.push("rowHeight");this.freezeColLeft=0;b.push("freezeColLeft");this.freezeColRight=0;b.push("freezeColRight");this.freezeRowTop=0;b.push("freezeRowTop");this.freezeRowBottom=0;b.push("freezeRowBottom");this.refresehDataTableOnDraw=false;b.push("refresehDataTableOnDraw");this.showDataTableOnSelect=false;b.push("showDataTableOnSelect");this.networkShowDataTable="nodes";b.push("networkShowDataTable");this.colorDataTable=true;b.push("colorDataTable");this.colorDataTableTransparency=0.5;b.push("colorDataTableTransparency");this.startCol=0;this.startRow=0;this.dataTableColumnWidth=[];this.dataTableRowHeight=[]};this.updateTheme=function(b){for(var e in b){if(e=="conditional"){for(var f in b[e]){if(this.isInArray(this.graphType,CanvasXpress.graphTypes[f])){for(var d in b[e][f]){this[d]=b[e][f][d]}}}}else{this[e]=b[e]}}};this.setTheme=function(){if(a&&a.hasOwnProperty("theme")&&a.theme&&CanvasXpress.themes.hasOwnProperty(a.theme)){this.updateTheme(CanvasXpress.themes[a.theme])}};this.resetInitialFontSize=function(){var b=["fontSize","titleFontSize","subtitleFontSize","citationFontSize","smpTitleFontSize","smpLabelFontSize","varTitleFontSize","varLabelFontSize","overlayFontSize","legendFontSize","decorationFontSize","axisTickFontSize","axisTitleFontSize","nodeFontSize","trackNameFontSize","featureNameFontSize","sequenceFontSize"];for(var c=0;c<b.length;c++){this[b[c]]=Number(CanvasXpress.doc.P[b[c]].D)}this.setInitialFonts()};this.setInitialFonts=function(){this.font=this.fontStyle+" "+this.fontSize+"px "+this.fontName;this.titleFont=this.titleFontStyle+" "+this.titleFontSize+"px "+this.fontName;this.subtitleFont=this.subtitleFontStyle+" "+this.subtitleFontSize+"px "+this.fontName;this.citationFont=this.citationFontStyle+" "+this.citationFontSize+"px "+this.fontName;this.smpTitleFont=this.smpTitleFontStyle+" "+this.smpTitleFontSize+"px "+this.fontName;this.smpLabelFont=this.smpLabelFontStyle+" "+this.smpLabelFontSize+"px "+this.fontName;this.varTitleFont=this.varTitleFontStyle+" "+this.varTitleFontSize+"px "+this.fontName;this.varLabelFont=this.varLabelFontStyle+" "+this.varLabelFontSize+"px "+this.fontName;this.overlayFont=this.overlayFontStyle+" "+this.overlayFontSize+"px "+this.fontName;this.legendFont=this.legendFontStyle+" "+this.legendFontSize+"px "+this.fontName;this.decorationFont=this.decorationFontStyle+" "+this.decorationFontSize+"px "+this.fontName;this.axisTickFont=this.axisTickFontStyle+" "+this.axisTickFontSize+"px "+this.fontName;this.axisTitleFont=this.axisTitleFontStyle+" "+this.axisTitleFontSize+"px "+this.fontName;this.motionCurrentFont=this.motionCurrentFontStyle+" "+this.motionCurrentFontSize+"px "+this.fontName;this.nodeFont=this.nodeFontStyle+" "+this.nodeFontSize+"px "+this.fontName;this.trackNameFont=this.trackNameFontStyle+" "+this.trackNameFontSize+"px "+this.fontName;this.featureNameFont=this.featureNameFontStyle+" "+this.featureNameFontSize+"px "+this.fontName;this.sequenceFont=this.sequenceFontStyle+" "+this.sequenceFontSize+"px "+this.fontName};this.setInitialConfig=function(){if(this.meta.config.user){delete (this.meta.config.user.skipRender);for(var b in this.meta.config.user){if(CanvasXpress.doc.P[b]&&CanvasXpress.doc.P[b].hasOwnProperty("T")){if(CanvasXpress.doc.P[b].T=="integer"||CanvasXpress.doc.P[b].T=="float"){this.meta.config.user[b]=Number(this.meta.config.user[b])}this[b]=this.meta.config.user[b]}else{this[b]=this.meta.config.user[b]}}}};this.resetConfig=function(b){var d={};if(b){for(var c=0;c<b.length;c++){d[b[c]]=this[b[c]]}}this.setConfigDefaults();for(var c in d){this[c]=d[c]}};this.updateConfig=function(c){if(c){this.meta.config.user=c;for(var b in c){this[b]=c[b]}}};this.getConfig=function(){var l={};var c=CanvasXpress.config.sort();var g={colors:true,images:true,xAxisValues:true,xAxisValuesRaw:true,xAxisMinorValues:true,yAxisValues:true,yAxisValuesRaw:true,yAxisMinorValues:true,zAxisValues:true,zAxisValuesRaw:true,zAxisMinorValues:true,nodeConfigurableProperties:true,edgeConfigurableProperties:true,trackConfigurableProperties:true,featureConfigurableProperties:true};if(this.isTransformedData){l.isTransformedData=this.isTransformedData}for(var f=0;f<c.length;f++){var e=c[f];if(CanvasXpress.doc.P[e]&&CanvasXpress.doc.P[e].hasOwnProperty("D")){var h=CanvasXpress.doc.P[e].D;if(g[e]){continue}var b=this[e]===undefined?false:this[e];if(typeof(b)=="object"){if(h=="[]"){h=[]}if(h=="{}"){h={}}if(b===null){if(h!="null"){l[e]=b}}else{if(e=="sizes"){if(!this.isSameObject(b,h.map(Number))){l[e]=b}}else{if(!this.isSameObject(b,h)){l[e]=b}}}}else{if(h.match(/false|true|null/)){if(b.toString()!=h){l[e]=b}}else{if(b!=h){l[e]=b}}}}}return l};this.getUserConfig=function(){return this.meta.config.user};this.getNewCanvasContext=function(d){var b=this.$(d);if(!b||b.tagName.toLowerCase()!="canvas"){b=this.$cX("canvas",{id:d});document.body.appendChild(b)}return b.getContext("2d")};this.setCanvasPixelRatio=function(){var b=document.createElement("canvas").getContext("2d");var c=window.devicePixelRatio||1;var d=b.webkitBackingStorePixelRatio||b.mozBackingStorePixelRatio||b.msBackingStorePixelRatio||b.oBackingStorePixelRatio||b.backingStorePixelRatio||1;this.meta.canvas.canvasPixelRatio=c/d};this.setDPI=function(c,d){c.style.width=c.style.width||c.width+"px";c.style.height=c.style.height||c.height+"px";var h=d/96;var b=parseFloat(c.style.width);var i=parseFloat(c.style.height);var e=c.width/b;var g=h/e;var f=c.cloneNode(false);f.getContext("2d").drawImage(c,0,0);var j=c.getContext("2d");c.width=Math.ceil(b*h);c.height=Math.ceil(i*h);j.setTransform(g,0,0,g,0,0);j.drawImage(f,0,0);j.setTransform(h,0,0,h,0,0)};this.setCanvas=function(){var g=this.$(this.target);if(g){this.setCanvasPixelRatio();this.checkCanvasXpressOrgSite();this.meta.canvas.ctx=g.getContext("2d");this.meta.canvas.ctx.setTransform(this.meta.canvas.canvasPixelRatio,0,0,this.meta.canvas.canvasPixelRatio,0,0);if((this.backgroundType=="video"||this.graphType=="Video")&&this.backgroundVideo){if(this.graphType=="Video"){this.backgroundType="video"}this.isVideo=true;var f=this.$cX("script",{type:"text/javascript",src:"../js/video.js"});var e=this.$cX("link",{type:"text/css",rel:"stylesheet",href:"../css/video-js.css"});var d=document.getElementsByTagName("head")[0];d.appendChild(e);d.appendChild(f);this.background="rgba(255,255,255,0)";this.legendBackgroundColor="rgba(255,255,255,0)";this.disableToolbar=true}else{if(this.graphType=="Map"){this.isMap=true;var d=[];if(this.topoJSON){for(var b in this.topoJSON){this.leafletJS.unshift(this.topoJSON[b])}}for(var b=0;b<this.leafletJS.length;b++){d.push(this.$cX("script",{type:"text/javascript",src:this.leafletJS[b]}))}for(var b=0;b<this.leafletCSS.length;b++){d.push(this.$cX("link",{type:"text/css",rel:"stylesheet",href:this.leafletCSS[b]}))}this.initLeaflet();CanvasXpress.loadScripts(d,this.leafletInit||this.leafletInitString||this.initializeLeaflet,this)}else{this.isVideo=false;this.isMap=false}}}};this.getCanvasContext=function(){var b;if(this.isSVG){b=this.meta.canvas.ctx5}else{if(this.isTransitionCanvas){b=this.transitionIter%2?this.meta.canvas.ctx3:this.meta.canvas.ctx4}else{b=this.isHighlightCanvas?this.meta.canvas.ctx2:this.isMapCanvas?this.meta.leaflet.ctx:this.meta.canvas.ctx}}this.currentCanvasContext=b.canvas.id;return b};this.checkCanvasXpressOrgSite=function(){var g=new RegExp("https://canvasxpress.org/js/");var d=document.getElementsByTagName("head")[0];for(var b=0;b<d.childNodes.length;b++){var f=d.childNodes[b];if(f.type=="text/javascript"&&g.test(f.src)){CanvasXpress.factory.siteSrc=true}}};this.inititalizeConfig=function(){CanvasXpress.config=[];this.setConfigDefaults();this.setTheme();if(a){for(var b=0;b<CanvasXpress.config.length;b++){var c=CanvasXpress.config[b];if(a.hasOwnProperty(c)){this[c]=a[c]}}}this.setInitialFonts();this.setCanvas();CanvasXpress.system.isR=this.isR;CanvasXpress.system.isShiny=window.Shiny?true:false};this.setFunctionNames("initConfig");this.inititalizeConfig()};CanvasXpress.prototype.initText=function(){this.setTextShadow=function(a){if(this.showTextShadow){if(a){this.meta.canvas.ctx.shadowOffsetX=this.shadowOffsetX;this.meta.canvas.ctx.shadowOffsetY=this.shadowOffsetY;this.meta.canvas.ctx.shadowBlur=this.shadowBlur;this.meta.canvas.ctx.shadowColor=this.shadowColor}else{this.meta.canvas.ctx.shadowOffsetX=0;this.meta.canvas.ctx.shadowOffsetY=0;this.meta.canvas.ctx.shadowBlur=0;this.meta.canvas.ctx.shadowColor=this.background}}};this.getArcTextArea=function(B,A,z,a,C,u,p,v,j,w,d,g){if(B==undefined){B=""}var q=["poly"];var o=this.getFontPt(p);var j=this.measureText(B,p)*(Math.PI*0.5)/a;C=(C+(u/2))-(j/2)%(Math.PI*2);u=C+j;var n=this.traceArc1(A,z,a,C,u,true);for(var k=0;k<n.length;k++){q.push(n[k][0],n[k][1])}n=this.traceArc1(A,z,a-o,C,u);for(var k=0;k<n.length;k++){q.push(n[k][0],n[k][1])}if(this.graphType=="Network"){return this.preScaleNetwork&&!this.isAnimation?q:this.adjustNetworkObjects(q)}else{return q}};this.drawArcText=function(B,z,w,a,C,p,o,q,j,v,g,h){this.functionCallerDraw="drawArcText";if(B==undefined){B=""}var A=this.getCanvasContext();if(B==null){return}if(!A){if(this.debug){alert("Dude, there is no canvas")}return}if(isNaN(z)||isNaN(w)){if(this.debug){alert("Not a valid coordinate ("+z+", "+w+") to draw "+B)}return}if(!h&&!isNaN(B)){B=this.formatNumber(B)}B=B.toString().replace("\x00","");if(!z){z=0}if(!w){w=0}if(!o){o=this.font}if(!q){q=this.foreground}if(!j){j=this.align}if(!v){v=this.baseline}this.saveCanvas();A.strokeStyle=this.isArray(q)?q[0]:q;A.fillStyle=this.isArray(q)?q[0]:q;A.font=o;A.textAlign=j;A.textBaseline=v;this.setTextShadow(true);var d=j=="right"?1:-1;var u=this.getFontPt(o);if(((["left","center"].indexOf(j)>-1)&&g)||(j=="right"&&!g)){B=B.split("").reverse().join("");if(this.isArray(q)){q=q.reverse()}}A.translate(z,w);C+=(Math.PI*!g);C+=(Math.PI/2)+(p/2);if(j=="center"){for(var k=0;k<B.length;k++){var n=this.measureText(B[k],o);C+=((n+(k==B.length-1?0:this.circularLetterSeparationFactor))/(a-u))/2*-d}}p=C;this.rotateCanvas(C);for(var k=0;k<B.length;k++){var n=this.measureText(B[k],o);p+=(n/2)/(a-u)*d;this.rotateCanvas((n/2)/(a-u)*d);if(this.isArray(q)){A.strokeStyle=q[k];A.fillStyle=q[k]}A.fillText(B[k],0,(g?1:-1)*(0-a+u/2));p+=(n/2+this.circularLetterSeparationFactor)/(a-u)*d;this.rotateCanvas((n/2+this.circularLetterSeparationFactor)/(a-u)*d)}this.restoreCanvas();this.setTextShadow(false)};this.getTextMultipleArea=function(o,n,k,A,B,E,D,g,q,p,j){if(o==undefined){o=""}var r=o.split(/\n/);var w=this.getFontPt(A);var C=[];var F=k+(r%2?0:w/2)-(r.length*w/2);for(var u=0;u<r.length;u++){C.push(this.getTextArea(r[u],n,F,A,B,E,D,g,q,p,j));F+=w}var z=C[0][1];var e=C[0][2];var v=C[0][3];var d=C[0][4];for(var u=1;u<C.length;u++){z=Math.min(z,C[u][1]);e=Math.min(e,C[u][2]);v=Math.max(v,C[u][3]);d=Math.max(d,C[u][4])}return[C[0][0],z,e,v,d]};this.drawTextMultiple=function(B,z,u,p,r,w,v,e,h,C,A){this.functionCaller="drawTextMultiple";var j=B.split(/\n/);var d=p;var n=[];if(!d){d=this.font}var o=this.getFontPt(d);var q=u+(j%2?0:o/2)-(j.length*o/2);for(var k=0;k<j.length;k++){this.drawText(j[k],z,q,d,r,w,v,e,h,C,A);q+=o}};this.getTextArea=function(q,o,n,B,D,F,E,g,u,r,k){var j=this;var v=function(b){b.shift();var a=["poly"];a=a.concat(j.rotatePoint(b[0],b[1],o,n,g));a=a.concat(j.rotatePoint(b[2],b[1],o,n,g));a=a.concat(j.rotatePoint(b[2],b[3],o,n,g));a=a.concat(j.rotatePoint(b[0],b[3],o,n,g));return a};if(q==undefined){q=""}if(k){if(o<this.marginLeft+this.offsetX+this.left||o>this.marginLeft+this.offsetX+this.left+this.x){return}if(n<this.marginTop+this.offsetY+this.top||n>this.marginTop+this.offsetY+this.top+this.y){return}}if(this.isMultipleLines(q)){return this.getTextMultipleArea(q,o,n,B,D,F,E,g,u,r,k)}var G=[];var p=this.measureText(q,B);var z=this.getFontPt(B);var C,e,A,d;var i=0;if(u){while(p>u&&i<10){q=q.substring(0,q.length-1);p=this.measureText(q,B);i++}}if(F=="left"){C=o;A=C+p}else{if(F=="right"){C=o-p;A=o}else{C=o-(p/2);A=o+(p/2)}}if(E=="top"){e=n;d=e+z}else{if(E=="bottom"){e=n-z;d=n}else{e=n-(z/2);d=n+(z/2)}}G=["rect",C,e,A,d];G=g?v(G):G;if(this.graphType=="Network"){return this.preScaleNetwork&&!this.isAnimation?G:this.adjustNetworkObjects(G)}else{return G}};this.drawText=function(z,q,n,j,k,p,o,d,e,A,u){this.functionCallerDraw="drawText";if(z==undefined){z=""}var v=this.getCanvasContext();var i=0;if(z==null){return}if(this.isMultipleLines(z)){return this.drawTextMultiple(z,q,n,j,k,p,o,d,e,A,u)}if(!v){if(this.debug){alert("Dude, there is no canvas")}return}if(isNaN(q)||isNaN(n)){if(this.debug){alert("Not a valid coordinate ("+q+", "+n+") to draw "+z)}return}if(u){if(q<this.marginLeft+this.offsetX+this.left||q>this.marginLeft+this.offsetX+this.left+this.x){return}if(n<this.marginTop+this.offsetY+this.top||n>this.marginTop+this.offsetY+this.top+this.y){return}}if(!q){q=0}if(!n){n=0}if(!j){j=this.font}if(!k){k=this.foreground}if(!p){p=this.align}if(!o){o=this.baseline}var r=this.measureText(z,j);var g=this.getFontPt(j);if(e){while(r>e&&i<10){z=z.substring(0,z.length-1);r=this.measureText(z,j);i++}}this.saveCanvas();v.strokeStyle=k;v.fillStyle=k;v.font=j;this.translateCanvas(q,n);v.textAlign=p;v.textBaseline=o;this.setTextShadow(true);if(d){this.rotateCanvas(d)}z=z.toString().replace("\x00","");if(A){v.strokeText(z,0,0)}else{v.fillText(z,0,0)}this.restoreCanvas();this.setTextShadow(false)};this.isMultipleLines=function(b){var a=b.toString().split(/\n/);return a.length-1};this.capitalize=function(a){if(a){return a.charAt(0).toUpperCase()+a.slice(1)}};this.decapitalize=function(a){if(a){return a.charAt(0).toLowerCase()+a.slice(1)}};this.measureTextMultiple=function(e,g){var c=e.split(/\n/);var a=0;var b=this.getCanvasContext();if(!b){return 0}if(!g){g=this.font}b.font=g;for(var d=0;d<c.length;d++){a=Math.max(a,b.measureText(c[d]).width)}return a};this.measureText=function(b,c){var a=this.getCanvasContext();if(!b||!a){return 0}b=b.toString();if(!c){c=this.font}if(!CanvasXpress.cacheText[c]){CanvasXpress.cacheText[c]={}}if(!CanvasXpress.cacheText[c][b]){a.font=c;if(this.isMultipleLines(b)){CanvasXpress.cacheText[c][b]=this.measureTextMultiple(b,c)}else{CanvasXpress.cacheText[c][b]=a.measureText(b).width}}return CanvasXpress.cacheText[c][b]};this.measureTextWidth=function(a,b){l=this.isMultipleLines(a);if(l>0){return(this.getFontPt(b)+this.margin)*(l+1)}else{return this.getFontPt(b)}};this.scaleTextToFont=function(b,e,a,c){var d=this.fontStyle+" "+e+"px "+this.fontName;if(b){while(this.measureText(b,d)>a&&e>=this.minTextSize){e-=2;d=this.fontStyle+" "+e+"px "+this.fontName}if(c){while(parseInt(e/1.33)>c-2){e--}d=this.fontStyle+" "+e+"px "+this.fontName}}return d};this.getFontPt=function(a){return a?Math.max(1,parseInt(a.toString().match(/[\-\d]+/)[0])):1};this.scaleTextToSize=function(a){var d=this.scaleTextConstantMult;if(!a){a=1}return Math.ceil(1/Math.sqrt(a)*d)};this.wrapText=function(c,b){var a=new RegExp("(?![^\\n]{1,"+b+"}$)([^\\n]{1,"+b+"})([\\s|-])","g");return c.toString().replace(a,"$1$2\n").replace(" \n","\n")};this.scaleFont=function(a,b){var d=this.getFontPt(a);var c=Math.max(1,parseInt(d*b));return a.replace(d+"px",c+"px")};this.approx=function(g){var e=g;var d=g.toString();var j=d.indexOf("99999");var h=d.indexOf("00000");var i=d.indexOf(".");var b=j>=0&&i<j?j:h>=0?h:null;if(b!=null){e=d.substring(0,b);f=Math.pow(10,e.length-(e.indexOf(".")+1));return Number(Math.round(Number(d)*f)/f)}else{return Number(d)}};this.formatNumber=function(b,a){if(a&&Math.abs(b)<99999){return sprintf("%."+a+"f",Number(b)).toString()}else{if(Math.abs(b)<0.0001||Math.abs(b)>99999||b.toString().length>=8){return Number(b).toExponential(2).toString().replace("e+0","").replace(".00","")}else{return b.toString()}}};this.bestFormatNumber=function(b,a){if(typeof b==="number"&&b%1==0){return b}else{if(a!=null&&a<1){return sprintf("%.0f",Number(b))}else{if(Math.abs(b)<0.001){return sprintf("%.2e",Number(b))}else{return sprintf("%.3f",Number(b))}}}};this.getMaxtTextBySampling=function(b,j){var c={};var g=[];var h=[];for(var e=0;e<b.length;e++){var d=b[e]!=null?b[e].toString():"";if(!c.hasOwnProperty(d)){c[d]=true;g.push([d,d.length])}}g.sort(function(k,i){return k[1]<i[1]?-1:k[1]>i[1]?1:0});if(!j){j=10}if(g.length<j){j=g.length}for(var e=0;e<j;e++){h.push(g[e][0])}return this.getMaxText(h)};this.getMaxText=function(d){var g="";var b=0;if(d&&d.length>0){for(var e=0;e<d.length;e++){if(d[e]){var h=this.measureText(d[e].toString(),this.font);if(h>b){g=d[e].toString();b=h}}}}return g};this.shortenText=function(c,b,a){if(!c){return""}c=c.toString();if(a&&c.length>b){return c.substring(0,Math.max(parseInt(a/b)-2,1))+".."}else{if(c.length<=b){return c}else{return c.substring(0,b-3)+"..."}}};this.convertToNumber=function(a){if(!isNaN(a)){return parseFloat(a)}else{return a}};this.stringToHex=function(c){var b="";for(var a=0;a<c.length;a++){b+=""+c.charCodeAt(a).toString(16)}return b};this.hexToString=function(b){var c="";for(var a=0;a<b.length;a+=2){c+=String.fromCharCode(parseInt(b.substr(a,2),16))}return c};this.setFunctionNames("initText")};CanvasXpress.prototype.initTime=function(){Date.prototype.getWeek=function(){var a=new Date(this.getFullYear(),0,1);return Math.ceil((((this-a)/86400000)+a.getDay()+1)/7)};Date.prototype.getDayYear=function(){var a=new Date(this.getFullYear(),0,1);return Math.ceil((this-a)/86400000)};this.getMillisecond=function(a){return a.getMilliseconds()};this.getSecond=function(a){return a.getSeconds()};this.getMinuteSecond=function(a){return a.getMinutes()+":"+a.getSeconds()};this.getMinute=function(a){return a.getMinutes()};this.getHourMinute=function(a){return a.getHours()+":"+a.getMinutes()};this.getHour=function(a){return a.getHours()};this.getYearWeek=function(a){return a.getFullYear()+"-"+a.getWeek()};this.getYearMonth=function(a){return a.getFullYear()+"-"+a.getMonth()};this.getYear=function(a){return a.getFullYear()};this.times={second:1000,minute:60000,hour:3600000,day:86400000,week:604800000,month:2592000000,year:31556952000};this.parseDate=function(j){var f=0;var c=0;var e=0;var k=parseInt(j.toString().substring(0,4));var a=parseInt(j.toString().substring(4,6).replace(/^0/,""));var g=parseInt(j.toString().substring(6,8).replace(/^0/,""));var b=j.toString().match(/\:/)?j.toString().substring(10).split(":"):false;if(b){f=b[0]?parseInt(b[0].replace(/^0/,"")):0;c=b[1]?parseInt(b[1].replace(/^0/,"")):0;e=b[2]?parseInt(b[2].replace(/^0/,"")):0}return new Date(k,a-1,g,f,c,e)};this.setTimeAxis=function(){var h=this.validateTimeAxis();if(h){var g=Date.parse(h[h.length-1])-Date.parse(h[0]);var d;var b={};var c=[];this.timeValues=[];this.timeValueIndices=[];if(g>this.times.year*2){d="getYear"}else{if(g>this.times.month*2){d="getYearMonth"}else{if(g>this.times.week*2){d="getYearWeek"}else{if(g<this.times.second){d="getMillisecond"}else{if(g<this.times.minute){d="getSecond"}else{if(g<this.times.hour/4){d="getMinuteSecond"}else{if(g<this.times.hour){d="getMinute"}else{if(g<this.times.day/4){d="getHourMinute"}else{if(g<this.times.day){d="getHour"}else{d=false}}}}}}}}}if(d){if(this.timeTicksFirst){for(var a=0;a<h.length;a++){var e=this[d](h[a]);if(!b.hasOwnProperty(e)){c.push(h[a]);this.timeValueIndices.push(a);b[e]=true}}}else{for(var a=h.length-1;a>=0;a--){var e=this[d](h[a]);if(!b.hasOwnProperty(e)){c.unshift(h[a]);this.timeValueIndices.unshift(a);b[e]=true}}}}else{for(var a=0;a<h.length;a++){this.timeValues.push(dateFormat(h[a],this.timeFormat));this.timeValueIndices.push(a)}}var g=Date.parse(c[c.length-1])-Date.parse(c[c.length-2]);if(d=="getYear"&&g<this.times.month*3){this.timeValues.pop();this.timeValueIndices.pop()}else{if(d=="getYearMonth"&&g<this.times.week*4){this.timeValues.pop();this.timeValueIndices.pop()}else{if(d=="getYearWeek"&&g<this.times.day*7){this.timeValues.pop();this.timeValueIndices.pop()}}}for(var a=0;a<c.length;a++){this.timeValues.push(dateFormat(c[a],this.timeFormat))}}};this.createRandomTimes=function(b){var e;var g=new Date();var a=g.getTime();var f=[new Date(a)];var h=this.isGroupedData?this.data.w:this.data.y;if(!b||!this.times[b]){b="day"}for(var c=0;c<h.smps.length;c++){e=Date.parse(h.smps[c]);if(!isNaN(e)){a=e}else{a-=this.times[b]}f.unshift(new Date(a))}return f};this.validateTimeAxis=function(){var f=this.isGroupedData?this.data.w:this.data.y;var a=false;var e=[];for(var b=0;b<this.smpIndices.length;b++){var c=this.smpIndices.length!=f.smps.length?Date.parse(f.smps[this.smpIndices[b]]):Date.parse(f.smps[b]);if(isNaN(c)){if(this.isExample){e=this.createRandomTimes();return e}else{a=true;break}}else{e.push(new Date(c))}}return a?false:e};this.setFunctionNames("initTime")};CanvasXpress.prototype.initColor=function(){this.validateColor=function(i,e,f){if(i){i=i.toString();i=i.replace(/\s/g,"");var b=(/rgb\((\d{1,3}),(\d{1,3}),(\d{1,3})\)/).exec(i);var d=(/rgba\((\d{1,3}),(\d{1,3}),(\d{1,3}),([0-9\.]+)\)/).exec(i);var g=(/^#?([0-9abcdef]{6})/i).exec(i);var a=(/^([0-9abcdef]{6})/i).exec(i);if(CanvasXpress.colorNames.hasOwnProperty(i)){i=this.hexToRgb(CanvasXpress.colorNames[i])}else{if(b!=null){i=b[0]}else{if(d!=null){i=d[0]}else{if(g!=null){i=this.hexToRgb(g[0])}else{if(a!=null){i=this.hexToRgb("#"+a[0])}else{i=false}}}}}}i=i&&e!=null?this.addColorTransparency(i,e):i?i:"rgb(0,0,0)";return i&&f?this.rgbToHex(i):i};this.darkenLightenColor=function(j,e){j=this.rgbToHex(j).substring(1,7);var i=parseInt(j,16);var h=(i>>16)+e;h=h>255?255:h<0?0:h;var f=((i>>8)&255)+e;f=f>255?255:f<0?0:f;var d=(i&255)+e;d=d>255?255:d<0?0:d;j=d|(f<<8)|(h<<16);return this.hexToRgb(j.toString(16))};this.rgbToHex=function(b){var a=function(c){c=parseInt(c,10);if(isNaN(c)){return"00"}c=Math.max(0,Math.min(c,255));return"0123456789ABCDEF".charAt((c-c%16)/16)+"0123456789ABCDEF".charAt(c%16)};if(b&&b.substr(0,1)==="#"){return b}if(b&&b.match(/^rgb\((\d{1,3}),(\d{1,3}),(\d{1,3})\)/)){return"#"+a(RegExp.$1)+a(RegExp.$2)+a(RegExp.$3)}else{return b}};this.rgbToHsl=function(m){var i=this.colorAsArray(m);var a=i[0]/255;var j=i[1]/255;var n=i[2]/255;var o=Math.max(a,j,n);var e=Math.min(a,j,n);var f,p;var c=(o+e)/2;if(o==e){f=0;p=0}else{var k=o-e;p=c>0.5?k/(2-o-e):k/(o+e);switch(o){case a:f=(j-n)/k+(j<n?6:0);break;case j:f=(n-a)/k+2;break;case n:f=(a-j)/k+4;break}f/=6}return"hsl("+Math.floor(f*100)+","+Math.floor(p*100)+"%,"+Math.floor(c*100)+"%)"};this.complementaryColor=function(j,e){var d=this.validateColor(j.toString());if(d.match(/^rgba?\((\d{1,3}),(\d{1,3}),(\d{1,3})(?:,([0-9\.]+))?/i)){var i=parseInt(255-RegExp.$1);var f=parseInt(255-RegExp.$2);var a=parseInt(255-RegExp.$3);if(i==f&&f==a){if(i>=127){d="rgb(255,255,255)"}else{d="rgb(0,0,0)"}}else{d="rgb("+i+","+f+","+a+")"}return e?this.rgbToHex(d):d}else{return j}};this.hexToRgb=function(c){var b=function(){return parseInt(c.substring(0,2),16)};var a=function(){return parseInt(c.substring(2,4),16)};var d=function(){return parseInt(c.substring(4,6),16)};c=c.charAt(0)=="#"?c.substring(1,7):c;return"rgb("+b()+","+a()+","+d()+")"};this.hslToRgb=function(n){var j=n.split(",");var i=Number(j[0].replace(/\s/g,"").replace("hsl(",""));var o=Number(j[0].replace(/\s/g,"").replace("%",""));var f=Number(j[0].replace(/\s/g,"").replace("%)",""));if(o==0){return"rgb("+f+","+f+","+f+")"}else{var e=function(h,g,b){if(b<0){b+=1}if(b>1){b-=1}if(b<1/6){return h+(g-h)*6*b}if(b<1/2){return g}if(b<2/3){return h+(g-h)*(2/3-b)*6}return h};var c=f<0.5?f*(1+o):f+o-f*o;var d=2*f-c;var a=Math.round(e(d,c,i+1/3)*255);var k=Math.round(e(d,c,i)*255);var m=Math.round(e(d,c,i-1/3)*255);return"rgb("+a+","+k+","+m+")"}};this.addColorTransparency=function(e,d,b){if(!b){e=this.validateColor(e)}if(e){var a=e.match(/^rgba?\((\d{1,3},\d{1,3},\d{1,3})(?:,([0-9\.]+))?/i);return"rgba("+a[1]+","+Math.min(d,(a[2]!=null?a[2]:1))+")"}else{return false}};this.removeColorTransparency=function(d,b){if(!b){d=this.validateColor(d)}if(d){var a=d.match(/^rgba?\((\d{1,3},\d{1,3},\d{1,3})(?:,([0-9\.]+))?/i);return"rgb("+a[1]+")"}else{return false}};this.isColorTransparency=function(b){b=this.validateColor(b);if(b){var a=b.match(/^rgba?\((\d{1,3},\d{1,3},\d{1,3})(?:,([0-9\.]+))?/i);return a[2]!=null?Number(a[2]):null}};this.isColorTransparent=function(d){d=this.validateColor(d);var b;if(d&&d.match(/^rgb\((\d{1,3}),(\d{1,3}),(\d{1,3})\)/)){return false}else{if(d){var a=d.match(/^rgba?\((\d{1,3},\d{1,3},\d{1,3})(?:,([0-9\.]+))?/i);return a[2]!=null&&a[2]==0?true:false}else{return false}}};this.combineColors=function(j){var e=[];var d=[];var n=[];var k=[];for(var f=0;f<j.length;f++){j[f]=this.validateColor(j[f])}for(var f=0;f<j.length;f++){var l=j[f];if(l&&l.match(/^rgba?\((\d{1,3}),(\d{1,3}),(\d{1,3})(?:,([0-9\.]+))?/i)){e.push(parseInt(RegExp.$1));d.push(parseInt(RegExp.$2));n.push(parseInt(RegExp.$3));if(RegExp.$4){k.push(parseFloat(RegExp.$4))}}}if(e.length>0){var a=parseInt(this.mean(e));var h=parseInt(this.mean(d));var m=parseInt(this.mean(n));if(k.length>0){var o=parseFloat(this.mean(k));return"rgba("+a+","+h+","+m+","+o+")"}else{return"rgb("+a+","+h+","+m+")"}}return false};this.colorAsArray=function(f){f=this.validateColor(f);var b=[];if(f){var d=(/rgb\((\d{1,3}),(\d{1,3}),(\d{1,3})\)/).exec(f);var e=(/rgba\((\d{1,3}),(\d{1,3}),(\d{1,3}),([0-9\.]+)\)/).exec(f);if(d!=null){b=[parseInt(d[1]),parseInt(d[2]),parseInt(d[3])]}else{if(e!=null){b=[parseInt(e[1]),parseInt(e[2]),parseInt(e[3]),Number(e[4])]}}}return b};this.blindColor=function(R,H){var q=this.colorAsArray(this.validateColor(R,H));var I=q[0];var P=q[1];var S=q[2];var w=[0.7465,0.2535,1.273463,-0.073894];var z=[1.4,-0.04,0.968437,0.003331];var u=[1.748,0,0.062921,0.292119];if(I==0&&P==0&&S==0){return"rgb(0,0,0)"}var l;switch(this.blindnessType){case"protanopia":l=w;break;case"deuteranopia":l=z;break;case"tritanopia":l=u;break;case"monochromatic":var R=Math.ceil((I*0.212656+I*0.715158+I*0.072186));return"rgb("+R+","+R+","+R+")"}var E=l[0];var C=l[1];var J=l[2];var y=l[3];var n=1;var x=Math.pow(I,2.2);var A=Math.pow(P,2.2);var B=Math.pow(S,2.2);var i=x*0.412424+A*0.357579+B*0.180464;var h=x*0.212656+A*0.715158+B*0.072185;var f=x*0.019332+A*0.119193+B*0.950444;var k=i/(i+h+f);var j=h/(i+h+f);var v=(j-C)/(k-E);var K=j-k*v;var e=(y-K)/(v-J);var a=(v*e)+K;i=e*h/a;f=(1-(e+a))*h/a;var N=0.312713*h/0.329016;var L=0.358271*h/0.329016;var F=N-i;var D=L-f;var G=F*3.24071+D*-0.498571;var M=F*-0.969258+D*0.0415557;var Q=F*0.0556352+D*1.05707;var d=i*3.24071+h*-1.53726+f*-0.498571;var o=i*-0.969258+h*1.87599+f*0.0415557;var s=i*0.0556352+h*-0.203996+f*1.05707;var T=((G<0?0:1)-d)/G;var m=((M<0?0:1)-o)/M;var p=((Q<0?0:1)-s)/Q;var O=[(T>1||T<0)?0:T,(m>1||m<0)?0:m,(p>1||m<0)?0:p];O=Math.max.apply(null,O);d=d+(O*G);o=o+(O*M);s=s+(O*Q);d=Math.pow(d,1/2.2);o=Math.pow(o,1/2.2);s=Math.pow(s,1/2.2);I=Math.ceil(d);P=Math.ceil(o);S=Math.ceil(s);if(I>255){I-=255}if(P>255){P-=255}if(S>255){S-=255}return"rgb("+I+","+P+","+I+")"};this.disableGradientTransparencyShadow=function(){if(!this.gradientTemp){this.gradientTemp=this.gradient}if(this.transparencyTemp==null){this.transparencyTemp=this.transparency}if(!this.showShadowTemp){this.showShadowTemp=this.showShadow}this.gradient=false;this.transparency=null;this.showShadow=false};this.enableGradientTransparencyShadow=function(){this.gradient=this.gradientTemp;this.transparency=this.transparencyTemp;this.showShadow=this.showShadowTemp};this.resetGradientTransparencyShadow=function(){delete (this.gradientTemp);delete (this.transparencyTemp);delete (this.showShadowTemp)};this.getGradientColor=function(h){if(h.match(/^rgba?\((\d{1,3}),(\d{1,3}),(\d{1,3})(?:,([0-9\.]+))?/i)){var f=Math.floor(parseInt(RegExp.$1)/this.gradientRatio);var e=Math.floor(parseInt(RegExp.$2)/this.gradientRatio);var a=Math.floor(parseInt(RegExp.$3)/this.gradientRatio);var d=RegExp.$4?parseFloat(RegExp.$4):false;if(d){return"rgba("+f+","+e+","+a+","+d+")"}else{return"rgb("+f+","+e+","+a+")"}}else{return false}};this.getGradient=function(f,e,d,c,b,a){if(this.gradientType=="radial"){return this.getRadialGradient(f,e,d,c,false,false,true)}else{return this.getLinearGradient(f,e,d,c,b,a,true)}};this.getLinearGradient=function(b,i,a,h,d,c,f){if(!f){this.saveCanvas()}var j=this.getCanvasContext();var e=j.createLinearGradient(b,i,a,h);if(!d){d=this.foreground}if(!c){c=this.getGradientColor(d);e.addColorStop(0,c);e.addColorStop(0.6,d);e.addColorStop(1,d)}else{e.addColorStop(0,d);e.addColorStop(0.3,c);e.addColorStop(1,c)}return e};this.getRadialGradient=function(j,h,a,e,d,c,i){if(!i){this.saveCanvas()}var b=a/5.5;var k=this.getCanvasContext();var f=k.createRadialGradient(j-b,h-b,1,j,h,a);if(!e){e=this.foreground}if(!d){if(this.transparency!=null){d="rgba(0,0,0,"+this.transparency+")"}else{d="rgb(0,0,0)"}}if(!c){c="rgba(0,0,0,0)"}f.addColorStop(0,e);f.addColorStop(1,d);f.addColorStop(1,c);return f};this.colorRGBfromString=function(b){var a=b.match(/^\W*([0-9A-F]{3}([0-9A-F]{3})?)\W*$/i);if(a){if(a[1].length===6){this.colorFromRgb(parseInt(a[1].substr(0,2),16)/255,parseInt(a[1].substr(2,2),16)/255,parseInt(a[1].substr(4,2),16)/255)}else{this.colorFromRgb(parseInt(a[1].charAt(0)+a[1].charAt(0),16)/255,parseInt(a[1].charAt(1)+a[1].charAt(1),16)/255,parseInt(a[1].charAt(2)+a[1].charAt(2),16)/255)}}};this.colorFromRgb=function(e,d,a){if(this.colorRGB){if(e!=null){this.colorRGB[0]=Math.min(Math.max(0,e),1)}if(d!=null){this.colorRGB[1]=Math.min(Math.max(0,d),1)}if(a!=null){this.colorRGB[2]=Math.min(Math.max(0,a),1)}var c=this.rgbFromHsv(this.colorRGB[0],this.colorRGB[1],this.colorRGB[2]);if(c[0]!=null){this.colorHSV[0]=c[0]}if(c[2]!=0){this.colorHSV[1]=c[1]}this.colorHSV[2]=c[2]}};this.rgbFromHsv=function(i,f,c){var j=Math.min(Math.min(i,f),c);var d=Math.max(Math.max(i,f),c);var a=d-j;if(a==0){return[null,0,d]}else{var e=i==j?3+(c-f)/a:(f==j?5+(i-c)/a:1+(f-i)/a);return[e==6?0:e,a/d,d]}};this.colorFromHsv=function(c,b,a){if(c!=null){this.colorHSV[0]=Math.min(Math.max(0,c),6)}if(b!=null){this.colorHSV[1]=Math.min(Math.max(0,b),1)}if(a!=null){this.colorHSV[2]=Math.min(Math.max(0,a),1)}this.colorRGB=this.hsvFromRgb(this.colorHSV[0],this.colorHSV[1],this.colorHSV[2])};this.hsvFromRgb=function(e,d,b){if(e==null){return[b,b,b]}var c=Math.floor(e);var g=c%2?e-c:1-(e-c);var a=b*(1-d);var j=b*(1-d*g);switch(c){case 0:return[b,j,a];case 1:return[j,b,a];case 2:return[a,b,j];case 3:return[a,j,b];case 4:return[j,a,b];case 5:return[b,a,j];case 6:return[b,a,j]}};this.colorRGBToString=function(){if(this.colorRGB){return(256|Math.round(255*this.colorRGB[0])).toString(16).substr(1)+(256|Math.round(255*this.colorRGB[1])).toString(16).substr(1)+(256|Math.round(255*this.colorRGB[2])).toString(16).substr(1)}};this.getColorNames=function(){return this.sortObject(CanvasXpress.colorNames)};this.getColorSchemes=function(){return this.sortObject(CanvasXpress.colorSchemes)};this.getHexColor=function(b){var c=/^#?[0-9a-fA-F]{6}$/i;var a=/rgb\((\d{1,3}),(\d{1,3}),(\d{1,3})\)/;if(c.test(b)){return b.substring(b.length-6,b.length)}else{if(a.test(b)){return this.rgbToHex(b)}else{var d=b.toLowerCase();if(CanvasXpress.colorNames.hasOwnProperty(d)){return CanvasXpress.colorNames[d]}else{throw new Error(b+" is not a valid color.")}}}};this.getColorForValue=function(a,c){if(!a){a=this.meta.def.colorBrew}for(var d=0;d<a.breaks.length;d++){if(a.breaks[d]>=c){return a.colors[d]}}return a.colors[a.colors.length-1]};this.setColorForValues=function(a,d){var g=this;var c=function(l){var j=function(t,q){var n=a.grads[l];var s=n.min;var y=n.max;var p=n.scol.substring(t,q);var z=n.ecol.substring(t,q);var v=d<s?s:d>y?y:d;var i=y-s;var w=parseInt(p,16);var m=parseInt(z,16);var u=(m-w)/i;var o=Math.round(u*(v-s)+w);var x=o.toString(16);return x.length==1?"0"+x:x};var k=j(0,2);var h=j(2,4);var b=j(4,6);return g.hexToRgb("#"+k+h+b)};if(!a){a=this.meta.def.colorBrew}if(a.length==1){return c(0)}else{var f=(a.max-a.min)/a.grads.length;var e=Math.min(Math.floor((Math.max(d,a.min)-a.min)/f),a.grads.length-1);return c(e)}};this.getColorBrew=function(L,C,F,g,f,c){var h=L||this.colorSpectrum;if(C!=null&&F!=null&&C==F){F+=0.1}var G=C!=null?C:this.minData!=null?this.minData:0;var t=F!=null?F:this.maxData!=null?this.maxData:100;var J=!c&&this.setMinX!=null?this.setMinX:null;var x=!c&&this.setMaxX!=null?this.setMaxX:null;var D,w;var M=[];if(g==null){zero=(G+t)/2}else{zero=g;var D=g-G;var w=t-g;if(D>w){t=g+D}else{G=g-w}}var u=this[this.axisAlgorithm](Math.min(J||G,x||t),Math.max(J||G,x||t),5,this.axisWilkinsonLoose);var H=(u[u.length-1]-u[0])/(h.length-1);var a=this.getAxisDecimals(u[1]-u[0]);var d=this.getMaxText(u);var I=this.measureText(d.toString(),this.font);var q=u[u.length-1]-u[0];var e=q/this.colorSpectrumNumber;if(f&&f.length>1&&f.length==h.length){for(var E=0;E<f.length;E++){f[E]=Number(f[E])}f=f.sort(function(l,i){return l-i});var y=u[0];var B=Math.ceil((this.colorSpectrumNumber-1)/h.length);for(var E=0;E<f.length;E++){var o=f[E];var K=this.seq(y,o,false,B);M=M.concat(K);var m=M.length-1;y=o+(M[m]-M[m-1])}}else{M=this.seq(u[0],u[u.length-1],false,this.colorSpectrumNumber)}while(M.length<this.colorSpectrumNumber){M.push(u[u.length-1])}var A={scol:this.getHexColor(h[0]),ecol:this.getHexColor(h[1]),min:u[0],max:u[0]+H};var k={spectrum:h,stops:f,z:g,colors:[],legend:[],grads:[A],rmin:G,rmax:t,min:u[0],max:u[u.length-1],range:q,zero:zero,vals:u,incr:H,decs:a,breaks:M,maxLevLen:I,maxLevChr:d.toString().length,maxLevStr:d};for(var E=1;E<h.length-1;E++){A={scol:this.getHexColor(h[E]),ecol:this.getHexColor(h[E+1]),min:u[0]+(H*E),max:u[0]+(H*(E+1))};k.grads.push(A)}var j=u[0];for(var E=0;E<this.colorSpectrumNumber;E++){k.colors.push(this.setColorForValues(k,j));j+=e}for(var E=0;E<this.colorSpectrumNumber;E++){j=M[E];k.legend.push(this.setColorForValues(k,j))}return k};this.setColorBrew=function(b,c){this.setColorSpectrum();if(!this.meta.def.colorBrew||b){if(this.meta.vals.colors){this.meta.vals.colors={}}if(this.graphType.match(/Stacked/)){this.meta.def.colorBrew=this.getColorBrew(this.colorSpectrum,this.minDataStacked,this.maxDataStacked,this.colorSpectrumZeroValue,this.colorSpectrumBreaks)}else{if(this.heatmapAutoAdjust||!this.meta.def.colorBrew){this.meta.def.colorBrew=this.getColorBrew(this.colorSpectrum,this.minData,this.maxData,this.colorSpectrumZeroValue,this.colorSpectrumBreaks)}else{var a=this.meta.def.colorBrew;if(c){this.meta.def.colorBrew=this.getColorBrew(this.colorSpectrum,this.minData||a.rmin,this.maxData||a.rmax,this.colorSpectrumZeroValue||a.z,this.colorSpectrumBreaks||a.stops)}else{this.meta.def.colorBrew=this.getColorBrew(this.colorSpectrum,a.rmin,a.rmax,a.z,a.stops)}}}}};this.validateUserColors=function(){var a=[];for(var b=0;b<this.colors.length;b++){a.push(this.validateColor(this.colors[b]))}if(a.length>0){this.colors=a}};this.setFunctionNames("initColor");this.validateUserColors()};CanvasXpress.prototype.initAttributes=function(){this.setStyle=function(c,b,d){var a=this.getCanvasContext();c=this.validateColor(c);if(this.transparency!=null){c=this.addColorTransparency(c,this.transparency)}a.fillStyle=c;a.strokeStyle=c;a.lineWidth=b?b:this.outlineWidth;a.lineCap=d?d:this.capType;this.setShadow(true)};this.setClipBoundaries=function(c){var b,d,a,e;if(c&&c.length==4){b=c[0];d=c[1];a=c[2];e=c[3]}else{b=this.marginLeft+this.offsetX+this.left;d=this.marginTop+this.offsetY+this.top;a=this.x;e=this.y}return[b,d,a,e]};this.setClipArea=function(a){var e=this.getCanvasContext();this.saveCanvas();e.strokeStyle="rgba(255,255,255,0)";var d,f,c,g;if(a){d=a[0];f=a[1];c=a[2];g=a[3]}else{d=this.marginLeft+this.offsetX+this.left;f=this.marginTop+this.offsetY+this.top;c=this.x+1;g=this.y+1}e.rect(d,f,c,g);e.clip();this.meta.state.clip=true};this.resetClipArea=function(){this.restoreCanvas();this.meta.state.clip=false};this.resetStyle=function(){this.setShadow(false)};this.setShadow=function(c){if(this.showShadow){var a=this.getCanvasContext();var b="rgba(255,255,255,0)";if(c){a.shadowOffsetX=this.shadowOffsetX;a.shadowOffsetY=this.shadowOffsetY;a.shadowBlur=this.shadowBlur;a.shadowColor=this.shadowColor}else{a.shadowOffsetX=0;a.shadowOffsetY=0;a.shadowBlur=0;a.shadowColor=this.background;a.strokeStyle="rgba(255,255,255,0)";a.fillStyle="rgba(255,255,255,0)"}}};this.lineTo=function(c,e,b,d){c=~~(c+0.5);e=~~(e+0.5);b=~~(b+0.5);d=~~(d+0.5);if(Math.abs(c-b)==1){c=(c+b)/2;b=c}else{c+=0.5;b+=0.5}if(Math.abs(e-d)==1){e=(e+d)/2;d=e}else{e+=0.5;d+=0.5}var a=this.getCanvasContext();a.moveTo(c,e);a.lineTo(b,d);a.stroke()};this.lineToOld=function(c,e,b,d){if(c==b){c=(((c+0.5)<<1)>>1)+0.5;b=c}else{if(e==d){e=(((e+0.5)<<1)>>1)+0.5;d=e}}var a=this.getCanvasContext();a.moveTo(c,e);a.lineTo(b,d);a.stroke()};this.bitCode=function(b,c){var a=0;if(b[0]<c[0]){a|=1}else{if(b[0]>c[2]){a|=2}}if(b[1]<c[1]){a|=4}else{if(b[1]>c[3]){a|=8}}return a};this.intersect=function(d,c,e,f){return e&8?[d[0]+(c[0]-d[0])*(f[3]-d[1])/(c[1]-d[1]),f[3]]:e&4?[d[0]+(c[0]-d[0])*(f[1]-d[1])/(c[1]-d[1]),f[1]]:e&2?[f[2],d[1]+(c[1]-d[1])*(f[2]-d[0])/(c[0]-d[0])]:e&1?[f[0],d[1]+(c[1]-d[1])*(f[0]-d[0])/(c[0]-d[0])]:null};this.lineClip=function(n,l,h){var k,j,d,m;if(!l){l=this.setClipBoundaries()}if(!h){h=[]}var g=n.length;var e=this.bitCode(n[0],l);var c=[];for(var f=1;f<g;f++){k=n[f-1];j=n[f];d=m=this.bitCode(j,l);while(true){if(!(e|d)){c.push(k);if(d!==m){c.push(j);if(f<g-1){h.push(c);c=[]}}else{if(f===g-1){c.push(j)}}break}else{if(e&d){break}else{if(e){k=this.intersect(k,j,e,l);e=this.bitCode(k,l)}else{j=this.intersect(k,j,d,l);d=this.bitCode(j,l)}}}}e=m}if(c.length){h.push(c)}return h};this.polygonClip=function(j,h){var g,c,f,a,d;if(!h){h=this.setClipBoundaries()}for(var b=1;b<=8;b*=2){g=[];c=j[j.length-1];f=!(this.bitCode(c,h)&b);for(var e=0;e<j.length;e++){a=j[e];d=!(this.bitCode(a,h)&b);if(d!==f){g.push(this.intersect(c,a,b,h))}if(d){g.push(a)}c=a;f=d}j=g;if(!j.length){break}}return g};this.lineIntersect=function(e,l,d,j,b,h,m,g){if((e===d&&l===j)||(b===m&&h===g)){return false}var f=((g-h)*(d-e)-(m-b)*(j-l));if(f===0){return false}var c=((m-b)*(l-h)-(g-h)*(e-b))/f;var a=((d-e)*(l-h)-(j-l)*(e-b))/f;if(c<0||c>1||a<0||a>1){return false}var k=e+c*(d-e);var i=l+c*(j-l);return[k,i]};this.clip=function(v,f,k){var d,c,p,n,j,o,v;var q,e,a,m;var u=[];if(!k){k=this.setClipBoundaries()}var e=k[0];var q=k[1];var a=k[2];var m=k[3];switch(v){case"path":u[0]=[];u[1]=[];for(var g=0;g<f[0].length;g++){c=f[0][g];n=f[1][g];if(c<e||c>a){c=null}if(n<q||n>m){n=null}u[0].push(c);u[1].push(n)}break;case"box":case"rect":case"rectangle":case"rect2":case"rect3":case"roundrect":case"roundrectt":case"roundrectb":case"roundrectr":case"roundrectl":case"roundrecttr":case"roundrecttl":case"roundrectbr":case"roundrectbl":case"roundrect2":case"roundrectd":case"roundrecto":d=this.parseInt(f[0]-(f[2]/2));p=this.parseInt(f[1]-(f[3]/2));c=this.parseInt(d+f[2]);n=this.parseInt(p+f[3]);if(c>d){if(n>p){if(d>a+this.outlineWidth||p>m+this.outlineWidth||c<e||n<q){return false}if(d<e){d=e}if(c>a){c=a}if(p<q){p=q}if(n>m){n=m}}else{if(d>a+this.outlineWidth||n>m+this.outlineWidth||c<e||p<q){return false}if(d<e){d=e}if(c>a){c=a}if(p>m){p=m}if(n<q){n=q}}}else{if(n>p){if(c>a+this.outlineWidth||p>m+this.outlineWidth||d<e||n<q){return false}if(d>a){d=a}if(c<e){c=e}if(p<q){p=q}if(n>m){n=m}}else{if(c>a+this.outlineWidth||n>m+this.outlineWidth||d<e||p<q){return false}if(d>a){d=a}if(c<e){c=e}if(p>m){p=m}if(n<q){n=q}}}u=[d,p,c-d,n-p];break;case"poly":break;case"circle":case"sphere":case"square":case"triangle":case"triangle2":case"equilateral":case"equilateral2":case"diamond":case"rhombus":case"pentagon":case"hexagon":case"octagon":case"oval":case"oval2":case"oval3":case"arc":case"arc2":case"ellipse":case"ellipse2":case"ellipse3":case"plus":case"minus":case"mdavid":case"star":case"pie":case"pie0":case"pie1":case"pie2":case"pie3":case"pie4":case"pie5":case"pie6":case"pie7":case"pie8":case"pie9":case"pacman":case"pacman2":d=parseInt(f[0]);p=parseInt(f[1]);if(d>e+a||d<e||p<q||p>q+m){return false}u=[d,p];break;case"line":d=parseFloat(f[0]);p=parseFloat(f[1]);c=parseFloat(f[2]);n=parseFloat(f[3]);if(d==c){if(d<e||d>a){return false}else{if(p>n){if(p<q){return false}else{if(p>m){p=m}}if(n>m){return false}else{if(n<q){n=q}}}else{if(p>m){return false}else{if(p<q){p=q}}if(n<q){return false}else{if(n>m){n=m}}}}}else{if(p==n){if(p<q||p>m){return false}else{if(d>c){if(d<e){return false}else{if(d>a){d=a}}if(c>a){return false}else{if(c<e){c=e}}}else{if(d>a){return false}else{if(d<e){d=e}}if(c<e){return false}else{if(c>a){c=a}}}}}else{if(d>c){if(d<e||c>a){return false}else{if(p>n){if(p<q||n>m){return false}else{j=p-n;o=d-c;if(d>a){p-=(d-a)*j/o;d=a}if(p>m){d-=(p-m)*o/j;p=m}if(c<e){n+=(e-c)*j/o;c=e}if(n<q){c+=(q-n)*o/j;n=q}}}else{if(n<q||p>m){return false}else{j=n-p;o=d-c;if(d>a){p+=(d-a)*j/o;d=a}if(p<q){d-=(q-p)*o/j;p=q}if(c<e){n-=(e-c)*j/o;c=e}if(n>m){c+=(n-m)*o/j;n=m}}}}}else{if(c<e||d>a){return false}else{if(p>n){if(p<q||n>m){return false}else{j=p-n;o=c-d;if(d<e){p-=(e-d)*j/o;d=e}if(p>m){d+=(p-m)*o/j;p=m}if(c>a){n+=(c-a)*j/o;c=a}if(n<q){c-=(q-n)*o/j;n=q}}}else{if(n<q||p>m){return false}else{j=n-p;o=c-d;if(d<e){p+=(e-d)*j/o;d=e}if(p<q){d+=(q-p)*o/j;p=q}if(c>a){n-=(c-a)*j/o;c=a}if(n>m){c-=(n-m)*o/j;n=m}}}}}}}u=[d,p,c,n];break;default:return false}return u};this.getLineArea=function(P,D,a,B,af,aa,O,T,Q,ab,ac,ad,R,U,V,E){var W=Math.max(O,this.lineWidthEvent);var S=[];var I=["poly"];P=this.validateBezier(P,D,a,B,af,Q,ab);if(P.match(/error/)){if(this.showErrorBars&&this.isNumeric([D,a,B,af,O])){D=Math.ceil(D);B=Math.ceil(B);a=Math.ceil(a);af=Math.ceil(af);O=Math.ceil(O);var K=O/2;if(O>0){I=["poly",D,a-W,B-W,af-W,B-W,af-K,B+W,af-K,B+W,af+K,B-W,af+K,B-W,af+W,D,a+W]}else{I=["poly",B-W,af+W,B-K,af+W,B-K,af-W,B+K,af-W,B+K,af+W,B+W,af+W,D+W,a,D-W,a]}}else{return false}}else{if(P=="spline"||P=="cardinalSpline"){if(D.length<3){return D.length<2?false:this.getLineArea("line",D[0],a[0],D[1],a[1],aa,O,T,Q,ab,ac,ad,R,U,V)}for(var Z=0;Z<D.length;Z++){I.push(D[Z],a[Z]-W);S.push(a[Z]+W,D[Z])}I=I.concat(S.reverse())}else{if(P=="arch"){if(D.length!=3||a.length!=3){return false}for(var Z=0;Z<D.length;Z++){if(!this.isNumeric([D[Z],a[Z]])){return false}}S=this.traceQuadraticCurve(D[0],a[0],D[1],a[1],D[2],a[2],0.25,true);for(var Z=0;Z<S.length;Z++){I.push(S[Z][0],S[Z][1])}S=this.traceQuadraticCurve(D[0],a[0],D[1],a[1],D[2],a[2],0.25);for(var Z=0;Z<S.length;Z++){I.push(S[Z][0],S[Z][1])}}else{if(P=="arc"){I=["poly"];S=this.traceArc(D,a,B,Q,ab,true);for(var Z=0;Z<S.length;Z++){I.push(S[Z][0],S[Z][1])}S=this.traceArc(D,a,B-W,Q,ab);for(var Z=0;Z<S.length;Z++){I.push(S[Z][0],S[Z][1])}}else{if(P=="quadratic"){var v=this.perpendicularLinePoints(D,a,B,af,false,Math.min(1,this.arrowQuadraticFactor*Math.abs(R))*(R>0?-1:1));var C=this.shortenLine(D,a,B,af,Q,ab,P,R);var x=this.parallelLinePoints(C[0],C[1],v[0],v[1],W);var u=this.parallelLinePoints(v[0],v[1],C[2],C[3],W);S=this.traceQuadraticCurve(x[0],x[1],x[4],x[5],u[4],u[5],0.1,true);for(var Z=0;Z<S.length;Z++){I.push(S[Z][0],S[Z][1])}var M=[];S=this.traceQuadraticCurve(x[2],x[3],x[6],x[7],u[6],u[7],0.1,true);for(var Z=0;Z<S.length;Z++){M.push(S[Z][1],S[Z][0])}I=I.concat(M.reverse())}else{if(this.isNumeric([D,a,B,af])){var G=this.shortenLine(D,a,B,af,(Q||0),(ab||0),P);D=G[0];a=G[1];B=G[2];af=G[3];if(ac){G=this.clip("line",[D,a,B,af],ad);if(G){D=G[0];a=G[1];B=G[2];af=G[3]}else{return false}}if(R&&this.isArray(R)&&R.length>0){if(this.isNumeric2DArray(R)){if(P.match(/bezier/i)){if(R[0].length==6){var ae=[R[0][0],R[0][1]];for(var Z=0;Z<R.length;Z++){ae=ae.concat(R[Z])}ae.push(R[R.length-1][0],R[R.length-1][1]);var d=this.cloneObject(ae);for(var Z=0;Z<R.length;Z++){S=this.traceBezierCurve(d[0],d[1]-W,d[2],d[3]-W,d[4],d[5]-W,d[6],d[7]-W,0.1,true);for(var Y=0;Y<S.length;Y++){I.push(S[Y][0],S[Y][1])}for(var Y=0;Y<6;Y++){d.shift()}}d=this.cloneObject(ae);var M=[];for(var Z=0;Z<R.length;Z++){S=this.traceBezierCurve(d[0],d[1]+W,d[2],d[3]+W,d[4],d[5]+W,d[6],d[7]+W,0.1,true);for(var Y=0;Y<S.length;Y++){M.push(S[Y][1],S[Y][0])}for(var Y=0;Y<6;Y++){d.shift()}}I=I.concat(M.reverse())}else{if(R.length==4){var x=this.parallelLinePoints(R[0][0],R[0][1],R[1][0],R[1][1],W);var u=this.parallelLinePoints(R[2][0],R[2][1],R[3][0],R[3][1],W);S=this.traceBezierCurve(x[0],x[1],x[4],x[5],u[0],u[1],u[4],u[5],0.1,true);for(var Y=0;Y<S.length;Y++){I.push(S[Y][0],S[Y][1])}S=this.traceBezierCurve(x[2],x[3],x[6],x[7],u[2],u[3],u[6],u[7],0.1,true);var M=[];for(var Y=0;Y<S.length;Y++){M.push(S[Y][1],S[Y][0])}I=I.concat(M.reverse())}else{var A=this.parallelLinePoints(R[0][0],R[0][1],R[R.length-1][0],R[R.length-1][1],W);I=["poly",A[0],A[1],A[2],A[3],A[6],A[7],A[4],A[5]]}}}else{if(R.length>2){I=["poly"];var L=[];for(var Z=0;Z<R.length-1;Z++){L.push([R[Z][0],R[Z][1]])}for(var Z=R.length-1;Z>=1;Z--){L.push([R[Z][0],R[Z][1]])}S=this.enlargePolygon(L,W,1);for(var Z=0;Z<S.length;Z++){I.push(S[Z][0],S[Z][1])}}else{var A=this.parallelLinePoints(R[0][0],R[0][1],R[1][0],R[1][1],W);I=["poly",A[0],A[1],A[2],A[3],A[6],A[7],A[4],A[5]]}}}else{return false}}else{if(P.match(/curved/i)){var z=D==B&&a==af&&E;var o=this.lineMidPoint(D,a,B,af);var N=this.lineLength(D,a,o[0],o[1]);var J=(Q||0)/N;var F=(ab||0)/N;var y=P.match(/curvedcc/i)&&D>B?false:!P.match(/curvedcc/i)&&B>=D?true:false;var l=B>=D?Math.asin((o[1]-a)/N):Math.asin(-(o[1]-a)/N);var X=l+Math.PI;var k=[];if(z){if(l<0){l+=Math.PI*2}var r=E.size*1.25;var H=E.size/1.25;switch(E.pos){case"top":k=[D,a-r,H,Math.PI*0.75,Math.PI*0.25,false];break;case"topRight":k=[D+r,a-r,H,Math.PI,Math.PI*0.5,false];break;case"right":k=[D+r,a,H,Math.PI*1.25,Math.PI*0.75,false];break;case"bottomRight":k=[D+r,a+r,H,Math.PI*1.5,Math.PI,false];break;case"bottom":k=[D,a+r,H,Math.PI*1.75,Math.PI*1.25,false];break;case"bottomLeft":k=[D-r,a+r,H,0,Math.PI*1.5,false];break;case"left":k=[D-r,a,H,Math.PI*0.25,Math.PI*1.75,false];break;case"topLeft":k=[D-r,a-r,H,Math.PI*0.5,0,false];break}}else{if(B>=D){k=[o[0],o[1],Math.max(0,N),l-F,X+J,y]}else{k=[o[0],o[1],Math.max(0,N),l+J,X-F,y]}}I=["poly"];S=this.traceArc(k[0],k[1],k[2]+W,k[3],k[4],k[5]);for(var Z=0;Z<S.length;Z++){I.push(S[Z][0],S[Z][1])}S=this.traceArc(k[0],k[1],k[2]-W,k[3],k[4],!k[5]);for(var Z=0;Z<S.length;Z++){I.push(S[Z][0],S[Z][1])}}else{if(P.match(/bezier/i)){var h=(D+B)/2;var g=(a+af)/2;if(P.match(/beziery/i)){S=this.traceBezierCurve(D,a-W,D,g-W,B,g-W,B,af-W,0.25,true)}else{S=this.traceBezierCurve(D,a-W,h,a-W,h,af-W,B,af-W,0.25,true)}for(var Z=0;Z<S.length;Z++){I.push(S[Z][0],S[Z][1])}if(P.match(/beziery/i)){S=this.traceBezierCurve(D,a+W,D,g+W,B,g+W,B,af+W,0.25)}else{S=this.traceBezierCurve(D,a+W,h,a+W,h,af+W,B,af+W,0.25)}for(var Z=0;Z<S.length;Z++){I.push(S[Z][0],S[Z][1])}}else{if(D==B&&a!=af){I=["poly",D-W,a,D+W,a,B+W,af,B-W,af]}else{if(a==af&&D!=B){I=["poly",D,a-W,B,a-W,B,af+W,D,af+W]}else{var A=this.parallelLinePoints(D,a,B,af,W);I=["poly",A[0],A[1],A[2],A[3],A[6],A[7],A[4],A[5]]}}}}}}else{return false}}}}}}if(this.graphType=="Network"){return this.preScaleNetwork&&!this.isAnimation?I:this.adjustNetworkObjects(I)}else{return I}};this.setDashDot=function(c){var a=this.getCanvasContext();var b=[];this.tempCap=a.lineCap;if(c.match(/blank/i)){b=CanvasXpress.R.lty[0]}else{if(c.match(/solid/i)){b=CanvasXpress.R.lty[1]}else{if(c.match(/dashed/i)){b=CanvasXpress.R.lty[2];b=[this.dashLength,this.dashLength-2]}else{if(c.match(/dotted/i)){b=CanvasXpress.R.lty[3];b=[this.dotLength,this.dotLength+2]}else{if(c.match(/dotdash/i)){b=CanvasXpress.R.lty[4]}else{if(c.match(/longdash/i)){b=CanvasXpress.R.lty[5]}else{if(c.match(/twodash/i)){b=CanvasXpress.R.lty[6]}}}}}}}a.setLineDash(b)};this.resetDashDot=function(){var a=this.getCanvasContext();a.lineCap=this.tempCap;a.setLineDash([])};this.validateBezier=function(c,b,g,a,f,d,h){if(this.adjustBezier){if(c.match(/bezier/i)&&(b==a||g==f)){return"line"}if(Math.abs(a-b)>=Math.abs(f-g)){if(c.match(/beziery/i)){c=c.replace("beziery","bezier");c=c.replace("bezierY","bezier")}}else{if(c.match(/bezierx/i)){c=c.replace("bezierx","beziery");c=c.replace("bezierX","bezierY")}else{if(c.match(/bezier/i)){c=c.replace("bezier","bezierY")}}}if(d!=null&&h!=null){if(c.match(/beziery/i)){if(f>g){if(g+d>f-h){c="line"}}else{if(g-d<f+h){c="line"}}}else{if(c.match(/beziery/i)){if(a>b){if(b+d>a-h){c="line"}}else{if(b-d<a+h){c="line"}}}}}}return c};this.drawLine=function(L,z,a,x,ab,U,K,P,N,W,X,Z,O,Q,R,A){this.functionCallerDraw="drawLine";var B=this.getCanvasContext();this.setDashDot(L);L=this.validateBezier(L,z,a,x,ab,N,W);var d=false;var C=function(b){switch(b){case"arrow":d=0;break;case"square":d=1;break;case"round":d=2;break;case"roundDocked":d=false;break}};if(L.match(/error/)){if(this.showErrorBars&&this.isNumeric([z,a,x,ab,K])){z=Math.ceil(z);x=Math.ceil(x);a=Math.ceil(a);ab=Math.ceil(ab);K=Math.ceil(K);var I=K/2;this.setStyle(U,false,P);if(!this.isColorTransparent(U)){B.beginPath();this.lineTo(z,a,x,ab);if(Math.abs(K)>this.errorBarsWidth){if(K>0){this.lineTo(x,ab-I,x,ab+I)}else{this.lineTo(x-I,ab,x+I,ab)}}}}this.resetStyle()}else{if(L.match(/spline|cardinalSpline/)){if(z.length<3){return z.length<2?false:this.drawLine("line",z[0],a[0],z[1],a[1],U,K,P,N,W,X,Z,O,Q,R)}var M=[];var Y=[];var V=0;for(var T=0;T<z.length;T++){if(this.isNumeric([z[T],a[T]])){Y.push(z[T],a[T]);V+=2}else{return}}this.setStyle(U,K,P);if(!this.isColorTransparent(U)){if(L.match(/spline/)){for(var T=0;T<V-4;T+=2){M=M.concat(this.splineControlPoint(Y[T],Y[T+1],Y[T+2],Y[T+3],Y[T+4],Y[T+5]))}B.beginPath();B.moveTo(Y[0],Y[1]);B.quadraticCurveTo(M[0],M[1],Y[2],Y[3]);for(var T=2;T<V-5;T+=2){B.bezierCurveTo(M[2*T-2],M[2*T-1],M[2*T],M[2*T+1],Y[T+2],Y[T+3])}B.moveTo(Y[V-2],Y[V-1]);B.quadraticCurveTo(M[2*V-10],M[2*V-9],Y[V-4],Y[V-3]);B.stroke()}else{Y=this.curvePoints(Y);B.beginPath();B.moveTo(Y[0],Y[1]);for(var T=2;T<Y.length-1;T+=2){B.lineTo(Y[T],Y[T+1])}B.stroke()}}this.resetStyle()}else{if(L.match(/arch/)){if(z.length!=3||a.length!=3){return false}for(var T=0;T<z.length;T++){if(!this.isNumeric([z[T],a[T]])){return false}}this.setStyle(U,K,P);if(!this.isColorTransparent(U)){B.beginPath();B.moveTo(z[0],a[0]);B.quadraticCurveTo(z[1],a[1],z[2],a[2]);B.stroke()}this.resetStyle()}else{if(L=="arc"){this.setStyle(U,K,P);B.beginPath();B.arc(z,a,Math.max(0,x),N,W,false);B.stroke();this.resetStyle()}else{if(L=="quadratic"){this.setStyle(U,K,P);var r=this.perpendicularLinePoints(z,a,x,ab,false,Math.min(1,this.arrowQuadraticFactor*Math.abs(O))*(O>0?-1:1));var y=this.shortenLine(z,a,x,ab,N,W,L,O);var aa=this.traceQuadraticCurve(y[0],y[1],r[0],r[1],y[2],y[3],0.1,true);B.beginPath();B.moveTo(y[0],y[1]);B.quadraticCurveTo(r[0],r[1],y[2],y[3]);B.stroke();this.resetStyle();if(R){z=aa[9][0];a=aa[9][1];x=y[2];ab=y[3];C(R);this.drawArrowHead(z,a,x,ab,U,K,d)}if(Q){z=aa[1][0];a=aa[1][1];x=y[0];ab=y[1];C(Q);this.drawArrowHead(z,a,x,ab,U,K,d,true)}}else{if(this.isNumeric([z,a,x,ab])){var E=this.shortenLine(z,a,x,ab,(N||0),(W||0),L);z=E[0];a=E[1];x=E[2];ab=E[3];if(X){E=this.clip("line",[z,a,x,ab],Z);if(E){z=E[0];a=E[1];x=E[2];ab=E[3]}else{return false}}if(O&&this.isArray(O)&&O.length>0){var G=O.length-1;if(this.isNumeric2DArray(O)){this.setStyle(U,K,P);if(L.match(/bezier/i)){if(!this.isColorTransparent(U)){if(O[0].length==6){B.beginPath();B.moveTo(O[0][0],O[0][1]);for(var T=0;T<O.length;T++){B.bezierCurveTo(O[T][0],O[T][1],O[T][2],O[T][3],O[T][4],O[T][5])}B.stroke();var aa;if(R){aa=this.traceBezierCurve(O[G][0],O[G][1],O[G][0],O[G][1],O[G][2],O[G][3],O[G][4],O[G][5],0.1,true);z=aa[9][0];a=aa[9][1];x=aa[10][0];ab=aa[10][1];C(R);this.drawArrowHead(z,a,x,ab,U,K,d)}if(Q){aa=this.traceBezierCurve(O[0][0],O[0][1],O[0][0],O[0][1],O[0][2],O[0][3],O[0][4],O[0][5],0.1,true);z=aa[1][0];a=aa[1][1];x=aa[0][0];ab=aa[0][1];C(Q);this.drawArrowHead(z,a,x,ab,U,K,d,true)}}else{if(O.length==4){B.beginPath();B.moveTo(O[0][0],O[0][1]);B.bezierCurveTo(O[1][0],O[1][1],O[2][0],O[2][1],O[3][0],O[3][1]);B.stroke();var aa=this.traceBezierCurve(O[0][0],O[0][1],O[1][0],O[1][1],O[2][0],O[2][1],O[3][0],O[3][1],0.1,true);if(R){z=aa[9][0];a=aa[9][1];x=O[3][0];ab=O[3][1];C(R);this.drawArrowHead(z,a,x,ab,U,K,d)}if(Q){z=aa[1][0];a=aa[1][1];x=O[1][0];ab=O[1][1];C(Q);this.drawArrowHead(z,a,x,ab,U,K,d,true)}}else{B.beginPath();B.moveTo(O[0][0],O[0][1]);this.lineTo(O[G][0],O[G][1]);B.stroke();if(R){z=O[G-1][0];a=O[G-1][1];x=O[G][0];ab=O[G][1];C(R);this.drawArrowHead(z,a,x,ab,U,K,d)}if(Q){z=O[0][0];a=O[0][1];x=O[1][0];ab=O[1][1];C(Q);this.drawArrowHead(z,a,x,ab,U,K,d,true)}}}}}else{if(!this.isColorTransparent(U)){B.beginPath();this.lineTo(O[0][0],O[0][1],O[1][0],O[1][1]);for(var T=1;T<G;T++){this.lineTo(O[T][0],O[T][1],O[T+1][0],O[T+1][1])}if(R){z=O[G-1][0];a=O[G-1][1];x=O[G][0];ab=O[G][1];C(R);this.drawArrowHead(z,a,x,ab,U,K,d)}if(Q){z=O[0][0];a=O[0][1];x=O[1][0];ab=O[1][1];C(Q);this.drawArrowHead(z,a,x,ab,U,K,d,true)}}}this.resetStyle()}else{return false}}else{if(L.match(/curved/i)){var v=z==x&&a==ab&&A;var l=this.lineMidPoint(z,a,x,ab);var J=this.lineLength(z,a,l[0],l[1]);var H=(N||0)/J;var D=(W||0)/J;var u=L.match(/curvedcc/i)&&z>x?false:!L.match(/curvedcc/i)&&x>=z?true:false;var k=x>=z?Math.asin((l[1]-a)/J):Math.asin(-(l[1]-a)/J);var S=k+Math.PI;var j=[];this.setStyle(U,K,P);if(!this.isColorTransparent(U)){B.beginPath();if(v){if(k<0){k+=Math.PI*2}if(A.dir){R=false;Q=A.end}else{R=A.end;Q=false}var o=A.size*1.25;var F=A.size/1.25;switch(A.pos){case"top":j=[z,a-o,F,Math.PI*0.75,Math.PI*0.25,false];break;case"topRight":j=[z+o,a-o,F,Math.PI,Math.PI*0.5,false];break;case"right":j=[z+o,a,F,Math.PI*1.25,Math.PI*0.75,false];break;case"bottomRight":j=[z+o,a+o,F,Math.PI*1.5,Math.PI,false];break;case"bottom":j=[z,a+o,F,Math.PI*1.75,Math.PI*1.25,false];break;case"bottomLeft":j=[z-o,a+o,F,0,Math.PI*1.5,false];break;case"left":j=[z-o,a,F,Math.PI*0.25,Math.PI*1.75,false];break;case"topLeft":j=[z-o,a-o,F,Math.PI*0.5,0,false];break}}else{if(x>=z){j=[l[0],l[1],Math.max(0,J),k-D,S+H,u]}else{j=[l[0],l[1],Math.max(0,J),k+H,S-D,u]}}B.arc(j[0],j[1],j[2],j[3],j[4],j[5]);var aa=this.traceArc(j[0],j[1],j[2],j[3],j[4],j[5]);B.stroke()}this.resetStyle();if(R){C(R);z=aa[15][0];a=aa[15][1];x=aa[16][0];ab=aa[16][1];this.drawArrowHead(z,a,x,ab,U,K,d)}if(Q){z=aa[1][0];a=aa[1][1];x=aa[0][0];ab=aa[0][1];C(Q);this.drawArrowHead(z,a,x,ab,U,K,d,true)}}else{if(L.match(/bezier/i)){var h=(z+x)/2;var g=(a+ab)/2;var aa;this.setStyle(U,K,P);if(!this.isColorTransparent(U)){B.beginPath();B.moveTo(z,a);if(L.match(/beziery/i)){B.bezierCurveTo(z,g,x,g,x,ab);aa=this.traceBezierCurve(z,a,z,g,x,g,x,ab,0.1,true)}else{B.bezierCurveTo(h,a,h,ab,x,ab);aa=this.traceBezierCurve(z,a,h,a,h,ab,x,ab,0.1,true)}B.stroke()}this.resetStyle();if(R){z=aa[9][0];a=aa[9][1];x=aa[10][0];ab=aa[10][1];C(R);this.drawArrowHead(z,a,x,ab,U,K,d)}if(Q){x=aa[0][0];ab=aa[0][1];z=aa[1][0];a=aa[1][1];C(Q);this.drawArrowHead(z,a,x,ab,U,K,d,true)}}else{this.setStyle(U,K,P);if(!this.isColorTransparent(U)){B.beginPath();this.lineTo(z,a,x,ab)}this.resetStyle();if(R){C(R);this.drawArrowHead(z,a,x,ab,U,K,d)}if(Q){C(Q);this.drawArrowHead(z,a,x,ab,U,K,d,true)}}}}}else{this.resetDashDot();return false}}}}}}this.resetDashDot()};this.drawArrowHead=function(v,c,t,b,u,l,h,e){var q=this.getCanvasContext();var s=function(z,C,f,D){var w=[];for(var A=0;A<z.length;A++){w.push([(z[A][0]*Math.cos(C))-(z[A][1]*Math.sin(C)),(z[A][0]*Math.sin(C))+(z[A][1]*Math.cos(C))])}var B=[];for(var A=0;A<w.length;A++){B.push([w[A][0]+f,w[A][1]+D])}return B};var p=this.arrowPointSize;var d=Math.max((p/2)-1,1);var a=Math.max((p*2/3),1);var n=l?l/2:this.outlineWidth/2;var j=l?l*2:this.outlineWidth*2;var o=h==1?[[-n,-p],[-n,p]]:h==0?[[1.5,-0.5],[-p,-d*l],[-p,d*l]]:false;var m=t-v;var k=b-c;this.setStyle(u,h==1?l+2:l);if(h<2){var g=s(o,Math.atan2(k,m),t,b);q.beginPath();q.moveTo(g[0][0],g[0][1]);for(var r=1;r<g.length;r++){if(!isNaN(g[r][0])&&!isNaN(g[r][1])){q.lineTo(g[r][0],g[r][1])}}if(h==0){if(!isNaN(g[0][0])&&!isNaN(g[0][1])){q.lineTo(g[0][0],g[0][1])}q.closePath();q.fill()}else{q.closePath();q.stroke()}}else{if(h==2){q.beginPath();q.arc(t,b,Math.max(0,d*1.3),0,Math.PI*2,true);q.closePath();q.fill()}else{}}this.resetStyle()};this.createPatterns=function(){var h=function(c){c.strokeStyle="rgb(29,137,182)";var j=[4,6,9,12,16,21,27,14,17,21,26];var l=[27,21,16,12,9,6,4,26,21,17,14];for(var k=0;k<j.length;k++){c.moveTo(j[k],l[k]);c.arc(j[k],l[k],2,0,Math.PI*2)}c.moveTo(3,32);c.arc(3,32,2,Math.PI,0);c.moveTo(13,32);c.arc(13,32,2,Math.PI,0);c.moveTo(32,3);c.arc(32,3,2,Math.PI*0.5,Math.PI*1.5);c.moveTo(32,13);c.arc(32,13,2,Math.PI*0.5,Math.PI*1.5);j=[[7,11],[8,12],[11,14],[14,17],[18,20],[22,24],[28,29]];l=[[28,29],[22,24],[18,20],[14,17],[11,14],[8,12],[7,11]];for(var k=0;k<j.length;k++){c.moveTo(j[k][0],l[k][0]);c.lineTo(j[k][1],l[k][1])}c.stroke()};var g=function(c){c.strokeStyle="rgb(29,137,182)";c.moveTo(3,0);c.arc(3,0,2,Math.PI,0,true);c.moveTo(3,5);c.arc(3,5,2,Math.PI,0);c.moveTo(6,1);c.lineTo(8,4);c.lineTo(10,1);c.moveTo(13,0);c.arc(13,0,2,Math.PI,0,true);c.moveTo(13,5);c.arc(13,5,2,Math.PI,0);c.stroke()};var d=function(c){c.strokeStyle="rgb(29,137,182)";c.moveTo(0,3);c.arc(0,3,2,Math.PI*1.5,Math.PI*0.5);c.moveTo(5,3);c.arc(5,3,2,Math.PI*1.5,Math.PI*0.5,true);c.moveTo(1,6);c.lineTo(4,8);c.lineTo(1,10);c.moveTo(0,13);c.arc(0,13,2,Math.PI*1.5,Math.PI*0.5);c.moveTo(5,13);c.arc(5,13,2,Math.PI*1.5,Math.PI*0.5,true);c.stroke()};var b=this.getCanvasContext();var e;var f=document.createElement("canvas");f.width=5;f.height=5;var a=f.getContext("2d");a.clearRect(0,0,5,5);a.beginPath();a.moveTo(0,0);a.lineTo(5,5);a.stroke();CanvasXpress.cachePatterns.hatchForward=b.createPattern(f,"repeat");a.clearRect(0,0,5,5);a.beginPath();a.moveTo(5,0);a.lineTo(0,5);a.stroke();CanvasXpress.cachePatterns.hatchReverse=b.createPattern(f,"repeat");f.width=3;f.height=3;a.clearRect(0,0,3,3);a.beginPath();a.moveTo(1.5,0);a.lineTo(1.5,3);a.stroke();CanvasXpress.cachePatterns.stripeVertical=b.createPattern(f,"repeat");a.clearRect(0,0,3,3);a.beginPath();a.moveTo(0,1.5);a.lineTo(3,1.5);a.stroke();CanvasXpress.cachePatterns.stripeHorizontal=b.createPattern(f,"repeat");f.width=5;f.height=5;a.clearRect(0,0,5,5);a.beginPath();a.arc(2.5,2.5,2,0,Math.PI*2);a.fill();CanvasXpress.cachePatterns.polkaDot=b.createPattern(f,"repeat");a.clearRect(0,0,5,5);a.beginPath();a.moveTo(0,0);a.lineTo(5,5);a.stroke();a.beginPath();a.moveTo(5,0);a.lineTo(0,5);a.stroke();CanvasXpress.cachePatterns.crossHatch=b.createPattern(f,"repeat");f.width=3;f.height=3;a.clearRect(0,0,3,3);a.beginPath();a.moveTo(1.5,0);a.lineTo(1.5,3);a.stroke();a.beginPath();a.moveTo(0,1.5);a.lineTo(3,1.5);a.stroke();CanvasXpress.cachePatterns.crossStripe=b.createPattern(f,"repeat");f.width=5;f.height=5;a.clearRect(0,0,5,5);a.beginPath();a.strokeRect(1,1,4,4);a.stroke();CanvasXpress.cachePatterns.squares=b.createPattern(f,"repeat");a.clearRect(0,0,5,5);a.beginPath();a.arc(2.5,2.5,1,0,Math.PI*2);a.stroke();CanvasXpress.cachePatterns.circles=b.createPattern(f,"repeat");f.width=7;f.height=7;a.clearRect(0,0,7,7);a.beginPath();a.moveTo(3.5,1);a.lineTo(3.5,6);a.stroke();a.beginPath();a.moveTo(1,3.5);a.lineTo(6,3.5);a.stroke();CanvasXpress.cachePatterns.plus=b.createPattern(f,"repeat");f.width=7;f.height=7;a.clearRect(0,0,7,7);a.beginPath();a.moveTo(1,3.5);a.lineTo(6,3.5);a.stroke();CanvasXpress.cachePatterns.minus=b.createPattern(f,"repeat");f.width=7;f.height=7;a.clearRect(0,0,7,7);a.beginPath();a.moveTo(3.5,1);a.lineTo(3.5,6);a.stroke();CanvasXpress.cachePatterns.bars=b.createPattern(f,"repeat");f.width=5;f.height=5;a.clearRect(0,0,5,5);a.beginPath();a.moveTo(0,5);a.lineTo(2.5,0);a.lineTo(5,5);a.stroke();CanvasXpress.cachePatterns.squiglesHorizontal=b.createPattern(f,"repeat");f.width=5;f.height=5;a.clearRect(0,0,5,5);a.beginPath();a.moveTo(0,0);a.lineTo(5,2.5);a.lineTo(0,5);a.stroke();CanvasXpress.cachePatterns.squiglesVertical=b.createPattern(f,"repeat");a.clearRect(0,0,5,5);a.beginPath();a.moveTo(0,0);a.lineTo(3,0);a.lineTo(0,3);a.closePath();a.stroke();a.fill();a.beginPath();a.moveTo(2,5);a.lineTo(5,2);a.lineTo(5,5);a.closePath();a.stroke();a.fill();CanvasXpress.cachePatterns.brickForward=b.createPattern(f,"repeat");a.clearRect(0,0,5,5);a.beginPath();a.moveTo(5,0);a.lineTo(2,0);a.lineTo(5,3);a.closePath();a.stroke();a.fill();a.beginPath();a.moveTo(0,5);a.lineTo(0,2);a.lineTo(3,5);a.closePath();a.stroke();a.fill();CanvasXpress.cachePatterns.brickReverse=b.createPattern(f,"repeat");a.clearRect(0,0,5,5);a.beginPath();a.arc(2.5,2.5,2,0,Math.PI*2);a.moveTo(0,5);a.lineTo(5,0);a.stroke();CanvasXpress.cachePatterns.art=b.createPattern(f,"repeat");a.clearRect(0,0,5,5);a.beginPath();a.moveTo(2,0);a.lineTo(0,0);a.lineTo(0,3);a.lineTo(2,3);a.stroke();a.beginPath();a.moveTo(3,3);a.lineTo(5,5);a.stroke();a.beginPath();a.moveTo(5,3);a.lineTo(3,5);a.stroke();CanvasXpress.cachePatterns.pcx=b.createPattern(f,"repeat");f.width=5;f.height=3;a.clearRect(0,0,5,3);a.beginPath();a.moveTo(0,0);a.lineTo(5,3);a.stroke();CanvasXpress.cachePatterns.hatchForward3=b.createPattern(f,"repeat");a.clearRect(0,0,5,3);a.beginPath();a.moveTo(5,0);a.lineTo(0,3);a.stroke();CanvasXpress.cachePatterns.hatchReverse3=b.createPattern(f,"repeat");f.width=5;f.height=16;a.clearRect(0,0,5,16);d(a);CanvasXpress.cachePatterns.membraneTop=b.createPattern(f,"repeat-x");f.width=5;f.height=16;a.clearRect(0,0,5,16);a.translate(5,0);a.scale(-1,1);d(a);CanvasXpress.cachePatterns.membraneBottom=b.createPattern(f,"repeat-x");f.width=16;f.height=5;a.clearRect(0,0,16,5);g(a);CanvasXpress.cachePatterns.membraneRight=b.createPattern(f,"repeat-y");f.width=16;f.height=5;a.clearRect(0,0,16,5);a.translate(0,5);a.scale(1,-1);g(a);CanvasXpress.cachePatterns.membraneLeft=b.createPattern(f,"repeat-y");f.width=32;f.height=32;a.clearRect(0,0,32,32);h(a);CanvasXpress.cachePatterns.membraneTL=b.createPattern(f,"no-repeat");f.width=32;f.height=32;a.clearRect(0,0,32,32);a.translate(0,32);a.scale(1,-1);h(a);CanvasXpress.cachePatterns.membraneBL=b.createPattern(f,"no-repeat");f.width=32;f.height=32;a.clearRect(0,0,32,32);a.translate(32,0);a.scale(-1,1);h(a);CanvasXpress.cachePatterns.membraneTR=b.createPattern(f,"no-repeat");f.width=32;f.height=32;a.clearRect(0,0,32,32);a.translate(32,32);a.scale(-1,-1);h(a);CanvasXpress.cachePatterns.membraneBR=b.createPattern(f,"no-repeat")};this.sphere=function(f,e,d,m,h,g,F,E,D){var c=Math.sin(F);var A=Math.cos(F);var b=Math.sin(E);var x=Math.cos(E);var a=Math.sin(D);var v=Math.cos(D);var C=function(j){var k=j.y;j.y=(k*A)+(j.z*c*-1);j.z=(k*c)+(j.z*A);var i=j.x;j.x=(i*x)+(j.z*b*-1);j.z=(i*b)+(j.z*x);var i=j.x;j.x=(i*v)+(j.y*a*-1);j.y=(i*a)+(j.y*v)};var l=[];var n=Math.PI/12;var t=Math.PI*2;var r=Math.PI/2;for(var B=1;B>=-1;B-=2){for(var z=0;z<r;z+=n){var u=Math.cos(z)*m;var o=Math.cos(z)*g;var q=Math.sin(z)*h*B*-1;for(var w=0;w<t;w+=n){var s={x:(Math.cos(w)*u),y:q,z:(Math.sin(w)*o)};C(s);s.x+=f;s.y+=e;s.z+=d;if(B>0){l.push([s.x,s.y,s.z])}else{l.unshift([s.x,s.y,s.z])}}}}return l};this.drawShapeSetShapeStyle=function(j,i,k,d,e,c,b,a,g){var l=this.getCanvasContext();this.saveCanvas();this.translateCanvas(j,i);if(a){this.rotateCanvas(a)}if(this.transparency!=null){e=this.addColorTransparency(e,this.transparency)}if(this.gradient){if(this.gradientType=="radial"){l.fillStyle=this.getGradient(0,0,Math.max(Math.abs(k),Math.abs(d)),e)}else{l.fillStyle=this.getGradient(0,0,k,d,e)}}else{if(b){switch(b){case"closed":case"solid":l.fillStyle=e;break;case"open":break;default:l.fillStyle=CanvasXpress.cachePatterns[b]?CanvasXpress.cachePatterns[b]:e;break}}else{l.fillStyle=e}}l.strokeStyle=c?c:this.foreground;l.lineWidth=g?g:this.outlineWidth;l.lineJoin=this.joinType;if((k&&l.lineWidth>=k)||(d&&l.lineWidth>=d)){l.strokeStyle=e}this.setShadow(true)};this.drawShapeDraw=function(d,c){var b=this.getCanvasContext();if(d&&d.length>1){var a=d.shift();while(a[0]==null||a[1]==null){a=d.shift()}b.beginPath();b.moveTo(a[0]+0.5,a[1]+0.5);while(d.length>0){a=d.shift();while(a[0]==null||a[1]==null){a=d.shift()}b.lineTo(a[0]+0.5,a[1]+0.5)}if(!c){b.closePath()}}};this.drawShapeFillStroke=function(b,d,c){var a=this.getCanvasContext();if(c&&c=="open"){a.stroke()}else{if(d==b||a.strokeStyle==a.fillStyle){a.fill()}else{a.fill();a.stroke()}}};this.drawShapeRestore=function(a,d,c){var b=this.getCanvasContext();this.setShadow(false);if(c){this.rotateCanvas(-c)}this.translateCanvas(-a,-d);this.restoreCanvas()};this.getShapeArea=function(v,m,l,n,G,H,D,C,B,k,L,M,A,I,q,J){var j=this;var F=function(d){if(j.graphType=="Network"){return d}d.shift();var b=["poly"];var f=Math.cos(B);var c=Math.sin(B);for(var e=0;e<d.length;e+=2){b.push((f*(m-d[e]))+(c*(l-d[e+1]))+d[e]);b.push((f*(l-d[e+1]))-(c*(m-d[e]))+d[e+1])}return b};var g,a;var N=["poly"];var K=[];if(!M){M=this.setClipBoundaries()}switch(v){case"arc2":K=this.traceArc1(m,l,G,A,I,true);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}K=this.traceArc1(m,l,G-n,A,I);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}break;case"pie":N.push(m,l);K=this.traceArc1(m,l,G,A,I,true);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}break;case"confidence":for(var E=0;E<m.length;E++){N.push(m[E][0],l[E][0]);K.push(l[E][1],m[E][1])}N=N.concat(K.reverse());break;case"violin":for(var E=0;E<m[0].length;E++){N.push(m[0][E],l[0][E]);K.push(l[1][E],m[1][E])}N=N.concat(K.reverse());break;case"bezier":K=this.traceBezierCurve(m[0],l[0],m[1],l[1],m[2],l[2],m[3],l[3],0.25,true);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}K=this.traceBezierCurve(m[0],l[0]+G,m[1],l[1]+G,m[2],l[2]+G,m[3],l[3]+G,0.25);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}break;case"arch":K=this.traceQuadraticCurve(m[0],l[0],m[1],l[1],m[2],l[2],0.25,true);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}K=this.traceArc1(m[4],l[4],G[0],n[2],n[3]);for(var E=1;E<K.length;E++){N.push(K[E][0],K[E][1])}if(m[0]==m[3]&&l[0]==l[3]&&m[1]==m[4]&&l[1]==l[4]&&m[2]==m[5]&&l[2]==l[5]){break}K=this.traceQuadraticCurve(m[3],l[3],m[4],l[4],m[5],l[5],0.25,true);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}K=this.traceArc1(m[1],l[1],G[1],n[0],n[1]);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}break;case"polygon":case"path":case"spline":case"hull":for(var E=0;E<m.length;E++){if(v=="spline"){N.push(m[E],l[E]-2);K.push(l[E]+2,m[E])}else{N.push(m[E],l[E])}}break;default:g=n/2;a=G/2;break}switch(v){case"image":N=["rect",m-(g*this.zoom),l-(a*this.zoom),m+(g*this.zoom),l+(a*this.zoom)];break;case"mdavid":case"star":case"circle":case"sphere":N=["circle",m,l,n];break;case"diamond":case"rhombus":N=["poly",m,l-a,m+g,l,m,l+a,m-g,l];break;case"box":case"rect":case"rectangle":case"roundrect":case"roundrectt":case"roundrectb":case"roundrectr":case"roundrectl":case"roundrecttr":case"roundrecttl":case"roundrectbr":case"roundrectbl":case"roundrect2":case"roundrectd":case"roundrecto":case"brace":case"square":case"pentagon":case"hexagon":case"octagon":case"oval":case"arc":case"arc3":case"ellipse":case"plus":case"minus":case"pch0":case"pch1":case"pch2":case"pch3":case"pch4":case"pch5":case"pch6":case"pch7":case"pch8":case"pch9":case"pch10":case"pch11":case"pch12":case"pch13":case"pch14":case"pch15":case"pch16":case"pch17":case"pch18":case"pch21":case"pch22":case"pch23":case"pch24":case"pch25":N=["rect",m-g,l-a,m+g,l+a];break;case"pch19":g+=2;a+=2;N=["rect",m-g,l-a,m+g,l+a];break;case"pch20":g-=2;a-=2;g=Math.max(2,g);a=Math.max(2,a);N=["rect",m-g,l-a,m+g,l+a];break;case"rect2":return this.getShapeArea("rectangle",m,l,n,n/2,H,D,C,B,k,L,M,A,I,q,J);case"rect3":return this.getShapeArea("rectangle",m,l,n,n/3,H,D,C,B,k,L,M,A,I,q,J);case"triangle":case"equilateral":N=["poly",m,l-a,m+g,l+a,m-g,l+a];break;case"triangle2":case"equilateral2":N=["poly",m,l+a,m+g,l-a,m-g,l-a];break;case"oval2":return this.getShapeArea("oval",m,l,n,n/2,H,D,C,B,k,L,M,A,I,q,J);case"oval3":return this.getShapeArea("oval",m,l,n,n/3,H,D,C,B,k,L,M,A,I,q,J);case"ellipse2":return this.getShapeArea("ellipse",m,l,n,n/2,H,D,C,B,k,L,M,A,I,q,J);case"ellipse3":return this.getShapeArea("ellipse",m,l,n,n/3,H,D,C,B,k,L,M,A,I,q,J);case"pie0":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI/5,q,J);case"pie1":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI/3.5,q,J);case"pie2":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI/2,q,J);case"pie3":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI/1.5,q,J);case"pie4":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI,q,J);case"pie5":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI*1.2,q,J);case"pie6":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI*1.4,q,J);case"pie7":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI*1.6,q,J);case"pie8":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI*1.8,q,J);case"pie9":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI*2,q,J);case"pacman":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,Math.PI*1/4,Math.PI*7/4,q,J);case"pacman2":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,Math.PI*5/4,Math.PI*3/4,q,J)}N=B?F(N):N;if(this.graphType=="Network"){return this.preScaleNetwork&&!this.isAnimation?N:this.adjustNetworkObjects(N)}else{return N}};this.drawShape=function(V,Q,P,S,aj,ak,aa,Z,X,O,ap,ar,W,am,T,an){this.functionCallerDraw="drawShape";var N,aq,j,at,Y,ad;var J=this.getCanvasContext();if(Z){switch(Z){case"closed":case"solid":case"open":break;default:var au=Z;Z="closed";this.drawShape(V,Q,P,S,aj,ak,ak,Z,X,O,ap,ar,W,am,T,an);Z=au;break}}switch(V){case"polygon":case"path":case"spline":case"arch":case"hull":case"confidence":case"violin":case"bezier":var af=Number.MAX_VALUE;var M=Number.MAX_VALUE*-1;var ae=Number.MAX_VALUE;var K=Number.MAX_VALUE*-1;aq=[];N=[];if(Q.length==P.length){if(V=="spline"&&Q.length<5){return this.drawShape("polygon",Q,P,S,aj,ak,aa,Z,X,O,ap,ar,W,am,T,an)}if(V=="arch"&&(Q.length!=6||P.length!=6||S.length!=4||aj.length!=2)){return false}if(V=="bezier"){if(this.isNumeric(Q)&&this.isNumeric(P)&&this.isNumeric(aj)){for(var ai=0;ai<Q.length;ai++){af=Math.min(af,Q[ai]);M=Math.max(M,Q[ai]);ae=Math.min(ae,P[ai]);K=Math.max(K,P[ai]);N.push([Q[ai],P[ai]])}Q=(af+M)/2;P=(ae+K)/2;for(var ai=0;ai<N.length;ai++){N[ai][0]-=Q;N[ai][1]-=P;aq.push(N[ai][0],N[ai][1])}}else{return false}}else{if(V=="confidence"){for(var ai=0;ai<Q.length;ai++){if(Q[ai][0]!=null&&Q[ai][1]!=null&&P[ai][0]!=null&&P[ai][1]!=null&&this.isNumeric([Q[ai][0],Q[ai][1],P[ai][0],P[ai][1]])){af=Math.min(af,Math.min(Q[ai][0],Q[ai][1]));M=Math.max(M,Math.max(Q[ai][0],Q[ai][1]));ae=Math.min(ae,Math.min(P[ai][0],P[ai][1]));K=Math.max(K,Math.max(P[ai][0],P[ai][1]));N.push([[Q[ai][0],Q[ai][1]],[P[ai][0],P[ai][1]]])}}Q=(af+M)/2;P=(ae+K)/2;for(var ai=0;ai<N.length;ai++){N[ai][0][0]-=Q;N[ai][0][1]-=Q;N[ai][1][0]-=P;N[ai][1][1]-=P;aq.push([N[ai][0][0],N[ai][0][1]],[N[ai][1][0],N[ai][1][1]])}}else{if(V=="violin"){if(Q[0].length==P[0].length&&Q[1].length==P[1].length&&Q[0].length==Q[1].length){for(var ai=0;ai<Q[0].length;ai++){if(this.isNumeric([Q[0][ai],Q[1][ai],P[0][ai],P[1][ai]])){af=Math.min(af,Math.min(Q[0][ai],Q[1][ai]));M=Math.max(M,Math.max(Q[0][ai],Q[1][ai]));ae=Math.min(ae,Math.min(P[0][ai],P[1][ai]));K=Math.max(K,Math.max(P[0][ai],P[1][ai]));N.push([[Q[0][ai],Q[1][ai]],[P[0][ai],P[1][ai]]])}}Q=(af+M)/2;P=(ae+K)/2;for(var ai=0;ai<N.length;ai++){N[ai][0][0]-=Q;N[ai][0][1]-=Q;N[ai][1][0]-=P;N[ai][1][1]-=P;aq.push([N[ai][0][0],N[ai][0][1]],[N[ai][1][0],N[ai][1][1]])}}else{return false}}else{for(var ai=0;ai<Q.length;ai++){if(Q[ai]&&P[ai]&&this.isNumeric([Q[ai],P[ai]])){af=Math.min(af,Q[ai]);M=Math.max(M,Q[ai]);ae=Math.min(ae,P[ai]);K=Math.max(K,P[ai]);N.push([Q[ai],P[ai]])}}Q=V=="arch"?Q[1]:(af+M)/2;P=V=="arch"?P[1]:(ae+K)/2;for(var ai=0;ai<N.length;ai++){N[ai][0]-=Q;N[ai][1]-=P;aq.push(N[ai][0],N[ai][1])}}}}}else{return false}break;default:if(this.isNumeric([Q,P,S,aj])){if(ap){N=this.clip(V,[Q,P,S,aj],ar);if(N){if(N.length==4){S=Math.max(1,N[2]);aj=Math.max(1,N[3]);Q=N[0]+(S/2);P=N[1]+(aj/2)}else{if(N.length==2){Q=N[0];P=N[1]}}}else{return false}}else{S=Math.max(1,S);aj=Math.max(1,aj)}j=S/2;at=aj/2;Y=aj/S;ad=1.5}else{return false}break}switch(V){case"image":if(T&&(CanvasXpress.cacheImages[this.getFileName(T)]||CanvasXpress.images[T])){this.drawShapeSetShapeStyle(Q,P,S,aj,ak,aa,Z,X,O);if(CanvasXpress.images[T]){this.drawImage(CanvasXpress.images[T],-j*this.zoom,-at*this.zoom,S*this.zoom,aj*this.zoom,false,false,false,false,ak)}else{this.drawImage(CanvasXpress.cacheImages[this.getFileName(T)],-j*this.zoom,-at*this.zoom,S*this.zoom,aj*this.zoom,false,false,false,false,ak)}}else{return this.drawShape("rectangle",Q,P,S,aj,"rgba(0,0,0,0.5)","rgba(0,0,0,0.5)",Z,X,O,ap,ar,W,am,T,an)}break;case"circle":case"sphere":this.drawShapeSetShapeStyle(Q,P,S,aj,ak,aa,Z,X,O);if(!this.isColorTransparent(ak)||!this.isColorTransparent(aa)){J.beginPath();J.arc(0,0,Math.max(0,S/2),0,Math.PI*2,false);J.closePath();this.drawShapeFillStroke(ak,aa,Z)}break;case"box":case"rect":N=[[-j,-at],[j,-at],[j,at],[-j,at]];this.drawShapeSetShapeStyle(Math.round(Q),Math.round(P),S,aj,ak,aa,Z,X,O);J.beginPath();J.moveTo(-j,-at);J.lineTo(j,-at);J.lineTo(j,at);J.lineTo(-j,at);J.closePath();this.drawShapeFillStroke(ak,aa,Z);break;case"rectangle":N=[[-j,-at],[j,-at],[j,at],[-j,at]];this.drawShapeSetShapeStyle(Q,P,S,aj,ak,aa,Z,X,O);if(Z&&Z=="open"){J.strokeRect(-j,-at,S,aj)}else{if(aa==ak||J.strokeStyle==J.fillStyle){J.fillRect(-j,-at,S,aj)}else{J.fillRect(-j,-at,S,aj);J.strokeRect(-j,-at,S,aj)}}break;case"rect2":return this.drawShape("rectangle",Q,P,S,S/2,ak,aa,Z,X,O,ap,ar,W,am,T,an);break;case"rect3":return this.drawShape("rectangle",Q,P,S,S/3,ak,aa,Z,X,O,ap,ar,W,am,T,an);break;case"roundrectt":var R=S>this.margin*2&&aj>this.margin*2?this.margin*8:S>aj?aj:S;this.drawShapeSetShapeStyle(Q,P,S,aj,ak,aa,Z,X,O);J.beginPath();J.moveTo(-j,-at+R);J.lineTo(-j,at);J.lineTo(j,at);J.lineTo(j,-at+R);J.quadraticCurveTo(j,-at,j-R,-at);J.lineTo(-j+R,-at);J.quadraticCurveTo(-j,-at,-j,-at+R);J.closePath();this.drawShapeFillStroke(ak,aa,Z);break;case"roundrectb":var R=S>this.margin*2&&aj>this.margin*2?this.margin*8:S>aj?aj:S;this.drawShapeSetShapeStyle(Q,P,S,aj,ak,aa,Z,X,O);J.beginPath();J.moveTo(-j,-at);J.lineTo(-j,at-R);J.quadraticCurveTo(-j,at,-j+R,at);J.lineTo(j-R,at);J.quadraticCurveTo(j,at,j,at-R);J.lineTo(j,-at);J.lineTo(-j,-at);J.closePath();this.drawShapeFillStroke(ak,aa,Z);break;case"roundrectr":var R=S>this.margin*2&&aj>this.margin*2?this.margin*8:S>aj?aj:S;this.drawShapeSetShapeStyle(Q,P,S,aj,ak,aa,Z,X,O);J.beginPath();J.moveTo(-j,-at);J.lineTo(-j,at);J.lineTo(j-R,at);J.quadraticCurveTo(j,at,j,at-R);J.lineTo(j,-at+R);J.quadraticCurveTo(j,-at,j-R,-at);J.lineTo(-j,-at);J.closePath();this.drawShapeFillStroke(ak,aa,Z);break;case"roundrectl":var R=S>this.margin*2&&aj>this.margin*2?this.margin*8:S>aj?aj:S;this.drawShapeSetShapeStyle(Q,P,S,aj,ak,aa,Z,X,O);J.beginPath();J.moveTo(-j,-at+R);J.lineTo(-j,at-R);J.quadraticCurveTo(-j,at,-j+R,at);J.lineTo(j,at);J.lineTo(j,-at);J.lineTo(-j+R,-at);J.quadraticCurveTo(-j,-at,-j,-at+R);J.closePath();this.drawShapeFillStroke(ak,aa,Z);break;case"roundrecttr":var R=S>this.margin*2&&aj>this.margin*2?this.margin*8:S>aj?aj:S;this.drawShapeSetShapeStyle(Q,P,S,aj,ak,aa,Z,X,O);J.beginPath();J.moveTo(-j,-at);J.lineTo(-j,at);J.lineTo(j,at);J.lineTo(j,-at+R);J.quadraticCurveTo(j,-at,j-R,-at);J.lineTo(-j,-at);J.closePath();this.drawShapeFillStroke(ak,aa,Z);break;case"roundrecttl":var R=S>this.margin*2&&aj>this.margin*2?this.margin*8:S>aj?aj:S;this.drawShapeSetShapeStyle(Q,P,S,aj,ak,aa,Z,X,O);J.beginPath();J.moveTo(-j,-at+R);J.lineTo(-j,at);J.lineTo(j,at);J.lineTo(j,-at);J.lineTo(-j+R,-at);J.quadraticCurveTo(-j,-at,-j,-at+R);J.closePath();this.drawShapeFillStroke(ak,aa,Z);break;case"roundrectbr":var R=S>this.margin*2&&aj>this.margin*2?this.margin*8:S>aj?aj:S;this.drawShapeSetShapeStyle(Q,P,S,aj,ak,aa,Z,X,O);J.beginPath();J.moveTo(-j,-at);J.lineTo(-j,at);J.lineTo(j-R,at);J.quadraticCurveTo(j,at,j,at-R);J.lineTo(j,-at);J.lineTo(-j,-at);J.closePath();this.drawShapeFillStroke(ak,aa,Z);break;case"roundrectbl":var R=S>this.margin*2&&aj>this.margin*2?this.margin*8:S>aj?aj:S;this.drawShapeSetShapeStyle(Q,P,S,aj,ak,aa,Z,X,O);J.beginPath();J.moveTo(-j,-at);J.lineTo(-j,at-R);J.quadraticCurveTo(-j,at,-j+R,at);J.lineTo(j,at);J.lineTo(j,-at);J.lineTo(-j,-at);J.closePath();this.drawShapeFillStroke(ak,aa,Z);break;case"roundrecto":var R=S<aj?j:at;this.drawShapeSetShapeStyle(Q,P,S,aj,ak,aa,Z,X,O);J.beginPath();if(S<aj){J.arc(0,-at+R,R,Math.PI,0);J.lineTo(j,at-R);J.arc(0,at-R,R,0,Math.PI);J.lineTo(-j,-at+R)}else{J.arc(-j+R,0,R,Math.PI*0.5,Math.PI*1.5);J.lineTo(j-R,-at);J.arc(j-R,0,R,Math.PI*1.5,Math.PI*0.5);J.lineTo(-j+R,at)}J.closePath();this.drawShapeFillStroke(ak,aa,Z);break;case"roundrect":case"roundrect2":case"roundrectd":var R=S>this.margin*2&&aj>this.margin*2?this.margin*2:S>aj?aj/4:S/4;if(V=="roundrect2"){R*=4}this.drawShapeSetShapeStyle(Q,P,S,aj,ak,aa,Z,X,O);J.beginPath();J.moveTo(-j,-at+R);J.lineTo(-j,at-R);J.quadraticCurveTo(-j,at,-j+R,at);J.lineTo(j-R,at);J.quadraticCurveTo(j,at,j,at-R);J.lineTo(j,-at+R);J.quadraticCurveTo(j,-at,j-R,-at);J.lineTo(-j+R,-at);J.quadraticCurveTo(-j,-at,-j,-at+R);J.closePath();this.drawShapeFillStroke(ak,aa,Z);if(V=="roundrectd"&&S>this.margin*2&&aj>this.margin*2){S-=this.margin*2;aj-=this.margin*2;j=S/2;at=aj/2;J.beginPath();J.moveTo(-j,-at+R);J.lineTo(-j,at-R);J.quadraticCurveTo(-j,at,-j+R,at);J.lineTo(j-R,at);J.quadraticCurveTo(j,at,j,at-R);J.lineTo(j,-at+R);J.quadraticCurveTo(j,-at,j-R,-at);J.lineTo(-j+R,-at);J.quadraticCurveTo(-j,-at,-j,-at+R);J.closePath();this.drawShapeFillStroke(ak,aa,Z)}break;case"brace":var R=S>aj?aj/4:S/4;this.drawShapeSetShapeStyle(Q,P,S,aj,ak,aa,Z,X,O);J.beginPath();J.moveTo(-j,-at);J.bezierCurveTo(-j,0,0,0,0,at);J.bezierCurveTo(0,0,j,0,j,-at);this.drawShapeFillStroke(ak,aa,Z);break;case"square":N=[[-j,-j],[j,-j],[j,j],[-j,j]];this.drawShapeSetShapeStyle(Q,P,S,aj,ak,aa,Z,X,O);this.drawShapeDraw(N);this.drawShapeFillStroke(ak,aa,Z);break;case"triangle":if(S==aj){return this.drawShape("equilateral",Q,P,S,aj,ak,aa,Z,X,O,ap,ar,W,am,T,an)}N=[[0,-at],[j,at],[-j,at]];this.drawShapeSetShapeStyle(Q,P,S,aj,ak,aa,Z,X,O);this.drawShapeDraw(N);this.drawShapeFillStroke(ak,aa,Z);break;case"triangle2":if(S==aj){return this.drawShape("equilateral2",Q,P,S,aj,ak,aa,Z,X,O,ap,ar,W,am,T,an)}N=[[0,at],[j,-at],[-j,-at]];this.drawShapeSetShapeStyle(Q,P,S,aj,ak,aa,Z,X,O);this.drawShapeDraw(N);this.drawShapeFillStroke(ak,aa,Z);break;case"equilateral":var R=S*Math.sqrt(3)/6;var g=R/2;var D=Math.sqrt((R*R)-(g*g));N=[[0,-at],[j,at],[-j,at]];this.drawShapeSetShapeStyle(Q,P,S,aj,ak,aa,Z,X,O);this.drawShapeDraw(N);this.drawShapeFillStroke(ak,aa,Z);break;case"equilateral2":var R=S*Math.sqrt(3)/6;var g=R/2;var D=Math.sqrt((R*R)-(g*g));N=[[0,at],[j,-at],[-j,-at]];this.drawShapeSetShapeStyle(Q,P,S,aj,ak,aa,Z,X,O);this.drawShapeDraw(N);this.drawShapeFillStroke(ak,aa,Z);break;case"diamond":case"rhombus":N=[[0,-at],[j,0],[0,at],[-j,0]];this.drawShapeSetShapeStyle(Q,P,S,aj,ak,aa,Z,X,O);this.drawShapeDraw(N);this.drawShapeFillStroke(ak,aa,Z);break;case"hexagon":var ao=S/3;var q=ao-j;N=[[q,-at],[-q,-at],[j,0],[-q,at],[q,at],[-j,0]];this.drawShapeSetShapeStyle(Q,P,S,aj,ak,aa,Z,X,O);this.drawShapeDraw(N);this.drawShapeFillStroke(ak,aa,Z);break;case"pentagon":var ao=S/3;this.drawShapeSetShapeStyle(Q,P,S,aj,ak,aa,Z,X,O);J.beginPath();for(var ai=0;ai<5;ai++){var C=(ai/5)*Math.PI*2+(-Math.PI/2);J.lineTo(Math.cos(C)*ao,Math.sin(C)*ao)}J.closePath();this.drawShapeFillStroke(ak,aa,Z);break;case"octagon":var av=S/4;var ah=aj/4;N=[[-av,-at],[av,-at],[j,-ah],[j,ah],[av,at],[-av,at],[-j,ah],[-j,-ah]];this.drawShapeSetShapeStyle(Q,P,S,aj,ak,aa,Z,X,O);this.drawShapeDraw(N);this.drawShapeFillStroke(ak,aa,Z);break;case"oval":case"ovald":this.drawShapeSetShapeStyle(Q,P,S,aj,ak,aa,Z,X,O);this.saveCanvas();this.scaleCanvas(1,Y);J.beginPath();J.arc(0,0,Math.max(0,S/2),0,Math.PI*2,true);J.closePath();this.restoreCanvas();this.drawShapeFillStroke(ak,aa,Z);if(V=="ovald"){S-=this.margin*2;aj-=this.margin*2;Y=aj/S;this.saveCanvas();this.scaleCanvas(1,Y);J.beginPath();J.arc(0,0,Math.max(0,S/2),0,Math.PI*2,true);J.closePath();this.restoreCanvas();this.drawShapeFillStroke(ak,aa,Z)}break;case"oval2":return this.drawShape("oval",Q,P,S,S/2,ak,aa,Z,X,O,ap,ar,W,am,T,an);break;case"oval3":return this.drawShape("oval",Q,P,S,S/3,ak,aa,Z,X,O,ap,ar,W,am,T,an);break;case"arc":this.drawShapeSetShapeStyle(Q,P,S,aj,ak,aa,Z,X,O);this.saveCanvas();this.scaleCanvas(1,Y);J.beginPath();J.arc(0,0,Math.max(0,S/2),0,Math.PI,true);if(Z!="open"){J.closePath()}this.restoreCanvas();this.drawShapeFillStroke(ak,aa,Z);break;case"arc2":var F=aj*Math.cos(W);var ay=aj*Math.sin(W);var E=aj*Math.cos(am);var aw=aj*Math.sin(am);var B=this.shortenLine(0,0,F,ay,0,S,"line");var v=this.shortenLine(0,0,E,aw,0,S,"line");this.drawShapeSetShapeStyle(Q,P,S,aj,ak,aa,Z,X,O);J.beginPath();J.moveTo(B[2],B[3]);J.lineTo(F,ay);J.arc(0,0,Math.max(0,aj),W,am,false);J.lineTo(v[2],v[3]);J.arc(0,0,Math.max(0,aj-S),am,W,true);J.closePath();this.drawShapeFillStroke(ak,aa,Z);break;case"arc3":this.drawShapeSetShapeStyle(Q,P,S,aj,ak,aa,Z,X,O);this.saveCanvas();this.scaleCanvas(1,Y);J.beginPath();J.arc(0,0,Math.max(0,S/2),0,Math.PI,true);this.restoreCanvas();this.drawShapeFillStroke(ak,aa,Z);break;case"arch":this.drawShapeSetShapeStyle(Q,P,S,aj,ak,aa,Z,X,O);J.beginPath();J.moveTo(N[0][0],N[0][1]);J.quadraticCurveTo(N[1][0],N[1][1],N[2][0],N[2][1]);J.arc(0,0,Math.max(0,aj[0]),S[3],S[2],true);J.quadraticCurveTo(N[4][0],N[4][1],N[5][0],N[5][1]);J.arc(0,0,Math.max(0,aj[1]),S[1],S[0],true);J.closePath();this.drawShapeFillStroke(ak,aa,Z);break;case"path":this.drawShapeSetShapeStyle(Q,P,S,aj,ak,aa,Z,X,O);this.drawShapeDraw(N,Z=="open");this.drawShapeFillStroke(ak,aa,Z);break;case"polygon":this.drawShapeSetShapeStyle(Q,P,S,aj,ak,aa,Z,X,O);this.drawShapeDraw(N,Z=="open");this.drawShapeFillStroke(ak,aa,Z);break;case"spline":var U=[];var ac=[];var G=[];ac.push(aq.shift());ac.push(aq.shift());G.push(aq.pop());G.unshift(aq.pop());var ab=aq.length;for(var ai=0;ai<ab-4;ai+=2){U=U.concat(this.splineControlPoint(aq[ai],aq[ai+1],aq[ai+2],aq[ai+3],aq[ai+4],aq[ai+5]))}this.drawShapeSetShapeStyle(Q,P,S,aj,ak,aa,Z,X,O);J.beginPath();J.moveTo(ac[0],ac[1]);J.lineTo(aq[0],aq[1]);J.quadraticCurveTo(U[0],U[1],aq[2],aq[3]);for(var ai=2;ai<ab-5;ai+=2){J.bezierCurveTo(U[2*ai-2],U[2*ai-1],U[2*ai],U[2*ai+1],aq[ai+2],aq[ai+3])}J.quadraticCurveTo(U[2*ab-10],U[2*ab-9],aq[ab-2],aq[ab-1]);J.lineTo(G[0],G[1]);J.lineTo(ac[0],ac[1]);this.drawShapeFillStroke(ak,aa,Z);break;case"hull":var ag;var ab=1;var H=[];while(aq.length>1){H.push([aq.shift(),aq.shift()])}var U=this.hullControlPoints(H);var m=[[H[0][0],H[0][1],U[U.length-1][0],U[U.length-1][1],U[0][0],U[0][1],H[1][0],H[1][1]]];for(var ai=1;ai<H.length-1;ai++){m.push([H[ai][0],H[ai][1],U[ab][0],U[ab][1],U[ab+1][0],U[ab+1][1],H[ai+1][0],H[ai+1][1]]);ab+=2}m.push([H[ai][0],H[ai][1],U[ab][0],U[ab][1],U[ab+1][0],U[ab+1][1],H[0][0],H[0][1]]);this.drawShapeSetShapeStyle(Q,P,S,aj,ak,aa,Z,X,O);J.beginPath();J.moveTo(m[0][0],m[0][1]);for(var ai=0;ai<m.length;ai++){J.bezierCurveTo(m[ai][2],m[ai][3],m[ai][4],m[ai][5],m[ai][6],m[ai][7])}this.drawShapeFillStroke(ak,aa,Z);break;case"violin":var ab=aq.length;this.drawShapeSetShapeStyle(Q,P,S,aj,ak,aa,Z,X,O);J.beginPath();J.moveTo(aq[0][0],aq[1][0]);for(var ai=2;ai<ab;ai+=2){J.lineTo(aq[ai][0],aq[ai+1][0])}J.lineTo(aq[ab-2][1],aq[ab-1][1]);for(var ai=2;ai<ab;ai+=2){var ax=(ab-1)-ai;J.lineTo(aq[ax-1][1],aq[ax][1])}J.lineTo(aq[0][0],aq[1][0]);this.drawShapeFillStroke(ak,aa,Z);break;case"confidence":var ab=aq.length;var U=[];var L=[];for(var ai=0;ai<ab-4;ai+=2){var ax=(ab-1)-ai;U=U.concat(this.splineControlPoint(aq[ai][0],aq[ai+1][0],aq[ai+2][0],aq[ai+3][0],aq[ai+4][0],aq[ai+5][0]));L=L.concat(this.splineControlPoint(aq[ax-1][1],aq[ax][1],aq[ax-3][1],aq[ax-2][1],aq[ax-5][1],aq[ax-4][1]))}this.drawShapeSetShapeStyle(Q,P,S,aj,ak,aa,Z,X,O);J.beginPath();J.moveTo(aq[0][0],aq[1][0]);J.quadraticCurveTo(U[0],U[1],aq[2][0],aq[3][0]);for(var ai=2;ai<ab-5;ai+=2){J.bezierCurveTo(U[2*ai-2],U[2*ai-1],U[2*ai],U[2*ai+1],aq[ai+2][0],aq[ai+3][0])}J.quadraticCurveTo(U[2*ab-10],U[2*ab-9],aq[ab-2][0],aq[ab-1][0]);J.lineTo(aq[ab-2][1],aq[ab-1][1]);J.quadraticCurveTo(L[0],L[1],aq[ab-4][1],aq[ab-3][1]);for(var ai=2;ai<ab-5;ai+=2){var ax=(ab-1)-ai;J.bezierCurveTo(L[2*ai-2],L[2*ai-1],L[2*ai],L[2*ai+1],aq[ax-3][1],aq[ax-2][1])}J.quadraticCurveTo(L[2*ab-10],L[2*ab-9],aq[0][1],aq[1][1]);J.lineTo(aq[0][0],aq[1][0]);this.drawShapeFillStroke(ak,aa,Z);break;case"bezier":this.drawShapeSetShapeStyle(Q,P,S,aj,ak,aa,Z,X,O);J.beginPath();J.moveTo(aq[0],aq[1]);J.bezierCurveTo(aq[2],aq[3],aq[4],aq[5],aq[6],aq[7]);J.lineTo(aq[6],aq[7]+aj);J.bezierCurveTo(aq[4],aq[5]+aj,aq[2],aq[3]+aj,aq[0],aq[1]+aj);J.lineTo(aq[0],aq[1]);this.drawShapeFillStroke(ak,aa,Z);break;case"ellipse":var a=j*0.5522848;var al=at*0.5522848;this.drawShapeSetShapeStyle(Q,P,S,aj,ak,aa,Z,X,O);J.beginPath();J.moveTo(0,at);J.bezierCurveTo(0,at-al,j-a,0,j,0);J.bezierCurveTo(j+a,0,S,at-al,S,at);J.bezierCurveTo(S,at+al,j+a,aj,j,aj);J.bezierCurveTo(j-a,aj,0,at+al,0,at);J.closePath();this.drawShapeFillStroke(ak,aa,Z);break;case"ellipse2":return this.drawShape("ellipse",Q,P,S,S/2,ak,aa,Z,X,O,ap,ar,W,am,T,an);break;case"ellipse3":return this.drawShape("ellipse",Q,P,S,S/3,ak,aa,Z,X,O,ap,ar,W,am,T,an);break;case"plus":N=[[-ad,-at],[ad,-at],[ad,-ad],[j,-ad],[j,ad],[ad,ad],[ad,at],[-ad,at],[-ad,ad],[-j,ad],[-j,-ad],[-ad,-ad],[-ad,-at]];this.drawShapeSetShapeStyle(Q,P,S,aj,ak,aa,Z,X,O);this.drawShapeDraw(N);this.drawShapeFillStroke(ak,aa,Z);break;case"minus":N=[[-j,-ad],[j,-ad],[j,ad],[-j,ad],[-j,-ad]];this.drawShapeSetShapeStyle(Q,P,S,aj,ak,aa,Z,X,O);this.drawShapeDraw(N);this.drawShapeFillStroke(ak,aa,Z);break;case"mdavid":var ao=S/3;var A=Math.PI/6;this.drawShapeSetShapeStyle(Q,P,S,aj,ak,aa,Z,X,O);this.saveCanvas();this.scaleCanvas(0.8,0.8);this.rotateCanvas(I*0.45);J.beginPath();J.moveTo(ao,0);for(var ai=0;ai<11;ai++){this.rotateCanvas(A);if(ai%2==0){J.lineTo((ao/0.55),0)}else{J.lineTo(ao,0)}}J.closePath();this.restoreCanvas();this.drawShapeFillStroke(ak,aa,Z);break;case"star":var k=(S/4);var I=Math.PI/5;this.drawShapeSetShapeStyle(Q,P,S,aj,ak,aa,Z,X,O);this.saveCanvas();this.scaleCanvas(0.7,0.7);this.rotateCanvas(I*0.45);J.beginPath();J.moveTo(k,0);for(var ai=0;ai<9;ai++){this.rotateCanvas(I);if(ai%2==0){J.lineTo((k/0.35),0)}else{J.lineTo(k,0)}}J.closePath();this.restoreCanvas();this.drawShapeFillStroke(ak,aa,Z);break;case"pie":if(typeof(W)=="undefined"){W=0}if(typeof(am)=="undefined"){am=Math.PI*2}this.drawShapeSetShapeStyle(Q,P,S,aj,ak,aa,Z,X,O);J.beginPath();J.arc(0,0,Math.max(0,S/2),W,am,false);J.lineTo(0,0);J.closePath();this.drawShapeFillStroke(ak,aa,Z);break;case"pie0":return this.drawShape("pie",Q,P,S,S/2,ak,aa,Z,X,O,ap,ar,0,Math.PI/5,T,an);break;case"pie1":return this.drawShape("pie",Q,P,S,S/2,ak,aa,Z,X,O,ap,ar,0,Math.PI/3.5,T,an);break;case"pie2":return this.drawShape("pie",Q,P,S,S/2,ak,aa,Z,X,O,ap,ar,0,Math.PI/2,T,an);break;case"pie3":return this.drawShape("pie",Q,P,S,S/2,ak,aa,Z,X,O,ap,ar,0,Math.PI/1.5,T,an);break;case"pie4":return this.drawShape("pie",Q,P,S,S/2,ak,aa,Z,X,O,ap,ar,0,Math.PI,T,an);break;case"pie5":return this.drawShape("pie",Q,P,S,S/2,ak,aa,Z,X,O,ap,ar,0,Math.PI*1.2,T,an);break;case"pie6":return this.drawShape("pie",Q,P,S,S/2,ak,aa,Z,X,O,ap,ar,0,Math.PI*1.4,T,an);break;case"pie7":return this.drawShape("pie",Q,P,S,S/2,ak,aa,Z,X,O,ap,ar,0,Math.PI*1.6,T,an);break;case"pie8":return this.drawShape("pie",Q,P,S,S/2,ak,aa,Z,X,O,ap,ar,0,Math.PI*1.8,T,an);break;case"pie9":return this.drawShape("pie",Q,P,S,S/2,ak,aa,Z,X,O,ap,ar,0,Math.PI*2,T,an);break;case"pacman":return this.drawShape("pie",Q,P,S,S/2,ak,aa,Z,X,O,ap,ar,Math.PI*1/4,Math.PI*7/4,T,an);break;case"pacman2":return this.drawShape("pie",Q,P,S,S/2,ak,aa,Z,X,O,ap,ar,Math.PI*5/4,Math.PI*3/4,T,an);break;case"pch0":this.drawShape("square",Q,P,S,S,ak,aa,"open",false,O,ap,ar,W,am,T,an);break;case"pch1":this.drawShape("circle",Q,P,S,S,ak,aa,"open",false,O,ap,ar,W,am,T,an);break;case"pch2":this.drawShape("equilateral",Q,P,S,S,ak,aa,"open",false,O,ap,ar,W,am,T,an);break;case"pch3":this.drawShapeSetShapeStyle(Q,P,S,aj,ak,aa,"open",false,O);J.moveTo(0,-at);this.lineTo(0,-at,0,at);J.stroke();J.moveTo(-j,0);this.lineTo(-j,0,j,0);J.stroke();this.drawShapeFillStroke(ak,aa,Z);break;case"pch4":this.drawShapeSetShapeStyle(Q,P,S,aj,ak,aa,"open",false,O);J.moveTo(-j,-at);this.lineTo(-j,-at,j,at);J.stroke();J.moveTo(j,-at);this.lineTo(j,-at,-j,at);J.stroke();this.drawShapeFillStroke(ak,aa,Z);break;case"pch5":this.drawShape("diamond",Q,P,S,S,ak,aa,"open",false,O,ap,ar,W,am,T,an);break;case"pch6":this.drawShape("equilateral2",Q,P,S,S,ak,aa,"open",false,O,ap,ar,W,am,T,an);break;case"pch7":this.drawShape("pch0",Q,P,S,aj,ak,aa,"open",false,O,ap,ar,W,am,T,an);this.drawShape("pch4",Q,P,S,aj,ak,aa,"open",false,O,ap,ar,W,am,T,an);break;case"pch8":this.drawShape("pch3",Q,P,S,aj,ak,aa,"open",false,O,ap,ar,W,am,T,an);this.drawShape("pch4",Q,P,S,aj,ak,aa,"open",false,O,ap,ar,W,am,T,an);break;case"pch9":this.drawShape("pch3",Q,P,S,aj,ak,aa,"open",false,O,ap,ar,W,am,T,an);this.drawShape("pch5",Q,P,S,aj,ak,aa,"open",false,O,ap,ar,W,am,T,an);break;case"pch10":this.drawShape("pch1",Q,P,S,aj,ak,aa,"open",false,O,ap,ar,W,am,T,an);this.drawShape("pch3",Q,P,S,aj,ak,aa,"open",false,O,ap,ar,W,am,T,an);break;case"pch11":this.drawShape("pch2",Q,P,S,aj,ak,aa,"open",false,O,ap,ar,W,am,T,an);this.drawShape("pch6",Q,P,S,aj,ak,aa,"open",false,O,ap,ar,W,am,T,an);break;case"pch12":this.drawShape("pch0",Q,P,S,aj,ak,aa,"open",false,O,ap,ar,W,am,T,an);this.drawShape("pch3",Q,P,S,aj,ak,aa,"open",false,O,ap,ar,W,am,T,an);break;case"pch13":this.drawShape("pch1",Q,P,S,aj,ak,aa,"open",false,O,ap,ar,W,am,T,an);this.drawShape("pch4",Q,P,S,aj,ak,aa,"open",false,O,ap,ar,W,am,T,an);break;case"pch14":this.drawShape("pch0",Q,P,S,aj,ak,aa,"open",false,O,ap,ar,W,am,T,an);this.drawShape("pch6",Q,P,S,aj,ak,aa,"open",false,O,ap,ar,W,am,T,an);break;case"pch15":case"pch22":this.drawShape("square",Q,P,S,S,ak||this.foreground,aa,"closed",false,O,ap,ar,W,am,T,an);break;case"pch16":case"pch21":this.drawShape("circle",Q,P,S,S,ak||this.foreground,aa,"closed",false,O,ap,ar,W,am,T,an);break;case"pch17":case"pch24":this.drawShape("equilateral",Q,P,S,S,ak||this.foreground,aa,"closed",false,O,ap,ar,W,am,T,an);break;case"pch18":case"pch23":this.drawShape("diamond",Q,P,S,S,ak||this.foreground,aa,"closed",false,O,ap,ar,W,am,T,an);break;case"pch19":this.drawShape("circle",Q,P,S+2,S+2,ak||this.foreground,aa,"closed",false,O,ap,ar,W,am,T,an);break;case"pch20":this.drawShape("circle",Q,P,Math.max(2,S-2),Math.max(2,S-2),ak||this.foreground,aa,"closed",false,O,ap,ar,W,am,T,an);break;case"pch25":this.drawShape("equilateral2",Q,P,S,S,ak||this.foreground,aa,"closed",false,O,ap,ar,W,am,T,an);break;default:this.drawShapeSetShapeStyle(Q,P,S,aj,ak,aa,Z,X,O);break}if(V=="box"||V=="rect"){this.drawShapeRestore(Math.round(Q),Math.round(P),X)}else{this.drawShapeRestore(Q,P,X)}};this.imageToCanvas=function(a){var b=this.$cX("canvas",{width:a.naturalWidth,height:a.naturalHeight});b.ctx=b.getContext("2d");b.ctx.drawImage(a,0,0);return b};this.colorizeImage=function(b,a){b.ctx.fillStyle=a;b.ctx.globalCompositeOperation="color";b.ctx.fillRect(0,0,b.width,b.height);b.ctx.globalCompositeOperation="source-over"};this.maskImage=function(b,a){b.ctx.globalCompositeOperation="destination-in";b.ctx.drawImage(a,0,0);b.ctx.globalCompositeOperation="source-over"};this.greyImage=function(m,b,o,n,f){var a=m.getImageData(b,o,n,f);var k=a.data;for(var e=0;e<k.length;e+=4){var j=0.34*k[e]+0.5*k[e+1]+0.16*k[e+2];j=j>220?255:j;k[e]=j;k[e+1]=j;k[e+2]=j}m.putImageData(a,b,o)};this.drawImage=function(d,a,r,n,g,b,s,o,f,p){var q=this.getCanvasContext();try{a=parseInt(Math.round(a||0));r=parseInt(Math.round(r||0));n=parseInt(Math.round(n||d.naturalWidth));g=parseInt(Math.round(g||d.naturalHeight));if(b&&s&&o&&f){b=parseInt(Math.round(b));s=parseInt(Math.round(s));o=parseInt(Math.round(o));f=parseInt(Math.round(f));q.drawImage(d,a,r,n,g,b,s,o,f);if(p&&p=="b&w"){this.greyImage(q,a,r,Math.max(n,b+o),Math.max(g,s+f))}}else{if(p&&p=="b&w"){q.drawImage(d,a,r,n,g);this.greyImage(q,a,r,n,g)}else{if(p){var m=this.imageToCanvas(d);q.drawImage(m,a,r,n,g);this.colorizeImage(m,p);this.maskImage(m,d);q.drawImage(m,a,r,n,g)}else{q.drawImage(d,a,r,n,g)}}}}catch(k){console.log(k);var j=this;setTimeout(function(){j.draw()},100)}};this.drawVideo=function(c,b,d){var e=this;var a=this.getCanvasContext();if(c.paused||c.ended){return false}a.drawImage(c,0,0,b,d);this.videoUpdate();setTimeout(function(){e.drawVideo(c,b,d)},50)};this.setGlobalCompositionOperation=function(b){if(!CanvasXpress.system.isIE&&b){var a=this.getCanvasContext();a.globalCompositeOperation=b;this.meta.state.globalCompositeOperation=b}};this.rectangleClear=function(a,e,c,d){var b=this.getCanvasContext();b.clearRect(a,e,c,d)};this.translateCanvas=function(a,c){var b=this.getCanvasContext();b.translate(a,c);this.meta.state.translate[0]+=a;this.meta.state.translate[1]+=c};this.rotateCanvas=function(b){var a=this.getCanvasContext();a.rotate(b);this.meta.state.rotate[0]+=b};this.scaleCanvas=function(a,c){var b=this.getCanvasContext();b.scale(a,c);this.meta.state.scale[0]*=a;this.meta.state.scale[1]*=c};this.saveCanvas=function(){var a=this.getCanvasContext();a.save();this.meta.state.save++};this.restoreCanvas=function(){var a=this.getCanvasContext();a.restore();this.meta.state.save--};this.setFunctionNames("initAttributes")};CanvasXpress.prototype.initRangeAlgorithms=function(){this.heckbert=function(d,k,b){var c=function(i,m){var o;var p=Math.floor(Math.log(i)/Math.LN10);var n=i/Math.pow(10,p);if(m){if(n<1.5){o=1}else{if(n<3){o=2}else{if(n<7){o=5}else{o=10}}}}else{if(n<1){o=1}else{if(n<2){o=2}else{if(n<5){o=5}else{o=10}}}}return o*Math.pow(10,p)};if(d>k){var f=k;d=k;d=f}var j=[];var g=c(k-d,false);var l=c(g/(b-1),true);var a=Math.floor(d/l)*l;var h=Math.ceil(k/l)*l;for(var e=a;e<=h;e+=l){j.push(this.approx(e))}return j};this.wilkinson=function(c,h,a){var b=function(z,B,A,y){var u=[10,1,5,2,2.5,3,4,1.5,7,6,8,9];var w=B-z;var r=A-1;var o=1-Math.abs(A-y)/y;var D=w/r;var t=Math.floor(Math.log(D)/Math.LN10);var E=Math.pow(10,t);var p=null;for(var C=0;C<u.length;C++){var s=u[C]*E;var F=Math.floor(z/s)*s;var n=F+r*s;if(F<=z&&n>=B){var v=1-(C-(F<=0&&n>=0?1:0))/u.length;var q=(B-z)/(n-F);if(q>0.8){var x=o+v+q;if(p==null||x>p.score){p={lmin:F,lmax:n,lstep:s,score:x}}}}}if(!p){p={lmin:z,lmax:B,lstep:1,score:0}}return p};if(c>h){var g=h;c=h;c=g}var j=[];var e=null;var l=[];for(var f=Math.max(Math.floor(a/2),2);f<=Math.ceil(6*a);f++){l.push(f)}for(var f=0;f<l.length;f++){var d=l[f];var m=b(c,h,d,a);if((m!=null&&e==null)||(m&&e&&m.score>e.score)){e=m}}for(var f=e.lmin;f<=e.lmax;f+=e.lstep){j.push(this.approx(f))}return j};this.wilkinsonExtended=function(a,y,R,C){var A=2.22e-14;var f=function(j,g){for(var c=0;c<g.length;c++){if(j==g[c]){return c}}};var J=function(c,w,m,g,z,Y){var k=w.length;var s=f(c,w);var Z=(g%Y<A||Y-(g%Y)<A)&&g<=0&&z>=0?1:0;return 1-s/(k-1)-m+Z};var K=function(s,m,g){var w=m.length;var k=f(s,m);var c=1;return 1-k/(w-1)-g+c};var h=function(c,i,j,g){return 1-0.5*(Math.pow(i-g,2)+Math.pow(c-j,2))/Math.pow(0.1*(i-c),2)};var r=function(c,k,i){var g=k-c;if(i>g){var j=(i-g)/2;return 1-0.5*(Math.pow(j,2)+Math.pow(j,2))/Math.pow(0.1*g,2)}else{return 1}};var o=function(j,c,i,s,w,q){var n=(j-1)/(q-w);var g=(c-1)/(Math.max(q,s)-Math.min(i,w));return 2-Math.max(n/g,g/n)};var X=function(g,c){return g>=c?2-(g-1)/(c-1):1};var e=[1,5,2,2.5,4,3];var G=[0.25,0.2,0.5,0.05];var P=e.length;var L={score:-2};var H=[];if(a>y){var l=a;a=y;y=l}if(y-a<A){for(var U=0;U<=R;U++){H.push(a)}return H}var T=1;while(T<Number.POSITIVE_INFINITY){for(var U=0;U<P;U++){var N=e[U];var u=K(N,e,T);if((G[0]*u+G[1]+G[2]+G[3]<L.score)){T=Number.POSITIVE_INFINITY;break}var S=2;while(S<Number.POSITIVE_INFINITY){var p=X(S,R);if((G[0]*u+G[1]+G[2]*p+G[3]<L.score)){break}var E=(y-a)/(S+1)/T/N;var F=Math.ceil(Math.log(E)/Math.LN10);while(F<Number.POSITIVE_INFINITY){var D=T*N*Math.pow(10,F);var B=r(a,y,D*(S-1));if((G[0]*u+G[1]*B+G[2]*p+G[3]<L.score)){break}var v=Math.floor(y/D)*T-(S-1)*T;var O=Math.ceil(a/D)*T;if(v>O){F++;continue}for(var x=v;x<=O;x++){var t=x*(D/T);var M=t+D*(S-1);var d=D;var I=J(N,e,T,t,M,d);var W=h(a,y,t,M);var V=o(S,R,a,y,t,M);var b=G[0]*I+G[1]*W+G[2]*V+G[3];if(b>L.score&&(!C||(t<=a&&M>=y))){L={lmin:t,lmax:M,lstep:d,score:b}}}F++}S++}}T++}for(var U=L.lmin;U<=L.lmax;U+=L.lstep){H.push(this.approx(U))}return H};this.rPretty=function(o,p,r){if(o>p){var w=p;o=p;o=w}var a,e,b;var l=[];var q=Math.floor(r)-1;var s=Math.floor(q%3);var g=0.75;var v=1.5;var d=0.5+1.5*v;var f=p-o;if(f==0&&p==0){a=1;e=true;b=1}else{a=Math.max(Math.abs(o),Math.abs(p));b=1+d>=1.5*v+0.5?1/(1+v):1.5/1+d;e=f<(a*b*Math.max(1,q)*1e-7*3)}if(e){if(a>10){a=9+a/10}a=a*g;if(s>1){a/=s}}else{a=f;if(q>1){a/=q}}if(a<20*1e-7){a=20*1e-7}var c=Math.pow(10,Math.floor(Math.log(a)/Math.LN10));var j=c;if((2*c)-a<v*(a-j)){j=2*c;if((5*c)-a<d*(a-j)){j=5*c;if((10*c)-a<v*(a-j)){j=10*c}}}var y=Math.floor(o/j+1e-7);var x=Math.ceil(p/j-1e-7);while(y*j>o+(1e-7*j)){y--}while(x*j<p-(1e-7*j)){x++}var t=Math.floor(0.5+x-y);if(t<s){t=s-t;if(y>=0){x+=t/2;y=y-t/2+t%2}else{y-=t/2;x=x+t/2+t%2}q=s}else{q=t}for(var u=y*j;u<=x*j;u+=j){l.push(this.approx(u))}return l};this.getAxisDecimals=function(a){a=this.approx(a).toString();return a.indexOf(".")>=0?Math.min(Number(a.length-(a.indexOf(".")+1)),20):0};this.setFunctionNames("initRangeAlgorithms")};CanvasXpress.prototype.initPrimitives=function(){this.initText();this.initTime();this.initColor();this.initAttributes();this.initRangeAlgorithms()};CanvasXpress.prototype.initGeneralUtils=function(){this.modifyObjectArray=function(c,g,h,f,j){this.functionCaller="modifyObjectArray";if(this.isTransition()){return}var e=this[h];if(f){var a={};if(this.isArray(c)){var b=c.length;for(var d=0;d<b;d++){a[c[d]]=true}}else{a[c]=true}for(var d in a){if(this.isInArray(d,e)){e=this.removeFromArray(d,e);delete (a[d])}}for(var d in a){e.push(d)}this[h]=e}else{if(g){var a={};var k=[];if(this.isArray(c)){var b=c.length;for(var d=0;d<b;d++){a[c[d]]=1}}else{a[c]=1}var b=e.length;for(var d=0;d<b;d++){if(!a.hasOwnProperty(e[d])){k.push(e[d])}}this[h]=k}else{if(this.isArray(c)){var b=c.length;for(var d=0;d<b;d++){e.push(c[d])}}else{e.push(c)}}}if(j){this.draw()}};this.getObjectArray=function(b){var d={};if(b&&this.isArray(b)){var e=b.length;for(var c=0;c<e;c++){d[b[c]]=true}}return d};this.getObjectArrayOrder=function(b){var d={};if(b&&this.isArray(b)){var e=b.length;for(var c=0;c<e;c++){d[b[c].toString()]=c}}return d};this.isInArray=function(e,b){if(this.isArray(b)){var c=this.getObjectArray(b);if(this.isArray(e)){var f=e.length;for(var d=0;d<f;d++){if(c.hasOwnProperty(e[d])){return true}}return false}else{return c.hasOwnProperty(e)}}else{return false}};this.removeFromArray=function(e,b){if(this.isArray(b)){var d=[];var f=b.length;for(var c=0;c<f;c++){if(b[c]!=e){d.push(b[c])}}}return d};this.isFunction=function(a){var b={};return a&&b.toString.call(a)==="[object Function]"};this.isArray=function(a){return Array.isArray(a)};this.isObject=function(a){return a instanceof Object};this.isUnique=function(b){return this.getUniqueEls(b).length==b.length};this.toArray=function(a){return this.isArray(a)?a:[a]};this.getKeys=function(a){return this.isArray(a)?a:this.isObject(a)?Object.keys(a):[]};this.unique=function(a){if(this.isArray(a)){return this.getUniqueEls(a)}else{if(this.isObject(a)){return this.getUniqueEls(this.getKeys(a))}else{return[a]}}};this.getUniqueEls=function(b){var e=b.length;var c={};for(var d=0;d<e;d++){c[b[d]]=true}return this.getKeys(c);return b.filter(function(a,f){return b.indexOf(a)===f})};this.getUniqueKeys=function(a){if(this.isArray(a)){return this.getUniqueEls(a)}else{if(this.isObject(a)){return this.getUniqueEls(this.getKeys(a))}else{return[a]}}};this.shuffleArray=function(b){for(var d=b.length;d>0;d--){var c=Math.floor(this.random()*d);var a=b[--d];b[d]=b[c];b[c]=a}return b};this.toNumber=function(c){var f=[];var d=this.isArray(c);c=this.toArray(c);var b=c.length;for(var e=0;e<b;e++){f.push(Number(c[e]))}return d?f:f[0]};this.extend=function(c,b){if(c==null||typeof(c)!="object"){return b}if(b==null||typeof(b)!="object"){return c}if(Object.assign){return Object.assign({},c,b)}else{for(var a in c){if(c.hasOwnProperty(a)){b[a]=c[a]}}return b}};this.cloneObjectR=function(b,a){if(b==null||typeof(b)!="object"){return b}if(a){return this.isArray(b)?Object.assign([],b):Object.assign({},b)}else{return this.parseJSON(this.stringifyJSON(b))}};this.cloneObject=function(c){if(this.isR){return this.cloneObjectR(c,true)}if(typeof c!=="object"){return c}if(!c){return c}if(Object.prototype.toString.apply(c)==="[object Array]"){var d=[];var a=c.length;for(var b=0;b<a;b++){d[b]=this.cloneObject(c[b])}return d}var d={};for(b in c){if(c.hasOwnProperty(b)){d[b]=this.cloneObject(c[b])}}return d};this.isSameObject=function(d,c){if(d===c){return true}if(typeof(d)!="object"||typeof(c)!="object"){return false}return JSON.stringify(d)==JSON.stringify(c)};this.isNumber=function(a){return a===null||a===undefined?true:!isNaN(parseFloat(a))&&isFinite(a)};this.isNumeric2DArray=function(a){var e=a.length;for(var d=0;d<e;d++){var c=a[d].length;for(var b=0;b<c;b++){if(!this.isNumber(a[d][b])){return false}}}return true};this.isNumeric=function(b,a,e){if(a){var f=this.smpIndices.length;for(var d=0;d<f;d++){var c=this.smpIndices[d];if(!this.isNumber(b[c])){return false}}}else{if(e){var f=this.varIndices.length;for(var d=0;d<f;d++){var c=this.varIndices[d];if(!this.isNumber(b[c])){return false}}}else{var f=b.length;for(var c=0;c<f;c++){if(!this.isNumber(b[c])){return false}}}}return true};this.isEmpty=function(b,a,e){if(a){var f=this.smpIndices.length;for(var d=0;d<f;d++){var c=this.smpIndices[d];if(b[c]!=""){return false}}}else{if(e){var f=this.varIndices.length;for(var d=0;d<f;d++){var c=this.varIndices[d];if(b[c]!=""){return false}}}else{var f=b.length;for(var c=0;c<f;c++){if(b[c]!=""){return false}}}}return true};this.isDate=function(b,a,f){var d=function(h){if(toString.call(h)==="[object Date]"){return true}if(typeof h.replace==="function"){h.replace(/^\s+|\s+$/gm,"")}var i=/(^\d{1,4}[\.|\\/|-]\d{1,2}[\.|\\/|-]\d{1,4})(\s*(?:0?[1-9]:[0-5]|1(?=[012])\d:[0-5])\d\s*[ap]m)?$/;return i.test(h)};if(a){var g=this.smpIndices.length;for(var e=0;e<g;e++){var c=this.smpIndices[e];if(b[c]&&!d(b[c])){return false}}}else{if(f){var g=this.varIndices.length;for(var e=0;e<g;e++){var c=this.varIndices[e];if(b[c]&&!d(b[c])){return false}}}else{var g=b.length;for(var c=0;c<g;c++){if(b[c]&&!d(b[c])){return false}}}}return true};this.padNumber=function(b,a){if(!a){a=4}b=b+"";return b.length>=a?b:new Array(a-b.length+1).join("0")+b};this.isPivotable=function(){var b=this.data.y.vars.length;var c=this.data.x?this.getKeys(this.data.x):[];var a=c.length;return b+a==3};this.pivotMatrix=function(j,g,l,d){var c={};var f=[];var e=[];var a=j.length;for(var b=0;b<a;b++){if(!c[j[b][g]]){c[j[b][g]]={}}c[j[b][g]][j[b][l]]=j[b][d];if(f.indexOf(j[b][l])==-1){f.push(j[b][l])}}f=this.stringRangeSort(f);var k=[];k.push("Vars");k.push.apply(k,f);e.push(k);for(var h in c){k=[];k.push(h);a=f.length;for(var b=0;b<a;b++){k.push(c[h][f[b]]||"")}e.push(k)}return e};this.transposeMatrix=function(a){return a[0].map(function(b,d){return a.map(function(c){return c[d]})})};this.filterNumbers=function(a){var c=[];var d=a.length;for(var b=0;b<d;b++){if(this.isNumber(a[b])){c.push(a[b])}}return c};this.cleanArray=function(b,a,e){var d=[];if(a){var f=this.smpIndices.length;for(var c=0;c<f;c++){d.push(b[this.smpIndices[c]])}d=this.filterNumbers(d)}else{if(e){var f=this.varIndices.length;for(var c=0;c<f;c++){d.push(b[this.varIndices[c]])}d=this.filterNumbers(d)}else{d=this.filterNumbers(b)}}return d};this.cleanArrays=function(j,h,g,e){var d=[];var c=[];if(g){var b=this.smpIndices.length;for(var f=0;f<b;f++){var k=this.filterNumbers([j[this.smpIndices[f]],h[this.smpIndices[f]]]);if(k.length==2){d.push(j[this.smpIndices[f]]);c.push(h[this.smpIndices[f]])}}}else{if(e){var b=this.varIndices.length;for(var f=0;f<b;f++){var k=this.filterNumbers([j[this.varIndices[f]],h[this.varIndices[f]]]);if(k.length==2){d.push(j[this.varIndices[f]]);c.push(h[this.varIndices[f]])}}}else{var b=j.length;for(var f=0;f<b;f++){var k=this.filterNumbers([j[f],h[f]]);if(k.length==2){d.push(j[f]);c.push(h[f])}}}}return[d,c]};this.reverseArray=function(a){tmp=a.reverse();return tmp};this.parseInt=function(a){return((a+0.5)<<1)>>1};this.getIpRangeFromAddressAndNetmask=function(g){var c=g.split("/");var e=c[0].split(".");var d=["0","0","0","0"];if(!/\d+\.\d+\.\d+\.\d+/.test(c[1])){d=("1".repeat(parseInt(c[1],10))+"0".repeat(32-parseInt(c[1],10))).match(/.{1,8}/g);d=d.map(function(h){return parseInt(h,2)})}else{d=c[1].split(".").map(function(h){return parseInt(h,10)})}var b=d.map(function(h){return h^255});var a=e.map(function(i,h){return i&d[h]});var f=e.map(function(i,h){return i|b[h]});return[a.join("."),f.join(".")]};this.int2Ip=function(a){return((a>>>24)+"."+(a>>16&255)+"."+(a>>8&255)+"."+(a&255))};this.ip2Int=function(a){return a.split(".").reduce(function(c,b){return(c<<8)+parseInt(b,10)},0)>>>0};this.setFunctionNames("initGeneralUtils")};CanvasXpress.prototype.initPlotUtils=function(){this.setVideoControls=function(){if(this.isVideo){var b=this;if(typeof _V_=="undefined"||!_V_.autoSetupTimeout){setTimeout(function(){b.setVideoControls()},100)}else{var e=_V_(this.target+"-cX-Video");var a=this.$(this.target+"-cX-Video");if(e&&a){a.style.position="absolute";a.style.background="transparent";this.video=a.childNodes[0];this.video.style.display="none";this.video.style.zIndex=-1;this.video.playbackRate=this.videoPlaybackRate;b.addEvtListener(this.video,"loadeddata",function(){b.addEvtListener(b.video,"play",b.videoPlay,false)},false);if(this.videoAutoplay){e.play();var c=function(){this.play=function(){if(b.video.readyState==4){b.drawVideo(b.video,b.width,b.height);clearInterval(d)}};var d=b.setInterval(this.play,30)};c.call()}}}}};this.drawLayoutCanvasCompartments=function(){this.functionCaller="drawLayoutCanvasCompartments";var n=this.canvasBoxColor;var m=this.height;var s=this.width;var g=this.left;var d=this.right;var p=this.bottom;var u=this.top;var j=this.marginLeft;var e=this.marginRight;var q=this.marginBottom;var a=this.marginTop;var o=this.layoutLeft;var k=this.layoutRight;var f=this.layoutBottom;var i=this.layoutTop;this.addToRender(["drawShape","rectangle",(j+this.offsetX)+(this.layoutWidth/2),(a+this.offsetY)+(this.layoutHeight/2),this.layoutWidth,this.layoutHeight,false,n,"open"]);this.addToRender(["drawLine","line",j,0,j,m,n]);this.addToRender(["drawLine","line",o+j,0,o+j,m,n]);this.addToRender(["drawLine","line",0,a,s,a,n]);this.addToRender(["drawLine","line",0,a+i,s,a+i,n]);this.addToRender(["drawLine","line",s-e,0,s-e,m,n]);this.addToRender(["drawLine","line",s-(e+k),0,s-(e+k),m,n]);this.addToRender(["drawLine","line",0,m-q,s,m-q,n]);this.addToRender(["drawLine","line",0,m-(q+f),s,m-(q+f),n]);this.addToRender(["drawLine","line",o+j+g,0,o+j+g,m,n]);this.addToRender(["drawLine","line",0,a+i+u,s,a+i+u,n]);this.addToRender(["drawLine","line",s-(e+k+d),0,s-(e+k+d),m,n]);this.addToRender(["drawLine","line",0,m-(q+f+p),s,m-(q+f+p),n])};this.drawCanvasBox=function(a){this.functionCaller="drawCanvasBox";if(this.canvasBox&&(this.graphType!="Network"||a)){this.addToRender(["disableGradientTransparencyShadow"]);this.addToRender(["drawShape","rectangle",this.width/2,this.height/2,this.width-2,this.height-2,false,this.canvasBoxColor,"open"]);this.addToRender(["enableGradientTransparencyShadow"])}};this.drawPlotWindow=function(){this.functionCaller="drawPlotWindow";if(this.backgroundType.match("window")){this.addToRender(["disableGradientTransparencyShadow"]);var a=this.marginLeft+this.offsetX+this.left;var b=this.marginTop+this.offsetY+this.top;if(this.backgroundType=="windowSolidGradient"){var c=this.getLinearGradient(a,b,this.gradientOrientation=="vertical"?a:b+this.y,this.gradientOrientation=="vertical"?a+this.x:b,this.backgroundGradient1Color,this.backgroundGradient2Color);this.addToRender(["drawShape","rectangle",a+(this.x/2),b+(this.y/2),this.x,this.y,c,c])}else{if(this.backgroundType=="windowImage"){this.addToRender(["drawShape","image",a+(this.x/2),b+(this.y/2),this.x,this.y,false,false,false,false,false,false,false,false,false,this.backgroundImage])}else{this.addToRender(["drawShape","rectangle",a+(this.x/2),b+(this.y/2),this.x,this.y,this.backgroundWindow,this.backgroundWindow])}}this.addToRender(["enableGradientTransparencyShadow"])}};this.validateSegregation=function(){var e="";var b=this.segregateVariablesBy;var d=this.segregateSamplesBy;if(b.length>0){var a=[];for(var c=0;c<b.length;c++){if((this.data.z&&this.data.z.hasOwnProperty(b[c]))||b[c]=="variable"){a.push(b[c])}}b=a}if(d.length>0){var a=[];for(var c=0;c<d.length;c++){if((this.data.x&&this.data.x.hasOwnProperty(d[c]))||d[c]=="sample"){a.push(d[c])}}d=a}if(b.length>0&&d.length>0){if(d.length>1){while(d.length>1){d.pop()}e+="Only one sample segregation when variable segregation is selected\n";e+="segregateSamplesBy was set to: "+d[0]+"\n"}if(b.length>1){while(b.length>1){b.pop()}e+="Only one variable segregation when sample segregation is selected\n";e+="segregateVariblesBy was set to: "+b[0]+"\n"}}else{if(d.length>0){if(d.length>2){while(d.length>2){d.pop()}e+="Maximum of two sample segregations\n";e+="segregateSamplesBy was set to: "+d[0]+","+d[1]+"\n"}}else{if(b.length>0){if(b.length>2){while(b.length>2){b.pop()}e+="Maximum of two variable segregations\n";e+="segregateVariablesBy was set to: "+b[0]+","+b[1]+"\n"}}}}if(e!=""){this.removeMenus();alert(e);return false}return true};this.checkSegregation=function(){if(this.graphType!="Candlestick"&&!this.isDOE){if(this.validateSegregation()){if(this.data.l){if(this.segregateSamplesBy.length==0){}else{if(!this.data.l.smps){this.segregateSamples(this.segregateSamplesBy,true)}}if(this.segregateVariablesBy.length==0){}else{if(!this.data.l.vars){this.segregateVariables(this.segregateVariablesBy,true)}}}else{if(this.segregateSamplesBy.length>0&&this.segregateVariablesBy.length>0){this.segregateSamplesVariables(true)}else{if(this.segregateSamplesBy.length>0){this.segregateSamples(this.segregateSamplesBy,true)}else{if(this.segregateVariablesBy.length>0){this.segregateVariables(this.segregateVariablesBy,true)}}}}}}};this.validateOverlays=function(){if(this.smpOverlays.length>0){var a=[];for(var b=0;b<this.smpOverlays.length;b++){if(this.smpOverlays[b]=="-"||(this.data.x&&this.data.x.hasOwnProperty(this.smpOverlays[b]))){a.push(this.smpOverlays[b])}}this.smpOverlays=a}if(this.varOverlays.length>0){var a=[];for(var b=0;b<this.varOverlays.length;b++){if(this.varOverlays[b]=="-"||(this.data.z&&this.data.z.hasOwnProperty(this.varOverlays[b]))){a.push(this.varOverlays[b])}}this.varOverlays=a}};this.isDotplotGraph=function(){if(this.graphType.match(/Dotplot/)){return true}else{if(this.graphType=="Boxplot"&&(this.showBoxplotOriginalData||this.showViolinBoxplot)){return true}else{return false}}};this.validateNetworkDecorations=function(){if(this.decorations.length){var c=this.meta.data.nodes;var a=[];for(var b=0;b<this.decorations.length;b++){if(c.hasOwnProperty(this.decorations[b])){a.push(this.decorations[b])}}this.decorations=a}};this.setFunctionNames("initPlotUtils")};CanvasXpress.prototype.initConfigUtils=function(){this.encode=function(a){return btoa(encodeURIComponent(a).replace(/%([0-9A-F]{2})/g,function(b,c){return String.fromCharCode("0x"+c)}))};this.decode=function(a){return decodeURIComponent(Array.prototype.map.call(atob(a),function(b){return"%"+("00"+b.charCodeAt(0).toString(16)).slice(-2)}).join(""))};this.getFileName=function(a){return a.substring(a.lastIndexOf("/")+1)};this.getTitleSubtitleHeight=function(){var b=0;var a;this.setTitleSubtitleFont();if(this.title){a=this.title.split(/\n/);b+=(this.margin+this.getFontPt(this.titleFont))*a.length;if(this.subtitle){a=this.subtitle.split(/\n/);b+=(this.margin+this.getFontPt(this.subtitleFont))*a.length}b+=this.margin}return b};this.setTitleSubtitleFont=function(){this.setPropertyFontSize(this.width,"titleFont");this.adjustFont(this.title,"titleFont",this.width);this.setPropertyFontSize(this.width,"subtitleFont");this.adjustFont(this.subtitle,"subtitleFont",this.width)};this.drawTitle=function(){this.functionCaller="drawTitle";this.setTitleSubtitleFont();if(this.title){var a=this.titleAlign=="left"?this.marginLeft+this.left:this.titleAlign=="right"?this.width-(this.marginRight+this.right):this.width/2;var b=this.marginTop+(this.getFontPt(this.titleFont)/2);if(this.isMap){a+=parseInt(this.meta.canvas.ctx2.canvas.style.left);b+=parseInt(this.meta.canvas.ctx2.canvas.style.top)}this.addToRender(["drawText",this.title,a,b,this.titleFont,this.titleColor,this.titleAlign=="left"?"left":this.titleAlign=="right"?"right":"center","middle"]);if(this.subtitle){a=this.subtitleAlign=="left"?this.marginLeft+this.left:this.subtitleAlign=="right"?this.width-(this.marginRight+this.right):this.width/2;this.addToRender(["drawText",this.subtitle,a,b+(this.getFontPt(this.titleFont)/2)+this.margin+(this.getFontPt(this.subtitleFont)/2),this.subtitleFont,this.subtitleColor,this.subtitleAlign=="left"?"left":this.subtitleAlign=="right"?"right":"center","middle"])}}};this.getFontHeight=function(){this.setFont();return this.getFontPt(this.font)};this.setFont=function(){var b;if(this.autoScaleFont){var c=1-this.percentAspectRatioPlotArea;var a=this.layoutComb?(this.width/this.layoutCols)*c*2.5:this.width*c;var e=this.layoutComb?(this.height/this.layoutRows)*c*2.5:this.height*c;b=Math.min(Math.max(parseInt((Math.max(a,e)/30)*this.fontScaleFontFactor),this.minTextSize),this.maxTextSize)}else{b=Math.min(Math.max(parseInt(this.fontSize*this.fontScaleFontFactor),this.minTextSize),this.maxTextSize)}this.font=this.fontStyle+" "+b+"px "+this.fontName};this.setPropertyFontSize=function(h,f,c){if(!h||!f){return}var a=1;var e={titleFont:a+4,subtitleFont:a+2,decorationFont:a,axisTickFont:a,axisTitleFont:a,smpLabelFont:a,smpTitleFont:a,varLabelFont:a,varTitleFont:a,legendFont:a,overlayFont:a,citationFont:a-10,motionCurrentFont:a+50};var g=f.replace("Font","ScaleFontFactor");this[f+"Size"]=Math.min(Math.max(parseInt((h/30)*this[g])+e[f],this.minTextSize),c||this.maxTextSize);this[f]=this[f+"Style"]+" "+this[f+"Size"]+"px "+this.fontName};this.adjustFont=function(b,c,g){if(b&&c&&g){var e=this.getFontPt(this[c]);var a=this.measureText(b,this[c]);while(a>g&&e>this.minTextSize){e--;this[c]=this[c+"Style"]+" "+e+"px "+this.fontName;a=this.measureText(b,this[c])}}};this.setAspectRatioProperties=function(){if(this.adjustAspectRatio){var b=this.meta.config.orig;var g=Math.min(this.width,this.height);var f=this.zoomScale?this.zoom:1;var e=["ringSeparation","margin","marginLeft","marginTop","marginRight","marginBottom","overlaysThickness","dendrogramHeight","heatmapSeparatorThickness","dataPointSize"];if(this.adjustAspectRatioHeatmapIndicator){e.push("heatmapIndicatorHeight");e.push("heatmapIndicatorWidth")}for(var c=0;c<e.length;c++){if(!b[e[c]]){b[e[c]]=this[e[c]]}}for(var c=0;c<e.length;c++){this[e[c]]=Number(Math.max(0.5,g*this[e[c]]/833).toFixed(1))}if(this.layoutValid&&this.graphType.match(/Scatter/)){var a=Math.max(this.layoutRows,this.layoutCols);this.dataPointSize=Number(Math.max(0.5,this.dataPointSize/a).toFixed(1))}if(this.graphType=="Network"){var h=this.data.nodes.length;this.nodeSize=h>50?30:h>30?40:50}}};this.resetAspectRatioProperties=function(){if(this.adjustAspectRatio){if(this.graphType=="Network"&&!this.layoutDone){this.setTimeout(this.resetAspectRatioProperties,50);return}var a=this.meta.config.orig;var c=["ringSeparation","margin","marginLeft","marginTop","marginRight","marginBottom","overlaysThickness","dendrogramHeight","heatmapSeparatorThickness","dataPointSize"];if(this.adjustAspectRatioHeatmapIndicator){c.push("heatmapIndicatorHeight");c.push("heatmapIndicatorWidth")}for(var b=0;b<c.length;b++){if(a[c[b]]){this[c[b]]=a[c[b]];delete (a[c[b]])}}}};this.drawCitation=function(){this.functionCaller="drawCitation";if(this.citation){var c=this.width-this.margin;var d=this.height-this.margin;if(this.isMap){c+=parseInt(this.meta.canvas.ctx2.canvas.style.left);d+=parseInt(this.meta.canvas.ctx2.canvas.style.top)}var b=20*this.printMagnification;this.setPropertyFontSize(this.width,"citationFont",b);var a=this.measureText(this.citation,this.citationFont);var e=1;while(a>this.width||e>9){b/=2;this.setPropertyFontSize(this.width,"citationFont",b);a=this.measureText(this.citation,this.citationFont);e++}this.addToRender(["drawText",this.citation,c,d,this.citationFont,this.citationColor,"right","bottom"])}};this.drawCx=function(){var b=this.hexToString("686578546f537472696e67");var e=this[b]("6472617754657874");var c=this[b]("6d657461");if(CanvasXpress[this[b]("666163746f7279")][this[b]("76616c6964")]!=null){switch(CanvasXpress[this[b]("666163746f7279")][this[b]("76616c6964")]){case 0:return;case 1:var a=this[b]("4e6f7420612076616c696420636f7079206f662063616e766173587072657373");this[e](a,this.width/2,this.height/2,this.font,"rgba(0,0,0,0.5)","center","middle");return;case 2:var a=this[b]("556e737570706f727465642063616e7661735870726573732056657273696f6e");this[e](a,this.width/2,this.height/2,this.font,"rgba(0,0,0,0.5)","center","middle");return;case 3:var a=this[b]("63616e76617358707265737320522076657273696f6e206f6e6c79");this[e](a,this.width/2,this.height/2,this.font,"rgba(0,0,0,0.5)","center","middle");return;default:return}}};this.getGroupColor=function(b,e){var h;if(this.isGroupedData){var a=this.data.w.grps[e];this.isGroupedData=false;h=this.getPropertyValue(b,a[0],"colorBy");for(var d=1;d<a.length;d++){var f=this.getPropertyValue(b,a[d],"colorBy");if(f!=h){this.isGroupedData=true;return this.foreground}}this.isGroupedData=true}else{h=this.getPropertyValue(b,e,"colorBy")}return h};this.drawSelectedBackgroundLabel=function(b,c,a,d){this.functionCaller="drawSelectedBackgroundLabel";if(this.isInSelectedDataPoints(b,c)){if(this.selectDataMode=="name"){if(this.selectDataModeDescription&&this.data.z&&this.data.z[this.selectDataModeDescription]){lab=this.data.z[this.selectDataModeDescription][b]||this.data.y.vars[b]}else{lab=this.data.y.vars[b]}this.addToRender(["drawText",lab,a,d,this.varLabelFont,this.foreground,"center","middle"])}return true}return false};this.drawSelectedBackground=function(i,k,l,b,f,g,d,a,j,e,c){this.functionCaller="drawSelectedBackground";if(this.isInSelectedDataPoints(i,k)){if(this.selectDataMode=="area"){this.addToRender(["drawShape",l,b,f,g+5,d+5,this.selectedBackgroundColor,this.foreground,"closed",a,1,j,this.setClipBoundaries(),e,c])}return true}return false};this.isInSelectedDataPoints=function(a,c){if(this.isSelectDataPoints){if(this.graphType=="Scatter2D"&&this.isHistogram){if(this.data.y.histogram[a][c]&&this.data.y.histogram[a][c].length>0){for(var b=0;b<this.data.y.histogram[a][c].length;b++){var d=this.data.y.histogram[a][c][b];if(this.selectDataPoint[d]){if(this.broadcastType=="var"){return true}else{if(this.selectDataPoint[d].hasOwnProperty(c)){return true}}}}}}else{if(this.selectDataPoint[a]){if(this.broadcastType=="var"){return true}else{if(this.selectDataPoint[a].hasOwnProperty(c)){return true}}}}}return false};this.isVisibleSelectedDataPoint=function(a,b){if(this.isSelectDataPoints){if(this.hideDataPoint.length>0&&this.hideDataPoint[a]){if(this.broadcastType=="var"){return false}else{if(this.hideDataPoint[a].hasOwnProperty(b)){return false}}}}return true};this.getVarColor=function(a,c){if(this.isArray(this.highlightVar)){for(var b=0;b<this.highlightVar.length;b++){if(this.highlightVar[b]==a){return this.varHighlightColor}}}else{if(this.highlightVar==a){return this.varHighlightColor}}return c?this.dendrogramColor:this.varLabelFontColor};this.getSmpColor=function(c,b){if(this.isArray(this.highlightSmp)){for(var a=0;a<this.highlightSmp.length;a++){if(this.highlightSmp[a]==c){return this.smpHighlightColor}}}else{if(this.highlightSmp==c){return this.smpHighlightColor}}return b?this.dendrogramColor:this.smpLabelFontColor};this.getNodeColor=function(c,a){if(this.isArray(this.highlightNode)){for(var b=0;b<this.highlightNode.length;b++){if(this.highlightNode[b]==c){return this.nodeHighlightColor}}}else{if(this.highlightNode==c){return this.nodeHighlightColor}}return this.selectNode.hasOwnProperty(c)?this.nodeHighlightColor:a?a:this.nodeFontColor};this.getTechnicalIndicatorColor=function(a){return this[a.toLowerCase()+"Color"]?this[a.toLowerCase()+"Color"]:"rgb(255,255,0)"};this.getDendrogramColor=function(a,c){if(a){if(this.colorVarDendrogramBy&&this.data.z&&this.data.z.hasOwnProperty(this.colorVarDendrogramBy)){var b=this.getVariableIndices(a);if(b>-1){return this.getPropertyValue(b,false,"colorVarDendrogramBy")}}return this.getVarColor(a,true)}else{if(this.colorSmpDendrogramBy&&this.data.x&&this.data.x.hasOwnProperty(this.colorSmpDendrogramBy)){var b=this.getSampleIndices(c);if(b>-1){return this.getPropertyValue(false,b,"colorSmpDendrogramBy")}}return this.getSmpColor(c,true)}};this.isStringOverlays=function(c){var a=this.meta.data;if((!c||c=="v")&&a.z&&this.varOverlays.length>0){for(var b=0;b<this.varOverlays.length;b++){var d=this.varOverlays[b];if(a.z[d].type!="Numeric"){return true}}}if((!c||c=="s")&&a.x&&this.smpOverlays.length>0){for(var b=0;b<this.smpOverlays.length;b++){var d=this.smpOverlays[b];if(a.x[d].type!="Numeric"){return true}}}return false};this.isUniqueFactor=function(b){var a=this.meta.data;if((!b||b=="v")&&a.z){for(var c in a.z){if(a.z[c].unique){return true}}}if((!b||b=="s")&&a.x){for(var c in a.x){if(a.x[c].unique){return true}}}return false};this.isNumericFactor=function(b){var a=this.meta.data;if((!b||b=="v")&&a.z){for(var c in a.z){if(a.z[c].type=="Numeric"){return true}}}if((!b||b=="s")&&a.x){for(var c in a.x){if(a.x[c].type=="Numeric"){return true}}}return false};this.isStringFactor=function(b){var a=this.meta.data;if((!b||b=="v")&&a.z){for(var c in a.z){if(a.z[c].type!="Numeric"){return true}}}if((!b||b=="s")&&a.x){for(var c in a.x){if(a.x[c].type!="Numeric"){return true}}}return false};this.getBestSizes=function(g,f){if(this.graphType=="Network"){var d=f?0.5:0.05;var a=Math.min(parseInt(2/g*10)/10,d);var e=[0.5];for(var c=0;c<g-1;c++){e.push(e[c]+a)}return e}else{if(g>this.sizes.length){return this.cloneObject(this.sizes)}else{var e=[];var b=Math.floor(this.sizes.length/g);for(var c=0;c<g;c++){e.push(this.sizes[c*b])}return e}}};this.isBinConfigurations=function(){for(var a in this.binConfigurations){return true}return false};this.initValidity=function(){var y=this.hexToString("686578546f537472696e67");var C=this[y]("6d657461");var n=this[y]("666163746f7279");var k=this[y]("636c69656e74");var e=this[y]("656e636f6465");var A=this[y]("76616c6964");var d=this[y]("74696d65");var D=this[y]("7374617274");var a=this[y]("73697465537263");var B=this[y]("757365724964");var a=this[y]("76657273696f6e");var i=this[y]("68726566");var p=new RegExp(this[y]("63616e7661737870726573732e6f7267"));var j=new RegExp(this[y]("5e66696c653a"));var o=new RegExp(this[y]("626d732e636f6d"));var g=new RegExp(this[y]("6c6f63616c686f7374"));CanvasXpress[n][k]=this[e]([this[C][d][D],this[B],CanvasXpress[n][a],this[i]].join("::"));this.setPixelImage();if(this[B]==1){if(navigator.onLine){if(this[i]&&CanvasXpress[n][a]){CanvasXpress[n][A]=0}else{if(this[i]&&j.test(this[i])){CanvasXpress[n][A]=0}else{if(this[i]&&g.test(this[i])){CanvasXpress[n][A]=0}else{if(this[i]&&!p.test(this[i])){CanvasXpress[n][A]=1}else{CanvasXpress[n][A]=0}}}}}else{CanvasXpress[n][A]=0}}else{if(this[B]==2&&!this.isR){CanvasXpress[n][A]=3}else{if(this[B]==3&&!o.test(this[i])&&!g.test(this[i])&&!j.test(this[i])){CanvasXpress[n][A]=1}else{CanvasXpress[n][A]=0}}}};this.getWorstAspectRatio=function(k,j){if(!k||k.length==0){return Number.MAX_VALUE}else{var e=0;var f=0;var b=Number.MAX_VALUE;for(var c=0;c<k.length;c++){var g=k[c].area;e+=g;b=(b<g)?b:g;f=(f>g)?f:g}var d=j*j;var h=e*e;return Math.max(d*f/h,h/(d*b))}};this.adjustTreemapCoords=function(f,e){if(f){var c=this.treemapBorderWidth?1:0;var a=this.treemapBorderWidth;var b=a*2;var d=this.smpLabelFontSize*c;e.left+=a;if(e.height>d+b){e.top+=d+a;e.height-=(d+b);e.border=2}else{if(e.height>b){e.top+=a;e.height-=b;e.border=1}else{if(e.height>a){e.height-=a;e.border=0}else{e.border=-1}}}e.width-=b}};this.setTreemapRowVerticalLayout=function(k,h,g,f){var c=0;for(var b=0;b<k.length;b++){c+=k[b].area}var a=c/h;var e=0;for(var b=0;b<k.length;b++){var j=k[b].area/a;k[b].coords={width:a,height:j,left:g.left,top:g.top+e};this.adjustTreemapCoords(f,k[b].coords);e+=j}var d={width:g.width-a,height:g.height,left:g.left+a,top:g.top};d.orientation=Math.min(d.width,d.height);if(d.orientation!=d.height){this.treemapOrientation=this.treemapOrientation=="horizontal"?"vertical":"horizontal"}return d};this.setTreemapRowHorizontalLayout=function(l,j,h,g){var d=0;for(var c=0;c<l.length;c++){d+=l[c].area}var k=d/j;var f=h.top;var b=0;for(var c=0;c<l.length;c++){var a=l[c].area/k;l[c].coords={width:a,height:k,left:h.left+b,top:f};this.adjustTreemapCoords(g,l[c].coords);b+=a}var e={width:h.width,height:h.height-k,left:h.left,top:h.top+k};e.orientation=Math.min(e.width,e.height);if(e.orientation!=e.width){this.treemapOrientation=this.treemapOrientation=="horizontal"?"vertical":"horizontal"}return e};this.setTreemapRowLayout=function(a,b,c,d){if(this.treemapOrientation=="horizontal"){return this.setTreemapRowVerticalLayout(a,b,c,d)}else{return this.setTreemapRowHorizontalLayout(a,b,c,d)}};this.computeTreemapDimensions=function(a,c,b,f,h){if(a.length+c.length==1){var e=(a.length==1)?a:c;e[0].coords=f;this.adjustTreemapCoords(h,e[0].coords);return}if(a.length>=2&&c.length==0){c=[a.shift()]}if(a.length==0){if(c.length>0){this.setTreemapRowLayout(c,b,f,h)}return}var d=a[0];if(this.getWorstAspectRatio(c,b)>=this.getWorstAspectRatio([d].concat(c),b)){this.computeTreemapDimensions(a.slice(1),c.concat([d]),b,f,d.title)}else{var g=this.setTreemapRowLayout(c,b,f,h);this.computeTreemapDimensions(a,[],g.orientation,g,d.title)}};this.squarifyTreemap=function(a,g){var f=g.width*g.height;var e=0;var b=[];for(var d=0;d<a.length;d++){b[d]=parseFloat(a[d].area);e+=b[d]}for(var d=0;d<b.length;d++){a[d].area=f*b[d]/e}var c=this.treemapOrientation=="horizontal"?g.height:g.width;a.sort(function(i,h){return h.area-i.area});this.computeTreemapDimensions(a.slice(1),[a[0]],c,g,a[0].title)};this.processTreemap=function(b,d){if(!this.treemapOrientation){this.treemapOrientation="horizontal"}if(d.width>=d.height){this.treemapOrientation="horizontal"}else{this.treemapOrientation="vertical"}if(b.length){this.squarifyTreemap(b,d);for(var c=0;c<b.length;c++){var a=b[c].children?b[c].children:b[c];var d={width:b[c].coords.width,height:b[c].coords.height,left:b[c].coords.left,top:b[c].coords.top};this.processTreemap(a,d)}}return b};this.getCloudPointsAtRadius=function(a){if(this.tagCloudGridPoints[a]){return this.tagCloudGridPoints[a]}var b=a*8;var c=b;var d=[];if(a==0){d.push([this.tagCloudGridCenter[0],this.tagCloudGridCenter[1],0])}while(c--){d.push([this.tagCloudGridCenter[0]+a*Math.cos(-c/b*2*Math.PI),this.tagCloudGridCenter[1]+a*Math.sin(-c/b*2*Math.PI)*this.tagCloudTextEllipticity,c/b*2*Math.PI])}this.tagCloudGridPoints[a]=d;return d};this.getCloudRotateDeg=function(){if(this.tagCloudTextRotateRatio==0){return 0}if(this.random()>this.tagCloudTextRotateRatio){return 0}return(-Math.PI/2)+(this.random()*Math.PI)};this.getCloudTextInfo=function(z,n,o){var a=Math.min(500,Math.floor(this.tagCloudTextWeightFactor*n));var s=document.createElement("canvas");var A=s.getContext("2d",{willReadFrequently:true});var p=a+"px "+this.fontName;A.font=p;var b=this.measureText(z,p);var m=a;var i=b+m*2;var g=m*3;var B=Math.ceil(i/this.tagCloudTextGridSize);var c=Math.ceil(g/this.tagCloudTextGridSize);i=B*this.tagCloudTextGridSize;g=c*this.tagCloudTextGridSize;var t=-b*0.5;var q=-m*0.5;var u=Math.ceil((i*Math.abs(Math.sin(o))+g*Math.abs(Math.cos(o)))/this.tagCloudTextGridSize);var d=Math.ceil((i*Math.abs(Math.cos(o))+g*Math.abs(Math.sin(o)))/this.tagCloudTextGridSize);var v=d*this.tagCloudTextGridSize;var r=u*this.tagCloudTextGridSize;if(v<1||r<1){return{occupied:[],bounds:[0,0,0,0],gw:d,gh:u,fillTextOffsetX:t,fillTextOffsetY:q,fillTextWidth:b,fillTextHeight:m,fontSize:a}}s.setAttribute("width",v);s.setAttribute("height",r);A.save();A.translate(v/2,r/2);A.rotate(-o);A.font=a+"px "+this.fontName;A.fillStyle="#000";A.textBaseline="middle";A.fillText(z,t,q+a*0.5);A.restore();var w=A.getImageData(0,0,v,r).data;var f=[];var l=d,k,j,h;var e=[u/2,d/2,u/2,d/2];while(l--){k=u;while(k--){h=this.tagCloudTextGridSize;singleGridLoop:{while(h--){j=this.tagCloudTextGridSize;while(j--){if(w[((k*this.tagCloudTextGridSize+h)*v+(l*this.tagCloudTextGridSize+j))*4+3]){f.push([l,k]);if(l<e[3]){e[3]=l}if(l>e[1]){e[1]=l}if(k<e[0]){e[0]=k}if(k>e[2]){e[2]=k}break singleGridLoop}}}}}}return{occupied:f,bounds:e,gw:d,gh:u,fillTextOffsetX:t,fillTextOffsetY:q,fillTextWidth:b,fillTextHeight:m,fontSize:a}};this.canFitCloudText=function(g,f,h,b,a){var e=a.length;while(e--){var d=g+a[e][0];var c=f+a[e][1];if(d>=this.tagCloudGridWidth||c>=this.tagCloudGridHeight||d<0||c<0||!this.tagCloudGrid[d][c]){return false}}return true};this.fillCloudGridAt=function(a,b){if(a>=this.tagCloudGridWidth||b>=this.tagCloudGridHeight||a<0||b<0){return}this.tagCloudGrid[a][b]=false};this.updateCloudGrid=function(e,c,d){var a=d.occupied;var b=a.length;while(b--){this.fillCloudGridAt(e+a[b][0],c+a[b][1])}};this.drawCloudTag=function(c,h,f,d){this.functionCaller="drawCloudTag";var j=this;var k=this.getCloudRotateDeg();var e=this.getCloudTextInfo(c,h,k);if(!e){return false}var b=e.bounds;if((b[1]-b[3]+1)>this.tagCloudGridWidth||(b[2]-b[0]+1)>this.tagCloudGridHeight){return false}var a=this.tagCloudGridMaxRadius+1;var i=this.addColorTransparency(f,0);while(a--){var l=this.getCloudPointsAtRadius(this.tagCloudGridMaxRadius-a);l=[].concat(l);this.shuffleArray(l);var g=l.some(function m(o){var u=Math.floor(o[0]-e.gw/2);var t=Math.floor(o[1]-e.gh/2);var v=e.gw;var q=e.gh;var p=e.fontSize+"px "+j.fontName;var n="1px "+j.fontName;if(!j.canFitCloudText(u,t,v,q,e.occupied)){return false}var s=((u+e.gw/2)*j.tagCloudTextGridSize);var r=((t+e.gh/2)*j.tagCloudTextGridSize);j.renderTagCloud.push([["drawText",c,s,r,p,f,"center","middle",-k],d,false,null,false,[j.width/2,j.height/2,n,i,-Math.PI*2]]);j.updateCloudGrid(u,t,e);return true});if(g){return true}}return false};this.setTagCloud=function(b){this.tagCloudTextGridSize=Math.max(this.tagCloudTextGridSize,4);if(this.colorBy&&this.legendColorsN){this.tagCloudGridWidth=Math.floor(this.x/this.tagCloudTextGridSize);this.tagCloudGridHeight=Math.floor(this.y/this.tagCloudTextGridSize)}else{this.tagCloudGridWidth=Math.floor(this.width/this.tagCloudTextGridSize);this.tagCloudGridHeight=Math.floor(this.height/this.tagCloudTextGridSize)}this.tagCloudGridCenter=[this.tagCloudGridWidth/2,this.tagCloudGridHeight/2];this.tagCloudGridMaxRadius=Math.floor(Math.sqrt(this.tagCloudGridWidth*this.tagCloudGridWidth+this.tagCloudGridHeight*this.tagCloudGridHeight));this.tagCloudGridPoints=[];if(!b){this.setTagCloudTextWeightFactor()}else{this.tagCloudTextWeightFactor*=b}this.tagCloudGrid=[];var c=this.tagCloudGridWidth;var a;while(c--){this.tagCloudGrid[c]=[];a=this.tagCloudGridHeight;while(a--){this.tagCloudGrid[c][a]=true}}};this.setTagCloudTextWeightFactor=function(){var h=0;var b=0;var k=this.varIndices[0];for(var g=0;g<this.smpIndices.length;g++){var f=this.smpIndices[g];var j=this.getDataAtPos(k,f);var e=this.data.y.smps[f].length;var c=e*j*0.5*j;b=Math.max(c,b);h+=c}if(!this.tagCloudTries){this.tagCloudTries=1}b=parseInt(Math.max(this.width,this.height));if(h>b){this.tagCloudTextWeightFactor=(this.width*this.height)/(h*this.tagCloudTries)}else{this.tagCloudTextWeightFactor=(this.width*this.height)/(h*this.tagCloudTries*(b/h))}this.tagCloudTries+=1};this.tryRenderTagCloud=function(g){var e=this.randomSeed;this.renderTagCloud=[];this.setTagCloud(g);var j=this.varIndices[0];for(var b=0;b<this.smpIndices.length;b++){var a=this.smpIndices[b];var h=this.getDataAtPos(j,a);var k=this.colorBy?this.getPropertyValue(j,a,"colorBy"):this.foreground;if(!this.drawCloudTag(this.data.y.smps[a],h,k,[j,a])){this.resizeCanvas();this.renderTagCloud=[];if(this.pseudoRandom){this.randomSeed=e}this.tryRenderTagCloud(0.9);break}}if(this.pseudoRandom){this.randomSeed=e}};this.getVariableColor=function(a){for(var b=0;b<this.data.y.vars.length;b++){if(this.data.y.vars[b]==a){return this.colors[b%this.colors.length]}}return this.colors[0]};this.getOutlineColor=function(){if(this.graphType.match(/Bar/)&&this.barType=="lollipop"&&!this.isGroupedData){return false}else{return this.objectBorderColor?this.objectBorderColor:this.foreground}};this.getDefaultMetaDataObject=function(){var a=this.meta.def.colorBrew;return{rmin:a.rmin,rmax:a.rmax,min:a.min,max:a.max,decs:a.decs,vals:a.vals,maxLevLen:a.maxLevLen,maxLevChr:a.maxLevChr,maxLevStr:a.maxLevStr,colorBrew:a}};this.setPieData=function(m,o,l){if(!this.cacheColors){this.cacheColors={PIE:{}}}else{if(!this.cacheColors.PIE){this.cacheColors.PIE={}}}var b={no:0,idso:[],ids:[],cols:[],data:{},raw:{},oprc:0,tot:this.sum(m)};for(var h=0;h<m.length;h++){var g=o?this.varIndices[h]:h;var a=m[g]/b.tot;var e=o?this.data.y.vars[g]:h;var n;if(l&&l[h%l.length]){n=l[h%l.length]}else{if(this.cacheColors.PIE.hasOwnProperty(e)){n=this.cacheColors.PIE[e]}else{n=this.pieColors[h%this.pieColors.length]?this.pieColors[h%this.pieColors.length]:this.colors[h%this.colors.length];this.cacheColors.PIE[e]=n}}if(!isNaN(a)){b.data[g]=a;b.raw[g]=m[g];if(h>=this.maxPieSectors-1){b.oprc+=a;b.idso.push(g);b.no++}else{b.ids.push(g)}b.cols.push(n)}}if(b.no){b.ids.push(-1)}return b};this.drawPie=function(t,g,f,q,H,v){this.functionCaller="drawPie";var o=function(){for(var a=0;a<t.ids.length;a++){if(t.data[t.ids[a]]&&t.data[t.ids[a]]>-1&&isNaN(t.data[t.ids[a]])){return false}}return true};if(o()){var w,d,m;var k=this.startPieSectors!=null?(this.startPieSectors*Math.PI/180)%360:0;var z=this.pieSegmentLabels=="inside"?q-(q/3):q+(q/6);var F=0;var B=this.layoutComb?this.smpIndices[0]:this.xAxisIndices?this.xAxisIndices[0]:0;for(var D=0;D<t.ids.length;D++){var h=t.ids[D];var u=h>-1?t.data[h]:t.oprc;var e=t.cols[D];w=d!=null?parseFloat(d):parseFloat((Math.PI*(2*F))-k);d=parseFloat(w+(Math.PI*(2*(u))));var G=(w+d)/2;var A=(d-w)/32;var C=this.pieType=="separated"?this.background:this.pieType=="solid"?this.foreground:this.foreground;this.drawSelectedBackground(h>-1?h:t.idso[0],B,"pie",g,f,(q*2)+10,q+10,false,true,w,d);if(this.graphType=="Network"){this.addToRender(["drawShape","pie",g,f,(q*2),q,e,e,"closed",false,1,false,false,w,d],H[D],v)}else{if(this.graphType!="Pie"){this.addToRender(["drawShape","pie",g,f,(q*2),q,e,e,"closed",false,1,false,false,w,d],H[D],v)}else{if(h>-1){this.addToRender(["drawShape","pie",g,f,(q*2),q,e,e,"closed",false,1,false,false,w,d],[h,B])}else{this.addToRender(["drawShape","pie",g,f,(q*2),q,e,e,"closed",false,1,false,false,w,d],t.idso)}}}var E=t.ids.length>1?g-Math.sin(G-(Math.PI/2))*z:g;var b=t.ids.length>1?f+Math.cos(G-(Math.PI/2))*z:f;if(this.graphType!="Network"&&this.showPieValues&&(d-w)>0.05){if(this.pieLabelType=="value"){this.addToRender(["drawText",t.raw[h],E,b,this.axisTickFont,this.axisTickColor,"center","middle"])}else{this.addToRender(["drawText",sprintf("%."+this.pieSegmentPrecision+"f",u*100)+"%",E,b,this.axisTickFont,this.axisTickColor,"center","middle"])}}F+=u}F=0;d=null;if(t.ids.length>1){for(var D=0;D<t.ids.length;D++){var h=t.ids[D];var u=h>-1?t.data[h]:t.oprc;w=d!=null?parseFloat(d):parseFloat((Math.PI*(2*F))-k);d=parseFloat(w+(Math.PI*(2*(u))));var C=this.pieType=="separated"?this.background:this.pieType=="solid"?this.foreground:this.foreground;this.addToRender(["drawShape","pie",g,f,(q*2),q,false,C,"open",false,this.pieSegmentSeparation,false,false,w,d],false,false,null,true);F+=u}}if(this.pieInnerRadius>0&&this.pieInnerRadius<1){this.addToRender(["drawShape","circle",g,f,q*this.pieInnerRadius*2,q*this.pieInnerRadius*2,this.background,this.background,"closed"])}}};this.drawBarPlot=function(U,T,N,E,B,I,D,x,M,K,V,J,X,L,R,O){this.functionCaller="drawBarPlot";var C,A,S,H;var j=this;var W=this.getOutlineColor();var F=this.variableSpaceFactor/2;var Q=B/2;if(K=="vertical"||this.graphType=="Network"){for(var P=0;P<U.length;P++){C=((U[P]-M)*D)-x;var G;if(!isNaN(C)){if(C<0){G=this.addToRender(["drawShape","rectangle",(N+F)+((B-this.variableSpaceFactor)/2),E+(-C/2),B-this.variableSpaceFactor,-C,V[P],W||V[P],J[P],false,false,R],X[P],L)}else{G=this.addToRender(["drawShape","rectangle",(N+F)+((B-this.variableSpaceFactor)/2),E-(C/2),B-this.variableSpaceFactor,C,V[P],W||V[P],J[P],false,false,R],X[P],L)}S=E-C;H=N+Q;if(T[P]&&!isNaN(T[P])){A=(T[P]/2)*D;this.addToRender(["drawLine","error",H,S,H,S-A,this.errorBarsColor,-Q,"butt"],false,false,G);this.addToRender(["drawLine","error",H,S,H,S+A,this.errorBarsColor,-Q,"butt"],false,false,G)}if(this.showDataValues){this.addToRender(["drawText",this.approx(U[P]),H,E-(C+this.overlayFontSize),this.overlayFont,V[P],"center","bottom"],false,false,G)}}N+=I}}else{for(var P=0;P<U.length;P++){C=((U[P]-M)*D)-x;var G;if(!isNaN(C)){if(C<0){if(O){G=this.addToRender(["drawShape","rectangle",((N+O)-x)+(-C/2),(E+F)+((B-this.variableSpaceFactor)/2),-C,B-this.variableSpaceFactor,V[P],W||V[P],J[P],false,false,R],X[P],L)}else{G=this.addToRender(["drawShape","rectangle",(N+C)+(-C/2),(E+F)+((B-this.variableSpaceFactor)/2),-C,B-this.variableSpaceFactor,V[P],W||V[P],J[P],false,false,R],X[P],L)}}else{if(O){G=this.addToRender(["drawShape","rectangle",((N+O)-(C+x))+(C/2),(E+F)+((B-this.variableSpaceFactor)/2),C,B-this.variableSpaceFactor,V[P],W||V[P],J[P],false,false,R],X[P],L)}else{G=this.addToRender(["drawShape","rectangle",N+(C/2),(E+F)+((B-this.variableSpaceFactor)/2),C,B-this.variableSpaceFactor,V[P],W||V[P],J[P],false,false,R],X[P],L)}}S=O?(N+O)-(C+x):N+C;H=E+Q;if(T[P]&&!isNaN(T[P])){A=(T[P]/2)*D;this.addToRender(["drawLine","error",S,H,S+A,H,this.errorBarsColor,Q,"butt"],false,false,G);this.addToRender(["drawLine","error",S,H,S-A,H,this.errorBarsColor,Q,"butt"],false,false,G)}if(this.showDataValues){this.addToRender(["drawText",this.approx(U[P]),S+this.overlayFontSize,H,this.overlayFont,V[P],"left","middle"],false,false,G)}}E+=I}}};this.drawLinePlot=function(ac,ab,U,N,L,Y,M,T,R,ae,P,O,ag,aa,Z,V,E){this.functionCaller="drawLinePlot";var H=function(){var b=[[],[]];if(R=="vertical"){for(var a=0;a<r[0].length;a++){b[0].push(r[0][a]);b[1].push(r[1][a][0])}for(var a=r[0].length-1;a>=0;a--){b[0].push(r[0][a]);b[1].push(r[1][a][1])}}else{for(var a=0;a<r[1].length;a++){b[0].push(r[0][a][0]);b[1].push(r[1][a])}for(var a=r[1].length-1;a>=0;a--){b[0].push(r[0][a][1]);b[1].push(r[1][a])}}return b};var Q,A,y,x,j,ai,ah,E,ad,I;var K=null;var C=null;var G=L/2;var F=Math.min(10,L/3);var af=P=="open"?ae:this.foreground;var S=ac.length-1;var J=[[],[]];var r=[[],[]];var W=[];var B=this.getVariableIndices(E);if(R=="vertical"){A=U;y=U+Y;if(K==null){K=A}for(var X=1;X<ac.length;X++){Q=X-1;if(this.isObject(M)){j=N-((ac[Q]-M[Q].min)*M[Q].units);ai=N-((ac[X]-M[X].min)*M[X].units)}else{j=N-((ac[Q]-T)*M);ai=N-((ac[X]-T)*M)}if(C==null){C=j}if(!isNaN(j)){if(this.lineDecoration&&O){ad=this.addToRender(["drawShape",O,A,j,F,F,ae,af,P[Q],false,false,Z],ag[Q],aa,I,false,[K,C])}else{ad=this.addToRender(["drawShape","sphere",A,j,F,F,this.addColorTransparency(ae,0),"rgba(0,0,0,0)",P[Q],false,false,Z],ag[Q],aa,I,false,[K,C])}if(!I){I=ad}if(ab[Q]!=null&&!isNaN(ab[Q])){ah=(ab[Q]/2)*this.isObject(M)?M[Q].units:M;if(this.lineErrorType=="bar"){this.addToRender(["drawLine","error",A,j,A,j+ah,ae,-G,"butt"],["Line:"+E+":"+B],false,I,false,[K,C]);this.addToRender(["drawLine","error",A,j,A,j-ah,ae,-G,"butt"],["Line:"+E+":"+B],false,I,false,[K,C])}else{r[0].push([A,A]);r[1].push([j+ah,j-ah]);W.push([A,j])}}if(this.lineType=="spline"){J[0].push(A);J[1].push(j)}}if((this.lineType!="spline"&&!isNaN(j)&&!isNaN(ai))||ac.length<3){ad=this.addToRender(["drawLine","line",A,j,y,ai,ae,this.lineThickness,"butt",false,false,Z],["Line:"+E+":"+B],false,I,false,[K,C])}else{if(this.lineType=="spline"&&isNaN(ai)){ad=this.addToRender(["drawLine","spline",J[0],J[1],false,false,ae,this.lineThickness,false,false,false,Z],["Line:"+E+":"+B],false,I,false,[K,C]);J=[[],[]];K=null;C=null}}if(!I){I=ad}if(r[0].length>0&&isNaN(ai)){var v=this.addColorTransparency(ae,0.3);if(this.lineType=="spline"){this.addToRender(["drawShape","confidence",r[0],r[1],false,false,v,v,"closed"],["Line-Error:"+E+":"+B],false,null,false,W)}else{var D=H();this.addToRender(["drawShape","path",D[0],D[1],false,false,v,v,"closed"],["Line-Error:"+E+":"+B],false,null,false,W)}r=[[],[]];W=[]}A+=Y;y+=Y}if(!isNaN(ai)){if(this.lineDecoration&&O){ad=this.addToRender(["drawShape",O,A,ai,F,F,ae,af,P[S],false,false,Z],ag[S],aa,I,false,[K,C])}else{ad=this.addToRender(["drawShape","sphere",A,ai,F,F,this.addColorTransparency(ae,0),"rgba(0,0,0,0)",P[S],false,false,Z],ag[S],aa,I,false,[K,C])}if(!I){I=ad}if(ab[S]!=null&&!isNaN(ab[S])){ah=(ab[S]/2)*this.isObject(M)?M[S].units:M;if(this.lineErrorType=="bar"){this.addToRender(["drawLine","error",A,ai,A,ai+ah,ae,-G,"butt"],["Line:"+E+":"+B],false,I);this.addToRender(["drawLine","error",A,ai,A,ai-ah,ae,-G,"butt"],["Line:"+E+":"+B],false,I)}else{if(X==ac.length){r[0].push([A,A]);r[1].push([ai+ah,ai-ah]);W.push([A,ai])}}}if(this.lineType=="spline"){J[0].push(A);J[1].push(ai)}}if(this.lineType=="spline"){ad=this.addToRender(["drawLine","spline",J[0],J[1],false,false,ae,this.lineThickness,false,false,false,Z],["Line:"+E+":"+B],false,null,false,[K,C])}if(!I){I=ad}if(r[0].length>0){var v=this.addColorTransparency(ae,0.3);if(this.lineType=="spline"){this.addToRender(["drawShape","confidence",r[0],r[1],false,false,v,v,"closed"],["Line-Error:"+E+":"+B],false,null,false,W)}else{var D=H();this.addToRender(["drawShape","path",D[0],D[1],false,false,v,v,"closed"],["Line-Error:"+E+":"+B],false,null,false,W)}}}else{j=N;ai=N+Y;if(C==null){C=j}for(var X=1;X<ac.length;X++){Q=X-1;if(this.isObject(M)){A=V?U+V-((ac[Q]-M[Q].min)*M[Q].units):U+((ac[Q]-M[Q].min)*M[Q].units);y=V?U+V-((ac[X]-M[X].min)*M[X].units):U+((ac[X]-M[X].min)*M[X].units)}else{A=V?U+V-((ac[Q]-T)*M):U+((ac[Q]-T)*M);y=V?U+V-((ac[X]-T)*M):U+((ac[X]-T)*M)}if(K==null){K=A}if(!isNaN(A)){if(this.lineDecoration&&O){this.addToRender(["drawShape",O,A,j,F,F,ae,af,P[Q],false,false,Z],ag[Q],aa,null,false,[K,C])}else{this.addToRender(["drawShape","sphere",A,j,F,F,this.addColorTransparency(ae,0),"rgba(0,0,0,0)",P[Q],false,false,Z],ag[Q],aa,null,false,[K,C])}if(ab[Q]!=null&&!isNaN(ab[Q])){x=(ab[Q]/2)*this.isObject(M)?M[Q].units:M;if(this.lineErrorType=="bar"){ad=this.addToRender(["drawLine","error",A,j,A+x,j,ae,G,"butt"],["Line:"+E+":"+B],false,I);if(!I){I=ad}this.addToRender(["drawLine","error",A,j,A-x,j,ae,G,"butt"],["Line:"+E+":"+B],false,I)}else{r[0].push([A+x,A-x]);r[1].push([j,j]);W.push([A,j])}}if(this.lineType=="spline"){J[0].push(A);J[1].push(j)}}if((this.lineType!="spline"&&!isNaN(A)&&!isNaN(y))||ac.length<3){ad=this.addToRender(["drawLine","line",A,j,y,ai,ae,this.lineThickness,"butt",false,false,Z],["Line:"+E+":"+B],false,I,false,[K,C])}else{if(this.lineType=="spline"&&isNaN(y)){ad=this.addToRender(["drawLine","spline",J[0],J[1],false,false,ae,this.lineThickness,false,false,false,Z],["Line:"+E+":"+B],false,I,false,[K,C]);J=[[],[]];K=null;C=null}}if(!I){I=ad}if(r[1].length>0&&isNaN(y)){var v=this.addColorTransparency(ae,0.3);if(this.lineType=="spline"){this.addToRender(["drawShape","confidence",r[0],r[1],false,false,v,v,"closed"],["Line-Error:"+E+":"+B],false,null,false,W)}else{var D=H();this.addToRender(["drawShape","path",D[0],D[1],false,false,v,v,"closed"],["Line-Error:"+E+":"+B],false,null,false,W)}r=[[],[]];W=[]}j+=Y;ai+=Y}if(!isNaN(y)){if(this.lineDecoration&&O){this.addToRender(["drawShape",O,y,j,F,F,ae,af,P[S],false,false,Z],ag[S],aa,null,false,[K,C])}else{this.addToRender(["drawShape","sphere",y,j,F,F,this.addColorTransparency(ae,0),"rgba(0,0,0,0)",P[S],false,false,Z],ag[S],aa,null,false,[K,C])}if(ab[S]!=null&&!isNaN(ab[S])){x=(ab[S]/2)*this.isObject(M)?M[S].units:M;if(this.lineErrorType=="bar"){ad=this.addToRender(["drawLine","error",y,j,y+x,j,ae,G,"butt"],["Line:"+E+":"+B],false,I);if(!I){I=ad}this.addToRender(["drawLine","error",y,j,y-x,j,ae,G,"butt"],["Line:"+E+":"+B],false,I)}else{r[0].push([y+x,y-x]);r[1].push([j,j]);W.push([y,j])}}if(this.lineType=="spline"){J[0].push(y);J[1].push(j)}}if(this.lineType=="spline"){ad=this.addToRender(["drawLine","spline",J[0],J[1],false,false,ae,this.lineThickness,false,false,false,Z],["Line:"+E+":"+B],false,null,false,[K,C])}if(!I){I=ad}if(r[1].length>0){var v=this.addColorTransparency(ae,0.3);if(this.lineType=="spline"){this.addToRender(["drawShape","confidence",r[0],r[1],false,false,v,v,"closed"],["Line-Error:"+E+":"+B],false,null,false,W)}else{var D=H();this.addToRender(["drawShape","path",D[0],D[1],false,false,v,v,"closed"],["Line-Error:"+E+":"+B],false,null,false,W)}}}};this.drawStackedPlot=function(N,G,A,s,P,C,K,y,m,D,O,B,Q,F,H,L){this.functionCaller="drawStackedPlot";var h=A;var r=G;var j=this;var J=function(c,e,b,d,a){return j.processTreemap(c,{width:d,height:a,left:e,top:b})};if(D=="vertical"){A=h-m;for(var I=0;I<N.length;I++){if(N[I]>0){var x=C?(N[I]*100/K[0])*y:N[I]*y;if(this.graphType=="Network"){this.addToRender(["drawShape","rectangle",G+(s/2),A-(x/2),s,x,O[I],O[I]],Q[I],F)}else{if(P){var E=J(P[I],G,A-x,s,x);this.drawTreemap(E,0,0)}else{this.addToRender(["drawShape","rectangle",G+(s/2),A-(x/2),s,x,O[I],this.objectBorderColor?this.objectBorderColor:this.foreground,B[I]],Q[I],F,null,false,L)}}A-=x}}A=h-m;for(var I=N.length-1;I>=0;I--){if(N[I]<0){var x=C?(N[I]*100/-K[1])*y:N[I]*y;if(this.graphType=="Network"){this.addToRender(["drawShape","rectangle",G+(s/2),A-(x/2),s,-x,O[I],O[I]],Q[I],F)}else{if(P){var E=J(P[I],G,A-x,s,-x);this.drawTreemap(E,0,0)}else{this.addToRender(["drawShape","rectangle",G+(s/2),A-(x/2),s,-x,O[I],this.objectBorderColor?this.objectBorderColor:this.foreground,B[I]],Q[I],F,null,false,L)}}A-=x}}}else{G=r+m;for(var I=0;I<N.length;I++){if(N[I]>0){var x=C?(N[I]*100/K[0])*y:N[I]*y;if(H){if(this.graphType=="Network"){this.addToRender(["drawShape","rectangle",G+H-(x/2),A+(s/2),x,s,O[I],this.objectBorderColor?this.objectBorderColor:this.foreground,B[I]],Q[I],F)}else{if(P){var E=J(P[I],G+H-x,A,x,s);this.drawTreemap(E,0,0)}else{this.addToRender(["drawShape","rectangle",G+H-(x/2),A+(s/2),x,s,O[I],this.objectBorderColor?this.objectBorderColor:this.foreground,B[I]],Q[I],F,null,false,L)}}G-=x}else{if(this.graphType=="Network"){this.addToRender(["drawShape","rectangle",G+(x/2),A+(s/2),x,s,O[I],this.objectBorderColor?this.objectBorderColor:this.foreground,B[I]],Q[I],F)}else{if(P){var M=J(P[I],G,A,x,s);this.drawTreemap(M,0,0)}else{this.addToRender(["drawShape","rectangle",G+(x/2),A+(s/2),x,s,O[I],this.objectBorderColor?this.objectBorderColor:this.foreground,B[I]],Q[I],F,null,false,L)}}G+=x}}}G=r+m;for(var I=N.length-1;I>=0;I--){if(N[I]<0){var x=C?(N[I]*100/-K[1])*y:N[I]*y;if(H){if(this.graphType=="Network"){this.addToRender(["drawShape","rectangle",G+H-(x/2),A+(s/2),-x,s,O[I],this.objectBorderColor?this.objectBorderColor:this.foreground,B[I]],Q[I],F)}else{if(P){var E=J(P[I],G+H-x,A,-x,s);this.drawTreemap(E,0,0)}else{this.addToRender(["drawShape","rectangle",G+H-(x/2),A+(s/2),-x,s,O[I],this.objectBorderColor?this.objectBorderColor:this.foreground,B[I]],Q[I],F,null,false,L)}}G-=x}else{if(this.graphType=="Network"){this.addToRender(["drawShape","rectangle",G+(x/2),A+(s/2),-x,s,O[I],this.objectBorderColor?this.objectBorderColor:this.foreground,B[I]],Q[I],F)}else{if(P){var M=J(P[I],G,A,-x,s);this.drawTreemap(M,0,0)}else{this.addToRender(["drawShape","rectangle",G+(x/2),A+(s/2),-x,s,O[I],this.objectBorderColor?this.objectBorderColor:this.foreground,B[I]],Q[I],F,null,false,L)}}G+=x}}}}};this.drawAreaPlot=function(ah,Z,S,Q,ad,T,af,V,J,D,m,X,ae,aj,W,al,ak,M,G){this.functionCaller="drawAreaPlot";var Y=ah.length-1;var aa=ae&&this.lineType=="rect"?"path":this.lineType=="rect"?"polygon":"spline";var A=[];var B=[];var U=[];var am=-D*J;var C=m*J;var L=function(b,a){for(var c=a+1;c<ah[b].length;c++){if(ah[b][c]>0){return 1}else{if(ah[b][c]<0){return -1}}}return 0};if(X=="vertical"){for(var ac=0;ac<ah[0].length;ac++){A[ac]=af=="stacked"&&D<0?S-C:S;B[ac]=S-C}for(var ac=0;ac<ah.length;ac++){var ag=Z;var P=ae?[]:[Z];var N=ae?[]:[S-am];var H=0;var ai,K;for(var ab=0;ab<ah[0].length;ab++){if(isNaN(ah[ac][ab])){if(!ae){P.push(ag-T);N.push(S-am)}if(ae&&this.lineType=="spline"){this.addToRender(["drawLine",aa,P,N,false,false,aj[ac],this.lineThickness],al[ac],ak,null,false,S-am)}else{if(D>=0&&Y>0&&af!="normal"){var E=U[U.length-1][1];P.shift();var F=[];var an=[];for(var ac=1;ac<N.length;ac++){F.push([P[ac-1],P[ac-1]]);an.push([N[ac],E[ac]])}this.addToRender(["drawShape","confidence",F,an,this.width,this.height,aj[Y],this.objectBorderColor?this.objectBorderColor:aj[Y],W[Y]],al[Y],ak,null,false,S-am)}else{this.addToRender(["drawShape",aa,P,N,this.width,this.height,aj[ac],this.objectBorderColor?this.objectBorderColor:aj[ac],W[ac]],al[ac],ak,null,false,S-am)}}if(G){var u=this.addColorTransparency(aj[ac],0);for(var I=0;I<P.length;I++){ai=this.addToRender(["drawShape","sphere",P[I],N[I],T,T,u,"rgba(0,0,0,0)",W[ac]],[al[ac][0],G[I]],false,null,true);if(!ae){this.addToRender(["drawLine","line",P[I],N[I]+T,P[I],N[0],u,T],[al[ac][0],G[I]],false,ai,true)}}}P=ae?[]:[ag+T];N=ae?[]:[S-am]}else{var R=af=="percent"?((ah[ac][ab]-D)*100/V[ab])*J:(ah[ac][ab]-(af=="stacked"&&D<0?0:D))*J;P.push(ag);if(af&&(af=="stacked"||af=="percent")){if(ah[ac][ab]>0||H>0){N.push(A[ab]-R);A[ab]-=R;H=1}else{if(ah[ac][ab]<0||H<0){N.push(B[ab]-R);B[ab]-=R;H=-1}else{var O=L(ac,ab);if(O<0){N.push(B[ab]-R);B[ab]-=R;H=-1}else{if(O>0){N.push(A[ab]-R);A[ab]-=R;H=1}else{N.push(am)}}}}}else{N.push(S-R)}}ag+=T}if(!ae){P.push(Z+Q);N.push(S-am)}U.push([P,N,aj[ac],W[ac],al[ac]])}}else{for(var ac=0;ac<ah[0].length;ac++){A[ac]=M?Z+M:af=="stacked"&&D<0?Z+C:Z;B[ac]=Z+C}for(var ac=0;ac<ah.length;ac++){var ag=S;var P=ae?[]:M?[Z+M]:[Z+am];var N=ae?[]:[S];var H=0;var ai,K;for(var ab=0;ab<ah[0].length;ab++){if(isNaN(ah[ac][ab])){if(!ae){P.push(M?Z+M:Z+am);N.push(ag-T)}if(ae&&this.lineType=="spline"){this.addToRender(["drawLine",aa,P,N,false,false,aj[ac],this.lineThickness],al[ac],ak,null,false,Z+am)}else{var E=U[U.length-1][0];if(D>=0&&Y>0&&af!="normal"){N.shift();var F=[];var an=[];for(var ac=1;ac<P.length;ac++){F.push([P[ac],E[ac]]);an.push([N[ac-1],N[ac-1]])}this.addToRender(["drawShape","confidence",F,an,this.width,this.height,aj[Y],this.objectBorderColor?this.objectBorderColor:aj[Y],W[Y]],al[Y],ak,null,false,Z+am)}else{this.addToRender(["drawShape",aa,P,N,this.width,this.height,aj[ac],this.objectBorderColor?this.objectBorderColor:aj[ac],W[ac]],al[ac],ak,null,false,Z+am)}}if(G){var u=this.addColorTransparency(aj[ac],0);for(var I=0;I<P.length;I++){ai=this.addToRender(["drawShape","sphere",P[I],N[I],T,T,u,"rgba(0,0,0,0)",W[ac]],[al[ac][0],G[I]],false,null,true);if(!ae){this.addToRender(["drawLine","line",P[I]-T,N[I],P[0],N[I],u,T],[al[ac][0],G[I]],false,ai,true)}}}P=ae?[]:[M?Z+M:Z+am];N=ae?[]:[ag+T]}else{var R=af=="percent"?((ah[ac][ab]-D)*100/V[ab])*J:(ah[ac][ab]-(af=="stacked"&&D<0?0:D))*J;N.push(ag);if(af&&(af=="stacked"||af=="percent")){if(M){P.push(A[ab]-R);A[ab]-=R}else{if(ah[ac][ab]>0||H>0){P.push(A[ab]+R);A[ab]+=R;H=1}else{if(ah[ac][ab]<0||H<0){P.push(B[ab]+R);B[ab]+=R;H=-1}else{var O=L(ac,ab);if(O<0){P.push(B[ab]+R);B[ab]+=R;H=-1}else{if(O>0){P.push(A[ab]+R);A[ab]+=R;H=1}else{N.push(am)}}}}}}else{P.push(M?Z+M-R:Z+R)}}ag+=T}if(!ae){P.push(M?Z+M:Z+am);N.push(S+ad)}U.push([P,N,aj[ac],W[ac],al[ac]])}}while(Y>=0){var ai,K;var ab=U.pop();if(ae){if(this.lineType=="spline"){this.addToRender(["drawLine",aa,ab[0],ab[1],false,false,ab[2],this.lineThickness],ab[4],ak,null,false,X=="vertical"?S-am:Z+am)}else{var K=null;for(var ac=1;ac<ab[0].length;ac++){var ai=this.addToRender(["drawLine",aa,ab[0][ac-1],ab[1][ac-1],ab[0][ac],ab[1][ac],ab[2],this.lineThickness],ab[4],ak,K,false,X=="vertical"?S-am:Z+am);if(K==null){K=ai}}}}else{if(D>=0&&Y>0&&af!="normal"){var E=X=="vertical"?U[U.length-1][1]:U[U.length-1][0];if(X=="vertical"){ab[0].shift();ab[0].pop();var F=[];var an=[];for(var ac=1;ac<ab[1].length-1;ac++){F.push([ab[0][ac-1],ab[0][ac-1]]);an.push([ab[1][ac],E[ac]])}ab[1].shift();ab[1].pop();this.addToRender(["drawShape","confidence",F,an,this.width,this.height,ab[2],this.objectBorderColor?this.objectBorderColor:ab[2],ab[3]],ab[4],ak,null,false,S-am)}else{ab[1].shift();ab[1].pop();var F=[];var an=[];for(var ac=1;ac<ab[0].length-1;ac++){F.push([ab[0][ac],E[ac]]);an.push([ab[1][ac-1],ab[1][ac-1]])}ab[0].shift();ab[0].pop();this.addToRender(["drawShape","confidence",F,an,this.width,this.height,ab[2],this.objectBorderColor?this.objectBorderColor:ab[2],ab[3]],ab[4],ak,null,false,Z+am)}}else{if(af=="normal"||af=="stacked"){this.addToRender(["drawShape",aa,ab[0],ab[1],this.width,this.height,ab[2],this.objectBorderColor?this.objectBorderColor:ab[2],ab[3]],ab[4],ak,null,false,X=="vertical"?S-am:Z+am)}else{if(X=="vertical"){var an=[];for(var ac=1;ac<ab[1].length-1;ac++){an.push([ab[1][ac],ab[1][0]])}this.addToRender(["drawShape","confidence",F,an,this.width,this.height,ab[2],this.objectBorderColor?this.objectBorderColor:ab[2],ab[3]],ab[4],ak,null,false,S-am)}else{var F=[];for(var ac=1;ac<ab[0].length-1;ac++){F.push([ab[0][ac],ab[0][0]])}this.addToRender(["drawShape","confidence",F,an,this.width,this.height,ab[2],this.objectBorderColor?this.objectBorderColor:ab[2],ab[3]],ab[4],ak,null,false,Z+am)}}}}if(G){var u=this.addColorTransparency(ab[2],0);var g=Math.min(10,T);for(var ac=1;ac<ab[0].length-1;ac++){ai=this.addToRender(["drawShape","sphere",ab[0][ac],ab[1][ac],g,g,u,"rgba(0,0,0,0)",ab[3]],[ab[4][0],G[ac-1]],false,null,true);if(!ae){if(X=="vertical"){this.addToRender(["drawLine","line",ab[0][ac],ab[1][ac]+T,ab[0][ac],ab[1][0],u,T],[ab[4][0],G[ac-1]],false,ai,true)}else{this.addToRender(["drawLine","line",ab[0][ac]-T,ab[1][ac],ab[0][0],ab[1][ac],u,T],[ab[4][0],G[ac-1]],false,ai,true)}}}}Y--}};this.drawBoxPlot=function(al,ab,U,R,X,T,aa,Z,am,Y,ap,ah,Q){this.functionCaller="drawBoxPlot";var O=this;var B=function(d){var c;if(O.layoutValid){if(O.segregateVariablesBy.length>0){c=d}else{if(O.segregateSamplesBy.length>0){var a=O.data.w.labs[d]||O.data.w.glab[d];for(var b=0;b<n.g[C].length;b++){if(n.g[C][b].density.name==a){c=b;break}}}}}else{c=O.grpIndices[d]}return n.g[C][c]};var P=function(a){return Z=="vertical"?U-((a-aa)*T):ab+((a-aa)*T)};var n=this.meta.data.d;var C=this.getVariableIndices(Q);var ao=this.foreground;var V=this.variableSpaceFactor/2;var af=R/2;var F=af/2;var D=F/2;var aj=R/this.boxplotOutliersRatio;var E={};var N={};var H=false;var M=this.isGroupedData&&this.showViolinBoxplot&&this.isRawData?(R-this.variableSpaceFactor)*this.boxplotWidthRatioIfViolin:R-this.variableSpaceFactor;var L=this.isGroupedData&&this.showViolinBoxplot&&this.isRawData?R*this.boxplotWidthRatioIfViolin:0;var K=this.isGroupedData&&this.showViolinBoxplot&&this.isRawData?L/2:af;var e=Math.max(1,R/4);if(Z=="vertical"){for(var ae=0;ae<al.length;ae++){if(this.isGroupedData&&this.showViolinBoxplot&&this.isRawData&&al[ae].length>1){this.drawViolin(B(ae),ab+(R/2),U,R/this.varIndices.length,T,aa,Z,ah[ae],"closed",ap[ae]);if(!this.showBoxplotIfViolin){H=true}}var W=ab+af;var S=[];var A=[];var I=this.showBoxplotOriginalData||this.showViolinBoxplot?ah[ae]:am[ae];for(var ad=0;ad<5;ad++){S.push(P(al[ae][ad]));A.push(S[S.length-1].toString())}if(!H){var J=(ab+V)+((R-this.variableSpaceFactor)/2);var ai=S[3]+((S[2]-S[3])/2);var ag=M;var an=S[2]-S[3];var k=this.boxplotNotched?P(al[ae][7][0]):false;var ac=this.boxplotNotched?P(al[ae][7][1]):false;var ak,G,x;if(this.boxplotNotched){if(this.showViolinBoxplot){G=[ab+(R-V-L)-e,ab+V+L,ab+V+L,ab+(R-V-L),ab+(R-V-L),ab+V+L+e,ab+(R-V-L)-e]}else{G=[ab+V+L+e,ab+V+L,ab+V+L,ab+(R-V-L),ab+(R-V-L),ab+(R-V-L)-e,ab+V+L+e]}x=[S[4],k,S[2],S[2],k,S[4],S[4]];ak=this.addToRender(["drawShape","polygon",G,x,false,false,am[ae],this.objectBorderColor?this.objectBorderColor:am[ae],Y[ae]],ap[ae],false,null,false,U);x=[S[4],ac,S[3],S[3],ac,S[4],S[4]];this.addToRender(["drawShape","polygon",G,x,false,false,am[ae],this.objectBorderColor?this.objectBorderColor:am[ae],Y[ae]],ap[ae],false,ak,false,U)}else{ak=this.addToRender(["drawShape","rectangle",J,ai,ag,an,am[ae],this.objectBorderColor?this.objectBorderColor:am[ae],Y[ae]],ap[ae],false,null,false,U)}if(this.unique(A).length!=1){if(this.boxplotNotched){this.addToRender(["drawLine","median",ab+V+L+e,S[4],ab+(R-V-L)-e,S[4],this.boxplotMedianColor,this.boxplotMedianWidth,"butt"],ap[ae],false,ak)}else{this.addToRender(["drawLine","median",ab+V+L,S[4],ab+(R-V-L),S[4],this.boxplotMedianColor,this.boxplotMedianWidth,"butt"],ap[ae],false,ak)}if(this.boxplotWishkersType=="single"){this.addToRender(["drawLine","line",W,S[2],W,S[0],ao,false,"butt"],ap[ae],false,ak);this.addToRender(["drawLine","line",W,S[3],W,S[1],ao,false,"butt"],ap[ae],false,ak)}else{this.addToRender(["drawLine","error",W,S[2],W,S[0],ao,-K,"butt"],ap[ae],false,ak);this.addToRender(["drawLine","error",W,S[3],W,S[1],ao,-K,"butt"],ap[ae],false,ak)}}if(this.boxplotMean){this.addToRender(["drawShape","rectangle",W,P(al[ae][6]),F,F,this.boxplotMeanColor,this.boxplotMeanColorBorder],ap[ae],false,ak,false,U)}if(al[ae][5]){for(var ad=0;ad<al[ae][5].length;ad++){this.addToRender(["drawShape","sphere",W,P(al[ae][5][ad]),aj,aj,am[ae],ao,Y[ae]],ap[ae],false,ak,false,U)}}}if(!E.hasOwnProperty(I)){E[I]=[];N[I]=this.cloneObject(ap[ae])}E[I].push([ab+V+(R/2),S[4]]);ab+=X}}else{for(var ae=0;ae<al.length;ae++){if(this.isGroupedData&&this.showViolinBoxplot&&this.isRawData&&al[ae].length>1){this.drawViolin(B(ae),ab,U+(R/2),R/this.varIndices.length,T,aa,Z,ah[ae],"closed",ap[ae]);if(!this.showBoxplotIfViolin){H=true}}var W=U+af;var S=[];var A=[];var I=this.showBoxplotOriginalData||this.showViolinBoxplot?ah[ae]:am[ae];for(var ad=0;ad<5;ad++){S.push(P(al[ae][ad]));A.push(S[S.length-1].toString())}if(!H){var J=S[2]+((S[3]-S[2])/2);var ai=(U+V)+((R-this.variableSpaceFactor)/2);var ag=S[3]-S[2];var an=M;var k=this.boxplotNotched?P(al[ae][7][0]):false;var ac=this.boxplotNotched?P(al[ae][7][1]):false;var ak,G,x;if(this.boxplotNotched){G=[S[4],k,S[2],S[2],k,S[4],S[4]];if(this.showViolinBoxplot){x=[U+(R-V-L)-e,U+V+L,U+V+L,U+(R-V-L),U+(R-V-L),U+V+L+e,U+(R-V-L)-e]}else{x=[U+V+L+e,U+V+L,U+V+L,U+(R-V-L),U+(R-V-L),U+(R-V-L)-e,U+V+L+e]}ak=this.addToRender(["drawShape","polygon",G,x,false,false,am[ae],this.objectBorderColor?this.objectBorderColor:am[ae],Y[ae]],ap[ae],false,null,false,U);G=[S[4],ac,S[3],S[3],ac,S[4],S[4]];this.addToRender(["drawShape","polygon",G,x,false,false,am[ae],this.objectBorderColor?this.objectBorderColor:am[ae],Y[ae]],ap[ae],false,ak,false,U)}else{ak=this.addToRender(["drawShape","rectangle",J,ai,ag,an,am[ae],this.objectBorderColor?this.objectBorderColor:am[ae],Y[ae]],ap[ae],false,null,false,ab)}if(this.unique(A).length!=1){if(this.boxplotNotched){this.addToRender(["drawLine","median",S[4],U+V+L+e,S[4],U+(R-V-L)-e,this.boxplotMedianColor,this.boxplotMedianWidth,"butt"],ap[ae],false,ak)}else{this.addToRender(["drawLine","median",S[4],U+V+L,S[4],U+(R-V-L),this.boxplotMedianColor,this.boxplotMedianWidth,"butt"],ap[ae],false,ak)}if(this.boxplotWishkersType=="single"){this.addToRender(["drawLine","line",S[2],W,S[0],W,ao,false,"butt"],ap[ae],false,ak);this.addToRender(["drawLine","line",S[3],W,S[1],W,ao,false,"butt"],ap[ae],false,ak)}else{this.addToRender(["drawLine","error",S[2],W,S[0],W,ao,K,"butt"],ap[ae],false,ak);this.addToRender(["drawLine","error",S[3],W,S[1],W,ao,K,"butt"],ap[ae],false,ak)}}if(this.boxplotMean){this.addToRender(["drawShape","rectangle",P(al[ae][6]),W,F,F,this.boxplotMeanColor,this.boxplotMeanColorBorder],ap[ae],false,ak,false,ab)}if(al[ae][5]){for(var ad=0;ad<al[ae][5].length;ad++){this.addToRender(["drawShape","sphere",P(al[ae][5][ad]),W,aj,aj,am[ae],ao,Y[ae]],ap[ae],false,ak,false,ab)}}}if(!E.hasOwnProperty(I)){E[I]=[];N[I]=this.cloneObject(ap[ae])}E[I].push([S[4],U+V+(R/2)]);U+=X}}if(this.boxplotConnect){for(var I in E){if(E[I].length>1){var ak=this.addToRender(["drawLine","line",E[I][0][0],E[I][0][1],E[I][1][0],E[I][1][1],I,this.boxplotConnectWidth,"butt"],["Line:",N[I][0],N[I][1]],false);for(var ae=1;ae<E[I].length-1;ae++){this.addToRender(["drawLine","line",E[I][ae][0],E[I][ae][1],E[I][ae+1][0],E[I][ae+1][1],I,this.boxplotConnectWidth,"butt"],["Line:",N[I][0],N[I][1]],false,ak)}}}}};this.drawCandlestickPlot=function(L,G,A,n,K,s,F,D,E,M,O){this.functionCaller="drawCandlestickPlot";var e=function(a){return E=="vertical"?A-((a-F)*s):G+((a-F)*s)};var N=this.foreground;var J=n/2;if(E=="vertical"){for(var I=0;I<L.length;I++){var C=G+J;var q=[];for(var H=0;H<L[I].length;H++){q.push(e(L[I][H]))}if(D){if(q[0]>q[1]){var k=G+(n/2);var f=q[1]+((q[0]-q[1])/2);var B=this.addToRender(["drawShape","rectangle",k,f,n,q[0]-q[1],false,M,"open"],O[I]);this.addToRender(["drawLine","line",C,q[1],C,q[2],M,false,"butt"],false,false,B,false,A);this.addToRender(["drawLine","line",C,q[3],C,q[0],M,false,"butt"],false,false,B,false,A)}else{var k=G+(n/2);var f=q[0]+((q[1]-q[0])/2);var B=this.addToRender(["drawShape","rectangle",k,f,n,q[1]-q[0],M,M,"closed"],O[I]);this.addToRender(["drawLine","line",C,q[3],C,q[1],M,false,"butt"],false,false,B,false,A);this.addToRender(["drawLine","line",C,q[0],C,q[2],M,false,"butt"],false,false,B,false,A)}}else{this.addToRender(["drawShape","rectangle",G+(n/2),q[0]+((A-q[0])/2),n,A-q[0],M,M,"closed"],O[I])}G+=K}}else{for(var I=0;I<L.length;I++){var C=A+J;var q=[];for(var H=0;H<L[I].length;H++){q.push(e(L[I][H]))}if(D){if(q[1]>q[0]){var k=q[0]+((q[1]-q[0])/2);var f=A+(n/2);var B=this.addToRender(["drawShape","rectangle",k,f,q[1]-q[0],n,false,M,"open"],O[I]);this.addToRender(["drawLine","line",q[1],C,q[2],C,M,false,"butt"],false,false,B,false,G);this.addToRender(["drawLine","line",q[3],C,q[0],C,M,false,"butt"],false,false,B,false,G)}else{var k=q[1]+((q[0]-q[1])/2);var f=A+(n/2);var B=this.addToRender(["drawShape","rectangle",k,f,q[0]-q[1],n,M,M,"closed"],O[I]);this.addToRender(["drawLine","line",q[3],C,q[1],C,M,false,"butt"],false,false,B,false,G);this.addToRender(["drawLine","line",q[0],C,q[2],C,M,false,"butt"],false,false,B,false,G)}}else{this.addToRender(["drawShape","rectangle",G+((q[0]-G)/2),A+(n/2),q[0]-G,n,M,M,"closed"],O[I])}A+=K}}};this.drawViolin=function(j,C,n,G,k,B,z,H,w,s){this.functionCaller="drawViolin";var e=[];var E=[];var b=[];var A=[];var a=[[],[]];var D,d,g,f;switch(this.violinScale){case"area":D=G/j.density.maxY*j.density.maxY/j.scale*0.9;break;case"count":D=G/j.density.maxY*j.density.sumY/j.area*0.9;break;case"width":D=G/j.density.maxY*0.9;break}var r=this.addColorTransparency(H,0.25);if(this.violinTrim){d=[];for(var F=j.density.trim[0];F<j.density.trim[1];F++){d.push(j.density.xy[F])}}else{d=j.density.xy}if(z=="vertical"){for(var F=0;F<d.length;F++){g=(d[F][1]*D);f=((d[F][0]-B)*k);e.push(C-g);E.push(n-f);b.push(C+g);A.push(n-f);a[0].push(C);a[1].push(n-f)}}else{for(var F=0;F<d.length;F++){g=((d[F][0]-B)*k);f=(d[F][1]*D);e.push(C+g);E.push(n-f);b.push(C+g);A.push(n+f);a[0].push(C+g);a[1].push(n)}}if(e.length>1&&E.length>1){this.addToRender(["drawShape","violin",[e,b],[E,A],false,false,r,this.foreground,w],s,false,null,false,a)}};this.drawDotPlot=function(ah,ag,Y,Q,ac,T,P,X,R,V,aj,Z,U,am,N,S,M,I,H){this.functionCaller="drawDotPlot";var L=this;var f=function(){var e=L.jitterColumns%2?L.jitterColumns+2:L.jitterColumns+3;var b=Math.max(ac-L.sizes[0],L.sizes[0])/(e-1);var a=[0];var c=1;for(var d=0;d<e/2;d+=2){a.push(c*-b);a.push(c*b);c++}return a};var G=function(d,a){var e=a[0];var c={n:{},arr:{}};for(var b=0;b<d.length;b++){var j=d[b].toString();if(!c.n.hasOwnProperty(j)){c.n[j]=0;c.arr[j]=[]}c.n[j]++}for(var j in c.n){switch(L.binAlignment){case"bottom":case"right":c.arr[j].push(0);c.n[j]--;while(c.n[j]>0){var h=c.arr[j][0];c.arr[j].unshift(h-e);c.n[j]--}break;case"top":case"left":c.arr[j].push(0);c.n[j]--;while(c.n[j]>0){var h=c.arr[j][c.arr[j].length-1];c.arr[j].push(h+e);c.n[j]--}break;case"center":if(c.n[j]%2){c.arr[j].push(0);c.n[j]--}else{c.arr[j].push(-e/2);c.n[j]--;c.arr[j].push(e/2);c.n[j]--}while(c.n[j]>0){var h=c.arr[j][0];c.arr[j].unshift(h-e);c.n[j]--;h=c.arr[j][c.arr[j].length-1];c.arr[j].push(h+e);c.n[j]--}break}}return c.arr};var C=[];var E=f();var ak=this.getOutlineColor();if(V=="vertical"){for(var ab=0;ab<ah.length;ab++){if((this.showBoxplotOriginalData&&this.isRawData)||this.graphType.match(/Dot/)||(this.graphType.match(/Bar/)&&this.barType=="lollipop"&&!this.isGroupedData)){var al=this.binned?G(ah[ab],R[ab]):false;for(var aa=0;aa<ah[ab].length;aa++){var W=this.binned?al[ah[ab][aa].toString()].shift():this.jitter?E[aa%E.length]:0;var x=am?am[ab][aa]:false;var O=Q-((ah[ab][aa]-X)*P);if(!isNaN(O)){var ai=this.addToRender(["drawShape",U[ab][aa],Y+W,O,R[ab][aa],R[ab][aa],aj[ab][aa],ak||aj[ab][aa],Z[ab][aa],false,false,S],x,N,null,false,Q);C.push([Y+W,O,R[ab][aa]/2,x]);if(!this.isGroupedData){if(ag[ab]&&ag[ab][aa]&&!isNaN(ag[ab][aa])){var an=(ag[ab][aa]/2)*P;this.addToRender(["drawLine","error",Y+W,O,Y+W,O+an,aj[ab][aa],-ac,"butt",false,false,true],x,false,ai);this.addToRender(["drawLine","error",Y+W,O,Y+W,O-an,aj[ab][aa],-ac,"butt",false,false,true],x,false,ai)}}}else{C.push([Y+W,Number.NaN,R[ab][aa]/2,x])}}if(this.showErrorBars&&this.isGroupedData&&ag[ab]&&ag[ab]&&!isNaN(ag[ab][0])&&!isNaN(ag[ab][1])){var O=Q-((ag[ab][0]-X)*P);var an=(ag[ab][1]/2)*P;var x=am?[am[ab][0][0],am[ab][0][1],"error"]:false;this.addToRender(["drawShape","diamond",Y,O,this.margin*this.errorBarsThickness,this.margin*this.errorBarsThickness,this.errorBarsColor,this.errorBarsColor,"closed",false,false,S],false,false,null,false,false,x);this.addToRender(["drawLine","line",Y,O-an,Y,O+an,this.errorBarsColor,this.errorBarsThickness,"butt",false,false,S],false,false,null,false,false,x)}}Y+=T}}else{for(var ab=0;ab<ah.length;ab++){if((this.showBoxplotOriginalData&&this.isRawData)||this.graphType.match(/Dot/)||(this.graphType.match(/Bar/)&&this.barType=="lollipop"&&!this.isGroupedData)){var al=this.binned?G(ah[ab],R[ab]):false;for(var aa=0;aa<ah[ab].length;aa++){var W=this.binned?al[ah[ab][aa].toString()].shift():this.jitter?E[aa%E.length]:0;var x=am?am[ab][aa]:false;var O=M?Y+M-((ah[ab][aa]-X)*P):Y+((ah[ab][aa]-X)*P);if(!isNaN(O)){var ai=this.addToRender(["drawShape",U[ab][aa],O,Q+W,R[ab][aa],R[ab][aa],aj[ab][aa],ak||aj[ab][aa],Z[ab][aa],false,false,S],x,N,null,false,Y);C.push([O,Q+W,R[ab][aa]/2,x]);if(!this.isGroupedData){if(ag[ab]&&ag[ab][aa]&&!isNaN(ag[ab][aa])){var an=(ag[ab][aa]/2)*P;this.addToRender(["drawLine","error",O,Q+W,O+an,Q+W,aj[ab][aa],ac,"butt",false,false,true],x,false,ai);this.addToRender(["drawLine","error",O,Q+W,O-an,Q+W,aj[ab][aa],ac,"butt",false,false,true],x,false,ai)}}}else{C.push([Number.NaN,Q+W,R[ab][aa]/2,x])}}}if(this.showErrorBars&&this.isGroupedData&&ag[ab]&&ag[ab]&&!isNaN(ag[ab][0])&&!isNaN(ag[ab][1])){var O=Y+((ag[ab][0]-X)*P);var an=(ag[ab][1]/2)*P;var x=am?[am[ab][0][0],am[ab][0][1],"error"]:false;this.addToRender(["drawShape","diamond",O,Q,this.margin*this.errorBarsThickness,this.margin*this.errorBarsThickness,this.errorBarsColor,this.errorBarsColor,"closed",false,false,S],false,false,null,false,false,x);this.addToRender(["drawLine","line",O-an,Q,O+an,Q,this.errorBarsColor,this.errorBarsThickness,"butt",false,false,S],false,false,null,false,false,x)}Q+=T}}if(this.connectBy&&this.data.x&&this.data.x.hasOwnProperty(this.connectBy)&&this.isRawData){var z=this.connectBy==this.colorBy?this.meta.data.x[this.colorBy]:false;var F=0;var ad=this.getKeys(this.connectByData);var g=this.getCustomColorScheme(ad.length);for(var ab in this.connectByData){var ai;var K=null;var ah=this.connectByData[ab];var J=z&&z.type!="Numeric"?z.colors[z.order[ab]%z.colors.length]:g[F%g.length];if(ah.length>1){for(var aa=1;aa<ah.length;aa++){var O=C[ah[aa-1]];var an=C[ah[aa]];ai=this.addToRender(["drawLine","line",O[0],O[1],an[0],an[1],J,this.connectByWidth,"butt",O[2],an[2],S],["Line:"+this.connectBy+" "+ab,O[3][0],O[3][2],an[3][2]],false,K);if(K==null){K=ai}}}F++}}else{if(this.connectBy&&this.data.z&&this.data.z.hasOwnProperty(this.connectBy)&&this.isRawData){this.connectByDataVar.push(C);if(H){var z=this.connectBy==this.colorBy?this.meta.data.z[this.colorBy]:false;for(var ab in this.connectByData){var ah=this.connectByData[ab];if(ah.length>1){for(var Z=0;Z<this.connectByDataVar[0].length;Z++){for(var aa=1;aa<ah.length;aa++){var O=this.connectByDataVar[ah[aa-1]][Z];var an=this.connectByDataVar[ah[aa]][Z];var af=ab;if(O&&an){var D=this.data.y.vars[O[3][0]];var ae=this.data.y.vars[an[3][0]];var B=this.data.y.smps[O[3][(this.isGroupedData?2:1)]];var A=this.data.y.smps[an[3][(this.isGroupedData?2:1)]];if(B==A){af=D+" - "+ae+" ("+B+")"}else{af=D+" ("+B+") - "+ae+" ("+A+")"}}this.addToRender(["drawLine","line",O[0],O[1],an[0],an[1],this.connectByColor,this.connectByWidth,"butt",O[2],an[2],S],["Line:"+this.connectBy+" "+af])}}}}}}}};this.drawHeatmap=function(H,C,s,j,E,G,K,F,z,J,y){this.functionCaller="drawHeatmap";var n=0;var g=C;var x=0.5;var B=this.meta.vals;if(!B.colors){B.colors={}}for(var D=0;D<H.length;D++){var k=H[D];var I=k==null||isNaN(k)?this.missingDataColor:B.colors[k.toString()]?B.colors[k.toString()]:this.getColorForValue(J,k);var A=G?I:this.heatmapCellBoxColor;B.colors[k==null?"null":k.toString()]=I;if(y){I=this.addColorTransparency(I,y)}if(this.graphType=="Network"){if(this.shapeByShape){this.addToRender(["drawShape",this.shapeByShape,C+(j/2),s+(E/2),j/2,E/2,I,A,z[D]],K[D],F)}else{this.addToRender(["drawShape","rectangle",C+(j/2),s+(E/2),j,E,I,I,z[D]],K[D],F)}}else{if(this.shapeByShape){this.addToRender(["drawShape",this.shapeByShape,C+(j/2),s+(E/2),j/2,E/2,I,A,z?z[D]:false],K[D],F)}else{if(D>0&&D<H.length-1){if(n>=0.5){this.addToRender(["drawShape","rect",C+((j+x)/2),s+((E+x)/2),j+x,E+x,I,I,z?z[D]:false],K[D],F,null,false,[g,s+((E+x)/2),0,E+x]);n=0}}else{this.addToRender(["drawShape","rect",C+((j+x)/2),s+((E+x)/2),j+x,E+x,I,I,z?z[D]:false],K[D],F,null,false,[g,s+((E+x)/2),0,E+x])}}}if(this.showDataValues){this.addToRender(["drawText",this.approx(k),(C+j)-2,(s+E)-2,this.overlayFont,this.foreground,"right","bottom"])}C+=j;n+=j}};this.drawTreemap=function(B,u,p,C,D){this.functionCaller="drawTreemap";var f=this;var r=this.graphOrientation=="vertical"?this.top+this.y:this.left;var k=function(d,c){f.functionCaller="drawTreemap";if(c){f.addToRender(["drawShape","rectangle",(d.coords.left+u)+(d.coords.width/2),(d.coords.top+p)+(d.coords.height/2),d.coords.width,d.coords.height,false,f.objectBorderColor?f.objectBorderColor:false,"open",false,d.outline,C,D],false,false,null,false,r)}else{f.addToRender(["drawShape","rectangle",(d.coords.left+u)+(d.coords.width/2),(d.coords.top+p)+(d.coords.height/2),d.coords.width,d.coords.height,d.color,f.objectBorderColor?f.objectBorderColor:false,"closed",false,false,C,D],d.index,false,null,false,r)}if(d.label){var b=f.measureText(d.label,f.overlayFont);if(b+f.margin<d.coords.width&&f.overlayFontSize+f.margin<d.coords.height){if(c){f.addToRender(["drawText",d.label,d.coords.left+u+(d.coords.width/2),d.coords.top+p+(d.coords.height/2),f.overlayFont,f.addColorTransparency(f.foreground,0.5),"center","middle"])}else{f.addToRender(["drawText",d.label,d.coords.left+u+f.margin,d.coords.top+p+f.margin,f.overlayFont,f.foreground,"left","top"])}}else{if(b+f.margin<d.coords.height&&f.overlayFontSize+f.margin<d.coords.width){if(c){f.addToRender(["drawText",d.label,d.coords.left+u+(d.coords.width/2),d.coords.top+p+(d.coords.height/2),f.overlayFont,f.addColorTransparency(f.foreground,0.5),"center","middle",-Math.PI/2])}else{f.addToRender(["drawText",d.label,d.coords.left+u+f.margin,d.coords.top+p+f.margin,f.overlayFont,f.foreground,"right","top",-Math.PI/2])}}}}};var s=function(c){for(var b=0;b<c.length;b++){if(c[b].children){s(c[b].children);k(c[b],true)}else{k(c[b])}}};for(var v=0;v<B.length;v++){var a=B[v];var q=this.treemapBorderWidth?1:0;var E=this.treemapBorderWidth;var o=E*2;var e=this.smpLabelFontSize*q;var g=this.treemapBorderColor;var m=u+a.coords.left-E;var j=p+a.coords.top-(e+E);var n=a.coords.width+o;var A=a.coords.height+e+o;if(a.title){this.addToRender(["disableGradientTransparencyShadow"]);if(a.coords.border>1){this.addToRender(["drawShape","rectangle",m+(n/2),j+((e+(E/2))/2),n,e+(E/2),g,g,"close",false,E,C,D]);this.addToRender(["drawShape","rectangle",m+(n/2),j+(A/2),n,A,false,g,"open",false,E,C,D])}else{if(a.coords.border>0){this.addToRender(["drawShape","rectangle",m+(n/2),(j+(e+E))+((A-(e+E))/2),n,A-(e+E),false,g,"open",false,E,C,D])}else{if(a.coords.border>-1){this.addToRender(["drawShape","rectangle",m+(n/2),(j+(e+E))+((A-(e+E))/2),n,A-(e+E),false,g,"open",false,E,C,D])}}}var z=this.measureText(a.title,this.smpLabelFont);if(z+this.margin<n&&this.smpLabelFontSize<=e&&a.coords.height>e+(E/2)){this.addToRender(["drawText",a.title,m+this.margin,j+(this.smpLabelFontSize/2),this.smpLabelFont,this.foreground,"left","middle"])}this.addToRender(["enableGradientTransparencyShadow"])}if(a.children){s(a.children)}else{k(a)}}};this.drawSankey=function(b){this.functionCaller="drawSankey";var f=b.links[0].target.x-b.links[0].source.x;for(var a=0;a<b.links.length;a++){var c=b.links[a];this.addToRender(["drawShape","bezier",c.plotX,c.plotY,f,c.dy,c.color,c.color,false,c.colors],c.tooltip,false,null,false,[this.left,this.top+this.y/2,f,c.dy])}for(var a=0;a<b.nodes.length;a++){var e=b.nodes[a];this.addToRender(["drawShape","rectangle",e.plotX+(e.dx/2),e.plotY+(e.dy/2),e.dx,e.dy,e.color,this.foreground],e.tooltip,false,null,false,[this.left,this.top+this.y/2,e.dx,e.dy]);this.addToRender(["drawText",e.name,e.plotX+(e.dx/2),e.plotY+(e.dy/2),this.overlayFont,this.overlayFontColor,"center","middle",-Math.PI/2],[e.tooltip[0]+":T"])}};this.drawTree=function(a,f){this.functionCaller="drawTree";if(this.data.tree&&this.data.tree.plot){var k=this.data.tree.plot;var d=this.treeNodeSize/2;var h=this.treeNodeSize/4;var e=a=="vertical"?true:false;var g=this;var j=function(p){var l=e?p.x0:p.y0;var o=e?p.y0:p.x0;if(p.children){for(var m=0;m<p.children.length;m++){j(p.children[m])}if(e){if(p.parent){g.addToRender(["drawText",p.data.name,l,o-((g.treeNodeSize/2)+g.margin),g.smpLabelFont,g.smpLabelFontColor,"right","middle",Math.PI/2],["Tree-Text:"+p.id],false,null,false,[b,i])}else{g.addToRender(["drawText",p.data.name,l,o-((g.treeNodeSize/2)+g.margin),g.smpLabelFont,g.smpLabelFontColor,"center","bottom"],["Tree-Text:"+p.id],false,null,false,[b,i])}}else{g.addToRender(["drawText",p.data.name,l-((g.treeNodeSize/2)+g.margin),o,g.smpLabelFont,g.smpLabelFontColor,"right","middle"],["Tree-Text:"+p.id],false,null,false,[b,i])}}else{if(e){g.addToRender(["drawText",p.data.name,l,o+(g.treeNodeSize/2)+g.margin,g.smpLabelFont,g.smpLabelFontColor,"left","middle",Math.PI/2],["Tree-Text-:"+p.id],false,null,false,[b,i])}else{g.addToRender(["drawText",p.data.name,l+(g.treeNodeSize/2)+g.margin,o,g.smpLabelFont,g.smpLabelFontColor,"left","middle"],["Tree-Text:"+p.id],false,null,false,[b,i])}}g.addToRender(["drawShape",p.data.shape,l,o,p.data.size,p.data.size,p.data.color,g.treeLinkColor,p.data.pattern,false,g.treeLinkWidth],["Tree-Node:"+p.id],false,null,false,[b,i]);if(p._children){g.addToRender(["drawLine","line",l-h,o,l+h,o,g.foreground],["Tree-Line1:"+p.id],false,null,false,[b,i]);g.addToRender(["drawLine","line",l,o-h,l,o+h,g.foreground],["Tree-Line2:"+p.id],false,null,true,[b,i])}else{if(p.children){g.addToRender(["drawLine","line",l-h,o,l+h,o,g.foreground],["Tree-Line1:"+p.id],false,null,false,[b,i])}}};var c=function(s){if(s.children){for(var m=0;m<s.children.length;m++){c(s.children[m])}}if(s.parent){var l=e?s.x0:s.y0;var r=e?s.y0:s.x0;var o=e?s.parent.x0:s.parent.y0;var q=e?s.parent.y0:s.parent.x0;var p=s._clicked?[o,q,o,q]:[b,i,b,i];g.addToRender(["drawLine","bezier",o,q,l,r,g.treeLinkColor,g.treeLinkWidth,false],[s.parent.id+":"+s.id],false,null,false,p);s._clicked=false}};var b=e?k.x0:k.y0;var i=e?k.y0:k.x0;c(k);if(!f){j(k)}}};this.zoomOncoprintVariables=function(c){this.functionCaller="zoomOncoprintVariables";if(this.isTransition()){return}var b=[];this.setOriginalIndices(false,this.varIndices,this.smpIndices);this.varIndicesStart=0;for(var a=0;a<Math.min(c,this.varIndices.length);a++){b.push(this.varIndices[a])}this.varIndices=b;this.draw()};this.setFunctionNames("initConfigUtils")};CanvasXpress.prototype.init3dUtils=function(){this.setTrigonometry=function(){if(!this.meta.math){this.meta.math={sin:[0],cos:[1]};for(var b=1;b<=360;b++){var a=Math.PI/(180/b);this.meta.math.sin[b]=Math.sin(a);this.meta.math.cos[b]=Math.cos(a)}}};this.set3DRotation=function(){this.setTrigonometry();var a=["xRotate","yRotate","zRotate"];for(var b=0;b<a.length;b++){if(this[a[b]]>360){this[a[b]]-=360}if(this[a[b]]<0){this[a[b]]=360}}};this.set3DParams=function(){var b=this.zoom;var a=this.x;this.perspective=a*this.perspectiveFactor;this.lenX=a/4*b*this.x3DRatio;this.lenY=a/4*b*this.y3DRatio;this.lenZ=a/4*b*this.z3DRatio;this.padX=a/2;this.padY=this.y/2;this.padZ=this.padY};this.get3DTransfrom=function(g,a,k){var f,e,b;var h=[];var n=this.meta.math.sin;var j=this.meta.math.cos;var d=this.perspective;var m=this.xRotate;var l=this.yRotate;var i=this.zRotate;e=a;b=k;a=e*j[parseInt(l)]-b*n[parseInt(l)];k=e*n[parseInt(l)]+b*j[parseInt(l)];f=g;b=k;g=b*n[parseInt(m)]+f*j[parseInt(m)];k=b*j[parseInt(m)]-f*n[parseInt(m)];f=g;e=a;g=f*j[parseInt(i)]-e*n[parseInt(i)];a=f*n[parseInt(i)]+e*j[parseInt(i)];if(this.perspective){g=g*(d/(k+d));a=a*(d/(k+d));k=k*(d/(k+d))}h.push(g+this.padX);h.push(a+this.padY);h.push(k+this.padZ);return h};this.setFunctionNames("init3dUtils")};CanvasXpress.prototype.initApiUtils=function(){this.getValidGraphTypes=function(){return this.validGraphTypes};this.setHeatmapScheme=function(){this.initializeAttributes()};this.hasIndicator=function(){if(this.graphType.match(/Scatter/)||this.graphType=="Bar"){return true}else{return false}};this.hasLegend=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Correlation"&&this.graphType!="Heatmap"){return true}else{return false}};this.hasLegendProperties=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Correlation"&&this.graphType!="Heatmap"&&this.graphType!="Pie"){return true}else{return false}};this.hasData=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"){return true}else{return false}};this.hasDataSamples=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"&&this.graphType!="Pie"&&!this.graphType.match(/Scatter/)){if(this.graphType=="Correlation"&&this.correlationAxis!="samples"){return false}return true}else{return false}};this.hasDataGroups=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"&&this.graphType!="Pie"&&!this.graphType.match(/Scatter/)){if(this.graphType=="Correlation"&&this.correlationAxis!="samples"){return false}if(this.data.x){return true}else{return false}}else{return false}};this.hasDataVariables=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"){if(this.graphType=="Correlation"&&this.correlationAxis!="variables"){return false}return true}else{return false}};this.hasDataProperties=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Heatmap"&&this.graphType!="Venn"&&this.graphType!="Pie"&&this.graphType!="Correlation"){return true}else{return false}};this.hasOrientation=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"&&this.graphType!="Pie"&&this.graphType!="Correlation"&&this.graphType!="Circular"&&!this.graphType.match(/Scatter/)){return true}else{return false}};this.hasOverlays=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"&&this.graphType!="Pie"&&this.graphType!="Correlation"&&!this.graphType.match(/Scatter/)){return true}else{return false}};this.hasDendrograms=function(){if(this.graphType!="Heatmap"&&(this.smpDendrogramNewick||this.varDendrogramNewick)){return true}else{return false}};this.hasDecorations=function(){return this.decorations&&(this.decorations.nlfit||this.decorations.line||this.decorations.reg||this.decorations.nor||this.decorations.area)?true:false};this.isSegregable=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"&&this.graphType!="Pie"&&this.graphType!="Correlation"&&!this.graphType.match(/Scatter/)){return true}else{return false}};this.getLineTypes=function(){var e=["line"];var c=["","dashed","dotted","bezierY","bezierX","curved"];var a=["arrow","arrowHead","arrowTail","arrowHeadSquareTail","arrowTailSquareHead","square","squareHead","squareTail","squareHeadArrowTail","squareTailArrowHead"];for(var d=0;d<a.length;d++){e.push(a[d]+"Line")}for(var d=1;d<c.length;d++){for(var b=0;b<a.length;b++){e.push(c[d]+this.capitalize(a[b])+"Line")}}return e};this.isValidShape=function(c){var a=["circle","sphere","box","rect","rectangle","rect2","rect3","roundrect","brace","square","triangle","triangle2","equilateral","equilateral2","star","diamond","rhombus","pentagon","hexagon","octagon"];a=a.concat(["oval","oval2","oval3","arc","arc2","arc3","arch","path","polygon","spline","hull","violin","confidence","bezier","ellipse","ellipse2","ellipse2","plus","minus"]);a=a.concat(["pie","pie0","pie1","pie2","pie3","pie4","pie5","pie6","pie7","pie8","pie9","pacman","pacman2","mdavid","image"]);a=a.concat(["pch0","pch1","pch2","pch3","pch4","pch5","pch6","pch7","pch8","pch9","pch10","pch11","pch12","pch13","pch14","pch15","pch16","pch17","pch18","pch19","pch20","pch21","pch22","pch23","pch24","pch25"]);for(var b=0;b<a.length;b++){if(a[b]==c){return true}}return false};this.getHeatmapSchemes=function(){var c=[];var d=["blue","red","green","yellow","cyan","purple","white","black"];for(var b=0;b<d.length;b++){c.push(d[b]);for(var a=0;a<d.length;a++){if(d[b]!=d[a]){c.push(d[b]+"-"+d[a])}}}return c};this.isCompatibleGraphType=function(b,a){if(b.match(/^Bar$|^Line$|Boxplot|Dotplot/)){return a.match(/^Bar$|^Line$|Boxplot|Dotplot/)?true:false}else{return false}};this.isOneDimensionalGraph=function(){return !this.graphType.match(/Scatter|Network|Venn|Genome|Circular|Correlation/)};this.modifyHighlights=function(c,b,d){var a=d?"highlightVar":"highlightSmp";this.modifyObjectArray(c,b,a)};this.getHighlights=function(a){return this.getObjectArray(a?this.highlightVar:this.highlightSmp)};this.modifyOverlaysProperties=function(g){this.functionCaller="modifyOverlaysProperties";if(this.isTransition()){return}var e=[];if(!this.isArray(g)){for(var d=0;d<arguments.length;d++){e.push(this.cloneObject(arguments[d]))}}else{e=this.cloneObject(g)}var b;var c=this;var a=e.shift();var f=this.cloneObject(e);while(f.length>1){b=f.shift();if(!c[b]){c[b]={}}c=c[b]}b=f.shift();c[b]=b=="showLegend"?!c[b]:isNaN(a)?a:Number(a);this.draw()};this.modifySmpOverlays=function(b,a){this.modifyObjectArray(b,a,"smpOverlays")};this.modifyVarOverlays=function(b,a){this.modifyObjectArray(b,a,"varOverlays")};this.getSmpOverlays=function(){return this.getObjectArray(this.smpOverlays)};this.getVarOverlays=function(){return this.getObjectArray(this.varOverlays)};this.getXData=function(){var b=[];if(this.data.x){for(var a in this.data.x){b.push(a)}}return b};this.getZData=function(){var b=[];if(this.data.z){for(var a in this.data.z){b.push(a)}}return b};this.getXZData=function(){return this.graphType.match(/Scatter/)?this.getZData():this.getXData()};this.getSamplesVariablesAsArray=function(){return this.graphType.match(/scatter/i)?this.getSamplesAsArray():this.getVariablesAsArray};this.getSamplesAsArray=function(){var d=this.getSamples();var b=[];for(var c=0;c<d.length;c++){b.push(d[c].name)}return b};this.getVariablesAsArray=function(){var d=this.getVariables();var b=[];for(var c=0;c<d.length;c++){b.push(d[c].name)}return b};this.getNodeData=function(a){return this.getNetworkData("nodes",a)};this.getEdgeData=function(a){return this.getNetworkData("edges",a)};this.isBooleanData=function(c){for(var a in c){if(c[a]["t"]=="numeric"){var b=this.getKeys(c[a]["o"]);if(b.length==2&&(c[a]["o"].hasOwnProperty("true")&&c[a]["o"].hasOwnProperty("false"))){c[a]["t"]="string"}else{if(b.length==1&&(c[a]["o"].hasOwnProperty("true")||c[a]["o"].hasOwnProperty("false"))){c[a]["t"]="string"}else{if(b.length==1&&c[a]["o"].hasOwnProperty("")){c[a]["t"]="string"}}}}}};this.getSampleVariableData=function(k,p,n,j,q){var g={smps:{idx:"smpIndices",spc:"x"},vars:{idx:"varIndices",spc:"z"}};var b={};b[k]={o:{},t:"string"};if(p){b[k]["o"]=this.getObjectArray(this.data.y[k])}else{for(var e=0;e<this[g[k]["idx"]].length;e++){b[k]["o"][this.data.y[k][this[g[k]["idx"]][e]]]=true}}if(j||q){var l=j?this.getVariableIndices(n):this.getSampleIndices(n);if(l>-1){b={};b[n]={o:{},t:"numeric"};if(p){var d=this.meta.data.y.range[n];b[n]["o"]={min:d.min,max:d.max}}else{var f=[];if(j){for(var e=0;e<this.smpIndices.length;e++){f.push(this.data.y.data[l][this.smpIndices[e]])}}else{for(var e=0;e<this.varIndices.length;e++){f.push(this.data.y.data[this.varIndices[e]][l])}}var a=this.range(f);b[n]["o"]={min:a[0],max:a[1]}}}}else{if(this.data[g[k]["spc"]]){for(var h in this.data[g[k]["spc"]]){if(n&&h!=n){continue}var d=this.meta.data[g[k]["spc"]][h];b[h]={o:{},t:d.type.toLowerCase()};if(p){if(d.type=="Numeric"){b[h]["t"]="numeric";b[h]["o"]={min:d.rmin,max:d.rmax}}else{b[h]["t"]="string";b[h]["o"]=this.cloneObject(d.levels)}}else{for(var e=0;e<this[g[k]["idx"]].length;e++){var c=this.getMetadataValue(this[g[k]["idx"]][e],g[k]["spc"],h,true);if(!b[h]["o"].hasOwnProperty(c)){b[h]["o"][c]=true}}if(b[h]["t"]=="numeric"){var f=[];for(var c in b[h]["o"]){for(var e=0;e<b[h]["o"][c];e++){f.push(c)}}var a=this.range(f);b[h]["o"]={min:a[0],max:a[1]}}}}}}return b};this.getNetworkData=function(d,a){if(this.graphType=="Network"&&!this[d+"Data"]){this[d+"Data"]={};var f=this.meta.data[d];for(var b in f){if(f[b].type=="String"){this[d+"Data"][b]={o:f[b].order,t:f[b].type.toLowerCase()}}else{this[d+"Data"][b]={o:{min:f[b].rmin,max:f[b].rmax},t:f[b].type.toLowerCase()}}}if(this[d+"Properties"].length>0){for(var c=0;c<this.data[d].length;c++){var e=this.data[d][c];this.getAdditionalData(e,this[d+"Data"],this[d+"Properties"])}}}if(this.graphType=="Network"){return a?this[d+"Data"]:this.getKeys(this[d+"Data"])}else{return false}};this.getFilteredNetworkData=function(g,j){var b={};b[g]={};if(this.graphType=="Network"){for(var e=0;e<this.data[g].length;e++){var d=this.data[g][e];if(j||(!j&&!d.hide)){for(var h in d){if(typeof(d[h])!="object"){if(b[g].hasOwnProperty(h)){b[g][h]["o"][d[h]]=true;if(isNaN(d[h])){b[g][h]["t"]="string"}}else{b[g][h]={o:{},t:isNaN(d[h])?"string":"numeric"};b[g][h]["o"][d[h]]=true}}}}if(this[g+"Properties"].length>0){this.getAdditionalData(d,b,this[g+"Properties"])}}this.isBooleanData(b[g]);for(var h in b[g]){if(b[g][h]["t"]=="numeric"){var f=[];for(var c in b[g][h]["o"]){f.push(c)}var a=this.range(f);b[g][h]["o"]={min:a[0],max:a[1]}}}}return b[g]};this.getFeatureData=function(a){if(!this.featuresData){var h={};var d=this.skipConfigurableProperties?this.getObjectArray(this.featureConfigurableProperties):{};for(var g=0;g<this.data.tracks.length;g++){var c=this.data.tracks[g];var b=c.data;for(var e=0;e<b.length;e++){var l=b[e];for(var k in l){if(!d[k]){if(typeof(l[k])!="object"){if(h.hasOwnProperty(k)){if(h[k]["o"].hasOwnProperty(l[k])){h[k]["o"][l[k]]=true}if(isNaN(l[k])){h[k]["t"]="string"}}else{h[k]={o:{},t:isNaN(l[k])?"string":"numeric"};h[k]["o"][l[k]]=true}}}}}if(this.featuresProperties.length>0){this.getAdditionalData(b,h,this.featuresProperties)}}this.featuresData=h}return a?this.featuresData:this.getKeys(this.featuresData)};this.getAdditionalData=function(d,e,h){for(var f=0;f<h.length;f++){var b=d;var k=false;if(h[f].length>0){for(var c=0;c<h[f].length;c++){var a=h[f][c];if(b[a]){b=b[a]}else{k=true;break}}if(!k){for(var g in b){if(typeof(b[g])!="object"){if(e.hasOwnProperty(g)){if(isNaN(b[g])){e[g]["t"]="string"}}else{e[g]={o:{},t:isNaN(b[g])?"string":"numeric",r:f};e[g]["o"][b[g]]=true}}}}}}};this.getOperators=function(){return["","like","not like",">",">=","<","<=","==","null","not null"]};this.zoonIn=function(a){this.handleWheelEvent(a,1)};this.zoonOut=function(a){this.handleWheelEvent(a,-1)};this.clusterSamples=function(b,a){this.functionCaller="clusterSamples";if(this.isTransition()){return}this.clusterAxis="samples";if(b||!this.smpDendrogramNewick){this.smpDendrogramNewick=this.cluster()}if(!a){this.draw()}};this.clusterVariables=function(b,a){this.functionCaller="clusterVariables";if(this.isTransition()){return}this.clusterAxis="variables";if(b||!this.varDendrogramNewick){this.varDendrogramNewick=this.cluster()}if(!a){this.draw()}};this.kmeansSamples=function(e,d){this.functionCaller="kmeansSamples";if(this.isTransition()){return}this.clusterAxis="samples";if(!this.data.x){this.data.x={}}if(e||!this.data.x["k-Means-S"]){var a=this.kmeans();this.data.x["k-Means-S"]=[];for(var b=0;b<this.smpIndices.length;b++){var c=this.smpIndices[b];this.data.x["k-Means-S"][c]=a[b]}if(!this.isInArray("k-Means-S",this.smpOverlays)){this.smpOverlays.push("k-Means-S")}this.updateMetaData("x","k-Means-S",false,true);this.sortSamplesByCategory("k-Means-S",true)}if(!d){this.draw()}};this.kmeansVariables=function(e,d){this.functionCaller="kmeansVariables";if(this.isTransition()){return}this.clusterAxis="variables";if(!this.data.z){this.data.z={}}if(e||!this.data.z["k-Means-V"]){var a=this.kmeans();this.data.z["k-Means-V"]=[];for(var b=0;b<this.varIndices.length;b++){var c=this.varIndices[b];this.data.z["k-Means-V"][c]=a[b]}if(!this.isInArray("k-Means-V",this.varOverlays)){this.varOverlays.push("k-Means-V")}this.updateMetaData("z","k-Means-V",false,true);this.sortVariablesByCategory("k-Means-V",true)}if(!d){this.draw()}};this.setFunctions=function(){var a=this.functions;a.push("clusterSamples");a.push("clusterVariables");a.push("transpose");a.push("transform");a.push("sortSamplesByCategory");a.push("sortSamplesByVariable");a.push("sortVariablesByCategory");a.push("sortVariablesBySample");a.push("hideUnhideSmps");a.push("hideUnhideVars");a.push("desegregateSamples");a.push("segregateSamples");a.push("groupSamples");a.push("ungroupSamples");a.push("desegregateVariables");a.push("segregateVariables");a.push("kmeansSamples");a.push("kmeansVariables");a.push("createContour");a.push("removeContour");a.push("showCodeDiv");a.push("hideCodeDiv");a.push("showInfoDiv");a.push("hideInfoDiv");a.push("updateCodeDiv");a.push("createHistogram");a.push("removeHistogram");a.push("addRegressionLine");a.push("addNormalDistributionLine");a.push("recalculateLayout");a.push("createRandomData");a.push("drawArea");a.push("draw");a.push("reset");a.push("print")};this.initializeApi=function(){this.setFunctions()};this.setFunctionNames("initApiUtils");this.initializeApi()};CanvasXpress.prototype.initDimensionUtils=function(){this.resizeCanvas=function(a,l,e){this.functionCaller="resizeCanvas";var c=this.margin;if(a||l||e){if(l||e){if(l){this.width=l;this.originalWidth=l}if(e){this.height=e;this.originalHeight=e}}else{if(a){this.width=this.originalWidth;this.height=this.originalHeight}}this.top=c+this.getTitleSubtitleHeight();this.left=c;this.right=c;this.bottom=c;this.resetRender()}if(!this.isSVG){this.meta.canvas.ctx.canvas.width=this.width;this.meta.canvas.ctx.canvas.height=this.height;this.meta.canvas.ctx.canvas.style.width=this.width+"px";this.meta.canvas.ctx.canvas.style.height=this.height+"px";this.meta.canvas.ctx2.canvas.width=this.width;this.meta.canvas.ctx2.canvas.height=this.height}this.addToRender(["disableGradientTransparencyShadow"]);if(this.backgroundType=="image"){if(this.graphType=="Network"){var k=this.scaleFactorX||1;var j=this.scaleFactorY||1;var b=this.offsetX*k;var o=this.offsetY*j;var i=this.maxX?this.maxX*k:this.maxX;var d=this.maxY?this.maxY*j:this.maxY;var n=this.colorNodeBy||(this.decorations.length&&this.showDecorations)?"b&w":false;CanvasXpress.system.isRStudio=this.isInIframe()&&this.isR?true:false;if(CanvasXpress.system.isRStudio){this.addToRender(["drawShape","image",(i/2)+b,(d/2)+o,i,d,false,false,false,false,false,false,false,false,false,this.backgroundImage])}else{this.drawImage(CanvasXpress.cacheImages[this.getFileName(this.backgroundImage)],0,0,this.maxX,this.maxY,b,o,i,d,n)}}else{this.addToRender(["drawShape","image",this.width/2,this.height/2,this.width,this.height,false,false,false,false,false,false,false,false,false,this.backgroundImage])}}else{if(this.backgroundType=="windowImage"){this.addToRender(["drawShape","image",this.left+(this.x/2),this.top+(this.y/2),this.x,this.y,false,false,false,false,false,false,false,false,false,this.backgroundImage])}else{if(this.backgroundType=="solid"||this.backgroundType=="window"||this.backgroundType=="windowSolidGradient"||this.backgroundType=="video"){this.addToRender(["drawShape","rectangle",0+(this.width/2),0+(this.height/2),this.width,this.height,this.background,this.background])}else{var f=this.getLinearGradient(0,0,this.gradientOrientation=="vertical"?0:this.height,this.gradientOrientation=="vertical"?this.height:0,this.backgroundGradient1Color,this.backgroundGradient2Color);this.addToRender(["drawShape","rectangle",0+(this.width/2),0+(this.height/2),this.width,this.height,f,f])}}}this.addToRender(["enableGradientTransparencyShadow"])};this.setWidth=function(a,b){this.setDimensions(a,false,b)};this.setHeight=function(b,a){this.setDimensions(false,b,a)};this.getWidth=function(){return this.marginLeft+this.left+this.x+this.right+this.marginRight};this.getHeight=function(){return this.marginTop+this.top+this.y+this.bottom+this.marginBottom};this.setDimensions=function(d,g,f,e,b,a){this.functionCaller="setDimensions";if(this.isTransition()){return}if(!this.resizable){return}var j=this.meta.canvas.ctx.canvas;if(!d||!this.resizableX){d=this.width}if(!g||!this.resizableY){g=this.height}d=j.originalWidth=parseInt(d);g=j.originalHeight=parseInt(g);this.clickLayoutNoAnimation(f);if(!this.reproducing){this.removeMotionDiv(true)}if(this.graphType=="Network"){this.scaleFactorX=null;this.scaleFactorY=null}this.draw(d,g);this.updateRemoteNavigationWindow();if(e){var i=this;setTimeout(function(){i.resizeViewport()},e)}else{this.resizeViewport()}if(a){a()}};this.initializeDimensions=function(){var b=this.meta.canvas.ctx.canvas;var a=this.margin;if(b.width){this.originalWidth=b.width;this.width=b.width}else{if(this.width){this.originalWidth=this.width;b.width=this.width}else{this.width=600;this.originalWidth=this.width;b.width=this.width}}if(b.height){this.originalHeight=b.height;this.height=b.height}else{if(this.height){this.originalHeight=this.height;b.height=this.height}else{this.height=600;this.originalHeight=this.height;b.height=this.height}}this.top=a+this.getTitleSubtitleHeight();this.left=a;this.right=a;this.bottom=a;this.x=this.width-(this.leftMargin+this.left+this.rightMargin+this.right);this.y=this.height-(this.topMargin+this.top+this.bottomMargin+this.bottom)};this.setFunctionNames("initDimensionUtils");this.initializeDimensions()};CanvasXpress.prototype.initUtils=function(){this.initGeneralUtils();this.initPlotUtils();this.initConfigUtils();this.init3dUtils();this.initApiUtils();this.initDimensionUtils()};CanvasXpress.prototype.initLegendUtils=function(){this.validateLegendPositions=function(){if(!this.legendInside){if(this.decorationsPosition!="right"&&this.decorationsPosition!="bottom"&&this.graphType!="Network"){this.decorationsPosition="bottom"}if(this.legendPosition!="top"&&this.legendPosition!="bottom"&&this.legendPosition!="right"&&this.legendPosition!="left"){if(this.graphType=="Circular"){if(this.legendPosition!="top"){this.legendPosition="right"}}else{this.legendPosition="right"}}}if(!this.overlaysLegendPosition){this.overlaysLegendPosition="topRight"}if(this.layoutValid){var a=this.meta.config.orig;a.insideLegend=this.insideLegend;this.insideLegend=false;if(this.legendPosition!="top"&&this.legendPosition!="bottom"&&this.legendPosition!="right"&&this.legendPosition!="left"){a.legendPosition=this.legendPosition;this.legendPosition="right"}}};this.setLegendFont=function(){if(this.autoScaleFont){var b=(1-this.percentAspectRatioPlotArea);var a=this.min(this.width*b,this.height*b);this.setPropertyFontSize(a,"legendFont")}else{this.legendFont=this.legendFontStyle+" "+parseInt(this.legendFontSize)+"px "+this.fontName}};this.drawLegendBackgroundBox=function(e,r,p,g,m,o,j,f){this.functionCaller="drawLegendBackgroundBox";var n=this.graphType=="Map"||this.graphType=="Correlation"?false:j?this.decorationsBackgroundColor:this.legendBackgroundColor;var c=f?this.legendBackgroundColor:j?this.decorationsBoxColor:this.legendBoxColor;var q=j?this.decorationsBox:this.legendBox;var k=this.graphType;var s=[0,0,this.width,this.height];if(m){if(q&&n&&!f&&k!="Network"){this.addToRender(["disableGradientTransparencyShadow"]);this.addToRender(["drawShape","rectangle",e+(p/2),r+(g/2),p,g,n,n,"solid",false,false,true,s],[-1],o);this.addToRender(["enableGradientTransparencyShadow"])}else{if(n){this.addToRender(["drawShape","rectangle",e+(p/2),r+(g/2),p,g,n,n,"solid",false,false,true,s],[-1],o)}else{this.addToRender(["drawShape","rectangle",e+(p/2),r+(g/2),p,g,false,"rgba(0,0,0,0)","open",false,false,true,s],[-1],o)}}}else{if(q){this.addToRender(["disableGradientTransparencyShadow"]);this.addToRender(["drawShape","rectangle",e+(p/2),r+(g/2),p,g,false,c,"open",false,false,true,s]);this.addToRender(["enableGradientTransparencyShadow"])}}};this.getDiameterLegend=function(){var a=Math.min(this.width,this.height);return Number(Math.max(0.5,a*12/833).toFixed(1))*this.legendScaleFontFactor};this.setCustomLegendDimensions=function(j){var e=j.text.length;var u=this.getDiameterLegend();var z=j.size;if(z){for(var k=0;k<z.length;k++){if(z[k]){u=Math.max(u,z[k])}}}var y=this.measureText(j.title&&this.showLegendTitle?j.title:"",this.legendFont);var g=this.measureText(this.getMaxText(j.text),this.legendFont);var p=this.getFontPt(this.legendFont);var v=this.legendColumns>e?e:this.legendColumns;var a=Math.ceil(e/v);var b=Math.max(y,(g+u+(this.margin*2))*v);var x=b+(this.margin*(v+2));var o=j.title&&this.showLegendTitle?(a*(Math.max(u,p)+this.margin))+p+(this.margin*2):(a*(Math.max(u,p)+this.margin))+(this.margin*1);this["legend"+j.id+"Width"]=x;this["legend"+j.id+"Height"]=o};this.setPropertyLegendDimensions=function(c,n,b){var a=this.decapitalize(c)+"By";if(this[a]&&(this[a+"ShowLegend"]||this.graphType=="Network")){var r,g,o;if(n){r=this[a];g=n;o=b&&b.sizes?b.sizes:this.sizes}else{if(this.data.x&&this.data.x.hasOwnProperty(this[a])){r=this[a];g=this.meta.data.x[this[a]].maxLevStr;o=this.meta.data.x[this[a]].sizes||this.sizes}else{if(this.data.z&&this.data.z.hasOwnProperty(this[a])){r=this[a];g=this.meta.data.z[this[a]].maxLevStr;o=this.meta.data.z[this[a]].sizes||this.sizes}else{if(a.match("Node")){r=this[a];g=this.meta.data.nodes[this[a]].maxLevStr;o=this.meta.data.nodes[this[a]].sizes||this.sizes}else{if(a.match("Edge")){r=this[a];g=this.meta.data.edges[this[a]].maxLevStr;o=this.meta.data.edges[this[a]].sizes||this.sizes}else{r=0;g=0;o=this.sizes}}}}}var k=this.getDiameterLegend();if(c=="Size"||c=="SizeNode"||c=="SizeEdge"){for(var h=0;h<this["legend"+c+"sN"];h++){if(o[h]){k=Math.max(k,o[h])}}}var j=this.getFontPt(this.legendFont);var t=this.legendColumns>this["legend"+(c=="Outline"?"Color":c)+"sN"]?this["legend"+(c=="Outline"?"Color":c)+"sN"]:this.legendColumns;var e=Math.ceil(this["legend"+(c=="Outline"?"Color":c)+"sN"]/t);var q=this.showLegendTitle?this.measureText(r,this.legendFont):0;var s=(this.measureText(g,this.legendFont)+k+(this.margin*2))*t;this["legend"+(c=="Outline"?"Color":c)+"Width"]=Math.max(q,s)+(this.margin*(t+2));this["legend"+(c=="Outline"?"Color":c)+"Height"]=(e*(Math.max(k,j)+this.margin))+(this.showLegendTitle?j+(this.margin*3):this.margin)}};this.setPropertyLegendIndicatorDimensions=function(e,b){var j=this.decapitalize(e)+"By";var d=0;var g=0;var i=this.getFontPt(this.legendFont);if(this[j]||e=="Decoration"){switch(e){case"Color":case"ColorNode":case"ColorEdge":case"Outline":case"Decoration":var a=this.showLegendTitle?this.measureText(this.colorBy||this.outlineBy||this.colorNodeBy||this.colorEdgeBy||"",this.legendFont):0;var c=b.maxLevLen;if(this.legendPosition.match(/top|bottom/)){g=this.heatmapIndicatorHeight+(this.margin*4)+(i*2);if(this.showLegendTitle){g+=i+this.margin}d=this.heatmapIndicatorWidth+Math.max(a,c)}else{g=this.heatmapIndicatorWidth+(this.margin*3)+(this.showLegendTitle?(i*2):0);d=this.heatmapIndicatorHeight+(this.margin*4)+Math.max(a,c)}break;case"Shape":case"ShapeNode":case"ShapeEdge":case"Size":case"SizeNode":case"SizeEdge":this.setPropertyLegendDimensions(e,b.maxLevStr,b);return;case"Pattern":case"PatternNode":case"PatternEdge":d=0;g=0;break}}this["legend"+(e=="Outline"?"Color":e)+"Width"]=d;this["legend"+(e=="Outline"?"Color":e)+"Height"]=g};this.setDecorationsLegendDimensions=function(){this.legendDecorationWidth=0;this.legendDecorationHeight=0;this.legendDecorationMaxLabel=0;if(this.showDecorations&&this.showDecorationsLegend&&this.decorations){if(!this.legendInside){if(this.decorationsPosition!="right"&&this.decorationsPosition!="bottom"&&this.graphType!="Network"){this.decorationsPosition="bottom"}}var f=this.getFontPt(this.decorationFont);var h=this.decorations;var b=0;if(h.nlfit){var g=this.measureText(sprintf("%96s","X"),this.decorationFont)+(this.margin*5);var a=0;for(var e=0;e<h.nlfit.length;e++){var c=this.measureText(h.nlfit[e].label,this.decorationFont);a=Math.max(c,a);this.legendDecorationMaxLabel=Math.max(a,this.legendDecorationMaxLabel)}b=Math.max(b,this.margin+a+this.margin+g+this.margin);this.legendDecorationHeight=(h.nlfit.length*f*2)+f+this.margin}if(h.line){var a=0;for(var e=0;e<h.line.length;e++){if(h.line[e].label){var c=this.measureText(h.line[e].label,this.decorationFont);a=Math.max(c,a);this.legendDecorationMaxLabel=Math.max(a,this.legendDecorationMaxLabel)}}if(a>0){b=Math.max(b,this.margin+a+this.margin);this.legendDecorationHeight+=(h.line.length*f*2)+this.margin}}if(h.reg){var g=this.measureText(sprintf("%45s","X"),this.decorationFont)+(this.margin*2);var a=0;for(var e=0;e<h.reg.length;e++){var c=this.measureText(h.reg[e].label,this.decorationFont);a=Math.max(c,a);this.legendDecorationMaxLabel=Math.max(a,this.legendDecorationMaxLabel)}b=Math.max(b,this.margin+a+this.margin+g+this.margin);this.legendDecorationHeight+=(h.reg.length*f*2)+f+this.margin}if(h.nor){var g=this.measureText(sprintf("%30s","X"),this.decorationFont)+(this.margin*1);var a=0;for(var e=0;e<h.nor.length;e++){var c=this.measureText(h.nor[e].label,this.decorationFont);a=Math.max(c,a);this.legendDecorationMaxLabel=Math.max(a,this.legendDecorationMaxLabel)}b=Math.max(b,this.margin+a+this.margin+g+this.margin);this.legendDecorationHeight+=(h.nor.length*f*2)+f+this.margin}if(h.area){var a=0;for(var e=0;e<h.area.length;e++){var c=this.measureText(h.area[e].label,this.decorationFont);a=Math.max(c,a);this.legendDecorationMaxLabel=Math.max(a,this.legendDecorationMaxLabel)}b=Math.max(b,this.margin+a+this.margin);this.legendDecorationHeight+=(h.area.length*f*2)+this.margin}if(h.kaplanMeier){var a=0;for(var e=0;e<h.kaplanMeier.length;e++){var c=this.measureText(h.kaplanMeier[e].label,this.decorationFont);a=Math.max(c,a);this.legendDecorationMaxLabel=Math.max(a,this.legendDecorationMaxLabel)}b=Math.max(b,this.margin+a+this.margin);this.legendDecorationHeight+=(h.kaplanMeier.length*f*2)-this.margin}this.legendDecorationWidth=b}};this.setOncoprintLegendDimension=function(){this.legendOncoprintWidth=0;this.legendOncoprintHeight=0;if(this.isOncoprint){var c=this.measureText("Amplification",this.legendFont);var e=this.measureText("Deletion",this.legendFont);var b=this.measureText("Mutation",this.legendFont);this.legendOncoprintWidth=100+c+e+b+(this.margin*2);this.legendOncoprintHeight=30+(this.margin*2)}};this.setSampleLegendDimension=function(){this.legendSampleWidth=0;this.legendSampleHeight=0;var d=this.getFontPt(this.legendFont);var b=0;if(this.graphType.match(/Scatter/)){if(this.xAxisIndices.length!=this.yAxisIndices.length||this.xAxisIndices.length>1){if(this.xAxisIndices.length==this.yAxisIndices.length&&this.xAxisIndices.length>1){for(var c=0;c<this.xAxisIndices.length;c++){var a;if(this.isHistogram){a=this.measureText(this.shortenText(this.xAxis[c],this.maxSmpStringLen),this.legendFont)}else{a=this.measureText(this.shortenText(this.xAxis[c],this.maxSmpStringLen)+" vs "+this.shortenText(this.yAxis[c],this.maxSmpStringLen),this.legendFont)}b=Math.max(a,b)}}else{if(this.xAxisIndices.length>this.yAxisIndices.length){b=this.measureText(this.shortenText(this.getMaxText(this.xAxis),this.maxSmpStringLen)+" vs "+this.shortenText(this.yAxis[0],this.maxSmpStringLen),this.legendFont)}else{if(this.yAxisIndices.length>this.xAxisIndices.length){if(this.isHistogram){b=this.measureText(this.shortenText(this.getMaxText(this.yAxis),this.maxSmpStringLen),this.legendFont)}else{b=this.measureText(this.shortenText(this.getMaxText(this.yAxis),this.maxSmpStringLen)+" vs "+this.shortenText(this.xAxis[0],this.maxSmpStringLen),this.legendFont)}}}}this.legendSampleWidth=(d-1)+b+(this.margin*3);this.legendSampleHeight=(Math.max(this.xAxisIndices.length,this.yAxisIndices.length)*(d+this.margin))+this.margin}else{if(this.isHistogram){b=this.measureText(this.shortenText(this.getMaxText(this.yAxis),this.maxSmpStringLen),this.legendFont);this.legendSampleWidth=(d-1)+b+(this.margin*3);this.legendSampleHeight=(Math.max(this.xAxisIndices.length,this.yAxisIndices.length)*(d+this.margin))+this.margin}}}};this.setVariableLegendDimension=function(){this.legendVariableWidth=0;this.legendVariableHeight=0;var a=this.isDOE&&this.layoutCurrentDOE?this.meta.data.x[this.layoutCurrentDOE]:this.meta.data.y;var f=this.getFontPt(this.legendFont);if(this.graphType=="Pie"){var g=this.varIndices.length>this.maxPieSectors?this.maxPieSectors:this.varIndices.length;var d=this.isDOE&&this.layoutCurrentDOE?this.shortenText(a.maxLevStr,this.maxVarStringLen):this.shortenText(a.maxVarStr,this.maxVarStringLen);if(this.maxPieSectors<this.varIndices.length&&d.length<5){d=this.shortenText("Other",this.maxVarStringLen)}var b=this.measureText(d,this.legendFont);if(b>this.width/2){this.legendFont=this.scaleTextToFont(b,f,this.width/2)}this.legendVariableWidth=this.measureText(d,this.legendFont)+f+(this.margin*3);this.legendVariableHeight=((f+this.margin)*g)+this.margin}else{if(this.layoutValid&&this.segregateVariablesBy.length>0&&!this.graphType.match(/Scatter/)){if(this.segregateVariablesBy[0]=="variable"||(this.segregateVariablesBy.length>1&&this.segregateVariablesBy[1]=="variable")){return}else{if(!this.colorBy||(this.colorBy&&this.colorBy=="variable")){var c=a.maxVarChr>this.maxVarStringLen?a.maxVarStr.substring(0,this.maxVarStringLen):a.maxVarStr;this.legendVariableWidth=((this.margin*3)+(f*2)+this.measureText(c,this.legendFont))*this.legendColumns;this.legendVariableHeight=(Math.ceil(this.data.y.vars.length/this.legendColumns)*f*1.5)+this.margin}else{return}}}else{if((this.colorBy&&this.colorBy=="variable")||(this.shapeBy&&this.shapeBy=="variable")||(this.sizeBy&&this.sizeBy=="variable")||(this.patternBy&&this.patternBy=="variable")){var c=this.sizeBy&&this.sizeBy=="variable"?Math.max(this.sizes[this.varIndices.length-1],this.getFontPt(this.legendFont)):this.getFontPt(this.legendFont);var d=this.shortenText(a.maxVarStr,this.maxVarStringLen);this.legendVariableWidth=((c-1)+this.measureText(d,this.legendFont)+(this.margin*3))*this.legendColumns;this.legendVariableHeight=(Math.ceil(this.varIndices.length/this.legendColumns)*(c+this.margin))+this.margin}else{if(this.graphType=="BarLine"||this.graphType=="DotLine"||this.graphType=="AreaLine"||this.graphType=="StackedLine"||this.graphType=="StackedPercentLine"){var c=a.maxVarChr>this.maxVarStringLen?a.maxVarStr.substring(0,this.maxVarStringLen):a.maxVarStr;this.legendVariableWidth=((this.margin*3)+(f*2)+this.measureText(c,this.legendFont))*this.legendColumns;this.legendVariableHeight=(Math.ceil((this.xAxisVarIndices.length+this.xAxis2VarIndices.length)/this.legendColumns)*f*1.5)+this.margin}else{if(!this.colorBy&&(this.graphType=="Bar"||this.graphType=="Line"||this.graphType=="Area"||this.graphType=="Dotplot"||this.graphType=="Stacked"||this.graphType=="StackedPercent"||this.graphType=="Boxplot")){var c=a.maxVarChr>this.maxVarStringLen?a.maxVarStr.substring(0,this.maxVarStringLen):a.maxVarStr;this.legendVariableWidth=((this.margin*3)+(f*2)+this.measureText(c,this.legendFont))*this.legendColumns;this.legendVariableHeight=(Math.ceil(this.varIndices.length/this.legendColumns)*f*1.5)+this.margin}else{if(this.graphType=="Circular"&&!this.showIdeogram){var c=a.maxVarChr>this.maxVarStringLen?a.maxVarStr.substring(0,this.maxVarStringLen):a.maxVarStr;var e=this.rAxisIndex>=0?this.varIndices.length-1:this.varIndices.length;this.legendVariableWidth=((this.margin*3)+(f*2)+this.measureText(c,this.legendFont))*this.legendColumns;this.legendVariableHeight=(Math.ceil(e/this.legendColumns)*f*1.5)+this.margin}}}}}}};this.setVennLegendDimension=function(){var a=this.data.venn.legend?this.getMaxText(this.data.venn.legend):"N/A";this.legendWidth=this.measureText(a,this.legendFont)+(this.margin*6);this.legendHeight=this.margin+this.margin+((this.getFontPt(this.legendFont)+this.margin)*this.vennGroups)};this.setOverlaysLegendDimensions=function(){var b=this.getFontPt(this.legendFont);var s=this.getDiameterLegend();var k=Math.max(b,s);var d=["varOverlays","smpOverlays"];var e=["varOverlayProperties","smpOverlayProperties"];var y=["showVarOverlaysLegend","showSmpOverlaysLegend"];this.legendOverlaysLayout=[];this.legendOverlaysWidth=0;this.legendOverlaysHeight=0;var q=this.margin;var n=this.margin;var a=0;var g=0;var l=0;var B=false;if(this.showOverlays&&(this.showVarOverlaysLegend||this.showSmpOverlaysLegend)){for(var v=0;v<d.length;v++){if(this[d[v]].length>0&&this[y[v]]){for(var t=0;t<this[d[v]].length;t++){var f=0;var x=0;var p=this[d[v]][t];if(p!="-"){var A=d[v]=="varOverlays"?"z":"x";var r=this.meta.data[A][p];var u=this.measureText(r.maxLevStr,this.legendFont);var z=this.measureText(p,this.legendFont);if(this.graphType=="Circular"||(this[e[v]][p]&&this[e[v]][p].type=="Default"&&this[e[v]][p].showLegend)){B=true;if(r.type=="String"){f=Math.max(z,u+k+(this.margin*3))*this[d[v]+"LegendColumns"];x=((Math.max(b,s)+this.margin)*Math.ceil(r.levels.length/this[d[v]+"LegendColumns"]))+b+(this.margin*3)}else{if(this.overlaysLegendPosition.match(/right/i)){f=Math.max(this.heatmapIndicatorHeight+(this.margin*2)+u,z);x=this.heatmapIndicatorWidth+(this.margin*3)+b}else{f=this.heatmapIndicatorWidth+(this.margin*3)+b;x=Math.max(this.heatmapIndicatorHeight+(this.margin*2)+u,z)}}this["legend"+p+"Width"]=f;this["legend"+p+"Height"]=x;if(this.overlaysLegendPosition.match(/right/i)){if(g+this.margin+x>(this.height-(this.top+this.bottom))){q+=this.margin+f;a=f;g=x;if(this.legendOverlaysLayout[l]){l++}this.legendOverlaysLayout[l]=[[A,p,f,x]]}else{if(f>a){q+=(f-a);a=f}g+=x;if(!this.legendOverlaysLayout[l]){this.legendOverlaysLayout[l]=[]}this.legendOverlaysLayout[l].push([A,p,f,x])}}else{if(a+this.margin+f>(this.width-(this.left+this.right))){n+=this.margin+x;a=f;g=x;if(this.legendOverlaysLayout[l]){l++}this.legendOverlaysLayout[l]=[[A,p,f,x]]}else{if(x>g){n+=(x-g);g=x}a+=f;if(!this.legendOverlaysLayout[l]){this.legendOverlaysLayout[l]=[]}this.legendOverlaysLayout[l].push([A,p,f,x])}}}}}}}}if(this.overlaysLegendPosition.match(/right/i)){this.legendOverlaysWidth=B?q+this.margin:0;this.legendOverlaysHeight=B?g+this.margin:0}else{this.legendOverlaysWidth=B?a+this.margin:0;this.legendOverlaysHeight=B?n+this.margin:0}};this.setLegendDimensions=function(){if(this.showDecorations&&this.showDecorationsLegend&&this.decorations){this.decorationLayout=[0]}if(this.showLegend){this.legendLayout=[];this.legendWidth=0;this.legendHeight=0;var a=this.margin;var k=this.margin;var b=0;var j=0;var g=0;var e=this.graphType=="Network"?["ColorNode","ShapeNode","SizeNode","PatternNode","ColorEdge","SizeEdge","Decoration"]:this.scatterPlotMatrix?["Color","Shape","Size","Pattern","Variable"]:["Color","Shape","Size","Pattern","Variable","Sample"];for(var c=0;c<e.length;c++){var f=this["legend"+e[c]+"Width"];var d=this["legend"+e[c]+"Height"];if(e[c]=="Decoration"&&!this.showDecorations){continue}if(f>0){if(this.legendPosition.match(/right|left/i)){if(j+this.margin+d>this.height){a+=this.margin+f;b=f;j=d;this.legendLayout[g]=[e[c]];g++}else{if(f>b){a+=(f-b);b=f}j+=d;if(!this.legendLayout[g]){this.legendLayout[g]=[]}this.legendLayout[g].push(e[c])}}else{if(b+this.margin+f>this.width){k+=this.margin+d;b=f;j=d;this.legendLayout[c]=[e[c]];g++}else{if(d>j){k+=(d-j);j=d}b+=f;if(!this.legendLayout[g]){this.legendLayout[g]=[]}this.legendLayout[g].push(e[c])}}}}for(var c=0;c<this.legend.length;c++){this.legend[c].id="Custom"+c;this.setCustomLegendDimensions(this.legend[c]);var f=this["legendCustom"+c+"Width"];var d=this["legendCustom"+c+"Height"];if(this.legendPosition.match(/right|left/i)){if(j+this.margin+d>this.height){a+=this.margin+f;b=f;j=d;this.legendLayout[g]=[this.legend[c].id];g++}else{if(f>b){a+=(f-b);b=f}j+=d;if(!this.legendLayout[g]){this.legendLayout[g]=[]}this.legendLayout[g].push(this.legend[c].id)}}else{if(b+this.margin+f>this.width){k+=this.margin+d;b=f;j=d;this.legendLayout[c]=[this.legend[c].id];g++}else{if(d>j){k+=(d-j);j=d}b+=f;if(!this.legendLayout[g]){this.legendLayout[g]=[]}this.legendLayout[g].push(this.legend[c].id)}}}this.legendWidth=b==0&&a==this.margin?0:this.legendPosition.match(/right|left/i)?a+this.margin:b+this.margin;this.legendHeight=j==0&&k==this.margin?0:this.legendPosition.match(/right|left/i)?j+this.margin:k+this.margin}};this.setLegends=function(){var h=this;var g=this.graphType=="Network"?["ColorNode","ShapeNode","SizeNode","PatternNode","ColorEdge","SizeEdge"]:["Color","Shape","Size","Pattern","Outline"];var q=["shapeByData","sizeByData","patternByData","outlineByData"];var n=function(a,o,t,v){var u=o=="Outline"?"Color":o;var s=(h.decapitalize(u)+"s").replace("Node","").replace("Edge","").replace("decorations","colors");delete (h["legend"+u+"sS"]);h["legend"+u+"Meta"]=a;if(t){h["legend"+u+"Meta"].vals=h.rPretty(t[0],t[1],5);h["legend"+u+"Meta"].decs=h.getAxisDecimals(t[1]-t[0]);h["legend"+u+"Meta"].maxLevStr=h.getMaxText(h["legend"+(o=="Outline"?"Color":o)+"Meta"].vals);h["legend"+u+"Meta"].maxLevLen=h.measureText(h["legend"+u+"Meta"].maxLevStr,h.font);h["legend"+u+"Meta"].maxLevChr=h["legend"+u+"Meta"].maxLevStr.toString().length}h["legend"+u+"sMax"]=h["legend"+u+"Meta"].maxLevStr;h["legend"+u+"sN"]=h["legend"+u+"Meta"].vals.length;for(var p=0;p<h["legend"+u+"Meta"].vals.length;p++){h["legend"+u+"s"][h["legend"+u+"Meta"].vals[p].toString()]=h[s][p]}h.setPropertyLegendIndicatorDimensions(o,h["legend"+u+"Meta"])};var j=function(A,H,w,C,x){var E=0;var u=0;var z=false;var B={};var r={};var a=A[h.decapitalize(C).replace("Node","").replace("Edge","")+"s"]||h[h.decapitalize(C).replace("Node","").replace("Edge","")+"s"];var y=h.isGroupedData&&h.graphType!="Dotplot"&&h.graphType!="Boxplot"&&!h.showBoxplotOriginalData&&h.groupingFactors.length==1;if(H=="x"){var s=h.isGroupedData?h.grpIndices:h.smpIndices;for(var F=0;F<s.length;F++){var t=s[F];if(h.isGroupedData&&(h.graphType=="Dotplot"||h.graphType=="Boxplot")){h.isGroupedData=false;for(var D=0;D<h.data.w.grps[t].length;D++){var v=h.getMetadataValue(h.data.w.grps[t][D],H,h[w]);r[v]=true}h.isGroupedData=true}else{var v=h.isGroupedData?h.getSmpAnnotations(h[w],h.data.w.grps[F],true):h.getMetadataValue(t,H,h[w]);r[v]=true}}}else{if(H=="z"){for(var F=0;F<h.varIndices.length;F++){var t=h.varIndices[F];var v=h.getMetadataValue(t,H,h[w]);r[v]=true}}else{if(H=="m"){for(var F=0;F<h.varIndices.length;F++){for(var D=0;D<h.smpIndices.length;D++){var v=x[h.varIndices[F]][h.smpIndices[D]];r[v]=true}}}else{if(H=="modified"){A.order={};for(var F=0;F<A.levels.length;F++){r[A.levels[F]]=true;A.order[A.levels[F]]=F}}else{if(H=="nodes"||H=="edges"){A.order={};for(var F=0;F<A.levels.length;F++){r[A.levels[F]]=true;A.order[A.levels[F]]=F}}}}}}r=h.getKeys(r);if(A.type=="Numeric"){if(A.orderS){r.sort(function(l,i){return A.orderS[l]-A.orderS[i]})}else{r.sort(function(l,i){return l-i});A.orderS={};for(var F=0;F<r.length;F++){A.orderS[r[F]]=F}}}else{r.sort(function(l,i){return A.order[l]-A.order[i]})}for(var F=0;F<r.length;F++){var v=r[F]!=null?r[F]:"NA";var G=h.measureText(v,h.legendFont);if(G>E){E=G;h["legend"+C+"sMax"]=v}B[v]=(A.type=="Numeric"?A.orderS[v]:A.order[v])%a.length;h["legend"+C+"s"][v]=a[B[v]];u++}h["legend"+C+"sS"]=r;z=H=="m"||H=="modified"?h["legend"+C+"sMax"]:false;h["legend"+C+"sN"]=u;h["legend"+C+"Meta"]=A;h.setPropertyLegendDimensions(C,z,A)};this.validateLegendPositions();this.setLegendFont();if(this.graphType=="Venn"){this.setVennLegendDimension();return}else{if(this.graphType=="Network"){for(var f=0;f<g.length;f++){var e=g[f];var k=this.decapitalize(g[f]);var b=k+"By";this["legend"+e+"s"]={};this["legend"+e+"sN"]=0;this["legend"+e+"Width"]=0;this["legend"+e+"Height"]=0;if(this[b]){var d=this.meta.data[e.match("Node")?"nodes":"edges"][this[b]];if(d.type=="Numeric"){n(d,e)}else{j(d,e.match("Node")?"nodes":"edges",b,e)}}}if(this.decorations.length&&this.decorationsType=="heatmap"&&this.meta.data.decorations.n&&this.showDecorations){var d=this.meta.data.decorations;var e="Decoration";this["legend"+e+"s"]={};this["legend"+e+"sN"]=0;this["legend"+e+"Width"]=0;this["legend"+e+"Height"]=0;n(d,e)}}else{if(this.isMultidimensionalData){for(var f=0;f<q.length;f++){if(this.data.y[this[q[f]]]){var c=this.data.y[this[q[f]]];var d=this.meta.data[this[q[f]]];var e=q[f].replace("ByData","");e=this.capitalize(e);var k=this.decapitalize(e);var b=k+"By";this["legend"+(e=="Outline"?"Color":e)+"s"]=[];this["legend"+(e=="Outline"?"Color":e)+"sN"]=0;if(d.type=="Numeric"){n(d,e,[d.min,d.max])}else{j(d,"m",b,e,c)}}}}else{for(var f=0;f<g.length;f++){var e=g[f];var k=this.decapitalize(g[f]);var b=k+"By";this["legend"+e+"s"]={};this["legend"+e+"sN"]=0;this["legend"+e+"Width"]=0;this["legend"+e+"Height"]=0;if(this[b]){if(this.data.x&&this.data.x.hasOwnProperty(this[b])){var d=this.meta.data.x[this[b]];this[k+"ByType"]="x";if(d.type=="Numeric"&&!d[b]){n(d,e)}else{j(d,"x",b,e)}}else{if(this.data.z&&this.data.z.hasOwnProperty(this[b])){var d=this.meta.data.z[this[b]];this[k+"ByType"]="z";if(d.type=="Numeric"&&!d[b]){n(d,e)}else{j(d,"z",b,e)}}else{if(this.getSampleIndices(this[b])>-1&&this.meta.data.y.range[this[b]]){var d=this.meta.data;if(d.modified&&d.modified.z&&d.modified.z[this[b]]){d=d.modified.z;if(!d.meta){d.meta={}}d.meta[this[b]]={levels:d[this[b]]};j(d.meta[this[b]],"modified",b,e)}else{d=d.y.range[this[b]];n(d,e,[d.min,d.max])}}else{if(this[b]=="variable"){h["legend"+e+"sN"]=this.varIndices.length}}}}}}}}}if(this.graphType!="Network"){this.setDecorationsLegendDimensions()}this.setSampleLegendDimension();this.setVariableLegendDimension();this.setOncoprintLegendDimension();this.setOverlaysLegendDimensions();this.setLegendDimensions()};this.addLegend=function(c,b){if(c){if(b){var a=this.findXYCoordinates(b);c.x=a.x;c.y=a.y}this.legend.push(c)}};this.deleteLegend=function(c){if(c&&c.id){var b=[];for(var a=0;a<this.legend.length;a++){if(this.legend[a].id!=c.id){b.push(this.legend[a])}}this.legend=b}};this.drawDecorationData=function(){this.functionCaller="drawDecorationData";var Z=this.marginLeft+this.offsetX+this.left;var V=this.marginTop+this.offsetY+this.top;var ah=this.decorations;if(this.showDecorations&&ah){if(this.graphType.match(/Scatter/)){if(ah.nlfit){var h,N,f;var F=this.varIndices;var I,g;for(var ad=0;ad<ah.nlfit.length;ad++){var az=[];var ax=[];var M=ad%this.colors.length;var a=Number(this.transformValue(this.yAxisTransform,ah.nlfit[ad].param[0]));var aL=Number(this.transformValue(this.yAxisTransform,ah.nlfit[ad].param[1]));var aK=Number(ah.nlfit[ad].param[2]);var aJ=Number(ah.nlfit[ad].param[3]);var W=this.xAxisIndices.length==1?this.xAxisIndices[0]:this.xAxisIndices[ad];var aA=this.getDataForSmpGrpAtIndex(W);if(this.xAxisTransform=="percentile"){h=this.range(aA);f=h[0];N=h[1]}F.sort(function(i,d){return aA[i]-aA[d]});M=ah.nlfit[ad].color?ah.nlfit[ad].color:this.colors[M];for(var ac=0;ac<F.length;ac++){var B=F[ac];var P=this.getDataAtPos(B,W);var O;var L=[];if(P>0){if(ac>0){var ay=F[ac-1];var aB=this.getDataAtPos(ay,W);if(aB>0){var Q=(P-aB)/this.functionIntervals;for(var ab=0;ab<this.functionIntervals;ab++){L.push(aB);aB+=Q}}}else{L=[P]}for(var ab=0;ab<L.length;ab++){if(ah.nlfit[ad].type=="reg"){O=a+((aL-a)/(1+aK/(Math.pow(L[ab],aJ))))}else{O=a+((aL-a)/(1+(Math.pow((L[ab]/aK),aJ))))}if(this.xAxisTransform){L[ab]=this.xAxisTransform=="percentile"?this.percentile(f,N,L[ab]):this.transformValue(this.xAxisTransform,L[ab])}I=Z+((L[ab]-this.xAxisMin)*this.xAxisUnit);g=(V+this.y)-((O-this.yAxisMin)*this.yAxisUnit);az.push(I);ax.push(g)}}}if(az.length>0){this.addToRender(["drawShape","path",az,ax,false,false,M,M,"open",false,false,true],["Decor-Non-Lin-"+ac+"-"+ad]);if(ah.nlfit[ad].type=="reg"){O=a+((aL-a)/(1+aK/(Math.pow(aK,aJ))))}else{O=a+((aL-a)/(1+(Math.pow((aK/aK),aJ))))}if(this.xAxisTransform){aK=this.xAxisTransform=="percentile"?this.percentile(f,N,aK):this.transformValue(this.xAxisTransform,aK)}I=Z+((aK-this.xAxisMin)*this.xAxisUnit);g=(V+this.y)-((O-this.yAxisMin)*this.yAxisUnit);var av=this.addToRender(["drawLine","dottedLine",Z,g,I,g,M],["Decor-Non-Lin-EC-h"+ac+"-"+ad]);this.addToRender(["drawLine","dottedLine",I,g,I,(V+this.y),M],["Decor-Non-Lin-EC-v"+ac+"-"+ad],false,av)}}}if(ah.line){for(var ad=0;ad<ah.line.length;ad++){if(ah.line[ad].x!=null||ah.line[ad].y!=null){var M=ah.line[ad].color?ah.line[ad].color:this.colors[ad%this.colors.length];var ak=ah.line[ad].type?ah.line[ad].type:"line";var P=ah.line[ad].x!=null?ah.line[ad].x:null;var O=ah.line[ad].y!=null?ah.line[ad].y:null;var E=ah.line[ad].x2!=null?ah.line[ad].x2:null;var b=ah.line[ad].y2!=null?ah.line[ad].y2:null;var R=ah.line[ad].width?ah.line[ad].width:1;var I,g,G,e;if(P!=null&&O!=null&&E!=null&&b!=null){I=Z+((P-this.xAxisMin)*this.xAxisUnit);G=Z+((E-this.xAxisMin)*this.xAxisUnit);g=V+this.y-((O-this.yAxisMin)*this.yAxisUnit);e=V+this.y-((b-this.yAxisMin)*this.yAxisUnit);this.addToRender(["drawLine",ak,I,g,G,e,M,R],["Decor-Line-"+ad])}else{if(P!=null){I=Z+((P-this.xAxisMin)*this.xAxisUnit);g=V;G=I;e=g+this.y;this.addToRender(["drawLine",ak,I,g,G,e,M,R],["Decor-Line-"+ad])}else{if(O!=null){I=Z;g=V+this.y-((O-this.yAxisMin)*this.yAxisUnit);G=I+this.x;e=g;this.addToRender(["drawLine",ak,I,g,G,e,M,R],["Decor-Line-"+ad])}}}}}}if(ah.reg){for(var ad=0;ad<ah.reg.length;ad++){if(ah.reg[ad].slope&&ah.reg[ad].intercept){var o=ah.reg[ad].fit?ah.reg[ad].fit:this.colors[ad%this.colors.length];var M=ah.reg[ad].color?ah.reg[ad].color:this.colors[ad%this.colors.length];var H=this.addColorTransparency(M,0.3);var m=this.getPropertyValue(ad,false,"patternBy");var ai=ah.reg[ad].style?ah.reg[ad].style:this.fitLineStyle;var aE=Number(ah.reg[ad].slope);var af=Number(ah.reg[ad].intercept);var aa=ah.reg[ad].id;var J=ah.reg[ad].cor;var v="y ~ "+this.formatNumber(aE)+"x + "+this.formatNumber(af)+" (r = "+this.formatNumber(J)+")";var S=ah.reg[ad].ci;var K=S.length-1;var I=this.showRegressionFullRange||!S?this.xAxisMin:S[0][0];var g=(aE*I)+af;var G=this.showRegressionFullRange||!S?this.xAxisMax:S[K][0];var e=(aE*G)+af;I=Z+(I*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);g=(V+this.y)-(g*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);G=Z+(G*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);e=(V+this.y)-(e*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);this.addToRender(["drawLine",ai,I,g,G,e,o,2],["Decor-Reg-"+ad,aa]);if(S){var z=[];var s=[];var ao=[];for(var ac=0;ac<S.length;ac++){I=Z+(S[ac][0]*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);g=(V+this.y)-(S[ac][1]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);e=(V+this.y)-(S[ac][2]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);z.push([I,I]);s.push([g,e]);ao.push([I,(g+e)/2])}if(this.showConfidenceIntervals){this.addToRender(["drawShape","confidence",z,s,false,false,H,M,m],[v+":Confidence",aa],false,null,false,ao)}}}}}if(ah.nor){for(var ad=0;ad<ah.nor.length;ad++){if(ah.nor[ad].mu&&ah.nor[ad].sigma){var D=[];var C=[];var aw=[];var I,g;var M=ad%this.colors.length;var ap=ah.nor[ad].mu;var am=ah.nor[ad].sigma;var q=ah.nor[ad].start?ah.nor[ad].start:ah.nor[ad].yAxis?this.yAxisMin:this.xAxisMin;var ae=ah.nor[ad].end?ah.nor[ad].end:ah.nor[ad].yAxis?this.yAxisMax:this.xAxisMax;var aq=120;if(q<ap&&ap<ae){var aB,ar,r,c;var Q=(ap-q)/aq;var u=am*am;var U=u*2;var ag=1/Math.sqrt(2*Math.PI*u);if(ah.nor[ad].yAxis){r=ah.nor[ad].max?ah.nor[ad].max*this.xAxisUnit:this.x-(this.x*this.axisExtension);c=r/ag;aB=q;for(var ac=0;ac<aq-1;ac++){ar=(ag*Math.pow(Math.E,-Math.pow(aB-ap,2)/u));aw.push([aB,ar]);I=Z+(ar*c);g=(V+this.y)-(aB*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);D.push(I);C.push(g);aB+=Q}Q=(ae-ap)/aq;aB=ap;for(var ac=0;ac<aq;ac++){ar=(ag*Math.pow(Math.E,-Math.pow(aB-ap,2)/u));aw.push([aB,ar]);I=Z+(ar*c);g=(V+this.y)-(aB*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);D.push(I);C.push(g);aB+=Q}M=ah.nor[ad].color?ah.nor[ad].color:this.colors[M];this.addToRender(["drawShape","path",D,C,false,false,M,M,"open",false,false,true],["Decor-Nor-"+ad])}else{r=ah.nor[ad].max?ah.nor[ad].max*this.yAxisUnit:this.y-(this.y*this.axisExtension);c=r/ag;aB=q;for(var ac=0;ac<aq-1;ac++){ar=(ag*Math.pow(Math.E,-Math.pow(aB-ap,2)/u));aw.push([aB,ar]);I=Z+(aB*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);g=(V+this.y)-(ar*c);D.push(I);C.push(g);aB+=Q}Q=(ae-ap)/aq;aB=ap;for(var ac=0;ac<aq;ac++){ar=(ag*Math.pow(Math.E,-Math.pow(aB-ap,2)/u));aw.push([aB,ar]);I=Z+(aB*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);g=(V+this.y)-(ar*c);D.push(I);C.push(g);aB+=Q}M=ah.nor[ad].color?ah.nor[ad].color:this.colors[M];this.addToRender(["drawShape","path",D,C,false,false,M,M,"open",false,false,true],["Decor-Nor-"+ad])}}}}}if(ah.area){for(var ad=0;ad<ah.area.length;ad++){if(ah.area[ad].type&&ah.area[ad].x&&ah.area[ad].y&&ah.area[ad].width&&ah.area[ad].height){if(this.isValidShape(ah.area[ad].type)){var I=Z+(ah.area[ad].x*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);var g=(V+this.y)-(ah.area[ad].y*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);var M=ah.area[ad].color?ah.area[ad].color:this.colors[ad%this.colors.length];var p=ah.area[ad].width*this.xAxisUnit;var aj=ah.area[ad].height*this.yAxisUnit;this.addToRender(["drawShape",ah.area[ad].type,I,g,p,aj,M,ah.area[ad].outline,ah.area[ad].pattern,ah.area[ad].rotate],["Decor-Area-"+ad])}}}}if(ah.kaplanMeier){var I,g,G,e,aF,aD,Y,X,M,H,al,aG,aI,aH,au,av;for(var ad=0;ad<ah.kaplanMeier.length;ad++){al=[[],[]];aG=[[],[]];aI=[[],[]];M=ah.kaplanMeier[ad].color;H=this.addColorTransparency(M,0.3);I=Z;g=(V+this.y)-(this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);G=Z+(ah.kaplanMeier[ad].data.times[0]*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);e=(V+this.y)-(ah.kaplanMeier[ad].data.data[0][3]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);aD=(V+this.y)-(ah.kaplanMeier[ad].data.data[0][4]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);X=(V+this.y)-(ah.kaplanMeier[ad].data.data[0][5]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);aH=I;au=g;av=this.addToRender(["drawLine","line",I,g,G,g,M,false,false,false,false,true],["Decor-KM-h-0-"+ad],false,null,false,[aH,au,aH,au]);this.addToRender(["drawLine","line",G,g,G,e,M,false,false,false,false,true],["Decor-KM-v-0-"+ad],false,av,false,[aH,au,aH,au]);if(this.showConfidenceIntervals){al[0].push(I,G,G);al[1].push(g,g,aD);aG[0].push(I,G,G);aG[1].push(g,g,X)}for(var ac=1;ac<ah.kaplanMeier[ad].data.times.length;ac++){I=Z+(ah.kaplanMeier[ad].data.times[ac-1]*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);g=(V+this.y)-(ah.kaplanMeier[ad].data.data[ac-1][3]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);aF=(V+this.y)-(ah.kaplanMeier[ad].data.data[ac-1][4]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);Y=(V+this.y)-(ah.kaplanMeier[ad].data.data[ac-1][5]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);G=Z+(ah.kaplanMeier[ad].data.times[ac]*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);e=(V+this.y)-(ah.kaplanMeier[ad].data.data[ac][3]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);aD=(V+this.y)-(ah.kaplanMeier[ad].data.data[ac][4]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);X=(V+this.y)-(ah.kaplanMeier[ad].data.data[ac][5]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);this.addToRender(["drawLine","line",I,g,G,g,M,false,false,false,false,true],["Decor-KM-h-"+ac+"-"+ad],false,av,false,[aH,au,aH,au]);this.addToRender(["drawLine","line",G,g,G,e,M,false,false,false,false,true],["Decor-KM-h-"+ac+"-"+ad],false,av,false,[aH,au,aH,au]);if(this.showConfidenceIntervals){al[0].push(I,G,G);al[1].push(aF,aF,aD);aG[0].push(I,G,G);aG[1].push(Y,Y,X)}}if(this.showConfidenceIntervals){aI[0]=al[0].concat(aG[0].reverse());aI[1]=al[1].concat(aG[1].reverse());this.addToRender(["drawShape","polygon",aI[0],aI[1],false,false,H,H,"closed"],["Decor-KM-Conf"+ad])}}}}else{if(ah.line){for(var ad=0;ad<ah.line.length;ad++){var I,g,G,e;var an=true;var ak=ah.line[ad].type||"line";var A=ah.line[ad].color;var T=this.transformValue(this.isTransformedData,ah.line[ad].value||0);var n=ah.line[ad].label||false;var at=ah.line[ad].width||1;var aC=ah.line[ad].align||"left";if(this.graphOrientation=="vertical"){I=this.marginLeft+this.offsetX+this.left;G=I+this.x;g=this.marginTop+this.offsetY+this.top+this.y-((T-this.xAxisMin)*this.xAxisUnit);e=g;an=g<=this.marginTop+this.offsetY+this.top+this.y&&g>=this.marginTop+this.offsetY+this.top?true:false}else{I=this.marginLeft+this.offsetX+this.left+((T-this.xAxisMin)*this.xAxisUnit);G=I;g=this.marginTop+this.offsetY+this.top;e=g+this.y;an=I<=this.marginLeft+this.offsetX+this.left+this.x&&this.marginLeft+this.offsetX+this.left?true:false}if(an){if(n){if(this.graphOrientation=="vertical"){if(aC=="right"){this.addToRender(["drawText",n,G-this.margin,e-this.margin,this.decorationFont,this.decorationColor,"right","bottom"])}else{if(aC=="center"){this.addToRender(["drawText",n,I+(this.x/2),e-this.margin,this.decorationFont,this.decorationColor,"center","bottom"])}else{this.addToRender(["drawText",n,I+this.margin,e-this.margin,this.decorationFont,this.decorationColor,"left","bottom"])}}}else{if(aC=="right"){this.addToRender(["drawText",n,G+(this.margin*2),e-this.margin,this.decorationFont,this.decorationColor,"left","middle"])}else{if(aC=="center"){this.addToRender(["drawText",n,G+(this.margin*2),g+(this.y/2),this.decorationFont,this.decorationColor,"left","middle"])}else{this.addToRender(["drawText",n,G+(this.margin*2),g+this.margin,this.decorationFont,this.decorationColor,"left","middle"])}}}}this.addToRender(["drawLine",ak,I,g,G,e,A,at],["Decor-Line"+ad])}}}if(ah.marker){this.drawMarkers()}}}};this.drawOncoprintLegend=function(){this.functionCaller="drawOncoprintLegend";if(this.isOncoprint){var a=this.marginLeft+this.offsetX+this.left+15;var g=this.marginTop+this.offsetY+this.top+this.y+this.bottom+this.margin-30;var d=this.measureText("Amplification",this.legendFont);var i=this.measureText("Deletion",this.legendFont);var f=this.measureText("Mutation",this.legendFont);if(this.legendOncoprintX&&this.legendOncoprintY){a=this.legendOncoprintX;g=this.legendOncoprintY}else{if(this.showLegend){if(!this.legendInside&&this.legendPosition=="bottom"){g-=this.legendHeight}}}this.legendOncoprintCurX=a;this.legendOncoprintCurY=g;var h=this.legendOncoprintCurX-10;var e=g-20;var c=100+d+i+f+(this.margin*2);var b=30+(this.margin*2);this.addToRender(["drawShape","rect",h+(c/2),e+(b/2),c,b,this.background,this.background],[-1],["-legend-oncoprint"]);this.addToRender(["drawShape","rect",a,g,10,30,"rgb(255,0,0)"],["Onc-Amplification"]);a=a+10+this.margin;this.addToRender(["drawText","Amplification",a,g,this.legendFont,this.legendColor,"left","middle"]);a=a+d+25;this.addToRender(["drawShape","rect",a,g,10,30,"rgb(0,0,255)"],["Onc-Deletion"]);a=a+10+this.margin;this.addToRender(["drawText","Deletion",a,g,this.legendFont,this.legendColor,"left","middle"]);a=a+i+25;this.addToRender(["drawShape","rect",a,g,10,30,"rgb(220,220,220)"],["Onc-Mutation"]);this.addToRender(["drawShape","rect",a,g,10,10,"rgb(0,153,0)"]);a=a+10+this.margin;this.addToRender(["drawText","Mutation",a,g,this.legendFont,this.legendColor,"left","middle"])}};this.drawStockIndicatorsLegend=function(){this.functionCaller="drawStockIndicatorsLegend";var d=this.marginLeft+this.offsetX+this.left;var n=this.marginTop+this.offsetY+this.top;if(this.summaryType=="candle"&&this.stockIndicators.length>0){var a=this.getFontPt(this.legendFont);var f=a/2;var b=this.measureText(this.getMaxText(this.stockIndicators),this.legendFont)+a+(this.margin*2);var k=this.graphOrientation=="vertical"?d+(this.margin*2):d+this.x-b;var j=n+this.margin+a;for(var e=0;e<this.stockIndicators.length;e++){var g=this.getTechnicalIndicatorColor(this.stockIndicators[e]);this.addToRender(["drawLine","line",k+f,j+f,k+f+a,j+f,g,false,"butt",false,false,true]);this.addToRender(["drawText",this.stockIndicators[e],k+a+this.margin,j+f,this.legendFont,g,"left","middle"]);j+=this.margin+a}}};this.drawSampleLegend=function(b,m){this.functionCaller="drawSampleLegend";var l=b;var d=m;var r=this.getFontPt(this.legendFont);var q=(r-1)/2;m+=this.margin+q;this.drawLegendBackgroundBox(l,d,this.legendSampleWidth,this.legendSampleHeight,true,"-legend-sample");var o=Math.max(this.xAxisIndices.length,this.yAxisIndices.length);for(var f=0;f<o;f++){var c=f%this.colors.length;var p=0;var j=this.getPropertyValue(f,false,"patternBy");var h=this.xAxisIndices.length==this.yAxisIndices.length?this.yAxis[f]:this.xAxisIndices.length>this.yAxisIndices.length?this.yAxis[this.yAxisCurrent]:this.yAxis[f];var k=this.xAxisIndices.length==this.yAxisIndices.length?this.xAxis[f]:this.xAxisIndices.length>this.yAxisIndices.length?this.xAxis[f]:this.xAxis[this.xAxisCurrent];var g=this.xAxisIndices.length==this.yAxisIndices.length?"Series:"+this.xAxisIndices[f]+":"+this.yAxisIndices[f]:this.xAxisIndices.length>this.yAxisIndices.length?"Series:"+this.xAxisIndices[f]+":0":"Series:0:"+this.yAxisIndices[f];var n=this.isHistogram?this.shortenText(h,this.maxSmpStringLen):this.shortenText(h,this.maxSmpStringLen)+" vs "+this.shortenText(k,this.maxSmpStringLen);var e=b+q+this.margin;var a=m+q+this.margin;if(this.colorBy){this.addToRender(["drawShape",this.shapes[p],e,m,r-1,r-1,this.background,this.colors[c],"open"],[g])}else{this.addToRender(["drawShape",this.shapes[p],e,m,r-1,r-1,this.colors[c],this.foreground,j],[g])}this.addToRender(["drawText",n,e+q+this.margin,m,this.legendFont,this.legendColor,"left","middle"],[g]);m+=r+this.margin}this.drawLegendBackgroundBox(l,d,this.legendSampleWidth,this.legendSampleHeight)};this.drawVariableLegend=function(D,c){this.functionCaller="drawVariableLegend";var q=D;var F=c;var p=this.getFontPt(this.legendFont);var v=p/2;var a=p*2;var d=p*1.5;var w=0;var k=this;var l=function(i){if(i<k.xAxisVarIndices.length){return k.colors[i%k.colors.length]}else{return k.colors[(i-k.xAxisVarIndices.length)%k.colors.length]}};if(this.legendVariableWidth==0||this.legendVariableHeight==0){return}else{if(this.graphType=="Circular"&&this.circularType=="sunburst"){return}else{if(this.graphType=="Pie"){this.drawLegendBackgroundBox(q,F,this.legendVariableWidth,this.legendVariableHeight,true,"-legend-variable");var C=!this.layoutComb?this.width-(D+(this.margin*1.5)):this.isDOE?this.layoutWidth-((D-this.offsetX)+(this.margin*1.5)):999999;D+=v+this.margin;c+=p;for(var z=0;z<this.varPie.ids.length;z++){var f=false;var o=this.varPie.ids[z];var g=this.varPie.cols[z];var s=o>-1?this.shortenText(this.data.y.vars[o],this.maxVarStringLen):"Other";this.addToRender(["drawShape","square",D,c,p,p,g,this.foreground,"closed"],["PieVar-"+o]);if(C>0){while(this.measureText(s,this.legendFont)>C&&s.length>1){s=s.substring(0,s.length-1);f=true}if(f){s=s+"..."}this.addToRender(["drawText",s,D+p,c,this.legendFont,this.legendColor,"left","middle"],["PieVar-"+o])}c+=p+this.margin;if(this.layoutComb){if((c-this.offsetY)>this.layoutHeight){this.addToRender(["drawText","...",D+p,c,this.legendFont,this.legendColor,"left","bottom"]);break}}else{if(c>this.height){this.addToRender(["drawText","...",D+p,c,this.legendFont,this.legendColor,"left","bottom"]);break}}}this.drawLegendBackgroundBox(q,F,this.legendVariableWidth,this.legendVariableHeight)}else{if((this.colorBy&&this.colorBy=="variable")||(this.shapeBy&&this.shapeBy=="variable")||(this.sizeBy&&this.sizeBy=="variable")||(this.patternBy&&this.patternBy=="variable")){this.drawLegendBackgroundBox(q,F,this.legendVariableWidth,this.legendVariableHeight,true,"-legend-variable");var y=this.sizeBy&&this.sizeBy=="variable"?Math.max(this.sizes[this.varIndices.length-1],p):p;var E=y/2;var B=this.legendVariableWidth/this.legendColumns;var b=Math.ceil(this.varIndices.length/this.legendColumns);c+=this.margin+this.margin;for(var z=0;z<b;z++){for(var u=0;u<this.legendColumns;u++){D=q+(this.margin+(B*u));if(w<this.varIndices.length){var o=this.varIndices[w];var g=this.graphType=="Circular"||(this.colorBy&&this.colorBy=="variable")?w%this.colors.length:0;var r=this.shapeBy&&this.shapeBy=="variable"?w%this.shapes.length:0;var x=this.sizeBy&&this.sizeBy=="variable"?this.sizes[w%this.sizes.length]:y;var n=this.patternBy&&this.patternBy=="variable"?this.patterns[w%this.patterns.length]:this.getPropertyValue(o,false,"patternBy");var m=D+E;var A=c+E;var s=this.shortenText(this.data.y.vars[o],this.maxVarStringLen);if(this.colorBy&&this.colorBy!="variable"){this.addToRender(["drawShape",this.shapes[r],m,c,x,x,this.background,this.foreground,n],["Var-"+o])}else{this.addToRender(["drawShape",this.shapes[r],m,c,x,x,this.colors[g],this.foreground,n],["Var-"+o])}this.addToRender(["drawText",s,m+E+this.margin,c,this.legendFont,this.legendColor,"left","middle"],["Var-"+o])}else{break}w++}c+=y+this.margin}this.drawLegendBackgroundBox(q,F,this.legendVariableWidth,this.legendVariableHeight)}else{if(this.graphType=="BarLine"||this.graphType=="DotLine"||this.graphType=="AreaLine"||this.graphType=="StackedLine"||this.graphType=="StackedPercentLine"){this.drawLegendBackgroundBox(q,F,this.legendVariableWidth,this.legendVariableHeight,true,"-legend-variable");var h=this.xAxisVarIndices.concat(this.xAxis2VarIndices);var B=this.legendVariableWidth/this.legendColumns;var b=Math.ceil(h.length/this.legendColumns);c+=this.margin;for(var z=0;z<b;z++){for(var u=0;u<this.legendColumns;u++){D=q+this.margin+(B*u);if(w<h.length){var o=w<this.xAxisVarIndices.length?this.xAxisVarIndices[w]:this.xAxis2VarIndices[w-this.xAxisVarIndices.length];var g=this.coordinateLineColor?l(w):this.getVariableColor(this.data.y.vars[o]);var n=this.getPropertyValue(o,false,"patternBy");var s=this.shortenText(this.data.y.vars[o],this.maxVarStringLen);if(w<this.xAxisVarIndices.length){this.addToRender(["drawShape","rectangle",D+(p/2),c+(p/2),p,p,g,this.foreground,n],["Var-"+o]);this.addToRender(["drawText",s,D+a,c+v,this.legendFont,this.legendColor,"left","middle"],["Var-"+o])}else{this.addToRender(["drawLine","line",D,c+v,D+p,c+v,g],["Var-"+o]);if(this.lineDecoration){}this.addToRender(["drawText",s,D+a,c+v,this.legendFont,this.legendColor,"left","middle"],["Var-"+o])}}else{break}w++}c+=d}this.drawLegendBackgroundBox(q,F,this.legendVariableWidth,this.legendVariableHeight)}else{if(this.graphType=="Bar"||this.graphType=="Line"||this.graphType=="ParallelCoordinates"||this.graphType=="Area"||this.graphType=="Dotplot"||this.graphType=="Stacked"||this.graphType=="StackedPercent"||this.graphType=="Boxplot"){this.drawLegendBackgroundBox(q,F,this.legendVariableWidth,this.legendVariableHeight,true,"-legend-variable");var B=this.legendVariableWidth/this.legendColumns;var b=Math.ceil(this.varIndices.length/this.legendColumns);c+=this.margin;for(var z=0;z<b;z++){for(var u=0;u<this.legendColumns;u++){D=q+this.margin+(B*u);if(w<this.varIndices.length){var o=this.varIndices[w];var g=this.getVariableColor(this.data.y.vars[o]);var n=this.getPropertyValue(o,false,"patternBy");var s=this.shortenText(this.data.y.vars[o],this.maxVarStringLen);if(this.graphType=="Line"||this.graphType=="ParallelCoordinates"){this.addToRender(["drawLine","line",D,c+v,D+p,c+v,g],["Var-"+o]);if(this.lineDecoration){this.addToRender(["drawShape",this.lineDecoration=="symbol"?this.shapes[w%this.shapes.length]:"circle",D+v,c+v,v,v,g,g,n],["Var-"+o])}}else{if(this.graphType=="Dotplot"||(this.graphType=="Boxplot"&&this.showBoxplotOriginalData)){if(this.shapeBy){this.addToRender(["drawShape",this.shapes[w%this.shapes.length],D+v,c+v,p,p,g,this.foreground,n],["Var-"+o])}else{this.addToRender(["drawShape","circle",D+v,c+v,p,p,g,this.foreground,n],["Var-"+o])}}else{this.addToRender(["drawShape","rectangle",D+(p/2),c+(p/2),p,p,g,this.foreground,n],["Var-"+o]);if(this.graphType=="Boxplot"){this.addToRender(["drawLine","line",D,c+(p/2),D+p,c+(p/2),this.foreground])}}}this.addToRender(["drawText",s,D+a,c+v,this.legendFont,this.legendColor,"left","middle"],["Var-"+o])}else{break}w++}c+=d}this.drawLegendBackgroundBox(q,F,this.legendVariableWidth,this.legendVariableHeight)}else{if(this.graphType=="Circular"&&!this.showIdeogram){var t=this.r/2.7;if(this.legendVariableWidth>t||this.legendVariableHeight>t){return}this.drawLegendBackgroundBox(q,F,this.legendVariableWidth,this.legendVariableHeight,true,"-legend-variable");var e=[];if(this.rAxisIndex>=0){for(var z=0;z<this.varIndices.length;z++){if(z==this.rAxisIndex){continue}e.push(this.varIndices[z])}}else{e=this.varIndices}var B=this.legendVariableWidth/this.legendColumns;var b=Math.ceil(e.length/this.legendColumns);c+=this.margin;for(var z=0;z<b;z++){for(var u=0;u<this.legendColumns;u++){D=q+this.margin+(B*u);if(w<e.length){var o=e[w];var g=this.colors[w%this.colors.length];var n=this.getPropertyValue(o,false,"patternBy");var s=this.shortenText(this.data.y.vars[o],this.maxVarStringLen);this.addToRender(["drawShape","rectangle",D+(p/2),c+(p/2),p,p,g,this.foreground,n],["Var-"+o]);this.addToRender(["drawText",s,D+a,c+v,this.legendFont,this.legendColor,"left","middle"],["VarLbl-"+o])}else{break}w++}c+=d}this.drawLegendBackgroundBox(q,F,this.legendVariableWidth,this.legendVariableHeight)}}}}}}}};this.drawVennLegend=function(){this.functionCaller="drawVennLegend";if(this.showLegend){var j=this.getFontPt(this.legendFont);var d=this.vennMarginLeft+this.marginLeft+this.left;var c=d+(j*2);var g=this.vennMarginTop+this.marginTop+this.top+this.y+this.margin+(j/2);var h=[];var a=[];for(var f in this.data.venn.legend){a.push(f)}a=a.sort();if(this.vennGroups==4){h.push(this.vennColors.length>0&&this.validateColor(this.vennColors[0])?this.validateColor(this.vennColors[0]):"rgb(255,0,0)");h.push(this.vennColors.length>1&&this.validateColor(this.vennColors[1])?this.validateColor(this.vennColors[1]):"rgb(0,153,51)");h.push(this.vennColors.length>2&&this.validateColor(this.vennColors[2])?this.validateColor(this.vennColors[3]):"rgb(153,204,0)");h.push(this.vennColors.length>3&&this.validateColor(this.vennColors[3])?this.validateColor(this.vennColors[2]):"rgb(0,0,255)")}else{if(this.vennGroups==3){h.push(this.vennColors.length>0&&this.validateColor(this.vennColors[0])?this.validateColor(this.vennColors[0]):"rgb(255,0,0)");h.push(this.vennColors.length>1&&this.validateColor(this.vennColors[1])?this.validateColor(this.vennColors[1]):"rgb(0,255,0)");h.push(this.vennColors.length>2&&this.validateColor(this.vennColors[2])?this.validateColor(this.vennColors[2]):"rgb(0,0,255)")}else{if(this.vennGroups==2){h.push(this.vennColors.length>0&&this.validateColor(this.vennColors[0])?this.validateColor(this.vennColors[0]):"rgb(0,0,255)");h.push(this.vennColors.length>1&&this.validateColor(this.vennColors[1])?this.validateColor(this.vennColors[1]):"rgb(255,0,0)")}else{h.push(this.vennColors.length>0&&this.validateColor(this.vennColors[0])?this.validateColor(this.vennColors[0]):"rgb(255,0,0)")}}}for(var f=0;f<this.vennGroups;f++){if(!this.vennLegendColors){this.addToRender(["drawText",a[f]+": ",d,g,this.legendFont,this.legendColor,"left","middle"])}var b=this.data.venn.legend&&this.data.venn.legend[a[f]]?this.data.venn.legend[a[f]]:"N/A";var e=(this.measureText(b,this.legendFont)>this.x)?this.scaleTextToFont(b,j,this.x-this.margin):this.legendFont;if(!this.vennLegendColors){this.addToRender(["drawText",b,c,g,e,this.legendColor,"left","middle"])}else{this.addToRender(["drawText",b,d,g,e,h[f],"left","middle"])}g+=this.margin+j}}};this.drawColorIndicator=function(B,f,o,H,E,g){this.functionCaller="drawColorIndicator";if(g||E||this.colorBy||this.outlineBy||this.colorNodeBy||this.colorEdgeBy||this.colorNodeBy||this.colorEdgeBy||(this.graphType=="Network"&&this.decorations.length&&this.decorationsType=="heatmap"&&this.showDecorations&&!this.colorNodeBy&&!this.colorEdgeBy)){var r=H||this.colorBy||this.outlineBy||this.colorNodeBy||this.colorEdgeBy;var m=g?"-legend-"+g+"-color":E?"-legend-indicator-color":"-legend-color";var h=g?"overlaysLegendPosition":E?"heatmapIndicatorPosition":"legendPosition";var G=g?g:E?0:this.legendColorWidth?this.legendColorWidth/2:10;var s=B;var F=f;var b=0;var A=this.heatmapIndicatorHeight;var e=this.heatmapIndicatorHeight;var u=o.min;var y=o.max;var a=o.decs;var q=o.vals;var p=this.heatmapIndicatorWidth/(y-u);var D=this.graphType=="Circular"?o:o.colorBrew?o.colorBrew:this.meta.def.colorBrew;var l=this.heatmapIndicatorWidth/this.colorSpectrumNumber;var t=h=="overlaysLegendPosition"&&this[h]=="topRight"?true:false;var d=this.heatmapIndicatorHeight+(this.getFontPt(this.legendFont)*((r)?2:1))+(this.margin*2);if(this[h]&&this[h].toString().match(/top|bottom/)&&!t){this.drawLegendBackgroundBox(s-(this.margin*2),F-this.margin,this.heatmapIndicatorWidth+(this.margin*3)+this.legendFontSize,d,true,"-legend-indicator-color",false,true);if(r){this.addToRender(["drawText",r,B+(this.heatmapIndicatorWidth/2),f,this.legendFont,this.legendColor,"center","top"]);b=this.margin+this.getFontPt(this.legendFont);f+=b}for(var x=0;x<this.colorSpectrumNumber;x++){var n=D.stops&&D.stops.length>0?this.getColorForValue(D,D.breaks[x]):D.legend[x];var C=this.transparency!=null?this.addColorTransparency(n,this.transparency):n;this.addToRender(["drawLine","line",B,f,B,f+e,C,Math.round(l+1.5)]);B+=l}B=s;f+=e;if(D.stops&&D.stops.length>0){var z=B+(this.measureText(D.breaks[0].toString(),this.legendFont)/2);this.addToRender(["drawText",D.breaks[0],B,f,this.legendFont,this.legendColor,"center","top"]);for(var x=0;x<D.stops.length-1;x++){for(var w=0;w<this.colorSpectrumNumber;w++){if(D.breaks[w]>=D.stops[x]){B=s+(w*l);var k=(this.measureText(D.breaks[x].toString(),this.legendFont)/2);if(B-k>z){this.addToRender(["drawText",D.stops[x],B,f,this.legendFont,this.legendColor,"center","top"]);z=B+k}break}}}B=s+(this.colorSpectrumNumber*l);this.addToRender(["drawText",D.stops[D.stops.length-1],B,f,this.legendFont,this.legendColor,"center","top"])}else{this.addToRender(["drawText",u,B,f,this.legendFont,this.legendColor,"center","top"]);B=s+(this.heatmapIndicatorWidth/2);this.addToRender(["drawText",(u+y)/2,B,f,this.legendFont,this.legendColor,"center","top"]);B=s+((this.colorSpectrumNumber-1)*l);this.addToRender(["drawText",y,B,f,this.legendFont,this.legendColor,"center","top"])}if(this.graphType=="Heatmap"&&this.heatmapIndicatorHistogram){this.drawHeatmapIndicatorHistogram(s,F+b)}}else{this.drawLegendBackgroundBox(s,F,this.legendColorWidth,this.heatmapIndicatorWidth+(this.margin*3)+this.legendFontSize,true,m,false,true);if(r){this.addToRender(["drawText",r,B+G+this.margin,f,this.legendFont,this.legendColor,"center","top"]);f+=(this.margin*1.5)+this.getFontPt(this.legendFont)}for(var x=0;x<this.colorSpectrumNumber;x++){var C=this.transparency!=null?this.addColorTransparency(D.legend[x],this.transparency):D.legend[x];this.addToRender(["drawLine","line",B,f,B+A,f,C,Math.round(l+1.5)]);f+=l}B+=A;if(r){f=F+(this.margin*1.5)+this.getFontPt(this.legendFont)}else{f=F}for(var x=0;x<q.length;x++){if(q[x]>=u&&q[x]<=y){var e=f+((q[x]-u)*p);this.addToRender(["drawText",q[x],B+this.margin,e,this.legendFont,this.legendColor,"left","middle"])}}}}};this.drawHeatmapIndicatorHistogram=function(x,b){this.functionCaller="drawHeatmapIndicatorHistogram";var w,a;var o=x;var z=b+this.heatmapIndicatorHeight;var y=[];for(var u=0;u<this.data.y.vars.length;u++){for(var s=0;s<this.data.y.smps.length;s++){var g=this.getDataAtPos(u,s,false,this.xAxisTransform,this.xAxisFloorValue,this.xAxisCeilValue);if(g!=null&&g!=""&&!isNaN(g)){y.push(g)}}}var k=this.range(y);var m=this[this.histogramSizeEstimator](y);var r=k[0];var t=k[1];var q=Math.ceil((t-r)/m);var e=[];for(var u=0;u<q;u++){e[u]=0}for(var u=0;u<this.data.y.vars.length;u++){for(var s=0;s<this.data.y.smps.length;s++){var g=this.getDataAtPos(u,s,false,this.xAxisTransform,this.xAxisFloorValue,this.xAxisCeilValue);if(g!=null&&g!=""&&!isNaN(g)){var n=parseInt((g-r)/m);e[n]++}}}r=0;t=0;for(var u=0;u<q;u++){r=Math.min(r,e[u]);t=Math.max(t,e[u])}var l=this.legendFont;var h=this[this.axisAlgorithm](r,t,3,this.axisWilkinsonLoose);var p=this.getMaxText(h);var f=(this.heatmapIndicatorWidth-1)/q;var c=this.heatmapIndicatorHeight/h[h.length-1];if(this.heatmapIndicatorPosition=="topLeft"){l=this.scaleTextToFont(p,this.getFontPt(this.legendFont),this.left-(this.heatmapIndicatorWidth+(this.margin*3)))}for(var u=0;u<h.length;u++){b=(h[u]*c);this.addToRender(["drawLine","line",o-this.margin,z-b,o,z-b,this.foreground]);this.addToRender(["drawText",h[u],o-(this.margin*1.5),z-b,l,this.legendColor,"right","middle"])}b=(e[0]*c);this.addToRender(["drawLine","line",o,z,o,z-b,this.heatmapIndicatorHistogramColor]);for(var u=0;u<q;u++){b=(e[u]*c);this.addToRender(["drawLine","line",o,z-b,o+f,z-b,this.heatmapIndicatorHistogramColor]);if(u<q-1){a=(e[u+1]*c);this.addToRender(["drawLine","line",o+f,z-b,o+f,z-a,this.heatmapIndicatorHistogramColor])}o+=f}this.addToRender(["drawLine","line",o,z-a,o,z,this.heatmapIndicatorHistogramColor])};this.isDrawPropertyLegend=function(a){if(a){if(this.graphType=="Network"){return(this[a+"By"]&&this.meta.data.edges[this[a+"By"]])||(this[a+"By"]&&this.meta.data.nodes[this[a+"By"]])}else{return(this[a+"By"]&&this.isMultidimensionalData)||(this[a+"By"]&&((this.data.x&&this.data.x.hasOwnProperty(this[a+"By"]))||(this.data.z&&this.data.z.hasOwnProperty(this[a+"By"]))||this.getSampleIndices(this[a+"By"])>-1))}}else{if(this.graphType=="Network"){return(this.colorEdgeBy&&this.meta.data.edges[this.colorEdgeBy])||(this.colorNodeBy&&this.meta.data.nodes[this.colorNodeBy])||(this.decorations.length&&this.decorationsType=="heatmap")}else{return(this.outlineBy&&this.isMultidimensionalData)||(this.colorBy&&((this.data.x&&this.data.x.hasOwnProperty(this.colorBy))||(this.data.z&&this.data.z.hasOwnProperty(this.colorBy))||this.getSampleIndices(this.colorBy)>-1))}}};this.drawColorLegend=function(a,b,d,c){if(this.isMap){a+=parseInt(this.meta.canvas.ctx2.canvas.style.left);b+=parseInt(this.meta.canvas.ctx2.canvas.style.top)}if(this.isDrawPropertyLegend()){if(d.type=="Numeric"&&!d.colorBy){this.drawColorIndicator(a,b,d)}else{this.drawPropertyLegend(c,a,b,d)}}};this.drawShapeLegend=function(a,b,d,c){this.drawPropertyLegend(c,a,b,d)};this.drawSizeLegend=function(a,b,d,c){this.drawPropertyLegend(c,a,b,d)};this.drawPatternLegend=function(a,b,d,c){this.drawPropertyLegend(c,a,b,d)};this.drawPropertyLegend=function(f,B,h,q){this.functionCaller="drawPropertyLegend";var t=this.decapitalize(f);if(this.isDrawPropertyLegend(t)){var C=f.replace("Node","").replace("Edge","")=="Size"?0:this.getDiameterLegend();if(f.replace("Node","").replace("Edge","")=="Size"){for(var A=0;A<(this.legendSizesN||q.levels.length);A++){C=Math.max(C,q.sizes?q.sizes[A]:this.sizes[A])}}var v=this.getFontPt(this.legendFont);var j=v/2;var b=this.legendColumns>this["legend"+f+"sN"]?this["legend"+f+"sN"]:this.legendColumns;var e=Math.ceil(this["legend"+f+"sN"]/b);var m=this["legend"+f+"Width"]/b;var g=h+this.margin+j;var z=Math.max(C,v);var l=this.graphType=="Boxplot"?"rectangle":"circle";var x=0;this.drawLegendBackgroundBox(B,h,this["legend"+f+"Width"],this["legend"+f+"Height"],true,"-legend-"+t);var F=f.replace("Node","").replace("Edge","")=="Color"&&this.outlineBy?this.outlineBy:this[t+"By"];if(this.showLegendTitle){this.addToRender(["drawText",F,B+(this["legend"+f+"Width"]/2),g,this.legendFont,this.legendColor,"center","middle"]);g+=j+this.margin;this.disableGradientTransparencyShadow();if(this.legendBox){this.addToRender(["drawLine","line",B,g,B+this["legend"+f+"Width"],g,this.legendBoxColor])}this.enableGradientTransparencyShadow();g+=this.margin+(z/2)}var a=this["legend"+f+"sS"]||this.sortObject(this["legend"+f+"s"]);var E=q.origin?q.origin:this.meta.data.modified?"modified":"y";for(var s=0;s<e;s++){for(var D=0;D<b;D++){var n=B+this.margin+C/2+(m*D);if(x<this["legend"+f+"sN"]){var w=a[x];if(f.replace("Node","").replace("Edge","")=="Color"){var k=q.colorBy&&q.colorBy.hasOwnProperty(w)?q.colorBy[w]:this.legendColors?this.legendColors[w]:q.colors[x];if(this.outlineBy){this.addToRender(["drawShape",l,n,g,C,C,false,k,"open",false,2],["Property:"+F+":"+w+":"+E])}else{this.addToRender(["drawShape",l,n,g,C,C,k,this.foreground,"closed"],["Property:"+F+":"+w+":"+E])}}else{if(f.replace("Node","").replace("Edge","")=="Shape"){var u=q.shapeBy&&q.shapeBy.hasOwnProperty(w)?q.shapeBy[w]:this.legendShapes?this.legendShapes[w]:q.shapes[x];this.addToRender(["drawShape",u,n,g,C,C,this.background,this.foreground,"closed"],["Property:"+F+":"+w+":"+E])}else{if(f.replace("Node","").replace("Edge","")=="Size"){var y=q.sizeBy&&q.sizeBy.hasOwnProperty(w)?q.sizeBy[w]:this.legendSizes?this.legendSizes[w]:q.sizes[x];if(q.rmax==q.max&&q.rmin==q.min){this.addToRender(["drawShape",l,n,g,y,y,this.background,this.foreground,"closed"],["Property:"+F+":"+w+":"+E])}else{this.addToRender(["drawShape",l,n,g,y,y,this.background,this.foreground,"closed"])}}else{if(f.replace("Node","").replace("Edge","")=="Pattern"){var o=q.patternBy&&q.patternBy.hasOwnProperty(w)?q.patternBy[w]:this.legendPatterns?this.legendPatterns[w]:q.patterns[x];this.addToRender(["drawShape","square",n,g,C,C,this.background,this.foreground,o],["Property:"+F+":"+w+":"+E])}}}}if(this.graphType=="Boxplot"){this.addToRender(["drawLine","line",n-(C/2),g,n+(C/2),g,this.foreground])}this.addToRender(["drawText",w,n+(z/2)+this.margin,g,this.legendFont,this.legendColor,"left","middle"],["Property:"+F+":"+w+":"+E])}x++}g+=this.margin+z}this.drawLegendBackgroundBox(B,h,this["legend"+f+"Width"],this["legend"+f+"Height"])}};this.drawCustomLegend=function(C,a,j,E,u){this.functionCaller="drawCustomLegend";var w=u.text.length;var y=this.getDiameterLegend();var q=u.size;if(q){for(var z=0;z<q.length;z++){if(q[z]){y=Math.max(y,q[z])}}}var f=this.getFontPt(this.legendFont);var b=f/2;var k=this.legendColumns>w?w:this.legendColumns;var d=Math.ceil(w/k);var l=j/k;var B=a+this.margin+b;var p=Math.max(y,f);var g=0;this.drawLegendBackgroundBox(C,a,j,E,true,"-legend-"+u.id);if(u.title){this.addToRender(["drawText",u.title,C+(j/2),B,this.legendFont,this.legendColor,"center","middle"]);B+=b+this.margin;this.disableGradientTransparencyShadow();if(this.legendBox){this.addToRender(["drawLine","line",C,B,C+j,B,this.legendBoxColor])}this.enableGradientTransparencyShadow();B+=this.margin+(p/2)}else{B+=(p/2)-b}var x=false;for(var t=0;t<d;t++){for(var D=0;D<k;D++){var m=C+this.margin+y/2+(l*D);if(g<w){if(u.shape&&u.shape[g]){var o=u.size[g]||y;var D=u.shapeColor[g]||this.background;this.addToRender(["drawShape",u.shape[g],m,B,o,o,D,D,"closed"]);x=true}if(u.line&&u.line[g]){var o=u.size[g]||y;var A=o/2;var D=u.lineColor[g]||this.background;var e=u.lineStart&&u.lineStart[g]?u.lineStart[g]:false;var v=u.lineEnd&&u.lineEnd[g]?u.lineEnd[g]:false;this.addToRender(["drawLine",u.line[g],m-A,B,m+A,B,D,false,false,false,false,false,false,false,e,v]);x=true}if(x){this.addToRender(["drawText",u.text[g],m+(p/2)+this.margin,B,this.legendFont,this.legendColor,"left","middle"])}else{this.addToRender(["drawText",u.text[g],m+(j/2),B,this.legendFont,this.legendColor,"center","middle"])}}g++}B+=this.margin+p}this.drawLegendBackgroundBox(C,a,j,E)};this.drawGenericLegend=function(s,p,n,y,q,A,o){this.functionCaller="drawGenericLegend";var u=this.getDiameterLegend();var d=this.getFontPt(this.legendFont);var r=Math.max(u,d);var b=r/2;var e=0;this.drawLegendBackgroundBox(s,p,n,y,true,"-legend");this.addToRender(["drawText",A,s+(n/2),p+this.margin+(d/2),this.legendFont,this.legendColor,"center","middle"]);e=p+d+(this.margin*2);if(this.legendBox){this.addToRender(["drawLine","line",s,e,s+n,e,this.legendBoxColor])}e+=this.margin;if(!o){o=1}var c=n/o;var f=Math.ceil(q.levels.length/o);var g=0;var a=e;var k=q.origin?q.origin:this.meta.data.modified?"modified":"y";for(var x=0;x<f;x++){for(var v=0;v<o;v++){var z=s+this.margin+(c*v);if(g<q.levels.length){var m=q.type=="String"?q.colors[g]:this.getColorForValue(q.colorBrew,q.levels[g]);this.addToRender(["drawShape","square",z+(u/2),a+(r/2),u,u,m,this.foreground],["Property:"+A+":"+q.levels[g]+":"+k]);this.addToRender(["drawText",q.levels[g],z+u+this.margin,a+(r/2),this.legendFont,this.legendColor,"left","middle"],["Property:"+A+":"+q.levels[g]+":"+k])}else{break}g++}a+=r+this.margin}this.drawLegendBackgroundBox(s,p,n,y)};this.drawDecorationLegend=function(e,s){this.functionCaller="drawDecorationLegend";if(this.graphType.match(/Scatter/)){var p,o;var m=this.decorations;var u=this.getFontPt(this.decorationFont);var c=this.measureText(sprintf("%15s","X"),this.decorationFont);var r=m.nlfit||m.nor||m.reg?c:0;var n=e+(r?this.legendDecorationMaxLabel+c:this.margin);var a=n;var g=s;var q=g;this.legendDecorationCurX=e;this.legendDecorationCurY=s;this.drawLegendBackgroundBox(e,(s-((u/2)+this.margin)),this.legendDecorationWidth,this.legendDecorationHeight+this.margin,true,"-legend-decorations",true);if(m.nlfit){this.addToRender(["drawText","Min",a,q,this.decorationFont,this.decorationsColor,"right","middle"]);a+=c+this.margin;this.addToRender(["drawText","Max",a,q,this.decorationFont,this.decorationsColor,"right","middle"]);a+=c+this.margin;this.addToRender(["drawText","EC50",a,q,this.decorationFont,this.decorationsColor,"right","middle"]);a+=c+this.margin;this.addToRender(["drawText","Slope",a,q,this.decorationFont,this.decorationsColor,"right","middle"]);a+=c+this.margin;this.addToRender(["drawText","p-Val",a,q,this.decorationFont,this.decorationsColor,"right","middle"]);a+=c+this.margin;this.addToRender(["drawText","F-Chg",a,q,this.decorationFont,this.decorationsColor,"right","middle"]);q+=u+u;for(var k=0;k<m.nlfit.length;k++){var f=k%this.colors.length;f=m.nlfit[k].color?m.nlfit[k].color:this.colors[f];a=(n+this.margin)-c;if(this.graphType=="ScatterBubble2D"&&this.decorationsPosition=="right"&&this.zAxisShow){a+=this.margin+this.getFontPt(this.axisTitleFont)+this.margin}this.addToRender(["drawText",m.nlfit[k].label,a,q,this.decorationFont,f,"right","middle"]);a=n;for(var h=0;h<6;h++){var b=m.nlfit[k].param[h];if(h<2){b=this.transformValue(this.yAxisTransform,b)}else{if(h==2){}}this.addToRender(["drawText",this.formatNumber(b),a,q,this.decorationFont,this.decorationsColor,"right","middle"]);a+=c+this.margin}q+=u+u}}if(m.line){for(var k=0;k<m.line.length;k++){if(m.line[k].label){for(var k=0;k<m.line.length;k++){var f=m.line[k].color?m.line[k].color:this.colors[k%this.colors.length];if(this.graphType=="ScatterBubble2D"&&this.decorationsPosition=="right"&&this.zAxisShow){a+=this.margin+this.getFontPt(this.axisTitleFont)+this.margin}this.addToRender(["drawText",m.line[k].label,a,q,this.decorationFont,f,"left","middle"]);q+=u+u}}}}if(m.reg){this.addToRender(["drawText","Slope",a,q,this.decorationFont,this.decorationsColor,"right","middle"]);a+=c+this.margin;this.addToRender(["drawText","Int",a,q,this.decorationFont,this.decorationsColor,"right","middle"]);a+=c+this.margin;this.addToRender(["drawText","Cor",a,q,this.decorationFont,this.decorationsColor,"right","middle"]);q+=u+u;for(var k=0;k<m.reg.length;k++){var f=m.reg[k].color?m.reg[k].color:this.colors[k%this.colors.length];a=(n+this.margin)-c;if(this.graphType=="ScatterBubble2D"&&this.decorationsPosition=="right"&&this.zAxisShow){a+=this.margin+this.getFontPt(this.axisTitleFont)+this.margin}this.addToRender(["drawText",m.reg[k].label,a,q,this.decorationFont,f,"right","middle"]);a=n;this.addToRender(["drawText",this.formatNumber(m.reg[k].slope),a,q,this.decorationFont,this.decorationsColor,"right","middle"]);a+=c+this.margin;this.addToRender(["drawText",this.formatNumber(m.reg[k].intercept),a,q,this.decorationFont,this.decorationsColor,"right","middle"]);a+=c+this.margin;this.addToRender(["drawText",this.formatNumber(m.reg[k].cor),a,q,this.decorationFont,this.decorationsColor,"right","middle"]);a+=c+this.margin;q+=u+u}}if(m.nor){this.addToRender(["drawText","Mu",a,q,this.decorationFont,this.decorationsColor,"right","middle"]);a+=c+this.margin;this.addToRender(["drawText","Sigma",a,q,this.decorationFont,this.decorationsColor,"right","middle"]);q+=u+u;for(var k=0;k<m.nor.length;k++){var f=k%this.colors.length;f=m.nor[k].color?m.nor[k].color:this.colors[f];a=(n+this.margin)-c;if(this.graphType=="ScatterBubble2D"&&this.decorationsPosition=="right"&&this.zAxisShow){a+=this.margin+this.getFontPt(this.axisTitleFont)+this.margin}this.addToRender(["drawText",m.nor[k].label,a,q,this.decorationFont,f,"right","middle"]);a=n;this.addToRender(["drawText",this.formatNumber(m.nor[k].mu),a,q,this.decorationFont,this.decorationsColor,"right","middle"]);a+=c+this.margin;this.addToRender(["drawText",this.formatNumber(m.nor[k].sigma),a,q,this.decorationFont,this.decorationsColor,"right","middle"]);a+=c+this.margin;q+=u+u}}if(m.area){for(var k=0;k<m.area.length;k++){if(m.area[k].label){var f=m.area[k].color?m.area[k].color:this.colors[k%this.colors.length];if(this.graphType=="ScatterBubble2D"&&this.decorationsPosition=="right"&&this.zAxisShow){a+=this.margin+this.getFontPt(this.axisTitleFont)+this.margin}this.addToRender(["drawText",m.area[k].label,a,q,this.decorationFont,f,"left","middle"]);q+=u+u}}}if(m.kaplanMeier){for(var k=0;k<m.kaplanMeier.length;k++){if(m.kaplanMeier[k].label){var f=m.kaplanMeier[k].color?m.kaplanMeier[k].color:this.colors[k%this.colors.length];if(this.graphType=="ScatterBubble2D"&&this.decorationsPosition=="right"&&this.zAxisShow){a+=this.margin+this.getFontPt(this.axisTitleFont)+this.margin}this.addToRender(["drawText",m.kaplanMeier[k].label,a,q,this.decorationFont,f,"left","middle"]);q+=u+u}}}this.drawLegendBackgroundBox(e,(s-((u/2)+this.margin)),this.legendDecorationWidth,this.legendDecorationHeight+this.margin,false,false,true)}};this.resetLegends=function(c){if(c){delete (this.legendDecorationCurX);delete (this.legendDecorationCurY);delete (this.legendDecorationX);delete (this.legendDecorationY)}var a=this.graphType=="Network"?["ColorNode","ShapeNode","SizeNode","PatternNode","ColorEdge","SizeEdge"]:this.scatterPlotMatrix?["Color","Shape","Size","Pattern","Variable"]:["Color","Shape","Size","Pattern","Variable","Sample"];for(var b=0;b<a.length;b++){this["legend"+a[b]+"Width"]=0;this["legend"+a[b]+"Height"]=0;if(c){delete (this["legend"+a[b]+"CurX"]);delete (this["legend"+a[b]+"CurY"]);delete (this["legend"+a[b]+"X"]);delete (this["legend"+a[b]+"Y"])}}delete (this.legendColorIndicatorCurX);delete (this.legendColorIndicatorCurY)};this.getXYLegendCoords=function(u,b,z){var r,p,a;var v=-1;var g=-1;var k=this;var n=function(){for(var l=0;l<k.legendLayout.length;l++){if(k.legendLayout[l]){for(var h=0;h<k.legendLayout[l].length;h++){if(k.legendLayout[l][h]==u){return[l,h]}}}}return[-1,-1]};if(this.legendLayout){var m=n();v=m[0];g=m[1];if(v>-1&&g>-1){var o=0;var d=0;if(this.legendPosition.match(/right|left/i)){for(var e=0;e<v;e++){var s=0;for(var c=0;c<this.legendLayout[e].length;c++){s=Math.max(s,this["legend"+this.legendLayout[e][c]+"Width"]+this.margin)}o+=s}for(var c=0;c<this.legendLayout[v].length;c++){d+=this["legend"+this.legendLayout[v][c]+"Height"]+this.margin}}else{for(var e=0;e<v;e++){var f=0;for(var c=0;c<this.legendLayout[e].length;c++){f=Math.max(f,this["legend"+this.legendLayout[e][c]+"Height"]+this.margin)}d+=f}for(var c=0;c<this.legendLayout[v].length;c++){o+=this["legend"+this.legendLayout[v][c]+"Width"]+this.margin}}if(this.graphType=="Circular"){r=b;p=z}else{if(this.graphType=="Network"){r=b+o;p=z;b=g==this.legendLayout[v].length-1?b+o:b;z=p+this["legend"+this.legendLayout[v][g]+"Height"]+this.margin}else{if(this.legendPosition.match(/right|left/i)){z=g==0&&(this.scatterPlotMatrix||this.layoutValid)?this.marginTop+this.layoutTop:g==0?this.marginTop+this.offsetY+this.top:z;r=b+o;a=this.legendPosition.match(/top/)?this.margin:this.legendPosition.match(/bottom/)?this.y-(d+this.margin):((this.y-d)/2);p=g==0&&(this.scatterPlotMatrix||this.layoutValid)?(this.height-d)/2:g==0?this.marginTop+this.offsetY+this.top+a:z;b=g==this.legendLayout[v].length-1?b+o:b;z=p+this["legend"+this.legendLayout[v][g]+"Height"]+this.margin}else{b=g==0&&(this.scatterPlotMatrix||this.layoutValid)?this.marginLeft+this.layoutLeft:g==0?this.marginLeft+this.offsetX+this.left:b;r=g==0&&(this.scatterPlotMatrix||this.layoutValid)?(this.width-o)/2:g==0?this.marginLeft+this.offsetX+this.left+((this.x-o)/2)+this.margin:b+this.margin;p=z+d;b=r+this["legend"+this.legendLayout[v][g]+"Width"]+this.margin;z=g==this.legendLayout[v].length-1?z+d:z}}}}}return[r,p,b,z]};this.getVariableLegendPosition=function(){var c,h;if(this.graphType=="Pie"){if(this.legendPosition=="right"||this.legendPosition=="left"){if(this.isDOE){c=this.legendPosition=="left"?this.marginLeft+this.offsetX+this.margin:this.marginLeft+this.offsetX+this.left+this.x-(this.margin*3);h=this.marginTop+this.offsetY+this.top+(this.y/2)-(this.legendVariableHeight/2)}else{c=this.legendPosition=="left"?this.margin:this.width-(this.marginRight+this.legendVariableWidth+this.margin);h=(this.height/2)-(this.legendVariableHeight/2)}}else{c=(this.width/2)-(this.legendVariableWidth/2);h=this.legendPosition=="top"?this.marginBottom+(this.top-this.legendVariableHeight+this.margin):this.height-(this.marginBottom+this.legendVariableHeight+this.margin)}}else{if(this.graphType=="Treemap"||this.graphType=="TagCloud"){return[0,0]}else{if(this.graphType=="Circular"){c=this.width-(this.marginRight+this.legendVariableWidth+this.margin);h=this.height-(this.marginBottom+this.legendVariableHeight+this.margin);return[c,h]}else{if(this.layoutValid){var d=this.width-(this.marginLeft+this.layoutLeft+this.layoutRight+this.marginRight);var b=this.height-(this.marginTop+this.layoutTop+this.layoutBottom+this.marginBottom);var j=this.legendVariableHeight+this.legendOverlaysHeight+this.margin;var e=this.legendVariableWidth+this.legendOverlaysWidth+this.margin;c=this.legendPosition=="right"?this.width-(this.marginRight+e):this.legendPosition=="left"?this.marginLeft+this.margin:this.marginLeft+this.layoutLeft+(d/2)-(e/2);h=this.legendPosition=="bottom"?this.height-(this.marginBottom+j):this.legendPosition=="top"?this.marginTop+this.margin+this.getTitleSubtitleHeight():this.marginTop+this.layoutTop+(b/2)-(j/2)}else{var f=this.marginLeft+this.offsetX+this.left;var k=this.marginTop+this.offsetY+this.top;var a=this.legendVariableHeight;var i=this.legendVariableWidth;if(this.legendInside){switch(this.legendPosition){case"bottomRight":c=f+this.x-(i+this.margin);h=k+this.y-(a+this.margin);break;case"bottom":c=f+(this.x/2)-(i/2);h=k+this.y-(a+this.margin);break;case"bottomLeft":c=f+this.margin;h=k+this.y-(a+this.margin);break;case"left":c=f+this.margin;h=k+(this.y/2)-(a/2);break;case"topLeft":c=f+this.margin;h=k+this.margin;break;case"top":c=f+(this.x/2)-(i/2);h=k+this.margin;break;case"topRight":c=f+this.x-(i+this.margin);h=k+this.margin;break;default:c=f+this.x-(i+this.margin);h=k+(this.y/2)-(a/2)}}else{var m=this.overlaysLegendPosition.match(/top|bottom/i)?this.legendOverlaysHeight:0;var g=this.overlaysLegendPosition.match(/right|left/i)?this.legendOverlaysWidth:0;switch(this.legendPosition){case"bottom":c=f+(this.x/2)-(i/2);h=k+this.y+this.bottom-(a+m+this.margin);break;case"top":c=f+(this.x/2)-(i/2);h=this.marginTop+this.offsetY+this.margin+this.getTitleSubtitleHeight();break;case"left":c=this.marginLeft+this.offsetX+this.margin;h=k+(this.y/2)-(a/2);break;default:c=f+this.x+this.right-(i+g+this.margin);h=k+(this.y/2)-(a/2)}}}}}}return[c,h]};this.getScatterLegendPosition=function(){var h=0;var f=0;var e=0;var b=0;var a=0;var g=0;var c=this.marginLeft+this.offsetX+this.left+this.margin;var i=this.marginTop+this.offsetY+this.top+this.margin;if(this.scatterPlotMatrix||this.layoutValid){if(this.legendPosition=="left"){e=this.marginLeft+this.margin}else{e=this.width+this.margin-(this.marginRight+(this.legendWidth||0))}if(this.legendPosition=="top"){b=this.marginTop+this.margin+this.getTitleSubtitleHeight()}else{b=this.height+this.margin-(this.marginBottom+(this.legendHeight||0))}h=e-(this.legendDecorationWidth+this.margin);f=b-(this.legendDecorationHeight+this.margin)}else{if(this.graphType=="Network"){if(this.maxX-this.minX>this.maxY-this.minY){e=this.margin;b=this.margin*5}else{e=this.width-(this.legendWidth+this.margin);b=this.margin*5}}else{if(this.graphType=="Circular"){if(this.circularType=="sunburst"&&this.colorBy){e=this.legendPosition=="top"?this.marginLeft+this.left:this.width-(this.legendColorWidth+this.right+this.marginRight);b=this.legendPosition=="top"?this.marginTop+this.top:this.height-(this.legendColorHeight+this.bottom+this.marginBottom)}else{e=this.legendPosition=="top"?this.marginLeft+this.left:this.width-(this.legendVariableWidth+this.right+this.marginRight);b=this.legendPosition=="top"?this.marginTop+this.top:this.height-(this.legendVariableHeight+this.bottom+this.marginBottom)}}else{if(this.legendInside){if(this.legendDecorationWidth>0&&this.legendDecorationHeight>0){var d=this.legendDecorationWidth+(this.margin*2);switch(this.decorationsPosition){case"bottomRight":h=c+this.x-d;f=i+this.y-(this.legendDecorationHeight+this.margin);break;case"bottom":h=c+(this.x/2)-(this.legendDecorationWidth/2);f=i+this.y-(this.legendDecorationHeight+this.margin);break;case"bottomLeft":h=c+this.margin;f=i+this.y-(this.legendDecorationHeight+this.margin);break;case"left":h=c+this.margin;f=i+(this.y/2)-(this.legendDecorationHeight/2);break;case"topLeft":h=c+this.margin;f=i+(this.margin*2);break;case"top":h=c+(this.x/2)-(this.legendDecorationWidth/2);f=i+(this.margin*2);break;case"topRight":h=c+this.x-d;f=i+(this.margin*2);break;default:h=c+this.x-d;f=i+(this.y/2)-(this.legendDecorationHeight/2);break}}if(this.legendWidth>0&&this.legendHeight>0){switch(this.legendPosition){case"bottomRight":e=c+this.x-this.legendWidth;b=i+this.y-this.legendHeight;break;case"bottom":e=c+(this.x/2)-(this.legendWidth/2);b=i+this.y-this.legendHeight;break;case"bottomLeft":e=c;b=i+this.y-this.legendHeight;break;case"left":e=c;b=i+(this.y/2)-(this.legendHeight/2);break;case"topLeft":e=c;b=i;break;case"top":e=c+(this.x/2)-(this.legendWidth/2);b=i;break;case"topRight":e=c+this.x-this.legendWidth;b=i;break;default:e=c+this.x-this.legendWidth;b=i+(this.y/2)-(this.legendHeight/2);break}}}else{switch(this.decorationsPosition){case"bottom":h=c+(this.x/2)-(this.legendDecorationWidth/2);f=i+this.y+this.bottom-this.legendDecorationHeight;break;default:h=c+this.x+this.right-(this.legendDecorationWidth+(this.margin*2));f=i+(this.y/2)-(this.legendDecorationHeight/2);break}a=this.legendPosition==this.decorationsPosition?this.legendDecorationWidth:0;g=this.legendPosition==this.decorationsPosition?this.legendDecorationHeight:0;switch(this.legendPosition){case"bottom":e=c+(this.x/2)-(this.legendWidth/2);b=i+this.y+this.bottom-(this.legendHeight+(g?g+this.margin:0));if(this.graphType=="Scatter3D"||this.is3DPlot){b+=this.legendHeight}break;case"top":e=c+(this.x/2)-(this.legendWidth/2);b=this.marginTop+this.offsetY+this.margin+this.getTitleSubtitleHeight();if(this.graphType=="Scatter3D"||this.is3DPlot){b+=this.legendHeight}break;case"left":e=this.marginLeft+this.offsetX+this.margin;b=i+(this.y/2)-(this.legendHeight/2);if(this.graphType=="Scatter3D"||this.is3DPlot){e+=this.legendWidth}break;default:e=c+this.x+this.right-(this.legendWidth+a);b=i+(this.y/2)-(this.legendHeight/2);if(this.graphType=="Scatter3D"||this.is3DPlot){e+=this.legendWidth}break}}}}}return[h,f,e,b]};this.drawIndicator=function(a,b,c){delete (this.legendColorIndicatorCurX);delete (this.legendColorIndicatorCurY);this.drawColorIndicator(a,b,false,c)};this.drawLegend=function(a){if(this.graphType=="Venn"){this.drawVennLegend()}else{if(this.graphType=="Circular"){if(this.circularType=="sunburst"){this.drawScatterLegend(a)}else{this.drawOverlaysLegend();var b=this.getVariableLegendPosition();this.drawVariableLegend(b[0],b[1])}}else{if(this.graphType=="Network"){this.drawScatterLegend()}else{if(this.graphType.match(/Scatter/)||this.is3DPlot||((this.colorBy||this.shapeBy||this.sizeBy||this.patternBy)&&this.graphType.match(/^Bar$|Boxplot|Dotplot|Treemap|TagCloud|ParallelCoordinates|Sankey|Tree|Line|Heatmap|Stacked|Map/))){this.drawScatterLegend(a);if(this.isOncoprint){this.drawOncoprintLegend()}this.drawOverlaysLegend()}else{this.draw1DLegend();this.drawOverlaysLegend()}}}}};this.draw1DLegend=function(){this.drawStockIndicatorsLegend();if(this.showLegend&&((this.graphType!="Heatmap")||(this.graphType=="Heatmap"&&(this.colorBy||this.shapeBy||this.sizeBy||this.patternBy)))){if(this.isMultidimensionalData||((this.colorBy||this.shapeBy||this.sizeBy||this.patternBy)&&this.graphType.match(/^Bar$|Boxplot|Dotplot|Treemap|TagCloud|ParallelCoordinates|Sankey|Tree|Line|Heatmap|Stacked/))){if(this.isOncoprint){this.drawOncoprintLegend()}this.drawScatterLegend()}else{if(this.graphType=="Treemap"||this.graphType=="TagCloud"){return}var c=this.getVariableLegendPosition();var a=c[0];var b=c[1];if(this.legendVariableX&&this.legendVariableY){a=this.legendVariableX;b=this.legendVariableY}this.legendVariableCurX=a;this.legendVariableCurY=b;this.drawVariableLegend(a,b)}}else{if(this.isOncoprint){this.drawOncoprintLegend()}}};this.drawOverlaysLegend=function(){var s,e;if(this.overlaysLegendPosition.match(/right/i)){s=this.layoutValid?this.marginTop+this.layoutTop:this.marginTop+this.offsetY+this.top;if(this.overlaysLegendPosition=="right"){s+=(this.y/2)-(this.legendOverlaysHeight/2)}e=this.layoutValid?this.width-(this.marginRight+this.layoutRight+this.legendOverlaysWidth):this.width-(this.marginRight+this.legendOverlaysWidth)}else{s=this.layoutValid?this.height-(this.marginBottom+this.layoutBottom+this.legendOverlaysHeight):this.height-(this.marginBottom+this.legendOverlaysHeight);e=this.layoutValid?this.marginLeft+this.layoutLeft:this.marginLeft+this.offsetX+this.left;if(this.overlaysLegendPosition=="bottom"){e+=(this.x/2)-(this.legendOverlaysWidth/2)}}var v=s;var f=e;for(var k=0;k<this.legendOverlaysLayout.length;k++){var n=this.legendOverlaysLayout[k];var r,b,d,a;var u=mw=0;var p=mh=0;for(var g=0;g<n.length;g++){r=n[g][0];b=n[g][1];mw=Math.max(u,n[g][2]);mh=Math.max(p,n[g][3])}for(var g=0;g<n.length;g++){r=n[g][0];b=n[g][1];d=this.meta.data[r][b];u=this["legend"+b+"Width"];p=this["legend"+b+"Height"];a=r=="z"?this.varOverlaysLegendColumns:this.smpOverlaysLegendColumns;if(d.type=="String"){this.drawGenericLegend(f,v,u,p,d,b,a)}else{this.drawColorIndicator(f,v,d,b,false,u/2)}if(this.overlaysLegendPosition.match(/right/i)){v+=p+this.margin}else{f+=u+this.margin}}if(this.overlaysLegendPosition.match(/right/i)){f+=mw+this.margin;v=s}else{f=e;v+=mh+this.margin}}};this.drawScatterLegend=function(e){var l=this.getScatterLegendPosition();if(this.showDecorations&&this.showDecorationsLegend&&this.decorations&&!this.layoutValid){if(this.legendDecorationX!=null&&this.legendDecorationY!=null){this.drawDecorationLegend(this.legendDecorationX,this.legendDecorationY)}else{this.drawDecorationLegend(l[0],l[1])}}if(this.showLegend){var j=this.graphType=="Network"?["ColorNode","ShapeNode","SizeNode","PatternNode","ColorEdge","SizeEdge","Decoration"]:this.scatterPlotMatrix?["Color","Shape","Size","Pattern","Variable"]:["Color","Shape","Size","Pattern","Variable","Sample"];var d=l[2];var n=l[3];for(var f=0;f<j.length;f++){var q=this["legend"+j[f]+"Width"];var g=this["legend"+j[f]+"Height"];var p=this["legend"+j[f]+"X"];var k=this["legend"+j[f]+"Y"];if(q>0){if(e){this.setPropertyLegendDimensions(j[f]);q=this["legend"+j[f]+"Width"];g=this["legend"+j[f]+"Height"]}var c=("draw"+j[f]+"Legend").replace("Node","").replace("Edge","").replace("Decoration","Color");var b=this["legend"+j[f]+"Meta"];var o=this.getXYLegendCoords(j[f],d,n);if(p&&k){this[c](p,k,b,j[f]);this["legend"+j[f]+"CurX"]=p;this["legend"+j[f]+"CurY"]=k}else{this[c](o[0],o[1],b,j[f]);this["legend"+j[f]+"CurX"]=o[0];this["legend"+j[f]+"CurY"]=o[1]}if(this.legendPosition.match(/right|left/i)){n=o[3]+this.margin}else{d=o[2]+this.margin}}}for(var f=0;f<this.legend.length;f++){if(this.graphType=="Network"&&!this.showDecorations){continue}var a="Custom"+f;var q=this["legend"+a+"Width"];var g=this["legend"+a+"Height"];var p=this["legend"+a+"X"];var k=this["legend"+a+"Y"];var o=this.getXYLegendCoords(a,d,n);if(p&&k){this.drawCustomLegend(p,k,q,g,this.legend[f]);this["legend"+a+"CurX"]=p;this["legend"+a+"CurY"]=k}else{this.drawCustomLegend(o[0],o[1],q,g,this.legend[f]);this["legend"+a+"CurX"]=o[0];this["legend"+a+"CurY"]=o[1]}if(this.legendPosition.match(/right|left/i)){n=o[3]+this.margin}else{d=o[2]+this.margin}}}};this.setMarker=function(f){var j=this;var k=function(q){var p=j.meta.render.objects;for(var m=0;m<p.length;m++){var n=p[m];if(n.type=="Data"&&n.idx){var l=n.idx.join(":");if(l==q||l==q+":false"||l==q+":true"||l==q+":box"){return n}}}return false};var c=function(){if(f.fontSize){return(f.fontStyle||"")+" "+parseInt(f.fontSize)+"px "+j.fontName}else{return j.decorationFont}};var e=this.graphType.match(/Treemap|Stacked/)?true:false;var g=this.isArray(f.variable)?this.getVariableIndices(f.variable):this.getVariableIndices([f.variable]);var h=this.isArray(f.sample)?this.getSampleIndices(f.sample,e):this.getSampleIndices([f.sample],e);var b=g.concat(h).join(":");var a=k(b);var i=a?this.centroidArea(a.area):false;var d=a?a.params[4]:false;if(!f.id){f.id=this.newId(this.target+"-marker-")}f.vi=g;f.si=h;if(!this.isArray(f.variable)){f.variable=[f.variable]}if(!this.isArray(f.sample)){f.sample=[f.sample]}if(!f.type){f.type="line"}f.b=[this.marginLeft+this.offsetX+this.left,this.marginTop+this.offsetY+this.top,this.x,this.y];f.len=this.measureText(f.text,c());f.width=this.measureTextWidth(f.text,c());f.tx=i?i[0]:false;f.ty=i&&f.type!="line"?i[1]-((d/2)+f.width):i?i[1]:false;return f};this.getMarker=function(c){if(c&&this.decorations&&this.decorations.marker){for(var b=0;b<this.decorations.marker.length;b++){var a=this.decorations.marker[b];if(c==a.id){return a}}}};this.drawMarkers=function(){this.functionCaller="drawMarkers";var k=this;var j=function(d,c,h){return d.ty>0&&d.ty<k.height&&d.tx>0&&d.tx<k.width};var b=function(){if(e.fontSize){return(e.fontStyle||"")+" "+parseInt(e.fontSize)+"px "+k.fontName}else{return k.decorationFont}};if(this.decorations&&this.decorations.marker){var l=this.decorations.marker;for(var f=0;f<l.length;f++){var e=this.setMarker(l[f]);if(e.tx&&e.ty&&e.b){var p,o;p=e.x?e.b[0]+(e.x*e.b[2]):this.graphOrientation=="vertical"?e.tx:e.tx+this.margin;o=e.y?e.b[1]+(e.y*e.b[3]):this.graphOrientation=="vertical"?e.ty-this.margin:e.ty;if(j(e,p,o)){var q=this.addToRender(["drawText",e.text,p,o,b(e),e.color||this.decorationsColor,e.align,e.baseline],"Marker:"+e.id);var a=this.meta.render.objects[q].area;if(e.type=="line"){var n=e.color||this.decorationsColor;var g;e.curX=p;e.curY=o;if(e.tx<a[1]-e.len){g=(a[2]+a[4])/2;this.addToRender(["drawLine","line",a[1]-this.margin,a[2],a[1]-this.margin,a[4],n],false,q);this.addToRender(["drawLine",e.type,e.tx,e.ty,a[1]-this.margin,g,n],false,q)}else{if(e.tx>a[3]+e.len){g=(a[2]+a[4])/2;this.addToRender(["drawLine","line",a[3]+this.margin,a[2],a[3]+this.margin,a[4],n],false,q);this.addToRender(["drawLine",e.type,e.tx,e.ty,a[3]+this.margin,g,n],false,q)}else{if(e.ty>a[4]+(e.width*0.2)){g=(a[1]+a[3])/2;this.addToRender(["drawLine","line",a[1],a[4]+this.margin,a[3],a[4]+this.margin,n],false,q);this.addToRender(["drawLine",e.type,e.tx,e.ty,g,a[4]+this.margin,n],false,q)}else{if(e.ty<a[2]-(e.width*0.2)){g=(a[1]+a[3])/2;this.addToRender(["drawLine","line",a[1],a[2]-this.margin,a[3],a[2]-this.margin,n],false,q);this.addToRender(["drawLine",e.type,e.tx,e.ty,g,a[2]-this.margin,n])}else{if(e.tx<a[1]){g=(a[2]+a[4])/2;this.addToRender(["drawLine","line",a[1]-this.margin,a[2],a[1]-this.margin,a[4],n],false,q);this.addToRender(["drawLine",e.type,e.tx,e.ty,a[1]-this.margin,g,n],false,q)}else{g=(a[2]+a[4])/2;this.addToRender(["drawLine","line",a[3]+this.margin,a[2],a[3]+this.margin,a[4],n],false,q);this.addToRender(["drawLine",e.type,e.tx,e.ty,a[3]+this.margin,g,n],false,q)}}}}}}else{e.curX=p;e.curY=o}}}}}};this.setFunctionNames("initLegendUtils")};CanvasXpress.prototype.initFilterUtils=function(){this.handleSelector=function(a){if(!this.hiddenLegends){this.hiddenLegends={}}this.hiddenLegends[a.id]=this.hiddenLegends[a.id]?false:true;switch(a.type){case"var":this.filterVariables(a.type+"s","exact",[a.name],false,true,true);break;case"smp":this.filterSamples(a.type+"s","exact",[a.name],false,true,true);break;case"series":this.filterSamples("smps","exact",a.name,false,true,true);break;case"meta":switch(a.object){case"x":this.filterSamplesByCategory(a.factor,"exact",[a.level],false,true,true);break;case"z":this.filterVariablesByCategory(a.factor,"exact",[a.level],false,true,true);break;case"modified":if(this.meta.data.modified.x&&this.meta.data.modified.x.meta&&this.meta.data.modified.x.meta[a.factor]){alert("Ooops! Needs to develop this case!")}else{if(this.meta.data.modified.z&&this.meta.data.modified.z.meta&&this.meta.data.modified.z.meta[a.factor]){this.filterUserData(["filterSmpBy"],[a.factor],["exact"],[[this.meta.data.modified.z.meta[a.factor].order[a.level]]],null,false,true,true)}}break}break}};this.filterVariables=function(g,f,b,e,d,a){this.filterUserData(["filterVarBy"],["vars"],[f],[b],null,e,d,a)};this.filterVariablesByCategory=function(g,f,b,e,d,a){this.filterUserData(["filterVarBy"],[g],[f],[b],null,e,d,a)};this.filterSamples=function(g,f,b,e,d,a){this.filterUserData(["filterSmpBy"],["smps"],[f],[b],null,e,d,a)};this.filterSamplesByCategory=function(a,g,d,f,e,b){this.filterUserData(["filterSmpBy"],[a],[g],[d],null,f,e,b)};this.filterUserData=function(j,k,e,m,d,a,b,l){this.functionCaller="filterUserData";if(this.isTransition()){return}if(a){this.resetFilters()}var g={min:">=",max:"<=",like:"like",exact:"exact"};for(var f=0;f<j.length;f++){this[j[f]].push(d!=null&&d[f]!=null?k[f]+":::"+d[f]:k[f]);this[j[f]+"Op"].push(g[e[f]]);this[j[f]+"Case"].push(false);this[j[f]+"Value"].push(m[f])}this.reset(true,b);this.filterData(true,l);if(this.isGroupedData&&this.smpIndices.length>0){this.groupSamples(this.groupingFactors,false,false,true,false,false,true)}else{this.draw()}};this.filterData=function(D,G){if(this.isDOE){return}var w={};var K={};var e={};var H=false;var E=this;var F=function(s,v,g){if(v.hasOwnProperty(s)){return v[s]}else{if(s.match(":::")){var d=s.split(":::");if(g[d[1]]){d[1]=parseInt(d[1]);for(var k=0;k<g[d[1]].length;k++){var h=g[d[1]][k];if(v.hasOwnProperty(h)){v=v[h]}else{return false}}if(v.hasOwnProperty(d[0])){return v[d[0]]}}}return false}};var z=function(j,s,h,g){if(!s){return true}if(E.filterSkipNullValues&&(j==null||j=="")){return true}if(s==">"){return parseFloat(j)-parseFloat(h)>0}else{if(s==">="){return parseFloat(j)-parseFloat(h)>0||parseFloat(j)-parseFloat(h)==0}else{if(s=="<"){return parseFloat(j)-parseFloat(h)<0}else{if(s=="<="){return parseFloat(j)-parseFloat(h)<0||parseFloat(j)-parseFloat(h)==0}else{if(s=="="||s=="=="){return parseFloat(j)-parseFloat(h)==0}else{if(s=="null"){return j==null}else{if(s=="not null"){return j!=null}else{if(s=="exact"){for(var d=0;d<h.length;d++){if(j.toString()==h[d].toString()){return true}}return false}else{if(s=="like"||s=="not like"){var k=false;if(g){for(var d=0;d<h.length;d++){if((j+"").search(h[d]+"")!=-1||h[d].toString()==j.toString()){k=true;if(s=="like"){break}}}}else{var a=(j+"").toLowerCase();for(var d=0;d<h.length;d++){var p=(h[d]+"").toLowerCase();if(a.search(p)!=-1||a.toString()==p.toString()){k=true;if(s=="like"){break}}}}return s=="like"?k:!k}}}}}}}}}};var t=function(a){if(!e[a]){e[a]=0}e[a]++};if(this.graphType=="Genome"&&this.filterFeatureBy.length>0){for(var O=0;O<this.filterFeatureBy.length;O++){if(this.filterFeatureBy[O]){for(var N=0;N<this.data.tracks.length;N++){var r=this.data.tracks[N];var l=r.data;for(var M=0;M<l.length;M++){var B=l[M];if(this.filterSkipNullKeys&&!B.hasOwnProperty(this.filterFeatureBy[O])){continue}var I=F(this.filterFeatureBy[O],B,this.featuresProperties);if(!z(I,this.filterFeatureByOp[O],this.filterFeatureByValue[O],this.filterFeatureByCase[O])){B.hide=this.filterType=="and"?true:w[N+":"+M]?false:true;K[N+":"+M]=true}else{w[N+":"+M]=true;if(this.filterType=="or"&&K[N+":"+M]){B.hide=false}}}}}}}else{if(this.graphType=="Network"&&(this.filterNodeBy.length>0||this.filterEdgeBy.length)){for(var O=0;O<this.filterNodeBy.length;O++){if(this.filterNodeBy[O]){for(var N=0;N<this.data.nodes.length;N++){if(this.filterSkipNullKeys&&!this.data.nodes[N].hasOwnProperty(this.filterNodeBy[O])){continue}if(this.data.nodes[N].hide){continue}var I=F(this.filterNodeBy[O],this.data.nodes[N],this.nodesProperties);if(!z(I,this.filterNodeByOp[O],this.filterNodeByValue[O],this.filterNodeByCase[O])){this.data.nodes[N].hide=this.filterType=="and"?true:w[this.data.nodes[N].id]?false:true;K[this.data.nodes[N].id]=true}else{w[this.data.nodes[N].id]=true;if(this.filterType=="or"&&K[this.data.nodes[N].id]){this.data.nodes[N].hide=false}}}}}for(var O=0;O<this.filterEdgeBy.length;O++){if(this.filterEdgeBy[O]){for(var N=0;N<this.data.edges.length;N++){var y=this.data.nodes[this.data.nodeIndices[this.data.edges[N].id1]];var u=this.data.nodes[this.data.nodeIndices[this.data.edges[N].id2]];var C=y.id+":"+u.id;if(this.filterSkipNullKeys&&!this.data.edges[N].hasOwnProperty(this.filterEdgeBy[O])){continue}var I=F(this.filterEdgeBy[O],this.data.edges[N],this.edgesProperties);if(!z(I,this.filterEdgeByOp[O],this.filterEdgeByValue[O],this.filterEdgeByCase[O])){this.data.edges[N].hide=this.filterType=="and"?true:w[C]?false:true;K[C]=true}else{w[C]=true;if(this.filterType=="or"&&K[C]){this.data.edges[N].hide=false}}if(!this.data.edges[N].hide){t(y.id);t(u.id)}}}}if(this.filterEdgeBy.length>0){for(var O=0;O<this.data.nodes.length;O++){var b=this.data.nodes[O];if(!e[b.id]){b.hide=true}}}}else{if(this.isCreateHistogram&&!G){if(this.filterVarBy.length>0){var R=this.dataStndBy;var P=this.data.y.histogram}}else{if(this.filterSmpBy.length>0){var S=-1;var x=[];for(var O=0;O<this.filterSmpBy.length;O++){if(this.filterSmpBy[O]){S=this.getSampleIndices(this.filterSmpBy[O]);if(S>=0){H=true;for(var N=0;N<this.varIndices.length;N++){var m=this.varIndices[N];var T=this.data.y.data[m][S];if(!z(T,this.filterSmpByOp[O],this.filterSmpByValue[O],this.filterSmpByCase[O])){x[m]=this.filterType=="and"?true:w[m]?false:true;K[m]=true}else{w[m]=true;x[m]=false}}}else{H=true;if(this.isGroupedData&&!D){for(var N=0;N<this.grpIndices.length;N++){var m=this.grpIndices[N];var T;if(this.filterSmpBy[O]=="smps"){var f=false;for(var M=0;M<this.data.w.grps[m].length;M++){T=this.data.y.smps[this.data.w.grps[m][M]];if(z(T,this.filterSmpByOp[O],this.filterSmpByValue[O],this.filterSmpByCase[O])){f=true;break}}if(!f){x[m]=this.filterType=="and"?true:w[m]?false:true;K[m]=true}else{w[m]=true;x[m]=false}}else{T=this.data.w.factors[this.filterSmpBy[O]][m];if(!z(T,this.filterSmpByOp[O],this.filterSmpByValue[O],this.filterSmpByCase[O])){x[m]=this.filterType=="and"?true:w[m]?false:true;K[m]=true}else{w[m]=true;x[m]=false}}}}else{for(var N=0;N<this.smpIndices.length;N++){var m=this.smpIndices[N];var T=this.filterSmpBy[O]=="smps"?this.data.y.smps[m]:this.getMetadataValue(m,"x",this.filterSmpBy[O],true);if(!z(T,this.filterSmpByOp[O],this.filterSmpByValue[O],this.filterSmpByCase[O])){x[m]=this.filterType=="and"?true:w[m]?false:true;K[m]=true}else{w[m]=true;x[m]=false}}}}}}if(H){var q=[];if(S>=0){if(!G){this.hiddenVars=x;for(var O=0;O<this.varIndices.length;O++){var A=this.varIndices[O];if(!this.hiddenVars[A]){q.push(A)}}this.varIndices=q}else{for(var O=0;O<this.varIndices.length;O++){var A=this.varIndices[O];this.hiddenVars[A]=this.hiddenVars[A]&&!x[A]?false:this.hiddenVars[A]?true:x[A]?false:true}}}else{if(!G){if(this.isGroupedData&&!D){this.hiddenGrps=x;for(var O=0;O<this.grpIndices.length;O++){var A=this.grpIndices[O];if(!this.hiddenGrps[A]){q.push(A)}}this.grpIndices=q}else{this.hiddenSmps=x;for(var O=0;O<this.smpIndices.length;O++){var A=this.smpIndices[O];if(!this.hiddenSmps[A]){q.push(A)}}this.smpIndices=q}}else{if(this.isGroupedData&&!D){for(var O=0;O<this.grpIndices.length;O++){var A=this.grpIndices[O];this.hiddenGrps[A]=this.hiddenGrps[A]&&!x[A]?false:this.hiddenGrps[A]?true:x[A]?false:true}}else{for(var O=0;O<this.smpIndices.length;O++){var A=this.smpIndices[O];this.hiddenSmps[A]=this.hiddenSmps[A]&&!x[A]?false:this.hiddenSmps[A]?true:x[A]?false:true}if(G&&this.data.w){var Q=this.data.w.grps;for(var O=0;O<this.grpIndices.length;O++){var A=this.grpIndices[O];this.hiddenGrps[A]=true;for(var N=0;N<Q[A].length;N++){if(!this.hiddenSmps[Q[A][N]]){this.hiddenGrps[A]=false;break}}}}}}}}}if(this.filterVarBy.length>0){var S=-1;var x=[];for(var O=0;O<this.filterVarBy.length;O++){if(this.filterVarBy[O]){S=this.getVariableIndices(this.filterVarBy[O]);if(S>=0){H=true;for(var N=0;N<this.smpIndices.length;N++){var m=this.smpIndices[N];var T=this.data.y.data[S][m];if(!z(T,this.filterVarByOp[O],this.filterVarByValue[O],this.filterVarByCase[O])){x[m]=this.filterType=="and"?true:w[m]?false:true;K[m]=true}else{w[m]=true;x[m]=false}}}else{H=true;for(var N=0;N<this.varIndices.length;N++){var m=this.varIndices[N];var T=this.filterVarBy[O]=="vars"?this.data.y.vars[m]:this.getMetadataValue(m,"z",this.filterVarBy[O]);if(!z(T,this.filterVarByOp[O],this.filterVarByValue[O],this.filterVarByCase[O])){x[m]=this.filterType=="and"?true:w[m]?false:true;K[m]=true}else{w[m]=true;x[m]=false}}}}}if(H){var q=[];if(S>=0){if(!G){this.hiddenSmps=x;for(var O=0;O<this.smpIndices.length;O++){var A=this.smpIndices[O];if(!this.hiddenSmps[A]){q.push(A)}}this.smpIndices=q}else{for(var O=0;O<this.smpIndices.length;O++){var A=this.smpIndices[O];this.hiddenSmps[A]=this.hiddenSmps[A]&&!x[A]?false:this.hiddenSmps[A]?true:x[A]?false:true}}}else{if(!G){this.hiddenVars=x;for(var O=0;O<this.varIndices.length;O++){var A=this.varIndices[O];if(!this.hiddenVars[A]){q.push(A)}}this.varIndices=q}else{for(var O=0;O<this.varIndices.length;O++){var A=this.varIndices[O];this.hiddenVars[A]=this.hiddenVars[A]&&!x[A]?false:this.hiddenVars[A]?true:x[A]?false:true}}}}}}}}if(this.layoutComb&&this.graphType!="Candlestick"&&!this.graphType.match(/Scatter/)){this.restoreEmptyCompartments();var o=this.getObjectArray(this.varIndices);var n=this.getObjectArray(this.smpIndices);for(var O=0;O<this.data.l.comp.length;O++){var L=this.layoutParams[O];var I=L.startingVarIndices;var J=L.startingSmpIndices;var U=[];if(I){for(var N=0;N<I.length;N++){if(o.hasOwnProperty(I[N])){U.push(I[N])}}L.varIndices=U}U=[];if(J){for(var N=0;N<J.length;N++){if(n.hasOwnProperty(J[N])){U.push(J[N])}}L.smpIndices=U}}}};this.resetSmpFilters=function(a){if(a!=null&&this.filterSmpBy.length>0){this.filterSmpBy.splice(a,1);this.filterSmpByOp.splice(a,1);this.filterSmpByValue.splice(a,1);this.filterSmpByCase.splice(a,1);this.filteredSmpIndices.splice(a,1)}else{this.filterSmpBy=[];this.filterSmpByOp=[];this.filterSmpByValue=[];this.filterSmpByCase=[];this.filteredSmpIndices=[]}};this.resetVarFilters=function(a){if(a!=null&&this.filterVarBy.length>0){this.filterVarBy.splice(a,1);this.filterVarByOp.splice(a,1);this.filterVarByValue.splice(a,1);this.filterVarByCase.splice(a,1);this.filteredVarIndices.splice(a,1)}else{this.filterVarBy=[];this.filterVarByOp=[];this.filterVarByValue=[];this.filterVarByCase=[];this.filteredVarIndices=[]}};this.resetNodeFilters=function(a){if(a!=null&&this.filterNodeBy.length>0){this.filterNodeBy.splice(a,1);this.filterNodeByOp.splice(a,1);this.filterNodeByValue.splice(a,1);this.filterNodeByCase.splice(a,1)}else{this.filterNodeBy=[];this.filterNodeByOp=[];this.filterNodeByValue=[];this.filterNodeByCase=[]}};this.resetEdgeFilters=function(a){if(a!=null&&this.filterEdgeBy.length>0){this.filterEdgeBy.splice(a,1);this.filterEdgeByOp.splice(a,1);this.filterEdgeByValue.splice(a,1);this.filterEdgeByCase.splice(a,1)}else{this.filterEdgeBy=[];this.filterEdgeByOp=[];this.filterEdgeByValue=[];this.filterEdgeByCase=[]}};this.resetFeatureFilters=function(a){if(a!=null&&this.filterFeatureBy.length>0){this.filterFeatureBy.splice(a,1);this.filterFeatureByOp.splice(a,1);this.filterFeatureByValue.splice(a,1);this.filterFeatureByCase.splice(a,1)}else{this.filterFeatureBy=[];this.filterFeatureByOp=[];this.filterFeatureByValue=[];this.filterFeatureByCase=[]}};this.resetFilters=function(e,d){var a=[];if(!e){a=["filterSmpBy","filterVarBy","filterNodeBy","filterEdgeBy","filterFeatureBy"]}else{a=[e]}delete (this.hiddenLegends);for(var b=0;b<a.length;b++){c=a[b];if(c=="filterSmpBy"){this.resetSmpFilters(d)}else{if(c=="filterVarBy"){this.resetVarFilters(d)}else{if(c=="filterNodeBy"){this.resetNodeFilters(d)}else{if(c=="filterEdgeBy"){this.resetEdgeFilters(d)}else{if(c=="filterFeatureBy"){this.resetFeatureFilters(d)}}}}}}};this.setFunctionNames("initFilterUtils")};CanvasXpress.prototype.initClusterUtils=function(){this.setDendrograms=function(){if(this.smpDendrogramNewick){this.smpDendrogram={};this.parseNewick(this.smpDendrogramNewick,"smpDendrogram")}if(this.varDendrogramNewick){this.varDendrogram={};this.parseNewick(this.varDendrogramNewick,"varDendrogram")}};this.parseNewick=function(a,d){var k=this;var y=0;var b=[];var u={};var c=0;var g=0;var v=0;var p=0;var j=[];var A=0;var B=0;this[d+"NodeId"]=0;var q=a.split(/\s*(;|\(|\)|,|:)\s*/);var l=function(E){var x=[];for(var D=0;D<E.length;D++){x.push(E[D].mid)}return k.mean(x)};var o=function(D){if(D.children){D.depth=g++;A=Math.max(A,D.depth);for(var x=0;x<D.children.length;x++){o(D.children[x]);if(D.children[x].children){D.children[x].mid=l(D.children[x].children)}}g--;p++}else{D.depth=g;v++}};var e=function(D){if(D.children){for(var x=0;x<D.children.length;x++){e(D.children[x]);if(D.children[x].children){D.children[x].len=1+A-D.children[x].depth}}}else{D.len=1+A-D.depth}};for(var z=0;z<q.length;z++){if(!y){var h=q[z];switch(h){case"(":var C={};u.children=[C];b.push(u);u=C;break;case",":if(b.length>0){var C={};b[b.length-1].children.push(C);u=C}else{y++}break;case")":u=b.pop();u.nodeId=this[d+"NodeId"]++;break;case":":break;default:var m=q[z-1];if(m==")"||m=="("||m==","){u.name=h;if(h&&!u.children){var s=d=="smpDendrogram"?this.getSampleIndices(h):this.getVariableIndices(h);if(s==-1){s=parseInt(h);u.name=d=="smpDendrogram"?this.data.y.smps[s]:this.data.y.vars[s];u.idx=s}else{u.idx=s}j.push(u.idx);u.ord=c++;u.mid=u.ord}}else{if(m==":"){u.height=parseFloat(h);B++}}}}else{if(y<3){this.parseNewick("("+a+")",d);return}else{alert(d+"is not in a valid Newick format");this[d]=false;if(d=="varDendrogram"){this.varDendrogramNewick=false}else{this.smpDendrogramNewick=false}return}}}o(u);e(u);u.max=A+1;u.leafs=v;u.useHeight=B==p;u.mid=l(u.children);u.axis=d;this[d]=u;var r={labl:d=="varDendrogram"?"variable":"sample",show:d=="varDendrogram"?"showVarDendrogram":"showSmpDendrogram",data:d=="varDendrogram"?"vars":"smps",indx:d=="varDendrogram"?"varIndices":"smpIndices",strt:d=="varDendrogram"?"varIndicesStart":"smpIndicesStart"};if(this[r.show]){var f;if(this[r.strt]<0){if(v!=this.data.y[r.data].length){f="Dude! The length of the "+r.labl+" nodes in the dendrogram ("+v+") is different to that one in the data ("+this.data.y[r.data].length+"). This ain't gonna work!";if(this.warnings){t.flashInfoSpan(100,100,f,3000)}this[r.show]=false}else{if(v!=this[r.indx].length){f="Ooops! Cannot show dendrogram with "+v+" nodes when only "+this[r.indx].length+" "+r.labl+" are visible.";if(this.warnings){t.flashInfoSpan(100,100,f,3000)}this[r.show]=false}else{this[r.indx]=j}}}else{var w=this[r.strt]+this[r.indx].length;this[r.indx]=[];for(var z=this[r.strt];z<w;z++){this[r.indx].push(j[z])}}}};this.writeNewick=function(b){var d="";if(b.children){var a=[];for(var c=0;c<b.children.length;c++){a.push(this.writeNewick(b.children[c]))}if(a.length>0){d="("+a.join(",")+")"}}else{d=b.idx}if(b.height){d+=":"+sprintf("%.1f",b.height)}return d};this.euclidianDistance=function(b,a,h,g){var e=this.cleanArrays(b,a,h,g);b=e[0];a=e[1];var f=0;if(b.length==a.length){for(var c=0;c<b.length;c++){f+=Math.pow(b[c]-a[c],2)}f=Math.sqrt(f)}return f};this.manhattanDistance=function(b,a,h,g){var e=this.cleanArrays(b,a,h,g);b=e[0];a=e[1];var f=0;if(b.length==a.length){for(var c=0;c<b.length;c++){f+=Math.abs(b[c]-a[c])}}return f};this.maxDistance=function(b,a,h,g){var e=this.cleanArrays(b,a,h,g);b=e[0];a=e[1];var f=0;if(b.length==a.length){for(var c=0;c<b.length;c++){f=Math.max(f,Math.abs(b[c]-a[c]))}}return f};this.classifyKmeansVector=function(f,c){var e=Number.POSITIVE_INFINITY;var a=0;for(var d=0;d<c.length;d++){var b=this[this.distance+"Distance"](f,c[d]);if(b<e){e=b;a=d}}return a};this.addVectors=function(c,b,g,f){var e=this.cleanArrays(c,b,g,f);c=e[0];b=e[1];var a=[];if(c.length==b.length){for(var d=0;d<c.length;d++){a.push(c[d]+b[d])}}return a};this.compareVectors=function(b,a){if(this.isArray(b)&&this.isArray(a)){if(b.length!=a.length){return false}for(var c=0;c<b.length;c++){if(this.isArray(b[c])&&this.isArray(a[c])){if(!this.compareArrays(b[c],a[c])){return false}}if(b[c]!==a[c]){return false}}return true}};this.vectorDotProduct=function(b,a,g,f){var d=this.cleanArrays(b,a,g,f);b=d[0];a=d[1];var e=0;if(b.length==a.length){for(var c=0;c<b.length;c++){e+=b[c]*a[c]}}return e};this.multiplyVectorByValue=function(a,d,e,c){a=this.cleanArray(a,e,c);for(var b=0;b<a.length;b++){a[b]*=d}return a};this.getCentroid=function(d,g,f,a){var h=[];if(g.length==a.length){var e=d+f;for(var b=0;b<g.length;b++){h.push((d*g[b]+f*a[b])/e)}}return h};this.createClusterNode=function(i,b,e,f,h,a){var g={id:i,left:b,right:e,dist:f,centroid:h};if(a!=null){g.mid=a}if(b==null&&e==null){g.size=1;g.depth=0}else{g.size=b.size+e.size;g.depth=1+Math.max(b.depth,e.depth)}return g};this.createRandomCentroids=function(c){var b=this;var a=c.slice(0);a.sort(function(){return(Math.round(b.random())-0.5)});return a.slice(0,this.clusterAxis=="samples"?this.kmeansSmpClusters:this.kmeansVarClusters)};this.createRandomVectors=function(d,g){var c=g.length;if(d>c){return null}var l=[];var f=[];var a={};var m=0;var o=0;var j,b;while(o<d){if(m==c){return null}var h=Math.floor(this.random()*c);if(h in a){continue}a[h]=1;m++;j=g[h];b=true;for(var e=0;e<o;e++){if(this.compareVectors(j,l[e])){b=false;break}}if(b){l[o]=j;f[o]=h;o++}}return{vectors:l,indices:f}};this.imputeDatum=function(a){var d=[];if(this.clusterAxis=="samples"){for(var b=0;b<this.varIndices.length;b++){var c=this.varIndices[b];d.push(this.data.y.data[c][a])}}else{for(var b=0;b<this.smpIndices.length;b++){var c=this.smpIndices[b];d.push(this.data.y.data[a][c])}}return this[this.imputeMethod](d)};this.getIdsForClustering=function(){var e=[];if(this.clusterAxis=="samples"){for(var b=0;b<this.smpIndices.length;b++){var c=this.smpIndices[b];var a=this.getSampleIndices(c);e[b]=a==-1?c:this.data.y.smps[c]}}else{for(var b=0;b<this.varIndices.length;b++){var c=this.varIndices[b];var a=this.getVariableIndices(c);e[b]=a==-1?c:this.data.y.smps[c]}}return e};this.getDataForClustering=function(){var h=[];var a=[];if(this.clusterAxis=="samples"){for(var c=0;c<this.smpIndices.length;c++){h[c]=[]}for(var c=0;c<this.varIndices.length;c++){var e=this.varIndices[c];for(var b=0;b<this.smpIndices.length;b++){var f=this.smpIndices[b];var g=this.data.y.data[e][f];if(isNaN(g)){if(!a[b]){a[b]=this.imputeDatum(f)}g=a[b]}h[b][c]=g}}}else{for(var c=0;c<this.varIndices.length;c++){h[c]=[]}for(var c=0;c<this.varIndices.length;c++){var e=this.varIndices[c];for(var b=0;b<this.smpIndices.length;b++){var f=this.smpIndices[b];var g=this.data.y.data[e][f];if(isNaN(g)){if(!a[c]){a[c]=this.imputeDatum(e)}g=a[c]}h[c][b]=g}}}return h};this.cluster=function(){var n=function(){var i=a[s][0].id;var d=a[r][0].id;if(i<0&&d>=0){return true}else{if(i<0&&d<0){return d>i}else{if(i>=0&&d>=0){return i>d}else{return false}}}};var h;var A=this.getDataForClustering();var w=this.getIdsForClustering();var o=[];var e=[];var C=[];var a=[];if(!this.meta.tree){this.meta.tree={}}var v=this.meta.tree;v[this.clusterAxis]=[];for(var z=0;z<A.length;z++){o[z]=[]}o[0][0]=Number.POSITIVE_INFINITY;for(var z=0;z<A.length-1;z++){for(var y=z+1;y<A.length;y++){o[y][y]=Number.POSITIVE_INFINITY;o[z][y]=this[this.distance+"Distance"](A[z],A[y]);o[y][z]=o[z][y]}}for(var z=0;z<A.length;z++){e[z]=0;for(var y=0;y<A.length;y++){if(o[z][e[z]]>o[z][y]){e[z]=y}}}for(var z=0;z<A.length;z++){a[z]=[];a[z][0]=this.createClusterNode(w[z],null,null,0,A[z]);C[z]=1}var b=-1;for(var q=0;q<A.length-1;q++){var s=0;for(var z=0;z<A.length;z++){if(o[z][e[z]]<o[s][e[s]]){s=z}}var r=e[s];if(n()){var c=r;r=s;s=c}var f=a[s][0];var u=a[r][0];var g=this.getCentroid(f.size,f.centroid,u.size,u.centroid);var B=this.createClusterNode(b,f,u,o[s][r],g);a[s].splice(0,0,B);for(var y=0;y<A.length;y++){if(this.linkage=="single"){if(o[s][y]>o[r][y]){o[y][s]=o[s][y]=o[r][y]}}else{if(this.linkage=="complete"){if(o[s][y]<o[r][y]){o[y][s]=o[s][y]=o[r][y]}}else{if(this.linkage=="average"){o[y][s]=o[s][y]=((C[s]*o[s][y])+(C[r]*o[r][y]))/(C[s]+C[r])}}}}C[s]+=C[r];o[s][s]=Number.POSITIVE_INFINITY;for(var z=0;z<A.length;z++){o[z][r]=o[r][z]=Number.POSITIVE_INFINITY}for(var y=0;y<A.length;y++){if(e[y]==r){e[y]=s}}for(var y=0;y<A.length;y++){for(var x=0;x<A.length;x++){if(o[x][y]<o[x][e[x]]){e[x]=y}}}h=B;v[this.clusterAxis].push([f.id,u.id,h.dist]);b--}return this.writeNewickCluster(h,true)};this.isLeafNode=function(a){if(a.left==null&&a.right==null){return true}else{return false}};this.writeNewickCluster=function(k,g,j){var h="";var e="";var f=false;if(this.isLeafNode(k)){f=true;if(isNaN(k.id)){h=this.clusterAxis=="variables"?this.getVariableIndices(k.id):this.getSampleIndices(k.id)}else{h=k.id}}else{var b;var c=this.writeNewickCluster(k.left,g,true);var a=this.writeNewickCluster(k.right,g,false);if(k.mid){for(var d=0;d<k.mid.length;d++){if(g&&k.mid[d].dist){e+=","+k.mid[d].id+":"+k.mid[d].dist}else{e+=","+k.mid[d].id}e+=k.mid[d].id}}h="("+c+e+","+a+")"}if(g&&!f){h+=":"+sprintf("%.1f",k.dist)}return h};this.kmeans=function(){var p=this.getDataForClustering();var q=this.createRandomCentroids(p);var m=new Array(p.length);var b=this.clusterAxis=="samples"?this.kmeansSmpClusters:this.kmeansVarClusters;var n=new Array(b);var s=0;var w=true;while(w){for(var e=0;e<p.length;e++){m[e]=this.classifyKmeansVector(p[e],q)}w=false;for(var c=0;c<b;c++){var l=[];for(var e=0;e<m.length;e++){if(m[e]==c){l.push(p[e])}}if(!l.length){continue}var o=q[c];var v=new Array(o.length);for(var f=0;f<o.length;f++){var h=0;for(var e=0;e<l.length;e++){if(!isNaN(l[e][f])){h+=l[e][f]}}v[f]=h/l.length;if(v[f]!=o[f]){w=true}}q[c]=v;n[c]=l}s++;if(s>this.maxIterations){w=false}}var r=[];for(var e=0;e<b;e++){r[e]={distance:this[this.distance+"Distance"](q[0],q[e]),assign:e}}r=r.sort(function(g,d){return g.distance-d.distance});var a={};for(var e=0;e<r.length;e++){a[r[e].assign]=e}for(var e=0;e<m.length;e++){var u=a[m[e]]+1;if(u>9){m[e]="K"+u}else{m[e]="K-0"+u}}return m};this.setFunctionNames("initClusterUtils")};CanvasXpress.prototype.initSortUtils=function(){this.sortNetworkIndices=function(h){this.functionCaller="sortNetworkIndices";if(this.isTransition()){return}var g=this.data[this.networkShowDataTable];var c=[h]?h:this.networkShowDataTable=="nodes"?"id":"id1";var b=[];var f=[];for(var e=0;e<g.length;e++){b.push(e);f.push(g[e][c]?g[e][c]:null)}if(this.isNumeric(f)){var a=Number.MAX_VALUE*-1;b.sort(function(j,i){return(f[j]||a)-(f[i]||a)})}else{b.sort(function(j,i){return f[j]>f[i]?1:f[j]<f[i]?-1:0})}var d=[];for(var e=0;e<g.length;e++){d.push(g[b[e]])}if(this.sortDir=="ascending"){d.reverse()}this.data[this.networkShowDataTable]=d;if(this.networkShowDataTable=="nodes"){this.setNodeIndices()}this.draw()};this.sortIndices=function(h,c,k,a,m,j,o){var g=this;var n=this.meta.def;this.tmpAsciiArray=[];this.tmpAsciiArray1=[];this.tmpAsciiArray2=[];this.tmpAsciiArrayAscii=false;this.tmpAsciiArrayAscii1=false;this.tmpAsciiArrayAscii2=false;if(k){k=this.toArray(k)}if(a){a=this.toArray(a)}if(m){m=this.toArray(m)}if(!c){c=this.sortDir}if(h=="onc"){var b=[];for(var f=0;f<this.data.y.vars.length;f++){b.push(f)}this.varIndices=b;this.tmpAsciiArray=this.data.z.Alterations;this.tmpAsciiArray1=this.getDataForSmpGrpAtIndex(this.smpIndices[0]);this.tmpAsciiArrayAscii=this.isAsciiArray(this.tmpAsciiArray);this.tmpAsciiArrayAscii1=this.isAsciiArray(this.tmpAsciiArray1)}else{if(k&&h=="vars"){if(k.length==1&&this.data.z&&this.data.z[k[0]]){this.tmpAsciiArray=this.data.z[k[0]];this.tmpAsciiArrayAscii=this.isAsciiArray(this.tmpAsciiArray)}else{if(k.length==2&&this.data.z&&this.data.z[k[0]]&&this.data.z[k[1]]){this.tmpAsciiArray=this.data.z[k[0]];this.tmpAsciiArray1=this.data.z[k[1]];this.tmpAsciiArrayAscii=this.isAsciiArray(this.tmpAsciiArray);this.tmpAsciiArrayAscii1=this.isAsciiArray(this.tmpAsciiArray1)}else{if(k.length==3&&this.data.z&&this.data.z[k[0]]&&this.data.z[k[1]]&&this.data.z[k[2]]){this.tmpAsciiArray=this.data.z[k[0]];this.tmpAsciiArray1=this.data.z[k[1]];this.tmpAsciiArray2=this.data.z[k[2]];this.tmpAsciiArrayAscii=this.isAsciiArray(this.tmpAsciiArray);this.tmpAsciiArrayAscii1=this.isAsciiArray(this.tmpAsciiArray1);this.tmpAsciiArrayAscii2=this.isAsciiArray(this.tmpAsciiArray2)}}}this.smpSort=-1;this.varSort=k}else{if(k&&h=="smps"){if(this.isGroupedData){this.isGroupedData=false;this.sortIndices(h,c,k,a,m,j,o);this.isGroupedData=true}if(k.length==1&&this.data.x&&this.data.x[k[0]]){this.tmpAsciiArray=this.isGroupedData?this.data.w.factors[k[0]]:this.data.x[k[0]];this.tmpAsciiArrayAscii=this.isAsciiArray(this.tmpAsciiArray)}else{if(k.length==2&&this.data.x&&this.data.x[k[0]]&&this.data.x[k[1]]){this.tmpAsciiArray=this.isGroupedData?this.data.w.factors[k[0]]:this.data.x[k[0]];this.tmpAsciiArray1=this.isGroupedData?this.data.w.factors[k[1]]:this.data.x[k[1]];this.tmpAsciiArrayAscii=this.isAsciiArray(this.tmpAsciiArray);this.tmpAsciiArrayAscii1=this.isAsciiArray(this.tmpAsciiArray1)}else{if(k.length==3&&this.data.x&&this.data.x[k[0]]&&this.data.x[k[1]]&&this.data.x[k[2]]){this.tmpAsciiArray=this.isGroupedData?this.data.w.factors[k[0]]:this.data.x[k[0]];this.tmpAsciiArray1=this.isGroupedData?this.data.w.factors[k[1]]:this.data.x[k[1]];this.tmpAsciiArray2=this.isGroupedData?this.data.w.factors[k[2]]:this.data.x[k[2]];this.tmpAsciiArrayAscii=this.isAsciiArray(this.tmpAsciiArray);this.tmpAsciiArrayAscii1=this.isAsciiArray(this.tmpAsciiArray1);this.tmpAsciiArrayAscii2=this.isAsciiArray(this.tmpAsciiArray2)}}}this.varSort=-1;this.smpSort=k}else{if(j&&o){var f=a?parseInt(this.getVariableIndices(a[0])):parseInt(this.getSampleIndices(m[0]));this.tmpAsciiArray=this.data.y[j][f];this.tmpAsciiArrayAscii=false;this.smpSort=[f]}else{if(a){var d=[];for(var f=0;f<this.varIndices.length;f++){d.push(f)}if(a.length==1){this.tmpAsciiArray=this.getDataForSmpGrpAtIndex(a[0]-1,d,j);this.tmpAsciiArrayAscii=false;this.smpSort=[a[0]-1]}else{if(a.length==2){this.tmpAsciiArray=this.getDataForSmpGrpAtIndex(a[0]-1,d,j);this.tmpAsciiArray1=this.getDataForSmpGrpAtIndex(a[1]-1,d,j);this.tmpAsciiArrayAscii=false;this.tmpAsciiArrayAscii1=false;this.smpSort=[a[0]-1,a[1]-1]}else{if(a.length==3){this.tmpAsciiArray=this.getDataForSmpGrpAtIndex(a[0]-1,d,j);this.tmpAsciiArray1=this.getDataForSmpGrpAtIndex(a[1]-1,d,j);this.tmpAsciiArray2=this.getDataForSmpGrpAtIndex(a[2]-1,d,j);this.tmpAsciiArrayAscii=false;this.tmpAsciiArrayAscii1=false;this.tmpAsciiArrayAscii2=false;this.smpSort=[a[0]-1,a[1]-1,a[2]-1]}}}}else{if(m){if(this.isGroupedData){this.isGroupedData=false;this.sortIndices(h,c,k,a,m,j,o);this.isGroupedData=true}var e=this.isGroupedData&&this.summaryType=="iqr"?this.data.w.median:this.isGroupedData?this.data.w[this.summaryType]:j?this.data.y[j]:this.data.y.data;if(m.length==1){this.tmpAsciiArray=e[m[0]-1];this.tmpAsciiArrayAscii=false;this.smpSort=[m[0]-1]}else{if(m.length==2){this.tmpAsciiArray=e[m[0]-1];this.tmpAsciiArray1=e[m[1]-1];this.tmpAsciiArrayAscii=false;this.tmpAsciiArrayAscii1=false;this.smpSort=[m[0]-1,m[1]-1]}else{if(a.length==3){this.tmpAsciiArray=e[m[0]-1];this.tmpAsciiArray1=e[m[1]-1];this.tmpAsciiArray2=e[m[2]-1];this.tmpAsciiArrayAscii=false;this.tmpAsciiArrayAscii1=false;this.tmpAsciiArrayAscii2=false;this.smpSort=[m[0]-1,m[1]-1,m[2]-1]}}}}else{if(this.isGroupedData){this.isGroupedData=false;this.sortIndices(h,c,k,a,m,j,o);this.isGroupedData=true}this.tmpAsciiArray=this.isGroupedData?this.data.w.smps:h=="vars"?this.data.y.vars:this.data.y.smps;this.tmpAsciiArrayAscii=true;if(h=="vars"){this.varSort=false}else{this.smpSort=false}}}}}}}var l=h=="vars"||h=="onc"?this.varIndices:this.isGroupedData?this.grpIndices:this.smpIndices;if(this.tmpAsciiArrayAscii){l.sort(function(p,i){return g.sortAsciibetically(p,i)})}else{l.sort(function(p,i){return g.sortNumerically(p,i)})}if(c!="ascending"){l.reverse()}this.tmpAsciiArray=[];this.tmpAsciiArray1=[];this.tmpAsciiArray2=[];this.tmpAsciiArrayAscii=false;this.tmpAsciiArrayAscii1=false;this.tmpAsciiArrayAscii2=false;if(h=="smps"){this.sortingSampleCategories=k}else{this.sortingVariableCategories=k}this.sortingSamples=a;this.sortingVariables=m;if(!n.sort){n.sort={}}if(this.isGroupedData&&h=="smps"){n.sort.grps=l}else{n.sort[h]=l}};this.isAsciiArray=function(a){return !this.isNumeric(a)};this.sortAsciibetically=function(d,c){var e=this;if(this.tmpAsciiArray[d]==this.tmpAsciiArray[c]&&this.tmpAsciiArray1.length>0){if(this.tmpAsciiArrayAscii1){return e.sortAsciibetically1(d,c)}else{return e.sortNumerically1(d,c)}}else{return((this.tmpAsciiArray[d]>this.tmpAsciiArray[c])?1:(this.tmpAsciiArray[d]<this.tmpAsciiArray[c])?-1:0)}};this.sortAsciibetically1=function(d,c){var e=this;if(this.tmpAsciiArray1[d]==this.tmpAsciiArray1[c]&&this.tmpAsciiArray2.length>0){if(this.tmpAsciiArrayAscii2){return e.sortAsciibetically2(d,c)}else{return e.sortNumerically2(d,c)}}else{return((this.tmpAsciiArray1[d]>this.tmpAsciiArray1[c])?1:(this.tmpAsciiArray1[d]<this.tmpAsciiArray1[c])?-1:0)}};this.sortAsciibetically2=function(d,c){return((this.tmpAsciiArray2[d]>this.tmpAsciiArray2[c])?1:(this.tmpAsciiArray2[d]<this.tmpAsciiArray2[c])?-1:0)};this.sortNumerically=function(e,d){var f=this;var c=Number.MAX_VALUE*-1;if((this.tmpAsciiArray[e]||c)-(this.tmpAsciiArray[d]||c)==0&&this.tmpAsciiArray1.length>0){if(this.tmpAsciiArrayAscii1){return f.sortAsciibetically1(e,d)}else{return f.sortNumerically1(e,d)}}else{return(this.tmpAsciiArray[e]||c)-(this.tmpAsciiArray[d]||c)}};this.sortNumerically1=function(e,d){var f=this;var c=Number.MAX_VALUE*-1;if((this.tmpAsciiArray1[e]||c)-(this.tmpAsciiArray1[d]||c)==0&&this.tmpAsciiArray2.length>0){if(this.tmpAsciiArrayAscii2){return f.sortAsciibetically2(e,d)}else{return f.sortNumerically2(e,d)}}else{return(this.tmpAsciiArray1[e]||c)-(this.tmpAsciiArray1[d]||c)}};this.sortNumerically2=function(e,d){var c=Number.MAX_VALUE*-1;return(this.tmpAsciiArray2[e]||c)-(this.tmpAsciiArray2[d]||c)};this.sortArray=function(a,b){var d=[];if(a.length!=b.length){return a}for(var c=0;c<a.length;c++){if(a[b[c]]){d[c]=a[b[c]]}else{return a}}return d};this.sortObject=function(b){var a=Object.keys(b);if(this.isAsciiArray(a)){if(this.sortCaseSensitive){return a.sort()}else{return a.sort(function(d,c){return d.toLowerCase().localeCompare(c.toLowerCase())})}}else{return a.sort(function(d,c){return d-c})}};this.stringRangeSort=function(d){var c={};var a;for(var b=0;b<d.length;b++){if(d[b].match(/^\d+\-\d+/)){a=d[b].split(/\-/);c[b]=Number(a[0])}else{if(d[b].match(/^\>\d+/)){a=d[b].split(/\>/);c[b]=Number(a[1])+1e-8}else{if(d[b].match(/^\<\d+/)){a=d[b].split(/\</);c[b]=Number(a[1])-1e-8}else{if(d[b].match(/^\d+/)){a=d[b];c[b]=a}else{return d.sort()}}}}}d.sort(function(f,e){c[f]-c[e]});return d};this.radixSort=function(n){var h=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];var e=new Int32Array(n.length);var f=[].concat(h);var g=[].concat(h);var j=[].concat(h);var l=[].concat(h);var a=0;var i;var b=0;var k;var c=0;var m;var d=0;var o;var p;for(p=0;p<n.length;p++){i=n[p]&255;k=(n[p]>>8)&255;m=(n[p]>>16)&255;o=(n[p]>>24)&255^128;f[i]++;g[k]++;j[m]++;l[o]++}for(p=0;p<256;p++){i=a+f[p];k=b+g[p];m=c+j[p];o=d+l[p];f[p]=a;g[p]=b;j[p]=c;l[p]=d;a=i;b=k;c=m;d=o}for(p=0;p<n.length;p++){i=n[p]&255;e[f[i]]=n[p];f[i]++}for(p=0;p<n.length;p++){k=(e[p]>>8)&255;n[g[k]]=e[p];g[k]++}for(p=0;p<n.length;p++){m=(n[p]>>16)&255;e[j[m]]=n[p];j[m]++}for(p=0;p<n.length;p++){o=(e[p]>>24)&255^128;n[l[o]]=e[p];l[o]++}return n};this.setFunctionNames("initSortUtils")};CanvasXpress.prototype.initMathUtils=function(){this.isNaN=function(a){return isNaN(a)?true:a==Number.POSITIVE_INFINITY?true:a==Number.NEGATIVE_INFINITY?true:false};this.isFinite=function(a){if(this.isArray(a)){for(var b=0;b<a.length;b++){if(!isFinite(a[b])){return false}}return true}else{return isFinite(a)}};this.triCube=function(a){return(a=1-a*a*a)*a*a};this.degreesToArcLength=function(b,a){return b*a};this.radiansToArcLength=function(a,b){return(a*Math.PI*b)/180};this.arcLengthToDegrees=function(b,a){return(a*180)/(b*Math.PI)};this.arcLengthToRadians=function(b,a){return a/b};this.radians=function(a){return a*Math.PI/180};this.getAngle=function(e,g,c,f,d){var b=(Math.atan2(f-g,c-e)*180/Math.PI)%360;if(!d){d=0}while(b<d){b+=360}while(b>=(d+360)){b-=360}return b};this.getRadians=function(d,f,c,e){var b=Math.atan2(e-f,c-d);if(b<0){b+=(2*Math.PI)}return b};this.rotatePoint=function(c,h,b,g,d){var f=Math.cos(d)*(c-b)-Math.sin(d)*(h-g)+b;var e=Math.sin(d)*(c-b)+Math.cos(d)*(h-g)+g;return[f,e]};this.lineLength=function(b,d,a,c){return Math.sqrt(Math.pow(a-b,2)+Math.pow(c-d,2))};this.lineMidPoint=function(b,d,a,c){return[(b+a)/2,(d+c)/2]};this.getCoordinateAtDistance=function(b,i,a,h,g){var c=a-b;var j=h-i;var e=Math.sqrt(Math.pow(c,2)+Math.pow(j,2));var f=g/e;return[b+(c*f),i+(j*f)]};this.parallelLinePoints=function(r,d,p,b,n){var i=p-r;var h=b-d;var o=this.lineLength(r,d,p,b);var u=i/o;var t=h/o;var s=-t;var q=u;var c=r+n*s;var f=d+n*q;var a=r-n*s;var e=d-n*q;var j=p+n*s;var m=b+n*q;var g=p-n*s;var k=b-n*q;return[c,f,a,e,j,m,g,k]};this.perpendicularLinePoints=function(b,n,a,j,c,g){var h=this.lineLength(b,n,a,j);var o=this.lineMidPoint(b,n,a,j);if(!c){c=h*g}var r=a-o[0];var q=j-o[1];var e=r/h;var d=q/h;var p=-d;var m=e;var k=o[0]+c*p;var i=o[1]+c*m;return[k,i]};this.shortenLine=function(f,n,c,m,p,i,r,a){if(this.isNumeric([f,n,c,m,p,i])){if(r.match(/bezier/i)){if(r.match(/beziery/i)){return m>n?[f,n+p,c,m-i]:[f,n-p,c,m+i]}else{return c>f?[f+p,n,c-i,m]:[f-p,n,c+i,m]}}else{if(r.match(/quadratic/i)){var k=this.lineLength(f,n,c,m);var d=this.perpendicularLinePoints(f,n,c,m,false,Math.min(1,this.arrowQuadraticFactor*Math.abs(a))*(a>0?-1:1));var b=this.traceQuadraticCurve(f,n,d[0],d[1],c,m,p/k,true);var o=this.traceQuadraticCurve(c,m,d[0],d[1],f,n,i/k,true);return[b[1][0],b[1][1],o[1][0],o[1][1]]}else{if(r.match(/curved/i)){return[f,n,c,m]}else{var g=Math.atan2(m-n,c-f);var h=Math.cos(g);var l=Math.sin(g);var j=this.lineLength(f,n,c,m);if(j){while(j<(p+i)){p/=1.1;i/=1.1}f+=h*p;n+=l*p;c-=h*i;m-=l*i}return[f,n,c,m]}}}}};this.traceArc=function(c,b,a,l,g,d){if(l>g){var j=l;l=g;g=j}var k=[];var h=((Math.PI*2)-(g-l))/16;k.push([a*Math.cos(l)+c,a*Math.sin(l)+b]);for(var f=0;f<16;f++){l-=h;k.push([a*Math.cos(l)+c,a*Math.sin(l)+b])}return d?k.reverse():k};this.traceArc1=function(c,b,a,m,h,d){if(m>h){var k=m;m=h;h=k}var l=[];var g=Math.PI;var i=h-m;var f=32;var j=i/f;l.push([a*Math.cos(m)+c,a*Math.sin(m)+b]);m+=j;while(m<h){l.push([a*Math.cos(m)+c,a*Math.sin(m)+b]);m+=j}l.push([a*Math.cos(h)+c,a*Math.sin(h)+b]);return d?l:l.reverse()};this.traceQuadraticCurve=function(l,k,e,c,j,h,b,f){var m=[];b=Math.max(0.01,b);var a=function(i,q,p,o){var n=1-i;return n*n*q+2*n*i*p+i*i*o};var d=function(i){return[a(i,l,e,j),a(i,k,c,h)]};for(var g=0;g<=1;g+=b){m.push(d(g))}return f?m:m.reverse()};this.traceBezierCurve=function(j,h,c,b,l,k,g,f,a,d){var m=[];a=Math.max(0.01,a);for(var e=0;e<=1;e+=a){m.push(this.deCasteljau([[j,h],[c,b],[l,k],[g,f]],e))}return d?m:m.reverse()};this.splineControlPoint=function(e,m,d,l,c,k){var n=Math.sqrt(Math.pow(d-e,2)+Math.pow(l-m,2));var h=Math.sqrt(Math.pow(c-d,2)+Math.pow(k-l,2));var g=this.tension*n/(n+h);var f=this.tension-g;var b=d+g*(e-c);var a=l+g*(m-k);var j=d-f*(e-c);var i=l-f*(m-k);return[b,a,j,i]};this.curvePoints=function(v,k){var a=[];var w=[];var f=this.tension;var g=this.tensionSegments;k=k?k:false;a=v.slice(0);if(k){a.unshift(v[v.length-1]);a.unshift(v[v.length-2]);a.unshift(v[v.length-1]);a.unshift(v[v.length-2]);a.push(v[0]);a.push(v[1])}else{a.unshift(v[1]);a.unshift(v[0]);a.push(v[v.length-2]);a.push(v[v.length-1])}var e,d,c,n,b,l,p,o,m,h,q;for(var u=2;u<(a.length-4);u+=2){for(var r=0;r<=g;r++){c=(a[u+2]-a[u-2])*f;n=(a[u+4]-a[u])*f;b=(a[u+3]-a[u-1])*f;l=(a[u+5]-a[u+1])*f;q=r/g;p=2*Math.pow(q,3)-3*Math.pow(q,2)+1;o=-(2*Math.pow(q,3))+3*Math.pow(q,2);m=Math.pow(q,3)-2*Math.pow(q,2)+q;h=Math.pow(q,3)-Math.pow(q,2);e=p*a[u]+o*a[u+2]+m*c+h*n;d=p*a[u+1]+o*a[u+3]+m*b+h*l;w.push(e);w.push(d)}}return w};this.hullControlPoints=function(f){var c=this;var f;var e=[];var g=0;var b,a;var d=function(p,n,m){var l=function(r,q){var t=q[0]-r[0];var s=q[1]-r[1];return Math.sqrt(t*t+s*s)};var o=l(p,n);var k=l(n,m);var h=c.tension*o/(o+k);var j=[((p[0]-m[0])*h)+n[0],((p[1]-m[1])*h)+n[1]];var i=[n[0]-((p[0]-m[0])*h),(n[1]-(p[1]-m[1])*h)];return[j,i]};for(b=0;b<f.length-2;b++){e.push.apply(e,d(f[b],f[b+1],f[b+2]))}e.push.apply(e,d(f[b],f[b+1],f[0]));e.push.apply(e,d(f[b+1],f[0],f[1]));return e};this.expandPolygon=function(o,w){var b=function(i){var d=Math.sqrt(i.x*i.x+i.y*i.y);return{x:i.x/d,y:i.y/d}};var s=function(d,i){return{x:d.x*i,y:d.y*i}};var l=function(i,d){return i.x*d.x+i.y*d.y};var c=function(d){return{x:d.y,y:-d.x}};var x=function(d){return{x:-d.y,y:d.x}};var v=function(F,E){var i=F[1].x-F[0].x;var D=E[0].x-E[1].x;var B=E[0].x-F[0].x;var d=F[1].y-F[0].y;var C=E[0].y-E[1].y;var p=E[0].y-F[0].y;var G=(D*p-C*B)/(d*D-i*C);return{x:F[0].x+G*(F[1].x-F[0].x),y:F[0].y+G*(F[1].y-F[0].y)}};var z=function(d){return l(c({x:d[1].x-d[0].x,y:d[1].y-d[0].y}),{x:d[2].x-d[1].x,y:d[2].y-d[1].y})>=0};var t=[];var g=z(o)?x:c;for(var u=0;u<o.length;++u){var k=o[(u>0)?u-1:o.length-1];var h=o[u];var f=o[(u<o.length-1)?u+1:0];var m={x:h[0]-k[0],y:h[1]-k[1]};var y={x:f[0]-h[0],y:f[1]-h[1]};var n=s(b(g(m)),w);var A=s(b(g(y)),w);var r={x:k[0]+n.x,y:k[1]+n.y};var j={x:h[0]+n.x,y:h[1]+n.y};var e={x:h[0]+A.x,y:h[1]+A.y};var q={x:f[0]+A.x,y:f[1]+A.y};var a=v([r,j],[e,q]);t.push([a.x,a.y])}return t};this.enlargePolygon=function(r,y,q){var f=function(i,e,d){return((d.x-i.x)*(e.y-i.y))-((e.x-i.x)*(d.y-i.y))};var z=function(p,s){var e=p.vrs[s];var d=p.vrs[(s+1)%p.vrs.length];var i=p.vrs[(s+p.vrs.length-1)%p.vrs.length];return(f(i,d,e)<0)?true:false};var h=function(s){var i=s.v2.x-s.v1.x;var d=s.v2.y-s.v1.y;var p=Math.sqrt(i*i+d*d);return{x:-d/p,y:i/p}};var o=function(d){var i=h(d);return{x:-i.x,y:-i.y}};var b=function(J){var p={vrs:J};var I=[];var D=(J.length>0)?J[0].x:undefined;var v=(J.length>0)?J[0].y:undefined;var s=D;var d=v;for(var E=0;E<p.vrs.length;E++){J[E].label=String(E);J[E].isReflex=z(p,E);var F={v1:J[E],v2:J[(E+1)%J.length],pol:p,index:E};F.outwardNormal=o(F);F.inwardNormal=h(F);I.push(F);var H=J[E].x;var G=J[E].y;D=Math.min(H,D);v=Math.min(G,v);s=Math.max(H,s);d=Math.max(G,d)}p.edges=I;p.minX=D;p.minY=v;p.maxX=s;p.maxY=d;p.closed=true;return p};var l=function(p,i,d){return{v1:{x:p.v1.x+i,y:p.v1.y+d},v2:{x:p.v2.x+i,y:p.v2.y+d}}};var C=function(p,e){var s=(e.v2.y-e.v1.y)*(p.v2.x-p.v1.x)-(e.v2.x-e.v1.x)*(p.v2.y-p.v1.y);if(s==0){return null}var i=((e.v2.x-e.v1.x)*(p.v1.y-e.v1.y)-(e.v2.y-e.v1.y)*(p.v1.x-e.v1.x))/s;var d=((p.v2.x-p.v1.x)*(p.v1.y-e.v1.y)-(p.v2.y-p.v1.y)*(p.v1.x-e.v1.x))/s;if(i<0||d<0||i>1||d>1){return null}return{x:p.v1.x+i*(p.v2.x-p.v1.x),y:p.v1.y+i*(p.v2.y-p.v1.y)}};var c=function(L,E,d,K,F,s){var J=Math.PI*2;var H=Math.atan2(K.y-E.y,K.x-E.x);var D=Math.atan2(F.y-E.y,F.x-E.x);if(H<0){H+=J}if(D<0){D+=J}var G=((H>D)?(H-D):(H+J-D));var e=((s)?-G:J-G)/q;L.push(K);for(var p=1;p<q;++p){var G=H+e*p;var I={x:E.x+Math.cos(G)*d,y:E.y+Math.sin(G)*d};L.push(I)}L.push(F)};var t=[];var u=[];for(var w=0;w<r.length;w++){u.push({x:r[w][0],y:r[w][1]})}var j=b(u);for(var w=0;w<j.edges.length;w++){var x=j.edges[w];var n=x.outwardNormal.x*y;var k=x.outwardNormal.y*y;t.push(l(x,n,k))}u=[];for(var w=0;w<t.length;w++){var g=t[w];var B=t[(w+t.length-1)%t.length];var m=C(B,g);if(m){u.push(m)}else{var A=j.edges[w].v1;c(u,A,y,B.v2,g.v1,false)}}var a=[];for(var w=0;w<u.length;w++){a.push([u[w].x,u[w].y])}return a};this.sample=function(c,g){if(c){if(!g||g<=0){g=c.length}var e,b;var f=c.slice(0);var d=c.length;var a=d-g;while(d-->a){b=Math.floor((d+1)*this.random());e=f[b];f[b]=f[d];f[d]=e}return f.slice(a)}else{return[]}};this.seq=function(g,c,f,a){var d=[];if(g!=null&&c!=null&&(a||f)){var b=c<g;if(c<g){var e=g;g=c;c=e}if(a){a=Math.abs(a);f=(c-g)/(a-1)}else{f=Math.abs(f)}if(f){while(c>=g){d.push(g);g+=f}}if(a){d[a-1]=c}else{if(d[d.length-1]<c){d.push(c)}}}return b?d.reverse():d};this.rnorm=function(h,b,d){var g=this;var c=[];if(b==null){b=0}if(d==null){d=1}var f=function(){var j,i;var a=2;while(a>1){j=g.random()*2-1;i=g.random()*2-1;a=j*j+i*i}return b+d*j*Math.sqrt(-2*Math.log(a)/a)};for(var e=0;e<h;e++){c.push(f())}return c};this.percentile2=function(a,f){if(a.length===0){return 0}if(typeof f!=="number"){throw new TypeError("p must be a number")}if(f<=0){return a[0]}if(f>=1){return a[a.length-1]}var c=a.length*f;var b=Math.floor(c);var d=b+1;var e=c%1;if(d>=a.length){return a[b]}else{return a[b]*(1-e)+a[d]*e}};this.percentRank=function(a,c){if(typeof c!=="number"){throw new TypeError("v must be a number")}for(var d=0,b=a.length;d<b;d++){if(c<=a[d]){while(d<b&&c===a[d]){d++}if(d===0){return 0}if(c!==a[d-1]){d+=(c-a[d-1])/(a[d]-a[d-1])}return d/b}}return 1};this.percentile=function(d,a,e){var b=a-d;if(b==0){return 50}var c=e-d;return c*100/b};this.rank=function(a){var c=[];for(var b=0;b<a.length;b++){c.push(b)}c.sort(function(e,d){return a[e]-a[d]});return c};this.rank2=function(b){var d=b.slice().sort(function(g,f){return g-f});var e=b.slice().map(function(f){return d.indexOf(f)+1});var c={};e.map(function(f){c[f]=c[f]?c[f]++:1});var a=e.map(function(f){return f/c[f]});return a};this.min=function(b,a,e){if(this.isArray(b)){b=this.cleanArray(b,a,e);var d=Number.POSITIVE_INFINITY;for(var c=0;c<b.length;c++){d=Math.min(d,b[c])}return d}else{return this.Min(b,a)}};this.max=function(c,b,e){if(this.isArray(c)){c=this.cleanArray(c,b,e);var a=Number.NEGATIVE_INFINITY;for(var d=0;d<c.length;d++){a=Math.max(a,c[d])}return a}else{return this.Max(c,b)}};this.sum=function(b,a,g,e,f){b=this.cleanArray(b,a,g);var d=0;for(var c=0;c<b.length;c++){if(e){if(b[c]>0){d+=b[c]}}else{if(f){if(b[c]<0){d+=b[c]}}else{d+=b[c]}}}return d};this.sumSquared=function(b,a,f,e){b=this.cleanArray(b,a,f);var d=0;for(var c=0;c<b.length;c++){if(e){if(b[c]>0){d+=b[c]*b[c]}}else{d+=b[c]*b[c]}}return d};this.sumSquaredError=function(b,a,g){b=this.cleanArray(b,a,g);var c=this.mean(b);var f=0;for(var e=0;e<b.length;e++){var d=b[e]-c;f+=d*d}return f};this.mean=function(b,a,e){b=this.cleanArray(b,a,e);var c=0;var f=0;for(var d=0;d<b.length;d++){if(!this.isNaN(b[d])){c+=Number(b[d]);f++}}if(f>0){c/=f}return c};this.range=function(c,b,f){c=this.cleanArray(c,b,f);var e=Number.MAX_VALUE;var a=Number.MAX_VALUE*-1;for(var d=0;d<c.length;d++){e=Math.min(c[d],e);a=Math.max(c[d],a)}return e==a&&e==0?[0,0.01]:e==a?[Number(e),Number(a)]:[Number(e),Number(a)]};this.median=function(b,a,f){b=this.cleanArray(b,a,f);var e=[];var d=[];var g=0;e[0]=Number.NaN;e[1]=Number.NaN;for(var c=0;c<b.length;c++){d.push(b[c]);g++}if(g>0){e[1]=g;d.sort(function(i,h){return i-h});if(g%2){e[0]=d[parseInt(g/2)]}else{e[0]=(d[parseInt((g-1)/2)]+d[g/2])/2}}return e};this.Abs=function(b,a,e){b=this.cleanArray(b,a,e);var d=[];for(var c=0;c<b.length;c++){d.push(Math.abs(b[c]))}return d};this.square=function(b,a,e){b=this.cleanArray(b,a,e);var d=[];for(var c=0;c<b.length;c++){d.push(b[c]*b[c])}return d};this.subtractArray=function(c,e){var b=[];for(var d=0;d<c.length;d++){b.push(c[d]-e)}return b};this.addArray=function(c,e){var b=[];for(var d=0;d<c.length;d++){b.push(c[d]+e)}return b};this.replaceArray=function(c,e){var b=[];for(var d=0;d<c.length;d++){b.push(e)}return b};this.random=function(){if(this.pseudoRandom){this.randomSeed=(this.randomSeed*9301+49297)%233280;return this.randomSeed/233280}else{return Math.random()}};this.randomBetween=function(b,a){return(this.random()*(a-b+1))+b};this.randomInt=function(){return parseInt(this.random())};this.randomIntBetween=function(b,a){return Math.floor(this.random()*(a-b+1))+b};this.sumarizeErrorData=function(b,a,c){if(this.errorBarsType=="standardErrorMean"){return this.meanStandardErrorN(b,a,c)}else{if(this.errorBarsType=="confidenceInterval95"){return this.mean95ConfidenceIntervalN(b,a,c)}else{return this.meanStandardDeviationN(b,a,c)}}};this.meanStandardErrorN=function(b,a,d){var c=this.variance(b,a,d,true);if(this.isNaN(c[1])){return[NaN,NaN,NaN]}return[c[0],Math.sqrt(c[1])/Math.sqrt(c[2]),c[2]]};this.mean95ConfidenceIntervalN=function(b,a,d){var c=this.meanStandardErrorN(b,a,d,true);if(this.isNaN(c[1])){return[NaN,NaN,NaN]}return[c[0],c[1]*1.96,c[2]]};this.meanStandardDeviationN=function(b,a,d){var c=this.variance(b,a,d,true);if(this.isNaN(c[1])){return[NaN,NaN,NaN]}return[c[0],Math.sqrt(c[1]),c[2]]};this.fivenum=function(a){a.sort(function(h,d){return h-d});var g=a.length;var b=Math.floor((g+3)/2)/2;var f=[1,b,(g+1)/2,g+1-b,g];var e=[];for(var c=0;c<f.length;c++){e.push((a[Math.floor(f[c])-1]+a[Math.ceil(f[c])-1])*0.5)}return e};this.boxplot=function(a,d,c){if(a.length>0){var e=[];var l=[];var b=this.fivenum(a);var g=this.boxplotHingeFunction=="summary"?this.quantile(a,[0.25,0.75]):[b[1],b[3]];var u=b[0];var q=g[0];var o=b[2];var s=b[2];var n=g[1];var t=b[4];var k=n-q;var p=q-this.boxplotCoef*k;var m=n+this.boxplotCoef*k;var j=(b[3]-b[1])/Math.sqrt(a.length);for(var r=0;r<a.length;r++){if(a[r]<p||a[r]>m){e.push(a[r])}else{l.push(a[r])}}if(e.length>0){var f=this.range(l);u=f[0];t=f[1]}var h=[s-1.58*j,s+1.58*j];return[s,q,o,n,u,t,e,a.length,h]}return[NaN,NaN,NaN,NaN,NaN,NaN,NaN]};this.quantileBin=function(b,a){if(a<b[0]){return 0}else{if(a>=b[0]&&a<b[1]){return 1}else{if(a>=b[1]&&a<b[2]){return 2}else{if(a>=b[2]){return 3}}}}};this.quantile=function(b,c){b=this.cleanArray(b);b=b.slice().sort(function(f,e){return f-e});var d=b.length-1;var a=c||[0.25,0.5,0.75];return a.map(function(j){if(j===0){return b[0]}else{if(j===1){return b[d]}else{var f=1+j*d;var i=Math.floor(f);var g=f-i;var e=b[i-1];return g===0?e:e+g*(b[i]-e)}}})};this.iqr=function(a){var b=this.quantile(a,[0.25,0.75]);return b[1]-b[0]};this.variance=function(e,f,c,a){e=this.cleanArray(e,f,c);var b=e.length;if(b<1){return a?[NaN,NaN,NaN]:NaN}else{if(b==1){return a?[e[0],0,1]:0}else{var j=this.mean(e);var h=0;var d=b;while(--d>=0){if(!this.isNaN(e[d])){var g=e[d]-j;h+=g*g}}if(a){return this.standardDeviationType=="unbiased"?[j,h/(b-1),b]:[j,h/b,b]}else{return this.standardDeviationType=="unbiased"?h/(b-1):h/b}}}};this.deviation=function(b,a,f){b=this.cleanArray(b,a,f);var g=b.length;if(g<1){return[NaN]}else{if(g==1){return[0]}else{var c=this.mean(b);var d=[];for(var e=0;e<g;e++){if(!this.isNaN(b[e])){d[e]=b[e]-c}else{d[e]=NaN}}return d}}};this.standardDeviation=function(b,a,d){var c=this.variance(b,a,d);if(this.isNaN(c)){return c}return Math.sqrt(c)};this.standardError=function(b,a,d){var c=this.variance(b,a,d,true);if(this.isNaN(c[1])){return c[1]}return Math.sqrt(c[1])/Math.sqrt(c[2])};this.meanSquaredError=function(b,a,c){b=this.cleanArray(b,a,c);return this.sumSquaredError(this.sumSquaredError(b,a,c))/b.length};this.confidenceInterval95=function(c,b,d){var a=this.standardError(c,b,d);if(this.isNaN(a)){return a}return a*1.96};this.covariance=function(h,g,e,c){var f=this.cleanArrays(h,g,e,c);h=f[0];g=f[1];var l=0;var a=[];var b=0;var k=this.mean(h);var j=this.mean(g);for(var d=0;d<h.length;d++){a[d]=(h[d]-k)*(g[d]-j);l+=a[d];b++}if(b>0){return l/(this.standardDeviationType=="unbiased"?b-1:b)}else{return NaN}};this.correlation=function(c,b,a,e,d){if(d&&d=="spearman"){return this.correlationSpearman(c,b,a,e)}else{return this.correlationPearson(c,b,a,e)}};this.correlationSpearman=function(m,l,h,f){var k=this.cleanArrays(m,l,h,f);m=k[0];l=k[1];var a=m.length;var b=0;var e=this.rank2(m);var c=this.rank2(l);for(var g=0;g<m.length;g++){var j=e[g]-c[g];b+=j*j}return 1-(6*b/(a*(a*a-1)))};this.correlationPearson=function(c,b,a,d){return this.covariance(c,b,a,d)/this.standardDeviation(c,a,d)/this.standardDeviation(b,a,d)};this.regression=function(k,j,g,b,c,l){var f=[];var h=this.cleanArrays(k,j,g,b);k=h[0];j=h[1];for(var e=0;e<k.length;e++){if(!this.isNaN(k[e])&&!this.isNaN(j[e])){f.push([k[e],j[e]])}}var a=this.regressionType+"Regression";var d=this[a](f);return[d.params[0],d.params[1],d.r2,d.confidence]};this.slope=function(b,d,a,c){return d!=c?(a-b)/(c-d):0};this.intercept=function(a,c,b){return c-(a*b)};this.slopeIntercept=function(b,e,a,d){var c=this.slope(b,e,a,d);return[c,this.intercept(b,e,c)]};this.normalize=function(f){var e=this.standardDeviationType;this.standardDeviationType="biased";for(var c=0;c<f.length;c++){var a=this.meanStandardDeviationN(f[c]);for(var b=0;b<f[c].length;b++){f[c][b]=(f[c][b]-a[0])/a[1]}}this.standardDeviationType=e;return f};this.coefficientDetermination=function(h,f){var c=0;for(var b=0;b<h.length;b++){c+=h[b][1]}var j=c/h.length;var e=0;for(var b=0;b<h.length;b++){var g=h[b][1]-j;e+=g*g}var d=0;for(var b=0;b<h.length;b++){var a=h[b][1]-f[b][1];d+=a*a}return 1-(d/e)};this.gaussianElimination=function(m,b){var o=m;var a=m.length-1;var c=[b];for(var g=0;g<a;g++){var h=g;for(var e=g+1;e<a;e++){if(Math.abs(o[g][e])>Math.abs(o[g][h])){h=e}}for(var d=g;d<a+1;d++){var f=o[d][g];o[d][g]=o[d][h];o[d][h]=f}for(var e=g+1;e<a;e++){for(var d=a;d>=g;d--){o[d][e]-=(o[d][g]*o[g][e])/o[g][g]}}}for(var e=a-1;e>=0;e--){var l=0;for(var d=e+1;d<a;d++){l+=o[d][e]*c[d]}c[e]=(o[a][e]-l)/o[e][e]}return c};this.linearRegression=function(v){var c=[0,0,0,0,0];var r=0;var p=Number.NEGATIVE_INFINITY;var l=Number.POSITIVE_INFINITY;for(var k=0;k<v.length;k++){r++;p=Math.max(p,v[k][0]);l=Math.min(l,v[k][0]);c[0]+=v[k][0];c[1]+=v[k][1];c[2]+=v[k][0]*v[k][0];c[3]+=v[k][0]*v[k][1];c[4]+=v[k][1]*v[k][1]}var h=((r*c[2])-(c[0]*c[0]));var a=((r*c[3])-(c[0]*c[1]));var b=h===0?0:a/h;var t=(c[1]/r)-((b*c[0])/r);var o=[];for(var k=0;k<v.length;k++){o[k]=[v[k][0],(v[k][0]*b)+t]}var e=[];var j=0;var u=0;var q=c[0]/r;var g=Math.max(k-2,1);var d=this.seq(l,p,(p-l)/10);var f=this.tinv(1-this.confidenceLevel,g,true);for(var m=0;m<k;m++){j+=Math.pow(v[m][1]-o[m][1],2);u+=Math.pow(v[m][0]-q,2)}j=Math.sqrt(j/g);for(var m=0;m<d.length;m++){var w=-f*j*Math.sqrt((1/k)+Math.pow(d[m]-q,2)/u);var s=b*d[m]+t;e.push([d[m],s+w,s-w,w])}return{predict:o,params:[b,t],r2:this.coefficientDetermination(v,o),confidence:e,string:t===0?"y = "+b+"x":"y = "+b+"x + "+t}};this.exponentialRegression=function(g){var f=[0,0,0,0,0,0];for(var i=0;i<g.length;i++){f[0]+=g[i][0];f[1]+=g[i][1];f[2]+=g[i][0]*g[i][0]*g[i][1];f[3]+=g[i][1]*Math.log(g[i][1]);f[4]+=g[i][0]*g[i][1]*Math.log(g[i][1]);f[5]+=g[i][0]*g[i][1]}var h=((f[1]*f[2])-(f[5]*f[5]));var d=Math.exp(((f[2]*f[3])-(f[5]*f[4]))/h);var c=((f[1]*f[4])-(f[5]*f[3]))/h;var e=[];for(var i=0;i<g.length;i++){e[i]=[g[i][0],d*Math.exp(c*g[i][0])]}return{predict:e,params:[d,c],r2:this.coefficientDetermination(g,e),confidence:false,string:"y = "+d+"e^("+c+"x)"}};this.logarithmicRegression=function(h){var g=[0,0,0,0];var d=h.length;for(var i=0;i<d;i++){g[0]+=Math.log(h[i][0]);g[1]+=h[i][1]*Math.log(h[i][0]);g[2]+=h[i][1];g[3]+=Math.pow(Math.log(h[i][0]),2)}const c=((d*g[1])-(g[2]*g[0]))/((d*g[3])-(g[0]*g[0]));const e=(g[2]-(c*g[0]))/d;var f=[];for(var i=0;i<h.length;i++){f[i]=[h[i][0],e+(c*Math.log(h[i][0]))]}return{predict:f,params:[e,c],r2:this.coefficientDetermination(h,f),confidence:false,string:"y = "+e+" + "+c+"ln(x)"}};this.powerRegression=function(h){var g=[0,0,0,0,0];var d=h.length;for(var i=0;i<d;i++){g[0]+=Math.log(h[i][0]);g[1]+=Math.log(h[i][1])*Math.log(h[i][0]);g[2]+=Math.log(h[i][1]);g[3]+=Math.pow(Math.log(h[i][0]),2)}var c=((d*g[1])-(g[0]*g[2]))/((d*g[3])-Math.pow(g[0],2));var e=Math.exp(((g[2]-(c*g[0]))/d));var f=[];for(var i=0;i<h.length;i++){f[i]=[h[i][0],e*Math.pow(h[i][0],c)]}return{predict:f,params:[e,c],r2:this.coefficientDetermination(h,f),confidence:false,string:"y = "+e+"x^"+c}};this.polynomialRegression=function(o){this.regressionOrder=2;var g=[];var s=[];var v=0;var u=0;var r=o.length;var h=this.regressionOrder+1;for(var p=0;p<h;p++){for(var f=0;f<r;f++){v+=Math.pow(o[f][0],p)*o[f][1]}g.push(v);v=0;var t=[];for(var m=0;m<h;m++){for(var f=0;f<r;f++){u+=Math.pow(o[f][0],(p+m))}t.push(u);u=0}s.push(t)}s.push(g);var e=this.gaussianElimination(s,h);var w=[];for(var d=0;d<o.length;d++){w[d]=[o[d][0],e[0]+(e[1]*Math.pow(o[d][0],e[2]))]}var q="y = ";for(var p=e.length-1;p>=0;p--){if(p>1){q+=e[p]+"x^"+p+" + "}else{if(p===1){q+=e[p]+"x + "}else{q+=e[p]}}}return{predict:w,params:e.reverse(),r2:this.coefficientDetermination(o,w),confidence:false,string:q}};this.checkLoessCache=function(b){var a=this.meta;if(!a.vals.loess){a.vals.loess={}}var c=this.cloneObject(b);c.push(this.loessDegree,this.loessSteps,this.loessSurfaceSteps,this.loessBandwidth,this.loessSpan);c=c.join(":");return a.vals.loess.hasOwnProperty(c)?a.vals.loess[c]:false};this.loess=function(Y,H,Q){var m=this.checkLoessCache(Q);if(m){return m}var F=this;var W=function(d){var k=Math.abs(d);var i=1/(1+k/2);var j=i*Math.exp(-k*k-1.26551223+i*(1.00002368+i*(0.37409196+i*(0.09678418+i*(-0.18628806+i*(0.27886807+i*(-1.13520398+i*(1.48851587+i*(-0.82215223+i*0.17087277)))))))));return d>=0?j:2-j};var l=function(d){if(d>=2){return -100}if(d<=0){return 100}var aa=(d<1)?d:2-d;var k=Math.sqrt(-2*Math.log(aa/2));var y=-0.70711*((2.30753+k*0.27061)/(1+k*(0.99229+k*0.04481))-k);for(var i=0;i<2;i++){var w=W(y)-aa;y+=w/(1.1283791670955126*Math.exp(-(y*y))-y*w)}return(d<1)?y:-y};var X=function(i,j,d){var k=Math.sqrt(j);return i-k*Math.sqrt(2)*l(2*d)};var O=function(d){var y=Math.ceil(0.1*d.length);var k=F.cloneObject(d);k=k.sort(function(i,aa){return i-aa});for(var j=0;j<y;j++){k.shift();k.pop()}var w=F.standardDeviation(k);return function(i){return i.map(function(aa){return aa/w})}};var a=function(j,d){var w=[];for(var k=0;k<j.length;k++){if(F.isArray(j[k])&&F.isArray(d[k])){w.push(a(j[k],d[k]))}else{w.push(j[k]*d[k])}}return w};var o=function(j,ab){var w=function(d,ac,ae){if(ae>1){for(var ad=ac;ad<j.length;ad++){w(a(d,j[ad]),ad,ae-1)}}else{aa.push(d)}};var aa=[];var y=Array(j[0].length).fill(1);for(var k=0;k<=ab;k++){w(y,0,k+1)}return aa};var n=function(j,i){if(j.length<2){return Math.abs(j[0]-i[0])}else{return Math.sqrt(j.reduce(function(d,k,w){return d+Math.pow(k-i[w],2)},0))}};var P=function(i,d){return i.map(function(j){return d.map(function(k){return n(j,k)})})};var q=function(k,j,i){return k<j?Math.pow(1-Math.pow(k/j,i),i):0};var r=function(k,j,i){return k.map(function(aa){var ac=F.rank(aa);var ab=[];for(var y=0;y<ac.length;y++){ab.push([aa[ac[y]],j[ac[y]]])}var ae=F.sum(j)*i;var d=0;var w=ab.findIndex(function(af){d+=af[1];return d>=ae});var ad=i>1?ab[ab.length-1][0]*i:ab[w][0];return a(aa.map(function(af){return q(af,ad,3)}),j)})};var s=function(ad,ac){var ab=ad.length;var k=ad[0].length;var w=ac.length;var ae=ac[0].length;var j=new Array(ab);for(var d=0;d<ab;d++){j[d]=new Array(ae);for(var aa=0;aa<ae;aa++){j[d][aa]=0;for(var y=0;y<k;y++){j[d][aa]+=ad[d][y]*ac[y][aa]}}}return j};var g=function(w,k){var d=new Array(w.length);for(var aa=0;aa<d.length;aa++){d[aa]=new Array(w[aa].length);for(var y=0;y<d[aa].length;y++){d[aa][y]=w[aa][y]-k[aa][y]}}return d};var u=function(d){var j=[];for(var k=0;k<d.length;k++){j.push(d[k][0])}return j};var I=function(j,k,w){var ab=a(w,k);var ac=F.transpose(j.map(function(ae){return a(w,ae)}));var aa=s(j,ac);var d=s(j,F.transpose([ab]));var y=s(numeric.inv(aa),d);var i=s(F.transpose(y),j);var ad=g([k],i);return{beta:y,yhat:i,residuals:ad}};var e=function(d){b=[];T=[];N=a(d,K);var i=F.transpose(M);i.forEach(function(k,j){var w=I(Z,G,N[j]);b.push(u(s([k],w.beta)));T.push(w.residuals);var y=F.median(F.Abs(w.residuals[0]));d[j]=w.residuals.map(function(aa){return q(aa,6*y[0],2)})})};this.loessDegree=parseInt(this.loessDegree);if(this.loessDegree<0||this.loessDegree>2){this.loessDegree=2}this.loessBandWidth=Number(this.loessBandwidth);if(this.loessBandwidth<0||this.loessBandwidth>1){this.loessBandwidth=0.8}this.loessSpan=Number(this.loessSpan);if(this.loessSpan<0||this.loessSpan>1){this.loessSpan=0.8}var z=[Y[0]];var t=[this.loessSteps];var G=Y[1];if(Y[2]){z.push(Y[2]);t.push(this.loessSteps)}if(!H){H=Array(Y[0].length).fill(1)}var Z=o(z,this.loessDegree);var c=z.map(O);var L=z.map(function(i,d){return c[d](i)});var h=this.transposeMatrix(L);var E=[];var J=[];z.forEach(function(ac,ad){var d=ac.sort(function(ae,i){return ae-i});var j=d[0];var y=d[d.length-1];var k=(y-j)/(t[ad]-1);J.push([]);for(var w=0;w<t[ad];w++){J[ad].push(j+w*k)}var aa=1;var ab=1;for(var w=ad-1;w>=0;w--){aa*=t[w]}for(var w=ad+1;w<z.length;w++){ab*=t[w]}E.push([]);for(var w=0;w<aa;w++){E[ad]=E[ad].concat(J[ad].reduce(function(i,ae){return i.concat(Array(ab).fill(ae))},[]))}});var A=this.cloneObject(E);var V=E[0].length;var M=o(A,this.loessDegree);var U=A.map(function(i,d){return c[d](i)});var f=P(this.transpose(U),h);var K=r(f,H,this.loessBandwidth);var b;var T;var N;var C=Array(V).fill(Array(Y[0].length).fill(1));for(var x=0;x<this.loessIterations;x++){e(C)}var v={fitted:u(b),residuals:T,weights:N};(function(){var i=X(0,1,1-(1-F.loessSpan)/2);var d=N.map(function(aa,k){var w=F.sum(aa);var j=s([aa],F.transpose([aa]));var y=Math.sqrt(s([F.square(T[k][0])],F.transpose([aa]))/(w-j[0]/w));return y*i});Object.assign(v,{halfwidth:d})})();var B=[];if(Y[2]){for(var S=0;S<this.loessSurfaceSteps;S++){var D=[];for(var R=0;R<this.loessSurfaceSteps;R++){D.push(v.fitted[R*this.loessSurfaceSteps+S])}B.push(D)}}if(!this.meta.vals.loess){this.meta.vals.loess={}}var p=this.cloneObject(Q);p.push(this.loessDegree,this.loessSteps,this.loessSurfaceSteps,this.loessBandwidth,this.loessSpan);p=p.join(":");if(Y[2]){this.meta.vals.loess[p]={x:J[0],y:J[1],z:B,c:v.halfwidth}}else{this.meta.vals.loess[p]={x:E[0],y:v.fitted,c:v.halfwidth}}return this.meta.vals.loess[p]};this.errorEllipse=function(a,c,b){if(b){return this.errorEllipse3D(a,c,b)}else{return this.errorEllipse2D(a,c)}};this.errorEllipse2D=function(k,g){var i=this.variance(k,false,false,true);var h=this.variance(g,false,false,true);var j=this.covariance(k,g);var m=[[i[1],j],[j,h[1]]];var n=numeric.eig(m);var l=Math.sqrt(2*this.gammaPinv(this.confidenceLevel,1));var f=n.lambda.x[0]>n.lambda.x[1]?0:1;var e=n.lambda.x[0]<n.lambda.x[1]?0:1;var b=i[1]>h[1]?Math.sqrt(n.lambda.x[f])*l:Math.sqrt(n.lambda.x[e])*l;var a=h[1]>i[1]?Math.sqrt(n.lambda.x[f])*l:Math.sqrt(n.lambda.x[e])*l;var c=Math.atan2(n.E.x[f][1],n.E.x[f][0]);if(c<0){c+=Math.PI/2}var d={rx:b,ry:a,cx:i[0],cy:h[0],rot:c};return d};this.errorEllipse3D=function(m,l,j){var p=this.variance(m,false,false,true);var o=this.variance(l,false,false,true);var n=this.variance(j,false,false,true);var c=this.covariance(m,l);var b=this.covariance(m,j);var i=this.covariance(l,j);var t=[[p[1],c,b],[c,o[1],i],[b,i,n[1]]];var k=numeric.eig(t);var a=Math.sqrt(2*this.gammaPinv(this.confidenceLevel,1));var f=this.rank(k.lambda.x);var s=f[2];var q=f[1];var r=f[0];var h=Math.sqrt(k.lambda.x[s])*a;var e=Math.sqrt(k.lambda.x[q])*a;var d=Math.sqrt(k.lambda.x[r])*a;var w=Math.atan2(k.E.x[2][s]*-1,k.E.x[1][s]*-1);var v=Math.atan2(k.E.x[2][s]*-1,k.E.x[0][s]*-1);var u=Math.atan2(k.E.x[1][s]*-1,k.E.x[0][s]*-1);if(w<0){}if(v<0){v+=Math.PI/2}if(u<0){}var g={rx:[h],ry:[e],rz:[d],cx:p[0],cy:o[0],cz:n[0],rot:[w,v,u]};return g};this.uniformKernel=function(a){return(a<=1&&a>=-1)?0.5:0},this.triangularKernel=function(a){return(a<=1&&a>=-1)?1-Math.abs(a):0},this.epanechnikovKernel=function(a){return(a<=1&&a>=-1)?0.75*(1-a*a):0},this.quarticKernel=function(a){if(a<=1&&a>=-1){var b=1-a*a;return(15/16)*b*b}else{return 0}},this.triweightKernel=function(a){if(a<=1&&a>=-1){var b=1-a*a;return(35/32)*b*b*b}else{return 0}},this.gaussianKernel=function(a){return 1/Math.sqrt(2*Math.PI)*Math.exp(-0.5*a*a)},this.cosineKernel=function(a){return(a<=1&&a>=-1)?Math.PI/4*Math.cos(Math.PI/2*a):0};this.silvermanRule=function(c){var a=Math.sqrt(this.variance(c));var b=4*Math.pow(a,5);var d=3*c.length;return Math.pow(b/d,0.2)};this.nrd0Rule=function(d){var a=Math.sqrt(this.variance(d));var e=this.iqr(d)/1.34;var c=Math.pow(d.length,-0.2);var b=e>0?Math.min(a,e):a;return 0.9*b*c};this.nrdRule=function(d){var a=Math.sqrt(this.variance(d));var e=this.iqr(d)/1.34;var c=Math.pow(d.length,-0.2);var b=e>0?Math.min(a,e):a;return 1.6*b*c};this.getBandwidthEstimate=function(a){return this[this.bandwidthRule+"Rule"](a)};this.kernelDensityEstimator=function(a,c){var b=this[this.densityKernel+"Kernel"];return function(e,d){return a.map(function(f){var g=-1;var j=0;var h=e.length;while(++g<h){j+=b((f-e[g])/c)}return[f,j/c/h]})}};this.density=function(A,B){var g=this.range(A);var s=g[0];var y=g[1];var q=this.getBandwidthEstimate(A);var r=(s-this.bandwidthCut*q);var d=(y+this.bandwidthCut*q);var t=(d-r)/256;var m=[];for(var n=r;n<d;n+=t){m.push(n)}var z=this.kernelDensityEstimator(m,q);var h=z(A);var f=[];var e=[];var p=0;var c=Infinity;var b=0;var a=this;for(var w=0;w<h.length;w++){if(isNaN(h[w][1])){h[w][1]=0}}for(var w=0;w<h.length;w++){if(h[w][0]>s&&h[w][0]<y){if(f.length==0){r=w;f.push(h[w-1][0]);e.push(h[w-1][1]);b+=h[w-1][1];p=Math.max(p,h[w-1][1]);c=Math.min(c,h[w-1][1])}f.push(h[w][0]);e.push(h[w][1]);b+=h[w][1];p=Math.max(p,h[w][1]);c=Math.min(c,h[w][1])}else{if(h[w][0]>=y){d=w;f.push(h[w][0]);e.push(h[w][1]);b+=h[w][1];p=Math.max(p,h[w][1]);c=Math.min(c,h[w][1]);break}}}var l=this.boxplot(f);var k=this.boxplot(e);var o=[];for(var w=0;w<6;w++){for(var u=0;u<f.length;u++){if(f[u]>=l[w]){o.push(e[u]);break}}}return{range:g,trim:[r,Math.max(r,d)],xy:h,bw:q,quantilesX:l,quantilesY:k,indecesY:o,sumY:b,maxY:p,minY:c,histogram:this.hist(A,B),name:B,n:A.length}};this.freedmanDiaconis=function(b,a,c){if(b&&b.length>1){b=this.cleanArray(b,a,c);var d=this.iqr(b);return d==0?1:Math.ceil(2*d*Math.pow(b.length,-1/3))}else{if(b&&b.length==1){return Number(b[0])}else{return 1}}};this.sturges=function(b,a,d){if(b&&b.length>1){b=this.cleanArray(b,a,d);var c=this.range(b);return Math.ceil(Math.log(b.length)/Math.LN2)+1}else{if(b&&b.length==1){return Number(b[0])}else{return 1}}};this.scott=function(b,a,e){if(b&&b.length>1){b=this.cleanArray(b,a,e);var c=this.range(b);var d=Math.sqrt(this.vriance(b));return Math.ceil((c[1]-c[0])/(3.5*d*Math.pow(b.length,-1/3)))}else{if(b&&b.length==1){return Number(b[0])}else{return 1}}};this.histBin=function(e,d,f,c){var a=Math.floor((e-d)/f);if(e==c[a]&&a>0){a--}return a};this.hist2D=function(h,a,m){if(this.isArray(h)&&this.isArray(h[0])&&h.length>1){var k={count:[],idxs:[],maxY:0};var e=[];for(var f=0;f<h.length;f++){e=e.concat(h[f])}var l=this.hist(e,a);for(var f=0;f<h.length;f++){k.count[f]=[];k.idxs[f]=[];for(var d=0;d<l.count.length;d++){k.count[f][d]=0;k.idxs[f][d]=[]}var c=m||l.breaks[0];for(var d=0;d<h[f].length;d++){var b=h[f][d];var n=this.histBin(b,c,l.size,l.breaks);k.count[f][n]++;k.idxs[f][n].push(d);k.maxY=Math.max(k.maxY,k.count[f][n])}}l.global=k;return l}else{if(this.isArray(h)&&this.isArray(h[0])&&h.length==1){return this.hist(h[0],a)}else{return this.hist(h,a)}}};this.hist=function(h,c){var b=this.range(h);var f=b[0];var m=b[0]==b[1]?b[0]+1:b[1];var d=this[this.histogramSizeEstimator](h);var r=this.rPretty(f,m,Math.max(this.histogramBins||8,d));var n=this.approx(r[1]-r[0]);var l=this.approx(n/2);var e=[];var o=[];var p=[];var j=[];if(r[0]>f){r.unshift(r[0]-n)}if(r[r.length-1]<m){r.push(r[r.length-1]+n)}var k=r.length;for(var g=0;g<k-1;g++){e[g]=0;p[g]=[];o[g]=this.approx(r[g]+l)}for(var g=0;g<h.length;g++){var q=this.histBin(h[g],r[0],n,r);e[q]++;p[q].push(g)}var a=-Infinity;for(var g=0;g<e.length;g++){a=Math.max(a,e[g]);j.push("Bin"+(g+1)+" ("+r[g]+" - "+r[g+1]+")")}return{estimator:d,breaks:r,count:e,mids:o,idxs:p,size:n,half:l,maxY:a,name:c,labels:j}};this.pretty=function(a){var c=Math.pow(10,Math.floor(Math.log(a/10)/Math.LN10));var b=10/a*c;if(b<=0.15){c*=10}else{if(b<=0.35){c*=5}else{if(b<=0.75){c*=2}}}return c*10};this.round=function(a,b){return Number(Math.round(a+"e"+b)+"e-"+b)};this.getHistogramBin=function(c,a){var d=a*Math.floor(c/a);return parseFloat(d.toFixed(this.getAxisDecimals(a)))};this.toFixed=function(h,b){var e=b||0;var d=g<0;var a=Math.pow(10,e);var g=Math.round(h*a);var c=String((d?Math.ceil:Math.floor)(g/a));var i=String((d?-g:g)%a);var f=new Array(Math.max(e-i.length,0)+1).join("0");return e?c+"."+f+i:c};this.bezierCalculatePoints=function(g,e){var b=g[0][0];var a=g[0][1];var d=g[1][0];var c=g[1][1];var h=b+(d-b)*e;var f=a+(c-a)*e;return[h,f]};this.deCasteljau=function(e,d){if(d===1){return e[e.length-1]}if(d===0){return e[0]}if(e.length==1){return e[0]}var b=[];for(var c=1,a=e.length;c<a;c++){b.push(this.bezierCalculatePoints([e[c-1],e[c]],d))}return this.deCasteljau(b,d)};this.divideBezierCurve=function(f,e,c,g){c=c||[];g=g||[];c.push(f[0]);g.push(f[f.length-1]);if(f.length===1){return[c,g]}var b=[];for(var d=1,a=f.length;d<a;d++){b.push(this.bezierCalculatePoints([f[d-1],f[d]],e))}return this.divideBezierCurve(b,e,c,g)};this.centroid=function(a){var c=[];if(!a||a.length<2){return[0,0]}else{if(a.length<3||a.length%2){return[a[0],a[1]]}else{while(a.length>1){c.push([a.shift(),a.shift()])}}}var b=c.reduce(function(d,e){return[d[0]+e[0]/c.length,d[1]+e[1]/c.length]},[0,0]);return b};this.centroidArea=function(a){var b=this.cloneObject(a);b.shift();return this.centroid(b)};this.prufer=function(c){var b=[];var e=Array.apply(null,Array(c.length+2)).map(function(a,j){return j});var h=Array.apply(null,Array(1*e.length)).map(function(){return 1});c.map(function(a){h[a]++});for(var f=0;f<c.length;f++){for(var d=0;d<e.length;d++){if(h[e[d]]===1){b.push([c[f],e[d]]);h[c[f]]--;h[e[d]]--;break}}}var g=e.filter(function(a){return h[a]===1});b.push(g);return b};this.getD3Sankey=function(){var h=function(D,C){return D<C?-1:D>C?1:D>=C?0:NaN};var f=function(H,F){var E=0,G=H.length,C,D=-1;if(F==null){while(++D<G){if(C=+H[D]){E+=C}}}else{while(++D<G){if(C=+F(H[D],D,H)){E+=C}}}return E};var t=function(H,F){var E=-1,G=H.length,D,C;if(F==null){while(++E<G){if((C=H[E])!=null&&C>=C){D=C;break}}while(++E<G){if((C=H[E])!=null&&D>C){D=C}}}else{while(++E<G){if((C=F(H[E],E,H))!=null&&C>=C){D=C;break}}while(++E<G){if((C=F(H[E],E,H))!=null&&D>C){D=C}}}return D};var x=function(D,C){return D=+D,C-=D,function(E){return D+C*E}};var v="$";function j(){}j.prototype=A.prototype={constructor:j,has:function(C){return(v+C) in this},get:function(C){return this[v+C]},set:function(C,D){this[v+C]=D;return this},remove:function(C){var D=v+C;return D in this&&delete this[D]},clear:function(){for(var C in this){if(C[0]===v){delete this[C]}}},keys:function(){var C=[];for(var D in this){if(D[0]===v){C.push(D.slice(1))}}return C},values:function(){var C=[];for(var D in this){if(D[0]===v){C.push(this[D])}}return C},entries:function(){var C=[];for(var D in this){if(D[0]===v){C.push({key:D.slice(1),value:this[D]})}}return C},size:function(){var C=0;for(var D in this){if(D[0]===v){++C}}return C},empty:function(){for(var C in this){if(C[0]===v){return false}}return true},each:function(D){for(var C in this){if(C[0]===v){D(this[C],C.slice(1),this)}}}};function A(C,F){var G=new j;if(C instanceof j){C.each(function(K,J){G.set(J,K)})}else{if(Array.isArray(C)){var E=-1,I=C.length,H;if(F==null){while(++E<I){G.set(E,C[E])}}else{while(++E<I){G.set(F(H=C[E],E,C),H)}}}else{if(C){for(var D in C){G.set(D,C[D])}}}}return G}var z=function(){var G=[],I=[],F,H,E;function D(P,N,L,Q){if(N>=G.length){return H!=null?H(P):(F!=null?P.sort(F):P)}var O=-1,J=P.length,T=G[N++],M,R,K=A(),S,U=L();while(++O<J){if(S=K.get(M=T(R=P[O])+"")){S.push(R)}else{K.set(M,[R])}}K.each(function(V,W){Q(U,W,D(V,N,L,Q))});return U}function C(K,L){if(++L>G.length){return K}var M,J=I[L-1];if(H!=null&&L>=G.length){M=K.entries()}else{M=[],K.each(function(O,N){M.push({key:N,values:C(O,L)})})}return J!=null?M.sort(function(O,N){return J(O.key,N.key)}):M}return E={object:function(J){return D(J,0,r,o)},map:function(J){return D(J,0,s,B)},entries:function(J){return C(D(J,0,s,B),0)},key:function(J){G.push(J);return E},sortKeys:function(J){I[G.length-1]=J;return E},sortValues:function(J){F=J;return E},rollup:function(J){H=J;return E}}};function r(){return{}}function o(C,D,E){C[D]=E}function s(){return A()}function B(E,C,D){E.set(C,D)}var l={};var e=12;var i=5;var m=[1,1];var p=[];var d=[];l.nodeWidth=function(C){if(!arguments.length){return e}e=+C;return l};l.nodePadding=function(C){if(!arguments.length){return i}i=+C;return l};l.nodes=function(C){if(!arguments.length){return p}p=C;return l};l.links=function(C){if(!arguments.length){return d}d=C;return l};l.size=function(C){if(!arguments.length){return m}m=C;return l};l.layout=function(C){c();k();a();g(C);b();u();return l};l.relayout=function(){b();u();return l};l.link=function(){var D=0.5;function C(L){var I=L.source.x+L.source.dx,H=L.target.x,G=x(I,H),F=G(D),E=G(1-D),K=L.source.y+L.sy+L.dy/2,J=L.target.y+L.ty+L.dy/2;return"M"+I+","+K+"C"+F+","+K+" "+E+","+J+" "+H+","+J}C.curvature=function(E){if(!arguments.length){return D}D=+E;return C};return C};function u(){var C=0.5;d.forEach(function(K){var H=K.source.x+K.source.dx,G=K.target.x,F=x(H,G),E=F(C),D=F(1-C),J=K.source.y+K.sy+K.dy/2,I=K.target.y+K.ty+K.dy/2;K.bezier=[[H,E,D,G],[J,J,I,I]]})}function c(){p.forEach(function(C){C.sourceLinks=[];C.targetLinks=[]});d.forEach(function(C){var D=C.source,E=C.target;if(typeof D==="number"){D=C.source=p[C.source]}if(typeof E==="number"){E=C.target=p[C.target]}D.sourceLinks.push(C);E.targetLinks.push(C)})}function k(){p.forEach(function(C){C.value=Math.max(f(C.sourceLinks,q),f(C.targetLinks,q))})}function a(){var D=p,E,C=0;while(D.length){E=[];D.forEach(function(F){F.x=C;F.breadth=C;F.dx=e;F.sourceLinks.forEach(function(G){E.push(G.target)})});D=E;++C}w(C);n((m[0]-e)/(C-1))}function w(C){p.forEach(function(D){if(!D.sourceLinks.length){D.x=C-1}})}function n(C){p.forEach(function(D){D.x*=C})}function g(H){var C=z().key(function(K){return K.x}).sortKeys(h).entries(p).map(function(K){return K.values});F();J();for(var I=1;H>0;--H){D(I*=0.99);J();E(I);J()}function F(){var K=t(C,function(L){return(m[1]-(L.length-1)*i)/f(L,q)});C.forEach(function(L){L.forEach(function(N,M){N.y=M;N.dy=N.value*K})});d.forEach(function(L){L.dy=L.value*K})}function E(L){C.forEach(function(M,N){M.forEach(function(O){if(O.targetLinks.length){var P=f(O.targetLinks,K)/f(O.targetLinks,q);O.y+=(P-y(O))*L}})});function K(M){return y(M.source)*M.value}}function D(L){C.slice().reverse().forEach(function(M){M.forEach(function(N){if(N.sourceLinks.length){var O=f(N.sourceLinks,K)/f(N.sourceLinks,q);N.y+=(O-y(N))*L}})});function K(M){return y(M.target)*M.value}}function J(){C.forEach(function(L){var O,K,N=0,P=L.length,M;L.sort(G);for(M=0;M<P;++M){O=L[M];K=N-O.y;if(K>0){O.y+=K}N=O.y+O.dy+i}K=N-i-m[1];if(K>0){N=O.y-=K;for(M=P-2;M>=0;--M){O=L[M];K=O.y+O.dy+i-N;if(K>0){O.y-=K}N=O.y}}})}function G(L,K){return L.y-K.y}}function b(){p.forEach(function(E){E.sourceLinks.sort(C);E.targetLinks.sort(D)});p.forEach(function(F){var G=0,E=0;F.sourceLinks.forEach(function(H){H.sy=G;G+=H.dy});F.targetLinks.forEach(function(H){H.ty=E;E+=H.dy})});function D(F,E){return F.source.y-E.source.y}function C(F,E){return F.target.y-E.target.y}}function y(C){return C.y+C.dy/2}function q(C){return C.value}return l};this.setSankey=function(){var a=this.getD3Sankey();a.nodeWidth(this.sankeyNodeWidth);a.nodePadding(this.margin);a.size([this.x,this.y]);a.nodes(this.data.sankey.nodes);a.links(this.data.sankey.links);a.layout(this.sankeyIterations);this.data.sankey.object=a};this.getD3Tree=function(){var b=this;var l=function(y,x,w){var z=w/(x.i-y.i);x.c-=z;x.s+=w;y.c+=z;x.z+=w;x.m+=w};var f=function(z){var y=0;var C=0;var B=z.children;var A=B.length;var x;while(--A>=0){x=B[A];x.z+=y;x.m+=y;y+=x.s+(C+=x.c)}};var a=function(x,w,y){return x.a.parent===w.parent?x.a:y};var r=function(w){var x=w.children;return x?x[0]:w.t};var v=function(w){var x=w.children;return x?x[x.length-1]:w.t};var e=function(x,w){return x.parent===w.parent?1:2};var i=1;var g=1;var n=null;var h=function(z,x){if(z===x){return z}var y=z.ancestors();var w=x.ancestors();var A=null;z=y.pop();x=w.pop();while(z===x){A=z;z=y.pop();x=w.pop()}return A};var d=function(w){w.data=w.data.data};var j=function(x){var w=0;do{x.height=w}while((x=x.parent)&&(x.height<++w))};var c=function(C,y){var F=new u(C);var D=+C.value&&(F.value=C.value);var A;var w=[F];var x;var E;var B;var z;if(y==null){y=function(G){return G.children}}while(A=w.pop()){if(D){A.value=+A.data.value}if((E=y(A.data))&&(z=E.length)){A.children=new Array(z);for(B=z-1;B>=0;--B){w.push(x=A.children[B]=new u(E[B]));x.parent=A;x.depth=A.depth+1}}}return F.eachBefore(j)};var u=function(w){this.data=w;this.depth=0;this.height=0;this.parent=null;if(this.nid==null){this.id=b.treeNodeId++}};u.prototype=c.prototype={constructor:u,count:function(){return this.eachAfter(count)},each:function(C){var z=this;var A;var y=[z];var x,w,B;do{A=y.reverse();y=[];while(z=A.pop()){C(z);x=z.children;if(x){for(w=0,B=x.length;w<B;++w){y.push(x[w])}}}}while(y.length);return this},eachAfter:function(C){var A=this;var w=[A];var z=[];var y,x,B;while(A=w.pop()){z.push(A);y=A.children;if(y){for(x=0,B=y.length;x<B;++x){w.push(y[x])}}}while(A=z.pop()){C(A)}return this},eachBefore:function(A){var z=this;var w=[z];var y,x;while(z=w.pop()){A(z);y=z.children;if(y){for(x=y.length-1;x>=0;--x){w.push(y[x])}}}return this},sum:function(w){return this.eachAfter(function(A){var z=+w(A.data)||0;var y=A.children;var x=y&&y.length;while(--x>=0){z+=y[x].value}A.value=z})},sort:function(w){return this.eachBefore(function(x){if(x.children){x.children.sort(w)}})},path:function(w){var A=this;var z=h(A,w);var y=[A];while(A!==z){A=A.parent;y.push(A)}var x=y.length;while(w!==z){y.splice(x,0,w);w=w.parent}return y},ancestors:function(){var x=this;var w=[x];while(x=x.parent){w.push(x)}return w},descendants:function(){var w=[];this.each(function(x){w.push(x)});return w},leaves:function(){var w=[];this.eachBefore(function(x){if(!x.children){w.push(x)}});return w},links:function(){var w=this;var x=[];w.each(function(y){if(y!==w){x.push({source:y.parent,target:y})}});return x},copy:function(){return c(this).eachBefore(d)}};var p=function(x,w){this._=x;this.parent=null;this.children=null;this.A=null;this.a=this;this.z=0;this.m=0;this.c=0;this.s=0;this.t=null;this.i=w};p.prototype=Object.create(u.prototype);var q=function(x){var w=new p(x,0);var B;var y=[w];var D;var A;var z;var C;while(B=y.pop()){if(A=B._.children){B.children=new Array(C=A.length);for(z=C-1;z>=0;--z){y.push(D=B.children[z]=new p(A[z],z));D.parent=B}}}(w.parent=new p(null,0)).children=[w];return w};function k(B){var D=q(B);D.eachAfter(t),D.parent.m=-D.z;D.eachBefore(o);if(n){B.eachBefore(s)}else{var x=B;var C=B;var w=B;B.eachBefore(function(F){if(F.x<x.x){x=F}if(F.x>C.x){C=F}if(F.depth>w.depth){w=F}});var E=x===C?1:e(x,C)/2;var y=E-x.x;var A=i/(C.x+E+y);var z=g/(w.depth||1);B.eachBefore(function(F){F.x=(F.x+y)*A;F.y=F.depth*z})}return B}function t(y){var A=y.children;var B=y.parent.children;var x=y.i?B[y.i-1]:null;if(A){f(y);var z=(A[0].z+A[A.length-1].z)/2;if(x){y.z=x.z+e(y._,x._);y.m=y.z-z}else{y.z=z}}else{if(x){y.z=x.z+e(y._,x._)}}y.parent.A=m(y,x,y.parent.A||B[0])}function o(w){w._.x=w.z+w.parent.m;w.m+=w.parent.m}function m(I,H,C){if(H){var z=I;var y=I;var B=H;var A=z.parent.children[0];var E=z.m;var D=y.m;var G=B.m;var F=A.m;var x;while(B=v(B),z=r(z),B&&z){A=r(A);y=v(y);y.a=I;x=B.z+G-z.z-E+e(B._,z._);if(x>0){l(a(B,I,C),I,x);E+=x;D+=x}G+=B.m;E+=z.m;F+=A.m;D+=y.m}if(B&&!v(y)){y.t=B;y.m+=G-D}if(z&&!r(A)){A.t=z;A.m+=E-F;C=I}}return C}function s(w){w.x*=i;w.y=w.depth*g}k.separation=function(w){return arguments.length?(e=w,k):e};k.size=function(w){return arguments.length?(n=false,i=+w[0],g=+w[1],k):(n?null:[i,g])};k.nodeSize=function(w){return arguments.length?(n=true,i=+w[0],g=+w[1],k):(n?[i,g]:null)};k.setTree=function(x,w){return c(x,w)};k.collapse=function(w){k.collapseTree(w);k.update(w)};k.expand=function(w){k.expandTree(w);k.update(w)};k.collapseTree=function(w){if(w.children){w._children=w.children;w._children.forEach(k.collapseTree);w.children=null}};k.expandTree=function(w){if(w._children){w.children=w._children;w.children.forEach(k.expandTree);delete w._children}};return k};this.setTree=function(){var b=[];if(this.treeCircular){b=this.x>this.y?[360,this.y/2]:[360,this.x/2]}else{b=[this.graphOrientation=="vertical"?this.x:this.y,this.graphOrientation=="vertical"?this.y:this.x]}var a=function(d,c){return(d.parent==c.parent?1:2)/d.depth};this.data.tree.object=this.treeCircular?this.getD3Tree().size(b).separation(a):this.getD3Tree().size(b);if(!this.data.tree.root){this.data.tree.root=this.getD3Tree().setTree(this.data.tree.data,function(c){return c.children})}this.data.tree.plot=this.data.tree.object(this.data.tree.root);this.data.tree.plot.size=b};this.getD3CirclePack=function(){var l=this;var r=function(K,I){if(K===I){return K}var J=K.ancestors();var H=I.ancestors();var L=null;K=J.pop();I=H.pop();while(K===I){L=K;K=J.pop();I=H.pop()}return L};var o=function(H){H.data=H.data.data};var w=function(I){var H=0;do{I.height=H}while((I=I.parent)&&(I.height<++H))};var m=function(N,J){var Q=new F(N);var O=+N.value&&(Q.value=N.value);var L;var H=[Q];var I;var P;var M;var K;if(J==null){J=function(R){return R.children}}while(L=H.pop()){if(O){L.value=+L.data.value}if((P=J(L.data))&&(K=P.length)){L.children=new Array(K);for(M=K-1;M>=0;--M){H.push(I=L.children[M]=new F(P[M]));I.parent=L;I.depth=L.depth+1}}}return Q.eachBefore(w)};var F=function(H){this.data=H;this.depth=0;this.height=0;this.parent=null;if(this.nid==null){this.id=l.treeNodeId++}};F.prototype=m.prototype={constructor:F,count:function(){return this.eachAfter(count)},each:function(N){var K=this;var L;var J=[K];var I,H,M;do{L=J.reverse();J=[];while(K=L.pop()){N(K);I=K.children;if(I){for(H=0,M=I.length;H<M;++H){J.push(I[H])}}}}while(J.length);return this},eachAfter:function(N){var L=this;var H=[L];var K=[];var J,I,M;while(L=H.pop()){K.push(L);J=L.children;if(J){for(I=0,M=J.length;I<M;++I){H.push(J[I])}}}while(L=K.pop()){N(L)}return this},eachBefore:function(L){var K=this;var H=[K];var J,I;while(K=H.pop()){L(K);J=K.children;if(J){for(I=J.length-1;I>=0;--I){H.push(J[I])}}}return this},sum:function(H){return this.eachAfter(function(L){var K=+H(L.data)||0;var J=L.children;var I=J&&J.length;while(--I>=0){K+=J[I].value}L.value=K})},sort:function(H){return this.eachBefore(function(I){if(I.children){I.children.sort(H)}})},path:function(H){var L=this;var K=r(L,H);var J=[L];while(L!==K){L=L.parent;J.push(L)}var I=J.length;while(H!==K){J.splice(I,0,H);H=H.parent}return J},ancestors:function(){var I=this;var H=[I];while(I=I.parent){H.push(I)}return H},descendants:function(){var H=[];this.each(function(I){H.push(I)});return H},leaves:function(){var H=[];this.eachBefore(function(I){if(!I.children){H.push(I)}});return H},links:function(){var H=this;var I=[];H.each(function(J){if(J!==H){I.push({source:J.parent,target:J})}});return I},copy:function(){return m(this).eachBefore(o)}};var e=null;var s=1;var q=1;var h=function(H){this._=H;this.next=null};var g=function(M){var I;var L=(M=M.slice()).length;var H=null;var K=H;while(L){var J=new h(M[L-1]);if(K){K=K.next=J}else{K=H=J}M[I]=M[--L]}return{head:H,tail:K}};var t=function(H){return G(g(H),[])};var d=function(J,H){var K=H.x-J.x;var I=H.y-J.y;var L=J.r-H.r;return L*L+0.000001>K*K+I*I};var G=function(I,O){var M;var K=null;var J=I.head;var H;var N;switch(O.length){case 1:M=y(O[0]);break;case 2:M=x(O[0],O[1]);break;case 3:M=u(O[0],O[1],O[2]);break}while(J){N=J._;H=J.next;if(!M||!d(M,N)){if(K){I.tail=K;K.next=null}else{I.head=I.tail=null}O.push(N);M=G(I,O);O.pop();if(I.head){J.next=I.head;I.head=J}else{J.next=null;I.head=I.tail=J}K=I.tail;K.next=H}else{K=J}J=H}I.tail=K;return M};var y=function(H){return{x:H.x,y:H.y,r:H.r}};var x=function(S,P){var I=S.x;var R=S.y;var K=S.r;var H=P.x;var O=P.y;var J=P.r;var N=H-I;var Q=O-R;var L=J-K;var M=Math.sqrt(N*N+Q*Q);return{x:(I+H+N/M*L)/2,y:(R+O+Q/M*L)/2,r:(M+K+J)/2}};var u=function(ag,ae,ad){var ac=ag.x;var L=ag.y;var X=ag.r;var aa=ae.x;var K=ae.y;var V=ae.r;var Y=ad.x;var I=ad.y;var U=ad.r;var aj=2*(ac-aa);var N=2*(L-K);var T=2*(V-X);var ak=ac*ac+L*L-X*X-aa*aa-K*K+V*V;var ah=2*(ac-Y);var M=2*(L-I);var S=2*(U-X);var ai=ac*ac+L*L-X*X-Y*Y-I*I+U*U;var af=ah*N-aj*M;var Z=(N*ai-M*ak)/af-ac;var W=(M*T-N*S)/af;var J=(ah*ak-aj*ai)/af-L;var H=(aj*S-ah*T)/af;var R=W*W+H*H-1;var Q=2*(Z*W+J*H+X);var P=Z*Z+J*J-X*X;var O=(-Q-Math.sqrt(Q*Q-4*R*P))/(2*R);return{x:Z+W*O+ac,y:J+H*O+L,r:O}};var n=function(M,K,I){var H=M.x;var Q=M.y;var R=K.r+I.r;var P=M.r+I.r;var S=K.x-H;var O=K.y-Q;var N=S*S+O*O;if(N){var L=0.5+((P*=P)-(R*=R))/(2*N);var J=Math.sqrt(Math.max(0,2*R*(P+N)-(P-=N)*P-R*R))/(2*N);I.x=H+L*S+J*O;I.y=Q+L*O-J*S}else{I.x=H+P;I.y=Q}};var a=function(J,H){var K=H.x-J.x;var I=H.y-J.y;var L=J.r+H.r;return L*L-0.000001>K*K+I*I};var A=function(M,I,O){var K=M._;var H=M.next._;var N=K.r+H.r;var L=(K.x*H.r+H.x*K.r)/N-I;var J=(K.y*H.r+H.y*K.r)/N-O;return L*L+J*J};var i=function(H){this._=H;this.next=null;this.previous=null};var k=function(P){if(!(N=P.length)){return 0}var U,N,R,V,V,T;var X=P[0];X.x=0;X.y=0;if(!(N>1)){return X.r}var W=P[1];X.x=-W.r;W.x=X.r;W.y=0;if(!(N>2)){return X.r+W.r}n(W,X,U=P[2]);var Y=X.r*X.r;var L=W.r*W.r;var M=U.r*U.r;var Q=Y+L+M;var K=Y*X.x+L*W.x+M*U.x;var J=Y*X.y+L*W.y+M*U.y;var I,H,S,R,O,V,T;X=new i(X);W=new i(W);U=new i(U);X.next=U.previous=W;W.next=X.previous=U;U.next=W.previous=X;B:for(var S=3;S<N;++S){n(X._,W._,U=P[S]);U=new i(U);R=W.next;O=X.previous;V=W._.r;T=X._.r;do{if(V<=T){if(a(R._,U._)){W=R;X.next=W;W.previous=X;--S;continue B}V+=R._.r;R=R.next}else{if(a(O._,U._)){X=O;X.next=W;W.previous=X;--S;continue B}T+=O._.r;O=O.previous}}while(R!==O.next);U.previous=X;U.next=W;X.next=W.previous=W=U;Q+=M=U._.r*U._.r;K+=M*U._.x;J+=M*U._.y;Y=A(X,I=K/Q,H=J/Q);while((U=U.next)!==W){if((M=A(U,I,H))<Y){X=U;Y=M}}W=X.next}X=[W._];U=W;while((U=U.next)!==W){X.push(U._)}U=t(X);for(var S=0;S<N;++S){X=P[S];X.x-=U.x;X.y-=U.y}return U.r};var j=function(H){k(H);return H};var E=function(H){return H==null?null:p(H)};var p=function(H){if(typeof H!=="function"){throw new Error}return H};var z=function(){return 0};var f=function(H){return function(){return H}};var D=function(H){return Math.sqrt(H.value)};var E=function(H){return H==null?null:p(H)};var C=function(H){return function(I){if(!I.children){I.r=Math.max(0,+H(I)||0)}}};var c=function(I,H){return function(M){if(K=M.children){var K,J,O=K.length,L=I(M)*H||0,N;if(L){for(J=0;J<O;++J){K[J].r+=L}}N=k(K);if(L){for(J=0;J<O;++J){K[J].r-=L}}M.r=N+L}}};var b=function(H){return function(J){var I=J.parent;J.r*=H;if(I){J.x=I.x+H*J.x;J.y=I.y+H*J.y}}};var v=z;function B(H){H.x=s/2,H.y=q/2;if(e){H.eachBefore(C(e)).eachAfter(c(v,0.5)).eachBefore(b(1))}else{H.eachBefore(C(D)).eachAfter(c(z,1)).eachAfter(c(v,H.r/Math.min(s,q))).eachBefore(b(Math.min(s,q)/(2*H.r)))}return H}B.radius=function(H){return arguments.length?(e=E(H),B):e};B.size=function(H){return arguments.length?(s=+H[0],q=+H[1],B):[s,q]};B.padding=function(H){return arguments.length?(v=typeof H==="function"?H:f(+H),B):v};B.setPack=function(H){return m(H).sum(function(I){return I.size}).sort(function(J,I){return I.value-J.value})};return B};this.setCirclePack=function(){var b=Math.max(this.top,this.right);var a=this.width-(this.right+this.left+this.marginLeft+this.marginRight);var e=this.height-(this.top+this.bottom+this.marginTop+this.marginBottom);var c=a>e?e:a;this.data.bubble.object=this.getD3CirclePack().size([c,c]).padding(2);if(!this.data.bubble.root){this.data.bubble.root=this.getD3CirclePack().setPack(this.data.bubble.data)}this.data.bubble.plot=this.data.bubble.object(this.data.bubble.root);this.data.bubble.plot.diameter=c};this.setFunctionNames("initMathUtils")};CanvasXpress.prototype.initLayout=function(){this.isValidLayout=function(){var b=this.layoutTopology?this.layoutTopology.split(/X/i):this.layout.split(/X/i);if(this.layoutTopology){this.layoutRows=b[0];this.layoutCols=b[1]}else{if(this.layout){this.layoutRows=b[0];this.layoutCols=b[1]}else{this.layoutRows=1;this.layoutCols=1;this.layoutValid=false}}if(!this.scatterPlotMatrix&&this.layoutComb&&this.data.l&&(this.data.l.vars||this.data.l.smps)&&this.data.l.weight&&this.data.l.type){this.data.l.comp=[];if(this.data.l.vars&&this.data.l.smps){var m={};for(var l=0;l<this.data.y.vars.length;l++){m[this.data.y.vars[l]]=l}var q={};for(var l=0;l<this.data.y.smps.length;l++){q[this.data.y.smps[l]]=l}var p=0;for(var l=0;l<this.data.l.smps.length;l++){var f=[];var e=this.data.l.smps[l].length;for(var h=0;h<e;h++){f.push(q[this.data.l.smps[l][h]])}for(var h=0;h<this.data.l.vars.length;h++){var d=[];var e=this.data.l.vars[h].length;for(var g=0;g<e;g++){d.push(m[this.data.l.vars[h][g]])}this.data.l.comp[p]=[d,f];p++}}}else{if(this.data.l.vars){var a={};for(var l=0;l<this.data.y.vars.length;l++){a[this.data.y.vars[l]]=l}for(var l=0;l<this.data.l.vars.length;l++){this.data.l.comp[l]=[];var e=this.data.l.vars[l].length;for(var h=0;h<e;h++){this.data.l.comp[l].push(a[this.data.l.vars[l][h]])}}}else{var a={};for(var l=0;l<this.data.y.smps.length;l++){a[this.data.y.smps[l]]=l}for(var l=0;l<this.data.l.smps.length;l++){this.data.l.comp[l]=[];var e=this.data.l.smps[l].length;for(var h=0;h<e;h++){this.data.l.comp[l].push(a[this.data.l.smps[l][h]])}}}}this.layoutValid=true}else{if(this.layoutComb&&this.data.l&&this.data.l.smps&&this.data.l.weight&&this.data.l.type){this.data.l.comp=[];var o=[];for(var l=0;l<this.data.y.vars.length;l++){o.push(l)}for(var l=0;l<this.data.l.type.length;l++){this.data.l.comp[l]=o}this.layoutValid=true}else{if(this.data.l&&this.data.l.comp){if(this.data.l.comp.length<=(this.layoutRows*this.layoutCols)){this.layoutValid=true}else{this.layoutValid=false}}else{this.layoutValid=false}}}if(this.layoutValid){this.meta.config.orig.adjustAspectRatio=this.adjustAspectRatio;this.adjustAspectRatio=true}};this.setLayoutFonts=function(){this.setLegends();if(this.graphType=="Scatter2D"){this.set2DFont()}else{if(this.graphType=="Pie"){this.setPieFont()}else{this.set1DFont()}}};this.getLayoutAxisTitleHeight=function(a){var b=0;if(this.graphType=="Treemap"||this.graphType=="TagCloud"||this.graphType=="Pie"||this.graphType=="Heatmap"){return 0}else{if(this.graphType=="Scatter2D"){if(a){return this.yAxisTitle?this.axisTitleFontSize+(this.margin*2):0}else{return this.xAxisTitle?this.axisTitleFontSize+(this.margin*2):0}}else{if(this.graphOrientation=="vertical"){b=a?this.getAxisDescription(true):this.getAxisDescription();b=b!=""?this.axisTitleFontSize+(this.margin*2):0}else{b=a?this.getAxisDescription(true):this.getAxisDescription();b=b!=""?this.axisTitleFontSize+(this.margin*2):0}}}return b};this.setLayoutLeft=function(){var a=0;if(this.isDOE){a=0}else{if(this.graphType=="Scatter2D"){if(this.showLegend){a+=this.legendPosition=="left"?this.legendWidth:this.margin}if(!this.layoutAdjust){a+=this.segregateVariablesBy.length||this.segregateSamplesBy.length?this.get2DYAxisTitleWidth():this.get2DYAxisWidth()}a+=this.getLayoutAxisTitleHeight()}else{if(this.graphType=="Pie"){a=(this.margin*2)+this.measureText("XX",this.smpLabelFont)}else{if(this.graphType=="Candlestick"){if(this.graphOrientation!="vertical"){this.setTimeAxis();a=this.getSampleLabelLength()}else{a=0}}else{if(this.graphType=="Heatmap"){a=0}else{if(!this.layoutAdjust){if(this.segregateVariablesBy.length>0){if(this.graphOrientation!="vertical"){a=this.getSampleLabelLength()}else{a=this.getAxisTitleTickLength()}}else{if(this.segregateSamplesBy.length>0){if(this.graphOrientation=="vertical"){a=this.getAxisTitleTickLength()}}}}else{if(this.graphOrientation!="vertical"&&this.segregateVariablesBy.length){a=this.getSampleLabelLength()}}if(this.graphOrientation=="vertical"){a+=this.getLayoutAxisTitleHeight()}else{a+=this.smpTitle?this.smpTitleFontSize+(this.margin*2):0}if(this.showLegend){a+=this.legendPosition=="left"?this.legendWidth:this.margin}}}}}}return a};this.setLayoutRight=function(){var a=0;if(this.isDOE){a=0}else{if(this.graphType.match(/Scatter/)){if(this.showLegend){a=this.legendPosition=="right"?this.legendWidth:this.margin}if(!this.layoutAdjust||this.segregateVariablesBy.length||this.segregateSamplesBy.length){a+=this.get2DYAxisWidth(true)}}else{if(this.graphType=="Pie"){if(this.showLegend&&this.legendPosition=="right"){a=this.legendVariableWidth}}else{if(this.graphType=="Heatmap"){return 0}else{if(!this.layoutAdjust){if(this.graphOrientation=="vertical"){a=this.getAxisTitleTickLength(true)}}else{a=0}if(this.graphOrientation=="vertical"){a+=this.getLayoutAxisTitleHeight(true)}if(this.showLegend&&this.legendPosition=="right"){a+=this.getLegendWidth("right");if(this.graphOrientation!="vertical"){a+=this.margin}}}}}}return a};this.setLayoutTop=function(){if(this.isDOE){return 0}var a=this.getTitleSubtitleHeight();if(this.graphType=="Pie"){a+=this.getFontHeight()+(this.margin*2)}else{if(this.graphType=="Scatter2D"){if(this.showLegend&&this.legendPosition=="top"){a+=this.legendHeight}if(!this.layoutAdjust||this.segregateVariablesBy.length||this.segregateSamplesBy.length){a+=this.get2DXAxisHeight(true)}}else{if(this.graphType!="Heatmap"){if(this.showLegend&&this.legendPosition=="top"){a+=this.legendHeight}if(!this.layoutAdjust){if(this.graphOrientation!="vertical"){a+=this.getAxisTitleTickLength()}}if(this.graphOrientation!="vertical"){a+=this.getLayoutAxisTitleHeight()}}}}return a};this.setLayoutBottom=function(){var a=0;if(this.isDOE){a=0}else{if(this.graphType=="Scatter2D"){if(!this.layoutAdjust){a=this.segregateVariablesBy.length||this.segregateSamplesBy.length?this.get2DXAxisTitleHeight():this.get2DXAxisHeight()}if(this.showLegend&&this.legendPosition=="bottom"){a+=this.legendHeight}a+=this.getLayoutAxisTitleHeight()}else{if(this.graphType=="Pie"){if(this.showLegend&&this.legendPosition=="bottom"){var c=this.getPieLegendDimensions();a=c[1]}}else{if(this.graphType=="Candlestick"&&this.graphOrientation=="vertical"){this.setTimeAxis();a=this.getSampleLabelLength()}else{if(this.graphType=="Heatmap"){a=this.getHeatmapIndicatorHeight()}else{if(!this.layoutAdjust){if(this.graphOrientation!="vertical"){a=this.getAxisTitleTickLength(true)}}if(this.graphOrientation=="vertical"){if(this.segregateVariablesBy.length>0){a=this.getSampleLabelLength()}a+=this.smpTitle?this.smpTitleFontSize+(this.margin*2):0}else{a+=this.getLayoutAxisTitleHeight(true)}if(this.showLegend&&this.legendPosition=="bottom"){a+=this.getLegendHeight("bottom")}}}}}}return a};this.drawLayoutSampleOverlays=function(b){var a=this.smpIndices;this.smpIndices=b;this.smpIndices=a;this.showSampleNames=true;this.showOverlays=true;this.draw1DYLayout()};this.setLayoutDimensions=function(){var c=this.isGroupedData;this.offsetX=0;this.offsetY=0;this.isGroupedData=false;this.setLayoutFonts();this.setLayoutLegendDimensions();this.isGroupedData=c;this.layoutLeft=this.setLayoutLeft();this.layoutRight=this.setLayoutRight();this.layoutTop=this.setLayoutTop();this.layoutBottom=this.setLayoutBottom();if(this.layoutCanvasCompartments){var a=this.width-(this.marginLeft+this.layoutLeft+this.marginRight+this.layoutRight);var b=this.height-(this.marginTop+this.layoutTop+this.marginBottom+this.layoutBottom);this.addToRender(["drawShape","rectangle",this.marginLeft+this.layoutLeft+(a/2),this.marginTop+this.layoutTop+(b/2),a,b,false,this.canvasBoxColor,"open"])}};this.setLayoutLegendDimensions=function(){if(this.graphType=="Pie"||this.isDOE){this.setVariableLegendDimension()}else{if(this.graphType=="Scatter2D"||this.isMultidimensionalData||((this.colorBy||this.shapeBy||this.sizeBy||this.patternBy)&&this.graphType.match(/^Bar$|Boxplot|Dotplot|Treemap|Heatmap/))){this.validatePropertyValues(true)}else{this.setVariableLegendDimension()}}};this.drawLabelsTitlesLayout=function(){this.functionCaller="drawLabelsTitlesLayout";var k=0;var f=0;var q=0;var C=0;var D=this.width-(this.marginLeft+this.layoutLeft+this.layoutRight+this.marginRight);var b=this.height-(this.marginTop+this.layoutTop+this.layoutBottom+this.marginBottom);if(this.graphType=="Treemap"){return}if(this.graphType=="Pie"&&(this.showPieGrid||this.showPieSampleLabel)){var z,m;var A=0;this.setFont();var s=this.getFontPt(this.font);var d=this.marginTop+this.layoutTop;var a=this.marginLeft+this.layoutLeft;var n=["A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z"];for(var v=0;v<this.layoutRows;v++){z=b*this.layoutParams[A].weight[1];k=(this.marginLeft+this.layoutLeft)-this.margin;d+=z;if(this.showPieGrid){this.addToRender(["drawText",n[v],k,(d+(s/2))-(z/2),this.font,this.foreground,"right","middle"])}for(var u=0;u<this.layoutCols;u++){if(this.xAxis.length<=A){break}m=D*this.layoutParams[A].weight[0];a+=m;f=(this.marginTop+this.layoutTop)-this.margin;if(v==0){if(this.showPieGrid){this.addToRender(["drawText",u+1,(a+(s/2))-(m/2),f,this.font,this.foreground,"center","bottom"])}}if(this.showPieSampleLabel){this.addToRender(["drawText",this.xAxis[A],a-(m/1.1),d-(z/5),this.legendFont,this.foreground,"center","middle"])}A++}a=this.marginLeft+this.layoutLeft}}else{if(this.graphType=="Scatter2D"){if(this.yAxisTitle){var B=((this.height-(this.marginTop+this.layoutTop+this.marginBottom+this.layoutBottom))/2)+(this.marginTop+this.layoutTop);var o=this.marginLeft+this.margin+(this.axisTitleFontSize/2)+((this.showLegend&&this.legendPosition=="left"?this.legendWidth:0)-this.margin);this.addToRender(["drawText",this.yAxisTitle,o,B,this.axisTitleFont,this.axisTitleFontColor,"center","middle",-Math.PI/2])}if(this.xAxisTitle){var t=0;var m=this.width-(this.marginLeft+this.layoutLeft+this.layoutRight+this.marginRight);var z=this.marginBottom+this.margin+(this.axisTitleFontSize/2)+t+(this.showLegend&&this.legendPosition=="bottom"?this.legendHeight:0);this.addToRender(["drawText",this.xAxisTitle,this.marginLeft+this.layoutLeft+(m/2),this.height-z,this.axisTitleFont,this.axisTitleFontColor,"center","middle"])}}else{if(this.graphType=="Heatmap"){this.draw1DXLayout()}if(this.smpTitle&&this.graphType!="Heatmap"){if(this.graphOrientation=="vertical"){var t=this.legendPosition=="bottom"?this.getLegendHeight():0;var m=this.width-(this.marginLeft+this.layoutLeft+this.layoutRight+this.marginRight);var z=this.marginBottom+this.margin+(this.smpTitleFontSize/2)+t;this.addToRender(["drawText",this.smpTitle,this.marginLeft+this.layoutLeft+(m/2),this.height-z,this.smpTitleFont,this.smpTitleFontColor,"center","middle"])}else{this.addToRender(["drawText",this.smpTitle,this.marginLeft+this.margin+(this.smpTitleFontSize/2),this.height/2,this.smpTitleFont,this.smpTitleFontColor,"center","middle",-Math.PI/2])}}var g=this.getAxisDescription();var e=this.getAxisDescription(true);if(g!=""&&this.graphType!="Heatmap"&&this.xAxisShow){if(this.graphOrientation=="vertical"){var o=this.marginLeft+this.margin+(this.axisTitleFontSize/2)+(this.showLegend&&this.legendPosition=="left"?this.legendWidth:0);var B=((this.height-this.layoutTop)/2)+this.layoutTop;this.addToRender(["drawText",g,o,B,this.axisTitleFont,this.axisTitleFontColor,"center","middle",-Math.PI/2])}else{var m=this.width-(this.marginLeft+this.layoutLeft+this.layoutRight+this.marginRight);var z=this.margin+(this.axisTitleFontSize/2)+this.getTitleSubtitleHeight()+(this.showLegend&&this.legendPosition=="top"?this.legendHeight:0);this.addToRender(["drawText",g,this.marginLeft+this.layoutLeft+(m/2),this.marginTop+z,this.axisTitleFont,this.axisTitleFontColor,"center","middle"])}}if(e!=""&&this.graphType!="Heatmap"&&this.xAxis2Show){if(this.graphOrientation=="vertical"){var t=this.legendPosition=="right"?this.getLegendWidth():0;var p=this.marginRight+this.margin+(this.axisTitleFontSize/2)+t;this.addToRender(["drawText",e,this.width-p,this.height/2,this.axisTitleFont,this.axisTitleFontColor,"center","middle",Math.PI/2])}else{var t=this.legendPosition=="bottom"?this.getLegendHeight():0;var m=this.width-(this.marginLeft+this.layoutLeft+this.layoutRight+this.marginRight);var z=this.marginBottom+this.margin+(this.axisTitleFontSize/2)+t;this.addToRender(["drawText",e,this.marginLeft+this.layoutLeft+(m/2),this.height-z,this.axisTitleFont,this.axisTitleFontColor,"center","middle"])}}}}};this.drawDOELabelsLayout=function(m){this.functionCaller="drawDOELabelsLayout";var g=this.foreground;var j=this.font;var e=this.measureText(m,j);var b=this.getFontPt(j)/2;var l=this.layoutWidth;var d=this.layoutHeight;var k=this.marginLeft+this.offsetX;var i=this.marginTop+this.offsetY;var a=k+l-5;var c=i+d-5;this.addToRender(["drawText",m,k+20,i,j,g,"left","top"]);this.addToRender(["drawLine","line",k+b,i+b,k+15,i+b,g]);this.addToRender(["drawLine","line",k+e+25,i+b,a,i+b,g]);this.addToRender(["drawLine","line",a,i+b,a,c,g]);this.addToRender(["drawLine","line",k+b,c,a,c,g]);this.addToRender(["drawLine","line",k+b,i+b,k+b,c,g])};this.setLayoutWeights=function(){var a=this.data.l.weight;var d=this.layoutParams;var e=this.data.l.comp;if(a){if(this.isDOE||this.scatterPlotMatrix||(this.data.l.vars&&this.data.l.smps)){for(var b=0;b<a.length;b++){d[b].weight=a[b]}}else{if(this.graphType=="Pie"){for(var b=0;b<e.length;b++){d[b].weight=a[b]}}else{for(var b=0;b<a.length;b++){d[b].weight=a[b]}}}}else{if(e){a=[];for(var b=0;b<e.length;b++){a[b]=e.length;d[b].weight=a[b]}}else{alert("Wuz going on dude? This aint't gonna work!")}}};this.setLayoutGraphTypes=function(){var b=this.data.l.type;if(b){for(var a=0;a<b.length;a++){this.layoutParams[a].graphType=b&&b[a]?b[a]:this.graphType}}};this.setLayoutIndices=function(f){if(!this.layoutIndices){for(var d=0;d<this.data.l.comp.length;d++){var a;var b=this.getObjectArray(this.varIndices);var e=this.getObjectArray(this.smpIndices);if(this.data.l.vars&&this.data.l.smps){a=[];for(var c=0;c<this.data.l.comp[d][0].length;c++){if(b.hasOwnProperty(this.data.l.comp[d][0][c])){a.push(this.data.l.comp[d][0][c])}}this.layoutParams[d].varIndices=a;a=[];for(var c=0;c<this.data.l.comp[d][1].length;c++){if(e.hasOwnProperty(this.data.l.comp[d][1][c])){a.push(this.data.l.comp[d][1][c])}}this.layoutParams[d].smpIndices=a;this.setOriginalIndices(d,this.layoutParams[d].varIndices,this.layoutParams[d].smpIndices)}else{if(this.data.l.comp[d]){a=[];if(this.data.l.vars){for(var c=0;c<this.data.l.comp[d].length;c++){if(b.hasOwnProperty(this.data.l.comp[d][c])){a.push(this.data.l.comp[d][c])}}this.layoutParams[d].varIndices=a;this.layoutParams[d].smpIndices=this.smpIndices;this.setOriginalIndices(d,this.layoutParams[d].varIndices,this.smpIndices)}else{for(var c=0;c<this.data.l.comp[d].length;c++){if(e.hasOwnProperty(this.data.l.comp[d][c])){a.push(this.data.l.comp[d][c])}}this.layoutParams[d].varIndices=this.varIndices;this.layoutParams[d].smpIndices=a;this.setOriginalIndices(d,this.varIndices,this.layoutParams[d].smpIndices)}}else{if(this.data.l.vars){this.layoutParams[d].varIndices=[];this.layoutParams[d].smpIndices=this.smpIndices}else{this.layoutParams[d].varIndices=this.varIndices;this.layoutParams[d].smpIndices=[]}}}this.layoutParams[d].varIndicesStart=-1;this.layoutParams[d].smpIndicesStart=-1}for(var d=0;d<this.data.l.type.length;d++){for(var c=0;c<f.length;c++){if(!this.layoutParams[d].hasOwnProperty(f[c])){this.layoutParams[d][f[c]]=this[f[c]]}}}this.layoutIndices=true}};this.resetLayout=function(){delete (this.data.l);delete (this.layoutParams);this.offsetX=0;this.offsetY=0;this.layoutValidN=false;this.layoutValidR=false;this.layoutValidC=false;this.layoutCurrent=false;this.layoutComb=false;this.layoutIndices=false;this.layoutRestore=false;this.layout="1X1"};this.setDOE=function(){this.oneDPlot(true);this.Scatter2D(true);this.Scatter3D(true);this.Pie(true)};this.resetLayoutRestore=function(){this.layoutRestore=false};this.setLayoutRestore=function(){if(!this.layoutRestore){this.layoutRestore={};var c=["title","subtitle","varIndices","smpIndices","grpIndices","varIndicesStart","smpIndicesStart","smpTitle","showVariableNames","showSampleNames","showOverlays","showLegend","legendInside","showDecorationsLegend","xAxisShow","xAxis2Show","xAxisS2Show","yAxisShow","yAxisS2Show","xAxisTitle","xAxis2Title","yAxisTitle","legendLayout"];c.push("legendDecorationWidth");c.push("legendDecorationHeight");var a=["Color","Shape","Size","Pattern","Variable","Sample"];for(var b=0;b<a.length;b++){c.push("legend"+a[b]+"s");c.push("legend"+a[b]+"sMax");c.push("legend"+a[b]+"sN");c.push("legend"+a[b]+"sS");c.push("legend"+a[b]+"Width");c.push("legend"+a[b]+"Height")}for(var b=0;b<c.length;b++){this.layoutRestore[c[b]]=this[c[b]]}if(this.isGroupedData&&this.data.w){this.layoutRestore.isGroupedData=this.isGroupedData}}};this.setLayoutParams=function(){if(!this.layoutParams&&this.data.l.comp){this.layoutParams=[];for(var a=0;a<this.data.l.type.length;a++){this.layoutParams[a]={}}}};this.removeEmptyCompartments=function(){if(this.layoutRemoveEmpty&&this.layoutParams&&!this.isDOE){var f={};var d=[];var g=["comp","desc","name","type","vars","smps","weight"];var h=0;for(var c=0;c<g.length;c++){if(this.data.l[g[c]]){f[g[c]]=[]}}for(var c=0;c<this.data.l.weight.length;c++){var b=this.layoutParams[c].varIndices.length;var e=this.layoutParams[c].smpIndices.length;if(b&&e){d.push(this.layoutParams[c]);for(var a=0;a<g.length;a++){if(this.data.l[g[a]]){f[g[a]].push(this.data.l[g[a]][c])}}if(this.data.l.group){f.group=this.data.l.group}h++}}if(h!=this.data.l.weight.length){this.stndByLayoutData={};this.stndByLayoutData.data=this.cloneObject(this.data.l);this.stndByLayoutData.pars=this.cloneObject(this.layoutParams);this.stndByLayoutData.layoutRows=this.layoutRows;this.stndByLayoutData.layoutCols=this.layoutCols;this.stndByLayoutData.layout=this.layout;this.data.l=f;this.layoutParams=d;this.layoutRows=Math.ceil(Math.sqrt(h));this.layoutCols=this.layoutRows*(this.layoutRows-1)>=h?this.layoutRows-1:this.layoutRows;this.layout=this.layoutRows+"X"+this.layoutCols;for(var c=0;c<this.data.l.weight.length;c++){this.data.l.weight[c]=[1/this.layoutCols,1/this.layoutRows]}}}};this.restoreEmptyCompartments=function(){if(this.stndByLayoutData){this.data.l=this.stndByLayoutData.data;this.layoutParams=this.stndByLayoutData.pars;this.layoutRows=this.stndByLayoutData.layoutRows;this.layoutCols=this.stndByLayoutData.layoutCols;this.layout=this.stndByLayoutData.layout;delete (this.stndByLayoutData)}};this.getLayoutAxisSamples=function(c){if(this.data.l.smps){var e={};var b=c=="x"?0:1;for(var d=0;d<this.data.l.smps.length;d++){if(this.data.l.smps[d]&&(this.data.l.smps[d][b]||this.data.l.smps[d][b]==0)){e[this.data.l.smps[d][b]]=true}else{if(this.data.l.smps[d][c+"Axis"]){e[this.data.l.smps[d][c+"Axis"]]=true}}}return this.getKeys(e)}else{if(this[c+"Axis"].length>0){return this[c+"Axis"]}else{return this.data.y.smps}}};this.drawLayoutCompartments=function(g){this.functionCaller="drawLayoutCompartments";var m=["left","right","top","bottom","x","y","offsetX","offsetY","graphType","summaryType","transformType","smpInfo","varInfo","minData","maxData","xAxisMin","xAxisMax","xAxisRange","xAxis2Min","xAxis2Max","xAxis2Range","yAxisMin","yAxisMax","yAxisRange","zAxisMin","zAxisMax","zAxisRange","xAxisAbsMin","xAxisAbsMax","xAxis2AbsMin","xAxis2AbsMax","yAxisAbsMin","yAxisAbsMax","zAxisAbsMin","zAxisAbsMax","xAxisUnit","xAxis2Unit","yAxisUnit","zAxisUnit"];var e=["weight","graphType","varIndices","smpIndices","grpIndices","varIndicesStart","smpIndicesStart","setMin","setMax","setMin2","setMax2","setMinX","setMaxX","setMinY","setMaxY","setMinZ","setMaxZ"];if(this.layoutComb){if(this.isDOE){m.push("data");this.setDOE()}this.removeEmptyCompartments();if(this.graphType.match(/Scatter/)){this.xAxisTmp=this.cloneObject(this.xAxis);this.yAxisTmp=this.cloneObject(this.yAxis);this.xAxis=this.getLayoutAxisSamples("x");this.yAxis=this.getLayoutAxisSamples("y");this.initAxes();this.xAxis=this.xAxisTmp;this.yAxis=this.yAxisTmp;this.xAxisIndices=this.getSampleIndices(this.xAxis);this.yAxisIndices=this.getSampleIndices(this.yAxis)}else{if(this.data.l&&this.data.l.group){this.groupSamples(this.data.l.group,false,false,true,true);this.meta.data.g=this.data.w;this.initAxes()}else{this.initAxes(true)}}this.setLayoutDimensions();var s=this.marginLeft+this.layoutLeft+this.layoutRight+this.marginRight;var p=this.marginTop+this.layoutTop+this.layoutBottom+this.marginBottom;this.setLayoutRestore();this.setLayoutParams();this.title="";this.subtitle="";this.offsetX=this.layoutLeft;this.offsetY=this.graphType=="Pie"?0:this.layoutTop;this.setLayoutWeights();this.setLongestLayoutLabel();this.setLayoutGraphTypes();this.setLayoutIndices(e);var q=0;for(var o=0;o<this.layoutRows;o++){for(var n=0;n<this.layoutCols;n++){this.layoutCurrent=q;if(this.isDOE){if(this.dataStndBy.l.smps.length<=q){break}}else{if(this.graphType=="Pie"){if(this.data.l.smps.length<=q){break}}else{if(this.layoutParams.length<=q){break}}}if(this.layoutParams[q]){for(var l=0;l<e.length;l++){this[e[l]]=this.layoutParams[q].hasOwnProperty(e[l])?this.layoutParams[q][e[l]]:this[e[l]]}}this.setLayoutGraphDimensions(s,p,q);if(this.isDOE){this.drawLayoutCompartmentsDOE(s,p,q)}else{if(this.graphType.match(/Scatter/)){this.drawLayoutCompartmentsScatter(s,p,o,n,q)}else{if(this.graphType=="Pie"){this.drawLayoutCompartmentsPie(s,p,q)}else{this.drawLayoutCompartmentsOneD(s,p,q)}}}if(!this.isDOE&&this.varIndices.length>0&&this.smpIndices.length>0){g.call(this)}for(var l=0;l<m.length;l++){this.layoutParams[q][m[l]]=this.cloneObject(this[m[l]])}if(this.data.w){this.layoutParams[q].w=this.cloneObject(this.data.w)}if(this.layoutCanvasCompartments){this.drawLayoutCanvasCompartments()}if(this.isDOE||this.graphType=="Pie"){}else{if(this.graphType.match(/Scatter/)){if(this.scatterPlotMatrix){this.functionCaller="drawLayoutCompartmentsBox";var f,d;if(o==n&&this.scatterPlotMatrixType.match(/complete/)){f=this.scaleTextToFont(this.meta.data.y.maxSmpStr,this.maxTextSize,(this.width-s)*0.7/this.layoutCols,this.y);this.addToRender(["drawShape","rectangle",this.marginLeft+this.offsetX+this.left+(this.x/2),this.marginTop+this.offsetY+this.top+(this.y/2),this.x,this.y,false,this.foreground,"open"]);this.addToRender(["drawText",this.data.y.smps[o],this.marginLeft+this.offsetX+this.left+(this.x/2),this.marginTop+this.offsetY+this.top+(this.y/2),f,this.foreground,"center","middle"])}else{if(!this.scatterPlotMatrixType.match(/complete/)&&this.data.y.smps[q+1]){d=this.axisTitleFontSize+this.margin+this.margin;f=this.scaleTextToFont(this.meta.data.y.maxSmpStr+" & "+this.meta.data.y.maxSmpStr,this.maxTextSize,(this.width-s)*0.8/this.layoutCols,d);if(this.layoutBoxLabelColors[0]){this.addToRender(["drawShape","rectangle",this.marginLeft+this.offsetX+this.left+(this.x/2),this.marginTop+this.offsetY+this.top-(d/2),this.x,d,this.layoutBoxLabelColors[0],this.foreground])}else{this.addToRender(["drawShape","rectangle",this.marginLeft+this.offsetX+this.left+(this.x/2),this.marginTop+this.offsetY+this.top-(d/2),this.x,d,false,this.foreground,"open"])}this.addToRender(["drawText",this.data.y.smps[0]+" & "+this.data.y.smps[q+1],this.marginLeft+this.offsetX+this.left+(this.x/2),this.marginTop+this.offsetY+this.top-(d/2),f,this.foreground,"center","middle"])}}this.functionCaller="drawLayoutCompartments"}else{if(this.segregateVariablesBy.length||this.segregateSamplesBy.length){this.drawTrellisLabels(q)}}}else{if(!this.layoutAdjust){var r=this.graphOrientation=="vertical"?n:o;var b=this.graphOrientation=="vertical"?this.layoutCols-1:this.layoutRows-1;if(r==0&&this.layoutRestore.xAxisShow&&this.graphType!="Heatmap"){this.layoutAxis=1;this.xAxisShow=true;this.draw1DXLayout()}if(r==b&&this.layoutRestore.xAxis2Show&&this.graphType!="Heatmap"){this.layoutAxis=2;this.xAxis2Show=true;this.draw1DXLayout()}}if(this.segregateVariablesBy.length){var a=false;if(this.graphOrientation=="vertical"){if(o==this.layoutRows-1){a=true}else{if(o==this.layoutRows-2&&(q+1+parseInt(this.layoutCols))>this.data.l.weight.length){a=true}}}else{if(n==0){a=true}}if(a){this.showSampleNames=this.layoutRestore.showSampleNames;this.draw1DYLayout()}}if(this.graphType!="Candlestick"){this.drawTrellisLabels(q)}}}this.offsetX+=this.layoutWidth;q++}this.offsetX=this.layoutLeft;this.offsetY+=this.layoutHeight}this.layoutCurrent=false;this.restoreLayoutParameters();if(this.isDOE){this.data=this.dataStndBy;this.graphType=this.data.l.type[0]}else{this.drawTitle();this.drawLabelsTitlesLayout();if(this.showLegend){if(this.isDOE||this.graphType!="Pie"){this.drawLegend(true)}}}if(this.meta.data.g){this.data.w=this.meta.data.g;delete (this.meta.data.g)}else{this.isGroupedData=false}}};this.restoreLayoutParameters=function(){for(var a in this.layoutRestore){this[a]=this.layoutRestore[a]}};this.setLayoutGraphDimensions=function(a,b,d){this.layoutWidth=(this.width-a)*this.layoutParams[d].weight[0];this.layoutHeight=(this.height-b)*this.layoutParams[d].weight[1];this.layoutParams[d].width=this.layoutWidth;this.layoutParams[d].height=this.layoutHeight};this.setLongestLayoutLabel=function(){var a=[];if(this.scatterPlotMatrix){}else{if((this.segregateSamplesBy.length>0&&this.segregateVariablesBy.length>0)||(this.segregateSamplesBy.length>1||this.segregateVariablesBy.length>1)){for(var b=0;b<this.data.l.name.length;b++){a.push(this.data.l.name[b][0]);a.push(this.data.l.name[b][1])}}else{if(this.data.l.name){for(var b=0;b<this.data.l.name.length;b++){a.push(this.data.l.name[b])}}}this.longestLayoutLabel=this.getMaxText(a)}};this.setLayoutLabels=function(a){this.layoutLabels=[];if(this.segregateSamplesBy.length>0&&this.segregateVariablesBy.length>0){this.layoutLabels.push(this.data.l.name[a][0]);this.layoutLabels.push(this.data.l.name[a][1])}else{if(this.segregateSamplesBy.length>1||this.segregateVariablesBy.length>1){this.layoutLabels.push(this.data.l.name[a][1]);this.layoutLabels.push(this.data.l.name[a][0])}else{if(this.scatterPlotMatrix){}else{this.layoutLabels.push(this.data.l.name[a])}}}};this.drawLayoutCompartmentsDOE=function(a,b,d){this.legendPosition="right";this.graphOrientation="vertical";if(d==0&&this.showDOEData){this.isShowDOEData=true;this.showLegend=this.layoutRestore.showLegend;if(this.graphType.match(/Scatter/i)){this.isHistogram=false;this.xAxis=this.configStndBy.xAxis;this.yAxis=this.configStndBy.yAxis;this.xAxisTitle=this.configStndBy.xAxisTitle;this.yAxisTitle=this.configStndBy.yAxisTitle;this.initAxes();this.initializeData(this.dataStndBy);this.varIndices=this.dataStndBy.l.doe}else{this.initializeData(this.dataStndBy);this.smpIndices=this.dataStndBy.l.doe}this.showLegend=false;if(this.graphType=="Scatter3D"){this.draw3DPlot()}else{if(this.graphType.match(/Scatter/i)){this.draw2DPlot()}else{this.plotByVariable=this.configStndBy.plotByVariable;if(this.configStndBy.groupingFactors.length>0){this.isGroupedData=true;if(this.dataStndBy.y.smps.length!=this.smpIndices.length){this.layoutComb=false;this.groupSamples(this.configStndBy.groupingFactors,false,false,true,true);this.layoutComb=true}this.draw1DPlot();this.isGroupedData=false;this.groupingFactors=[]}else{this.draw1DPlot()}this.plotByVariable=false}}this.showLegend=true;this.isShowDOEData=false}else{this.drawDOELabelsLayout(this.dataStndBy.l.smps[d][0]);this.top=5;this.bottom=5;this.right=5;this.left=5;if(this.dataStndBy.l.type[d]=="Pie"){this.showLegend=true;this.createPie(this.dataStndBy.l.smps[d][0]);this.graphType="Pie";this.layoutCurrentDOE=this.dataStndBy.l.smps[d][0];this.legendBox=false;this.drawPiePlot()}else{if(this.dataStndBy.l.type[d]=="Treemap"){this.createTreemap(this.dataStndBy.l.smps[d][0]);this.graphType="Treemap";this.draw1DPlot()}else{if(this.dataStndBy.l.type[d]=="Scatter2D"){this.createHistogram(this.dataStndBy.l.smps[d][0]);this.graphType="Scatter2D";this.initAxes();this.showLegend=false;this.xAxisTitle="";this.yAxisTitle="";this.draw2DPlot()}}}}};this.drawLayoutCompartmentsScatter=function(a,e,d,b,f){if(this.segregateVariablesBy.length&&this.segregateSamplesBy.length){this.xAxis=[this.data.l.smps[Math.floor(f/this.data.l.smps.length)][0]];this.yAxis=[this.data.l.smps[Math.floor(f/this.data.l.smps.length)][1]];this.xAxisIndices=this.getSampleIndices(this.xAxis);this.yAxisIndices=this.getSampleIndices(this.yAxis);this.setLayoutLabels(f)}else{if(this.data.l.smps&&this.data.l.smps[f].xAxis&&this.data.l.smps[f].yAxis){this.xAxis=this.data.l.smps[f].xAxis;this.yAxis=this.data.l.smps[f].yAxis;this.xAxisIndices=this.getSampleIndices(this.xAxis);this.yAxisIndices=this.getSampleIndices(this.yAxis)}else{if(!this.scatterPlotMatrix&&this.data.l.smps&&this.data.l.smps[f]){this.xAxis=[this.data.l.smps[f][0]];this.yAxis=[this.data.l.smps[f][1]];this.xAxisIndices=this.getSampleIndices(this.xAxis);this.yAxisIndices=this.getSampleIndices(this.yAxis);this.setLayoutLabels(f)}else{if(this.data.l.vars&&this.data.l.vars[f]){this.setLayoutLabels(f)}else{this.xAxis=false;this.yAxis=false;this.xAxisIndices=false;this.yAxisIndices=false}}}}if(this.layoutAdjust&&this.xAxis&&this.yAxis){this.initAxes();this.layoutAxis=3}else{this.layoutAxis=b==0?2:0;this.layoutAxis=d==this.layoutRows&&this.layoutAxis?3:d==this.layoutRows?1:0}if(this.data.l.reg){if(this.data.l.reg[f]){if(this.decorations){delete (this.decorations)}for(var d=0;d<this.data.l.reg[f].length;d++){this.addRegressionDecoration(this.data.l.reg[f][d].reg,this.data.l.reg[f][d].lab,this.data.l.reg[f][d].col,this.data.l.reg[f][d].fit,this.data.l.reg[f][d].id)}}}this.showLegend=false;this.legendInside=true;this.showDecorationsLegend=true;this.xAxisTitle="";this.yAxisTitle="";if(!this.layoutAdjust){this.xAxisShow=false;this.yAxisShow=false;this.xAxisS2Show=false;this.yAxisS2Show=false;if(d==0&&b%2>0){this.xAxisS2Show=true}if(d==this.layoutRows-1&&b%2==0){this.xAxisShow=true}if(b==0&&d%2>0){this.yAxisShow=true}if(b==this.layoutCols-1&&d%2==0){this.yAxisS2Show=true}}};this.drawLayoutCompartmentsPie=function(a,b,d){this.smpIndices=[this.getSampleIndices(this.data.l.smps[d])];this.showLegend=true};this.drawLayoutCompartmentsOneD=function(b,d,e){if(this.graphType=="Candlestick"){this.xAxisShow=true;this.xAxis2Show=true;this.xAxisTitle=true;this.xAxis2Title=true;if(e==1){this.summaryType="volume";if(this.showVolume){this.showSampleNames=true}}else{this.summaryType="candle";this.showSampleNames=false}}else{this.showLegend=false;this.showOverlays=true;this.isGroupedData=false;this.xAxisTitle=false;this.xAxis2Title=false;this.smpTitle=false;this.adjustAspectRatioXTries=0;this.adjustAspectRatioYTries=0;this.setLayoutLabels(e);if(this.varIndices.length>0&&this.smpIndices.length>0){if(this.data.l.group){var a=this.layoutParams[e].dragged?this.layoutParams[e].grpIndices:false;this.groupSamples(this.data.l.group,false,a,true,true,true);this.layoutParams[e].grpIndices=this.grpIndices;if(this.colorBy&&this.isInArray(this.colorBy,this.groupingFactors)&&this.layoutRestore.showLegend){}if(this.data.w.smps.length==1&&this.graphType!="Heatmap"&&this.isInArray(this.data.l.group,this.segregateSamplesBy)){this.showSampleNames=false}}else{if(this.smpIndices.length==1&&this.graphType!="Heatmap"){}}if(this.segregateVariablesBy.length>0&&this.graphType!="Heatmap"){this.showSampleNames=false}if(this.layoutAdjust){this.layoutAxis=3;if(this.varIndices.length>0&&this.smpIndices.length>0){this.initAxes()}}else{if(this.graphOrientation=="vertical"){this.xAxisShowLayout=!(e%this.layoutCols)?true:false}else{this.xAxisShowLayout=e<this.layoutCols?true:false;this.xAxis2ShowLayout=e>=this.layoutCols*(this.layoutRows-1)?true:false}this.xAxisShow=false;this.xAxis2Show=false}}}};this.drawTrellisLabels=function(o){this.functionCaller="drawTrellisLabels";if(this.layoutValid){var e=this.layoutCollapse?this.marginLeft+this.offsetX:this.marginLeft+this.offsetX+this.margin;var q=this.marginTop+this.offsetY;var p=this.layoutWidth;var d=p/2;var j=this.getFontHeight()+(this.margin*2);var b=j/2;var a=this.layoutHeight-((this.layoutLabels.length*j)+(this.margin*(this.layoutCollapse?0:1)));var k=this.layoutLabels.length?this.scaleTextToFont(this.longestLayoutLabel,this.fontSize,p):this.font;if(o>=this.layoutCols){if(this.graphOrientation!="vertical"&&this.graphType!="Heatmap"&&!this.layoutAdjust&&!this.graphType.match(/Scatter/)){a-=this.getAxisTitleTickLength()}else{if(this.graphType.match(/Scatter/)&&(this.segregateVariablesBy.length||this.segregateSamplesBy.length)){}}}if(!this.layoutCollapse){if(this.layoutAdjust){p=this.x;e+=this.left-this.margin;d=p/2;a=this.y}else{p-=(this.graphType.match(/Scatter/)&&(this.segregateVariablesBy.length||this.segregateSamplesBy.length)?this.margin:this.margin*2)}}for(var g=0;g<this.layoutLabels.length;g++){if(this.layoutBoxLabelColors[g]){this.addToRender(["drawShape","box",e+(p/2),q+(j/2),p,j,this.layoutBoxLabelColors[g],this.layoutBoxShow?this.foreground:this.layoutBoxLabelColors[g]],false,false,null,true)}else{if(this.layoutBoxShow){this.addToRender(["drawShape","box",e+(p/2),q+(j/2),p,j,false,this.foreground,"open"],false,false,null,true)}}this.addToRender(["drawText",this.layoutLabels[g],e+d-this.margin,q+b,k,this.foreground,"center","middle"]);q+=j}if(this.graphOrientation!="vertical"&&this.xAxisShow){q=this.marginTop+this.offsetY+this.top}if(this.layoutBoxShow){this.addToRender(["drawShape","box",e+(p/2),q+(a/2),p,a,false,this.foreground,"open"],false,false,null,true)}}};this.initializeLayout=function(){this.isValidLayout()};this.setFunctionNames("initLayout");this.initializeLayout()};CanvasXpress.prototype.initViewport=function(a){this.setViewport=function(){var d=this.$("container-"+this.target);if(!d){var H=this.$(this.target);var B=H.parentNode;H.className="CanvasXpress";H.style.visibility=this.debug?"visible":"hidden";if(!H.hasAttribute("data-maxWidth")){H.setAttribute("data-maxWidth",H.hasAttribute("width")?Number(H.getAttribute("width")):B.clientWidth)}if(!H.hasAttribute("data-maxHeight")){H.setAttribute("data-maxHeight",H.hasAttribute("height")?Number(H.getAttribute("height")):B.clientHeight)}if(!B.id){B.id="CanvasXpress-ParentNode-"+this.target}this.targetParentNode=B.id;this.targetParentNodeResponsive=false;this.targetParentNodeAspectRatio=[];var E=H.hasAttribute("data-responsive")?JSON.parse(H.getAttribute("data-responsive")):false;var z=H.hasAttribute("data-aspectRatio")?H.getAttribute("data-aspectRatio"):false;var f=H.hasAttribute("data-resizable")?H.getAttribute("data-resizable"):false;if(f){if(f=="both"){this.resizable=true;this.resizableX=true;this.resizableY=true}else{if(f=="x"||f=="X"){this.resizable=true;this.resizableX=true;this.resizableY=false}else{if(f=="y"||f=="Y"){this.resizable=true;this.resizableX=false;this.resizableY=true}else{if(f=="none"){this.resizable=false;this.resizableX=false;this.resizableY=false}}}}}if(E){this.targetParentNodeResponsive=true;var n=z?z.split(/:/):[];var k=this.getMaxCanvasWidthHeight(H,n);H.width=k[0];H.height=k[1];this.targetParentNodeAspectRatio=[H.width,H.height]}H.width=H.originalWidth=parseInt(H.width);H.height=H.originalHeight=parseInt(H.height);H.style.width=H.width+"px";H.style.height=H.height+"px";var y=this.$cX("canvas",{id:this.target+"-events",className:"CanvasXpress",width:H.width,height:H.height},{position:"absolute",left:0,top:0,visibility:this.debug?"visible":"hidden"});this.target2=this.target+"-events";var h=this.$cX("canvas",{id:this.target+"-transitions0",className:"CanvasXpress",width:H.width,height:H.height},{position:"absolute",left:0,top:0,visibility:"hidden"});this.target3=this.target+"-transitions0";var g=this.$cX("canvas",{id:this.target+"-transitions1",className:"CanvasXpress",width:H.width,height:H.height},{position:"absolute",left:0,top:0,visibility:"hidden"});this.target4=this.target+"-transitions1";var d=this.$cX("div",{id:"container-"+this.target,className:"CanvasXpressContainer"});var D=this.$cX("div",{id:this.leafletId||this.target+"-leafletId",className:"CanvasXpressMap"},{width:H.width+"px",height:H.height+"px"});if(this.isMap){H.style.position="absolute";H.style.left="0px";H.style.top="0px"}if(a){d.style.display="none"}var J=this.$cX("div",{id:"northest-container-"+this.target,className:"CanvasXpressContainer"},{width:H.width+"px",clear:"left"});var w=this.$cX("div",{id:"northest-wrapper-"+this.target,className:"CanvasXpressWrapper"},{width:H.width+"px"});var m=this.$cX("div",{id:"north-container-"+this.target,className:"CanvasXpressContainer"},{width:H.width+"px",height:"0px",clear:"left"});var I=this.$cX("div",{id:"north-wrapper-"+this.target,className:"CanvasXpressWrapper"},{width:H.width+"px",height:"0px"});var L=this.$cX("div",{id:"middle-container-"+this.target,className:"CanvasXpressContainer"},{width:H.width+"px",height:H.height+"px",clear:"left"});var q=this.$cX("div",{id:"west-container-"+this.target,className:"CanvasXpressContainer"},{width:"0px",height:H.height+"px",cssFloat:"left"});var K=this.$cX("div",{id:"west-wrapper-"+this.target,className:"CanvasXpressWrapper"},{width:"0px",height:H.height+"px"});var e=this.$cX("div",{id:"center-wrapper-"+this.target,className:"CanvasXpressWrapper"});var j=this.$cX("div",{id:"east-container-"+this.target,className:"CanvasXpressContainer"},{width:"0px",height:H.height+"px"});var G=this.$cX("div",{id:"east-wrapper-"+this.target,className:"CanvasXpressWrapper"},{width:"0px",height:H.height+"px"});var b=this.$cX("div",{id:"south-container-"+this.target,className:"CanvasXpressContainer"},{width:H.width+"px",height:"0px",clear:"left"});var A=this.$cX("div",{id:"south-wrapper-"+this.target,className:"CanvasXpressWrapper",state:"open"},{width:H.width+"px",height:"0px"});J.appendChild(w);m.appendChild(I);q.appendChild(K);j.appendChild(G);b.appendChild(A);L.appendChild(q);L.appendChild(e);L.appendChild(j);d.appendChild(J);d.appendChild(m);d.appendChild(L);d.appendChild(b);d.appendChild(this.createLoadingTimer());if(this.isVideo){var r=this.$(this.target+"-cX-Video");if(!r){r=this.$cX("video",{id:this.target+"-cX-Video",autoplay:false,controls:this.videoControls,loop:this.videoLoop,preload:this.videoPreload,poster:this.videoPoster,dataSet:this.videoData,width:this.meta.canvas.ctx.canvas.width,height:this.meta.canvas.ctx.canvas.height,className:this.videoClassName});var u=[];var C=this.backgroundVideo;if(C&&!(C.propertyIsEnumerable("length"))&&typeof C==="object"&&typeof C.length==="number"){u=C}else{u.push(this.backgroundVideo)}for(var F=0;F<u.length;F++){var x=this.$cX("source",{src:u[F],type:u[F].match(/mp4$/)?"video/mp4":u[F].match(/webm$/)?"video/webm":"video/ogv"});r.appendChild(x)}}H.parentNode.insertBefore(d,H);e.appendChild(H.parentNode.appendChild(H));H.parentNode.insertBefore(r,H);H.parentNode.appendChild(y)}else{H.parentNode.insertBefore(d,H);e.appendChild(H.parentNode.appendChild(H));if(this.isMap){H.parentNode.appendChild(D)}H.parentNode.appendChild(y);H.parentNode.appendChild(h);H.parentNode.appendChild(g)}this.meta.canvas.ctx2=y.getContext("2d");this.meta.canvas.ctx2.setTransform(this.meta.canvas.canvasPixelRatio,0,0,this.meta.canvas.canvasPixelRatio,0,0);this.meta.canvas.ctx3=h.getContext("2d");this.meta.canvas.ctx3.setTransform(this.meta.canvas.canvasPixelRatio,0,0,this.meta.canvas.canvasPixelRatio,0,0);this.meta.canvas.ctx4=g.getContext("2d");this.meta.canvas.ctx4.setTransform(this.meta.canvas.canvasPixelRatio,0,0,this.meta.canvas.canvasPixelRatio,0,0)}};this.getMaxCanvasWidthHeight=function(k,f){var l,i;var e=this.targetParentNode.match(/canvasXpressRemoteWindow/)?this.$(this.targetParentNode).parentNode.parentNode:this.$(this.targetParentNode);var b=e.getClientRects();var g=b[0].width;var d=b[0].height-41;var m=k.getAttribute("data-maxWidth");var j=k.getAttribute("data-maxHeight");g=g>m?m:g;d=d>j?j:d;if(f.length==2){f[0]=Number(f[0]);f[1]=Number(f[1]);if(f[0]==f[1]){l=g;i=l}else{if(f[0]>f[1]){i=d;l=parseInt(i*f[0]/f[1])}else{l=g;i=parseInt(l*f[1]/f[0])}}}else{l=g;i=d}return[l,i]};this.createLoadingTimer=function(){var k=this.target+"canvasXpressLoadingTimer";if(this.$(k)){return}var j=this.$(this.target);var h=this.$cX("div",{id:k},{display:"none",position:"absolute",width:"100%",top:parseInt((j.height/2)-100.5)+"px"});var f=this.$cX("div",{className:"counter"});var d=this.$cX("div",{className:"timer"});var b=this.$cX("div",{className:"imer-val-container seconds-single"});for(var e=0;e<10;e++){b.appendChild(this.$cX("div",{className:"timer-val",innerHTML:e}))}d.appendChild(b);f.appendChild(d);h.appendChild(f);var g=this.$cX("div",{className:"sk-fading-circle"});for(var e=1;e<13;e++){g.appendChild(this.$cX("div",{className:"sk-circle"+e+" sk-circle"}))}h.appendChild(g);return h};this.resizeViewportNorth=function(){var f=this.$("west-container-"+this.target);var e=this.$("east-container-"+this.target);var c=this.$("northest-container-"+this.target);var d=this.$("northest-wrapper-"+this.target);var g=this.$("north-container-"+this.target);var b=this.$("north-wrapper-"+this.target);if(f&&e&&c&&d&&g&&b){c.style.width=(parseInt(f.style.width)+this.meta.canvas.ctx.canvas.width+parseInt(e.style.width))+"px";d.style.width=(parseInt(f.style.width)+this.meta.canvas.ctx.canvas.width+parseInt(e.style.width))+"px";g.style.width=(parseInt(f.style.width)+this.meta.canvas.ctx.canvas.width+parseInt(e.style.width))+"px";b.style.width=(parseInt(f.style.width)+this.meta.canvas.ctx.canvas.width+parseInt(e.style.width))+"px";g.style.height="0px";b.style.height="0px"}};this.resizeViewportWest=function(){var e=this.$(this.target+"-cX-Configurator");var b=this.$("west-container-"+this.target);var d=this.$("west-wrapper-"+this.target);if(b&&d){b.style.width="0px";d.style.width="0px";b.style.height=this.meta.canvas.ctx.canvas.height+"px";d.style.height=this.meta.canvas.ctx.canvas.height+"px"}};this.resizeViewportEast=function(){var d=this.$(this.target+"-cX-DataFilter");var b=this.$("east-container-"+this.target);var c=this.$("east-wrapper-"+this.target);if(b&&c){b.style.width="0px";c.style.width="0px";b.style.height=this.meta.canvas.ctx.canvas.height+"px";c.style.height=this.meta.canvas.ctx.canvas.height+"px"}};this.resizeViewportSouth=function(c){var h=this.$(this.target+"-cX-DataTable");var f=this.$("west-container-"+this.target);var e=this.$("east-container-"+this.target);var g=this.$("south-container-"+this.target);var b=this.$("south-wrapper-"+this.target);if(h&&f&&e&&g&&b){if(c){g.style.height=parseInt(h.style.height)+"px";b.style.height=parseInt(h.style.height)+"px";g.style.width=parseInt(h.style.width)+"px";b.style.width=parseInt(h.style.width)+"px"}else{g.style.width=(parseInt(f.style.width)+this.meta.canvas.ctx.canvas.width+parseInt(e.style.width))+"px";b.style.width=(parseInt(f.style.width)+this.meta.canvas.ctx.canvas.width+parseInt(e.style.width))+"px";g.style.height="0px";b.style.height="0px"}}};this.resizeViewport=function(){var d=this.$("middle-container-"+this.target);var b=this.$("east-container-"+this.target);var c=this.$("west-container-"+this.target);if(d&&b&&c){this.resizeViewportWest();this.resizeViewportEast();this.resizeViewportNorth();this.resizeViewportSouth();d.style.width=(parseInt(c.style.width)+this.meta.canvas.ctx.canvas.width+parseInt(b.style.width)+0)+"px";d.style.height=(this.meta.canvas.ctx.canvas.height+0)+"px"}};this.resizeViewportMiddle=function(b,d){var f=this.$("middle-container-"+this.target);var c=this.$("east-container-"+this.target);var e=this.$("west-container-"+this.target);if(f&&c&&e){this.resizeViewportWest();this.resizeViewportEast();this.resizeViewportNorth();this.resizeViewportSouth();f.style.width=(parseInt(e.style.width)+b+parseInt(c.style.width)+0)+"px";f.style.height=(d+0)+"px"}};this.resetViewportOverflow=function(c){if(c){var b=this.$(c+"-wrapper-"+this.target);if(b){b.style.overflow="visible"}}};this.initializeViewport=function(){this.setViewport()};this.setFunctionNames("initViewport");this.initializeViewport()};CanvasXpress.prototype.initMenus=function(){this.addMenu=function(A,a,n,b,g,d,t,z){if(this.disableMenu){return}var p;var o;var j=this.$("north-wrapper-"+this.target);var c=this.$("west-container-"+this.target);this.resetLinkDiv();if(j&&c){if(a){o=this.newId("-cX-Menu-");p=this.$cX("div",{id:o,className:"CanvasXpressMenu draggable",par:n},{left:"0px",top:"0px",zIndex:this.menuIndex++,display:"none"})}else{this.removeMenus();if(b){a=b;g+=c.offsetWidth}else{a=this.setMenu();var v=this.getTargetEvent(A);var B=this.adjustedCoordinates(A,this.isMap?false:v);if(z){g=8;d=8}else{g=B.x+c.offsetWidth;d=B.y}}o=this.newId("-cX-Menu-");p=this.$cX("div",{id:o,className:"CanvasXpressMenu draggable"},{left:g+"px",top:d+"px",zIndex:this.menuIndex++})}var k=this.$cX("ul",{id:this.newId("-cX-List-"),className:"CanvasXpressList",header:t});p.appendChild(k);j.appendChild(p);var s=this.maxSubMenus;var q=a.length>s?s:a.length;if(a.length>s){k.rawMenu=a;k.rawMenuIndex=0;this.addMenuItemScroller(k,"Top")}for(var r=0;r<q;r++){if(a[r][0]=="-"){this.addMenuItemSep(k)}else{if(a[r][0]=="-text-"){this.addMenuItemText(a[r],k)}else{if(a[r][0]=="-color-"){this.addMenuItemColor(a[r],k)}else{if(a[r][0]=="-slider-"){this.addMenuItemSlider(a[r],k)}else{if(a[r][0]=="-filter-"){this.addMenuItemFilter(a[r],k)}else{this.addMenuItem(a[r],k)}}}}}}if(a.length>s){this.addMenuItemScroller(k,"Bottom")}}return o};this.pageMenuItem=function(e,f){var g,j,a,i;var h=e.rawMenuMatch||e.rawMenu;if(h){var d=e.childNodes.length-2;if(f=="Top"&&e.rawMenuIndex>0){g=e.childNodes[e.childNodes.length-2];j=h[e.rawMenuIndex-1];a=e.childNodes[2];i=true;e.rawMenuIndex--}else{if(f=="Bottom"&&h.length>(e.rawMenuIndex+d)){g=e.childNodes[2];j=h[e.rawMenuIndex+d];a=e.childNodes[e.childNodes.length-1];i=true;e.rawMenuIndex++}}if(i){this.addRemoveItemListeners("removeEvtListener",g);g.parentNode.removeChild(g);if(j[0]=="-"){this.addMenuItemSep(e,a)}else{if(j[0]=="-text-"){this.addMenuItemText(j,e,a)}else{if(j[0]=="-color-"){this.addMenuItemColor(j,e,a)}else{if(j[0]=="-slider-"){this.addMenuItemSlider(j,e,a)}else{if(j[0]=="-filter-"){this.addMenuItemFilter(j,e,a)}else{this.addMenuItem(j,e,a)}}}}}}}};this.filterScrollSearch=function(b){var k=this.$(b);if(k){var c=k.value;var n=new RegExp(k.value,"i");var h=k.parentNode.parentNode;var j=h.rawMenu;var f=[];for(var e=0;e<j.length;e++){if(j[e][0].match(n)){f.push(j[e])}}if(f.length!=j.length){h.rawMenuMatch=f}else{delete (h.rawMenuMatch)}while(h.childNodes.length>0){var d=h.childNodes[0];this.addRemoveItemListeners("removeEvtListener",d);h.removeChild(d)}var m=this.maxSubMenus;var g=f.length>m?m:f.length;h.rawMenuIndex=0;var a=this.addMenuItemScroller(h,"Top",c);for(var e=0;e<g;e++){this.addMenuItem(f[e],h)}this.addMenuItemScroller(h,"Bottom");a.focus();a.value=c}};this.addMenuItemSep=function(d,a){var c=this.$cX("li",{id:this.newId("-cX-List-Item-Sep-"),className:"CanvasXpressListItemSep"});var e=this.$cX("span",{id:this.newId("-cX-List-Item-Text-Sep-"),className:"CanvasXpressListItemTextSep",innerHTML:"&nbsp;"});c.appendChild(e);if(a){a.parentNode.insertBefore(c,a)}else{d.appendChild(c)}};this.addMenuItemScroller=function(c,d){var b=this.$cX("li",{id:this.newId("-cX-List-Item-Scroll-"+d),className:"CanvasXpressListItemScroll"+d});var f=this.$cX("span",{id:this.newId("-cX-List-Item-Text-Scroll-"+d),className:"CanvasXpressListItemTextScroll"+d,innerHTML:"&nbsp;"});b.appendChild(f);c.appendChild(b);this.addRemoveItemListeners("addEvtListener",b);if(d=="Top"){var a=this.$cX("li",{id:this.newId("-cX-List-Item-Scroll-Search"),className:"CanvasXpressListItemScrollSearch"+d});var e=this.$cX("input",{id:this.newId("-cX-List-Item-Scroll-Search-Input"),className:"CanvasXpressListItemScrollSearch",type:"text",placeholder:" Search menu"});a.appendChild(e);c.appendChild(a);return e}};this.getMenuItemValue=function(d){if(d[2][2]){var c=this.cloneObject(d[2][2]);var b=this;while(c.length>0){var a=c.shift();if(b[a]){b=b[a]}else{return""}}return b!=null?b:""}else{return this[d[2][0]]||""}};this.addMenuItem=function(e,p,m){var k=this.newId("-cX-List-Item-");var g=this.$cX("li",{id:k,className:"CanvasXpressListItem",click:e[2],params:e[3]||[],upload:e[0]&&e[0]=="Load"?true:false,uploadParams:e[0]&&e[0]=="Load Parameters"?true:false});var n;var d={cursor:"grab",cursor:"-moz-grab",cursor:"-webkit-grab"};var t=false;if(e[5]){n=this.$cX("a",{id:this.newId("-cX-List-Item-A-"),className:"CanvasXpressListItemAArrow",hidefocus:"true",unselectable:"on",href:"#",menu:k,menuId:"false",menuFunc:e[5],menuParm:e[6],draggable:false},d);t=true}else{n=this.$cX("a",{id:this.newId("-cX-List-Item-A-"),className:"CanvasXpressListItemA",hidefocus:"true",unselectable:"on",href:"#",menuFunc:e[2],menuParm:e[3],draggable:false})}var h=this.$cX("img",{id:this.newId("-cX-List-Icon-"),className:"CanvasXpressListIcon",src:e[1]&&CanvasXpress.images[e[1]]?CanvasXpress.images[e[1]]:CanvasXpress.images.canvasXpress,key:e[1]});var r;if(e[0]&&(e[0]=="Load"||e[0]=="Load Parameters")){r=this.$cX("span",{id:this.newId("-cX-List-Item-Text-"),className:"CanvasXpressListItemText",draggable:false},{marginRight:0});var j=this.$cX("input",{id:this.newId("-cX-List-Item-Text-File-Upload"),className:"CanvasXpressListItemText",type:"file",draggable:false},{color:"transparent",width:"100px"});r.appendChild(j)}else{r=this.$cX("span",{id:this.newId("-cX-List-Item-Text-"),className:"CanvasXpressListItemText",innerHTML:e[0]||"",draggable:false},t?d:false)}var c=this.$cX("span",{className:"CanvasXpressListItemTextShort",innerHTML:e[4]||"",draggable:false});n.appendChild(h);n.appendChild(r);n.appendChild(c);g.appendChild(n);if(m){m.parentNode.insertBefore(g,m)}else{p.appendChild(g)}this.addRemoveItemListeners("addEvtListener",g)};this.addMenuItemText=function(c,m,j){var h=this.newId("-cX-List-Item-Text-");var f=this.newId("-cX-List-Item-Text-Input-");var d=this.getMenuItemValue(c);var e=this.$cX("li",{id:h,className:"CanvasXpressListItem",click:c[1],params:[c[2],f]});var n=this.$cX("input",{id:f,className:"CanvasXpressList",type:"text",value:d},{paddingLeft:"3px",width:"200px"});var k=this.$cX("a",{id:this.newId("-cX-List-Text-Item-A-"),className:"CanvasXpressListItemA",hidefocus:"true",unselectable:"on",href:"#"});var g=this.$cX("img",{id:this.newId("-cX-List-Text-Icon-"),className:"CanvasXpressListIcon",src:CanvasXpress.images.refresh,key:"refreshForm"},{marginTop:"4px"});k.appendChild(g);k.appendChild(n);e.appendChild(k);if(j){j.parentNode.insertBefore(e,j)}else{m.appendChild(e)}this.addRemoveItemListeners("addEvtListener",e)};this.addMenuItemColor=function(E,v,L){var m=this.newId("-cX-List-Item-Color-");var n=this.newId("-cX-List-Item-Color-Container-");var g=this.newId("-cX-List-Item-Color-Current-");var B=this.newId("-cX-List-Item-Color-Palete-");var f=this.newId("-cX-List-Item-Color-Palete-Current-");var k=this.newId("-cX-List-Item-Color-Saturation-");var w=this.newId("-cX-List-Item-Color-Saturation-Current-");var N=this[E[2][0]]||"";var G=this.$cX("li",{id:m,className:"CanvasXpressListItem",click:E[1],params:[E[2],g],palete:B,paleteCurrent:f,colorCurrent:g,saturation:k,saturationCurrent:w});var M=this.$cX("a",{id:this.newId("-cX-List-Color-Item-A-"),className:"CanvasXpressListItemA",hidefocus:"true",unselectable:"on",href:"#"},{height:"140px",width:"250px"});var I=this.$cX("img",{id:this.newId("-cX-List-Color-Icon-"),className:"CanvasXpressListIcon",src:CanvasXpress.images.refresh,key:"refreshForm"},{marginTop:"2px"});var J=N?this.rgbToHex(this.validateColor(N.replace(/[\'\"]/g,""))):this.foreground;this.colorRGBfromString(J);var t=Math.round(this.colorHSV[0]/6*180);var r=Math.round((1-this.colorHSV[1])*100);var q=Math.round((1-this.colorHSV[2])*100);var K=this.$cX("div",{id:n},{width:"188px",height:"138px",cssFloat:"left"});var C=this.$cX("div",{id:g,parentItem:m,className:"CanvasXpressConfiguratorColor",value:N},{width:"203px",height:"24px",cssFloat:"left",marginBottom:"5px",cursor:"default",lineHeight:"24px"});var D=this.$cX("div",{id:B,parentItem:m,className:"CanvasXpressConfiguratorColorMain"},{position:"relative",left:"0px",top:"0px",width:"181px",height:"101px"});var d=this.$cX("div",{id:f,parentItem:m,className:"CanvasXpressConfiguratorColorExtra"},{position:"relative",left:(t-7)+"px",top:(r-7)+"px",width:"195px",height:"115px"});D.appendChild(d);var A=this.$cX("div",{id:k,parentItem:m,className:"CanvasXpressConfiguratorColor"},{position:"relative",left:"188px",top:"-102px",width:"15px",height:"100px",border:"1px solid rgb(51,122,183)",clear:"left",cursor:"crosshair"});for(var H=0;H<100;H+=4){var F=this.$cX("div",false,{height:"4px",position:"relative",left:"0px",cursor:"crosshair"});A.appendChild(F)}var e=this.$cX("div",{id:w,parentItem:m,className:"CanvasXpressConfiguratorColorExtra"},{position:"relative",left:"0px",top:(q-108)+"px",width:"29px",height:"115px"});A.appendChild(e);K.appendChild(C);K.appendChild(D);K.appendChild(A);M.appendChild(I);M.appendChild(K);G.appendChild(M);if(L){L.parentNode.insertBefore(G,L)}else{v.appendChild(G)}this.colorizeCurrentItemColor(G);this.colorizeSaturationItemColor(G);this.addRemoveItemListeners("addEvtListener",G)};this.colorizeCurrentItemColor=function(a){var e=this.$(a.colorCurrent);if(e){var d=this.colorRGBToString();var b=this.hexToRgb("#"+d);e.style.backgroundColor="#"+d;e.innerHTML="&nbsp;&nbsp;"+b;e.style.color=this.complementaryColor(b,true);e.value=b}};this.colorizeSaturationItemColor=function(a){var d=function(m,k,c,j,h){return"rgb("+(m*(1-j/h)*100)+"%,"+(k*(1-j/h)*100)+"%,"+(c*(1-j/h)*100)+"%)"};var f=this.$(a.saturation);if(f&&this.colorHSV){var g=f.childNodes;var b=this.hsvFromRgb(this.colorHSV[0],this.colorHSV[1],1);if(b){for(var e=0;e<g.length-1;e++){g[e].style.backgroundColor=d(b[0],b[1],b[2],e,g.length-1)}}}};this.updateColorItemValue=function(b,c){if(!b){var g=this.getMenuItemComp(c);if(g){b=g[0]}else{return false}}if(this.changingColorItemOn){if(this.changingColorItemOn=="palette"){var a=this.$(b.palete);var h=this.$(b.paleteCurrent);if(a&&h){var j=this.adjustedCoordinates(c,a);if(j){var i=Math.min(Math.max(0,j.x),181);var f=Math.min(Math.max(0,j.y-25),101);h.style.left=(i-7)+"px";h.style.top=(f-7)+"px";this.colorFromHsv(i*6/180,1-f/100,null);this.colorizeCurrentItemColor(b);this.colorizeSaturationItemColor(b)}}}else{var k=this.$(b.saturation);var d=this.$(b.saturationCurrent);if(k&&d){var j=this.adjustedCoordinates(c,k);if(j){var f=Math.min(Math.max(0,j.y-25),101);d.style.top=(f-108)+"px";this.colorFromHsv(null,null,1-f/100);this.colorizeCurrentItemColor(b)}}}}return false};this.endColorItemChange=function(a){this.changingColorItemOn=false};this.addMenuItemSlider=function(q,m,I){var f=this.newId("-cX-List-Item-Slider-");var e=this.newId("-cX-List-Item-Slider-Container-");var E=this.newId("-cX-List-Item-Slider-Table-");var K=q[2][0]||"";var D=this.formatNumber(this.binConfigurations[K]["max"],this.binConfigurations[K]["dec"]);var v=this.$cX("li",{id:f,className:"CanvasXpressListItem",click:q[1],params:[q[2][0],e],slider:K});var J=this.$cX("a",{id:this.newId("-cX-List-Slider-Item-A-"),className:"CanvasXpressListItemA",hidefocus:"true",unselectable:"on",href:"#"});var H=this.$cX("div",{id:e,className:"CanvasXpressList"});var n=this.$cX("table",{id:E,className:"CanvasXpressListItemTable"},{width:"100%"});var g=this.$cX("tbody");var h=D.length*8;for(var B=0;B<this.binConfigurations[K]["n"];B++){var s=Number(B>0?this.binConfigurations[K]["bins"][B-1]["value"]:this.binConfigurations[K]["min"]);var A=Number(B<this.binConfigurations[K]["n"]-1?this.binConfigurations[K]["bins"][B+1]["value"]:this.binConfigurations[K]["max"]);var k=this.$cX("input",{id:E+"-Range-"+B,className:"CanvasXpressListItem",type:"range",value:this.binConfigurations[K]["bins"][B]["value"],min:s,max:A,step:Number(this.formatNumber((A-s)/20,this.binConfigurations[K]["dec"])),slider:K,sliderRange:B,sliderNumber:false},{width:"120px"});var j=this.$cX("input",{id:E+"-Number-"+B,className:"CanvasXpressListItem",type:"number",value:this.binConfigurations[K]["bins"][B]["value"],min:s,max:A,step:Number(this.formatNumber((A-s)/20,this.binConfigurations[K]["dec"])),slider:K,sliderRange:B,sliderNumber:true},{width:(h+18)+"px",textAlign:"right"});var c=this.$cX("tr");var G=this.$cX("th",{innerHTML:this.binConfigurations[K]["bins"][B]["name"]},{paddingRight:"5px"});var F=this.$cX("td",{id:E+"-Min-"+B,innerHTML:this.formatNumber(s,this.binConfigurations[K]["dec"])},{width:h+"px",textAlign:"right"});var C=this.$cX("td");C.appendChild(k);var z=this.$cX("td",{id:E+"-Max-"+B,innerHTML:this.formatNumber(A,this.binConfigurations[K]["dec"])},{width:h+"px"});var w=this.$cX("td",false,{paddingLeft:"5px"});w.appendChild(j);c.appendChild(G);c.appendChild(F);c.appendChild(C);c.appendChild(z);c.appendChild(w);g.appendChild(c)}n.appendChild(g);H.appendChild(n);H.appendChild(this.$cX("br"));var p=this.$cX("img",{id:this.newId("-cX-List-Icon-"),className:"CanvasXpressListIcon",src:CanvasXpress.images.refresh,key:"refreshForm"},{marginTop:"4px"});J.appendChild(p);J.appendChild(H);v.appendChild(J);if(I){I.parentNode.insertBefore(v,I)}else{m.appendChild(v)}this.addRemoveItemListeners("addEvtListener",v)};this.updateSliderItemValue=function(h){var a=this.changingSliderItemOn.slider;var g=this.changingSliderItemOn.sliderRange;var c=Number(this.formatNumber(this.changingSliderItemOn.value,this.binConfigurations[a]["dec"]));var d=this.$(this.changingSliderItemOn.id.replace("-Range-","-Number-"));var f=this.$(this.changingSliderItemOn.id.replace("-Range-"+g,"-Range-"+(g-1)));var j=this.$(this.changingSliderItemOn.id.replace("-Range-"+g,"-Max-"+(g-1)));var b=this.$(this.changingSliderItemOn.id.replace("-Range-"+g,"-Range-"+(g+1)));var i=this.$(this.changingSliderItemOn.id.replace("-Range-"+g,"-Min-"+(g+1)));this.binConfigurations[a]["bins"][g]["value"]=c;if(d){d.value=c}if(f&&j){f.max=c;f.step=(f.max-f.min)/20;j.innerHTML=c}if(b&&i){b.min=c;b.step=(b.max-b.min)/20;i.innerHTML=c}this.applySliderItemValue(a);return false};this.endSliderItemChange=function(g){if(this.changingSliderItemOn.sliderNumber){var a=this.changingSliderItemOn.slider;var f=this.changingSliderItemOn.sliderRange;var c=Number(this.formatNumber(this.changingSliderItemOn.value,this.binConfigurations[a]["dec"]));var i=this.$(this.changingSliderItemOn.id.replace("-Number-","-Range-"));var d=this.$(this.changingSliderItemOn.id.replace("-Number-"+f,"-Range-"+(f-1)));var j=this.$(this.changingSliderItemOn.id.replace("-Number-"+f,"-Max-"+(f-1)));var b=this.$(this.changingSliderItemOn.id.replace("-Number-"+f,"-Range-"+(f+1)));var h=this.$(this.changingSliderItemOn.id.replace("-Number-"+f,"-Min-"+(f+1)));this.binConfigurations[a]["bins"][f]["value"]=c;if(i){i.value=c}if(d&&j){d.max=c;d.step=(d.max-d.min)/20;j.innerHTML=c}if(b&&h){b.min=c;b.step=(b.max-b.min)/20;h.innerHTML=c}this.applySliderItemValue(a)}this.changingSliderItemOn=false};this.applySliderItemValue=function(f){var a=this.binConfigurations[f]["name"];var e=this.binConfigurations[f]["vi"];this.data.x[a]=[];for(var d=0;d<this.data.y.data[e].length;d++){var b=this.data.y.data[e][d];if(!isNaN(b)&&b!=""&&b!=null){for(var c=0;c<this.binConfigurations[f]["n"];c++){if(b<=this.binConfigurations[f]["bins"][c].value){this.data.x[a][d]=this.binConfigurations[f]["bins"][c].name;break}}}else{this.data.x[a][d]=""}}if(this.isGroupedData){this.ungroupSamples(true)}this.updateData(this.data);this.groupSamples([a]);this.sortSamplesByCategory([a])};this.addMenuItemFilter=function(f,d,a){var e=this.newId("-cX-List-Item-");var c=this.$cX("li",{id:e,className:"CanvasXpressListItem",type:"filter",selector:f[1].id.split(":")[1]});c.appendChild(f[1]);if(a){a.parentNode.insertBefore(c,a)}else{d.appendChild(c)}};this.addRemoveItemListeners=function(b,a){if(!a){return this.removeMenus()}else{if(a.className=="CanvasXpressListItemSep"){return}}var e=a.parentNode.parentNode;var f=a.id.match("-cX-List-Item-Color-");if(this.hasClass(e,"draggable")&&!f){this[b](e,"mousedown",this.registerMousemove,false)}if(a.upload){var d=a.childNodes[0].childNodes[1].childNodes[0];this[b](d,"change",this.loadFile,false)}else{if(a.uploadParams){var d=a.childNodes[0].childNodes[1].childNodes[0];this[b](d,"change",this.loadParamsFile,false)}else{this[b](a,"click",this.clickMenuItem,false)}}this[b](a,"mouseover",this.mouseoverMenuItem,false);this[b](a,"mouseout",this.mouseoutMenuItem,false);this[b](a,"mousewheel",this.mousewheelMenuItem,false);this[b](a,"contextmenu",this.contextMenuItem,false);if(a.className.match(/Scroll/)){this[b](a,"mousedown",this.mousedownMenuItem,false);this[b](a,"mouseup",this.mouseupMenuItem,false)}if(a.paleteCurrent&&a.saturation){this[b](a,"mousedown",this.mousedownMenuItemColor,false)}if(a.slider){this[b](a,"mousedown",this.mousedownMenuItemSlider,false)}};this.contextMenuItem=function(a){return function(h){if(!h){h=window.event}a.cancelEvent(h);var b=a.getTargetEvent(h);var n=a.getMenuItemComp(h);var f=n[1].childNodes[0];var g=n[1].childNodes[1].innerText;var k=n[1].menuFunc;var j=n[1].menuParm;var p=n[1].menuId;var q=n[2].offsetLeft;var l=n[2].offsetTop+n[1].offsetTop;a.removeMenus();var o=[["Pin "+g+" to Toolbar","pin","pinToToolbar",[f,g,k,j,p,false,true]]];var d=a.addMenu(h,o);var c=a.$(d);c.style.left=q+"px";c.style.top=l+"px";c.style.display="block";return false}}(this);this.pinToToolbar=function(c,d,f,e,g,i,h){this.removeMenus();var b=this.$(this.target+"-cX-Toolbar-Custom");if(b){var a=this.target+"-cX-Custom-Toolbar-Menu-"+f;if(!this.$(a)){c.id=a;c.className="CanvasXpressToolbarImage";c.style.width="24px";c.style.height="24px";c.style.cssFloat="left";c.title=d;c.fun=f;c.par=e;c.mid=g||this.newId("-cX-Default-Toolbar-Menu-");if(h){b.insertBefore(c,b.firstChild)}else{b.appendChild(c)}this.addRemoveEvtListener("addEvtListener",c,"click",this.addCustomToolbarMenu,false);this.addRemoveEvtListener("addEvtListener",c,"contextmenu",this.unpinFromToolbar,false);if(!i){CanvasXpress.stack[this.target].afterRender.push(["addImageToToolbar",[c.key,d,f,e,g]])}}}};this.unpinFromToolbar=function(a){return function(j){if(!j){j=window.event}a.cancelEvent(j);var c=a.getTargetEvent(j);var g=c.offsetLeft;var h=c.offsetTop;var f=[["Unpin "+c.title+" from Toolbar","unpin","removeImageFromToolbar",[c.id]]];var d=a.addMenu(j,f);var b=a.$(d);b.style.left=g+"px";b.style.top=h+"px";b.style.display="block";return false}}(this);this.addCustomToolbarMenu=function(a){return function(g){if(!g){g=window.event}a.cancelEvent(g);var d=a.getTargetEvent(g);var h=a[d.fun].apply(a,d.par);if(d.mid){var f=a.addMenu(false,h);var b=a.$(f);if(d.id.match(/DataExplorer/)){if(a.menuIndex<10002){a.menuIndex=10002}var j=a.getBoundingClientRect(d);b.style.left=parseInt(j.left)+"px";b.style.top=parseInt(j.top)+"px";b.style.zIndex=a.menuIndex++}else{b.style.left=d.offsetLeft+"px";b.style.top="10px"}b.style.display="block"}}}(this);this.addImageToToolbar=function(e,a,b,h,d,g,f){var c=this.$cX("img",{className:"CanvasXpressToolbarImage",src:CanvasXpress.images[e],key:e});this.pinToToolbar(c,a,b,h,d,g,f)};this.removeImageFromToolbar=function(c,b){var a=this.$(c);if(a){this.addRemoveEvtListener("removeEvtListener",a,"click",this.addCustomToolbarMenu,false);this.addRemoveEvtListener("removeEvtListener",a,"contextmenu",this.unpinFromToolbar,false);a.parentNode.removeChild(a);this.removeMenus();if(!b){CanvasXpress.stack[this.target].afterRender.push(["removeImageFromToolbar",[c]])}}};this.removeAllImagesFromToolbar=function(){var a=this.$(this.target+"-cX-Toolbar-Custom");if(a){var b=a.getElementsByTagName("img");while(b.length>0){this.removeImageFromToolbar(b[0].id,true)}}};this.clickMenuItem=function(a){return function(h){if(!h){h=window.event}a.cancelEvent(h);var b=a.getTargetEvent(h);var m=a.getMenuItemComp(h);if(m&&!/input|textarea|select/i.test(b.tagName)){if(m[0].className.match(/Scroll/)||m[1].className.match(/Scroll/)){var c=m[0].className.match(/Scroll/)?m[0]:m[1];var n=c.parentNode;var j=c.className.match(/ScrollTop/)?"Top":"Bottom";a.pageMenuItem(n,j)}else{var f=[];if(m[0].params){for(var g=0;g<m[0].params.length;g++){if(m[0].params[g]=="event"){f.push(h)}else{if(m[0].params[g]=="component"){f.push(m)}else{f.push(m[0].params[g])}}}}if(a[m[0].click]){a[m[0].click].apply(a,f);var d=m[1].firstChild.key;var o=m[1].firstChild.src;if(d){if(d.match("unchecked")){m[1].firstChild.key="checked";m[1].firstChild.src=CanvasXpress.images.checked}else{if(d.match("checked")){m[1].firstChild.key="unchecked";m[1].firstChild.src=CanvasXpress.images.unchecked}else{if(d.match("eyeClosed")){m[1].firstChild.key="eye2";m[1].firstChild.src=CanvasXpress.images.eye2;m[1].childNodes[1].innerHTML=m[1].childNodes[1].innerHTML.replace("Hide","Show")}else{if(d.match("eye2")){m[1].firstChild.key="eyeClosed";m[1].firstChild.src=CanvasXpress.images.eyeClosed;m[1].childNodes[1].innerHTML=m[1].childNodes[1].innerHTML.replace("Show","Hide")}else{if(d=="lightbulb"){m[1].firstChild.key="lightbulbOff";m[1].firstChild.src=CanvasXpress.images.lightbulbOff}else{if(d=="lightbulbOff"){m[1].firstChild.key="lightbulb";m[1].firstChild.src=CanvasXpress.images.lightbulb}else{if(d=="descending"){m[1].firstChild.key="ascending";m[1].firstChild.src=CanvasXpress.images.ascending}else{if(d=="ascending"){m[1].firstChild.key="descending";m[1].firstChild.src=CanvasXpress.images.descending}else{if(d.match("radioOn")){a.resetRadioMenuItem(m[2].firstChild.childNodes);if(f[1]&&f[1].match(/xAxis|yAxis|zAxis/)){m[1].firstChild.key="radioOn";m[1].firstChild.src=CanvasXpress.images.radioOn}else{m[1].firstChild.key="radioOff";m[1].firstChild.src=CanvasXpress.images.radioOff}}else{if(d.match("radioOff")){a.resetRadioMenuItem(m[2].firstChild.childNodes);m[1].firstChild.key="radioOn";m[1].firstChild.src=CanvasXpress.images.radioOn}}}}}}}}}}}}}return false}else{return false}}}(this);this.resetRadioMenuItem=function(b){for(var c=0;c<b.length;c++){var a=b[c].firstChild.firstChild;if(a&&a.nodeName.match(/img/i)){a.src=CanvasXpress.images.radioOff;a.key="radioOff"}}};this.adjustMenuItemPosition=function(f,p,o){var g,x;var q=this.remoteParentId?this.$(this.remoteParentId):this.$("container-"+this.target);var i=window.innerWidth;var b=window.innerHeight;var u=q.offsetLeft;var k=q.offsetTop;var s=q.clientWidth;var j=q.clientHeight;var a=i-u;var v=f.clientWidth;var n=f.clientHeight;if(p){g=p.offsetLeft+p.offsetWidth-5;if(g+v+5>a){g=p.offsetLeft-v+5}x=p.offsetTop+o.offsetTop}else{g=f.offsetLeft;x=f.offsetTop}f.style.left=g+"px";f.style.top=x+"px"};this.mouseoverMenuItem=function(a){return function(j){if(!j){j=window.event}var h=a.getMenuItemComp(j);if(!h){return false}if(h[0].className.match(/Scroll/)||h[1].className.match(/Scroll/)){var n=h[0].className.match(/Scroll/)?h[0]:h[1];n.className+="Active";return false}var f=h[2].firstChild.childNodes;a.hideMenusRecursively(f);h[0].className="CanvasXpressListItemActive";if(h[1].menu){var l=a[h[1].menuFunc].apply(a,h[1].menuParm);var g=a.addMenu(false,l,h[1].menu);var b=a.$(g);var k=h[2];b.style.left="0px";b.style.top="0px";b.style.display="block";a.adjustMenuItemPosition(b,k,h[1]);h[1].className="CanvasXpressListItemAArrowActive";h[1].menuId=g}else{h[1].className="CanvasXpressListItemAActive"}return false}}(this);this.mouseoutMenuItem=function(a){return function(z){if(!z){z=window.event}if(a.fastScrollMenuOn){a.fastScrollMenuOn=false;clearInterval(a.fastScrollMenu)}var w,v,u,s,i,h,g,c;var B=a.adjustedCoordinates(z);if(B){var k=a.$("north-container-"+a.target);var l=a.$("west-container-"+a.target);B.x+=l.offsetWidth;B.y+=k.offsetHeight;var o=a.getMenuItemComp(z);if(!o){return false}else{if(o[1]&&o[1].menu){var p=a.$(o[1].menuId);var x=p.firstChild.firstChild;w=p.offsetLeft;i=p.offsetTop;v=w+p.offsetWidth;h=i+p.offsetHeight;if(B.x>=w&&B.x<=v&&B.y>=i&&B.y<=h){return false}a.hideMenu(o,p);if(x&&x.type=="filter"){var A=x.firstChild;if(A.type=="string"){var r=a.$(a.target+":"+x.selector+":cX-DataFilterMask");if(r){a.addRemoveStringDataFilterListeners("removeEvtListener",r)}}else{var q=a.$(a.target+":"+x.selector+":cX-DataFilterMin");var n=a.$(a.target+":"+x.selector+":cX-DataFilterMinLabel");var j=a.$(a.target+":"+x.selector+":cX-DataFilterRange");var t=a.$(a.target+":"+x.selector+":cX-DataFilterMax");var y=a.$(a.target+":"+x.selector+":cX-DataFilterMaxLabel");var b=a.$(a.target+":"+x.selector+":cX-DataFilterScale");if(q&&n&&j&&t&&y&&b){a.addRemoveNumericDataFilterListeners("removeEvtListener",q,t,n,y,b)}}}}else{a.hideMenu(o)}}}return false}}(this);this.mousedownMenuItemColor=function(a){return function(d){if(!d){d=window.event}var b=a.getTargetEvent(d);var c=a.getMenuItemComp(d);if(!c){return false}else{if(b.id&&b.id.match(/-cX-List-Item-Color-Palete-/)){a.changingColorItemOn="palette";if(a.colorHSV[2]==0){a.colorFromHsv(null,null,1);a.colorizeCurrentItemColor(c[0]);var f=a.$(c[0].saturationCurrent);if(f){f.style.top="-108px"}}a.updateColorItemValue(c[0],d);a.colorizeSaturationItemColor(c[0])}else{if(b.parentNode.id&&b.parentNode.id.match(/-cX-List-Item-Color-Saturation-/)){a.changingColorItemOn="saturation";a.updateColorItemValue(c[0],d)}}}a.cancelEvent(d);return false}}(this);this.mousedownMenuItemSlider=function(a){return function(b){if(!b){b=window.event}a.changingSliderItemOn=a.getTargetEvent(b);return false}}(this);this.mousedownMenuItem=function(a){return function(b){if(!b){b=window.event}a.fastScrollMenuOn=true;a.fastScrollMenu=a.setInterval(function(){a.clickMenuItem(b)},100);return false}}(this);this.mouseupMenuItem=function(a){return function(b){if(!b){b=window.event}if(a.fastScrollMenuOn){a.fastScrollMenuOn=false;clearInterval(a.fastScrollMenu)}}}(this);this.mousewheelMenuItem=function(a){return function(g){if(!g){g=window.event}a.cancelEvent(g);var h=0;if(g.wheelDelta){h=g.wheelDelta;if(window.opera){h=-h}}else{if(g.detail){h=-g.detail}}if(h){var b=a.getTargetEvent(g);var f=a.getMenuItemComp(g);if(!f){return false}var c=f[0].parentNode;if(h>0){a.pageMenuItem(c,"Top")}else{a.pageMenuItem(c,"Bottom")}}return false}}(this);this.getMenuItemComp=function(b){var a=this.getTargetEvent(b);while(a&&a.tagName&&!a.tagName.match(/li/i)){a=a.parentNode}return a.parentNode&&a.parentNode.parentNode?[a,a.firstChild,a.parentNode.parentNode]:false};this.hideMenu=function(e,f){if(e){if(e[0].className.match(/Scroll/)||e[1].className.match(/Scroll/)){var g=e[0].className.match(/Scroll/)?e[0]:e[1];g.className=g.className.replace("Active","")}else{if(e[1].menu){e[1].className="CanvasXpressListItemAArrow"}else{e[1].className="CanvasXpressListItemA"}e[0].className="CanvasXpressListItem"}}if(f){var b=f.firstChild.childNodes;for(var d=0;d<b.length;d++){var a=b[d];if(!a.className.match(/Scroll|ItemSep/)){this.addRemoveItemListeners("removeEvtListener",a)}}f.parentNode.removeChild(f)}};this.hideMenusRecursively=function(e){for(var f=0;f<e.length;f++){var c=e[f];if(!c.className.match(/Scroll|ItemSep/)){var d=c.firstChild;var b=d.menu?this.$(d.menuId):false;if(b){this.hideMenusRecursively(b.firstChild.childNodes)}this.hideMenu([c,d],b)}}};this.removeMenus=function(k){var f=[];if(this.skipHeaderMouseout){this.skipHeaderMouseout.className="CanvasXpressTableCellHead";this.skipHeaderMouseout.firstChild.firstChild.className="CanvasXpressTableCellHead";this.skipHeaderMouseout=false}if(!k){var c=this.$("north-wrapper-"+this.target);if(c){var h=c.getElementsByTagName("div");for(var g=0;g<h.length;g++){if(this.hasClass(h[g],"CanvasXpressMenu")){f.unshift(this.$(h[g].id))}}}this.menuIndex=10000}else{f.push(this.$(this.target+"-cX-Menu-"+k))}if(f.length>0){for(g in this.meta.ids){if(g.match(/cX-Menu-|cX-Menu/)){delete (this.meta.ids[g])}}for(var g=0;g<f.length;g++){var a=f[g];var b=a.getElementsByTagName("li");for(var e=0;e<b.length;e++){if(b[e].className!="CanvasXpressListItemSep"){this.addRemoveItemListeners("removeEvtListener",b[e])}}a.parentNode.removeChild(a)}}};this.changeTextColorAttributeMenu=function(a,b){return this.isArray(b)?[[a,"changeTextColorAttribute",b]]:[[a,"changeTextColorAttribute",[b]]]};this.getAxisLayoutTypeMenu=function(){var a=[];a.push(["Complete - Both",this.scatterPlotMatrixType=="completeBoth"?"radioOn":"radioOff","changeLayoutType",["completeBoth"]]);a.push(["Complete - Upper",this.scatterPlotMatrixType=="completeUpper"?"radioOn":"radioOff","changeLayoutType",["completeUpper"]]);a.push(["Complete - Lower",this.scatterPlotMatrixType=="completeLower"?"radioOn":"radioOff","changeLayoutType",["completeLower"]]);a.push(["First",this.scatterPlotMatrixType=="first"?"radioOn":"radioOff","changeLayoutType",["first"]]);return a};this.getAxisLayoutMenu=function(){var a=[];a.push(["Auto-Adjust",this.layoutAdjust?"lightbulb":"lightbulbOff","toggleAttribute",["layoutAdjust"]]);a.push(["Type",false,false,false,false,"getAxisLayoutTypeMenu",[]]);return a};this.getAxisSampleMenu=function(c){var d=[];var a=this.getObjectArray(this[c+"Axis"]);for(var b=0;b<this.data.y.smps.length;b++){d.push([this.data.y.smps[b],a[this.data.y.smps[b]]?"checked":"unchecked","changeSampleInAxis",[this.data.y.smps[b],c+"Axis"]])}return d};this.getAxisMenu=function(e,d){var c=e.toUpperCase();var b=d?"2":"";var a=[];a.push([this[e+"Axis"+b+"Show"]?"Hide Axis":"Show Axis",this[e+"AxisShow"]?"eyeClosed":"eye2","toggleAttribute",[e+"Axis"+b+"Show"]]);a.push(["Set Min","min",false,false,false,"changeTextColorAttributeMenu",["-text-","setMin"+c+b]]);a.push(["Set Max","max",false,false,false,"changeTextColorAttributeMenu",["-text-","setMax"+c+b]]);a.push(["Transform","function",false,false,false,"getAxisTransformMenu",[e]]);if(this.graphType=="Scatter3D"||this.graphType=="ScatterBubble2D"||this.is3DPlot){a.push(["Exact Range","exact","toggleAttribute",[e+"AxisExact"]])}a.push(["Format","textFormat",false,false,false,"changeTextColorAttributeMenu",["-text-",e+"Axis"+b+"TickFormat"]]);if(this.graphType.match(/Scatter/)){a.push(["Samples","samples",false,false,false,"getAxisSampleMenu",[e]])}return a};this.getFirstAxisMenu=function(){return[[this.xAxisShow?"Hide Axis":"Show Axis",this.xAxisShow?"eyeClosed":"eye2","toggleAttribute",["xAxisShow"]]]};this.getSecondAxisMenu=function(){return[[this.xAxis2Show?"Hide Axis":"Show Axis",this.xAxis2Show?"eyeClosed":"eye2","toggleAttribute",["xAxis2Show"]]]};this.getRangeAxisMenu=function(){var a=[];a.push(["Set Min","min",false,false,false,"changeTextColorAttributeMenu",["-text-","setMinX"]]);a.push(["Set Max","max",false,false,false,"changeTextColorAttributeMenu",["-text-","setMaxX"]]);return a};this.getAxesMenu=function(){var a=[];if(this.graphType=="Scatter2D"){a.push(["X-Axis","axes2DPropertiesX",false,false,false,"getAxisMenu",["x"]]);a.push(["Y-Axis","axes2DPropertiesY",false,false,false,"getAxisMenu",["y"]]);a.push(["Color","colors",false,false,false,"changeTextColorAttributeMenu",["-color-","axisTickColor"]]);a.push(["Font","font",false,false,false,"getFontStyleMenu",["axisTick"]]);if(this.scatterPlotMatrix){a.push(["Axes Layout",false,false,false,false,"getAxisLayoutMenu",[]])}}else{if(this.graphType=="Scatter3D"||this.graphType=="ScatterBubble2D"||this.is3DPlot){a.push(["X-Axis","axes3DPropertiesX",false,false,false,"getAxisMenu",["x"]]);a.push(["Y-Axis","axes3DPropertiesY",false,false,false,"getAxisMenu",["y"]]);a.push(["Z-Axis","axes3DPropertiesZ",false,false,false,"getAxisMenu",["z"]]);a.push(["Color","colors",false,false,false,"changeTextColorAttributeMenu",["-color-","axisTickColor"]]);a.push(["Font","font",false,false,false,"getFontStyleMenu",["axisTick"]])}else{if(this.graphType.match(/BarLine|DotLine|AreaLine|StackedLine|StackedPercentLine/)){a.push(["First Axis","axes1DPropertiesFirst",false,false,false,"getAxisMenu",["x"]]);a.push(["Second Axis","axes1DPropertiesSecond",false,false,false,"getAxisMenu",["x",true]]);a.push(["Color","colors",false,false,false,"changeTextColorAttributeMenu",["-color-","axisTickColor"]]);a.push(["Font","font",false,false,false,"getFontStyleMenu",["axisTick"]])}else{a.push(["First Axis","axes1DPropertiesFirst",false,false,false,"getFirstAxisMenu",[]]);a.push(["Second Axis","axes1DPropertiesSecond",false,false,false,"getSecondAxisMenu",[]]);a.push(["Range","range",false,false,false,"getRangeAxisMenu",[]]);a.push(["Format","textFormat",false,false,false,"changeTextColorAttributeMenu",["-text-","xAxisTickFormat"]]);a.push(["Color","colors",false,false,false,"changeTextColorAttributeMenu",["-color-","axisTickColor"]]);a.push(["Font","font",false,false,false,"getFontStyleMenu",["axisTick"]]);if(this.layoutValid){a.push(["Auto-Adjust",this.layoutAdjust?"lightbulb":"lightbulbOff","toggleAttribute",["layoutAdjust"]])}}}}return a};this.getHeatmapBoxMenu=function(){var a=[];a.push(["Color","colors",false,false,false,"changeTextColorAttributeMenu",["-color-","heatmapCellBoxColor"]]);a.push(["Width","thickness2",false,false,false,"changeTextColorAttributeMenu",["-text-","heatmapCellBoxWidth"]]);a.push([this.heatmapCellBox?"Hide Box":"Show Box",this.heatmapCellBox?"eyeClosed":"eye2","toggleAttribute",["heatmapCellBox"]]);return a};this.getHeatmapHighlightMenu=function(){return[["Color","colors",false,false,false,"changeTextColorAttributeMenu",["-color-","heatmapCellBoxColorHighlight"]]]};this.getHeatmapVarSmpSeparatorsMenu=function(h,d,j){var e=this.meta.data;var k=[];if(e[h]&&d.length>0){var f={};for(var g=0;g<d.length;g++){var a=d[g];if(e[h][a].type!="Numeric"){f[a]=true}}var b=this.sortObject(f);for(var g=0;g<b.length;g++){k.push([b[g],b[g]==this[j]?"radioOn":"radioOff","changeAttribute",[j,b[g]]])}}return k};this.getHeatmapSeparatorsMenu=function(){var a=[];if(this.isStringOverlays("v")){a.push(["Variables","variables",false,false,false,"getHeatmapVarSmpSeparatorsMenu",["z",this.varOverlays,"heatmapVarSeparateBy"]])}if(this.isStringOverlays("s")){a.push(["Samples","samples",false,false,false,"getHeatmapVarSmpSeparatorsMenu",["x",this.smpOverlays,"heatmapSmpSeparateBy"]])}return a};this.getHeatmapMenu=function(){var a=[];a.push(["Cell Boxes","square",false,false,false,"getHeatmapBoxMenu",[]]);a.push(["Highlight","heatmapHighlight",false,false,false,"getHeatmapHighlightMenu",[]]);if(this.isStringOverlays()){a.push(["Separators","heatmapSpaceSeparation",false,false,false,"getHeatmapSeparatorsMenu",[]])}return a};this.getPlotAreaMajorTicksMenu=function(a){return[[this[a]?"Hide Major Ticks":"Show Major Ticks",this[a]?"eyeClosed":"eye2","toggleAttribute",[a]]]};this.getPlotAreaMinorTicksMenu=function(a){return[[this[a]?"Hide Minor Ticks":"Show Minor Ticks",this[a]?"eyeClosed":"eye2","toggleAttribute",[a]]]};this.getPlotAreaTickTypeMenu=function(a){var b=[];b.push(["Solid","ticksMajor","changeAttribute",[a,"solid"]]);b.push(["Dotted","ticksTypeDotted","changeAttribute",[a,"dotted"]]);b.push(["Dashed","ticksTypeDashed","changeAttribute",[a,"dashed"]]);return b};this.getPlotAreaGridMenu=function(b){var a=[];a.push(["Color","colors",false,false,false,"changeTextColorAttributeMenu",["-color-",b+"AxisTickColor"]]);if(this.graphType!="Scatter3D"&&!this.is3DPlot){a.push(["Major Ticks","ticksMajor",false,false,false,"getPlotAreaMajorTicksMenu",[b+"AxisMajorTicks"]]);a.push(["Minor Ticks","ticksMinor",false,false,false,"getPlotAreaMinorTicksMenu",[b+"AxisMinorTicks"]]);a.push(["Number","hash",false,false,false,"changeTextColorAttributeMenu",["-text-",b+"AxisTicks"]])}a.push(["Style","ticksType",false,false,false,"getPlotAreaTickTypeMenu",[b+"AxisTickStyle"]]);return a};this.getPlotAreaScatterGridMenu=function(){var a=[];if(this.graphType=="Scatter2D"||this.graphType=="ScatterBubble2D"){a.push(["X-Axis","grid2DX",false,false,false,"getPlotAreaGridMenu",["x"]]);a.push(["Y-Axis","grid2DY",false,false,false,"getPlotAreaGridMenu",["y"]])}else{if(this.graphType=="Scatter3D"||this.is3DPlot){a.push(["X-Axis","grid3DX",false,false,false,"getPlotAreaGridMenu",["x"]]);a.push(["Y-Axis","grid3DY",false,false,false,"getPlotAreaGridMenu",["y"]]);a.push(["Z-Axis","grid3DZ",false,false,false,"getPlotAreaGridMenu",["z"]])}}return a};this.getPlotAreaAxisAlgorithmMenu=function(){var a=[];a.push(["Heckbert",this.axisAlgorithm=="heckbert"?"radioOn":"radioOff","changeAttribute",["axisAlgorithm","heckbert"]]);a.push(["R Pretty",this.axisAlgorithm=="rPretty"?"radioOn":"radioOff","changeAttribute",["axisAlgorithm","rPretty"]]);a.push(["Wilkinson",this.axisAlgorithm=="wilkinson"?"radioOn":"radioOff","changeAttribute",["axisAlgorithm","wilkinson"]]);a.push(["Wilkinson Extended",this.axisAlgorithm=="wilkinsonExtended"?"radioOn":"radioOff","changeAttribute",["axisAlgorithm","wilkinsonExtended"]]);return a};this.getPlotAreaBarsTypeMenu=function(){var a=[];a.push(["Standard Deviation",this.errorBarsType=="standardDeviation"?"radioOn":"radioOff","changeAttribute",["errorBarsType","standardDeviation"]]);a.push(["Standard Error of Mean",this.errorBarsType=="standardErrorMean"?"radioOn":"radioOff","changeAttribute",["errorBarsType","standardErrorMean"]]);a.push(["95% Confidence Interval",this.errorBarsType=="confidenceInterval95"?"radioOn":"radioOff","changeAttribute",["errorBarsType","confidenceInterval95"]]);return a};this.getPlotAreaErrorBarsMenu=function(){var a=[];a.push(["Color","colors",false,false,false,"changeTextColorAttributeMenu",["-color-","errorBarsColor"]]);a.push(["Thickness","thickness",false,false,false,"changeTextColorAttributeMenu",["-text-","errorBarsThickness"]]);a.push(["Type","Tu",false,false,false,"getPlotAreaBarsTypeMenu",[]]);a.push([this.showErrorBars?"Hide Error Bars":"Show Error Bars",this.showErrorBars?"eyeClosed":"eye2","toggleAttribute",["showErrorBars"]]);return a};this.getPlotAreaOneVariableSpaceMenu=function(){var a=[];a.push(["Farther","farther","setFontAttributeSize",["variableSpaceFactor","increase"]]);a.push(["Closer","closer","setFontAttributeSize",["variableSpaceFactor","decrease"]]);return a};this.getPlotAreaOneSampleWidthMenu=function(){var a=[];a.push(["Wider","wider","setFontAttributeSize",["widthFactor","increase"]]);a.push(["Thinner","thinner","setFontAttributeSize",["widthFactor","decrease"]]);return a};this.getBoxplotMedianMenu=function(){var a=[];a.push(["Median Color","colors",false,false,false,"changeTextColorAttributeMenu",["-color-","boxplotMedianColor"]]);a.push(["Width","thickness",false,false,false,"changeTextColorAttributeMenu",["-text-","boxplotMedianWidth"]]);return a};this.getBoxplotMeanMenu=function(){var a=[];a.push(["Mean Color","colors",false,false,false,"changeTextColorAttributeMenu",["-color-","boxplotMeanColor"]]);a.push(["Mean Border Color","colors",false,false,false,"changeTextColorAttributeMenu",["-color-","boxplotMeanColorBorder"]]);a.push([this.boxplotMean?"Hide Mean":"Show Mean",this.boxplotMean?"eyeClosed":"eye2","toggleAttribute",["boxplotMean"]]);return a};this.getWishkersMenu=function(){var a=[];a.push(["Single","wishkersSingle","changeAttribute",["boxplotWishkersType","single"]]);a.push(["Double","wishkersDouble","changeAttribute",["boxplotWishkersType","double"]]);return a};this.getBinAlignmentMenu=function(){var b=[];b.push(["Left","binAlignmentLeft","changeAttribute",["binAlignment","left"]]);b.push(["Center","binAlignmentCenter","changeAttribute",["binAlignment","center"]]);b.push(["Right","binAlignmentRight","changeAttribute",["binAlignment","right"]]);return b};this.getDataPointsMenu=function(){var a=[];a.push(["Jitter","jitter","toggleAttribute",["jitter"]]);a.push(["Binned","binned","toggleAttribute",["binned"]]);a.push(["Bin Aligment","binAlignment",false,false,false,"getBinAlignmentMenu",[]]);if(this.graphType=="Boxplot"){a.push([this.showBoxplotOriginalData?"Hide Data":"Show Data",this.showBoxplotOriginalData?"eyeClosed":"eye2","toggleAttribute",["showBoxplotOriginalData"]])}return a};this.getBoxplotAttributesMenu=function(){var b=[];b.push(["Notch","notched","toggleAttribute",["boxplotNotched"]]);b.push(["Wishkers","wishkers",false,false,false,"getWishkersMenu"]);b.push(["Boxplot Mean","boxplotMean",false,false,false,"getBoxplotMeanMenu",[]]);b.push(["Boxplot Median","boxplotMedian2",false,false,false,"getBoxplotMedianMenu",[]]);return b};this.getViolinTrimMenu=function(){var a=[];a.push(["Trim","violinTrimmed","changeAttribute",["violinTrim",true]]);a.push(["Not Trim","violinUntrimmed","changeAttribute",["violinTrim",false]]);return a};this.getViolinScaleMenu=function(){var a=[];a.push(["Area",this.violinScale=="area"?"radioOn":"radioOff","changeAttribute",["violinScale","area"]]);a.push(["Count",this.violinScale=="count"?"radioOn":"radioOff","changeAttribute",["violinScale","count"]]);a.push(["Width",this.violinScale=="width"?"radioOn":"radioOff","changeAttribute",["violinScale","width"]]);return a};this.getViolinAttributesMenu=function(){var b=[];b.push(["Trim","violin2",false,false,false,"getViolinTrimMenu",[]]);b.push(["Scale","scale",false,false,false,"getViolinScaleMenu",[]]);b.push([this.showBoxplotIfViolin?"Hide Boxplot":"Show Boxplot",this.showBoxplotIfViolin?"eyeClosed":"eye2","toggleAttribute",["showBoxplotIfViolin"]]);b.push(["Boxplot ratio","thickness",false,false,false,"changeTextColorAttributeMenu",["-text-","boxplotWidthRatioIfViolin"]]);b.push([this.showViolinBoxplot?"Hide Violin":"Show Violin",this.showViolinBoxplot?"eyeClosed":"eye2","toggleAttribute",["showViolinBoxplot"]]);return b};this.getBoxplotMenu=function(){var a=[];a.push(["Data Points","showData",false,false,false,"getDataPointsMenu",[]]);a.push(["Attributes","boxplotMedian",false,false,false,"getBoxplotAttributesMenu",[]]);a.push(["Violin Attributes","violin",false,false,false,"getViolinAttributesMenu",[]]);a.push(["Connect Boxplot","connects","toggleAttribute",["boxplotConnect"]]);return a};this.getPlotAreaOneMenu=function(){var b=[];b.push(["Axis Algorithm","x",false,false,false,"getPlotAreaAxisAlgorithmMenu",[]]);b.push(["Error Bars","errorBars",false,false,false,"getPlotAreaErrorBarsMenu",[]]);b.push(["Border Color","colors",false,false,false,"changeTextColorAttributeMenu",["-color-","plotBoxColor"]]);b.push([this.plotBox?"Hide Border":"Show Border",this.plotBox?"eyeClosed":"eye2","toggleAttribute",["plotBox"]]);if(this.graphType.match(/Bar|Boxplot/)&&this.data.y.vars.length>1){b.push(["Variable Space","spacing",false,false,false,"getPlotAreaOneVariableSpaceMenu",[]])}b.push(["Sample Width","thickness",false,false,false,"getPlotAreaOneSampleWidthMenu",[]]);return b};this.getPlotAreaScatterMenu=function(){var b=[];b.push(["Axis Algorithm",this.graphType=="Scatter3D"||this.is3DPlot?"xyz":"xy",false,false,false,"getPlotAreaAxisAlgorithmMenu",[]]);b.push(["Error Bars","errorBars",false,false,false,"getPlotAreaErrorBarsMenu",[]]);b.push(["Border Color","colors",false,false,false,"changeTextColorAttributeMenu",["-color-","plotBoxColor"]]);b.push([this.plotBox?"Hide Border":"Show Border",this.plotBox?"eyeClosed":"eye2","toggleAttribute",["plotBox"]]);return b};this.getAxesTitleXMenu=function(){return[["Text","normal",false,false,false,"changeTextColorAttributeMenu",["-text-","xAxisTitle"]]]};this.getAxesTitleX2Menu=function(){return[["Text","normal",false,false,false,"changeTextColorAttributeMenu",["-text-","xAxis2Title"]]]};this.getAxesTitleYMenu=function(){return[["Text","normal",false,false,false,"changeTextColorAttributeMenu",["-text-","yAxisTitle"]]]};this.getAxesTitleZMenu=function(){return[["Text","normal",false,false,false,"changeTextColorAttributeMenu",["-text-","zAxisTitle"]]]};this.getAxesTitleMenu=function(){var a=[];if(this.graphType.match(/scatter/i)||this.is3DPlot){if(this.graphType=="Scatter3D"||this.is3DPlot){a.push(["X-Axis","axes3DTitleX",false,false,false,"getAxesTitleXMenu",[]]);a.push(["Y-Axis","axes3DTitleY",false,false,false,"getAxesTitleYMenu",[]]);a.push(["Z-Axis","axes3DTitleZ",false,false,false,"getAxesTitleZMenu",[]])}else{a.push(["X-Axis","axes2DTitleX",false,false,false,"getAxesTitleXMenu",[]]);a.push(["Y-Axis","axes3DTitleY",false,false,false,"getAxesTitleYMenu",[]])}}else{if(this.graphType.match(/BarLine|DotLine|AreaLine|StackedLine|StackedPercentLine/)){a.push(["First Axis","axes1DTitleFirst",false,false,false,"getAxesTitleXMenu",[]]);a.push(["Second Axis","axes1DTitleSecond",false,false,false,"getAxesTitleX2Menu",[]])}else{a.push(["Text","normal",false,false,false,"changeTextColorAttributeMenu",["-text-","xAxisTitle"]])}}a.push(["Color","colors",false,false,false,"changeTextColorAttributeMenu",["-color-","axisTitleColor"]]);a.push(["Font","font",false,false,false,"getFontStyleMenu",["axisTitle"]]);return a};this.getTitleMenu=function(){var a=[];a.push(["Color","colors",false,false,false,"changeTextColorAttributeMenu",["-color-","titleColor"]]);a.push(["Font","font",false,false,false,"getFontStyleMenu",["title"]]);a.push(["Text","normal",false,false,false,"changeTextColorAttributeMenu",["-text-","title"]]);return a};this.getSubtitleMenu=function(){var a=[];a.push(["Color","colors",false,false,false,"changeTextColorAttributeMenu",["-color-","subtitleColor"]]);a.push(["Font","font",false,false,false,"getFontStyleMenu",["subtitle"]]);a.push(["Text","normal",false,false,false,"changeTextColorAttributeMenu",["-text-","subtitle"]]);return a};this.getTitleSubtitleMenu=function(){var a=[];if(this.graphType.match(/scatter/i)||this.is3DPlot){a.push(["Title","mainScatterTitle",false,false,false,"getTitleMenu",[]]);a.push(["Subtitle","mainScatterSubtitle",false,false,false,"getSubtitleMenu",[]])}else{a.push(["Title",this.graphType=="Heatmap"?"mainHeatmapTitle":"main1DTitle",false,false,false,"getTitleMenu",[]]);a.push(["Subtitle",this.graphType=="Heatmap"?"mainHeatmapSubtitle":"main1DSubtitle",false,false,false,"getSubtitleMenu",[]])}return a};this.getLegendLocationMenu=function(){var a=[];a.push(["Inside Plot","toInside","changeAttribute",["legendInside",true]]);a.push(["Outside Plot","toOutside","changeAttribute",["legendInside",false]]);return a};this.getLegendPositionMenu=function(){var a=[];if(this.legendInside){a.push(["Top","top","changeAttribute",["legendPosition","top"]]);a.push(["Top Right","topRight","changeAttribute",["legendPosition","topRight"]]);a.push(["Right","right","changeAttribute",["legendPosition","right"]]);a.push(["Bottom Right","bottomRight","changeAttribute",["legendPosition","bottomRight"]]);a.push(["Bottom","bottom","changeAttribute",["legendPosition","bottom"]]);a.push(["Bottom Left","bottomLeft","changeAttribute",["legendPosition","bottomLeft"]]);a.push(["Left","left","changeAttribute",["legendPosition","left"]]);a.push(["Top Left","topLeft","changeAttribute",["legendPosition","topLeft"]])}else{a.push(["Top","top","changeAttribute",["legendPosition","top"]]);a.push(["Bottom","bottom","changeAttribute",["legendPosition","bottom"]]);a.push(["Right","right","changeAttribute",["legendPosition","right"]]);a.push(["Left","left","changeAttribute",["legendPosition","left"]])}return a};this.getLegendBorderMenu=function(){var a=[];a.push(["Color","colors",false,false,false,"changeTextColorAttributeMenu",["-color-","legendBoxColor"]]);a.push([this.legendBox?"Hide Border":"Show Border",this.legendBox?"eyeClosed":"eye2","toggleAttribute",["legendBox"]]);return a};this.getLegendMenu=function(){var a=[];a.push(["Border","square",false,false,false,"getLegendBorderMenu",[]]);a.push(["Background","background",false,false,false,"changeTextColorAttributeMenu",["-color-","legendBackgroundColor"]]);a.push(["Color","colors",false,false,false,"changeTextColorAttributeMenu",["-color-","legendColor"]]);a.push(["Font","font",false,false,false,"getFontStyleMenu",["legend"]]);if(this.graphType!="Network"){a.push(["Position",this.legendInside?"toLocation2":"toLocation3",false,false,false,"getLegendPositionMenu",[]]);a.push(["Location","toLocation",false,false,false,"getLegendLocationMenu",[]])}a.push(["Columns","hash",false,false,false,"changeTextColorAttributeMenu",["-text-","legendColumns"]]);if(this.graphType!="Network"){a.push(["Reset Positions","refresh","resetLegendPosition"])}a.push([this.showLegend?"Hide Legend":"Show Legend",this.showLegend?"eyeClosed":"eye2","toggleAttribute",["showLegend"]]);return a};this.getIndicatorPositionMenu=function(){var a=[];a.push(["Right","right","changeAttribute",["heatmapIndicatorPosition","right"]]);a.push(["Top Right","topRight","changeAttribute",["heatmapIndicatorPosition","topRight"]]);a.push(["Top","top","changeAttribute",["heatmapIndicatorPosition","top"]]);a.push(["Top Left","topLeft","changeAttribute",["heatmapIndicatorPosition","topLeft"]]);return a};this.getIndicatorMenu=function(){var a=[];a.push(["Position","toLocation2",false,false,false,"getIndicatorPositionMenu",[]]);a.push(["Height","heightness",false,false,false,"changeTextColorAttributeMenu",["-text-","heatmapIndicatorHeight"]]);a.push(["Width","thickness",false,false,false,"changeTextColorAttributeMenu",["-text-","heatmapIndicatorWidth"]]);a.push(["Histogram","indicatorHistogram","toggleAttribute",["heatmapIndicatorHistogram"]]);a.push([this.showHeatmapIndicator?"Hide Indicator":"Show Indicator",this.showHeatmapIndicator?"eyeClosed":"eye2","toggleAttribute",["showHeatmapIndicator"]]);return a};this.getDecorationsBorderMenu=function(){var a=[];a.push(["Color","colors",false,false,false,"changeTextColorAttributeMenu",["-color-","decorationsBoxColor"]]);a.push([this.decorationsBox?"Hide Border":"Show Border",this.decorationsBox?"eyeClosed":"eye2","toggleAttribute",["decorationsBox"]]);return a};this.getDecorationsPositionMenu=function(){var a=[];if(this.legendInside){a.push(["Top","top","changeAttribute",["decorationsPosition","top"]]);a.push(["Top Right","topRight","changeAttribute",["decorationsPosition","topRight"]]);a.push(["Right","right","changeAttribute",["decorationsPosition","right"]]);a.push(["Bottom Right","bottomRight","changeAttribute",["decorationsPosition","bottomRight"]]);a.push(["Bottom","bottom","changeAttribute",["decorationsPosition","bottom"]]);a.push(["Bottom Left","bottomLeft","changeAttribute",["decorationsPosition","bottomLeft"]]);a.push(["Left","left","changeAttribute",["decorationsPosition","left"]]);a.push(["Top Left","topLeft","changeAttribute",["decorationsPosition","topLeft"]])}else{a.push(["Bottom","bottom","changeAttribute",["decorationsPosition","bottom"]]);a.push(["Right","right","changeAttribute",["decorationsPosition","right"]])}return a};this.getDecorationsDataMenu=function(){return[[this.showDecorations?"Hide Decorations":"Show Decorations",this.showDecorations?"eyeClosed":"eye2","toggleAttribute",["showDecorations"]]]};this.getDecorationsLegendMenu=function(){return[[this.showDecorationsLegend?"Hide Decorations Legend":"Show Decorations Legend",this.showDecorationsLegend?"eyeClosed":"eye2","toggleAttribute",["showDecorationsLegend"]]]};this.getDecorationsConfidenceIntervalsMenu=function(){return[[this.showConfidenceIntervals?"Hide Confidence Intervals":"Show Confidence Intervals",this.showConfidenceIntervals?"eyeClosed":"eye2","toggleAttribute",["showConfidenceIntervals"]]]};this.getDecorationsMenu=function(){var b=this.decorations;var a=[];a.push(["Border","square",false,false,false,"getDecorationsBorderMenu",[]]);a.push(["Background","background",false,false,false,"changeTextColorAttributeMenu",["-color-","decorationsBackgroundColor"]]);a.push(["Color","colors",false,false,false,"changeTextColorAttributeMenu",["-color-","decorationsColor"]]);a.push(["Font","font",false,false,false,"getFontStyleMenu",["decoration"]]);a.push(["Position",this.legendInside?"toInside":"toLocation2",false,false,false,"getDecorationsPositionMenu",[]]);a.push(["Data and Legend","database",false,false,false,"getDecorationsDataMenu",[]]);a.push(["Legend","legendScatter",false,false,false,"getDecorationsLegendMenu",[]]);if(b.reg||b.kaplanMeier){a.push(["Confidence Intervals",b.reg?"confidence":"kaplanMeyerConfidence",false,false,false,"getDecorationsConfidenceIntervalsMenu",[]])}return a};this.getOverlaysMemebersMenu=function(g,b){var f=[];var e={};for(var a=0;a<this[b+"Overlays"].length;a++){e[this[b+"Overlays"][a]]=true}var d=this.sortObject(this.data[g]);for(var a=0;a<d.length;a++){f.push([d[a],e[d[a]]?"checked":"unchecked",b=="var"?"showVariableOverlays":"showSampleOverlays",[d[a]]])}return f};this.getOverlaysLegendMenu=function(g,b){var e=[];var f=this[b+"OverlayProperties"];var d=this.sortObject(this.data[g]);for(var a=0;a<d.length;a++){e.push([d[a],f[d[a]].showLegend?"eyeClosed":"eye2","modifyOverlaysProperties",[false,b+"OverlayProperties",d[a],"showLegend"]])}return e};this.getOverlaysPositionMemberMenu=function(a,b){var c=[];if(a=="var"){c.push(["Bottom","bottom","modifyOverlaysProperties",["bottom",a+"OverlayProperties",b,"position"]]);c.push(["Top","top","modifyOverlaysProperties",["top",a+"OverlayProperties",b,"position"]])}else{if(this.graphType=="Heatmap"||this.graphOrientation=="horizontal"){c.push(["Left","left","modifyOverlaysProperties",["left",a+"OverlayProperties",b,"position"]]);c.push(["Right","right","modifyOverlaysProperties",["right",a+"OverlayProperties",b,"position"]])}else{c.push(["Bottom","bottom","modifyOverlaysProperties",["bottom",a+"OverlayProperties",b,"position"]]);c.push(["Top","top","modifyOverlaysProperties",["top",a+"OverlayProperties",b,"position"]])}}return c};this.getOverlaysPositionMenu=function(f,b){var e=[];var d=this.sortObject(this.data[f]);for(var a=0;a<d.length;a++){e.push([d[a],"cog2",false,false,false,"getOverlaysPositionMemberMenu",[b,d[a]]])}return e};this.getOverlaysThicknessMenu=function(f,b){var e=[];var d=this.sortObject(this.data[f]);for(var a=0;a<d.length;a++){e.push([d[a],"cog2",false,false,false,"changeTextColorAttributeMenu",["-text-",[false,"modifyOverlaysProperties",[b+"OverlayProperties",d[a],"thickness"]]]])}return e};this.getOverlaysColorSchemesMenu=function(g,f){var e=[];var b=this.meta.data[g];var a=this.getColorSchemes();for(var d=0;d<a.length;d++){e.push([a[d],b[f].spectrum==a[d]?"radioOn":"radioOff","modifyColorProperties",[a[d],f,g]])}return e};this.getOverlaysColorMenu=function(g,d){var f=[];var a=this.meta.data[g];var e=this.sortObject(this.data[g]);for(var b=0;b<e.length;b++){if(this.isNumeric(this.data[g][e[b]])){if(this[d+"OverlayProperties"][e[b]]&&this[d+"OverlayProperties"][e[b]].type&&this[d+"OverlayProperties"][e[b]].type=="Heatmap"){f.push([e[b],"cog2",false,false,false,"getColorSpectrumMenu",[a[e[b]].colorBrew.spectrum,"modifyColorProperties",e[b],g]])}else{f.push([e[b],"cog2",false,false,false,"changeTextColorAttributeMenu",["-color-",[false,"modifyOverlaysProperties",[d+"OverlayProperties",e[b],"color"]]]])}}else{f.push([e[b],"cog2",false,false,false,"getOverlaysColorSchemesMenu",[g,e[b]]])}}return f};this.getOverlaysGraphTypeMenu=function(d,f){var e=[];var b=["Area","AreaLine","Bar","BarLine","Dotplot","DotLine","Heatmap","Line","Pie","Stacked","StackedLine","StackedPercent","StackedPercentLine","Treemap"];var a=["areaGraph","areaLineGraph","barGraph","barLineGraph","dotPlot","dotLineGraph","heatmapGraph","lineGraph","pieChart","stackedGraph","stackedLineGraph","stackedPercentage","stackedPercentageLine","treemapGraph"];for(var c=0;c<b.length;c++){e.push([b[c],a[c],"modifyOverlaysProperties",[b[c],d+"OverlayProperties",f,"type"]])}return e};this.getOverlaysGraphDefaultMenu=function(a,c){var b=[];b.push(["Default","heatmapGraph","modifyOverlaysProperties",["Heatmap",a+"OverlayProperties",c,"type"]]);b.push(["Text","text","modifyOverlaysProperties",["Text",a+"OverlayProperties",c,"type"]]);b.push(["Treemap","treemapGraph","modifyOverlaysProperties",["Treemap",a+"OverlayProperties",c,"type"]]);return b};this.getOverlaysGraphMenu=function(g,d){var f=[];var a=this.meta.data[g];var e=this.sortObject(this.data[g]);for(var b=0;b<e.length;b++){if(this.isNumeric(this.data[g][e[b]])){f.push([e[b],"cog2",false,false,false,"getOverlaysGraphTypeMenu",[d,e[b]]])}else{f.push([e[b],"cog2",false,false,false,"getOverlaysGraphDefaultMenu",[d,e[b]]])}}return f};this.getOverlaysPropertiesMenu=function(d,a){var b=[];if(a=="var"){b.push(["Position","topBottom",false,false,false,"getOverlaysPositionMenu",[d,a]])}else{if(this.graphType=="Heatmap"||this.graphOrientation=="vertical"){b.push(["Position","leftRight",false,false,false,"getOverlaysPositionMenu",[d,a]])}else{b.push(["Position","topBottom",false,false,false,"getOverlaysPositionMenu",[d,a]])}}b.push(["Thickness","thickness",false,false,false,"getOverlaysThicknessMenu",[d,a]]);b.push(["Color","colors",false,false,false,"getOverlaysColorMenu",[d,a]]);b.push(["Type","graphType",false,false,false,"getOverlaysGraphMenu",[d,a]]);b.push(["Legend",this.graphType=="Heatmap"?"legendHeatmap":"legend1D",false,false,false,"getOverlaysLegendMenu",[d,a]]);return b};this.getLegendOverlaysPositionMenu=function(){var a=[];a.push(["Top Right","topRight","changeAttribute",["overlaysLegendPosition","topRight"]]);a.push(["Right","right","changeAttribute",["overlaysLegendPosition","right"]]);a.push(["Bottom Left","bottomLeft","changeAttribute",["overlaysLegendPosition","bottomLeft"]]);a.push(["Bottom","bottom","changeAttribute",["overlaysLegendPosition","bottom"]]);return a};this.getLegendOverlaysMenu=function(a){var b="show"+a+"OverlaysLegend";return[[this[b]?"Hide Legend":"Show Legend",this[b]?"eyeClosed":"eye2","toggleAttribute",[b]]]};this.getOverlaysMenu=function(){var a=[];if(this.graphType=="Heatmap"&&this.data.z){a.push(["Variable Overlays","overlaysHeatmapVariables",false,false,false,"getOverlaysMemebersMenu",["z","var"]]);a.push(["Variable Overlays Properties","overlaysHeatmapVariablesProperties",false,false,false,"getOverlaysPropertiesMenu",["z","var"]]);a.push(["Variable Overlays Legend","legendHeatmap",false,false,false,"getLegendOverlaysMenu",["Var"]]);a.push(["-"])}if(this.data.x){a.push(["Sample Overlays",this.graphType=="Heatmap"?"overlaysHeatmapSamples":"overlays1D",false,false,false,"getOverlaysMemebersMenu",["x","smp"]]);a.push(["Sample Overlays Properties",this.graphType=="Heatmap"?"overlaysHeatmapSamplesProperties":"overlays1DProperties",false,false,false,"getOverlaysPropertiesMenu",["x","smp"]]);a.push(["Sample Overlays Legend",this.graphType=="Heatmap"?"legendHeatmap":"legend1D",false,false,false,"getLegendOverlaysMenu",["Smp"]]);a.push(["-"])}a.push(["Overlays Legend Position","toLocation2",false,false,false,"getLegendOverlaysPositionMenu",[]]);a.push(["-"]);a.push(["Label Color","colors",false,false,false,"changeTextColorAttributeMenu",["-color-","overlayFontColor"]]);a.push(["Label Font","font",false,false,false,"getFontStyleMenu",["overlay"]]);a.push(["Default Thickness","thickness",false,false,false,"changeTextColorAttributeMenu",["-text-","overlaysThickness"]]);if(this.data.x||this.data.z){a.push([this.showOverlays?"Hide Overlays":"Show Overlays",this.showOverlays?"eyeClosed":"eye2","toggleAttribute",["showOverlays"]])}a.push(["More","more","showConfiguratorCategory",["event","Overlays"]]);return a};this.getBinDataPercentileMenu=function(d){var b=[];for(var a=0;a<this.data.y.vars.length;a++){if(d){b.push([this.data.y.vars[a],"radioOff","binDataByPercentile",[a,true]])}else{b.push([this.data.y.vars[a],"radioOff","binDataByPercentile",[a]])}}return b};this.getBinDataQuantileMenu=function(d){var b=[];for(var a=0;a<this.data.y.vars.length;a++){if(d){b.push([this.data.y.vars[a],"radioOff","binDataByQuantile",[a,true]])}else{b.push([this.data.y.vars[a],"radioOff","binDataByQuantile",[a]])}}return b};this.getBinDataCustomBinMenu=function(b){var c=[];for(var a=2;a<9;a++){c.push([a+" bins","radioOff","binDataCustom",[b,a]])}return c};this.getBinDataCustomMenu=function(){var b=[];for(var a=0;a<this.data.y.vars.length;a++){b.push([this.data.y.vars[a],false,false,false,false,"getBinDataCustomBinMenu",[a]])}return b};this.getBinDataMenu=function(){var a=[];a.push(["By Percentile Discrete","percentage3",false,false,false,"getBinDataPercentileMenu",[]]);a.push(["By Percentile Continuous","percentage3",false,false,false,"getBinDataPercentileMenu",[true]]);a.push(["By Quantile Discrete","quantiles",false,false,false,"getBinDataQuantileMenu",[]]);a.push(["By Quantile Continuous","quantiles",false,false,false,"getBinDataQuantileMenu",[true]]);a.push(["Custom","custom",false,false,false,"getBinDataCustomMenu",[]]);return a};this.getGroupSamplesMenu=function(){if(this.data.x){var d=[];var b={};var a=this.sortObject(this.data.x);for(var c=0;c<this.groupingFactors.length;c++){b[this.groupingFactors[c]]=true}for(var c=0;c<a.length;c++){d.push([a[c],b[a[c]]?"checked":"unchecked","showSampleGroups",[a[c]]])}return d}else{return false}};this.getSmpLabelHighlightLevelMenu=function(){var c=[];var b={};var d=this.isGroupedData?this.data.w:this.data.y;for(var a=0;a<this.highlightSmp.length;a++){b[this.highlightSmp[a]]=true}for(var a=0;a<d.smps.length;a++){c.push([d.smps[a],b[d.smps[a]]?"checked":"unchecked","modifyObjectArray",[d.smps[a],false,"highlightSmp",true,true]])}return c};this.getSmpLabelHighlightMenu=function(){var a=[];a.push(["Samples","samples",false,false,false,"getSmpLabelHighlightLevelMenu",[]]);a.push(["Color","colors",false,false,false,"changeTextColorAttributeMenu",["-color-","smpHighlightColor"]]);return a};this.getSmpLabelMenu=function(){var a=[];a.push(["Color","colors",false,false,false,"changeTextColorAttributeMenu",["-color-","smpLabelFontColor"]]);a.push(["Font","font",false,false,false,"getFontStyleMenu",["smpLabel"]]);a.push(["Highlight",this.graphType=="Heatmap"?"sampleLabelsHeatmap":"sampleLabels1D",false,false,false,"getSmpLabelHighlightMenu",[]]);a.push(["Interval","hash",false,false,false,"changeTextColorAttributeMenu",["-text-","smpLabelInterval"]]);a.push(["Rotate","rotateClockwise",false,false,false,"changeTextColorAttributeMenu",["-text-","smpLabelRotate"]]);a.push([this.showSampleNames?"Hide Labels":"Show Labels",this.showSampleNames?"eyeClosed":"eye2","toggleAttribute",["showSampleNames"]]);return a};this.getVarLabelHighlightLevelMenu=function(){var d=[];var c={};var a=this.data.y.vars;for(var b=0;b<this.highlightVar.length;b++){c[this.highlightVar[b]]=true}for(var b=0;b<a.length;b++){d.push([a[b],c[a[b]]?"checked":"unchecked","modifyObjectArray",[a[b],false,"highlightVar",true,true]])}return d};this.getVarLabelHighlightMenu=function(){var a=[];a.push(["Variables","variables",false,false,false,"getVarLabelHighlightLevelMenu",[]]);a.push(["Color","colors",false,false,false,"changeTextColorAttributeMenu",["-color-","varHighlightColor"]]);return a};this.getVarLabelMenu=function(b){var a=[];a.push(["Color","colors",false,false,false,"changeTextColorAttributeMenu",["-color-","varLabelFontColor"]]);a.push(["Font","font",false,false,false,"getFontStyleMenu",["varLabel"]]);a.push(["Highlight","heatmapHighlightVariables",false,false,false,"getVarLabelHighlightMenu",[]]);a.push(["Interval","hash",false,false,false,"changeTextColorAttributeMenu",["-text-","varLabelInterval"]]);a.push(["Rotate","rotateClockwise",false,false,false,"changeTextColorAttributeMenu",["-text-","varLabelRotate"]]);a.push([this.showVariableNames?"Hide Labels":"Show Labels",this.showVariableNames?"eyeClosed":"eye2","toggleAttribute",["showVariableNames"]]);return a};this.getGraphPartMenu=function(c,b){var a=[];a.push(["Color","colors",false,false,false,"changeTextColorAttributeMenu",["-color-",c+(b?"FontColor":"Color")]]);a.push(["Font","font",false,false,false,"getFontStyleMenu",[c]]);a.push(["Text","normal",false,false,false,"changeTextColorAttributeMenu",["-text-",c]]);return a};this.getFontStyleMenu=function(c){var b=[];var a="ScaleFontFactor";b.push(["Bigger","increaseFontSize","setFontAttributeSize",[c+a,"increase"]]);b.push(["Smaller","decreaseFontSize","setFontAttributeSize",[c+a,"decrease"]]);b.push(["Normal","normal","setFontAttributeStyle",[c+"FontStyle","normal"]]);b.push(["Bold","bold","setFontAttributeStyle",[c+"FontStyle","bold"]]);b.push(["Italic","italic","setFontAttributeStyle",[c+"FontStyle","italic"]]);return b};this.getDataPointAttributesPropertySampleMenu=function(b){var d=[];var c=this.isGroupedData?this.data.w:this.data.y;for(var a=0;a<c.smps.length;a++){d.push([c.smps[a],this[b]==c.smps[a]?"radioOn":"radioOff","changeAttribute",[b,c.smps[a]]])}return d};this.getDataPointAttributesPropertyMenu=function(f){var g=[];if(f=="treemapBy"){var a={};var b=this.sortObject(this.data.x);for(var c=0;c<this.treemapBy.length;c++){a[this.treemapBy[c]]=true}for(var c=0;c<b.length;c++){g.push([b[c],a[b[c]]?"checked":"unchecked","showTreemapGroups",[b[c]]])}}else{if(this.graphType!="Line"&&this.graphType!="ParallelCoordinates"){var e=this.graphType.match(/scatter/i)||this.graphType=="Map"?this.sortObject(this.data.z):this.sortObject(this.data.x);for(var c=0;c<e.length;c++){g.push([e[c],e[c]==this[f]?"radioOn":"radioOff","changeAttribute",[f,e[c]]])}g.push(["-"])}var c="variable";if(f!="connectBy"){g.push(["Variable",c==this[f]?"radioOn":"radioOff","changeAttribute",[f,c]])}if(((!this.graphType.match(/scatter/i)&&!this.graphType=="Map")||this.graphType=="Dotplot")&&this.data.z){var d=this.sortObject(this.data.z);if(f!="connectBy"||this.graphType=="Dotplot"){g.push(["-"])}for(var c=0;c<d.length;c++){if(f!="connectBy"||this.graphType=="Dotplot"){g.push([d[c],d[c]==this[f]?"radioOn":"radioOff","changeAttribute",[f,d[c]]])}}}if(this.graphType=="Line"||this.graphType=="ParallelCoordinates"||this.graphType=="Map"){g.push(["-"]);g.push(["Sample","samples",false,false,false,"getDataPointAttributesPropertySampleMenu",[f]])}}return g};this.getDataPointAttributesMenu=function(){var a=[];if(this.graphType!="Heatmap"){a.push(["Color By","colors",false,false,false,"getDataPointAttributesPropertyMenu",["colorBy"]])}if(this.graphType.match(/scatter/i)||this.is3DPlot||this.graphType=="Dotplot"||this.graphType=="Tree"||(this.graphType=="Boxplot"&&this.showBoxplotOriginalData)){a.push(["Shape By","shapes",false,false,false,"getDataPointAttributesPropertyMenu",["shapeBy"]]);a.push(["Size By","sizes",false,false,false,"getDataPointAttributesPropertyMenu",["sizeBy"]])}if(!this.graphType.match(/parallelcoordinates|line/i)){a.push(["Pattern By","patterns",false,false,false,"getDataPointAttributesPropertyMenu",["patternBy"]])}if(this.graphType.match(/scatter/i)||this.is3DPlot||this.graphType=="Dotplot"||(this.graphType=="Boxplot"&&this.showBoxplotOriginalData)){a.push(["Connect By","connects",false,false,false,"getDataPointAttributesPropertyMenu",["connectBy"]])}if(this.graphType.match(/stacked/i)&&this.data.x&&this.isGroupedData){a.push(["Treemap By","treemapGraph",false,false,false,"getDataPointAttributesPropertyMenu",["treemapBy"]])}if(this.graphType.match(/scatter/i)){a.push(["Ellipse By","ellipsises",false,false,false,"getDataPointAttributesPropertyMenu",["ellipseBy"]])}return a};this.getDendrogramColorMenu=function(d){var e=[];if(d){var c=this.sortObject(this.data.z);for(var b=0;b<c.length;b++){e.push([c[b],this.colorVarDendrogramBy==c[b]?"radioOn":"radioOff","changeAttribute",["colorVarDendrogramBy",c[b]]])}}else{var a=this.sortObject(this.data.x);for(var b=0;b<a.length;b++){e.push([a[b],this.colorSmpDendrogramBy==a[b]?"radioOn":"radioOff","changeAttribute",["colorSmpDendrogramBy",a[b]]])}}return e};this.getDendrogramsMenu=function(){var a=[];if(this.graphType=="Tree"){a.push(["Radial Layout",this.treeCircular?"checked":"unchecked","toggleAttribute",["treeCircular"]]);a.push(["Inverted Tree",this.treeInverted?"checked":"unchecked","toggleAttribute",["treeInverted"]])}else{if(this.graphType=="Heatmap"){a.push(["Cluster Variable","cluster2","clusterVariables",[true]]);a.push(["K-Means Variable","cluster4","kmeansVariables",[true]]);if(this.varDendrogram){a.push(["Color Variable Cluster By","colors",false,false,false,"getDendrogramColorMenu",[true]]);if(this.showVarDendrogram){a.push(["Hide Dendrogram","eyeClosed","showHideDendrogram",["showVarDendrogram"]])}else{a.push(["Show Dendrogram","eye2","showHideDendrogram",["showVarDendrogram"]])}}a.push(["-"])}a.push(["Cluster Samples","cluster","clusterSamples",[true]]);a.push(["K-Means Samples","cluster3","kmeansSamples",[true]]);if(this.smpDendrogram){a.push(["Color Sample Cluster By","colors",false,false,false,"getDendrogramColorMenu",[]]);if(this.showSmpDendrogram){a.push(["Hide Dendrogram","eyeClosed","showHideDendrogram",["showSmpDendrogram"]])}else{a.push(["Show Dendrogram","eye2","showHideDendrogram",["showSmpDendrogram"]])}}a.push(["-"]);a.push(["More","more","showConfiguratorCategory",["event","Clustering"]])}return a};this.getGraphTypeMenu=function(){var a=[];a.push(["Area","areaGraph","changeAttribute",["graphType","Area"],"Shit + Alt + A"]);a.push(["Area Line","areaLineGraph","changeAttribute",["graphType","AreaLine"],"Shit + Alt + F"]);a.push(["Bar","barGraph","changeAttribute",["graphType","Bar"],"Shit + Alt + B"]);a.push(["Bar Line","barLineGraph","changeAttribute",["graphType","BarLine"],"Shit + Alt + C"]);a.push(["Boxplot","boxPlot","changeAttribute",["graphType","Boxplot"],"Shit + Alt + I"]);a.push(["Circular","circularGraph","changeAttribute",["graphType","Circular"]]);a.push(["Correlation","correlationGraph","changeAttribute",["graphType","Correlation"],"Shit + Alt + X"]);a.push(["Dot Line","dotLineGraph","changeAttribute",["graphType","DotLine"],"Shit + Alt + E"]);a.push(["Dotplot","dotPlot","changeAttribute",["graphType","Dotplot"],"Shit + Alt + D"]);a.push(["Heatmap","heatmapGraph","changeAttribute",["graphType","Heatmap"],"Shit + Alt + H"]);a.push(["Line","lineGraph","changeAttribute",["graphType","Line"],"Shit + Alt + L"]);a.push(["Pie Chart","pieChart","changeAttribute",["graphType","Pie"],"Shit + Alt + P"]);if(this.data.y.smps.length>1){a.push(["Scatter 2D","scatter2D","changeAttribute",["graphType","Scatter2D"],"Shit + Alt + 2"])}if(this.data.y.smps.length>2){a.push(["Scatter Bubble 2D","scatter2DBubble","changeAttribute",["graphType","ScatterBubble2D"],"Shit + Alt + 4"]);a.push(["Scatter 3D","scatter3D","changeAttribute",["graphType","Scatter3D"],"Shit + Alt + 3"])}a.push(["Stacked","stackedGraph","changeAttribute",["graphType","Stacked"],"Shit + Alt + S"]);a.push(["Stacked Line","stackedLineGraph","changeAttribute",["graphType","StackedLine"],"Shit + Alt + U"]);a.push(["Stacked Percent","stackedPercentage","changeAttribute",["graphType","StackedPercent"],"Shit + Alt + T"]);a.push(["Stacked Percent Line","stackedPercentageLine","changeAttribute",["graphType","StackedPercentLine"],"Shit + Alt + W"]);a.push(["Tag Cloud","wordCloud","changeAttribute",["graphType","TagCloud"]]);a.push(["Parallel Coordinates","lineGraph","changeAttribute",["graphType","ParallelCoordinates"]]);a.push(["Sankey","sankeyDiagram","changeAttribute",["graphType","Sankey"]]);a.push(["Tree","treeGraph","changeAttribute",["graphType","Tree"]]);a.push(["Treemap","treemapGraph","changeAttribute",["graphType","Treemap"]]);return a};this.getGraphOrientationMenu=function(){var a=[];a.push(["Horizontal","graphOrientationHorizontal","changeAttribute",["graphOrientation","horizontal"]]);a.push(["Vertical","graphOrientationVertical","changeAttribute",["graphOrientation","vertical"]]);return a};this.getMarginsMenu=function(){var a=[];a.push(["Global","margins",false,false,false,"changeTextColorAttributeMenu",["-text-","margin"]]);a.push(["-"]);a.push(["Bottom","marginBottom",false,false,false,"changeTextColorAttributeMenu",["-text-","marginBottom"]]);a.push(["Left","marginLeft",false,false,false,"changeTextColorAttributeMenu",["-text-","marginLeft"]]);a.push(["Top","marginTop",false,false,false,"changeTextColorAttributeMenu",["-text-","marginTop"]]);a.push(["Right","marginRight",false,false,false,"changeTextColorAttributeMenu",["-text-","marginRight"]]);return a};this.getShadesMenu=function(){var a=[];a.push(["Objects","shadow","toggleAttribute",["showShadow"]]);a.push(["Text","shadowText","toggleAttribute",["showTextShadow"]]);a.push(["Color","colors",false,false,false,"changeTextColorAttributeMenu",["-color-","shadowColor"]]);a.push(["More","more","showConfiguratorCategory",["event","Shadows"]]);return a};this.getCanvasBorderMenu=function(){var a=[];a.push(["Color","colors",false,false,false,"changeTextColorAttributeMenu",["-color-","canvasBoxColor"]]);a.push([this.canvasBox?"Hide Border":"Show Border",this.canvasBox?"eyeClosed":"eye2","toggleAttribute",["canvasBox"]]);return a};this.getGradientsOrientationMenu=function(){var a=[];a.push(["Horizontal","gradientHorizontalLeft","changeAttribute",["gradientOrientation","horizontal"]]);a.push(["Vertical","gradientVerticalTop","changeAttribute",["gradientOrientation","vertical"]]);return a};this.getGradientsTypeMenu=function(){var a=[];a.push(["Linear","gradientVerticalTop","changeAttribute",["gradientType","linear"]]);a.push(["Radial","gradientRadial","changeAttribute",["gradientType","radial"]]);return a};this.getGradientsMenu=function(){var a=[];a.push(["Gradient","gradientToggle","toggleAttribute",["gradient"]]);a.push(["Orientation","gradientOrientation",false,false,false,"getGradientsOrientationMenu",[]]);a.push(["Type","gradientType",false,false,false,"getGradientsTypeMenu",[]]);a.push(["-"]);a.push(["More","more","showConfiguratorCategory",["event","Gradients"]]);return a};this.getBackgroundTypeMenu=function(){var a=[];a.push(["Solid","background","changeAttribute",["backgroundType","solid","solid"]]);a.push(["Gradient","background3","changeAttribute",["backgroundType","gradient","gradient"]]);a.push(["Solid Window","background2","changeAttribute",["backgroundType","window","window"]]);a.push(["Solid Window on Gradient","background5","changeAttribute",["backgroundType","windowGradient","windowGradient"]]);a.push(["Gradient Window on Solid","background4","changeAttribute",["backgroundType","windowSolidGradient","windowSolidGradient"]]);return a};this.getBackgroundMenu=function(){var a=[];a.push(["Type","backgroundType",false,false,false,"getBackgroundTypeMenu",[]]);a.push(["-"]);a.push(["Background Color","background",false,false,false,"changeTextColorAttributeMenu",["-color-","background"]]);a.push(["Window Color","background2",false,false,false,"changeTextColorAttributeMenu",["-color-","backgroundWindow"]]);a.push(["Gradient Start Color","gradientVerticalTop",false,false,false,"changeTextColorAttributeMenu",["-color-","backgroundGradient1Color"]]);a.push(["Gradient End Color","gradientVerticalBottom",false,false,false,"changeTextColorAttributeMenu",["-color-","backgroundGradient2Color"]]);a.push(["-"]);a.push(["More","more","showConfiguratorCategory",["event","Background"]]);return a};this.getFontsSizeStyleMenu=function(){var a=[];a.push(["Bigger","increaseFontSize","setFontAttributeSize",["fontScaleFontFactor","increase"]]);a.push(["Smaller","decreaseFontSize","setFontAttributeSize",["fontScaleFontFactor","decrease"]]);a.push(["Normal","normal","setFontAttributeStyle",["fontStyle","normal"]]);a.push(["Bold","bold","setFontAttributeStyle",["fontStyle","bold"]]);a.push(["Italic","italic","setFontAttributeStyle",["fontStyle","italic"]]);return a};this.getFontsMenu=function(){var a=[];a.push(["Size and Style","font",false,false,false,"getFontsSizeStyleMenu",[]]);a.push(["-"]);a.push(["Architects Daughter",this.fontName=="Architects Daughter"?"radioOn":"radioOff","changeAttribute",["fontName","Architects Daughter","Architects Daughter"]]);a.push(["Arial",this.fontName=="Arial"?"radioOn":"radioOff","changeAttribute",["fontName","Arial","Arial"]]);a.push(["Courier",this.fontName=="Courier"?"radioOn":"radioOff","changeAttribute",["fontName","Courier","Courier"]]);a.push(["Indie Flower",this.fontName=="Indie Flower"?"radioOn":"radioOff","changeAttribute",["fontName","Indie Flower","Indie Flower"]]);a.push(["Roboto",this.fontName=="Roboto"?"radioOn":"radioOff","changeAttribute",["fontName","Roboto","Roboto"]]);a.push(["Ubuntu",this.fontName=="Ubuntu"?"radioOn":"radioOff","changeAttribute",["fontName","Ubuntu","Ubuntu"]]);a.push(["Verdana",this.fontName=="Verdana"?"radioOn":"radioOff","changeAttribute",["fontName","Verdana","Verdana"]]);a.push(["-"]);a.push(["More","more","showConfiguratorCategory",["event","Text"]]);return a};this.getLayoutVarMenu=function(){var d=[];var a={};for(var b=0;b<this.segregateVariablesBy.length;b++){a[this.segregateVariablesBy[b]]=true}if(this.data.z){var c=this.sortObject(this.data.z);for(var b=0;b<c.length;b++){d.push([c[b],a[c[b]]?"checked":"unchecked","showVariableSegregation",[c[b]]])}if(!this.graphType.match(/Scatter/)){d.push(["-"])}}if(!this.graphType.match(/Scatter/)){d.push(["variable",a.variable?"checked":"unchecked","showVariableSegregation",["variable"]])}return d};this.getLayoutSmpMenu=function(){var a=[];var d={};for(var c=0;c<this.segregateSamplesBy.length;c++){d[this.segregateSamplesBy[c]]=true}if(this.data.x){var b=this.sortObject(this.data.x);for(var c=0;c<b.length;c++){a.push([b[c],d[b[c]]?"checked":"unchecked","showSampleSegregation",[b[c]]])}if(!this.graphType.match(/Scatter/)){a.push(["-"])}}if(!this.graphType.match(/Scatter/)){a.push(["sample",d.sample?"checked":"unchecked","showSampleSegregation",["sample"]])}return a};this.getLayoutMenu=function(){var a=[];a.push(["Segregate Samples By","samples",false,false,false,"getLayoutSmpMenu",[]]);a.push(["Segregate Variables By","variables",false,false,false,"getLayoutVarMenu",[]]);return a};this.getSegregationMenu=function(){var d=[];var c={};var d=[];if(this.data.z&&!this.scatterPlotMatrix){var e=this.sortObject(this.data.z);for(var b=0;b<this.segregateVariablesBy.length;b++){c[this.segregateVariablesBy[b]]=true}for(var b=0;b<e.length;b++){d.push([e[b],c[e[b]]?"checked":"unchecked","showVariableSegregation",[e[b]]])}}if(this.data.x&&!this.scatterPlotMatrix){var a=this.sortObject(this.data.x);for(var b=0;b<this.segregateSamplesBy.length;b++){c[this.segregateSamplesBy[b]]=true}for(var b=0;b<a.length;b++){d.push([a[b],c[a[b]]?"checked":"unchecked","showSampleSegregation",[a[b]]])}}if(!this.graphType.match(/Scatter/)){d.push(["variable",c.variable?"checked":"unchecked","showVariableSegregation",["variable"]]);d.push(["sample",c.sample?"checked":"unchecked","showSampleSegregation",["sample"]])}if(!this.is3DPlot&&d.length>0){return d}else{return false}};this.getColorSpectrumMenu=function(b,g,m,l,k){var c=[];var a=this.getObjectArray(b);var f=this.getColorNames();for(var e=0;e<f.length;e++){if(a[f[e]]){var h=0;for(var d=0;d<b.length;d++){if(f[e]==b[d]){h=d;break}}if(m&&l){c.push([f[e]+" ("+(h+1)+")","checked",g,[f[e],m,l]])}else{c.push([f[e]+" ("+(h+1)+")","checked",g,[f[e]]])}}else{if(m&&l){c.push([f[e],"unchecked",g,[f[e],m,l]])}else{c.push([f[e],"unchecked",g,[f[e]]])}}}return c};this.getColorSpectrumSchemeMenu=function(e,f){var d=[];var a=this.getColorSchemes();for(var b=0;b<a.length;b++){d.push([a[b],this[e]==a[b]?"radioOn":"radioOff","changeAttribute",["colorSpectrum",[],false,f,a[b]]])}return d};this.getColorSchemeMenu=function(e,f){var d=[];var a=this.getColorSchemes();for(var b=0;b<a.length;b++){d.push([a[b],this[e]==a[b]?"radioOn":"radioOff","changeAttribute",[e,a[b],false,f]])}return d};this.getColorsSpectrumCompMenu=function(){var a=[];a.push(["Spectrum By Colors","colors",false,false,false,"getColorSpectrumMenu",[this.colorSpectrum,"changeColorSpectrum"]]);a.push(["Spectrum By Scheme","palette",false,false,false,"getColorSpectrumSchemeMenu",["colorScheme","changeColorSpectrumByScheme"]]);a.push(["Spectrum Color Number","hash",false,false,false,"changeTextColorAttributeMenu",["-text-","colorSpectrumTarget"]]);a.push(["Zero-Center","zscore",false,false,false,"changeTextColorAttributeMenu",["-text-",[false,"changeColorSpectrumZeroValue",[null]]]]);return a};this.getColorBlindTypeMenu=function(){var a=[];a.push(["No Blind Type",!this.blindnessType?"radioOn":"radioOff","changeAttribute",["blindnessType",false]]);a.push(["Protanopia",this.blindnessType=="protanopia"?"radioOn":"radioOff","changeAttribute",["blindnessType","protanopia"]]);a.push(["Deuteranopia",this.blindnessType=="deuteranopia"?"radioOn":"radioOff","changeAttribute",["blindnessType","deuteranopia"]]);a.push(["Tritanopia",this.blindnessType=="tritanopia"?"radioOn":"radioOff","changeAttribute",["blindnessType","tritanopia"]]);a.push(["Monochromatic",this.blindnessType=="monochromatic"?"radioOn":"radioOff","changeAttribute",["blindnessType","monochromatic"]]);return a};this.getColorsMenu=function(){var a=[];a.push(["Blind Type","eyeCrossed",false,false,false,"getColorBlindTypeMenu",[]]);a.push(["Scheme","palette",false,false,false,"getColorSchemeMenu",["colorScheme","changeColorScheme"]]);a.push(["Spectrum","theme",false,false,false,"getColorsSpectrumCompMenu",[]]);return a};this.getResizeMenu=function(){var a=[];a.push(["Height","height",false,false,false,"changeTextColorAttributeMenu",["-text-",["height","setHeight"]]]);a.push(["Width","width",false,false,false,"changeTextColorAttributeMenu",["-text-",["width","setWidth"]]]);return a};this.getThemeMenu=function(){var a=[];a.push(["CanvasXpress",this.theme=="cx"?"radioOn":"radioOff","changeTheme",["cx"]]);a.push(["Economist",this.theme=="economist"?"radioOn":"radioOff","changeTheme",["economist"]]);a.push(["GGPlot",this.theme=="ggplot"?"radioOn":"radioOff","changeTheme",["ggplot"]]);a.push(["Gray-Inverse",this.theme=="igray"?"radioOn":"radioOff","changeTheme",["igray"]]);a.push(["Excel",this.theme=="excel"?"radioOn":"radioOff","changeTheme",["excel"]]);a.push(["Paul Tol",this.theme=="paulTol"?"radioOn":"radioOff","changeTheme",["paulTol"]]);a.push(["Solarized",this.theme=="solarized"?"radioOn":"radioOff","changeTheme",["solarized"]]);a.push(["Stata",this.theme=="stata"?"radioOn":"radioOff","changeTheme",["stata"]]);a.push(["Tableau",this.theme=="tableau"?"radioOn":"radioOff","changeTheme",["tableau"]]);a.push(["Wall Street Journal",this.theme=="wallStreetJournal"?"radioOn":"radioOff","changeTheme",["wallStreetJournal"]]);a.push(["-"]);a.push(["None",this.theme=="none"?"radioOn":"radioOff","changeTheme",["none"]]);return a};this.getGeneralMenu=function(){var a=[];a.push(["Background","background",false,false,false,"getBackgroundMenu",[]]);a.push(["Border","square",false,false,false,"getCanvasBorderMenu",[]]);a.push(["Color","colors",false,false,false,"getColorsMenu",[]]);a.push(["Font","font",false,false,false,"getFontsMenu",[]]);a.push(["Gradients","gradientVerticalTop",false,false,false,"getGradientsMenu",[]]);if(!this.graphType.match(/Scatter/)&&!this.is3DPlot){a.push(["Graph Orientation","graphOrientation",false,false,false,"getGraphOrientationMenu",[]])}a.push(["Graph Type","graphType",false,false,false,"getGraphTypeMenu",[]]);if(!this.is3DPlot&&(this.data.x||this.data.z)){a.push(["Layout","segregate",false,false,false,"getLayoutMenu",[]])}a.push(["Margins","margins",false,false,false,"getMarginsMenu",[]]);a.push(["Shadows","shadow",false,false,false,"getShadesMenu",[]]);a.push(["Size","resize",false,false,false,"getResizeMenu",[]]);a.push(["Theme","theme",false,false,false,"getThemeMenu",[]]);a.push(["Transparency","transparency",false,false,false,"changeTextColorAttributeMenu",["-text-","transparency"]]);return a};this.getSwitchSmpToAnnotationMenu=function(){var b=[];for(var a=0;a<this.data.y.smps.length;a++){b.push([this.data.y.smps[a],"radioOff","switchSmpToAnnotation",[this.data.y.smps[a]]])}return b};this.getSwitchAnnotationToSmpMenu=function(){var c=[];var b=this.sortObject(this.data.z);for(var a=0;a<b.length;a++){if(this.meta.data.z[b[a]]){c.push([b[a],"radioOff","switchAnnotationToSmp",[b[a]]])}}return c};this.getSwitchSmpAnnotationToIdMenu=function(){var c=[];var a=this.sortObject(this.data.x);for(var b=0;b<a.length;b++){if(this.meta.data.x[a[b]].unique){c.push([a[b],"radioOff","switchSmpAnnotationToId",[a[b]]])}}return c};this.getSwitchVarToAnnotationMenu=function(){var a=[];for(var b=0;b<this.data.y.vars.length;b++){a.push([this.data.y.vars[b],"radioOff","switchVarToAnnotation",[this.data.y.vars[b]]])}return a};this.getSwitchAnnotationToVarMenu=function(){var b=[];var a=this.sortObject(this.data.x);for(var c=0;c<a.length;c++){if(this.meta.data.x[a[c]]){b.push([a[c],"radioOff","switchAnnotationToVar",[a[c]]])}}return b};this.getSwitchVarAnnotationToIdMenu=function(){var c=[];var b=this.sortObject(this.data.z);for(var a=0;a<b.length;a++){if(this.meta.data.z[b[a]].unique){c.push([b[a],"radioOff","switchVarAnnotationToId",[b[a]]])}}return c};this.getSwitchSamplesMenu=function(){var a=[];a.push(["Sample to Annotation","switchDown",false,false,false,"getSwitchSmpToAnnotationMenu",[]]);if(this.data.z){a.push(["Annotation to Sample","switchUp",false,false,false,"getSwitchAnnotationToSmpMenu",[]])}if(this.data.x&&this.isUniqueFactor("s")){a.push(["Annotation to Id","switch",false,false,false,"getSwitchSmpAnnotationToIdMenu",[]])}a.push(["Create New Sample Id","more","switchSmpIdToAnnotation",[]]);return a};this.getSwitchVariablesMenu=function(){var a=[];a.push(["Variable to Annotation","switchDown",false,false,false,"getSwitchVarToAnnotationMenu",[]]);if(this.data.x){a.push(["Annotation to Variable","switchUp",false,false,false,"getSwitchAnnotationToVarMenu",[]])}if(this.data.z&&this.isUniqueFactor("v")){a.push(["Annotation to Id","switch",false,false,false,"getSwitchVarAnnotationToIdMenu",[]])}a.push(["Create New Variable Id","more","switchVarIdToAnnotation",[]]);return a};this.getSwitchMenu=function(){var a=[];a.push(["Samples","samples",false,false,false,"getSwitchSamplesMenu",[]]);a.push(["Variables","variables",false,false,false,"getSwitchVariablesMenu",[]]);return a};this.getConvertNumericToStringMenu=function(f,b){var d=[];var e=this.sortObject(this.data[f]);for(var a=0;a<e.length;a++){if(this.meta.data[f][e[a]]&&this.meta.data[f][e[a]].type=="Numeric"){d.push([e[a],"radioOff","switchNumericToString",[e[a],b]])}}return d};this.getConvertStringToNumericMenu=function(f,b){var d=[];var e=this.sortObject(this.data[f]);for(var a=0;a<e.length;a++){if(this.meta.data[f][e[a]]&&this.meta.data[f][e[a]].type!="Numeric"){d.push([e[a],"radioOff","switchStringToNumeric",[e[a],b]])}}return d};this.getConvertVarSmpMenu=function(d,a){var b=[];if(this.isNumericFactor(a)){b.push(["Numeric to String","toString",false,false,false,"getConvertNumericToStringMenu",[d,a=="s"]])}if(this.isStringFactor(a)){b.push(["String to Numeric","toNumeric",false,false,false,"getConvertStringToNumericMenu",[d,a=="s"]])}return b};this.getConvertMenu=function(){var a=[];if(this.data.x){a.push(["Samples","samples",false,false,false,"getConvertVarSmpMenu",["x","s"]])}if(this.data.z){a.push(["Variables","variables",false,false,false,"getConvertVarSmpMenu",["z","v"]])}return a};this.getTransformPercentMenu=function(){var a=[];a.push(["By Sample","samples","transform",["percentile","samples"]]);a.push(["By Variable","variables","transform",["percentile","variables"]]);return a};this.getTransformZScoreMenu=function(){var a=[];a.push(["By Sample","samples","transform",["zscore","samples"]]);a.push(["By Variable","variables","transform",["zscore","variables"]]);return a};this.getTransformRatioMenu=function(){var a=[];a.push(["To Sample","samples",false,false,false,"getTransformRatioSmpMenu",[]]);if(this.data.x&&this.isGroupedData){a.push(["To Group","groups",false,false,false,"getTransformRatioGrpMenu",[]]);if(this.ratioGroupReference&&this.data.x.hasOwnProperty(this.ratioGroupReference)){a.push(["To Level","levels",false,false,false,"getTransformRatioLevMenu",[]])}}return a};this.getTransformRatioLevMenu=function(){var c=[];var a=this.sortObject(this.getObjectArray(this.data.x[this.ratioGroupReference]));for(var b=0;b<a.length;b++){if(a[b]!=null){c.push([a[b],this.ratioLevelReference==a[b]?"radioOn":"radioOff","changeTransformRatio",["level",a[b]]])}}return c};this.getTransformRatioGrpMenu=function(){var b=[];var a=this.sortObject(this.data.x);for(var c=0;c<a.length;c++){b.push([a[c],this.ratioGroupReference==a[c]?"radioOn":"radioOff","changeTransformRatio",["group",a[c]]])}return b};this.getTransformRatioSmpMenu=function(){var c=[];for(var a=0;a<this.data.y.smps.length;a++){var b=this.data.y.smps[a];c.push([b,this.ratioSampleReference==b?"radioOn":"radioOff","changeTransformRatio",["sample",b]])}return c};this.getTransformMenu=function(){var a=[];a.push(["Log Base 2","logarithm2","transform",["log2"]]);a.push(["Log Base 10","logarithm10","transform",["log10"]]);a.push(["Exp Base 2","exponent2","transform",["exp2"]]);a.push(["Exp Base 10","exponent10","transform",["exp10"]]);a.push(["Ceil data","ceil",false,false,false,"changeTextColorAttributeMenu",["-text-",[false,"modifyTransform",["tceil"]]]]);a.push(["Floor data","floor",false,false,false,"changeTextColorAttributeMenu",["-text-",[false,"modifyTransform",["tfloor"]]]]);a.push(["Percentile","percentage3",false,false,false,"getTransformPercentMenu",[]]);a.push(["Z-Score","zscore",false,false,false,"getTransformZScoreMenu",[]]);a.push(["Ratio","ratio",false,false,false,"getTransformRatioMenu",[]]);a.push(["-"]);a.push(["Reset","refresh","transform",["reset"]]);a.push(["-"]);a.push(["Overwrite data","disckette","transform",["save"]]);return a};this.getAxisTransformMenu=function(b){var c=[];b=b.toLowerCase();c.push(["Log Base 2","logarithm2","changeAttribute",[b+"AxisTransform","log2"]]);c.push(["Log Base 10","logarithm10","changeAttribute",[b+"AxisTransform","log10"]]);c.push(["Exp Base 2","exponent2","changeAttribute",[b+"AxisTransform","exp2"]]);c.push(["Exp Base 10","exponent10","changeAttribute",[b+"AxisTransform","exp10"]]);c.push(["Percentile","percentage3","changeAttribute",[b+"AxisTransform","exp10"]]);c.push(["-"]);c.push(["Reset","refresh","changeAttribute",[b+"AxisTransform",false]]);return c};this.getSortSmpIntensityMenu=function(){var c=[];var a={};if(this.sortingSamples){for(var b=0;b<this.sortingSamples.length;b++){a[this.sortingSamples[b]]=true}}for(var b=0;b<this.data.y.smps.length;b++){c.push([this.data.y.smps[b],a[b+1]?"radioOn":"radioOff","showSorting",["smp","var",this.data.y.smps[b]]])}return c};this.getSortVarIntensityMenu=function(){var c=[];var a={};if(this.sortingVariables){for(var b=0;b<this.sortingVariables.length;b++){a[this.sortingVariables[b]]=true}}for(var b=0;b<this.data.y.vars.length;b++){c.push([this.data.y.vars[b],a[b+1]?"radioOn":"radioOff","showSorting",["var","smp",this.data.y.vars[b]]])}return c};this.getSortSmpCatMenu=function(){var d=[];var b={};var a=this.sortObject(this.data.x);if(this.sortingSampleCategories){for(var c=0;c<this.sortingSampleCategories.length;c++){b[this.sortingSampleCategories[c]]=true}}for(var c=0;c<a.length;c++){d.push([a[c],b[a[c]]?"checked":"unchecked","showSorting",["cat","smp",a[c]]])}return d};this.getSortVarCatMenu=function(){var d=[];var a={};var c=this.sortObject(this.data.z);if(this.sortingVariableCategories){for(var b=0;b<this.sortingVariableCategories.length;b++){a[this.sortingVariableCategories[b]]=true}}for(var b=0;b<c.length;b++){d.push([c[b],a[c[b]]?"checked":"unchecked","showSorting",["cat","var",c[b]]])}return d};this.getSortSmpMenu=function(){var a=[];a.push(["By Variable Intensity","variables",false,false,false,"getSortVarIntensityMenu",[]]);if(this.data.x){a.push(["By Sample Category","Xu",false,false,false,"getSortSmpCatMenu",[]])}a.push(["By Name","samples","showSorting",["cat","smp","samples"]]);return a};this.getSortVarMenu=function(){var a=[];a.push(["By Sample Intensity","samples",false,false,false,"getSortSmpIntensityMenu",[]]);if(this.data.z){a.push(["By Variable Category","zscore",false,false,false,"getSortVarCatMenu",[]])}a.push(["By Name","variables","showSorting",["cat","var","variables"]]);return a};this.getSortMenu=function(){var a=[];if(this.sortDir=="ascending"){a.push(["Change Sorting","descending","changeAttribute",["sortDir","descending",true]])}else{a.push(["Change Sorting","ascending","changeAttribute",["sortDir","ascending",true]])}a.push(["Case Sensitive",this.sortCaseSensitive?"checked":"unchecked","toggleAttribute",["sortCaseSensitive"]]);a.push(["-"]);a.push(["Sort Samples","samples",false,false,false,"getSortSmpMenu",[]]);a.push(["Sort Variables","variables",false,false,false,"getSortVarMenu",[]]);return a};this.getSliderMenu=function(){var a=[];for(var b in this.binConfigurations){a.push([b,false,false,false,false,[["-slider-","changeBin",[b]]]])}return a};this.getPivotMenu=function(){var b=[];if(this.isPivotable()){if(this.data.y.vars.length==3){var c=this.data.y.vars;b.push([c[0]+" as Variables; "+c[1]+" as Samples","radioOff","pivotYY",[c[0],c[1]]]);b.push([c[0]+" as Variables; "+c[2]+" as Samples","radioOff","pivotYY",[c[0],c[2]]]);b.push([c[1]+" as Variables; "+c[0]+" as Samples","radioOff","pivotYY",[c[1],c[0]]]);b.push([c[1]+" as Variables; "+c[2]+" as Samples","radioOff","pivotYY",[c[1],c[2]]]);b.push([c[2]+" as Variables; "+c[0]+" as Samples","radioOff","pivotYY",[c[2],c[0]]]);b.push([c[2]+" as Variables; "+c[1]+" as Samples","radioOff","pivotYY",[c[2],c[1]]])}else{if(this.data.y.vars.length==2){var c=this.data.y.vars;var a=this.getKeys(this.data.x);b.push([a[0]+" as Variables; "+c[0]+" as Samples","radioOff","pivotXY",[a[0],c[0]]]);b.push([a[0]+" as Variables; "+c[1]+" as Samples","radioOff","pivotXY",[a[0],c[1]]]);b.push([c[0]+" as Variables; "+a[0]+" as Samples","radioOff","pivotXY",[c[0],a[0]]]);b.push([c[1]+" as Variables; "+a[0]+" as Samples","radioOff","pivotXY",[c[1],a[0]]])}else{var a=this.getKeys(this.data.x);b.push([a[0]+" as Variables; "+a[1]+" as Samples","radioOff","pivotXX",[a[0],a[1]]]);b.push([a[1]+" as Variables; "+a[0]+" as Samples","radioOff","pivotXX",[a[1],a[0]]])}}}return b};this.getRdatasetsMenu=function(){var a=[];if(this.Rdatasets){var c=this.sortObject(this.Rdatasets);c=c.sort(function(e,d){return e.toLowerCase()>d.toLowerCase()});for(var b=0;b<c.length;b++){a.push([c[b],"radioOff","getRLibraryDataSets",[c[b]]])}}return a};this.getRangeMenu=function(){var a=[];a.push(["Set Min","min",false,false,false,"changeTextColorAttributeMenu",["-text-","setMinX"]]);a.push(["Set Max","max",false,false,false,"changeTextColorAttributeMenu",["-text-","setMaxX"]]);a.push(["Exact Range","exact","toggleAttribute",["xAxisExact"]]);return a};this.getSummaryTypeMenu=function(){var c=[];var b=["mean","median","min","max","sum"];c.push(["Raw",!this.summaryType||this.summaryType=="raw"?"radioOn":"radioOff","modifySummaryType",["raw"]]);for(var a=0;a<b.length;a++){c.push([this.capitalize(b[a]),this.summaryType==b[a]?"radioOn":"radioOff","modifySummaryType",[b[a]]])}return c};this.getDataMenu=function(){var a=[];if(this.isBinConfigurations()){a.push(["Configure Bins","bold",false,false,false,"getSliderMenu",[]])}if(this.data.x||this.data.z){a.push(["Convert Annotations","convert",false,false,false,"getConvertMenu",[]])}if(this.graphType=="Heatmap"){a.push(["Range","range",false,false,false,"getRangeMenu",[]])}a.push(["Summary Type","summary",false,false,false,"getSummaryTypeMenu",[]]);a.push(["Switch Data","switch",false,false,false,"getSwitchMenu",[]]);if(!this.graphType.match(/Scatter/i)){a.push(["Sort","ascending",false,false,false,"getSortMenu",[]])}a.push(["Transform","function",false,false,false,"getTransformMenu",[]]);if(!this.layoutValid){a.push(["Transpose","transpose","transpose"])}if(this.isPivotable()){a.push(["Pivot","pivot",false,false,false,"getPivotMenu",[]])}if(!this.layoutValid){a.push(["Bin Data","histogram",false,false,false,"getBinDataMenu",[]])}return a};this.getLoessMenu=function(){var a=[];a.push([this.showLoessFit?"Hide Loess Fit":"Show Loess Fit",this.showLoessFit?"eyeClosed":"eye2","toggleAttribute",["showLoessFit"]]);return a};this.getHistogramDensityMenu=function(){var b=["epanechnikov","uniform","triangular","quartic","triweight","gaussian","cosine"];var a=[];for(var c=0;c<b.length;c++){a.push([b[c],b[c]==this.densityKernel?"radioOn":"radioOff","changeAttribute",["densityKernel",b[c],false,"modifyHistogram"]])}return a};this.getHistogramMedianLineStyleMenu=function(){var a=[];a.push(["Solid","lineTypeSolid","changeAttribute",["histogramMedianLineStyle","solid"]]);a.push(["Dotted","lineTypeDotted","changeAttribute",["histogramMedianLineStyle","dotted"]]);a.push(["Dashed","lineTypeDashed","changeAttribute",["histogramMedianLineStyle","dashed"]]);return a};this.getHistogramMenu=function(){var a=[];a.push(["Bin Number","hash",false,false,false,"changeTextColorAttributeMenu",["-text-",["histogramBins","modifyHistogram"]]]);a.push(["Density Kernel","fit",false,false,false,"getHistogramDensityMenu",[]]);a.push(["Remove Histogram","histogramCrossed","removeHistogram"]);a.push([this.hideHistogram?"Show Histogram Bars":"Hide Histogram Bars",this.hideHistogram?"eye2":"eyeClosed","toggleAttribute",["hideHistogram"]]);a.push(["Stagger Histograms","histogramStaggered","toggleAttribute",["histogramStagger","modifyHistogram"]]);a.push([this.showHistogramDensity?"Hide Density":"Show Density",this.showHistogramDensity?"eyeClosed":"eye2","toggleAttribute",["showHistogramDensity","modifyHistogram"]]);a.push([this.showFilledHistogramDensity?"Hide Filled Density":"Show Filled Density",this.showFilledHistogramDensity?"eyeClosed":"eye2","toggleAttribute",["showFilledHistogramDensity"]]);a.push(["Fill Transparency","transparency",false,false,false,"changeTextColorAttributeMenu",["-text-","histogramDensityFillTransparency"]]);a.push([this.showHistogramMedian?"Hide Median":"Show Median",this.showHistogramMedian?"eyeClosed":"eye2","toggleAttribute",["showHistogramMedian"]]);a.push(["Median Line Style","lineTypePattern",false,false,false,"getHistogramMedianLineStyleMenu",[]]);return a};this.getDOEMenu=function(){var d=[];var c=this.initialGraphType.match(/Scatter/)?this.getKeys(this.dataStndBy.z):this.getKeys(this.dataStndBy.x);var a=this.getObjectArray(this.includeDOE);for(var b=0;b<c.length;b++){d.push([c[b],a[c[b]]?"checked":"unchecked","modifyDOE",[c[b]]])}return d};this.getCorrelationCatMenu=function(f,d){var b=[];var e=this.sortObject(this.data[f]);for(var a=0;a<e.length;a++){if(this.isNumeric(this.data[f][e[a]])){b.push([e[a],"radioOff","correlateData",[d,e[a]]])}}return b};this.getCorrelationMenu=function(){var b=[];var a=[];if(this.data.y.vars.length>=3){b.push(["Samples","samples","correlateData"])}if(this.data.y.smps.length>=3&&this.data.x&&this.isNumericFactor("s")){b.push(["Sample Annotation","samples",false,false,false,"getCorrelationCatMenu",["x",true]])}if(this.data.y.smps.length>=3){b.push(["Variables","variables","correlateData",[true]])}if(this.data.y.vars.length>=3&&this.data.z&&this.isNumericFactor("v")){b.push(["Variable Annotation","variables",false,false,false,"getCorrelationCatMenu",["z",false]])}return b};this.getMagnificationMenu=function(){var a=[];for(var b=1;b<=10;b++){a.push([(96*b)+" DPI",this.printMagnification==b?"radioOn":"radioOff","changeAttributeNoDraw",["printMagnification",b]])}return a};this.getParametersMenu=function(){var a=[];a.push(["Load Parameters","loadFile",true,[]]);a.push(["Save as JSON","json2","save",[false,"cX-"+this.target+"-param",true]]);return a};this.getFileMenu=function(){var a=[];a.push(["Save as PNG","camera","print",[],"Ctrl + P"]);if(!this.graphType.match(/Venn|TagCloud|Map/)){a.push(["Save as SVG","svg","saveSVG",[]])}a.push(["Save as JSON","json2","save",[]]);a.push(["Print Magnification","zoomIn",false,false,false,"getMagnificationMenu",[]]);a.push(["-"]);a.push(["Reproducible Research","RRBW","clickRepResearch",[]]);a.push(["Show JSON code","json","clickShowCode",[]]);a.push(["Show R code","Rcode","clickShowRCode",[]]);if(!this.motionBy){a.push(["Reproduce","redo","reproduce",[false,true],"Ctrl + Alt + R"])}if(this.remoteService&&this.remoteServiceType=="webService"){a.push(["Save customizations to server","disckette","saveRemote",["afterRender"]]);a.push(["Clear parameters from server","discketteCrossed","clearRemote",[]])}a.push(["-"]);a.push(["Load","loadFile",true,[]]);if(this.Rdatasets){a.push(["R Datasets","RBW",false,false,false,"getRdatasetsMenu",[]])}a.push(["-"]);a.push(["Parameters","cog",false,false,false,"getParametersMenu",[]]);a.push(["-"]);a.push(["Reset","refresh","masterReset",[],"ESC"]);return a};this.getExploreMenu=function(){var a=[];a.push(["Filters","funnel","clickDataFilters",[]]);a.push(["Table","table","clickDataTable",[]]);a.push(["Configure","tools","clickDataExplorer",[]]);a.push(["-"]);a.push(["Search Parameters","magnifier","addConfiguratorCloseMenus"]);return a};this.getConfigurationMenu=function(){var e=this.decorations;var b={Bar:true,Line:true,Area:true,AreaLine:true,BarLine:true,Boxplot:true,Dotplot:true,DotLine:true,Heatmap:true,Treemap:true,TagCloud:true,ParallelCoordinates:true,Sankey:true,Stacked:true,StackedLine:true,StackedPercent:true,StackedPercentLine:true,Candlestick:true};var a=[];if(this.isMap||this.graphType=="Tree"){a.push(["Citation","citation1D",false,false,false,"getGraphPartMenu",["citation"]]);a.push(["Legend","legend",false,false,false,"getLegendMenu",[]]);a.push(["Title / Subtitle",this.graphType=="Heatmap"?"titleSubtitleH":"titleSubtitle",false,false,false,"getTitleSubtitleMenu",[]])}else{if(b[this.graphType]&&!this.is3DPlot){if(this.graphType!="Heatmap"){a.push(["Axes","axes1DProperties",false,false,false,"getAxesMenu",[]]);a.push(["Axes Titles","axes1DTitle",false,false,false,"getAxesTitleMenu",[]])}a.push(["Citation",this.graphType=="Heatmap"?"citationHeatmap":"citation1D",false,false,false,"getGraphPartMenu",["citation"]]);a.push(["General",this.graphType=="Heatmap"?"generalHeatmap":"general1D",false,false,false,"getGeneralMenu",[]]);a.push(["Grid","grid1D",false,false,false,"getPlotAreaGridMenu",["x"]]);if(this.graphType!="Heatmap"){if(this.graphType.match(/Dot/)){a.push(["Dotplot","dotPlot",false,false,false,"getDataPointsMenu",[]])}else{if(this.graphType=="Boxplot"){a.push(["Boxplot","boxPlot",false,false,false,"getBoxplotMenu",[]])}}a.push(["Plot Area","plot1D",false,false,false,"getPlotAreaOneMenu",[]]);if(e){a.push(["Decorations",e.marker?"decorationsMarker2D":"decorationsLine1D",false,false,false,"getDecorationsMenu",[]])}a.push(["Legend","legend1D",false,false,false,"getLegendMenu",[]]);if(this.data.x){a.push(["Overlays","overlays1D",false,false,false,"getOverlaysMenu",[]])}}if(this.graphType=="Heatmap"){a.push(["Indicator","indicator",false,false,false,"getIndicatorMenu",[]]);a.push(["Heatmap","heatmapGraph",false,false,false,"getHeatmapMenu",[]]);if(this.data.x||this.data.z){a.push(["Overlays","overlaysHeatmapSamples",false,false,false,"getOverlaysMenu",[]])}}a.push(["Sample Labels",this.graphType=="Heatmap"?"sampleLabelsHeatmap":"sampleLabels1D",false,false,false,"getSmpLabelMenu",[]]);a.push(["Samples Title",this.graphType=="Heatmap"?"sampleTitleHeatmap":"sampleTitle1D",false,false,false,"getGraphPartMenu",["smpTitle",true]]);if(this.graphType=="Heatmap"){a.push(["Variable Labels","variableLabelsHeatmap",false,false,false,"getVarLabelMenu",[]]);a.push(["Variables Title","variableTitleHeatmap",false,false,false,"getGraphPartMenu",["varTitle",true]])}a.push(["Title / Subtitle",this.graphType=="Heatmap"?"mainHeatmapTitleSubtitle":"main1DTitleSubtitle",false,false,false,"getTitleSubtitleMenu",[]])}else{if(this.graphType.match(/scatter/i)||this.is3DPlot){if(this.graphType=="Scatter3D"||this.is3DPlot){a.push(["Axes","axes3DProperties",false,false,false,"getAxesMenu",[]]);a.push(["Axes Titles","axes3DTitle",false,false,false,"getAxesTitleMenu",[]]);a.push(["Citation","citationScatter",false,false,false,"getGraphPartMenu",["citation"]]);a.push(["General","general3D",false,false,false,"getGeneralMenu",[]])}else{a.push(["Axes","axes2DProperties",false,false,false,"getAxesMenu",[]]);a.push(["Axes Titles","axes2DTitle",false,false,false,"getAxesTitleMenu",[]]);a.push(["Citation","citationScatter",false,false,false,"getGraphPartMenu",["citation"]]);a.push(["General","general2D",false,false,false,"getGeneralMenu",[]])}a.push(["Grid","gridScatter",false,false,false,"getPlotAreaScatterGridMenu",[]]);a.push(["Plot Area","plotScatter",false,false,false,"getPlotAreaScatterMenu",[]]);if(e){var c=e.nlfit?"nonlinearFit":e.line?"decorationsLine2D2":e.lines?"decorationsLine2D":e.reg?"correlation":e.nor?"fit3":e.area?"fit2":e.kaplanMeier?"kaplanMeyer":e.marker?"decorationsMarker2D":false;a.push(["Decorations",c,false,false,false,"getDecorationsMenu",[]])}a.push(["Legend","legendScatter",false,false,false,"getLegendMenu",[]]);a.push(["Title / Subtitle","mainScatterTitleSubtitle",false,false,false,"getTitleSubtitleMenu",[]]);if(this.isSelectDataPoints){a.push(["Show hidden data points","eye","showHideSelectedDataPoint",[false,45],"Ctrl + Insert"]);a.push(["Hide data points","eyeCrossed","showHideSelectedDataPoint",[false,46],"Ctrl + Delete"])}}}}return a};this.getAlignNetworkMenu=function(){var a=[];a.push(["Top","alignTop","alignDistributeSelectedNodes",[false,84]]);a.push(["Right","alignRight","alignDistributeSelectedNodes",[false,82]]);a.push(["Bottom","alignBottom","alignDistributeSelectedNodes",[false,66]]);a.push(["Left","alignLeft","alignDistributeSelectedNodes",[false,76]]);return a};this.getDistributeNetworkMenu=function(){var a=[];a.push(["Vertically","distributeVertical","alignDistributeSelectedNodes",[false,86]]);a.push(["Horozontally","distributeHorizontal","alignDistributeSelectedNodes",[false,72]]);return a};this.getRotateNetworkMenu=function(){var a=[];a.push(["Clockwise","rotateClockwise","arrowMove",[34]]);a.push(["Clockwise - Animate","rotateClockwise2","arrowMove",[39,true]]);a.push(["Anticlockwise","rotateAnticlockwise","arrowMove",[33]]);a.push(["Anticlockwise - Animate","rotateAnticlockwise2","arrowMove",[37,true]]);return a};this.getOrderNetworkMenu=function(){var a=[];a.push(["Send to back","moveBack","orderNodes",["sendNodeToBack"]]);a.push(["Send backward","moveBackwards","orderNodes",["sendNodeBackward"]]);a.push(["Bring to front","moveFront","orderNodes",["bringNodeToFront"]]);a.push(["Bring forward","moveForwards","orderNodes",["bringNodeForward"]]);return a};this.getNetworkDecorationsPositionMenu=function(){var a=[];a.push(["Center","center","changeAttribute",["decorationsPosition","center"]]);a.push(["Top","top","changeAttribute",["decorationsPosition","top"]]);a.push(["Right","right","changeAttribute",["decorationsPosition","right"]]);a.push(["Bottom","bottom","changeAttribute",["decorationsPosition","bottom"]]);a.push(["Left","left","changeAttribute",["decorationsPosition","left"]]);return a};this.getNetworkDecorationAttributesMenu=function(){var d=[];var c=[];var a=this.sortObject(this.meta.data.nodes);var f={x:true,y:true,z:true,width:true,height:true,community:true,decorationsXi:true,decorationsYi:true};for(var e=0;e<a.length;e++){if(this.meta.data.nodes[a[e]].type=="Numeric"&&!f[a[e]]){c.push(a[e])}}var b={};for(var e=0;e<this.decorations.length;e++){b[this.decorations[e]]=true}for(var e=0;e<c.length;e++){d.push([c[e],b[c[e]]?"checked":"unchecked","showNetworkDecorations",[c[e]]])}return d};this.getNetworkDecorationsTypeMenu=function(){var a=[];a.push(["Bar","barGraph","changeAttribute",["decorationsType","bar"]]);a.push(["Heatmap","heatmapGraph","changeAttribute",["decorationsType","heatmap"]]);a.push(["Pie Chart","pieChart","changeAttribute",["decorationsType","pie"]]);a.push(["Stacked","stackedGraph","changeAttribute",["decorationsType","stacked"]]);return a};this.getNetworkDecorationsMenu=function(){var a=[];a.push(["Attributes","Au",false,false,false,"getNetworkDecorationAttributesMenu",[]]);a.push(["Height","heightness",false,false,false,"changeTextColorAttributeMenu",["-text-","decorationsHeight"]]);a.push(["Width","thickness",false,false,false,"changeTextColorAttributeMenu",["-text-","decorationsWidth"]]);a.push(["Position","toLocation3",false,false,false,"getNetworkDecorationsPositionMenu",[]]);a.push(["Type","graphType",false,false,false,"getNetworkDecorationsTypeMenu",[]]);a.push([this.showDecorations?"Hide Decorations":"Show Decorations",this.showDecorations?"eyeClosed":"eye2","toggleAttribute",["showDecorations"]]);return a};this.getNetworkNodeEdgeAttributesMenu=function(){var a=[];a.push(["Nodes","nodes",false,false,false,"getNetworkNodeAttributesMenu",[]]);a.push(["Edges","edges",false,false,false,"getNetworkEdgeAttributesMenu",[]]);return a};this.getNetworkNodeAttributesPropertyMenu=function(b){var d=[];var c=this.sortObject(this.meta.data.nodes);for(var a=0;a<c.length;a++){d.push([c[a],this[b]==c[a]?"radioOn":"radioOff","changeAttribute",[b,c[a]]])}return d};this.getNetworkNodeAttributesMenu=function(){var a=[];a.push(["Color By","colors",false,false,false,"getNetworkNodeAttributesPropertyMenu",["colorNodeBy"]]);a.push(["Shape By","shapes",false,false,false,"getNetworkNodeAttributesPropertyMenu",["shapeNodeBy"]]);a.push(["Size By","sizes",false,false,false,"getNetworkNodeAttributesPropertyMenu",["sizeNodeBy"]]);a.push(["Pattern By","patterns",false,false,false,"getNetworkNodeAttributesPropertyMenu",["patternNodeBy"]]);return a};this.getNetworkEdgeAttributesPropertyMenu=function(b){var d=[];var c=this.sortObject(this.meta.data.edges);for(var a=0;a<c.length;a++){d.push([c[a],this[b]==c[a]?"radioOn":"radioOff","changeAttribute",[b,c[a]]])}return d};this.getNetworkEdgeAttributesMenu=function(){var a=[];a.push(["Color By","colors",false,false,false,"getNetworkEdgeAttributesPropertyMenu",["colorEdgeBy"]]);a.push(["Size By","thickness2",false,false,false,"getNetworkEdgeAttributesPropertyMenu",["sizeEdgeBy"]]);return a};this.setMenu=function(){var a={Bar:true,Line:true,Area:true,AreaLine:true,BarLine:true,Boxplot:true,Dotplot:true,DotLine:true,Heatmap:true,Treemap:true,TagCloud:true,ParallelCoordinates:true,Stacked:true,StackedLine:true,StackedPercent:true,StackedPercentLine:true,Candlestick:true};this.menu=[];this.menu.push(["File","folder",false,false,false,"getFileMenu",[]]);this.menu.push(["-"]);if(this.graphType!="Map"){this.menu.push(["Explore","magnifier",false,false,false,"getExploreMenu",[]]);this.menu.push(["-"])}if(this.graphType=="Network"){this.menu.push(["Legend","legend",false,false,false,"getLegendMenu",[]]);this.menu.push(["-"]);this.menu.push(["Data Point Attributes","colorShapeSize",false,false,false,"getNetworkNodeEdgeAttributesMenu",[]]);this.menu.push(["-"]);this.menu.push(["Decorations","tools",false,false,false,"getNetworkDecorationsMenu",[]]);this.menu.push(["Color","colors",false,false,false,"getColorsMenu",[]]);this.menu.push(["-"]);this.menu.push([this.showNetworkCommunities?"Hide Communities":"Show Communities",this.showNetworkCommunities?"eyeClosed":"eye2","toggleAttribute",["showNetworkCommunities"]]);if(this.showNetworkCommunities&&!this.colorNodeBy){this.menu.push(["Coordinate Convex Hull Color","communitiesOn","toggleAttribute",["coordinateNetworkConvexHullCommunityColor"]])}this.menu.push(["-"]);if(this.isSelectNodes){this.menu.push(["Align","alignBottom",false,false,false,"getAlignNetworkMenu",[]]);this.menu.push(["Distribute","distributeVertical",false,false,false,"getDistributeNetworkMenu",[]]);this.menu.push(["Rotate","rotateAnticlockwise",false,false,false,"getRotateNetworkMenu",[]]);this.menu.push(["Order","order",false,false,false,"getOrderNetworkMenu",[]]);this.menu.push(["-"]);this.menu.push(["Show conections","network","showHideSelectedDataPoint",[false,36],"Ctrl + Home"]);this.menu.push(["-"]);this.menu.push(["Show hidden nodes","eye","showHideSelectedDataPoint",[false,45],"Ctrl + Insert"]);this.menu.push(["Hide nodes","eyeCrossed","showHideSelectedDataPoint",[false,46],"Ctrl + Delete"]);this.menu.push(["-"]);this.menu.push(["Undo","undo","undo",[],"Ctrl + z"]);this.menu.push(["Redo","redo","redo",[],"Ctrl + y"]);this.menu.push(["-"]);this.menu.push(["Recalculate Layout","network2","recalculateLayoutSelectedNodes"])}else{if(this.isHiddenNodes){this.menu.push(["Show hidden nodes","showSelected","hideUnhideNodes",[],"Ctrl + Insert"]);this.menu.push(["-"])}this.menu.push(["Rotate","rotateAnticlockwise",false,false,false,"getRotateNetworkMenu",[]]);this.menu.push(["-"]);this.menu.push(["Redraw","refresh","recalculateLayout"])}}if(this.graphType=="Map"){this.menu.push(["Customize","cog",false,false,false,"getConfigurationMenu",[]]);this.menu.push(["-"]);if(this.data.z){this.menu.push(["Color By","colors",false,false,false,"getDataPointAttributesPropertyMenu",["colorBy"]])}}else{if(this.graphType=="Tree"){this.menu.push(["Customize","cog",false,false,false,"getConfigurationMenu",[]]);this.menu.push(["-"]);if(this.data.x){this.menu.push(["Data Point Attributes","colorShapeSize",false,false,false,"getDataPointAttributesMenu",[]]);this.menu.push(["-"])}this.menu.push(["Layout","cluster",false,false,false,"getDendrogramsMenu",[]])}else{if(this.graphType=="Circular"){this.menu.push(["Cluster","cluster",false,false,false,"getDendrogramsMenu",[]]);this.menu.push(["-"])}}}if(this.isDOE){this.menu.push(["Modify Meta-Data Plots","doe",false,false,false,"getDOEMenu",[]]);this.menu.push(["Remove Meta-Data Plots","doeCrossed","removeDOE"]);this.menu.push(["-"])}else{if(a[this.graphType]&&!this.is3DPlot){this.menu.push(["Customize","cog",false,false,false,"getConfigurationMenu",[]]);this.menu.push(["-"]);this.menu.push(["Data","data",false,false,false,"getDataMenu",[]]);this.menu.push(["-"]);if(this.data.x||this.graphType=="ParallelCoordinates"||this.graphType=="Line"){this.menu.push(["Data Point Attributes","colorShapeSize",false,false,false,"getDataPointAttributesMenu",[]]);this.menu.push(["-"])}if((this.data.x||this.data.z)&&this.isRawData){if(this.data.x){this.menu.push(["Group Samples","group",false,false,false,"getGroupSamplesMenu",[]])}if(this.data.x||this.data.z){this.menu.push(["Segregate Data","segregate",false,false,false,"getSegregationMenu",[]])}this.menu.push(["-"])}if(!this.layoutValid&&this.isRawData){this.menu.push(["Cluster","cluster",false,false,false,"getDendrogramsMenu",[]]);this.menu.push(["-"]);if(this.isHistogram){this.menu.push(["Histogram","histogram",false,false,false,"getHistogramMenu",[]])}else{if(!this.isCorrelate){this.menu.push(["Correlate","correlation",false,false,false,"getCorrelationMenu",[]]);if(this.data.x){this.menu.push(["Explore Meta-Data","doe","createDOE"])}this.menu.push(["Histogram","histogram","createHistogram"])}}}}else{if(this.graphType=="Circular"){this.menu.push(["Data","data",false,false,false,"getDataMenu",[]]);this.menu.push(["-"]);if(this.data.x||this.data.z){if(this.data.x||this.data.z){this.menu.push(["Segregate Data","segregate",false,false,false,"getSegregationMenu",[]])}this.menu.push(["-"])}}else{if(this.graphType.match(/scatter/i)||this.is3DPlot){this.menu.push(["Customize","cog",false,false,false,"getConfigurationMenu",[]]);this.menu.push(["-"]);this.menu.push(["Data","data",false,false,false,"getDataMenu",[]]);this.menu.push(["-"]);if(this.graphType=="Scatter2D"){if(this.isHistogram){this.menu.push(["Histogram","histogram",false,false,false,"getHistogramMenu",[]])}else{if(this.isCorrelate){this.menu.push(["Remove Correlation","correlationCrossed","removeCorrelation"])}else{if(this.decorations&&this.decorations.reg){this.menu.push(["Remove Correlation","correlationCrossed","removeCorrelation"])}else{this.menu.push(["Loess","nonLinearFit",false,false,false,"getLoessMenu",[]]);this.menu.push(["Correlate","correlation","correlateData"])}if(this.data.z&&!this.scatterPlotMatrix){this.menu.push(["Explore Meta-Data","doe","createDOE"])}if(!this.scatterPlotMatrix){this.menu.push(["Create Histogram","histogram","createHistogram"])}}}}else{if(this.graphType=="Scatter3D"){this.menu.push(["Loess","nonLinearFit",false,false,false,"getLoessMenu",[]])}}if(this.data.z){this.menu.push(["Data Point Attributes","colorShapeSize",false,false,false,"getDataPointAttributesMenu",[]])}if(this.data.z&&!this.scatterPlotMatrix){this.menu.push(["-"]);this.menu.push(["Segregate Data","segregate",false,false,false,"getSegregationMenu",[]])}}}}}return this.menu};this.resetMenus=function(){this.removeMenus()};this.initializeMenus=function(){if(this.showPrimaryMenus){var a=this.setMenu();for(var c=0;c<a.length;c++){var d=a[c];if(d[5]){this.addImageToToolbar(d[1],d[0],d[5],d[6],false,true)}}var b=this.$(this.target+"-cX-Toolbar-Custom");if(b){if(b.clientWidth>(this.width*0.8)){this.removeAllImagesFromToolbar()}}}};this.setFunctionNames("initMenus");this.initializeMenus()};CanvasXpress.prototype.initLinks=function(){this.addLinkDiv=function(){if(this.$(this.target+"-cX-Link")){this.resetLinkDiv();return}var b=this.$cX("div",{id:this.target+"-cX-Link",className:"CanvasXpressLink"},{zIndex:10002,display:"none"});var a=this.$cX("ul",{id:this.target+"-cX-Link-Content",className:"CanvasXpressList"});var c=this.$("north-wrapper-"+this.target);if(c){b.appendChild(a);c.appendChild(b)}};this.showLinkDiv=function(J,b,D){var K=this.$(this.target+"-cX-Link-Content");var k=this.$("west-container-"+this.target);var M=false;if(K){this.resetLinkDiv();var L=this.adjustedCoordinates(J);if(L){var h=L.x+k.offsetWidth;var f=L.y;for(var H=0;H<b.length;H++){var o=b[H].url;var C=b[H].name;var r=b[H].title;var E=b[H].icon;var v=b[H].source;var B=b[H].params;if(o){M=true}else{if(v&&this.data.links&&this.data.links[v]){o=this.data.links[v].url;M=true;if(B){for(var G in B){o=o.replace("$"+G+"$",B[G])}}}}var F=this.$cX("li",{className:"CanvasXpressListItem"});var c=r?r:this.data.links&&v&&this.data.links[v]&&this.data.links[v].title?this.data.links[v].title:"";var N=this.$cX("a",{className:"CanvasXpressListItemA",href:o,alt:c,title:c,target:"_blank"});var I=this.$cX("img",{className:"CanvasXpressListIcon",src:E?E:this.data.links&&v&&this.data.links[v]&&this.data.links[v].icon?this.data.links[v].icon:CanvasXpress.images.canvasXpress});var A=this.$cX("span",{className:"CanvasXpressListItemText",innerHTML:C?C:this.data.links&&v&&this.data.links[v]&&this.data.links[v].name?this.data.links[v].name:H});N.appendChild(I);N.appendChild(A);F.appendChild(N);this.addRemoveLinkListeners("addEvtListener",F);K.appendChild(F)}K.parentNode.style.left=h+"px";K.parentNode.style.top=f+"px";K.parentNode.style.display=M?"block":"none"}}};this.addRemoveLinkListeners=function(b,a){if(a){this.addRemoveEvtListener(b,a,"click",this.clickLink,false);this.addRemoveEvtListener(b,a,"mouseover",this.mouseoverLink,false);this.addRemoveEvtListener(b,a,"mouseout",this.mouseoutLink,false)}};this.clickLink=function(a){return function(b){if(!b){b=window.event}a.resetLinkDiv();return false}}(this);this.mouseoverLink=function(a){return function(c){if(!c){c=window.event}var b=a.getMenuItemComp(c);if(b){b[0].className="CanvasXpressListItemActive";b[1].className="CanvasXpressListItemAActive"}return false}}(this);this.mouseoutLink=function(a){return function(c){if(!c){c=window.event}var b=a.getMenuItemComp(c);if(b){b[0].className="CanvasXpressListItem";b[1].className="CanvasXpressListItemA"}return false}}(this);this.resetLinkDiv=function(){var a=this.$(this.target+"-cX-Link-Content");if(a&&a.childNodes){while(a.childNodes.length>0){this.addRemoveLinkListeners("removeEvtListener",a.childNodes[0]);a.removeChild(a.childNodes[0])}a.parentNode.style.display="none"}};this.resetLinks=function(){this.resetLinkDiv()};this.initializeLinks=function(){if(!this.disableEvents){this.addLinkDiv()}};this.setFunctionNames("initLinks");this.initializeLinks()};CanvasXpress.prototype.initTooltip=function(){this.addTooltipDiv=function(w,v,u,b,f){this.resetInfoSpan();var g=0;var k=this.target+"-cX-TooltipDiv"+g;var A=this.$(this.target+"-cX-Info");if(A&&A.style.display!="none"){v=parseInt(A.style.left);u=parseInt(A.style.top)}var l=this.$(k);while(l){g++;k=this.target+"-cX-TooltipDiv"+g;l=this.$(k)}var p=this.$cX("div",{id:k,className:"CanvasXpressTooltip draggable"},{left:v+"px",top:u+"px"});var r=this.$cX("img",{id:k+"Close",className:"CanvasXpressTooltip",src:CanvasXpress.images.cancel,alt:"Close",title:"Close"});var h=this.$cX("img",{id:k+"Marker",className:"CanvasXpressTooltip",src:CanvasXpress.images.pencil,obj:f,alt:"Add Marker",title:"Add Marker"});if(!b){b={}}b.clear="both";var a=1;if(b.hasOwnProperty("opacity")){a=b.opacity;delete (b.opacity)}p.style.opacity=a;var z=this.$cX("div",{id:k+"HTML",innerHTML:w||""},b);p.appendChild(r);if(f){p.appendChild(h)}p.appendChild(z);var j=this.$("center-wrapper-"+this.target);j.appendChild(p);return p};this.addRemoveTooltipDivsListeners=function(a,b){this.addRemoveEvtListener(a,b,"mousedown",this.registerMousemove,false);this.addRemoveEvtListener(a,b,"touchstart",this.registerMousemove,false);this.addRemoveEvtListener(a,b.childNodes[0],"click",this.closeTooltipDiv,false);if(b.childNodes[1]&&b.childNodes[0].tagName.toUpperCase()=="IMG"){this.addRemoveEvtListener(a,b.childNodes[1],"click",this.addMarkerTooltipDiv,false)}};this.closeTooltipDiv=function(a){return function(c){if(!c){c=window.event}var b=c.target||c.srcElement;if(b){var f=b.parentNode;a.addRemoveTooltipDivsListeners("removeEvtListener",f);a.collapseGenie(c,f,false,function(){f.parentNode.removeChild(f)})}return false}}(this);this.addMarkerTooltipDiv=function(a){return function(c){var b=c.target||c.srcElement;if(b){var g=b.parentNode;var f=b.obj;if(f){a.addMarkerConfigurator(c,f)}}return false}}(this);this.showTooltipDiv=function(f,j,b,a,i,h,c){var g;if(i&&h){g=this.addTooltipDiv(j,i,h,a,c);this.addRemoveTooltipDivsListeners("addEvtListener",g)}else{var l=this.$(this.target+"-cX-Info");var k=b?this.regularCoordinates(f,b):this.adjustedCoordinates(f,l);if(k){i=k.x;h=f?k.y:k.y+25;g=this.addTooltipDiv(j,i,h,a,c);this.addRemoveTooltipDivsListeners("addEvtListener",g)}}return g};this.resetTooltipDivs=function(){var c=0;var a=this.target+"-cX-TooltipDiv"+c;var b=this.$(a);while(b){this.addRemoveTooltipDivsListeners("removeEvtListener",b);b.parentNode.removeChild(b);c++;a=this.target+"-cX-TooltipDiv"+c;b=this.$(a)}};this.addInfoSpan=function(){if(this.$(this.target+"-cX-Info")){this.resetInfoSpan();return}var d=this.$("center-wrapper-"+this.target);var b=this.$cX("span",{id:this.target+"-cX-Info",className:"CanvasXpressTooltip"},{display:"none"});var a=this.$cX("div",{id:this.target+"-cX-Info-Left",className:"CanvasXpressTooltipArrowLeft"},{display:"none"});d.appendChild(b);d.appendChild(a)};this.resetInfoSpan=function(g,c){var b=this.$(this.target+"-cX-Info");var d=this.$(this.target+"-cX-Info-Left");if(b&&!this.noInfoSpanReset){var a=new Date().getTime()-this.infoStartTime;if(a>this.infoTimeIn||c){b.style.left="0px";b.style.top="0px";b.style.display="none";d.style.display="none";b.innerHTML=""}}};this.flashInfoSpan=function(l,k,o,d,a){var g=this;if(d){this.noInfoSpanReset=true}var q=new Date().getTime()-this.infoStartTime;var r=this.$(this.target+"-cX-Info");var j=this.$(this.target);var b=j.getClientRects();if(r){r.innerHTML=o;r.style.display="block";var n=parseInt(r.clientWidth);var f=parseInt(r.clientHeight);r.style.left=(l||0)+"px";r.style.top=(k||0)+"px";if(a){for(var e in a){r.style[e]=a[e]}}if(d){this.noInfoSpanReset=true;var m=function(){this.update=function(){var c=new Date().getTime();if(c-g.infoStartTime>d){g.noInfoSpanReset=false;g.resetInfoSpan();clearInterval(h)}};var h=g.setInterval(this.update,d)};m.call()}}};this.showInfoSpan=function(i,n,a){if(this.draggingOn||this.remoteUpdating||this.noInfoSpanReset){return}var p=new Date().getTime()-this.infoStartTime;var q=this.$(this.target+"-cX-Info");var g=this.$(this.target+"-cX-Info-Left");if(q&&n&&n!=""&&p>this.infoTimeIn){var o=a?this.regularCoordinates(i,a):this.adjustedCoordinates(i,q);if(o){var k=o.x;var j=i?o.y:o.y+25;if(CanvasXpress.system.isIE){k+=document.body.scrollLeft;j+=document.body.scrollTop}var f;var c;if(i&&i.type=="touchmove"){f=25;c=40}else{f=10;c=20}if(!isNaN(n)){n=n.toString()}if(n.match(/\w/)){q.innerHTML=n;q.style.left=(k+f)+"px";q.style.top=(j-c)+"px";q.style.display="inline";var b=(q.clientHeight/2)+1.5;g.style.left=(k+f+2.5)+"px";g.style.top=(j+b-c)+"px";if(this.isMap){q.style.zIndex=10000}var m=parseInt(q.clientWidth);var b=parseInt(q.clientHeight);if(m<window.innerWidth&&m>(window.innerWidth+window.pageXOffset)-k&&(m+c)<(k-window.pageXOffset)){q.style.left=(k-(m+c))+"px";q.style.left=(k-(parseInt(q.clientWidth)+c))+"px"}if(b<window.innerHeight&&b>(window.innerHeight+window.pageYOffset)-j&&(b-(f*1.5))<(j-window.pageYOffset)){q.style.top=(j-(b-(f*1.5)))+"px";q.style.top=(j-(parseInt(q.clientHeight)-(f*1.5)))+"px"}this.infoStartTime=new Date().getTime();var d=this;var l=function(){this.update=function(){var h=new Date().getTime();if(h-d.infoStartTime>d.infoTimeOut){d.resetInfoSpan();clearInterval(e)}};var e=d.setInterval(this.update,100)};l.call()}}}};this.addMarkerConfigurator=function(Q,H){var y=this.$("center-wrapper-"+this.target);if(y){var F=this.target+"-cX-Marker";if(this.$(F)){this.closeMarkerConfigurator(false,this.$(F))}var O=Q.target||Q.srcElement;var D=O.parentNode;var R=this.adjustedCoordinates(Q);var z=H.y?H.y.vars:H.w.vars;var C=H.y?H.y.smps:H.w.smps;var k=this.graphType.match(/Treemap|Stacked/)?true:false;var I={};var E=false;var A={id:this.newId(this.target+"-marker-"),vi:this.getVariableIndices(z),si:this.getSampleIndices(C,k),variable:z,sample:C,update:false};var L=false;var G=["text","color","fontSize","fontStyle","align","baseline","type","x","y"];for(var N=0;N<G.length;N++){I[G[N]]=""}I.align="center";I.baseline="middle";I.type="line";if(this.decorations&&this.decorations.marker){for(var N=0;N<this.decorations.marker.length;N++){var J=this.decorations.marker[N];if(this.isSameObject(J.variable,z)&&this.isSameObject(J.sample,C)){for(var M=0;M<G.length;M++){I[G[M]]=J[G[M]]}L=true;A.update=true}}}var B=this.$cX("div",{id:F,className:"CanvasXpressMarker draggable",par:D.id,obj:A},{left:R.x+"px",top:(R.y-this.height)+"px",display:"block",position:"relative"});var c=this.$cX("img",{id:F+"ConfiguratorMarkerClose",className:"CanvasXpressDataTableToolbarImage",src:CanvasXpress.images.cancel,alt:"Close",title:"Close"});var f=this.$cX("div",{id:F+"Container",className:"CanvasXpressDataTableContainer"},{left:"12px"});var d=this.$cX("table",{id:F+"MarkerTable",className:"CanvasXpressDataTable"});var a=this.$cX("tbody");for(var N=0;N<G.length;N++){var b=this.$cX("tr");var q=this.$cX("th",{className:"CanvasXpressTableCellHead"},{height:G[N]=="text"?"64px":"18px",width:"80px",backgroundRepeat:"repeat"});var l=this.$cX("div",{className:"CanvasXpressTableCell",innerHTML:this.capitalize(G[N])},{height:G[N]=="text"?"64px":"18px",width:"80px"});var u=this.$cX("td",{className:"CanvasXpressTableCell"},{height:G[N]=="text"?"64px":"18px",width:"160px",border:"1px solid #ccc"});var t=this.$cX("div",{className:"CanvasXpressTableCell"},{height:G[N]=="text"?"64px":"18px",width:"160px"});var h;if(G[N]=="text"){h=this.$cX("textarea",{id:F+"ConfiguratorMarker-"+G[N],className:"CanvasXpressMarker",name:G[N],value:I[G[N]],rows:3},{width:"100%",border:"none"})}else{if(G[N]=="color"){h=this.$cX("input",{id:F+"ConfiguratorMarker-"+G[N],className:"CanvasXpressMarker",type:"color",name:G[N],value:I[G[N]]?this.validateColor(I[G[N]],null,true):""},{width:"100%",border:"none"})}else{if(G[N]=="type"){h=this.$cX("select",{id:F+"ConfiguratorMarker-"+G[N],className:"CanvasXpressMarker",size:1},{width:"100%",border:"none",backgroundColor:"white"});var x=this.$cX("option",{text:"line",value:"line"});try{h.add(x,null)}catch(P){h.add(x)}var g=this.$cX("option",{text:"annotation",value:"annotation"});try{h.add(g,null)}catch(P){h.add(g)}if(I[G[N]]&&I[G[N]]!="line"){h.options[1].selected=true;E=true}}else{if(G[N]=="x"||G[N]=="y"){h=this.$cX("input",{id:F+"ConfiguratorMarker-"+G[N],className:"CanvasXpressMarker",type:"number",name:G[N],value:I[G[N]]?sprintf("%.2f",Number(I[G[N]])):0,min:0,max:1,step:0.01},{width:"100%",border:"none"});if(E){h.disabled=true}}else{if(G[N].match(/fontSize/)){h=this.$cX("input",{id:F+"ConfiguratorMarker-"+G[N],className:"CanvasXpressMarker",type:"number",name:G[N],value:I[G[N]]||12},{width:"100%",border:"none"})}else{h=this.$cX("input",{id:F+"ConfiguratorMarker-"+G[N],className:"CanvasXpressMarker",type:"text",name:G[N],value:I[G[N]]||""},{width:"100%",border:"none"})}}}}}var r=this.$cX("input",{id:F+"ConfiguratorMarkerRemove",value:"Remove",type:"button"},{cssFloat:"left",borderRadius:"5px",position:"relative",top:"308px",left:"12px",width:"125px",height:"24px"});var K=this.$cX("input",{id:F+"ConfiguratorMarkerAdd",value:L?"Update":"Add",type:"button"},{cssFloat:"left",borderRadius:"5px",position:"relative",top:"308px",left:"24px",width:"125px",height:"24px"});t.appendChild(h);u.appendChild(t);q.appendChild(l);b.appendChild(q);b.appendChild(u);a.appendChild(b)}d.appendChild(a);f.appendChild(d);B.appendChild(c);B.appendChild(f);B.appendChild(r);B.appendChild(K);y.appendChild(B);this.addRemoveMarkerConfiguratorListeners("addEvtListener")}};this.addRemoveMarkerConfiguratorListeners=function(e){var b=this.$(this.target+"-cX-Marker");var h=this.$(this.target+"-cX-MarkerConfiguratorMarkerClose");var g=this.$(this.target+"-cX-MarkerConfiguratorMarkerRemove");var d=this.$(this.target+"-cX-MarkerConfiguratorMarkerAdd");var f=this.$(this.target+"-cX-MarkerConfiguratorMarker-type");if(b&&h&&g&&d&&f){this[e](b,"mousedown",this.registerMousemove,false);this[e](h,"click",this.closeMarkerConfigurator,false);this[e](g,"click",this.removeMarker,false);this[e](d,"click",this.addMarker,false);this[e](f,"change",this.changeTypeMarker,false)}};this.closeMarkerConfigurator=function(a){return function(f,b){var c=f?(f.target||f.srcElement):false;var d=c?a.$(c.parentNode.par):b?a.$(b.par):false;if(d){a.addRemoveTooltipDivsListeners("removeEvtListener",d);d.parentNode.removeChild(d)}if(!b){b=c.parentNode}a.addRemoveMarkerConfiguratorListeners("removeEvtListener",b);b.parentNode.removeChild(b);return false}}(this);this.removeMarker=function(a){return function(c){var b=c.target||c.srcElement;a.modifyMarker(b.parentNode.obj,true);a.closeMarkerConfigurator(c);return false}}(this);this.addMarker=function(a){return function(c){var b=c.target||c.srcElement;a.modifyMarker(b.parentNode.obj);a.closeMarkerConfigurator(c);return false}}(this);this.changeTypeMarker=function(a){return function(d){var c=d.target||d.srcElement;var f=this.value;var b=c.parentNode.parentNode.parentNode.nextElementSibling;var g=b.nextElementSibling;b.childNodes[1].childNodes[0].childNodes[0].disabled=f=="line"?false:true;g.childNodes[1].childNodes[0].childNodes[0].disabled=f=="line"?false:true;return false}}(this);this.modifyMarker=function(e,a){var d=["text","color","fontSize","fontStyle","align","baseline","type","x","y"];for(var b=0;b<d.length;b++){var c=this.$(this.target+"-cX-MarkerConfiguratorMarker-"+d[b]);if(c){e[d[b]]=c.value}}this.updateMarker(e,a)};this.updateMarker=function(e,b){this.functionCaller="updateMarker";if(this.isTransition()){return}if(b){if(e.update){var d=[];for(var c=0;c<this.decorations.marker.length;c++){var a=this.decorations.marker[c];if(this.isSameObject(a.variable,e.variable)&&this.isSameObject(a.sample,e.sample)){continue}d.push(a)}this.decorations.marker=d}else{return false}}else{if(e.update){for(var c=0;c<this.decorations.marker.length;c++){var a=this.decorations.marker[c];if(this.isSameObject(a.variable,e.variable)&&this.isSameObject(a.sample,e.sample)){a.text=e.text;a.color=e.color;a.fontSize=Number(e.fontSize);if(e.fontStyle!=""){a.fontStyle=e.fontStyle}a.align=e.align;a.baseline=e.baseline;a.x=Number(e.x);a.y=Number(e.y);a.type=e.type;break}}}else{if(!this.decorations){this.decorations={}}if(!this.decorations.marker){this.decorations.marker=[]}this.decorations.marker.push({vi:e.vi,si:e.si,variable:e.variable,sample:e.sample,text:e.text,color:e.color,fontSize:Number(e.fontSize),fontStyle:e.fontStyle,align:e.align,baseline:e.baseline,x:Number(e.x),y:Number(e.y),type:e.type})}}this.draw()};this.initializeTooltip=function(){if(!this.disableEvents){this.addInfoSpan()}};this.setFunctionNames("initTooltip");this.initializeTooltip()};CanvasXpress.prototype.initToolbar=function(){this.addToolbarDiv=function(){if(this.$(this.target+"-cX-Toolbar")){return}var g=this.$cX("div",{id:this.target+"-cX-Toolbar",className:"CanvasXpressToolbar"},{position:"absolute",overflow:"hidden",width:this.width+"px",height:"0px",zIndex:1,backgroundColor:"rgba(255,255,255,0.85)"});var o=this.$cX("div",{id:this.target+"-cX-Toolbar-Custom",className:"CanvasXpressToolbar"},{cssFloat:"left"});var a=this.$cX("img",{id:this.target+"-cX-ToolbarSave",className:"CanvasXpressToolbarImage",src:CanvasXpress.images.camera,alt:"Save as png",title:"Save as png"});var i=this.$cX("img",{id:this.target+"-cX-ToolbarMove",className:"CanvasXpressToolbarImage",src:CanvasXpress.images.move,alt:"Move Canvas (Grab here)",title:"Move Canvas (Grab here)",draggable:false},{display:(this.movable?"none":"block"),cursor:"move"});var j=this.$cX("img",{id:this.target+"-cX-ToolbarLayout",className:"CanvasXpressToolbarImage",src:CanvasXpress.images.funnel,alt:"Explore data",title:"Explore data"},{display:(this.disableDataFilters||this.disableDataTable||this.disableConfigurator?"none":"block")});var f=this.$cX("img",{id:this.target+"-cX-ToolbarLasso",className:"CanvasXpressToolbarImage",src:CanvasXpress.images.lasso,alt:"Lasso Selection",title:"Lasso Selection"},{display:(this.graphType=="Scatter2D"?"block":"none")});var h=this.$cX("img",{id:this.target+"-cX-ToolbarDataExplorer",className:"CanvasXpressToolbarImage",src:CanvasXpress.images.tools,alt:"Configure",title:"Configure"},{display:(this.isMap?"none":"block")});var k=this.$cX("img",{id:this.target+"-cX-ToolbarInformation",className:"CanvasXpressToolbarImage",src:CanvasXpress.images.info,alt:"Data Details",title:"Data Details"},{display:(this.info?"block":"none")});var b=this.$cX("img",{id:this.target+"-cX-ToolbarMaxMin",className:"CanvasXpressToolbarImage",src:CanvasXpress.images.maximizeMinimize,alt:"Minimize / Maximize",title:"Minimize / Maximize"},{marginRight:"13px"});g.appendChild(this.beaconImage);g.appendChild(b);g.appendChild(k);g.appendChild(h);g.appendChild(f);g.appendChild(j);g.appendChild(i);g.appendChild(a);g.appendChild(o);var n=this.$("north-wrapper-"+this.target);if(n){n.appendChild(g);this.addRemoveToolbarListeners("addEvtListener")}};this.addRemoveToolbarListeners=function(c){this.addRemoveEvtListener(c,this.$(this.target+"-cX-ToolbarSave"),"click",this.print,false);this.addRemoveEvtListener(c,this.$(this.target+"-cX-ToolbarMove"),"mousedown",this.registerMousemove,false);this.addRemoveEvtListener(c,this.$(this.target+"-cX-ToolbarLayout"),"click",this.clickLayout,false);this.addRemoveEvtListener(c,this.$(this.target+"-cX-ToolbarLasso"),"click",this.clickLasso,false);this.addRemoveEvtListener(c,this.$(this.target+"-cX-ToolbarDataExplorer"),"click",this.clickDataExplorer,false);this.addRemoveEvtListener(c,this.$(this.target+"-cX-ToolbarInformation"),"click",this.clickDataDetails,false);this.addRemoveEvtListener(c,this.$(this.target+"-cX-ToolbarMaxMin"),"click",this.clickGraphMaxMin,false);var a=this.$(this.target+"-cX-Toolbar-Custom");if(c=="removeEvtListener"&&a){for(var b=0;b<a.childNodes.length;b++){this.addRemoveEvtListener(c,a.childNodes[b],"click",this.addCustomToolbarMenu,false);this.addRemoveEvtListener(c,a.childNodes[b],"contextmenu",this.unpinFromToolbar,false)}}};this.backgroundMask=function(a){var b=this.$("container-"+this.target);if(b){if(a){b.style.position="fixed";b.style.left=0;b.style.top=0;b.style.padding="2px";b.style.width=a[0]+"px";b.style.height=a[1]+"px";b.style.zIndex=1000000;b.style.backgroundColor="white"}else{b.style.position="relative";b.style.left="";b.style.top="";b.style.padding="";b.style.width="";b.style.height="";b.style.zIndex="";b.style.backgroundColor=""}}};this.clickLasso=function(a){return function(c,b){if(!c){c=window.event}a.removeMenus();a.lassoSelected=true}}(this);this.clickLayoutNoAnimation=function(b){if(this.appLayout&&!b){var a=this;this.hideTable(false,function(){a.hideDataFilter();var c=a.$(a.target+"-cX-ToolbarLayout");c.src=CanvasXpress.images.funnel;c.alt="Explore data";c.title="Explore data";a.appLayout=false;a.activeAccordion=false});return false}};this.clickLayoutShowDataFilter=function(c,b,d){var a=this;this.showDataFilter(c,function(){a.moveDataFilter(false,"dock",function(){a.expandGenie(c,a.$(a.target+"-cX-DataFilter"),false,b,d)},c)})};this.clickDataFilters=function(a){return function(f,d){if(!f){f=window.event}a.removeMenus();if(a.maximized){if(a.appLayout){a.clickLayout(f,a.$(a.target+"-cX-ToolbarLayout"),function(){a.clickDataFilters(f,d)})}else{if(a.appLayoutDataTable){a.clickDataTable(f,function(){a.clickLayout(f,a.$(a.target+"-cX-ToolbarLayout"),d)})}else{var c=a.dataFilterWidth+10;a.appLayoutDataFilter=a.appLayoutDataFilter?false:true;if(a.appLayoutDataFilter){a.setDimensions(a.width-c,a.height,true);a.resizeWidthOnLayoutActive=c;a.resizeDataFilterHeight();a.clickLayoutShowDataFilter(f,d)}else{var b=function(){a.hideDataFilter(f,function(){a.resizeViewportMiddle(a.width+c,a.height);a.setDimensions(a.width+c,a.height,true,250);a.resizeWidthOnLayoutActive=false;if(d){d(f)}},brc)};if(a.activeAccordion){a.activateAccordion(false,a.activeAccordion.previousSibling,b)}else{b()}}}}}else{a.showDataFilter(f,function(){a.expandGenie(f,a.$(a.target+"-cX-DataFilter"),false,d)})}return false}}(this);this.clickLayoutShowDataTable=function(g,c,f,b,h){this.updateDataTable(false,false,false,false,false,true);if(!this.dataTableLastState||(this.dataTableLastState&&this.dataTableLastState!="docked")){this.moveDataTableDiv("dockGenie")}var a=this.getDataFilterState();var d=this.$("middle-container-"+this.target);if(!f){f=parseInt(d.style.width)+(a=="docked"?(this.dataFilterWidth+6):0)-(this.appLayoutDataTable?17:-1)}if(!b){b=this.dataTableLastHeight||parseInt(this.dataTableTarget.style.height)}this.dataTableTarget=this.$(this.target+"-cX-DataTable");this.updateDataTableResizerDiv(false,f,b);this.endDataTableResizerDiv(true);this.expandGenie(g,this.$(this.target+"-cX-DataTable"),false,c,h)};this.clickDataTable=function(a){return function(d,c){if(!d){d=window.event}a.removeMenus();if(a.maximized){if(a.appLayout){a.clickLayout(d,a.$(a.target+"-cX-ToolbarLayout"),function(){a.clickDataTable(d,c)})}else{if(a.appLayoutDataFilter){a.clickDataFilters(d,function(){a.clickLayout(d,a.$(a.target+"-cX-ToolbarLayout"),c)})}else{a.setDataTableDimensions();var b=a.dataTableLastHeight?a.dataTableLastHeight+6:a.dataTableRowsHeight+81;a.appLayoutDataTable=a.appLayoutDataTable?false:true;if(a.appLayoutDataTable){a.setDimensions(a.width,a.height-b,true);a.resizeHeightOnLayoutActive=true;a.clickLayoutShowDataTable(d,c)}else{a.hideTable(d,function(){a.setDimensions(a.width,a.height+b,true,250);a.resizeHeightOnLayoutActive=false;if(c){c(d)}})}}}}else{a.updateDataTable(false,false,false,false,false,true);a.expandGenie(d,a.$(a.target+"-cX-DataTable"),false,c)}return false}}(this);this.clickLayout=function(a){return function(i,c,g){if(!i){i=window.event}if(!c){if(i){c=i.target||i.srcElement}else{c=a.$(a.target+"-cX-ToolbarLayout")}}if(a.appLayoutDataTable){a.clickDataTable(i,function(){a.clickDataFilters(i,g)})}else{if(a.appLayoutDataFilter){a.clickDataFilters(i,function(){a.clickDataTable(i,g)})}else{a.appLayout=a.appLayout?false:true;c.src=CanvasXpress.images.funnel;c.alt="Explore data";c.title="Explore data";if(a.resizeHeightOnLayout){a.setDataTableDimensions()}if(a.appLayout){var d=a.width;var b=a.dataFilterWidth+10;var f=a.dataTableLastHeight?a.dataTableLastHeight+6:a.dataTableRowsHeight+81;if(a.resizeWidthOnLayout&&a.width-b>=b*1.3){if(a.resizeHeightOnLayout&&a.height-f>=f*1){a.setDimensions(a.width-b,a.height-f,true);a.resizeWidthOnLayoutActive=b;a.resizeHeightOnLayoutActive=f}else{a.setDimensions(a.width-b,a.height,true);a.resizeWidthOnLayoutActive=b}}else{if(a.resizeHeightOnLayout&&a.height-f>=f*1){a.setDimensions(a.width,a.height-f,true);a.resizeHeightOnLayoutActive=f}}a.resizeDataFilterHeight();a.hideToolbar(1);a.clickLayoutShowDataFilter(i,false,{x:-a.dataFilterWidth,y:0});a.clickLayoutShowDataTable(i,function(){if(g){g(i)}},d-3,false,{x:-a.dataFilterWidth,y:0})}else{a.hideToolbar(1);a.hideTable(i);a.hideDataFilter(i,function(){var e=function(){a.resizeWidthOnLayoutActive=false;a.resizeHeightOnLayoutActive=false;a.updateRemoteNavigationWindow(function(){if(g){g(i)}})};if(a.resizeWidthOnLayoutActive){if(a.resizeHeightOnLayoutActive){a.setDimensions(a.width+a.resizeWidthOnLayoutActive,a.height+a.resizeHeightOnLayoutActive,true,false,false,e)}else{a.setDimensions(a.width+a.resizeWidthOnLayoutActive,a.height,true,false,false,e)}}else{if(a.resizeHeightOnLayoutActive){a.setDimensions(a.width,a.height+a.resizeHeightOnLayoutActive,true,false,false,e)}}})}}}return false}}(this);this.clickDataExplorer=function(a){return function(b){if(!b){b=window.event}a.removeMenus();a.addDataExplorer();a.expandGenie(b,a.$(a.target+"-cX-DataExplorer"));return false}}(this);this.clickDataDetails=function(a){return function(f){if(!f){f=window.event}a.removeMenus();var b=document.body.scrollLeft;var h=document.body.scrollTop;var c={maxWidth:"500px",maxHeight:"500px",whiteSpace:"normal",overflow:"auto",textAlign:"left",opacity:0};var g=a.showTooltipDiv(f,a.info,false,c,f.clientX+b-a.width,f.clientY+h);a.expandGenie(f,g);return false}}(this);this.clickRepResearch=function(a){return function(h,l){if(!h){h=window.event}a.removeMenus();var b=document.body.scrollLeft;var k=document.body.scrollTop;var c=a.prettyJSON(CanvasXpress.stack[a.target],null,true);var g='<pre class="CanvasXpressCode">\n'+c+"</pre>\n";var f={maxWidth:"500px",maxHeight:"500px",whiteSpace:"normal",overflow:"auto",textAlign:"left",opacity:0};var i=a.showTooltipDiv(h,g,false,f,h.clientX+b-(a.width/2),h.clientY+k);a.expandGenie(h,i);return false}}(this);this.clickShowCode=function(a){return function(b,c){if(!b){b=window.event}a.removeMenus();a.showCodeDiv(b);return false}}(this);this.clickShowRCode=function(a){return function(b){if(!b){b=window.event}a.removeMenus();a.showRCodeDiv(b);return false}}(this);this.moveCanvasXpressContainer=function(c){if(c){if(this.maximized){var b=this.$(this.target+"-CanvasXpressAnchor");if(b){b.parentNode.insertBefore(c,b);b.parentNode.removeChild(b)}}else{var b=this.$cX("div",{id:this.target+"-CanvasXpressAnchor"});c.parentNode.insertBefore(b,c);document.body.insertBefore(c,document.body.firstElementChild)}}};this.clickGraphMaxMin=function(a){a.functionCaller="clickGraphMaxMin";return function(d,g){if(!d){d=window.event}if(a.appLayout||a.appLayoutDataTable||a.appLayoutDataFilter){if(a.appLayout){a.clickLayout(d,a.$(a.target+"-cX-ToolbarLayout"),a.clickGraphMaxMin)}else{if(a.appLayoutDataTable){a.clickDataTable(d,a.clickGraphMaxMin)}else{if(a.appLayoutDataFilter){a.clickDataFilters(d,a.clickGraphMaxMin)}}}}else{var h=a.remoteService?a.$(a.remoteParentId+"-canvasXpressRemoteWindow"):a.$("container-"+a.target);var f=a.$(a.target+"-cX-ToolbarMaxMin");var c=window.innerWidth;var b=window.innerHeight;if(h&&f){a.moveCanvasXpressContainer(h);if(a.maximized){a.backgroundMask();f.alt="Maximize";f.title="Maximize";f.src=CanvasXpress.images.maximizeMinimize;a.setDimensions(a.maximized[0],a.maximized[1],false,false,true);h.style.left=a.maximized[2];h.style.top=a.maximized[3];document.documentElement.style.overflowX=a.maximized[4];document.documentElement.style.overflowY=a.maximized[5];a.maximized=false;a.resizeDataFilterHeight()}else{a.backgroundMask([c,b]);f.alt="Minimize";f.title="Minimize";f.src=CanvasXpress.images.maximizeMinimize;a.maximized=g||[a.width,a.height,h.style.left,h.style.top,document.body.style.overflowX,document.body.style.overflowY];document.documentElement.style.overflowX="hidden";document.documentElement.style.overflowY="hidden";a.setDimensions(c-4,b-4,false,false,true);a.resizeDataFilterHeight()}a.hideToolbar(1)}}return false}}(this);this.showToolbar=function(e){if(!this.disableToolbar&&!this.dataTableMaximized){var b=this.$(this.target+"-cX-Toolbar");var d=this.$("west-container-"+this.target);var a=this.$(this.target+"-cX-ToolbarMove");if(b&&parseInt(b.style.height)==0&&d&&a){a.style.display=this.movable&&!this.maximized?"block":"none";this.resizeMove(b,0,0,this.width,36,250);if(e){var c=this;setTimeout(function(){c.hideToolbar(e)},e)}}}};this.hideToolbar=function(e,a){var b=this.$(this.target+"-cX-Toolbar");var d=this.$("west-container-"+this.target);if(b&&parseInt(b.style.height)==36&&d){this.resizeMove(b,0,0,this.width,0,500,a)}else{if(e&&b&&parseInt(b.style.height)>0){var c=this;setTimeout(function(){c.hideToolbar(e,a)},e)}}};this.isToolbar=function(c){if(!c){c=window.event}var b=this.adjustedCoordinates(c);if(b){var a=b.x;var d=b.y;if(d>0&&d<36&&a>0&&a<this.width){this.showToolbar()}else{if(d>36&&d<this.height&&a>0&&a<this.width){this.hideToolbar()}}}};this.initializeToolbar=function(){if(!this.disableEvents){if(!this.disableToolbar){this.addToolbarDiv()}}};this.setFunctionNames("initToolbar");this.initializeToolbar()};CanvasXpress.prototype.initConfigurator=function(){this.addConfigurator=function(a){return function(ad,C,M,L){var w=false;if(!ad){ad=window.event}if(a.isVML||a.disableConfigurator){return}var ag=a.$(a.target+"-cX-Configurator");if(ag){w=true;if(a.activeTarget){a.activeTarget.style.zIndex=10000}a.activeTarget=ag;a.activeTarget.style.zIndex=10001}var E="Search property or function";a.configuringOn=true;if(C){if(a.isArray(C)){C=C[0]}if(a.graphType=="Network"){a.configuringNetwork=C;if(a.data.nodes.length>C){E="Configure "+(a.data.nodes[C].label||a.data.nodes[C].name||a.data.nodes[C].id)}else{var A=a.data.edges[C-a.data.nodes.length];var H=a.data.nodes[a.data.nodeIndices[A.id1]];var G=a.data.nodes[a.data.nodeIndices[A.id2]];E="Configure "+(H.label||H.name||H.id)+" - "+(G.label||H.name||G.id)}}else{if(a.graphType=="Genome"){a.configuringGenome=C;E="Configure track "+C}}}var B=M!=null&&L!=null?{x:M,y:L}:a.adjustedCoordinates(ad);if(B){M=B.x;L=B.y;if(w){ag.style.left=M+"px";ag.style.top=L+"px";return}else{ag=a.$cX("div",{id:a.target+"-cX-Configurator",className:"CanvasXpressConfigurator draggable"},{cursor:"move",left:M+"px",top:L+"px",padding:"10px",position:"absolute",zIndex:10001,opacity:0})}var aa=a.$cX("div",{id:a.target+"-cX-ConfiguratorKeyText"},{display:"block",marginBottom:"5px",width:a.configuratorWidth+"px",height:"24px"});var ab=a.$cX("span",{id:a.target+"-cX-ConfiguratorKeyTextSpan",className:"CanvasXpressConfigurator",innerHTML:E});var I=a.$cX("img",{id:a.target+"-cX-ConfiguratorKeyMenu",className:"CanvasXpressConfigurator",src:CanvasXpress.images.list,alt:"Open menus",title:"Open menus"});var ac=a.$cX("img",{id:a.target+"-cX-ConfiguratorKeySearch",className:"CanvasXpressConfigurator",src:CanvasXpress.images.magnifier,alt:"Browse properties by category",title:"Browse properties by category"});var Y=a.$cX("img",{id:a.target+"-cX-ConfiguratorKeyClose",className:"CanvasXpressConfigurator",src:CanvasXpress.images.cancel,alt:"Close",title:"Close"});var Z=a.$cX("input",{id:a.target+"-cX-ConfiguratorKey",className:"CanvasXpressConfigurator",type:"text"},{display:"block",width:a.configuratorWidth+"px"});var X=a.$cX("select",{id:a.target+"-cX-ConfiguratorCategories",className:"CanvasXpressConfigurator",size:5},{display:"none",width:a.configuratorWidth+"px"});var R=a.$cX("div",{id:a.target+"-cX-ConfiguratorSugestionsText",innerHTML:"Select property"},{display:"none",margin:"5px 0px 5px 0px",width:a.configuratorWidth+"px"});var Q=a.$cX("select",{id:a.target+"-cX-ConfiguratorSugestions",className:"CanvasXpressConfigurator",size:10},{display:"none",width:a.configuratorWidth+"px"});var af=a.$cX("div",{id:a.target+"-cX-ConfiguratorSugestionsDescription"},{display:"none",margin:"5px 0px 5px 0px",width:a.configuratorWidth+"px",minHeight:"56px",overflow:"auto"});var O=a.$cX("div",{id:a.target+"-cX-ConfiguratorValueText",innerHTML:"Current value"},{display:"none",margin:"5px 0px 5px 0px",width:a.configuratorWidth+"px"});var ai=a.$cX("div",{id:a.target+"-cX-ConfiguratorSeeAlso"},{display:"none",width:a.configuratorWidth+"px",minHeight:"20px",overflow:"auto"});var N=a.$cX("input",{id:a.target+"-cX-ConfiguratorValue",className:"CanvasXpressConfigurator",type:"text"},{display:"none",width:a.configuratorWidth+"px"});var D=a.$cX("input",{id:a.target+"-cX-ConfiguratorApply",value:"Apply",type:"button"},{display:"none",cssFloat:"left",borderRadius:"5px",top:"4px",position:"relative",width:(a.configuratorWidth/2)+"px"});var ah=a.$cX("input",{id:a.target+"-cX-ConfiguratorButton",value:"Draw",type:"button"},{display:"none",cssFloat:"left",borderRadius:"5px",top:"4px",position:"relative",width:(a.configuratorWidth/2)+"px"});var S=a.$cX("img",{id:a.target+"-cX-ConfiguratorOptionsClose",className:"CanvasXpressConfigurator",src:CanvasXpress.images.cancel,alt:"Close",title:"Close"});var K=a.$cX("div",{id:a.target+"-cX-ConfiguratorOptions",className:"CanvasXpressConfigurator draggable"},{cursor:"move",display:"none",padding:"10px",position:"absolute"});var U=a.$cX("div",{id:a.target+"-cX-ConfiguratorColorCurrent",className:"CanvasXpressConfiguratorColor"},{width:"181px",height:"24px",cssFloat:"left",cursor:"default",lineHeight:"24px"});var T=a.$cX("img",{id:a.target+"-cX-ConfiguratorColorClose",className:"CanvasXpressConfigurator",src:CanvasXpress.images.cancel,alt:"Close",title:"Close"});var W=a.$cX("div",{id:a.target+"-cX-ConfiguratorColor",className:"CanvasXpressConfigurator draggable"},{width:"212px",cursor:"move",display:"none",padding:"10px",position:"absolute"});var F=a.$cX("div",{id:a.target+"-cX-ConfiguratorFilter",className:"CanvasXpressConfiguratorFilter draggable",innerHTML:'Build filter ("+" to set "-" to remove)'},{cursor:"move",display:"none",padding:"10px",position:"absolute"});var J=a.$cX("img",{id:a.target+"-cX-ConfiguratorFilterClose",className:"CanvasXpressConfigurator",src:CanvasXpress.images.cancel,alt:"Close",title:"Close"});var P=a.$cX("div",{id:a.target+"-cX-ConfiguratorExample",className:"CanvasXpressConfiguratorExample draggable"},{width:(a.configuratorExamplesSize+35)+"px",maxHeight:(a.configuratorExamplesSize)+"px",cursor:"move",display:"none",padding:"10px",position:"absolute",overflow:"hidden",paddingBottom:"35px"});var ae=a.$cX("span",{id:a.target+"-cX-ConfiguratorExampleSpan",className:"CanvasXpressConfiguratorExample",innerHTML:""});var t=a.$cX("img",{id:a.target+"-cX-ConfiguratorExampleClose",className:"CanvasXpressConfigurator",src:CanvasXpress.images.cancel,alt:"Close",title:"Close"});var h=a.$cX("div",{id:a.target+"-cX-ConfiguratorExampleContent",className:"CanvasXpressConfiguratorExampleContent"},{maxWidth:(a.configuratorExamplesSize+35)+"px",maxHeight:(a.configuratorExamplesSize)+"px"});aa.appendChild(ab);aa.appendChild(Y);aa.appendChild(ac);aa.appendChild(I);K.appendChild(document.createTextNode("Select option ..."));K.appendChild(S);K.appendChild(a.$cX("br"));W.appendChild(U);W.appendChild(T);W.appendChild(a.$cX("br"));F.appendChild(J);F.appendChild(a.$cX("br"));P.appendChild(ae);P.appendChild(t);P.appendChild(a.$cX("br"));P.appendChild(h);ag.appendChild(aa);ag.appendChild(Z);ag.appendChild(X);ag.appendChild(R);ag.appendChild(Q);ag.appendChild(af);ag.appendChild(ai);ag.appendChild(O);ag.appendChild(N);ag.appendChild(D);ag.appendChild(ah);ag.appendChild(K);ag.appendChild(W);ag.appendChild(F);ag.appendChild(P);var V=a.$("west-wrapper-"+a.target);if(V){V.appendChild(ag);if(a.activeTarget){a.activeTarget.style.zIndex=10000}a.activeTarget=ag;a.addRemoveConfiguratorListeners("addEvtListener");if(a.configuringNetwork||a.configuringGenome){a.selectConfig(false,true)}this.expandGenie(ad,ag);setTimeout(function(){Z.focus()},300)}}}}(this);this.addConfiguratorCloseMenus=function(a){return function(d,c,b,f){a.removeMenus();a.addConfigurator(d,c,b,f)}}(this);this.addRemoveConfiguratorListeners=function(B){var v=this.$(this.target+"-cX-Configurator");var j=this.$(this.target+"-cX-ConfiguratorCategories");var C=this.$(this.target+"-cX-ConfiguratorSugestions");var x=this.$(this.target+"-cX-ConfiguratorApply");var w=this.$(this.target+"-cX-ConfiguratorButton");var k=this.$(this.target+"-cX-ConfiguratorKeyClose");var o=this.$(this.target+"-cX-ConfiguratorKeySearch");var h=this.$(this.target+"-cX-ConfiguratorKeyMenu");var u=this.$(this.target+"-cX-ConfiguratorOptions");var a=this.$(this.target+"-cX-ConfiguratorOptionsClose");var g=this.$(this.target+"-cX-ConfiguratorColor");var d=this.$(this.target+"-cX-ConfiguratorColorClose");var y=this.$(this.target+"-cX-ConfiguratorFilter");var e=this.$(this.target+"-cX-ConfiguratorFilterClose");var r=this.$(this.target+"-cX-ConfiguratorExample");var A=this.$(this.target+"-cX-ConfiguratorExampleClose");if(v&&j&&C&&w&&x&&k&&o&&h&&u&&a&&g&&d&&y&&e&&r&&A){this[B](v,"mousedown",this.registerMousemove,false);this[B](j,"change",this.changeCategory,false);this[B](j,"click",this.changeCategory,false);this[B](C,"change",this.clickSuggestions,false);this[B](C,"click",this.clickSuggestions,false);this[B](x,"click",this.clickApplyConfigurator,false);this[B](w,"click",this.clickConfigurator,false);this[B](h,"click",this.clickMenuDropDown,false);this[B](o,"click",this.clickSearch,false);this[B](k,"click",this.closeConfigurator,false);this[B](u,"mousedown",this.registerMousemove,false);this[B](a,"click",this.closePropertyOptions,false);this[B](g,"mousedown",this.registerMousemove,false);this[B](d,"click",this.closePropertyColor,false);this[B](y,"mousedown",this.registerMousemove,false);this[B](e,"click",this.closePropertyFilter,false);this[B](r,"mousedown",this.registerMousemove,false);this[B](A,"click",this.closePropertyExample,false)}};this.getConfigurableProperties=function(){if(this.configuringNetwork){if(this.data.nodes.length>this.configuringNetwork){return this.getNodeConfigurableProperties(this.configuringNetwork)}else{return this.getEdgeConfigurableProperties(this.configuringNetwork-this.data.nodes.length)}}else{if(this.configuringGenome){if(!isNaN(this.configuringGenome)||this.configuringGenome.match(/:/)){return this.featureConfigurableProperties}else{if(this.configuringGenome.match(/track/)){return this.trackConfigurableProperties}else{this.configuringGenome=false}}}}var c=[];for(var b in CanvasXpress.doc.P){if(!CanvasXpress.doc.P[b].Z){var a=this.getGraphTypes(CanvasXpress.doc.P[b],true);if(a.hasOwnProperty(this.graphType)){c.push(b)}}}return c};this.getConfigurableObjectDoc=function(a){if(this.configuringNetwork){if(this.data.nodes.length>this.configuringNetwork){return CanvasXpress.doc.N[a]?CanvasXpress.doc.N[a]:false}else{return CanvasXpress.doc.E[a]?CanvasXpress.doc.E[a]:false}}else{if(this.configuringGenome){if(!isNaN(this.configuringGenome)||this.configuringGenome.match(/:/)){return CanvasXpress.doc.F[a]?CanvasXpress.doc.F[a]:false}else{if(this.configuringGenome.match(/track/)){return CanvasXpress.doc.G[a]?CanvasXpress.doc.G[a]:false}else{this.configuringGenome=false;return CanvasXpress.doc.P[a]?CanvasXpress.doc.P[a]:false}}}else{return CanvasXpress.doc.P[a]?CanvasXpress.doc.P[a]:false}}};this.selectConfig=function(D,F){var z=this.$(this.target+"-cX-ConfiguratorKey");var q=this.$(this.target+"-cX-ConfiguratorSugestionsText");var n=this.$(this.target+"-cX-ConfiguratorSugestions");var E=this.$(this.target+"-cX-ConfiguratorSugestionsDescription");var l=this.$(this.target+"-cX-ConfiguratorValueText");var H=this.$(this.target+"-cX-ConfiguratorSeeAlso");var j=this.$(this.target+"-cX-ConfiguratorValue");var f=this.$(this.target+"-cX-ConfiguratorApply");var G=this.$(this.target+"-cX-ConfiguratorButton");var B=this.$(this.target+"-cX-ConfiguratorValueHREF");var m=document.activeElement;var y=this.getConfigurableProperties();var w=[];if(this.getKeyCode(D)==13){this.resetOptionColorFiltersExamples();if(this.editingDescriptionOn){this.submitEditPropertyDescription()}else{if(n&&j&&j.value){var g=false;for(var A=0;A<y.length;A++){if(n.value==y[A]){g=true;break}}if(g){this.clickConfigurator(D,n,j)}else{this.resetConfigurator(D)}}}}else{if(m.id.match(/canvasXpressConfiguratorFilterValue/)){return}else{if(z&&m.id==z.id||F){this.resetOptionColorFiltersExamples();this.resetEditPropertyDescription();for(var A=0;A<y.length;A++){if(y[A].toLowerCase().indexOf(z.value.toLowerCase())>=0){w.push(y[A])}}if(w.length>0&&q&&n&&E&&l&&H&&j&&G&&f){this.resetSugestions();if(!this.configuringNetwork&&!this.configuringGenome){w.sort(function(d,c){return CanvasXpress.doc.P[d].M>CanvasXpress.doc.P[c].M?1:CanvasXpress.doc.P[c].M>CanvasXpress.doc.P[d].M?-1:d>c?1:c>d?-1:0});for(var A=0;A<w.length;A++){var y=this.$cX("option",{text:CanvasXpress.doc.P[w[A]].M?CanvasXpress.doc.P[w[A]].M+" : "+w[A]:"NA : "+w[A],value:w[A]});try{n.add(y,null)}catch(C){n.add(y)}}}else{w.sort();for(var A=0;A<w.length;A++){var y=this.$cX("option",{text:w[A],value:w[A]});try{n.add(y,null)}catch(C){n.add(y)}}}n.options[0].selected=true;this.setConfiguratorPropertyValue(n,E,l,H,j);q.innerHTML="Select property ("+w.length+")";q.style.display="block";n.style.display="block";E.style.display="block";l.style.display="block";H.style.display="block";j.style.display="block";G.style.display="block";f.style.display="block"}else{z.value=z.value.slice(0,z.value.length-1)}}else{if(j&&m.id==j.id){this.resetOptionColorFiltersExamples();this.resetEditPropertyDescription();if(B&&B.innerHTML=="color"){B.style.color=j.value?this.rgbToHex(this.validateColor(j.value.replace(/[\'\"]/g,""))):this.foreground}}else{if(this.remoteService){this.resetOptionColorFiltersExamples();this.selectDataSet(D)}}}}}return false};this.clickSearch=function(a){return function(H){if(!H){H=window.event}a.configuringNetwork=false;a.configuringGenome=false;a.resetEditOptionColorFiltersExamples();var F=a.$(a.target+"-cX-ConfiguratorKeyTextSpan");var D=a.$(a.target+"-cX-ConfiguratorKey");var B=a.$(a.target+"-cX-ConfiguratorCategories");var x=a.$(a.target+"-cX-ConfiguratorSugestionsText");var w=a.$(a.target+"-cX-ConfiguratorSugestions");var I=a.$(a.target+"-cX-ConfiguratorSugestionsDescription");var t=a.$(a.target+"-cX-ConfiguratorValueText");var K=a.$(a.target+"-cX-ConfiguratorSeeAlso");var q=a.$(a.target+"-cX-ConfiguratorValue");var J=a.$(a.target+"-cX-ConfiguratorButton");var c=a.$(a.target+"-cX-ConfiguratorApply");var h=a.$(a.target+"-cX-ConfiguratorOptions");var A=a.$(a.target+"-cX-ConfiguratorColor");var j=a.$(a.target+"-cX-ConfiguratorFilter");var C=a.getKeys(CanvasXpress.doc.M).sort();var p=[];if(D&&D.style.display=="none"){if(F){F.innerText="Search property or function"}if(B){B.style.display="none"}D.value="";D.style.display="block"}else{if(F){for(var E=0;E<C.length;E++){if(CanvasXpress.doc.M[C[E]].U){var f=a.getGraphTypes({M:C[E]},true);if(f.hasOwnProperty(a.graphType)){p.push(C[E])}}else{p.push(C[E])}F.innerText="Select category ("+p.length+")"}}if(D){D.style.display="none"}if(B){a.resetCategories();for(var E=0;E<p.length;E++){var y=a.$cX("option",{text:p[E],value:p[E]});try{B.add(y,null)}catch(G){B.add(y)}}B.style.display="block"}}if(x&&w&&I&&t&&K&&q&&J&&c&&h&&A&&j){x.style.display="none";w.style.display="none";I.style.display="none";t.style.display="none";K.style.display="none";q.style.display="none";J.style.display="none";c.style.display="none";h.style.display="none";A.style.dysplay="none";j.style.dysplay="none"}return false}}(this);this.clickMenuDropDown=function(a){return function(b){if(!b){b=window.event}a.closeConfigurator(b);a.addMenu(b,false,false,false,8,8);return false}}(this);this.closeConfigurator=function(a){return function(b){if(!b){b=window.event}a.resetViewportOverflow("west");a.resetConfigurator(b);return false}}(this);this.changeCategory=function(a){return function(G,D,I){if(!G){G=window.event}a.resetEditOptionColorFiltersExamples();var C=a.$(a.target+"-cX-ConfiguratorCategories");var w=a.$(a.target+"-cX-ConfiguratorSugestionsText");var t=a.$(a.target+"-cX-ConfiguratorSugestions");var H=a.$(a.target+"-cX-ConfiguratorSugestionsDescription");var q=a.$(a.target+"-cX-ConfiguratorValueText");var K=a.$(a.target+"-cX-ConfiguratorSeeAlso");var l=a.$(a.target+"-cX-ConfiguratorValue");var f=a.$(a.target+"-cX-ConfiguratorApply");var J=a.$(a.target+"-cX-ConfiguratorButton");var g=a.$(a.target+"-cX-ConfiguratorOptions");var B=a.$(a.target+"-cX-ConfiguratorColor");var h=a.$(a.target+"-cX-ConfiguratorFilter");var k=CanvasXpress.doc.M;if(I){C.value=I}if(C&&C.value&&w&&t&&H&&q&&K&&l&&J&&g&&B&&h){var y=k[C.value].P.sort();a.resetSugestions();for(var E=0;E<y.length;E++){if(I&&y[E]==I){D=E}var A=a.$cX("option",{text:y[E],value:y[E]});try{t.add(A,null)}catch(F){t.add(A)}}t.options[D||0].selected=true;w.innerHTML="Select property ("+y.length+")";a.setConfiguratorPropertyValue(t,H,q,K,l);w.style.display="block";t.style.display="block";H.style.display="block";q.style.display="block";K.style.display="block";l.style.display="block";f.style.display="block";J.style.display="block";g.style.display="none";B.style.display="none";h.style.display="none"}return false}}(this);this.hideCategories=function(){var a=this.$(this.target+"-cX-ConfiguratorCategories");var b=this.$(this.target+"-cX-ConfiguratorKeyTextSpan");var c=this.$(this.target+"-cX-ConfiguratorKeySearch");var e=this.$(this.target+"-cX-ConfiguratorKeyDock");if(a&&b&&c&&e){a.style.display="none";b.innerHTML="";c.style.display="none";e.style.display="none"}};this.resetCategories=function(){var a=this.$(this.target+"-cX-ConfiguratorCategories");if(a){if(a.hasChildNodes()){while(a.childNodes.length>=1){a.removeChild(a.firstChild)}}a.style.display="none"}};this.clickSuggestions=function(a){return function(b){if(!b){b=window.event}a.resetEditOptionColorFiltersExamples();a.setConfiguratorPropertyValue();return false}}(this);this.setConfiguratorPropertyValue=function(l,e,j,g,h){if(!l){l=this.$(this.target+"-cX-ConfiguratorSugestions")}if(!e){e=this.$(this.target+"-cX-ConfiguratorSugestionsDescription")}if(!j){j=this.$(this.target+"-cX-ConfiguratorValueText")}if(!g){g=this.$(this.target+"-cX-ConfiguratorSeeAlso")}if(!h){h=this.$(this.target+"-cX-ConfiguratorValue")}var k;var f=this.$(this.target+"-cX-ConfiguratorOptions");var c=this.getConfigurableObjectDoc(l.value);h.value="";h.style.readonly=false;if(this.configuringNetwork){if(typeof(this[l.value])=="function"){h.style.disabled="disabled";h.style.readonly=false}else{if(this.configuringNetwork<this.data.nodes.length){k=this.data.nodes[this.configuringNetwork][l.value]}else{k=this.data.edges[this.configuringNetwork-this.data.nodes.length][l.value]}}}else{if(this.configuringGenome){var b=this.subtracksInfo;if(!isNaN(this.configuringGenome)){k=this.data.tracks[b[this.configuringGenome].track].data[b[this.configuringGenome].index][l.value]}else{if(this.configuringGenome.match(/:/)){k=parseInt(this.configuringGenome.split(":")[1]);k=this.data.tracks[b[k].track].data[b[k].index][l.value]}else{k=parseInt(this.configuringGenome.replace("track-",""));k=this.data.tracks[b[k].track][l.value]}}}else{if(typeof(this[l.value])=="function"){j.innerHTML="Current&nbsp;value&nbsp;[&nbsp;<i>function</i>&nbsp;]&nbsp;"+this[l.value].length+"&nbsp;parameter(s)";if(this[l.value].length==0){h.style.disabled="disabled";h.style.readonly=false}}else{k=this[l.value]}}}h.value=k?this.stringifyJSON(k):"";this.addPropertyDescription(e,c,l.value);this.addPropertySeeAlsoLinks(g,c);this.addPropertyOptions(j,f,c,l.value,k);if(this.showConfiguratorExamplesOnSelect){this.resetPropertyExample();this.clickExamplePropertyDescription(false,l.value)}};this.resetSugestions=function(){var a=this.$(this.target+"-cX-ConfiguratorSugestions");if(a){if(a.hasChildNodes()){while(a.childNodes.length>=1){a.removeChild(a.firstChild)}}a.style.display="none"}};this.addPropertyDescription=function(r,g,f){var t=g&&g.C?g.C:"";var j=g&&g.M?g.M:"";var v=g&&g.H?true:false;this.resetPropertyDescription(r);var n=this.$cX("img",{id:this.target+"-cX-ConfiguratorSugestionsDescriptionEdit",src:CanvasXpress.images.pencil2,alt:"Edit description",title:"Edit description"},{cursor:"default",margin:"2px",width:"10px",height:"10px",background:"rgba(0,0,0,0)",border:"0px none",boxShadow:"0 0 0px rgba(0,0,0,0)"});var a=this.$cX("i",{innerHTML:f});var w=this.$cX("span",{id:this.target+"-cX-ConfiguratorSugestionsDescriptionEditSpan",className:"CanvasXpressConfigurator",prop:f,innerHTML:" : "+t});var k=this.$cX("i",{innerHTML:j});var l=this.$cX("a",{id:this.target+"-cX-ConfiguratorSugestionsDescriptionExample",href:"javascript:void(0)",alt:"Show examples",title:"Show examples"});var u=this.$cX("span",false,{className:"CanvasXpressConfigurator"});l.appendChild(a);u.appendChild(document.createTextNode("Description [ "));u.appendChild(k);u.appendChild(document.createTextNode(" ]"));r.appendChild(u);r.appendChild(this.$cX("br"));r.appendChild(v?l:a);r.appendChild(w);r.appendChild(n);this.addEvtListener(l,"click",this.clickExamplePropertyDescription,false);this.addEvtListener(n,"click",this.clickEditPropertyDescription,false)};this.resetPropertyDescription=function(f,b,a){if(!f){f=this.$(this.target+"-cX-ConfiguratorSugestionsDescription")}if(!b){b=this.$(this.target+"-cX-ConfiguratorSugestionsDescriptionEdit")}if(f&&b){this.removeEvtListener(b,"click",this.clickEditPropertyDescription,false);if(!a){a=this.$(this.target+"-cX-ConfiguratorSugestionsDescriptionExample")}if(a){this.removeEvtListener(a,"click",this.clickExamplePropertyDescription,false)}while(f.childNodes.length>0){var g=f.childNodes[0];f.removeChild(g)}}};this.getGraphTypes=function(e,c){var a=[];if(e.U){for(var b=0;b<e.U.length;b++){var d=e.U[b];a=a.concat(CanvasXpress.graphTypes[d])}}else{if(CanvasXpress.doc.M[e.M].U){for(var b=0;b<CanvasXpress.doc.M[e.M].U.length;b++){var d=CanvasXpress.doc.M[e.M].U[b];a=a.concat(CanvasXpress.graphTypes[d])}}else{a=["Bar"]}}return c?this.getObjectArray(a):this.getUniqueEls(a).sort()};this.getExamplesDocObject=function(c,v){var h=[];if(c){var g=this.getConfigurableObjectDoc(c);var w=this.getGraphTypes(g);for(var n=0;n<g.H.length;n++){if(g.H[n].match(/^\{\[/)){var s=[];var a=g.H[n]=="{[*]}"||g.H[n].match(/^\{\[.+?\]\}[^,]/)||g.H[n].match(/^\{\[.+\]\}[^,]$/)?{}:this.parseJSON(String(g.H[n].replace(/^\{\[.+?\],/,"{")));var e=a.data?this.getDataSet(a.data):false;var l=a.skipExample?this.getObjectArray(a.skipExample):{};var q=a.functions?a.functions:false;if(e){delete (a.data)}if(l){delete (a.skipExample)}if(q){delete (a.functions)}if(g.H[n].match(/^\{\[[^\*].+\]/)){s=g.H[n].replace(/"/g,"");s=s.split("]")[0].replace("{[","").split(",")}else{if(g.T=="option"){s=g.O}else{if(g.T=="boolean"){s=[true,false]}else{if(g.T=="color"){s=["rgb(255,125,51)","rgb(51,255,125)","rgb(125,51,255)"];s.unshift(g.D)}else{if(g.T=="float"){s=g.D=="null"?[null,0.5]:[parseFloat(g.D),Math.max(parseFloat(g.D)*2,1)]}else{if(g.T=="integer"){s=g.D==0?[0,1]:[parseInt(g.D),parseInt((parseInt(g.D)*2)+0.5)]}}}}}}if(s.length>8){s=this.sample(s,8)}for(var m=0;m<s.length;m++){if(l.hasOwnProperty(s[m])){continue}var b=(v?c:this.target)+"-cX-ConfiguratorExample-"+c+"-"+String(s[m]).replace(/\s/m,"-")+"-"+n;var k=this.cloneObject(a);if(s[m]=="null"||s[m]==null){k[c]=null}else{k[c]=g.T=="integer"||g.T=="float"?Number(s[m]):s[m];if(k[c]=="false"){k[c]=false}else{if(k[c]=="true"){k[c]=true}}}if(!k.graphType){k.graphType=w[2]||w[0]}if(q){h.push([b,e,k,q])}else{h.push([b,e,k])}}}else{var m=this.parseJSON(String(g.H[n]));var t=m.data?this.getDataSet(m.data):false;var r=m.functions?m.functions:false;if(t){delete (m.data)}if(r){delete (m.functions)}var b=(v?c:this.target)+"-cX-ConfiguratorExample-"+c+"-"+n;if(!m.graphType){m.graphType=w[2]||w[0]}if(r){h.push([b,t,m,r])}else{h.push([b,t,m])}}}}return h};this.clickExamplePropertyDescription=function(a){return function(y,r,C){a.resetPropertyExample();var k=function(j,c){var p=["sankey","tree","bubble"];for(var e=0;e<p.length;e++){delete (j[p[e]]);delete (c[p[e]])}return j?j:c};var d=function(){if(a.graphType!=m){m=a.graphType;B=a.getDataSet()}return B};var x=C?a.$(r+"-cX-API-Example"):a.$(a.target+"-cX-ConfiguratorExample");var f=C?a.$(r+"-cX-API-ExampleSpan"):a.$(a.target+"-cX-ConfiguratorExampleSpan");var q=C?a.$(r+"-cX-API-ExampleContent"):a.$(a.target+"-cX-ConfiguratorExampleContent");var m=a.graphType;var B=a.getDataSet();if(x&&f&&q){x.style.display="block";if(!r){r=this.firstChild.innerHTML}var g=a.getExamplesDocObject(r);f.innerHTML=r;for(var u=0;u<g.length;u++){var s=g[u][0];var w=g[u][2];a.graphType=w.graphType;var o=k(a.cloneObject(g[u][1]),d());var h=g[u][3];var z=a.$cX("canvas",{id:s,width:C?500:a.configuratorExamplesSize,height:C?500:a.configuratorExamplesSize});q.appendChild(z);if(!w.title){if(w[r]!=null){if(this.isArray(w[r])){w.title=r+" : "+w[r].join(",")}else{if(this.isObject(w[r])){w.title=r+" : Object"}else{w.title=r+" : "+w[r]}}}else{w.title=r+" : null"}}var l=new CanvasXpress(s,o,w);if(h){for(var t=0;t<h.length;t++){if(h[t].match(/:/)){var b=h[t].split(":");l[b.shift()].apply(l,b)}else{l[h[t]]()}}}}if(!C){if(a.alignConfiguratorExamples||a.configuratorLastState=="docked"){var n=a.$(a.target+"-cX-Configurator");x.style.left=n.offsetWidth+"px";x.style.top="-1px";x.style.height=(n.clientHeight-45)+"px";q.style.maxHeight=(n.clientHeight-45)+"px";a.removeClass(x,"draggable")}else{var A=a.adjustedCoordinates(y,x);x.style.left=A.x+"px";x.style.top=A.y+"px";delete (x.style.height);q.style.Maxheight="500px";a.addClass(x,"draggable")}}}}}(this);this.clickEditPropertyDescription=function(a){return function(h){if(!h){h=window.event}a.resetPropertyColor();a.resetPropertyFilter();a.resetPropertyExample();var f=a.$(a.target+"-cX-Configurator");var g=a.$(a.target+"-cX-ConfiguratorSugestions");var u=a.$(a.target+"-cX-ConfiguratorSugestionsDescriptionEditSpan");var m=a.$(a.target+"-cX-ConfiguratorOptions");if(f&&g&&u&&m){m.style.display="none";var t=a.adjustedCoordinates(h,g);if(t){a.editingDescriptionOn=true;var r=t.x;var o=t.y;var j=a.$cX("div",{id:a.target+"-cX-ConfiguratorEditForm",className:"CanvasXpressConfigurator draggable"},{cursor:"move",left:r+"px",top:o+"px",padding:"10px",position:"absolute",width:(a.configuratorWidth*0.8)+"px"});var l=a.$cX("img",{id:a.target+"-cX-ConfiguratorEditFormClose",className:"CanvasXpressConfigurator",src:CanvasXpress.images.cancel,alt:"Close",title:"Close"});var q=a.$cX("textarea",{id:a.target+"-cX-ConfiguratorEditFormValue",className:"CanvasXpressConfigurator",value:u.prop+u.innerHTML,rows:10},{width:"100%",maxWidth:(a.configuratorWidth*0.8)+"px"});var n=a.$cX("input",{id:a.target+"-cX-ConfiguratorEditFormButton",value:"Submit",type:"button"},{width:"100%",borderRadius:"5px",maxWidth:(a.configuratorWidth*0.8)+"px"});j.appendChild(document.createTextNode("Editing "+g.value));j.appendChild(l);j.appendChild(a.$cX("br"));j.appendChild(q);j.appendChild(n);a.addEvtListener(l,"click",a.closeEditPropertyDescription,false);a.addEvtListener(n,"click",a.submitEditPropertyDescription,false);f.appendChild(j)}}}}(this);this.submitEditPropertyDescription=function(a){return function(f){if(!f){f=window.event}var c=a.$(a.target+"-cX-ConfiguratorSugestions");var b=a.$(a.target+"-cX-ConfiguratorEditFormValue");var d=a.$(a.target+"-cX-ConfiguratorSugestionsDescriptionEditSpan");if(c&&b&&d){b.value=b.value.replace(/\n/g,"");CanvasXpress.doc.P[c.value].C=b.value;d.innerHTML=b.value;alert("New description for:\n - "+c.value+" -\nwas submitted and may apppear\nin new versions of CanvasXpress\nThank you for your contribution")}a.resetEditPropertyDescription()}}(this);this.closeEditPropertyDescription=function(a){return function(b){if(!b){b=window.event}a.resetEditPropertyDescription()}}(this);this.resetEditPropertyDescription=function(){var e=this.$(this.target+"-cX-ConfiguratorEditForm");var f=this.$(this.target+"-cX-ConfiguratorEditFormClose");var a=this.$(this.target+"-cX-ConfiguratorEditFormButton");if(e&&f&&a){this.addEvtListener(f,"click",this.closeEditPropertyDescription,false);this.addEvtListener(a,"click",this.submitEditPropertyDescription,false);e.parentNode.removeChild(e)}this.editingDescriptionOn=false};this.addPropertySeeAlsoLinks=function(e,g){this.resetPropertySeeAlsoLinks(e);var d=this.$cX("span",false,{className:"CanvasXpressConfigurator"});d.appendChild(document.createTextNode("See Also: "));e.appendChild(d);if(g&&g.S){for(var f=0;f<g.S.length;f++){var h=this.$cX("a",{href:"javascript:void(0)",innerHTML:g.S[f]});this.addEvtListener(h,"click",this.clickPropertySeeAlsoLinks,false);e.appendChild(h);if(f<g.S.length-1){e.appendChild(document.createTextNode(", "))}}}};this.clickPropertySeeAlsoLinks=function(a){return function(h){if(!h){h=window.event}var f=a.$(a.target+"-cX-ConfiguratorKey");var b=a.$(a.target+"-cX-ConfiguratorCategories");var g=a.$(a.target+"-cX-ConfiguratorSugestions");var c=h.target||h.srcElement;if(b&&b.style.display=="block"){var l=CanvasXpress.doc.P[c.innerHTML];var j=CanvasXpress.doc.M[l.M].P.sort();b.value=l.M;for(i=0;i<j.length;i++){if(j[i]==c.innerHTML){a.changeCategory(h,i);return false}}a.changeCategory(h)}else{if(f){f.value=c.innerHTML;a.selectConfig(h,true)}}return false}}(this);this.resetPropertySeeAlsoLinks=function(b){if(!b){b=this.$(this.target+"-cX-ConfiguratorSeeAlso")}if(b&&b.childNodes){while(b.childNodes.length>0){var d=b.childNodes[0];if(d.nodeName.toLowerCase()=="a"){this.removeEvtListener(d,"click",this.clickPropertySeeAlsoLinks,false)}b.removeChild(d)}}};this.addPropertyOptions=function(w,p,f,g,s){this.resetPropertyOptions(w,p);var q=this.$cX("span",false,{className:"CanvasXpressConfigurator"});var l=this.$cX("i");q.appendChild(document.createTextNode("Current value"));if(f&&f.T&&(f.T=="option"||f.T=="array"||f.T=="boolean")){var x=this.$cX("div",{id:this.target+"-cX-ConfiguratorOptionsContainer",className:"CanvasXpressConfiguratorOptions"});var r=this.$cX("a",{href:"javascript:void(0)",innerHTML:f.T,alt:"Modify property",title:"Modify property"});this.addEvtListener(r,"click",this.clickPropertyOptions,false);q.appendChild(document.createTextNode(" ["));l.appendChild(r);q.appendChild(document.createTextNode(" "));q.appendChild(l);q.appendChild(document.createTextNode(" ]"));if(f.T=="array"){var n=f.X?this[f.X]():f.O?f.O:[];var m=this.getObjectArray(s);if(n.length>0){for(var h=0;h<n.length;h++){var g=this.$cX("input",{type:"checkbox",value:n[h],checked:m.hasOwnProperty(n[h])?true:false},{marginLeft:"0px"});this.addEvtListener(g,"change",this.updatePropertyValue,false);x.appendChild(document.createTextNode((h+1)+". "));x.appendChild(g);x.appendChild(document.createTextNode(n[h]));x.appendChild(this.$cX("br"))}}else{x.appendChild(this.$cX("br"));x.appendChild(document.createTextNode("This array is user defined"));x.appendChild(this.$cX("br"))}}else{var n=f.T=="boolean"?["true","false"]:f.X?this[f.X]():f.O?f.O:[];if(f.X&&f.O){n=n.concat(f.O)}for(var h=0;h<n.length;h++){var g=this.$cX("a",{href:"javascript:void(0)",innerHTML:n[h],alt:"Modify property",title:"Modify property"},{padding:"2px"});this.addEvtListener(g,"click",this.updatePropertyValue,false);x.appendChild(document.createTextNode((h+1)+". "));x.appendChild(g);x.appendChild(this.$cX("br"))}}p.appendChild(x)}else{if(f&&f.T){q.appendChild(document.createTextNode(" ["));if(f.T=="color"){var n;if(this.configuringNetwork){if(this.configuringNetwork<this.data.nodes.length){n=this.data.nodes[this.configuringNetwork][g]}else{n=this.data.edges[this.configuringNetwork-this.data.nodes.length][g]}}else{if(this.configuringGenome){var e=this.subtracksInfo;if(!isNaN(this.configuringGenome)){n=this.data.tracks[e[this.configuringGenome].track].data[e[this.configuringGenome].index]}else{if(this.configuringGenome.match(/:/)){n=parseInt(this.configuringGenome.split(":")[1]);n=this.data.tracks[e[n].track].data[e[n].index]}else{n=parseInt(this.configuringGenome.replace("track-",""));n=this.data.tracks[e[n].track]}}}else{n=this[g]}}var r=this.$cX("a",{id:this.target+"-cX-ConfiguratorValueHREF",href:"javascript:void(0)",innerHTML:f.T,alt:"Modify color",title:"Modify color"},{color:n?this.rgbToHex(this.validateColor(n)):this.foreground});this.addEvtListener(r,"click",this.addPropertyColor,false);l.appendChild(r)}else{if(f&&f.T=="filter"){var r=this.$cX("a",{id:this.target+"-cX-ConfiguratorValueFilter",href:"javascript:void(0)",innerHTML:f.T,name:g});r.opts=f.X?this[f.X]():f.O?f.O:[];r.opts.unshift("");this.addEvtListener(r,"click",this.addPropertyFilter,false);l.appendChild(r)}else{l.appendChild(document.createTextNode(f.T))}}q.appendChild(document.createTextNode(" "));q.appendChild(l);q.appendChild(document.createTextNode(" ]"))}}w.appendChild(q)};this.clickPropertyOptions=function(a){return function(b){if(!b){b=window.event}a.resetEditPropertyDescription();var c=a.$(a.target+"-cX-ConfiguratorOptions");if(c){c.style.display="block";c.style.left=b.layerX+"px";c.style.top=b.layerY+"px"}return false}}(this);this.closePropertyOptions=function(a){return function(b){if(!b){b=window.event}a.handleHideDiv(a.target+"-cX-ConfiguratorOptions")}}(this);this.resetPropertyOptions=function(a,e,b){if(!a){a=this.$(this.target+"-cX-ConfiguratorValueText")}if(!e){e=this.$(this.target+"-cX-ConfiguratorOptions")}if(a&&a.childNodes&&!b){while(a.childNodes.length>0){var f=a.childNodes[0];if(f.nodeName.toLowerCase()=="a"){this.removeEvtListener(f,"click",this.clickPropertyOptions,false)}a.removeChild(f)}}if(e){var d=this.$(this.target+"-cX-ConfiguratorOptionsContainer");if(d){while(d.childNodes.length>0){var f=d.childNodes[0];if(f.nodeName.toLowerCase()=="a"){this.removeEvtListener(f,"click",this.updatePropertyValue,false)}else{if(f.nodeName.toLowerCase()=="input"&&f.type=="checkbox"){this.removeEvtListener(f,"change",this.updatePropertyValue,false)}}d.removeChild(f)}e.removeChild(d)}e.style.display="none"}};this.addPropertyFilter=function(a){return function(d){if(!d){d=window.event}a.resetEditPropertyDescription();var b=d.target||d.srcElement;var c=a.$(a.target+"-cX-ConfiguratorFilter");a.addAllPropertyFilters(b.name,b.opts);c.style.display="block";c.opts=b.opts;c.style.left=d.layerX+"px";c.style.top=d.layerY+"px"}}(this);this.addAllPropertyFilters=function(c,d){var b=this.$(this.target+"-cX-ConfiguratorFilter");for(var a=0;a<this[c].length;a++){this.insertPropertyFilterRow(b,a,c,d)}this.insertPropertyFilterRow(b,this[c].length,c,d)};this.insertPropertyFilterRow=function(F,B,r,y){if(!F){F=this.$(this.target+"-cX-ConfiguratorFilter")}if(F){var e=this.configuratorWidth*0.25;var G=this.$cX("div",{id:this.target+"-cX-ConfiguratorFilterContainer"+B},{width:(this.configuratorWidth*1.05)+"px"});var q=this.$cX("select",{id:this.target+"-cX-ConfiguratorFilterSelect"+B,className:"CanvasXpressConfiguratorFilter",param:r,idx:B},{marginRight:"2px",marginLeft:"1px",width:e+"px"});if(!y){y=F.opts}y.sort();for(var A=0;A<y.length;A++){var d=this.$cX("option",{text:y[A],value:y[A]});try{q.add(d,null)}catch(E){q.add(d)}if(this[r][B]&&y[A]==this[r][B]){d.selected=true}}this.addEvtListener(q,"change",this.unsetPropertyFilterRow,false);var t=this.$cX("select",{id:this.target+"-cX-ConfiguratorFilterOp"+B,className:"CanvasXpressConfiguratorFilter",param:r,idx:B},{marginRight:"2px",width:e+"px"});var x=this.getOperators();for(var A=0;A<x.length;A++){var d=this.$cX("option",{text:x[A],value:x[A]});try{t.add(d,null)}catch(E){t.add(d)}if(this[r+"Op"][B]&&x[A]==this[r+"Op"][B]){d.selected=true}}this.addEvtListener(t,"change",this.unsetPropertyFilterRow,false);var I=this.$cX("img",{src:CanvasXpress.images.font},{width:"10px"});var H=this.$cX("input",{id:this.target+"-cX-ConfiguratorFilterCase"+B,type:"checkbox",param:r,idx:B,alt:"Check for case sensitive",title:"Check for case sensitive"},{width:"10px"});if(this[r+"Case"][B]){H.checked=true}this.addEvtListener(H,"change",this.unsetPropertyFilterRow,false);var n=this.$cX("input",{id:this.target+"-cX-ConfiguratorFilterValue"+B,param:r,idx:B,type:"text"},{width:e+"px"});if(this[r+"Value"][B]){n.value=this[r+"Value"][B]}this.addEvtListener(n,"change",this.unsetPropertyFilterRow,false);var u=this.$cX("img",{id:this.target+"-cX-ConfiguratorFilterMinus"+B,src:CanvasXpress.images.less,alt:"Remove Filter",title:"Remove Filter",param:r,idx:B},{padding:"9px 2px 2px 2px",cssFloat:"left",cursor:"default",width:"10px"});this.addEvtListener(u,"click",this.removePropertyFilterRow,false);var e=this.$cX("img",{id:this.target+"-cX-ConfiguratorFilterPlus"+B,src:CanvasXpress.images.more,alt:"Set Filter",title:"Set Filter",param:r,idx:B},{padding:"7px 2px 2px 2px",cssFloat:"right",cursor:"default",width:"10px"});this.addEvtListener(e,"click",this.addPropertyFilterRow,false);var D=this.$cX("img",{id:this.target+"-cX-ConfiguratorFilterCheck"+B,src:CanvasXpress.images.check,alt:"Filter added",title:"Filter added"},{padding:"7px 2px 2px 2px",cssFloat:"right",cursor:"default",width:"10px",display:this[r][B]?"block":"none"});var C=this.$cX("div",{id:this.target+"-cX-ConfiguratorFilterCheckEmpty"+B},{cssFloat:"right",cursor:"default",width:"10px",display:this[r][B]?"none":"block"});G.appendChild(u);G.appendChild(q);G.appendChild(t);G.appendChild(I);G.appendChild(H);G.appendChild(n);G.appendChild(C);G.appendChild(D);G.appendChild(e);F.appendChild(G)}};this.addPropertyFilterRow=function(a){return function(q){if(!q){q=window.event}var b=q.target||q.srcElement;var d=b.parentNode;var r=b.param;var l=b.idx;var t=a.$(a.target+"-cX-ConfiguratorValue");var n=a.$(a.target+"-cX-ConfiguratorFilterCheck"+l);var m=a.$(a.target+"-cX-ConfiguratorFilterCheckEmpty"+l);if(d&&r&&l!=null&&t&&n&&m){var j=d.childNodes[1].value;var f=d.childNodes[2].value;var s=d.childNodes[4].checked;var u=d.childNodes[5].value;if(j!=""&&((f!=""&&u!="")||f.match("null"))){if(a[r].length>0&&a[r][l]!=null){a[r][l]=j;a[r+"Op"][l]=f;a[r+"Value"][l]=u;a[r+"Case"][l]=s}else{a[r].push(j);a[r+"Op"].push(f);a[r+"Value"].push(u);a[r+"Case"].push(s);a.insertPropertyFilterRow(false,l+1,r)}t.value='["'+a[r].join('", "')+'"]';n.style.display="block";m.style.display="none"}}}}(this);this.removePropertyFilterRow=function(a){return function(k){if(!k){k=window.event}var d=k.target||k.srcElement;var j=d.parentNode;var h=j.parentNode;var l=d.param;var f=d.idx;var b=a.$(a.target+"-cX-ConfiguratorValue");if(j&&l&&f!=null&&b){a.resetFilters(l,f);a.resetPropertyFilter(true);a.addAllPropertyFilters(l,h.opts);b.value=a[l].length>0?'["'+a[l].join('", "')+'"]':"[]"}}}(this);this.unsetPropertyFilterRow=function(a){return function(m){if(!m){m=window.event}var p=[];var b=m.target||m.srcElement;var n=b.param;var f=b.idx;if(n&&f!=null){if(a[n].length>0&&a[n][f]){a[n][f]=false;a[n+"Op"][f]=false;a[n+"Value"][f]=false;a[n+"Case"][f]=false;for(var d=0;d<a[n].length;d++){if(d!=f){p.push(a[n][d])}}var l=a.$(a.target+"-cX-ConfiguratorFilterCheck"+f);var k=a.$(a.target+"-cX-ConfiguratorFilterCheckEmpty"+f);var o=a.$(a.target+"-cX-ConfiguratorValue");if(l&&k&&o){l.style.display="none";k.style.display="block";o.value=p.length>0?'["'+p.join('", "')+'"]':"[]"}}}}}(this);this.closePropertyFilter=function(a){return function(b){if(!b){b=window.event}a.handleHideDiv(a.target+"-cX-ConfiguratorFilter");a.resetPropertyFilter()}}(this);this.closePropertyExample=function(a){return function(b){if(!b){b=window.event}a.handleHideDiv(a.target+"-cX-ConfiguratorExample");a.resetPropertyExample()}}(this);this.resetPropertyFilter=function(a){var b=this.$(this.target+"-cX-ConfiguratorFilter");if(b){if(b&&b.childNodes){while(b.childNodes.length>3){var c=b.childNodes[3];this.removeEvtListener(c.childNodes[0],"click",this.removePropertyFilterRow,false);this.removeEvtListener(c.childNodes[1],"change",this.unsetPropertyFilterRow,false);this.removeEvtListener(c.childNodes[2],"change",this.unsetPropertyFilterRow,false);this.removeEvtListener(c.childNodes[4],"change",this.unsetPropertyFilterRow,false);this.removeEvtListener(c.childNodes[5],"change",this.unsetPropertyFilterRow,false);this.removeEvtListener(c.childNodes[8],"click",this.addPropertyFilterRow,false);b.removeChild(b.childNodes[3])}}if(!a){b.style.display="none"}}};this.resetPropertyExample=function(a){var b=this.$(this.target+"-cX-ConfiguratorExample");if(b){this.destroyInDOM(b.getElementsByTagName("canvas"));if(!a){b.style.display="none"}}};this.addPropertyColor=function(a){return function(j){if(!j){j=window.event}a.resetEditPropertyDescription();var d=a.$(a.target+"-cX-ConfiguratorColor");var t=a.$(a.target+"-cX-ConfiguratorValue");if(d&&t){var g=t.value?a.rgbToHex(a.validateColor(t.value.replace(/[\'\"]/g,""))):a.foreground;a.colorRGBfromString(g);var r=Math.round(a.colorHSV[0]/6*180);var q=Math.round((1-a.colorHSV[1])*100);var m=Math.round((1-a.colorHSV[2])*100);var l=a.$cX("div",{id:a.target+"-cX-ConfiguratorColorContainer"},{width:"210px",height:"101px",marginTop:"7px"});var b=a.$cX("div",{id:a.target+"-cX-ConfiguratorColorPalette",className:"CanvasXpressConfiguratorColorMain"},{position:"relative",left:"0px",top:"0px",width:"181px",height:"101px"});var o=a.$cX("div",{id:a.target+"-cX-ConfiguratorColorPaletteCurrent",className:"CanvasXpressConfiguratorColorExtra"},{position:"relative",left:(r-7)+"px",top:(q-7)+"px",width:"195px",height:"115px"});b.appendChild(o);var w=a.$cX("div",{id:a.target+"-cX-ConfiguratorColorSaturation",className:"CanvasXpressConfiguratorColor"},{position:"relative",left:"188px",width:"15px",height:"100px",border:"1px solid rgb(51,122,183)",cursor:"crosshair"});for(var f=0;f<100;f+=4){var u=a.$cX("div",false,{height:"4px",position:"relative",left:"0px",cursor:"crosshair"});w.appendChild(u)}var k=a.$cX("div",{id:a.target+"-cX-ConfiguratorColorSaturationCurrent",className:"CanvasXpressConfiguratorColorExtra"},{position:"relative",left:"0px",top:(m-108)+"px",width:"29px",height:"115px"});w.appendChild(k);l.appendChild(b);l.appendChild(w);d.appendChild(l);a.colorizeCurrentColorDiv();a.colorizeSaturationColorDiv();a.addEvtListener(b,"mousedown",a.registerPalette,false);a.addEvtListener(w,"mousedown",a.registerSaturation,false);d.style.display="block";d.style.left=j.layerX+"px";d.style.top=j.layerY+"px"}return false}}(this);this.registerPalette=function(a){return function(b){if(!b){b=window.event}a.changingColorOn="palette";if(a.colorHSV[2]==0){a.colorFromHsv(null,null,1);a.colorizeCurrentColorDiv();var c=a.$(a.target+"-cX-ConfiguratorColorSaturationCurrent");if(c){c.style.top="-108px"}}a.updateColorValue(b);a.colorizeSaturationColorDiv();return false}}(this);this.registerSaturation=function(a){return function(b){if(!b){b=window.event}a.changingColorOn="saturation";a.updateColorValue(b);return false}}(this);this.updateColorValue=function(g){if(this.changingColorOn){if(this.changingColorOn=="palette"){var f=this.$(this.target+"-cX-ConfiguratorColorPalette");var b=this.$(this.target+"-cX-ConfiguratorColorPaletteCurrent");if(f&&b){var d=this.adjustedCoordinates(g,f);if(d){var a=Math.min(Math.max(0,d.x),181);var j=Math.min(Math.max(0,d.y),101);b.style.left=(a-7)+"px";b.style.top=(j-7)+"px";this.colorFromHsv(a*6/180,1-j/100,null);this.colorizeCurrentColorDiv();this.colorizeSaturationColorDiv()}}}else{var c=this.$(this.target+"-cX-ConfiguratorColorSaturation");var h=this.$(this.target+"-cX-ConfiguratorColorSaturationCurrent");if(c&&h){var d=this.adjustedCoordinates(g,c);if(d){var j=Math.min(Math.max(0,d.y),101);h.style.top=(j-108)+"px";this.colorFromHsv(null,null,1-j/100);this.colorizeCurrentColorDiv()}}}}};this.colorizeCurrentColorDiv=function(){var f=this.$(this.target+"-cX-ConfiguratorColorCurrent");var a=this.$(this.target+"-cX-ConfiguratorValue");var d=this.$(this.target+"-cX-ConfiguratorValueHREF");if(f&&a&&d){var e=this.colorRGBToString();var b=this.hexToRgb("#"+e);f.style.backgroundColor="#"+e;f.innerHTML="&nbsp;&nbsp;"+b;f.style.color=this.complementaryColor(b,true);a.value='"'+b+'"';d.style.color="#"+e}};this.colorizeSaturationColorDiv=function(){var b=function(m,k,c,j,h){return"rgb("+(m*(1-j/h)*100)+"%,"+(k*(1-j/h)*100)+"%,"+(c*(1-j/h)*100)+"%)"};var e=this.$(this.target+"-cX-ConfiguratorColorSaturation");if(e&&this.colorHSV){var f=e.childNodes;var a=this.hsvFromRgb(this.colorHSV[0],this.colorHSV[1],1);if(a){for(var d=0;d<f.length-1;d++){f[d].style.backgroundColor=b(a[0],a[1],a[2],d,f.length-1)}}}};this.endColorChange=function(a){this.changingColorOn=false};this.closePropertyColor=function(a){return function(b){if(!b){b=window.event}a.handleHideDiv(a.target+"-cX-ConfiguratorColor");a.resetPropertyColor()}}(this);this.resetPropertyColor=function(){var c=this.$(this.target+"-cX-ConfiguratorColor");var b=this.$(this.target+"-cX-ConfiguratorColorPalette");var a=this.$(this.target+"-cX-ConfiguratorColorSaturation");if(c&&b&&a){if(c&&c.childNodes){while(c.childNodes.length>3){c.removeChild(c.childNodes[3])}this.removeEvtListener(b,"mousedown",this.registerPalette,false);this.removeEvtListener(a,"mousedown",this.registerSaturation,false)}c.style.display="none"}};this.updatePropertyValue=function(a){return function(h){if(!h){h=window.event}a.resetEditPropertyDescription();var f=a.$(a.target+"-cX-ConfiguratorValue");var j=a.$(a.target+"-cX-ConfiguratorOptions");var d=h.target||h.srcElement;if(d.nodeName.toLowerCase()=="input"){var b=[];for(var g=0;g<d.parentNode.childNodes.length;g++){var k=d.parentNode.childNodes[g];if(k.checked){b.push(k.value)}}f.value=b.length>0?'["'+b.join('", "')+'"]':"[]"}else{if(f&&j){if(d.innerHTML=="true"){f.value=d.innerHTML}else{if(d.innerHTML=="false"){f.value=d.innerHTML}else{if(d.innerHTML=="null"){f.value=d.innerHTML}else{f.value='"'+d.innerHTML+'"'}}}j.style.display="none"}}return false}}(this);this.clickApplyConfigurator=function(a){return function(b){return a.clickConfigurator(b,false,false,true)}}(this);this.clickConfigurator=function(a){return function(g,d,c,b){if(!g){g=window.event}if(!d){d=a.$(a.target+"-cX-ConfiguratorSugestions")}if(!c){c=a.$(a.target+"-cX-ConfiguratorValue")}if(d&&c){var f=a.getConfigurableObjectDoc(d.value);if(c.value){var h=a.parseJSON(c.value);if(f.T=="color"&&!a.validateColor(h)){alert('"'+h+'" is NOT a valid color');return false}}}a.updateClickConfigurator(g,d.value,c.value,b);return false}}(this);this.updateClickConfigurator=function(g,m,k,j){this.functionCaller="updateClickConfigurator";if(this.isTransition()){return}if(this.configuringNetwork){if(this.configuringNetwork<this.data.nodes.length){if(typeof(this[m])=="function"){this[m](this.data.nodes[this.configuringNetwork])}else{this.data.nodes[this.configuringNetwork][m]=this.parseJSON(k)}}else{if(typeof(this[m])=="function"){this[m](this.data.edges[this.configuringNetwork-this.data.nodes.length])}else{this.data.edges[this.configuringNetwork-this.data.nodes.length][m]=this.parseJSON(k)}}}else{if(this.configuringGenome){var b=this.subtracksInfo;if(!isNaN(this.configuringGenome)){this.data.tracks[b[this.configuringGenome].track].data[b[this.configuringGenome].index][m]=this.parseJSON(k)}else{if(this.configuringGenome.match(/:/)){var h=parseInt(this.configuringGenome.split(":")[1]);this.data.tracks[b[h].track].data[b[h].index][m]=this.parseJSON(k)}else{var h=parseInt(this.configuringGenome.replace("track-",""));this.data.tracks[h][m]=this.parseJSON(k)}}}else{if(typeof(this[m])=="function"){if(this[m].length>0&&k){var c=this.parseJSON(k);this[m](c)}else{this[m]()}this.resetConfigurator(g);return false}else{if(m=="summaryType"&&this.isGroupedData&&this[m]!=this.parseJSON(k)){var l=this.groupingFactors;this.ungroupSamples(true);this[m]=this.parseJSON(k);this.meta.config.user[m]=this[m];this.groupSamples(l,false,false,false,true)}else{this[m]=this.parseJSON(k);this.meta.config.user[m]=this[m]}}}}if(!j){this.resetConfigurator(g)}var d=m.match(/filter(.+)By/);if(d){this.reset();this.filterData()}this.resetPropertyExample();this.draw()};this.handleHideDiv=function(a){var b=this.$(a);if(b){b.style.display="none"}return false};this.resetOptionColorFiltersExamples=function(){this.resetPropertyOptions(false,false,true);this.resetPropertyColor();this.resetPropertyFilter();this.resetPropertyExample()};this.resetEditOptionColorFiltersExamples=function(){this.resetEditPropertyDescription();this.resetPropertyOptions(false,false,true);this.resetPropertyFilter();this.resetPropertyExample()};this.resetConfigurator=function(a){if(this.configuringOn&&this.configuringOn!="docked"){var b=this.$(this.target+"-cX-Configurator");this.resetEditOptionColorFiltersExamples();this.resetPropertyDescription();this.resetPropertySeeAlsoLinks();this.editingDescriptionOn=false;this.configuratorLastState=false;this.configuringOn=false;this.configuringNetwork=false;this.configuringGenome=false;this.addRemoveConfiguratorListeners("removeEvtListener");this.collapseGenie(a,b,false,function(){b.parentNode.removeChild(b)})}};this.setFunctionNames("initConfigurator")};CanvasXpress.prototype.initCodeInfo=function(){this.addInfoCodeDiv=function(){if(this.$(this.target+"-cX-Code")){return}var g=this.$cX("div",{id:this.target+"-cX-Code",className:"CanvasXpressCode draggable"},{left:"25px",top:"-"+(this.height-25)+"px",display:"none"});var h=this.$cX("img",{id:this.target+"-cX-CodeCloseImage",className:"CanvasXpressCode",src:CanvasXpress.images.cancel,alt:"Close Code",title:"Close Code"});var e=this.$cX("img",{id:this.target+"-cX-CodePrettyImage",className:"CanvasXpressCode",src:CanvasXpress.images.codeIndent,alt:"Pretty Code",title:"Pretty Code"});var d=this.$cX("img",{id:this.target+"-cX-CodeCompactImage",className:"CanvasXpressCode",src:CanvasXpress.images.codeCompact,alt:"Compact Code",title:"Compact Code"});var b=this.$cX("img",{id:this.target+"-cX-CodeParamsImage",className:"CanvasXpressCode",src:CanvasXpress.images.codeParams,alt:"Params Code",title:"Params Code"});var j=this.$cX("img",{id:this.target+"-cX-CodeSelectImage",className:"CanvasXpressCode",src:CanvasXpress.images.codeSelect,alt:"Select Code",title:"Select Code"});var f=this.$cX("div",{id:this.target+"-cX-CodeContainer",className:"CanvasXpressCodeContainer"});var a=this.$("north-wrapper-"+this.target);var k=this.$("south-wrapper-"+this.target);if(a){a.appendChild(f)}if(k){g.appendChild(h);g.appendChild(e);g.appendChild(d);g.appendChild(b);g.appendChild(j);g.appendChild(f);k.appendChild(g);this.addRemoveCodeListeners("addEvtListener")}};this.addRemoveCodeListeners=function(a){this.addRemoveEvtListener(a,this.$(this.target+"-cX-Code"),"mousedown",this.registerMousemove,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-CodeCloseImage"),"click",this.clickCode,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-CodePrettyImage"),"click",this.clickChangeCode,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-CodeCompactImage"),"click",this.clickChangeCode,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-CodeParamsImage"),"click",this.clickChangeCode,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-CodeSelectImage"),"click",this.clickSelectCode,false)};this.clickCode=function(a){return function(b){if(!b){b=window.event}a.hideCodeDiv(b);return false}}(this);this.clickChangeCode=function(a){return function(c){if(!c){c=window.event}var b=a.getTargetEvent(c);switch(b.id){case a.target+"-cX-CodePrettyImage":a.codeType="pretty";break;case a.target+"-cX-CodeCompactImage":a.codeType="compact";break;case a.target+"-cX-CodeParamsImage":a.codeType="params";break;default:break}a.updateCodeDiv();return false}}(this);this.clickSelectCode=function(a){return function(d){if(!d){d=window.event}var b;var c=a.$(a.target+"-cX-CodeContent");if(c){if(document.selection){b=document.body.createTextRange();b.moveToElementText(c);b.select()}else{if(window.getSelection()){b=document.createRange();b.selectNode(c);window.getSelection().removeAllRanges();window.getSelection().addRange(b)}}}return false}}(this);this.clearCodeDiv=function(){var b=this.$(this.target+"-cX-Code");var a=this.$(this.target+"-cX-CodeContent");if(b&&a){a.parentNode.removeChild(a);b.style.display="none"}};this.getDataJSON=function(b){var a={x:true,y:true,z:true,market:true,venn:true,nodes:true,edges:true,tracks:true,video:true};var d={sankey:true,tree:true,bubble:true};var f={};for(var c in this.data){if(a.hasOwnProperty(c)){f[c]=this.cloneObject(this.data[c],true)}}return b?this.prettyJSON(f,null,true):this.stringifyJSON(f)};this.getConfigJSON=function(a){return a?this.prettyJSON(this.getConfig(),null,true):this.stringifyJSON(this.getConfig())};this.getEventsJSON=function(a){var b=CanvasXpress.stack[this.target].events||false;return a?this.prettyJSON(b,null,true):this.stringifyJSON(b)};this.getCodeJSONJS=function(a){var f=this.getDataJSON(a);var g=this.getConfigJSON(a);var b=this.getEventsJSON(a);return'<span class=json-value>new</span> CanvasXpress(<span class=json-string>"canvas"</span>, '+f+", "+g+", "+b+");\n"};this.updateCodeDiv=function(i){var g=this.$(this.target+"-cX-Code");var b=this.$(this.target+"-cX-CodeContainer");var a=this.getDataJSON(this.codeType=="pretty");var f=this.codeType=="params"?"{\n  ...\n}":a;var j=this.getConfigJSON(this.codeType=="pretty"||this.codeType=="params");var e=this.getEventsJSON(true);if(g&&b){this.clearCodeDiv();var k=this.codeType=="compact"?"span":"pre";var d='<span class=json-value>new</span> CanvasXpress(<span class=json-string>"canvasID"</span>, '+f+", "+j+", "+e+")\n";b.appendChild(this.$cX(k,{id:this.target+"-cX-CodeContent",className:"CanvasXpressCodeContent",innerHTML:d}));g.style.display="block";if(i){g.style.zIndex=i}}};this.updateInfoDiv=function(a){var b=this.$(this.target+"-cX-Info");if(b&&a){b.innerHTML=a}};this.showDiv=function(a,b){var c=this.$(this.target+"-cX-"+a);if(c){c.style.opacity=0;c.style.display="block";this.expandGenie(b,c)}};this.hideDiv=function(b,c){var f=this.$(this.target+"-cX-"+b);var a=this;if(f){this.collapseGenie(c,f,false,function(){f.style.display="none"})}};this.showCodeDiv=function(a){this.updateCodeDiv();this.removeMenus();this.showDiv("Code",a)};this.showRCodeDiv=function(b){this.removeMenus();var d=this.$(this.target+"-cX-Code");var a=this.$(this.target+"-cX-CodeContainer");if(d&&a){this.clearCodeDiv();a.appendChild(this.$cX("pre",{id:this.target+"-cX-CodeContent",className:"CanvasXpressCodeContent",innerHTML:this.dataToR()}));this.$(this.target+"-cX-CodePrettyImage").style.display="none";this.$(this.target+"-cX-CodeCompactImage").style.display="none";this.$(this.target+"-cX-CodeParamsImage").style.display="none";this.showDiv("Code",b);if(this.graphType=="Map"){d.style.zIndex=1000}}};this.hideCodeDiv=function(a){this.$(this.target+"-cX-CodePrettyImage").style.display="block";this.$(this.target+"-cX-CodeCompactImage").style.display="block";this.$(this.target+"-cX-CodeParamsImage").style.display="block";if(this.graphType=="Map"){var b=this.$(this.target+"-cX-Code");delete b.style.zIndex}this.hideDiv("Code",a)};this.showInfoDiv=function(a){this.removeMenus();this.showDiv("Info",a)};this.hideInfoDiv=function(a){this.hideDiv("Info",a)};this.initializeCodeInfo=function(){this.addInfoCodeDiv()};this.setFunctionNames("initCodeInfo");this.initializeCodeInfo()};CanvasXpress.prototype.initBin=function(){this.addBinConfigurator=function(M,B){this.removeMenus();var z=this.target+"-"+M+"-cX-Bin";var f=this.range(this.data.y.data[M]);var E=(f[1]-f[0])/B;var w=this.getAxisDecimals(f[0])+1;this.binConfigurations[z]={};this.binConfigurations[z]["apply"]=false;this.binConfigurations[z]["n"]=B;this.binConfigurations[z]["vi"]=M;this.binConfigurations[z]["min"]=f[0];this.binConfigurations[z]["max"]=f[1];this.binConfigurations[z]["dec"]=w;this.binConfigurations[z]["name"]="Custom-"+this.data.y.vars[M]+"-Bin";this.binConfigurations[z]["bins"]=[];for(var H=0;H<B;H++){this.binConfigurations[z]["bins"][H]={name:"Bin-"+(H+1),value:Number(f[0]+((H+1)*E))}}var I=this.$cX("div",{id:z,className:"CanvasXpressBin draggable"},{left:"30px",top:-(this.height-30)+"px",display:"block"});var g=this.$cX("img",{id:z+"CloseImage",className:"CanvasXpressBin",src:CanvasXpress.images.cancel,alt:"Close Bin Configurator",title:"Close Bin Configurator"});var J=this.$cX("div",{id:z+"Container",className:"CanvasXpressBinContainer"});var C=this.$cX("input",{id:z+"Name",className:"CanvasXpressBin",type:"text",value:"Custom-"+this.data.y.vars[M]+"-Bin"},{width:"97%"});var A=this.$cX("div",{id:z+"NameSegmentContainer",className:"CanvasXpressBinNameContainer"});var y=this.$cX("table",{id:z+"NameSegment",className:"CanvasXpressBinTable"},{width:"100%"});var v=this.$cX("tbody");var G=this.$cX("th",{innerHTML:"Bin"},{textAlign:"center"});var F=this.$cX("th",{innerHTML:"Name"},{textAlign:"center"});var D=this.$cX("th",{innerHTML:"Max"},{textAlign:"center"});var o=this.$cX("tr");o.appendChild(G);o.appendChild(F);o.appendChild(D);v.appendChild(o);for(var H=0;H<B;H++){var G=this.$cX("td",{innerHTML:H+1},{width:(this.configuratorWidth*0.1)+"px",textAlign:"center",fontWeight:"bold"});var F=this.$cX("td");var D=this.$cX("td");var e=this.$cX("input",{id:z+"Name"+H,className:"CanvasXpressBin",type:"text",value:"Bin-"+(H+1)},{width:(this.configuratorWidth*0.65)+"px",textAlign:"center",fontWeight:"bold"});var h=this.$cX("input",{id:z+"Value"+H,className:"CanvasXpressBin",type:"text",value:this.formatNumber(f[0]+((H+1)*E),w)},{width:(this.configuratorWidth*0.25)+"px"});var o=this.$cX("tr");D.appendChild(h);F.appendChild(e);o.appendChild(G);o.appendChild(F);o.appendChild(D);v.appendChild(o)}y.appendChild(v);A.appendChild(y);var L=this.$cX("input",{id:z+"Apply",value:"Apply",type:"button"},{cssFloat:"left",borderRadius:"5px",top:"4px",position:"relative",width:"46%",padding:"3px",margin:"5px"});var K=this.$cX("input",{id:z+"Button",value:"Done",type:"button"},{cssFloat:"left",borderRadius:"5px",top:"4px",position:"relative",width:"46%",padding:"3px",margin:"5px"});var u=this.$("south-wrapper-"+this.target);if(u){J.appendChild(this.$cX("span",{className:"CanvasXpressBin",innerHTML:"Edit Name"}));J.appendChild(this.$cX("br"));J.appendChild(C);J.appendChild(this.$cX("br"));J.appendChild(this.$cX("br"));J.appendChild(this.$cX("span",{className:"CanvasXpressBin",innerHTML:"Edit Bin Name and Range"}));J.appendChild(this.$cX("br"));J.appendChild(A);J.appendChild(L);J.appendChild(K);J.appendChild(this.$cX("br"));I.appendChild(g);I.appendChild(J);u.appendChild(I);this.addRemoveBinListeners("addEvtListener",z)}};this.addRemoveBinListeners=function(b,d){var c=d?[d]:this.getKeys(this.binConfigurations);for(var a=0;a<c.length;a++){this.addRemoveEvtListener(b,this.$(c[a]),"mousedown",this.registerMousemove,false);this.addRemoveEvtListener(b,this.$(c[a]+"CloseImage"),"click",this.closeBinConfigurator,false);this.addRemoveEvtListener(b,this.$(c[a]+"Apply"),"click",this.applyBinConfigurator,false);this.addRemoveEvtListener(b,this.$(c[a]+"Button"),"click",this.doneBinConfigurator,false);if(b=="removeEvtListener"&&this.binConfigurations[c[a]]&&!this.binConfigurations[c[a]]["apply"]){delete (this.binConfigurations[c[a]])}}};this.closeBinConfigurator=function(a){return function(c){if(!c){c=window.event}var b=a.getTargetEvent(c);var f=b.id.replace("CloseImage","");var d=a.$(f);if(d){a.addRemoveBinListeners("removeEvtListener",f);d.parentNode.removeChild(d)}return false}}(this);this.validateBinning=function(a){var e=false;var h=this.$(a+"Name0").value;var m=this.$(a+"Value0").value;for(var k=1;k<this.binConfigurations[a]["n"];k++){var p=this.$(a+"Name"+k).value;var b=this.$(a+"Value"+k).value;if(h==""||h==null){e="Value for Bin "+k+" CANNOT be null";break}else{if(p==""||p==null){e="Value for Bin "+(k+1)+" CANNOT be null";break}else{if(m==""||m==null){e="Value for "+h+" ("+m+") CANNOT be null";break}else{if(b==""||b==null){e="Value for "+p+" ("+b+") CANNOT be null";break}else{if(isNaN(m)){e="Value for "+h+" ("+m+") is NOT a number";break}else{if(isNaN(b)){e="Value for "+p+" ("+b+") is NOT a number";break}else{if(m>b){e="Value for "+h+" ("+m+")CANNOT be greater that value for "+p+" ("+b+")";break}h=p;m=b}}}}}}}if(e){alert(e);return false}else{for(var k=0;k<this.binConfigurations[a]["n"];k++){var c=this.$(a+"Name"+k).value;var o=this.$(a+"Value"+k).value;this.binConfigurations[a]["bins"][k]={name:c,value:o}}var d=this.binConfigurations[a]["name"];var g=this.binConfigurations[a]["vi"];this.data.x[d]=[];for(var k=0;k<this.data.y.data[g].length;k++){var o=this.data.y.data[g][k];if(!isNaN(o)&&o!=""&&o!=null){for(var f=0;f<this.binConfigurations[a]["n"];f++){if(o<=this.binConfigurations[a]["bins"][f].value){this.data.x[d][k]=this.binConfigurations[a]["bins"][f].name;break}}}else{this.data.x[d][k]=""}}if(this.isGroupedData){this.ungroupSamples(true)}this.updateData(this.data);this.groupSamples([d]);this.sortSamplesByCategory([d]);this.binConfigurations[a]["apply"]=true;return true}};this.applyBinConfigurator=function(a){return function(c){if(!c){c=window.event}var b=a.getTargetEvent(c);var d=b.id.replace("Apply","");a.validateBinning(d)}}(this);this.doneBinConfigurator=function(a){return function(d){if(!d){d=window.event}var b=a.getTargetEvent(d);var g=b.id.replace("Button","");var c=a.validateBinning(g);var f=a.$(g);if(f&&c){a.addRemoveBinListeners("removeEvtListener",g);f.parentNode.removeChild(f)}return false}}(this);this.setFunctionNames("initBin")};CanvasXpress.prototype.initDataExplorer=function(){this.addDataExplorer=function(){var a=this.target+"-cX-DataExplorer";var m=this.$(a);if(m){return}var i=this.$cX("div",{id:this.target+"-cX-DataExplorer",className:"CanvasXpressBin draggable"},{left:"34px",top:"-"+(this.height-36)+"px",display:"block",opacity:0});var p=this.$cX("img",{id:this.target+"-cX-DataExplorerCloseImage",className:"CanvasXpressBin",src:CanvasXpress.images.cancel,alt:"Close Data Explorer",title:"Close Data Explorer"});var g=this.$cX("img",{id:this.target+"-cX-DataExplorerDataTableImage",className:"CanvasXpressBin",src:CanvasXpress.images.table,alt:"Show Data in Table",title:"Show Data in Table"});var n=this.$cX("img",{id:this.target+"-cX-DataExplorerDataFilterImage",className:"CanvasXpressBin",src:CanvasXpress.images.funnel,alt:"Filter Data",title:"Filter Data"});var h=this.$cX("img",{id:this.target+"-cX-DataExplorerCustomizeImage",className:"CanvasXpressBin",src:CanvasXpress.images.cog,alt:"Customize",title:"Customize",fun:"getConfigurationMenu",par:[],mid:this.newId("-cX-DataExplorer-Menu-")});var b=this.$cX("img",{id:this.target+"-cX-DataExplorerHelpImage",className:"CanvasXpressBin",src:CanvasXpress.images.info,alt:"Mouse over Headers\nin Data Explorer to\nLearn Functionality",title:"Mouse over Headers\nin Data Explorer to\nLearn Functionality"});var j=this.$cX("div",{id:this.target+"-cX-DataExplorerContainer",className:"CanvasXpressBinContainer"});var l=this.$("south-wrapper-"+this.target);if(l){i.appendChild(p);i.appendChild(g);i.appendChild(n);i.appendChild(h);i.appendChild(b);var s=this.loadDataExplorerTopPanel();j.appendChild(s);j.appendChild(this.$cX("hr",{className:"CanvasXpressDataExplorer"},{width:"241px"}));var e=this.$cX("span",{innerHTML:"Columns",title:"Columns in Data"},{postion:"abosulte",margin:"5px",floatCSS:"left",lineHeight:"32px",fontWeight:"bold"});j.appendChild(e);var k=this.data.x?this.$cX("img",{id:this.target+"-cX-DataExplorerMinimizeImage1",className:"CanvasXpressBin",src:CanvasXpress.images.collapse,srt:CanvasXpress.images.expand,title:"Collapse Variables and Sample Metadata"}):this.$cX("img",{id:this.target+"-cX-DataExplorerMinimizeImage1",className:"CanvasXpressBin",srt:CanvasXpress.images.collapse,src:CanvasXpress.images.expand,title:"Expand Variables and Sample Metadata"});j.appendChild(k);var q=this.loadDataExplorerMiddlePanel();j.appendChild(q);j.appendChild(this.$cX("hr",{className:"CanvasXpressDataExplorer"},{width:"241px"}));var r=this.$cX("span",{innerHTML:"Rows",title:"Rows in Data"},{postion:"abosulte",margin:"5px",floatCSS:"left",lineHeight:"32px",fontWeight:"bold"});j.appendChild(r);var f=this.data.z&&!this.data.x?this.$cX("img",{id:this.target+"-cX-DataExplorerMinimizeImage2",className:"CanvasXpressBin",src:CanvasXpress.images.collapse,srt:CanvasXpress.images.expand,title:"Collapse Samples and Variable Metadata"}):this.$cX("img",{id:this.target+"-cX-DataExplorerMinimizeImage2",className:"CanvasXpressBin",srt:CanvasXpress.images.collapse,src:CanvasXpress.images.expand,title:"Expand Samples and Variable Metadata"});j.appendChild(f);var o=this.loadDataExplorerBottomPanel();j.appendChild(o);i.appendChild(j);l.appendChild(i);this.addRemoveDataExplorerListeners("addEvtListener")}};this.loadDataExplorerTopPanel=function(){var j=this.loadFormatDataExplorerDiv();var e=this.loadLayoutDataExplorerDiv();var f=this.loadMetadataDataExplorerDiv();var a=this.loadPropertiesDataExplorerDiv();var k=this.loadOrientationDataExplorerDiv();var i=this.loadFileUploadDataExplorerDiv();var c=this.loadOverlaysDataExplorerDiv();var d=this.loadThemesDataExplorerDiv();var g=this.loadGraphTypesDataExplorerDiv();var h=this.loadAxesDataExplorerDiv();var b=this.$cX("div",{className:"CanvasXpressDataExplorerPanelOpen"});b.appendChild(j);b.appendChild(e);b.appendChild(f);b.appendChild(this.$cX("br"));b.appendChild(a);b.appendChild(k);b.appendChild(i);b.appendChild(c);b.appendChild(d);b.appendChild(this.$cX("br"));b.appendChild(g);b.appendChild(h);b.appendChild(this.$cX("br"));return b};this.loadDataExplorerMiddlePanel=function(){var b=this.loadVariablesDataExplorerDiv();var a=this.loadAnnotationsDataExplorerDiv();var c=this.$cX("div",{className:(this.data.x?"CanvasXpressDataExplorerPanelOpen":"CanvasXpressDataExplorerPanel")});c.appendChild(this.$cX("span",{className:"CanvasXpressBin",innerHTML:"Variables / Data Series"}));c.appendChild(this.$cX("img",{id:this.target+"-cX-DataExplorerSortVariables",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.ascending,asr:CanvasXpress.images.descending,params:["sortDataExplorer"],alt:"Sort Variables",title:"Sort Variables"},{border:"none",padding:0}));c.appendChild(b);c.appendChild(this.$cX("span",{className:"CanvasXpressBin",innerHTML:"Sample Metadata"}));c.appendChild(this.$cX("img",{id:this.target+"-cX-DataExplorerSortAnnotations",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.ascending,asr:CanvasXpress.images.descending,params:["sortDataExplorer"],alt:"Sort Sample Metadata",title:"Sort Sample Metadata"},{border:"none",padding:0}));c.appendChild(this.$cX("br"));c.appendChild(a);return c};this.loadDataExplorerBottomPanel=function(){var a=this.loadSamplesDataExplorerDiv();var c=this.loadDescriptionsDataExplorerDiv();var b=this.$cX("div",{className:(!this.data.x&&this.data.z?"CanvasXpressDataExplorerPanelOpen":"CanvasXpressDataExplorerPanel")});b.appendChild(this.$cX("span",{className:"CanvasXpressBin",innerHTML:"Samples"}));b.appendChild(this.$cX("img",{id:this.target+"-cX-DataExplorerSortSamples",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.ascending,asr:CanvasXpress.images.descending,params:["sortDataExplorer"],alt:"Sort Samples",title:"Sort Samples"},{border:"none",padding:0}));b.appendChild(a);b.appendChild(this.$cX("span",{className:"CanvasXpressBin",innerHTML:"Variable Metadata"}));b.appendChild(this.$cX("img",{id:this.target+"-cX-DataExplorerSortDescriptions",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.ascending,asr:CanvasXpress.images.descending,params:["sortDataExplorer"],alt:"Sort Variable Metadata",title:"Sort Variable Metadata"},{border:"none",padding:0}));b.appendChild(this.$cX("br"));b.appendChild(c);return b};this.loadFormatDataExplorerDiv=function(){var b=this.$cX("div",{id:this.target+"-cX-DataExplorerFormat",className:"CanvasXpressDataExplorer"},{width:"55px",height:"54px",textAlign:"center",cssFloat:"left"});var a=this.$cX("img",{id:this.target+"-cX-DataExplorerTranspose",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.transpose,params:["transpose"],alt:"Transpose data",title:"Transpose data"});b.appendChild(this.$cX("span",{className:"CanvasXpressBin",innerHTML:"Format",title:"Click in icons to reformat data",alt:"Click in icons to reformat data"},{width:"55px",cursor:"pointer"}));b.appendChild(this.$cX("hr",{className:"CanvasXpressDataExplorer"},{width:"61px"}));b.appendChild(a);return b};this.loadLayoutDataExplorerDiv=function(){var c=this.$cX("div",{id:this.target+"-cX-DataExplorerLayout",className:"CanvasXpressDataExplorer"},{width:"85px",height:"54px",textAlign:"center",cssFloat:"left"});var a=this.$cX("img",{id:this.target+"-cX-DataExplorerGroupSamples",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.group,params:["groupSamples"],alt:"Group Samples",title:"Group Samples"});var b=this.$cX("img",{id:this.target+"-cX-DataExplorerSegregate",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.segregate2,params:["segregate"],alt:"Segregate Data",title:"Segregate Data"});c.appendChild(this.$cX("span",{className:"CanvasXpressBin",innerHTML:"Layout",title:"Drag sample metadata to change layout",alt:"Drag sample metadata to change layout"},{width:"85px",cursor:"pointer"}));c.appendChild(this.$cX("hr",{className:"CanvasXpressDataExplorer"},{width:"92px"}));c.appendChild(a);c.appendChild(b);return c};this.loadMetadataDataExplorerDiv=function(){var a=this.$cX("div",{id:this.target+"-cX-DataExplorerMetadata",className:"CanvasXpressDataExplorer"},{width:"53px",height:"54px",textAlign:"center",cssFloat:"left"});var b=this.$cX("img",{id:this.target+"-cX-DataExplorerDOE",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.doe,params:["createDOE"],alt:"Explore Meta Data",title:"Explore Meta Data"});a.appendChild(this.$cX("span",{className:"CanvasXpressBin",innerHTML:"DOE",title:"Click in icon to explore meta data",alt:"Click in icon to explore meta data"},{width:"53px",cursor:"pointer"}));a.appendChild(this.$cX("hr",{className:"CanvasXpressDataExplorer"},{width:"59px"}));a.appendChild(b);return a};this.loadPropertiesDataExplorerDiv=function(){var g=this.$cX("div",{id:this.target+"-cX-DataExplorerProperties",className:"CanvasXpressDataExplorer"},{width:"76px",height:"135px",textAlign:"center",cssFloat:"left"});var d=this.$cX("img",{id:this.target+"-cX-DataExplorerColor",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.colors,params:["colorBy"],alt:"Color Data",title:"Color Data"});var f=this.$cX("img",{id:this.target+"-cX-DataExplorerShape",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.shapes,params:["shapeBy"],alt:"Shape Data",title:"Shape Data"});var b=this.$cX("img",{id:this.target+"-cX-DataExplorerSize",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.sizes,params:["sizeBy"],alt:"Size Data",title:"Size Data"});var c=this.$cX("img",{id:this.target+"-cX-DataExplorerPattern",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.patterns,params:["patternBy"],alt:"Pattern Data",title:"Pattern Data"});var a=this.$cX("img",{id:this.target+"-cX-DataExplorerConnect",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.connects,params:["connectBy"],alt:"Connect Data",title:"Connect Data"});var e=this.$cX("img",{id:this.target+"-cX-DataExplorerTreemapBy",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.treemapGraph,params:["treemapBy"],alt:"Treemap Data",title:"Treemap Data"});g.appendChild(this.$cX("span",{className:"CanvasXpressBin",innerHTML:"Properties",title:"Drag metadata to change propeties",alt:"Drag metadata to change properties"},{width:"76px",cursor:"pointer"}));g.appendChild(this.$cX("hr",{className:"CanvasXpressDataExplorer"},{width:"82px"}));g.appendChild(d);g.appendChild(f);g.appendChild(b);g.appendChild(c);g.appendChild(a);g.appendChild(e);return g};this.loadOrientationDataExplorerDiv=function(){var b=this.$cX("div",{id:this.target+"-cX-DataExplorerOrientation",className:"CanvasXpressDataExplorer"},{width:"76px",height:"54px",textAlign:"center",cssFloat:"left"});var a=this.$cX("img",{id:this.target+"-cX-DataExplorerVertical",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.graphOrientationVertical,params:["changeAttribute",["graphOrientation","vertical"]],alt:"Vertical Graph",title:"Vertical Graph"});var c=this.$cX("img",{id:this.target+"-cX-DataExplorerHorizontal",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.graphOrientationHorizontal,params:["changeAttribute",["graphOrientation","horizontal"]],alt:"Horizontal Graph",title:"Horizontal Graph"});b.appendChild(this.$cX("span",{className:"CanvasXpressBin",innerHTML:"Orientation",title:"Click icon to change graph orientation",alt:"Click icon to change graph orientation"},{width:"76px",cursor:"pointer"}));b.appendChild(this.$cX("hr",{className:"CanvasXpressDataExplorer"},{width:"82px"}));b.appendChild(a);b.appendChild(c);return b};this.loadFileUploadDataExplorerDiv=function(){var a=this.$cX("div",{id:this.target+"-cX-DataExplorerFileUpload",className:"CanvasXpressDataExplorer"},{width:"40px",height:"54px",textAlign:"center",cssFloat:"left"});var b=this.$cX("input",{id:this.target+"-cX-DataExplorerFileUploader",type:"file"},{display:"none"});var c=this.$cX("img",{id:this.target+"-cX-DataExplorerLoadFile",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.loadFile,params:["fileUpload"],title:"Click to upload a new file"});a.appendChild(this.$cX("span",{className:"CanvasXpressBin",innerHTML:"File",title:"Click icon to upload new data"},{width:"40px",cursor:"pointer"}));a.appendChild(this.$cX("hr",{className:"CanvasXpressDataExplorer"},{width:"46px"}));a.appendChild(c);a.appendChild(b);return a};this.loadOverlaysDataExplorerDiv=function(){var b=this.$cX("div",{id:this.target+"-cX-DataExplorerOverlays",className:"CanvasXpressDataExplorer"},{width:"51px",height:"67px",textAlign:"center",cssFloat:"none",position:"absolute",top:"169px",left:"93px"});var a=this.$cX("img",{id:this.target+"-cX-DataExplorerOverlay",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.overlays1D,params:["overlays"],alt:"Add Overlay",title:"Add Overlay"},{marginTop:"8px"});b.appendChild(this.$cX("span",{className:"CanvasXpressBin",innerHTML:"Overlays",title:"Drag Sample Annotations to add Overlays"},{width:"51px",cursor:"pointer",margin:"0"}));b.appendChild(this.$cX("hr",{className:"CanvasXpressDataExplorer"},{width:"58px"}));b.appendChild(a);return b};this.loadThemesDataExplorerDiv=function(){var b=this.$cX("div",{id:this.target+"-cX-DataExplorerThemes",className:"CanvasXpressDataExplorer"},{width:"65px",height:"67px",textAlign:"center",cssFloat:"none",position:"absolute",top:"169px",left:"158px"});var e=[CanvasXpress.images.iconCanvasXpress,CanvasXpress.images.iconExcel,CanvasXpress.images.iconGGPlot,CanvasXpress.images.iconGrey,CanvasXpress.images.iconPaulTol,CanvasXpress.images.iconSolarized,CanvasXpress.images.iconStata,CanvasXpress.images.iconTableau,CanvasXpress.images.iconTheEconomist,CanvasXpress.images.iconWallStreetJournal,CanvasXpress.images.canvasXpress];var g=["CanvasXpress","Excel","GGPlot","Gray","Paul Tol","Solarized","Stata","Tableau","The Economist","Wall Street Journal","None"];var j=["cx","excel","ggplot","igray","paulTol","solarized","stata","tableau","economist","wallStreetJournal","none"];var c=[];for(var d=0;d<e.length;d++){var h=this.$cX("img",{className:"CanvasXpressCarousel",src:e[d],title:g[d],theme:j[d]},{width:"24px",height:"24px",padding:"1px",margin:"4px 4px 0px 0px",background:"rgba(0,0,0,0)",border:"0 none",boxShadow:"0 0 10px rgba(0,0,0,0)"});c.push(h)}var k=this.createCarousel(c,28,28,64,4,"horizontal",{margin:"5px 14px 3px 16px"});var f=this.$cX("span",{className:"CanvasXpressCarousel",title:"Previous",innerHTML:"<",trgId:k.id},{top:"57px",left:"2px"});var a=this.$cX("span",{className:"CanvasXpressCarousel",title:"Next",innerHTML:">",trgId:k.id},{top:"57px",left:"58px"});b.appendChild(this.$cX("span",{className:"CanvasXpressBin",innerHTML:"Theme",title:"Click to change Graph Color Theme"},{width:"65px",cursor:"pointer"}));b.appendChild(this.$cX("hr",{className:"CanvasXpressDataExplorer"},{width:"72px"}));b.appendChild(k);b.appendChild(f);b.appendChild(a);return b};this.loadGraphTypesDataExplorerDiv=function(){var j=this.$cX("div",{id:this.target+"-cX-DataExplorerGraphs",className:"CanvasXpressDataExplorer"},{width:"152px",height:"177px",textAlign:"center",cssFloat:"left",marginBottom:"6px"});var b=this.$cX("img",{id:this.target+"-cX-DataExplorerArea",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.areaGraph,params:["changeAttribute",["graphType","Area"]],alt:"Area",title:"Area"});var k=this.$cX("img",{id:this.target+"-cX-DataExplorerBar",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.barGraph,params:["changeAttribute",["graphType","Bar"]],alt:"Bar",title:"Bar"});var l=this.$cX("img",{id:this.target+"-cX-DataExplorerBoxplot",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.boxPlot,params:["changeAttribute",["graphType","Boxplot"]],alt:"Boxplot",title:"Boxplot"});var p=this.$cX("img",{id:this.target+"-cX-DataExplorerCorrelation",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.correlation,params:["changeAttribute",["graphType","Correlation"]],alt:"Correlation",title:"Correlation"});var a=this.$cX("img",{id:this.target+"-cX-DataExplorerCircular",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.circularGraph,params:["changeAttribute",["graphType","Circular"]],alt:"Circular",title:"Circular"});var i=this.$cX("img",{id:this.target+"-cX-DataExplorerHeatmap",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.heatmapGraph,params:["changeAttribute",["graphType","Heatmap"]],alt:"Heatmap",title:"Heatmap"});var h=this.$cX("img",{id:this.target+"-cX-DataExplorerDotplot",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.dotPlot,params:["changeAttribute",["graphType","Dotplot"]],alt:"Dotplot",title:"Dotplot"});var o=this.$cX("img",{id:this.target+"-cX-DataExplorerLine",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.lineGraph,params:["changeAttribute",["graphType","Line"]],alt:"Line",title:"Line"});var g=this.$cX("img",{id:this.target+"-cX-DataExplorerPie",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.pieChart,params:["changeAttribute",["graphType","Pie"]],alt:"Pie Chart",title:"Pie Chart"});var f=this.$cX("img",{id:this.target+"-cX-DataExplorerScatter2D",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.scatter2D,params:["changeAttribute",["graphType","Scatter2D"]],alt:"Scatter 2D",title:"Scatter 2D"});var d=this.$cX("img",{id:this.target+"-cX-DataExplorerScatterBubble2D",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.scatter2DBubble,params:["changeAttribute",["graphType","ScatterBubble2D"]],alt:"Scatter Bubble 2D",title:"Scatter Bubble 2D"});var e=this.$cX("img",{id:this.target+"-cX-DataExplorerScatter3D",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.scatter3D,params:["changeAttribute",["graphType","Scatter3D"]],alt:"Scatter 3D",title:"Scatter 3D"});var q=this.$cX("img",{id:this.target+"-cX-DataExplorerStacked",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.stackedGraph,params:["changeAttribute",["graphType","Stacked"]],alt:"Stacked",title:"Stacked"});var m=this.$cX("img",{id:this.target+"-cX-DataExplorerStackedPercent",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.stackedPercentage,params:["changeAttribute",["graphType","StackedPercent"]],alt:"Stacked Percent",title:"Stacked Percent"});var c=this.$cX("img",{id:this.target+"-cX-DataExplorerTagCloud",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.wordCloud,params:["changeAttribute",["graphType","TagCloud"]],alt:"Tag Cloud",title:"Tag Cloud"});var n=this.$cX("img",{id:this.target+"-cX-DataExplorerTreemap",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.treemapGraph,params:["changeAttribute",["graphType","Treemap"]],alt:"Treemap",title:"Treemap"});j.appendChild(this.$cX("span",{id:this.target+"-cX-DataExplorerGraphTypes",className:"CanvasXpressBin",innerHTML:"Graph Types ...",title:"Click in icons to change graph type",alt:"Click in icons to change graph type",fun:"getGraphTypeMenu",par:[],mid:this.newId("-cX-DataExplorer-Menu-")},{width:"132px",cursor:"pointer"}));j.appendChild(this.$cX("hr",{className:"CanvasXpressDataExplorer"},{width:"158px"}));j.appendChild(b);j.appendChild(k);j.appendChild(l);j.appendChild(a);j.appendChild(p);j.appendChild(i);j.appendChild(h);j.appendChild(o);j.appendChild(g);j.appendChild(f);j.appendChild(d);j.appendChild(e);j.appendChild(q);j.appendChild(m);j.appendChild(c);j.appendChild(n);return j};this.loadAxesDataExplorerDiv=function(){var f=this.$cX("div",{id:this.target+"-cX-DataExplorerAxes",className:"CanvasXpressDataExplorer"},{width:"54px",height:"177px",textAlign:"center",cssFloat:"left",marginBottom:"6px"});var b=this.$cX("img",{id:this.target+"-cX-DataExplorerXAxis",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.axes2DPropertiesX,params:["addToAxis",["xAxis"]],alt:"X-Axis",title:"X-Axis"});var e=this.$cX("img",{id:this.target+"-cX-DataExplorerLinLogXAxis",className:"CanvasXpressDataExplorer2",src:(this.xAxisTransform&&this.xAxisTransform.match("log")?CanvasXpress.images.logLin:CanvasXpress.images.linLog),srt:(this.xAxisTransform&&this.xAxisTransform.match("log")?CanvasXpress.images.linLog:CanvasXpress.images.logLin),params:["linLog",["xAxis"]],alt:"X-Axis Lin / Log",title:"X-Axis Lin / Log"},{width:"9px",height:"24px"});var h=this.$cX("img",{id:this.target+"-cX-DataExplorerYAxis",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.axes2DPropertiesY,params:["addToAxis",["yAxis"]],alt:"Y-Axis",title:"Y-Axis"});var d=this.$cX("img",{id:this.target+"-cX-DataExplorerLinLogYAxis",className:"CanvasXpressDataExplorer2",src:(this.yAxisTransform&&this.yAxisTransform.match("log")?CanvasXpress.images.logLin:CanvasXpress.images.linLog),srt:(this.yAxisTransform&&this.yAxisTransform.match("log")?CanvasXpress.images.linLog:CanvasXpress.images.logLin),params:["linLog",["yAxis"]],alt:"Y-Axis Lin / Log",title:"Y-Axis Lin / Log"},{width:"9px",height:"24px"});var g=this.$cX("img",{id:this.target+"-cX-DataExplorerZAxis",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.axes3DPropertiesZ,params:["addToAxis",["zAxis"]],alt:"Z-Axis",title:"Z-Axis"});var c=this.$cX("img",{id:this.target+"-cX-DataExplorerLinLogZAxis",className:"CanvasXpressDataExplorer2",src:(this.zAxisTransform&&this.zAxisTransform.match("log")?CanvasXpress.images.logLin:CanvasXpress.images.linLog),srt:(this.zAxisTransform&&this.zAxisTransform.match("log")?CanvasXpress.images.linLog:CanvasXpress.images.logLin),params:["linLog",["zAxis"]],alt:"Z-Axis Lin / Log",title:"Z-Axis Lin / Log"},{width:"9px",height:"24px"});var a=this.$cX("img",{id:this.target+"-cX-DataExplorerMotion",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.motion,params:["motion"],alt:"Motion",title:"Motion"});f.appendChild(this.$cX("span",{className:"CanvasXpressBin",innerHTML:"Axes",title:"Drag Samples to assign to Axis",alt:"Drag Samples to assign to Axis"},{width:"54px",cursor:"pointer"}));f.appendChild(this.$cX("hr",{className:"CanvasXpressDataExplorer"},{width:"60px"}));f.appendChild(b);f.appendChild(e);f.appendChild(h);f.appendChild(d);f.appendChild(g);f.appendChild(c);f.appendChild(a);return f};this.updateDataExplorerContainerPopulation=function(b){var f=[];var d=b.firstChild;var a=0;for(var e=0;e<d.childNodes.length;e++){var g=d.childNodes[e];f.push([g.offsetLeft-b.offsetLeft,g.offsetTop-b.offsetTop,g.textContent]);if(g.offsetTop-b.offsetTop<b.clientHeight){a=e}}while(d.childNodes[a+1]){d.removeChild(d.childNodes[a+1])}if(f.length){d.style.height=(f[f.length-1][1]+31)+"px"}else{d.style.height=b.style.height}b.population=f};this.minimizeDataExplorerContainer=function(b){var f=[];b.style.visibility="hidden";document.body.appendChild(b);var d=b.firstChild;var a=0;for(var e=0;e<d.childNodes.length;e++){var g=d.childNodes[e];f.push([g.offsetLeft-b.offset