% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cancensus.R
\name{as_census_region_list}
\alias{as_census_region_list}
\title{Convert a (suitably filtered) data frame from
\code{\link{list_census_regions}} to a list suitable for passing to
\code{\link{get_census}}.}
\usage{
as_census_region_list(tbl)
}
\arguments{
\item{tbl}{A data frame, suitably filtered, as returned by
\code{\link{list_census_regions}}.}
}
\description{
Convert a (suitably filtered) data frame from
\code{\link{list_census_regions}} to a list suitable for passing to
\code{\link{get_census}}.
}
\examples{
\dontrun{
library(dplyr, warn.conflicts = FALSE)

# Query the CensusMapper API for the total occupied dwellings
# of 20 random Census Subdivisions, in Census 2016.
regions <- list_census_regions("CA16") \%>\%
  filter(level == "CSD") \%>\%
  sample_n(20) \%>\%
  as_census_region_list()

occupied <- get_census("CA16", regions = regions,
                            vectors = c("v_CA16_408"),
                            level = "Regions")
}
}
