% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vaccination.R
\name{get_subregion_vaccination_data}
\alias{get_subregion_vaccination_data}
\title{Get sub-region vaccination data}
\usage{
get_subregion_vaccination_data(
  dates = c("current", "recent", "all"),
  subregion_code = NULL
)
}
\arguments{
\item{dates}{One of "current", "recent", or "all" to specify the time frame
of the reports returned. If choosing "all" reports, must also provide one
or more sub-region codes.}

\item{subregion_code}{One or more sub-region codes. Returns all reports for
those sub-regions (even if \code{dates} is not "all")}
}
\value{
A data frame with one row per sub-region report.
}
\description{
Runs a GET request of sub-region vaccination data from the COVID-19 tracker
API, and returns parsed data.
The \code{dates} argument specifies the time frame of the data: "current"
(the default; latest report for each sub-region), "recent"
(15 most recent reports for each sub-region), and "all" (returns all reports
for one or more sub-regions specified by the \code{subregion_code} argument).
To get a list of available sub-regions, use the function \code{get_subregions()}.
}
\details{
Note that sub-region vaccination data is only for select provinces and
territories. Also the percentages reported differ between percent of total
population, and percent of eligible population.
See the API documentation for more details:
https://api.covid19tracker.ca/docs/1.0/vaccinations.
}
\examples{

get_subregion_vaccination_data()
get_subregion_vaccination_data("recent")
get_subregion_vaccination_data("all", subregion_code = c("ON382", "SK007"))
}
