% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_effects,commOccu-method}
\alias{plot_effects,commOccu-method}
\alias{plot_effects}
\title{Plot Marginal Effects of Covariates}
\usage{
\S4method{plot_effects}{commOccu}(
  object,
  mcmc.list,
  submodel = "state",
  draws = 1000,
  outdir,
  level = 0.95,
  keyword_squared = "_squared",
  ...
)
}
\arguments{
\item{object}{\code{commOccu} object}

\item{mcmc.list}{mcmc.list. Output of \code{\link{fit}} called on a \code{commOccu} object}

\item{submodel}{Submodel to get plots for. Can be "det" or "state"}

\item{draws}{Number of draws from the posterior to use when generating the plots. If fewer than draws are available, they are all used}

\item{outdir}{Directory to save plots to (optional)}

\item{level}{Probability mass to include in the uncertainty interval}

\item{keyword_squared}{character. A suffix in covariate names in the model that indicates a covariate is a quadratic effect of another covariate which does not carry the suffix in its name.}

\item{...}{additional arguments for \code{\link[ggplot2]{ggsave}}}
}
\value{
list of ggplot objects
}
\description{
Plot marginal effect plots (= response curves if covariates are continuous) for all species in a community (multi-species) occupancy model. Takes into account species-specific intercepts (if any). Currently only supports continuous covariates, not categorical covariates.
}
