## ----set-options, echo=FALSE, cache=FALSE-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
options(width = 300)

## ----include = FALSE--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
knitr::opts_chunk$set(
  fig.width = 7,
  collapse = TRUE,
  comment = "#>",
  message = FALSE,
  warning = FALSE
)

## ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
library(calmr)
fpfn <- data.frame(
  group = c("FP", "FN"),
  phase1 = c("100F>T>(US)/100T", "100F>T/100T>(US)"),
  r1 = c(TRUE, TRUE)
)
fpfn

## ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
pars <- get_parameters(fpfn, model = "ANCCR")
# increase learning rates
pars$alpha_reward <- 0.8
pars$alpha <- 0.08
# increase sampling interval to speed up the model
pars$sampling_interval <- 5
pars

## ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
experiment <- make_experiment(fpfn,
  parameters = pars,
  model = "ANCCR"
)
head(experiences(experiment)[[1]], 20)

## ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
experiment <- run_experiment(experiment)

## ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
# Action values
patch_plots(plot(experiment, type = "qs"))
# ANCCR
patch_plots(plot(experiment, type = "anccrs"))
# Dopamine transients
patch_plots(plot(experiment, type = "das"))

